/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.FloatParameterFilter;
import org.geowebcache.filter.ParameterFilter;
import org.geowebcache.filter.RegexParameterFilter;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.rest.seed.SeedRequest;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.Configuration;
import org.geowebcache.util.ConfigurationException;
import org.geowebcache.util.GeoWebCacheConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
implements Configuration,
ApplicationContextAware {
    private static Log log = LogFactory.getLog(XMLConfiguration.class);
    private static final String CONFIGURATION_FILE_NAME = "geowebcache.xml";
    private static final String[] CONFIGURATION_REL_PATHS = new String[]{"/WEB-INF/classes", "/../resources"};
    private WebApplicationContext context;
    private String absPath = null;
    private String relPath = null;
    private boolean mockConfiguration = false;
    private File configH = null;
    StorageBroker storageBroker = null;
    private GeoWebCacheConfiguration gwcConfig = null;

    public XMLConfiguration(StorageBroker storageBroker) {
        this.storageBroker = storageBroker;
    }

    public XMLConfiguration() {
    }

    public XMLConfiguration(InputStream is) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        XStream xs = XMLConfiguration.getConfiguredXStream(new XStream());
        this.gwcConfig = (GeoWebCacheConfiguration)xs.unmarshal((HierarchicalStreamReader)new DomReader((Element)this.checkAndTransform(docBuilder.parse(is))));
        LinkedList<TileLayer> layers = this.gwcConfig.layers;
        this.mockConfiguration = true;
        if (layers != null) {
            for (TileLayer layer : layers) {
                this.setDefaultValues(layer);
            }
        }
    }

    private File findConfFile() throws GeoWebCacheException {
        if (this.configH == null) {
            this.determineConfigDirH();
        }
        File xmlFile = null;
        if (this.configH == null) {
            throw new GeoWebCacheException("Unable to determine configuration directory.");
        }
        xmlFile = new File(this.configH.getAbsolutePath() + File.separator + CONFIGURATION_FILE_NAME);
        if (xmlFile == null) {
            throw new GeoWebCacheException("Found no configuration file in " + this.configH.getAbsolutePath() + " If you are running GWC in GeoServer this is probably not a problem.");
        }
        log.trace((Object)("Found configuration file in " + this.configH.getAbsolutePath()));
        return xmlFile;
    }

    @Override
    public List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        LinkedList<TileLayer> layers;
        if (!this.mockConfiguration && (this.gwcConfig == null || reload)) {
            File xmlFile = this.findConfFile();
            this.loadConfiguration(xmlFile);
        }
        if ((layers = this.gwcConfig.layers) != null) {
            for (TileLayer layer : layers) {
                this.setDefaultValues(layer);
            }
        }
        return layers;
    }

    private void setDefaultValues(TileLayer layer) {
        if (layer.isCacheBypassAllowed() == null) {
            if (this.gwcConfig.cacheBypassAllowed != null) {
                layer.isCacheBypassAllowed(this.gwcConfig.cacheBypassAllowed);
            } else {
                layer.isCacheBypassAllowed(false);
            }
        }
        if (layer.getBackendTimeout() == null) {
            if (this.gwcConfig.backendTimeout != null) {
                layer.setBackendTimeout(this.gwcConfig.backendTimeout);
            } else {
                layer.setBackendTimeout(120);
            }
        }
    }

    private void loadConfiguration(File xmlFile) throws GeoWebCacheException {
        Node rootNode = this.loadDocument(xmlFile);
        XStream xs = XMLConfiguration.getConfiguredXStream(new XStream());
        this.gwcConfig = (GeoWebCacheConfiguration)xs.unmarshal((HierarchicalStreamReader)new DomReader((Element)rootNode));
        this.gwcConfig.init();
    }

    private void writeConfiguration() throws GeoWebCacheException {
        File xmlFile = this.findConfFile();
        this.persistToFile(xmlFile);
    }

    public static XStream getConfiguredXStream(XStream xs) {
        xs.setMode(1001);
        xs.alias("gwcConfiguration", GeoWebCacheConfiguration.class);
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.aliasField("xmlns:xsi", GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xsi_noNamespaceSchemaLocation");
        xs.aliasField("xsi:noNamespaceSchemaLocation", GeoWebCacheConfiguration.class, "xsi_noNamespaceSchemaLocation");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns");
        xs.alias("layers", List.class);
        xs.alias("wmsLayer", WMSLayer.class);
        xs.alias("grids", new ArrayList().getClass());
        xs.alias("grid", Grid.class);
        xs.alias("mimeFormats", new ArrayList().getClass());
        xs.alias("srs", SRS.class);
        xs.alias("parameterFilters", new ArrayList().getClass());
        xs.alias("parameterFilter", ParameterFilter.class);
        xs.alias("seedRequest", SeedRequest.class);
        xs.alias("floatParameterFilter", FloatParameterFilter.class);
        xs.alias("regexParameterFilter", RegexParameterFilter.class);
        return xs;
    }

    protected void persistToFile(File xmlFile) throws GeoWebCacheException {
        XStream xs = XMLConfiguration.getConfiguredXStream(new XStream());
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new GeoWebCacheException(uee.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            throw new GeoWebCacheException(fnfe.getMessage());
        }
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xs.toXML((Object)this.gwcConfig, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GeoWebCacheException("Error writing to " + xmlFile.getAbsolutePath() + ": " + e.getMessage());
        }
        log.info((Object)("Wrote configuration to " + xmlFile.getAbsolutePath()));
    }

    public boolean modifyLayer(TileLayer tl) throws GeoWebCacheException {
        boolean response = this.gwcConfig.replaceLayer(tl);
        if (response) {
            this.writeConfiguration();
        }
        return response;
    }

    public boolean addLayer(TileLayer tl) throws GeoWebCacheException {
        boolean response = this.gwcConfig.addLayer(tl);
        if (response) {
            this.writeConfiguration();
        }
        return response;
    }

    public boolean deleteLayer(TileLayer layer) throws GeoWebCacheException {
        boolean response = this.gwcConfig.removeLayer(layer);
        if (response) {
            this.writeConfiguration();
        }
        return response;
    }

    private Node loadDocument(File xmlFile) throws ConfigurationException {
        Node topNode = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            topNode = this.checkAndTransform(docBuilder.parse(xmlFile));
        }
        catch (ParserConfigurationException pce) {
            log.error((Object)pce.getMessage());
            pce.printStackTrace();
        }
        catch (IOException ei) {
            throw new ConfigurationException("Error parsing file " + xmlFile.getAbsolutePath());
        }
        catch (SAXException saxe) {
            log.error((Object)saxe.getMessage());
        }
        if (topNode == null) {
            throw new ConfigurationException("Error parsing file " + xmlFile.getAbsolutePath() + ", top node came out as null");
        }
        return topNode;
    }

    private Node checkAndTransform(Document doc) throws ConfigurationException {
        Node rootNode = doc.getDocumentElement();
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.info((Object)"The configuration file is of the pre 1.0 type, trying to convert.");
            rootNode = this.applyTransform(rootNode, "geowebcache_pre10.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.0")) {
            log.info((Object)"Updating configuration from 1.0.0 to 1.0.1");
            rootNode = this.applyTransform(rootNode, "geowebcache_100.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.1")) {
            log.info((Object)"Updating configuration from 1.0.1 to 1.0.2");
            rootNode = this.applyTransform(rootNode, "geowebcache_101.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.2")) {
            log.info((Object)"Updating configuration from 1.0.2 to 1.1.0");
            rootNode = this.applyTransform(rootNode, "geowebcache_102.xsl").getFirstChild();
        }
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.error((Object)"Unable to parse file, expected gwcConfiguration at root after transform.");
            throw new ConfigurationException("Unable to parse after transform.");
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = XMLConfiguration.class.getResourceAsStream("geowebcache.xsd");
        try {
            Schema schema = factory.newSchema(new StreamSource(is));
            Validator validator = schema.newValidator();
            DOMSource domSrc = new DOMSource(rootNode);
            validator.validate(domSrc);
            log.info((Object)"Configuration file validated fine.");
        }
        catch (SAXException e) {
            log.info((Object)e.getMessage());
            log.info((Object)"Will try to use configuration anyway.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootNode;
    }

    private Node applyTransform(Node oldRootNode, String xslFilename) {
        DOMResult result = new DOMResult();
        InputStream is = XMLConfiguration.class.getResourceAsStream(xslFilename);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(is));
            transformer.transform(new DOMSource(oldRootNode), result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return result.getNode();
    }

    public void determineConfigDirH() {
        String baseDir = this.context.getServletContext().getRealPath("");
        if (this.absPath != null) {
            this.configH = new File(this.absPath);
        } else if (this.relPath != null) {
            this.configH = new File(baseDir + this.relPath);
            log.info((Object)("Configuration directory set to: " + this.configH.getAbsolutePath()));
        } else if (this.relPath == null) {
            File tmpPath = null;
            if (this.configH == null) {
                for (int i = 0; i < CONFIGURATION_REL_PATHS.length; ++i) {
                    this.relPath = CONFIGURATION_REL_PATHS[i];
                    if (File.separator.equals("\\")) {
                        this.relPath = this.relPath.replace("/", "\\");
                    }
                    if (!(tmpPath = new File(baseDir + this.relPath + File.separator + CONFIGURATION_FILE_NAME)).exists() || !tmpPath.canRead()) continue;
                    log.info((Object)("No configuration directory was specified, using " + tmpPath.getAbsolutePath()));
                    this.configH = new File(baseDir + this.relPath);
                }
            }
        }
        if (this.configH == null) {
            log.error((Object)"Failed to find geowebcache.xml");
        } else {
            log.info((Object)("Configuration directory set to: " + this.configH.getAbsolutePath()));
            if (!this.configH.exists() || !this.configH.canRead()) {
                log.error((Object)"Configuration file cannot be read or does not exist!");
            }
        }
    }

    @Override
    public String getIdentifier() throws GeoWebCacheException {
        if (this.mockConfiguration) {
            return "Mock configuration";
        }
        if (this.configH == null) {
            this.findConfFile();
        }
        if (this.configH != null) {
            return this.configH.getAbsolutePath();
        }
        return null;
    }

    public void setRelativePath(String relPath) {
        this.relPath = relPath;
    }

    public void setAbsolutePath(String absPath) {
        this.absPath = absPath;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.context = (WebApplicationContext)arg0;
    }

    public void debugPrint(Node node) {
        if (node == null) {
            System.out.println("1: No node");
            return;
        }
        System.out.println("1: " + node.getNodeName() + " " + node.getNamespaceURI());
        node = node.getFirstChild();
        if (node != null) {
            System.out.println("2: " + node.getNodeName() + " " + node.getNamespaceURI());
            node = node.getFirstChild();
        }
        if (node != null) {
            System.out.println("3: " + node.getNodeName() + " " + node.getNamespaceURI());
        }
    }
}

