/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.simple;

import com.noelios.restlet.ext.simple.SimplePipelineFactory;
import com.noelios.restlet.ext.simple.SimpleProtocolHandler;
import com.noelios.restlet.ext.simple.SimpleServerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import org.restlet.Server;
import org.restlet.data.Protocol;
import simple.http.PipelineFactory;
import simple.http.PipelineHandler;
import simple.http.PipelineHandlerFactory;
import simple.http.ProtocolHandler;
import simple.http.connect.ConnectionFactory;

public class HttpsServerHelper
extends SimpleServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public void start() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType());
        FileInputStream fis = this.getKeystorePath() == null ? null : new FileInputStream(this.getKeystorePath());
        char[] password = this.getKeystorePassword() == null ? null : this.getKeystorePassword().toCharArray();
        keyStore.load(fis, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.getCertAlgorithm());
        keyManagerFactory.init(keyStore, this.getKeyPassword().toCharArray());
        SSLContext sslContext = SSLContext.getInstance(this.getSslProtocol());
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        SSLServerSocket serverSocket = null;
        String addr = this.getServer().getAddress();
        if (addr != null) {
            InetAddress iaddr = InetAddress.getByName(addr);
            serverSocket = (SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(this.getServer().getPort(), 50, iaddr);
        } else {
            serverSocket = (SSLServerSocket)sslContext.getServerSocketFactory().createServerSocket(this.getServer().getPort());
        }
        serverSocket.setSoTimeout(60000);
        this.setSocket(serverSocket);
        fis.close();
        this.setConfidential(true);
        this.setHandler(PipelineHandlerFactory.getInstance((ProtocolHandler)new SimpleProtocolHandler(this), (int)this.getDefaultThreads(), (int)this.getMaxWaitTimeMs()));
        this.setConnection(ConnectionFactory.getConnection((PipelineHandler)this.getHandler(), (PipelineFactory)new SimplePipelineFactory()));
        this.getConnection().connect(this.getSocket());
        super.start();
    }

    public String getKeystorePath() {
        return this.getParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystorePassword() {
        return this.getParameters().getFirstValue("keystorePassword", "");
    }

    public String getKeystoreType() {
        return this.getParameters().getFirstValue("keystoreType", "JKS");
    }

    public String getKeyPassword() {
        return this.getParameters().getFirstValue("keyPassword", "");
    }

    public String getCertAlgorithm() {
        return this.getParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public String getSslProtocol() {
        return this.getParameters().getFirstValue("sslProtocol", "TLS");
    }
}

