/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.util.Utilities;
import org.opengis.feature.type.Name;

public class NameImpl
implements Name {
    protected String namespace;
    protected String local;

    public NameImpl(String local) {
        this(null, local);
    }

    public NameImpl(String namespace, String local) {
        this.namespace = namespace;
        this.local = local;
    }

    public boolean isGlobal() {
        return this.getNamespaceURI() == null;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public String getLocalPart() {
        return this.local;
    }

    public String getURI() {
        if (this.namespace == null && this.local == null) {
            return null;
        }
        if (this.namespace == null) {
            return this.local;
        }
        if (this.local == null) {
            return this.namespace;
        }
        return new StringBuffer(this.namespace).append(this.local).toString();
    }

    public int hashCode() {
        String uri = this.getURI();
        return uri != null ? uri.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NameImpl) {
            NameImpl other = (NameImpl)obj;
            if (!Utilities.equals((Object)this.namespace, (Object)other.namespace)) {
                return false;
            }
            return Utilities.equals((Object)this.local, (Object)other.local);
        }
        if (obj instanceof Name) {
            Name other = (Name)obj;
            return Utilities.equals((Object)this.getURI(), (Object)other.getURI());
        }
        return false;
    }

    public String toString() {
        return this.getURI();
    }
}

