/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.DelegatingActionUtils;

public class DelegatingTilesRequestProcessor
extends TilesRequestProcessor {
    private WebApplicationContext webApplicationContext;

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        super.init(actionServlet, moduleConfig);
        if (actionServlet != null) {
            this.webApplicationContext = this.initWebApplicationContext(actionServlet, moduleConfig);
        }
    }

    protected WebApplicationContext initWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) throws IllegalStateException {
        return DelegatingActionUtils.findRequiredWebApplicationContext(actionServlet, moduleConfig);
    }

    protected final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        Action action = this.getDelegateAction(mapping);
        if (action != null) {
            return action;
        }
        return super.processActionCreate(request, response, mapping);
    }

    protected Action getDelegateAction(ActionMapping mapping) throws BeansException {
        String beanName = this.determineActionBeanName(mapping);
        if (!this.getWebApplicationContext().containsBean(beanName)) {
            return null;
        }
        return (Action)this.getWebApplicationContext().getBean(beanName, Action.class);
    }

    protected String determineActionBeanName(ActionMapping mapping) {
        return DelegatingActionUtils.determineActionBeanName(mapping);
    }
}

