/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultFIDReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShapefileAttributeReader;
import org.geotools.data.shapefile.ShapefileFeatureLocking;
import org.geotools.data.shapefile.ShapefileFeatureSource;
import org.geotools.data.shapefile.ShapefileFeatureStore;
import org.geotools.data.shapefile.ShapefileFeatureWriter;
import org.geotools.data.shapefile.ShapefileFileResourceInfo;
import org.geotools.data.shapefile.ShapefileFileServiceInfo;
import org.geotools.data.shapefile.ShapefileURLResourceInfo;
import org.geotools.data.shapefile.ShapefileURLServiceInfo;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.prj.PrjFileReader;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.geotools.data.shapefile.shp.xml.ShpXmlFileReader;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.resources.Classes;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapefileDataStore
extends AbstractFileDataStore {
    public static final Charset DEFAULT_STRING_CHARSET = Charset.forName("ISO-8859-1");
    private static final Set HINTS = Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(Hints.FEATURE_DETACHED)));
    protected final ShpFiles shpFiles;
    protected URI namespace = null;
    protected SimpleFeatureType schema;
    protected boolean useMemoryMappedBuffer = true;
    protected Charset dbfCharset;
    private ServiceInfo info;
    private ResourceInfo resourceInfo;

    public ShapefileDataStore(URL url) throws MalformedURLException {
        this(url, false, DEFAULT_STRING_CHARSET);
    }

    public ShapefileDataStore(URL url, boolean useMemoryMappedBuffer) throws MalformedURLException {
        this(url, useMemoryMappedBuffer, DEFAULT_STRING_CHARSET);
    }

    public ShapefileDataStore(URL url, boolean useMemoryMappedBuffer, Charset dbfCharset) throws MalformedURLException {
        this(url, null, false, dbfCharset);
    }

    public ShapefileDataStore(URL url, URI namespace) throws MalformedURLException {
        this(url, namespace, false, DEFAULT_STRING_CHARSET);
    }

    public ShapefileDataStore(URL url, URI namespace, boolean useMemoryMapped, Charset dbfCharset) throws MalformedURLException {
        this.shpFiles = new ShpFiles(url);
        this.namespace = namespace;
        this.useMemoryMappedBuffer = !this.isLocal() || !this.shpFiles.exists(ShpFileType.SHP) ? false : useMemoryMapped;
        this.useMemoryMappedBuffer = useMemoryMapped;
        this.dbfCharset = dbfCharset;
    }

    public ShapefileDataStore(URL url, URI namespace, boolean useMemoryMapped) throws MalformedURLException {
        this(url, namespace, useMemoryMapped, DEFAULT_STRING_CHARSET);
    }

    @Override
    public synchronized ServiceInfo getInfo() {
        if (this.info == null) {
            this.info = this.isLocal() ? new ShapefileFileServiceInfo(this) : new ShapefileURLServiceInfo(this);
        }
        return this.info;
    }

    synchronized ResourceInfo getInfo(String typeName) {
        if (this.resourceInfo == null) {
            this.resourceInfo = this.isLocal() ? new ShapefileFileResourceInfo(this) : new ShapefileURLResourceInfo(this);
        }
        return this.resourceInfo;
    }

    public void setStringCharset(Charset stringCharset) {
        this.dbfCharset = stringCharset;
    }

    public Charset getStringCharset() {
        return this.dbfCharset;
    }

    @Override
    protected Map createMetadata(String typeName) {
        String urlString = this.shpFiles.get(ShpFileType.SHP_XML);
        if (urlString == null) {
            return Collections.EMPTY_MAP;
        }
        try {
            ShpXmlFileReader reader = new ShpXmlFileReader(this.shpFiles);
            HashMap<String, Metadata> map = new HashMap<String, Metadata>();
            map.put("shp.xml", reader.parse());
            return map;
        }
        catch (Throwable t) {
            LOGGER.warning("Could not parse " + urlString + ":" + t.getLocalizedMessage());
            return Collections.EMPTY_MAP;
        }
    }

    public boolean isLocal() {
        return this.shpFiles.isLocal();
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getFeatureReader();
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader() throws IOException {
        try {
            return this.createFeatureReader(this.getSchema().getTypeName(), this.getAttributesReader(true), this.schema);
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", se);
        }
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        String[] propertyNames = query.getPropertyNames();
        String defaultGeomName = this.schema.getGeometryDescriptor().getLocalName();
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        Filter filter = query.getFilter();
        filter.accept((FilterVisitor)extractor, null);
        String[] filterAttnames = extractor.getAttributeNames();
        if (propertyNames != null && propertyNames.length == 1 && propertyNames[0].equals(defaultGeomName) && (filterAttnames.length == 0 || filterAttnames.length == 1 && filterAttnames[0].equals(defaultGeomName))) {
            try {
                SimpleFeatureType newSchema = DataUtilities.createSubType(this.schema, propertyNames);
                return this.createFeatureReader(typeName, this.getAttributesReader(false), newSchema);
            }
            catch (SchemaException se) {
                throw new DataSourceException("Error creating schema", se);
            }
        }
        return super.getFeatureReader(typeName, query);
    }

    protected FIDFeatureReader createFeatureReader(String typeName, ShapefileAttributeReader reader, SimpleFeatureType readerSchema) throws SchemaException {
        return new FIDFeatureReader(reader, new DefaultFIDReader(typeName), readerSchema);
    }

    protected ShapefileAttributeReader getAttributesReader(boolean readDbf) throws IOException {
        ArrayList<AttributeDescriptor> atts;
        ArrayList<AttributeDescriptor> arrayList = atts = this.schema == null ? this.readAttributes() : this.schema.getAttributeDescriptors();
        if (!readDbf) {
            LOGGER.fine("The DBF file won't be opened since no attributes will be read from it");
            atts = new ArrayList<AttributeDescriptor>(1);
            atts.add((AttributeDescriptor)this.schema.getGeometryDescriptor());
            return new ShapefileAttributeReader(atts, this.openShapeReader(), null);
        }
        return new ShapefileAttributeReader(atts, this.openShapeReader(), this.openDbfReader());
    }

    protected ShapefileReader openShapeReader() throws IOException {
        try {
            return new ShapefileReader(this.shpFiles, true, this.useMemoryMappedBuffer);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", se);
        }
    }

    protected DbaseFileReader openDbfReader() throws IOException {
        if (this.shpFiles.get(ShpFileType.DBF) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.DBF)) {
            return null;
        }
        try {
            return new DbaseFileReader(this.shpFiles, this.useMemoryMappedBuffer, this.dbfCharset);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, this.useMemoryMappedBuffer);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected PrjFileReader openPrjReader() throws IOException, FactoryException {
        if (this.shpFiles.get(ShpFileType.PRJ) == null) {
            return null;
        }
        if (this.isLocal() && !this.shpFiles.exists(ShpFileType.PRJ)) {
            return null;
        }
        try {
            return new PrjFileReader(this.shpFiles);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String[] getTypeNames() {
        return new String[]{this.getCurrentTypeName()};
    }

    protected String createFeatureTypeName() {
        return this.shpFiles.getTypeName();
    }

    protected String getCurrentTypeName() {
        return this.schema == null ? this.createFeatureTypeName() : this.schema.getTypeName();
    }

    protected void typeCheck(String requested) throws IOException {
        if (!this.getCurrentTypeName().equals(requested)) {
            throw new IOException("No such type : " + requested);
        }
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        EmptyFeatureReader<SimpleFeatureType, SimpleFeature> featureReader;
        this.typeCheck(typeName);
        ShapefileAttributeReader attReader = this.getAttributesReader(true);
        try {
            SimpleFeatureType schema = this.getSchema();
            if (schema == null) {
                throw new IOException("To create a shapefile, you must first call createSchema()");
            }
            featureReader = this.createFeatureReader(typeName, attReader, schema);
        }
        catch (Exception e) {
            featureReader = new EmptyFeatureReader(this.schema);
        }
        return new ShapefileFeatureWriter(typeName, this.shpFiles, attReader, featureReader, this.dbfCharset);
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        this.typeCheck(typeName);
        return this.getSchema();
    }

    @Override
    public SimpleFeatureType getSchema() throws IOException {
        if (this.schema == null) {
            List<AttributeDescriptor> types = this.readAttributes();
            SimpleFeatureType parent = null;
            GeometryDescriptor geomDescriptor = (GeometryDescriptor)types.get(0);
            Class geomBinding = geomDescriptor.getType().getBinding();
            if (geomBinding == Point.class || geomBinding == MultiPoint.class) {
                parent = BasicFeatureTypes.POINT;
            } else if (geomBinding == Polygon.class || geomBinding == MultiPolygon.class) {
                parent = BasicFeatureTypes.POLYGON;
            } else if (geomBinding == LineString.class || geomBinding == MultiLineString.class) {
                parent = BasicFeatureTypes.LINE;
            }
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setDefaultGeometry(geomDescriptor.getLocalName());
            builder.addAll(types);
            builder.setName(this.createFeatureTypeName());
            if (this.namespace != null) {
                builder.setNamespaceURI(this.namespace);
            } else {
                builder.setNamespaceURI("http://www.opengis.net/gml");
            }
            builder.setAbstract(false);
            if (parent != null) {
                builder.setSuperType(parent);
            }
            this.schema = builder.buildFeatureType();
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AttributeDescriptor> readAttributes() throws IOException {
        ShapefileReader shp = this.openShapeReader();
        DbaseFileReader dbf = this.openDbfReader();
        CoordinateReferenceSystem crs = null;
        PrjFileReader prj = null;
        try {
            prj = this.openPrjReader();
            if (prj != null) {
                crs = prj.getCoodinateSystem();
            }
        }
        catch (FactoryException fe) {
            crs = null;
        }
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        try {
            Class geometryClass = JTSUtilities.findBestGeometryClass(shp.getHeader().getShapeType());
            build.setName(Classes.getShortName((Class)geometryClass));
            build.setNillable(true);
            build.setCRS(crs);
            build.setBinding(geometryClass);
            GeometryType geometryType = build.buildGeometryType();
            attributes.add((AttributeDescriptor)build.buildDescriptor("the_geom", geometryType));
            HashSet<String> usedNames = new HashSet<String>();
            usedNames.add("the_geom");
            if (dbf != null) {
                DbaseFileHeader header = dbf.getHeader();
                int ii = header.getNumFields();
                for (int i = 0; i < ii; ++i) {
                    Class attributeClass = header.getFieldClass(i);
                    String name = header.getFieldName(i);
                    if (usedNames.contains(name)) {
                        String origional = name;
                        int count = 1;
                        name = name + count;
                        while (usedNames.contains(name)) {
                            name = origional + ++count;
                        }
                    }
                    usedNames.add(name);
                    int length = header.getFieldLength(i);
                    build.setNillable(true);
                    build.setLength(length);
                    build.setBinding(attributeClass);
                    attributes.add(build.buildDescriptor(name));
                }
            }
            ArrayList<AttributeDescriptor> arrayList = attributes;
            return arrayList;
        }
        finally {
            try {
                if (prj != null) {
                    prj.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (dbf != null) {
                    dbf.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (shp != null) {
                    shp.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSchemaCRS(CoordinateReferenceSystem crs) throws IOException {
        if (crs == null) {
            throw new NullPointerException("CRS required for .prj file");
        }
        String s = crs.toWKT();
        s = s.replaceAll("\n", "").replaceAll("  ", "");
        StorageFile storageFile = this.shpFiles.getStorageFile(ShpFileType.PRJ);
        FileWriter out = new FileWriter(storageFile.getFile());
        try {
            out.write(s);
        }
        finally {
            out.close();
        }
        storageFile.replaceOriginal();
        this.schema = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ShapeType shapeType;
        if (!this.isLocal()) {
            throw new IOException("Cannot create FeatureType on remote shapefile");
        }
        this.shpFiles.delete();
        this.schema = featureType;
        CoordinateReferenceSystem cs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        Class geomType = featureType.getGeometryDescriptor().getType().getBinding();
        if (Point.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.POINT;
        } else if (MultiPoint.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.MULTIPOINT;
        } else if (LineString.class.isAssignableFrom(geomType) || MultiLineString.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.ARC;
        } else if (Polygon.class.isAssignableFrom(geomType) || MultiPolygon.class.isAssignableFrom(geomType)) {
            shapeType = ShapeType.POLYGON;
        } else {
            throw new DataSourceException("Cannot create a shapefile whose geometry type is " + geomType);
        }
        StorageFile shpStoragefile = this.shpFiles.getStorageFile(ShpFileType.SHP);
        StorageFile shxStoragefile = this.shpFiles.getStorageFile(ShpFileType.SHX);
        StorageFile dbfStoragefile = this.shpFiles.getStorageFile(ShpFileType.DBF);
        StorageFile prjStoragefile = this.shpFiles.getStorageFile(ShpFileType.PRJ);
        FileChannel shpChannel = shpStoragefile.getWriteChannel();
        FileChannel shxChannel = shxStoragefile.getWriteChannel();
        ShapefileWriter writer = new ShapefileWriter(shpChannel, shxChannel);
        try {
            ReferencedEnvelope transformedBounds;
            ReferencedEnvelope env = new ReferencedEnvelope(new Envelope(-179.0, 179.0, -89.0, 89.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (cs != null) {
                try {
                    transformedBounds = env.transform(cs, true);
                }
                catch (Exception e) {
                    cs = null;
                    transformedBounds = env;
                }
            } else {
                transformedBounds = env;
            }
            writer.writeHeaders(transformedBounds, shapeType, 0, 100);
        }
        finally {
            writer.close();
            assert (!shpChannel.isOpen());
            assert (!shxChannel.isOpen());
        }
        DbaseFileHeader dbfheader = ShapefileDataStore.createDbaseHeader(featureType);
        dbfheader.setNumRecords(0);
        FileChannel dbfChannel = dbfStoragefile.getWriteChannel();
        try {
            dbfheader.writeHeader(dbfChannel);
        }
        finally {
            dbfChannel.close();
        }
        if (cs != null) {
            String s = cs.toWKT();
            s = s.replaceAll("\n", "").replaceAll("  ", "");
            FileWriter prjWriter = new FileWriter(prjStoragefile.getFile());
            try {
                prjWriter.write(s);
            }
            finally {
                prjWriter.close();
            }
        } else {
            LOGGER.warning("PRJ file not generated for null CoordinateReferenceSystem");
        }
        StorageFile.replaceOriginals(shpStoragefile, shxStoragefile, dbfStoragefile, prjStoragefile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ReferencedEnvelope getBounds() throws DataSourceException {
        Envelope env;
        Channel in;
        block17: {
            in = null;
            ByteBuffer buffer = ByteBuffer.allocate(100);
            FileReader reader = new FileReader(){

                public String id() {
                    return "Shapefile Datastore's getBounds Method";
                }
            };
            in = this.shpFiles.getReadChannel(ShpFileType.SHP, reader);
            in.read(buffer);
            buffer.flip();
            ShapefileHeader header = new ShapefileHeader();
            header.read(buffer, true);
            ReferencedEnvelope bounds = new ReferencedEnvelope(this.schema.getCoordinateReferenceSystem());
            bounds.include(header.minX(), header.minY());
            bounds.include(header.minX(), header.minY());
            env = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
            if (this.schema == null) break block17;
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, this.schema.getCoordinateReferenceSystem());
            in.close();
            return referencedEnvelope;
        }
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(env, null);
        in.close();
        return referencedEnvelope;
        {
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new DataSourceException("Problem getting Bbox", ioe);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter().equals(Filter.INCLUDE)) {
            return this.getBounds();
        }
        return null;
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        SimpleFeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new ShapefileFeatureLocking(this, HINTS, featureType);
            }
            return new ShapefileFeatureStore(this, HINTS, featureType);
        }
        return new ShapefileFeatureSource(this, HINTS, featureType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            IndexFile file = this.openIndexFile();
            if (file != null) {
                try {
                    int n = file.getRecordCount();
                    return n;
                }
                finally {
                    file.close();
                }
            }
            ShapefileReader reader = this.openShapeReader();
            int count = -1;
            try {
                count = reader.getCount(count);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                reader.close();
            }
            return count;
        }
        return super.getCount(query);
    }

    protected static DbaseFileHeader createDbaseHeader(SimpleFeatureType featureType) throws IOException, DbaseFileException {
        DbaseFileHeader header = new DbaseFileHeader();
        int ii = featureType.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            AttributeDescriptor type = featureType.getDescriptor(i);
            Class colType = type.getType().getBinding();
            String colName = type.getLocalName();
            int fieldLen = FeatureTypes.getFieldLength(type);
            if (fieldLen == -1) {
                fieldLen = 255;
            }
            if (colType == Integer.class || colType == Short.class || colType == Byte.class) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 9), 0);
                continue;
            }
            if (colType == Long.class) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 19), 0);
                continue;
            }
            if (colType == BigInteger.class) {
                header.addColumn(colName, 'N', Math.min(fieldLen, 33), 0);
                continue;
            }
            if (Number.class.isAssignableFrom(colType)) {
                int l = Math.min(fieldLen, 33);
                int d = Math.max(l - 2, 0);
                header.addColumn(colName, 'N', l, d);
                continue;
            }
            if (Date.class.isAssignableFrom(colType)) {
                header.addColumn(colName, 'D', fieldLen, 0);
                continue;
            }
            if (colType == Boolean.class) {
                header.addColumn(colName, 'L', 1, 0);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(colType)) {
                header.addColumn(colName, 'C', Math.min(254, fieldLen), 0);
                continue;
            }
            if (Geometry.class.isAssignableFrom(colType)) continue;
            throw new IOException("Unable to write : " + colType.getName());
        }
        return header;
    }

    public String toString() {
        return "Shapefile datastore for :" + this.shpFiles.get(ShpFileType.SHP);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.shpFiles.dispose();
    }
}

