/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class CoverageStoreUtils {
    private static final Logger LOGGER = Logging.getLogger((String)CoverageStoreUtils.class.toString());
    public static final Format[] formats = GridFormatFinder.getFormatArray();

    private CoverageStoreUtils() {
    }

    public static Format acquireFormat(String type) throws IOException {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format = null;
        int length = formats.length;
        for (int i = 0; i < length; ++i) {
            if (!formats[i].getName().equals(type)) continue;
            format = formats[i];
            break;
        }
        if (format == null) {
            throw new IOException("Cannot handle format: " + type);
        }
        return format;
    }

    public static ParameterValue find(Format format, String key) {
        return CoverageStoreUtils.find(format.getReadParameters(), key);
    }

    public static ParameterValue find(ParameterValueGroup params, String key) {
        List list = params.values();
        for (ParameterValue val : list) {
            ParameterDescriptor descr = val.getDescriptor();
            if (!key.equalsIgnoreCase(descr.getName().toString())) continue;
            return val;
        }
        return null;
    }

    public static Format aquireFactoryByType(String type) {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format2 = null;
        for (Format format2 : formats) {
            if (!format2.getName().equals(type)) continue;
            return format2;
        }
        return null;
    }

    public static Format aquireFactory(String description) {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format2 = null;
        for (Format format2 : formats) {
            if (!format2.getDescription().equals(description)) continue;
            return format2;
        }
        return null;
    }

    public static List listDataFormatsDescriptions() {
        ArrayList<String> list = new ArrayList<String>();
        Format[] formats = GridFormatFinder.getFormatArray();
        int length = formats.length;
        for (int i = 0; i < length; ++i) {
            if (list.contains(formats[i].getDescription())) continue;
            list.add(formats[i].getDescription());
        }
        return Collections.synchronizedList(list);
    }

    public static List listDataFormats() {
        ArrayList<Format> list = new ArrayList<Format>();
        Format[] formats = GridFormatFinder.getFormatArray();
        int length = formats.length;
        for (int i = 0; i < length; ++i) {
            if (list.contains(formats[i])) continue;
            list.add(formats[i]);
        }
        return Collections.synchronizedList(list);
    }

    public static Map defaultParams(String description) {
        return Collections.synchronizedMap(CoverageStoreUtils.defaultParams(CoverageStoreUtils.aquireFactory(description)));
    }

    public static Map defaultParams(Format factory) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        ParameterValueGroup params = factory.getReadParameters();
        if (params != null) {
            List list = params.values();
            Iterator it = list.iterator();
            ParameterDescriptor descr = null;
            ParameterValue val = null;
            while (it.hasNext()) {
                val = (ParameterValue)it.next();
                descr = val.getDescriptor();
                String key = descr.getName().toString();
                Object value = null;
                if (val.getValue() != null) {
                    value = "values_palette".equalsIgnoreCase(key) ? val.getValue() : val.getValue().toString();
                }
                if (value == null) {
                    value = "";
                }
                if (value == null) continue;
                defaults.put(key, value);
            }
        }
        return Collections.synchronizedMap(defaults);
    }

    public static Map toParams(GridFormatFactorySpi factory, Map params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        ParameterValueGroup info = factory.createFormat().getReadParameters();
        for (String key : params.keySet()) {
            Object value = CoverageStoreUtils.find(info, key).getValue();
            if (value == null) continue;
            map.put(key, value);
        }
        return Collections.synchronizedMap(map);
    }

    public static GeneralEnvelope getWGS84LonLatEnvelope(GeneralEnvelope envelope) throws IndexOutOfBoundsException, FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
            return new GeneralEnvelope((Envelope)envelope);
        }
        DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        GeneralEnvelope targetEnvelope = !mathTransform.isIdentity() ? CRS.transform((MathTransform)mathTransform, (Envelope)envelope) : new GeneralEnvelope((Envelope)envelope);
        targetEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)targetCRS);
        return targetEnvelope;
    }
}

