/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

public class TypeRef {
    private final String dataStoreId;
    private final String typeName;

    public TypeRef(String dataStoreId, String typeName) {
        this.dataStoreId = dataStoreId;
        this.typeName = typeName;
    }

    public TypeRef(String typeRef) {
        int split = typeRef.indexOf(47);
        if (split == -1) {
            this.dataStoreId = null;
            this.typeName = typeRef;
        } else {
            this.dataStoreId = typeRef.substring(0, split);
            this.typeName = typeRef.substring(split + 1);
        }
    }

    static String parseDataStoreId(String typeRef) {
        int split = typeRef.indexOf(47);
        return split == -1 ? null : typeRef.substring(0, split);
    }

    static String parseTypeName(String typeRef) {
        int split = typeRef.indexOf(47);
        return split == -1 ? typeRef : typeRef.substring(split + 1);
    }

    static TypeRef parseTypeRef(String typeRef) {
        return new TypeRef(typeRef);
    }

    public String toString() {
        return this.dataStoreId + "/" + this.typeName;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

