/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Collections;
import java.util.List;
import org.geotools.filter.IllegalFilterException;
import org.geotools.resources.Utilities;
import org.geotools.styling.Font;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontImpl
implements Font,
Cloneable {
    private Expression fontFamily = null;
    private Expression fontSize = null;
    private Expression fontStyle = null;
    private Expression fontWeight = null;

    protected FontImpl() {
    }

    @Override
    public Expression getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public List<Expression> getFamily() {
        return Collections.singletonList(this.fontFamily);
    }

    @Override
    public void setFontFamily(Expression fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Override
    public Expression getFontSize() {
        return this.fontSize;
    }

    @Override
    public Expression getSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(Expression fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public Expression getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public Expression getStyle() {
        return this.fontStyle;
    }

    @Override
    public void setFontStyle(Expression fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Override
    public Expression getFontWeight() {
        return this.fontWeight;
    }

    @Override
    public Expression getWeight() {
        return this.fontWeight;
    }

    @Override
    public void setFontWeight(Expression fontWeight) {
        this.fontWeight = fontWeight;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should not happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fontFamily != null) {
            result = 1000003 * result + this.fontFamily.hashCode();
        }
        if (this.fontSize != null) {
            result = 1000003 * result + this.fontSize.hashCode();
        }
        if (this.fontStyle != null) {
            result = 1000003 * result + this.fontStyle.hashCode();
        }
        if (this.fontWeight != null) {
            result = 1000003 * result + this.fontWeight.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof FontImpl) {
            FontImpl other = (FontImpl)oth;
            return Utilities.equals((Object)this.fontFamily, (Object)other.fontFamily) && Utilities.equals((Object)this.fontSize, (Object)other.fontSize) && Utilities.equals((Object)this.fontStyle, (Object)other.fontStyle) && Utilities.equals((Object)this.fontWeight, (Object)other.fontWeight);
        }
        return false;
    }

    public static Font createDefault(FilterFactory filterFactory) {
        FontImpl font = new FontImpl();
        try {
            font.setFontSize((Expression)filterFactory.literal((Object)new Integer(10)));
            font.setFontStyle((Expression)filterFactory.literal((Object)"normal"));
            font.setFontWeight((Expression)filterFactory.literal((Object)"normal"));
            font.setFontFamily((Expression)filterFactory.literal((Object)"Serif"));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating default", ife);
        }
        return font;
    }
}

