/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.resources.Utilities;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.util.SimpleInternationalString;
import org.opengis.filter.Filter;
import org.opengis.style.Description;
import org.opengis.util.Cloneable;
import org.opengis.util.InternationalString;

public class RuleImpl
implements Rule,
Cloneable {
    private List<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
    private List<Graphic> graphics = new ArrayList<Graphic>();
    private String name;
    private String title;
    private String abstractStr;
    private Filter filter = null;
    private boolean hasElseFilter = false;
    private double maxScaleDenominator = Double.POSITIVE_INFINITY;
    private double minScaleDenominator = 0.0;

    protected RuleImpl() {
    }

    protected RuleImpl(Symbolizer[] symbolizers) {
        this.symbolizers.addAll(Arrays.asList(symbolizers));
    }

    public Graphic[] getLegendGraphic() {
        return this.graphics.toArray(new Graphic[0]);
    }

    public void addLegendGraphic(Graphic graphic) {
        this.graphics.add(graphic);
    }

    public void setLegendGraphic(Graphic[] graphics) {
        List<Graphic> graphicList = Arrays.asList(graphics);
        this.graphics.clear();
        this.graphics.addAll(graphicList);
    }

    public void addSymbolizer(Symbolizer symb) {
        this.symbolizers.add(symb);
    }

    public void setSymbolizers(Symbolizer[] syms) {
        List<Symbolizer> symbols = Arrays.asList(syms);
        this.symbolizers.clear();
        this.symbolizers.addAll(symbols);
    }

    public Symbolizer[] getSymbolizers() {
        return this.symbolizers.toArray(new Symbolizer[this.symbolizers.size()]);
    }

    public Description getDescription() {
        return new Description(){

            public InternationalString getAbstract() {
                return new SimpleInternationalString(RuleImpl.this.abstractStr);
            }

            public InternationalString getTitle() {
                return new SimpleInternationalString(RuleImpl.this.title);
            }

            public void accept(org.opengis.style.StyleVisitor visitor) {
                visitor.visit((Description)this, null);
            }
        };
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean hasElseFilter() {
        return this.hasElseFilter;
    }

    public void setIsElseFilter(boolean flag) {
        this.hasElseFilter = flag;
    }

    public void setHasElseFilter() {
        this.hasElseFilter = true;
    }

    public double getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    public void setMaxScaleDenominator(double maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
    }

    public double getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    public void setMinScaleDenominator(double minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            RuleImpl clone = (RuleImpl)super.clone();
            clone.graphics = new ArrayList<Graphic>();
            clone.symbolizers = new ArrayList<Symbolizer>();
            clone.filter = this.filter;
            Graphic[] legends = new Graphic[this.graphics.size()];
            for (int i = 0; i < legends.length; ++i) {
                Graphic legend = this.graphics.get(i);
                legends[i] = (Graphic)((Cloneable)legend).clone();
            }
            clone.setLegendGraphic(legends);
            Symbolizer[] symbArray = new Symbolizer[this.symbolizers.size()];
            for (int i = 0; i < symbArray.length; ++i) {
                Symbolizer symb = this.symbolizers.get(i);
                symbArray[i] = (Symbolizer)((Cloneable)symb).clone();
            }
            clone.setSymbolizers(symbArray);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        result = 1000003 * result + ((Object)this.symbolizers).hashCode();
        if (this.graphics != null) {
            result = 1000003 * result + ((Object)this.graphics).hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        if (this.abstractStr != null) {
            result = 1000003 * result + this.abstractStr.hashCode();
        }
        if (this.filter != null) {
            result = 1000003 * result + this.filter.hashCode();
        }
        result = 1000003 * result + (this.hasElseFilter ? 1 : 0);
        long temp = Double.doubleToLongBits(this.maxScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        temp = Double.doubleToLongBits(this.minScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof RuleImpl) {
            RuleImpl other = (RuleImpl)oth;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.title, (Object)other.title) && Utilities.equals((Object)this.abstractStr, (Object)other.abstractStr) && Utilities.equals((Object)this.filter, (Object)other.filter) && this.hasElseFilter == other.hasElseFilter && Utilities.equals(this.graphics, other.graphics) && Utilities.equals(this.symbolizers, other.symbolizers) && Double.doubleToLongBits(this.maxScaleDenominator) == Double.doubleToLongBits(other.maxScaleDenominator) && Double.doubleToLongBits(this.minScaleDenominator) == Double.doubleToLongBits(other.minScaleDenominator);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<RuleImpl");
        if (this.name != null) {
            buf.append(":");
            buf.append(this.name);
        }
        buf.append("> ");
        buf.append(this.filter);
        if (this.symbolizers != null) {
            buf.append("\n");
            for (Symbolizer symbolizer : this.symbolizers) {
                buf.append("\t");
                buf.append(symbolizer);
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

