/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis.fidmapper;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.opengis.feature.simple.SimpleFeature;
import org.postgresql.PGStatement;

public class OIDFidMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 3257569520561763632L;

    public void initSupportStructures() {
    }

    public String getID(Object[] attributes) {
        return attributes[0].toString();
    }

    public Object[] getPKAttributes(String FID) throws IOException {
        try {
            return new Object[]{new Long(Long.parseLong(FID))};
        }
        catch (NumberFormatException nfe) {
            return new Object[]{new Integer(-1)};
        }
    }

    public String createID(Connection conn, SimpleFeature feature, Statement statement) throws IOException {
        try {
            UnWrapper uw;
            if (!(statement instanceof PGStatement) && (uw = DataSourceFinder.getUnWrapper(statement)) != null) {
                statement = uw.unwrap(statement);
            }
            PGStatement pgStatement = (PGStatement)statement;
            return String.valueOf(pgStatement.getLastOID());
        }
        catch (SQLException e) {
            throw new DataSourceException("Problems occurred while getting last generate oid from Postgresql statement", e);
        }
        catch (ClassCastException e) {
            throw new DataSourceException("Statement is not a PGStatement. OIDFidMapper can be used only with Postgres!", e);
        }
    }

    public boolean returnFIDColumnsAsAttributes() {
        return false;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int colIndex) {
        return "oid";
    }

    public int getColumnType(int colIndex) {
        return 2;
    }

    public int getColumnSize(int colIndex) {
        return 8;
    }

    public int getColumnDecimalDigits(int colIndex) {
        return 0;
    }

    public boolean isAutoIncrement(int colIndex) {
        return true;
    }

    public boolean isValid(String fid) {
        try {
            Long.parseLong(fid, 10);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

