/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.validate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OffsetPointGenerator {
    private double offsetDistance;
    private Geometry g;
    private List offsetPts;

    public OffsetPointGenerator(Geometry g, double offsetDistance) {
        this.g = g;
        this.offsetDistance = offsetDistance;
    }

    public List getPoints() {
        this.offsetPts = new ArrayList();
        List lines = LinearComponentExtracter.getLines(this.g);
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            LineString line = (LineString)i.next();
            this.extractPoints(line);
        }
        return this.offsetPts;
    }

    private void extractPoints(LineString line) {
        Coordinate[] pts = line.getCoordinates();
        for (int i = 0; i < pts.length - 1; ++i) {
            this.computeOffsetPoints(pts[i], pts[i + 1]);
        }
    }

    private void computeOffsetPoints(Coordinate p0, Coordinate p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        double len = Math.sqrt(dx * dx + dy * dy);
        double ux = this.offsetDistance * dx / len;
        double uy = this.offsetDistance * dy / len;
        double midX = (p1.x + p0.x) / 2.0;
        double midY = (p1.y + p0.y) / 2.0;
        Coordinate offsetLeft = new Coordinate(midX - uy, midY + ux);
        Coordinate offsetRight = new Coordinate(midX + uy, midY - ux);
        this.offsetPts.add(offsetLeft);
        this.offsetPts.add(offsetRight);
    }
}

