/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import java.awt.Dimension;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.geotools.resources.Classes;

public class ImageDimension
extends Dimension {
    private static final long serialVersionUID = -4349573462196081362L;
    public int numBands;
    private final int dataType;

    public ImageDimension(RenderedImage image) {
        super(image.getWidth(), image.getHeight());
        SampleModel model = image.getSampleModel();
        this.numBands = model.getNumBands();
        this.dataType = model.getDataType();
    }

    public ImageDimension(Raster raster) {
        super(raster.getWidth(), raster.getHeight());
        this.numBands = raster.getNumBands();
        this.dataType = raster.getDataBuffer().getDataType();
    }

    public long getNumSampleValues() {
        return (long)this.width * (long)this.height * (long)this.numBands;
    }

    public long getMemoryUsage() {
        return this.getNumSampleValues() * (long)(DataBuffer.getDataTypeSize(this.dataType) / 8);
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object.getClass().equals(this.getClass())) {
            ImageDimension that = (ImageDimension)object;
            return this.numBands == that.numBands && this.dataType == that.dataType;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + 37 * this.numBands;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + "[width=" + this.width + ",height=" + this.height + ",numBands=" + this.numBands + ']';
    }
}

