/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.DescribeCoverageType;
import net.opengis.wcs11.DomainSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.GetCapabilitiesType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.GridCrsType;
import net.opengis.wcs11.OutputType;
import net.opengis.wcs11.RangeSubsetType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wcs.DefaultWebCoverageService;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService111;
import org.geoserver.wcs.kvp.GridCS;
import org.geoserver.wcs.kvp.GridType;
import org.geoserver.wcs.response.DescribeCoverageTransformer;
import org.geoserver.wcs.response.WCSCapsTransformer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.global.CoverageDimension;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.WCS;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

public class DefaultWebCoverageService111
implements WebCoverageService111 {
    Logger LOGGER = Logging.getLogger(DefaultWebCoverageService.class);
    private static final Hints HINTS = new Hints(new HashMap());
    private WCS wcs;
    private Data catalog;

    public DefaultWebCoverageService111(WCS wcs, Data catalog) {
        this.wcs = wcs;
        this.catalog = catalog;
    }

    public WCSInfo getServiceInfo() {
        return this.wcs.getInfo();
    }

    public WCSCapsTransformer getCapabilities(GetCapabilitiesType request) {
        String version;
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.1.0");
        provided.add("1.1.1");
        EList accepted = null;
        if (request.getAcceptVersions() != null) {
            accepted = request.getAcceptVersions().getVersion();
        }
        if ("1.1.0".equals(version = RequestUtils.getVersionOws11(provided, accepted)) || "1.1.1".equals(version)) {
            WCSCapsTransformer capsTransformer = new WCSCapsTransformer(this.wcs, this.catalog);
            capsTransformer.setEncoding(this.wcs.getCharSet());
            return capsTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    public DescribeCoverageTransformer describeCoverage(DescribeCoverageType request) {
        String version = request.getVersion();
        if ("1.1.0".equals(version) || "1.1.1".equals(version)) {
            DescribeCoverageTransformer describeTransformer = new DescribeCoverageTransformer(this.wcs, this.catalog);
            describeTransformer.setEncoding(this.wcs.getCharSet());
            return describeTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    public GridCoverage[] getCoverage(GetCoverageType request) {
        if (this.LOGGER.isLoggable(Level.FINEST)) {
            this.LOGGER.finest(new StringBuffer("execute CoverageRequest response. Called request is: ").append(request).toString());
        }
        CoverageInfo meta = null;
        GridCoverage2D coverage = null;
        try {
            GeneralEnvelope destinationEnvelopeInSourceCRS;
            GeneralEnvelope destinationEnvelope;
            meta = this.catalog.getCoverageInfo(request.getIdentifier().getValue());
            this.checkDomainSubset(meta, request.getDomainSubset());
            this.checkRangeSubset(meta, request.getRangeSubset());
            this.checkOutput(meta, request.getOutput());
            Format format = meta.getFormatInfo().getFormat();
            AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)meta.createReader(HINTS);
            ParameterValueGroup params = reader.getFormat().getReadParameters();
            GeneralEnvelope originalEnvelope = reader.getOriginalEnvelope();
            BoundingBoxType bbox = request.getDomainSubset().getBoundingBox();
            CoordinateReferenceSystem nativeCRS = originalEnvelope.getCoordinateReferenceSystem();
            if (bbox != null) {
                double[] lowerCorner = new double[bbox.getLowerCorner().size()];
                double[] upperCorner = new double[bbox.getUpperCorner().size()];
                for (int i = 0; i < lowerCorner.length; ++i) {
                    lowerCorner[i] = (Double)bbox.getLowerCorner().get(i);
                    upperCorner[i] = (Double)bbox.getUpperCorner().get(i);
                }
                destinationEnvelope = new GeneralEnvelope(lowerCorner, upperCorner);
                if (bbox.getCrs() == null) {
                    destinationEnvelope.setCoordinateReferenceSystem(nativeCRS);
                    destinationEnvelopeInSourceCRS = destinationEnvelope;
                } else {
                    CoordinateReferenceSystem bboxCRS = CRS.decode((String)bbox.getCrs());
                    destinationEnvelope.setCoordinateReferenceSystem(bboxCRS);
                    MathTransform bboxToNativeTx = CRS.findMathTransform((CoordinateReferenceSystem)bboxCRS, (CoordinateReferenceSystem)nativeCRS, (boolean)true);
                    destinationEnvelopeInSourceCRS = CRS.transform((MathTransform)bboxToNativeTx, (Envelope)destinationEnvelope);
                    destinationEnvelopeInSourceCRS.setCoordinateReferenceSystem(nativeCRS);
                }
            } else {
                destinationEnvelope = destinationEnvelopeInSourceCRS = reader.getOriginalEnvelope();
            }
            GridCrsType gridCRS = request.getOutput().getGridCRS();
            CoordinateReferenceSystem targetCRS = gridCRS == null ? reader.getOriginalEnvelope().getCoordinateReferenceSystem() : CRS.decode((String)gridCRS.getGridBaseCRS());
            MathTransform gridToCRS = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
            if (gridCRS != null) {
                Double[] origin = (Double[])gridCRS.getGridOrigin();
                Double[] offsets = (Double[])gridCRS.getGridOffsets();
                if (origin == null) {
                    origin = new Double[]{0.0, 0.0};
                }
                if (offsets == null) {
                    if (!(gridToCRS instanceof AffineTransform2D) && !(gridToCRS instanceof IdentityTransform)) {
                        throw new WcsException("Internal error, the coverage we're playing with does not have an affine transform...");
                    }
                    if (gridToCRS instanceof IdentityTransform) {
                        offsets = gridCRS.getGridType().equals((Object)GridType.GT2dSimpleGrid) ? new Double[]{1.0, 1.0} : new Double[]{1.0, 0.0, 0.0, 1.0};
                    } else {
                        AffineTransform2D affine = (AffineTransform2D)gridToCRS;
                        offsets = gridCRS.getGridType().equals((Object)GridType.GT2dSimpleGrid) ? new Double[]{affine.getScaleX(), affine.getScaleY()} : new Double[]{affine.getScaleX(), affine.getShearX(), affine.getShearY(), affine.getScaleY()};
                    }
                }
                AffineTransform tx = gridCRS.getGridType().equals(GridType.GT2dSimpleGrid.getXmlConstant()) ? new AffineTransform(offsets[0], 0.0, 0.0, offsets[1], origin[0], origin[1]) : new AffineTransform(offsets[0], offsets[2], offsets[1], offsets[3], origin[0], origin[1]);
                gridToCRS = new AffineTransform2D(tx);
            }
            Map parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)reader.getFormat().getReadParameters());
            GeneralEnvelope intersected = new GeneralEnvelope((Envelope)destinationEnvelopeInSourceCRS);
            intersected.intersect((Envelope)originalEnvelope);
            GridGeometry2D destinationGridGeometry = new GridGeometry2D(PixelInCell.CELL_CENTER, gridToCRS, (Envelope)intersected, null);
            parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), destinationGridGeometry);
            coverage = (GridCoverage2D)reader.read(CoverageUtils.getParameters((ParameterValueGroup)reader.getFormat().getReadParameters(), (Map)parameters, (boolean)true));
            if (coverage == null || !(coverage instanceof GridCoverage2D)) {
                throw new IOException("The requested coverage could not be found.");
            }
            GridCoverage2D bandSelectedCoverage = coverage;
            String interpolationType = null;
            if (request.getRangeSubset() != null) {
                if (request.getRangeSubset().getFieldSubset().size() > 1) {
                    throw new WcsException("Multi field coverages are not supported yet");
                }
                FieldSubsetType field = (FieldSubsetType)request.getRangeSubset().getFieldSubset().get(0);
                interpolationType = field.getInterpolationType();
                if (field.getAxisSubset().size() > 1) {
                    throw new WcsException("Multi axis coverages are not supported yet");
                }
                if (field.getAxisSubset().size() == 1) {
                    CoverageDimension[] dimensions = meta.getDimensions();
                    HashMap<String, Integer> dimensionMap = new HashMap<String, Integer>();
                    for (int i = 0; i < dimensions.length; ++i) {
                        String keyName = dimensions[i].getName().replace(' ', '_');
                        dimensionMap.put(keyName, i);
                    }
                    AxisSubsetType axisSubset = (AxisSubsetType)field.getAxisSubset().get(0);
                    EList keys = axisSubset.getKey();
                    int[] bands = new int[keys.size()];
                    for (int j = 0; j < bands.length; ++j) {
                        String key = (String)keys.get(j);
                        Integer index = (Integer)dimensionMap.get(key);
                        if (index == null) {
                            throw new WcsException("Unknown field/axis/key combination " + field.getIdentifier().getValue() + "/" + axisSubset.getIdentifier() + "/" + key);
                        }
                        bands[j] = index;
                    }
                    try {
                        bandSelectedCoverage = (GridCoverage2D)WCSUtils.bandSelect((GridCoverage)coverage, (int[])bands);
                    }
                    catch (WcsException e) {
                        throw new WcsException(e.getLocalizedMessage());
                    }
                }
            }
            Interpolation interpolation = Interpolation.getInstance((int)0);
            if (interpolationType != null) {
                if (interpolationType.equalsIgnoreCase("bilinear")) {
                    interpolation = Interpolation.getInstance((int)1);
                } else if (interpolationType.equalsIgnoreCase("bicubic")) {
                    interpolation = Interpolation.getInstance((int)2);
                } else if (interpolationType.equalsIgnoreCase("nearest")) {
                    interpolation = Interpolation.getInstance((int)0);
                }
            }
            GridCoverage2D croppedGridCoverage = WCSUtils.crop((Coverage)bandSelectedCoverage, (GeneralEnvelope)((GeneralEnvelope)coverage.getEnvelope()), (CoordinateReferenceSystem)nativeCRS, (GeneralEnvelope)destinationEnvelopeInSourceCRS, (Boolean)Boolean.TRUE);
            GridCoverage2D scaledCoverage = WCSUtils.scale((GridCoverage2D)croppedGridCoverage, (GridGeometry2D)destinationGridGeometry);
            GridCoverage2D reprojectedCoverage = WCSUtils.reproject((GridCoverage2D)scaledCoverage, (CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS, (Interpolation)interpolation);
            return new GridCoverage[]{reprojectedCoverage};
        }
        catch (Exception e) {
            if (e instanceof WcsException) {
                throw (WcsException)((Object)e);
            }
            throw new WcsException((Throwable)e);
        }
    }

    private void checkDomainSubset(CoverageInfo meta, DomainSubsetType domainSubset) throws Exception {
        BoundingBoxType bbox = domainSubset.getBoundingBox();
        if ("urn:ogc:def:crs:OGC:1.3:CRS84".equals(bbox.getCrs())) {
            bbox.setCrs("EPSG:4326");
        }
        CoordinateReferenceSystem bboxCRs = CRS.decode((String)bbox.getCrs());
        Envelope gridEnvelope = meta.getCoverage().getEnvelope();
        GeneralEnvelope gridEnvelopeBboxCRS = null;
        if (bboxCRs instanceof GeographicCRS) {
            try {
                CoordinateOperationFactory cof = CRS.getCoordinateOperationFactory((boolean)true);
                CoordinateOperation operation = cof.createOperation(gridEnvelope.getCoordinateReferenceSystem(), bboxCRs);
                gridEnvelopeBboxCRS = CRS.transform((CoordinateOperation)operation, (Envelope)gridEnvelope);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        List lower = bbox.getLowerCorner();
        List upper = bbox.getUpperCorner();
        for (int i = 0; i < lower.size(); ++i) {
            if (!((Double)lower.get(i) > (Double)upper.get(i))) continue;
            CoordinateSystemAxis axis = bboxCRs.getCoordinateSystem().getAxis(i);
            if (bboxCRs instanceof GeographicCRS && axis.getDirection() == AxisDirection.EAST) {
                if (gridEnvelopeBboxCRS != null) {
                    double envMax = gridEnvelopeBboxCRS.getMaximum(i);
                    if (envMax >= (Double)lower.get(i)) {
                        upper.set(i, (Double)upper.get(i) + (axis.getMaximumValue() - axis.getMinimumValue()));
                    } else {
                        lower.set(i, (Double)lower.get(i) - (axis.getMaximumValue() - axis.getMinimumValue()));
                    }
                } else {
                    upper.set(i, (Double)upper.get(i) + (axis.getMaximumValue() - axis.getMinimumValue()));
                }
            }
            if (!((Double)lower.get(i) > (Double)upper.get(i))) continue;
            throw new WcsException("illegal bbox, min of dimension " + (i + 1) + ": " + lower.get(i) + " is " + "greater than max of same dimension: " + upper.get(i), WcsException.WcsExceptionCode.InvalidParameterValue, "BoundingBox");
        }
    }

    private void checkOutput(CoverageInfo meta, OutputType output) {
        if (output == null) {
            return;
        }
        String format = output.getFormat();
        String declaredFormat = this.getDeclaredFormat(meta.getSupportedFormats(), format);
        if (declaredFormat == null) {
            throw new WcsException("format " + format + " is not supported for this coverage", WcsException.WcsExceptionCode.InvalidParameterValue, "format");
        }
        GridCrsType gridCRS = output.getGridCRS();
        if (gridCRS != null) {
            String gridBaseCrs = gridCRS.getGridBaseCRS();
            if (gridBaseCrs != null) {
                String actualCRS = null;
                String gridBaseCrsCode = this.extractCode(gridBaseCrs);
                for (String responseCRS : meta.getResponseCRSs()) {
                    String code = this.extractCode(responseCRS);
                    if (!code.equalsIgnoreCase(gridBaseCrsCode)) continue;
                    actualCRS = responseCRS;
                }
                if (actualCRS == null) {
                    throw new WcsException("CRS " + gridBaseCrs + " is not among the supported ones for coverage " + meta.getName(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridBaseCrs");
                }
                gridCRS.setGridBaseCRS(gridBaseCrs);
            } else {
                String code = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)meta.getCrs());
                gridCRS.setGridBaseCRS("urn:x-ogc:def:crs:EPSG:" + code);
            }
            String gridTypeValue = gridCRS.getGridType();
            GridType type = GridType.GT2dGridIn2dCrs;
            if (gridTypeValue != null) {
                type = null;
                for (GridType gt : GridType.values()) {
                    if (!gt.getXmlConstant().equalsIgnoreCase(gridTypeValue)) continue;
                    type = gt;
                }
                if (type == null) {
                    throw new WcsException("Unknown grid type " + gridTypeValue, WcsException.WcsExceptionCode.InvalidParameterValue, "GridType");
                }
                if (type == GridType.GT2dGridIn3dCrs) {
                    throw new WcsException("Unsupported grid type " + gridTypeValue, WcsException.WcsExceptionCode.InvalidParameterValue, "GridType");
                }
            }
            gridCRS.setGridType(type.getXmlConstant());
            String gridCS = gridCRS.getGridCS();
            if (gridCS != null && !gridCS.equalsIgnoreCase(GridCS.GCSGrid2dSquare.getXmlConstant())) {
                throw new WcsException("Unsupported grid cs " + gridCS, WcsException.WcsExceptionCode.InvalidParameterValue, "GridCS");
            }
            gridCRS.setGridCS(GridCS.GCSGrid2dSquare.getXmlConstant());
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)gridCRS.getGridBaseCRS());
            }
            catch (Exception e) {
                throw new WcsException("Could not understand crs " + gridCRS.getGridBaseCRS(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridBaseCRS");
            }
            if (!gridCRS.isSetGridOrigin() || gridCRS.getGridOrigin() == null) {
                Object[] origin = new Double[type.getOriginArrayLength()];
                Arrays.fill(origin, (Object)0.0);
                gridCRS.setGridOrigin((Object)origin);
            } else {
                Double[] gridOrigin = (Double[])gridCRS.getGridOrigin();
                if (gridOrigin.length != type.getOriginArrayLength()) {
                    throw new WcsException("Grid origin size (" + gridOrigin.length + ") inconsistent with grid type " + type.getXmlConstant() + " that requires (" + type.getOriginArrayLength() + ")", WcsException.WcsExceptionCode.InvalidParameterValue, "GridOrigin");
                }
                gridCRS.setGridOrigin((Object)gridOrigin);
            }
            Double[] gridOffsets = (Double[])gridCRS.getGridOffsets();
            if (gridOffsets != null) {
                if (type.getOffsetArrayLength() != gridOffsets.length) {
                    throw new WcsException("Invalid offsets lenght, grid type " + type.getXmlConstant() + " requires " + type.getOffsetArrayLength(), WcsException.WcsExceptionCode.InvalidParameterValue, "GridOffsets");
                }
            } else {
                gridCRS.setGridOffsets(null);
            }
        }
    }

    private String extractCode(String srsName) {
        if (srsName.startsWith("http://www.opengis.net/gml/srs/epsg.xml#")) {
            return srsName.substring(40);
        }
        if (srsName.startsWith("urn:")) {
            return srsName.substring(srsName.lastIndexOf(58) + 1);
        }
        if (srsName.startsWith("EPSG:")) {
            return srsName.substring(5);
        }
        return srsName;
    }

    private String getDeclaredFormat(List supportedFormats, String format) {
        for (String sf : supportedFormats) {
            if (sf.equalsIgnoreCase(format)) {
                return sf;
            }
            CoverageResponseDelegate delegate = CoverageResponseDelegateFactory.encoderFor((String)sf);
            if (delegate == null || !delegate.canProduce(format)) continue;
            return sf;
        }
        return null;
    }

    private void checkRangeSubset(CoverageInfo info, RangeSubsetType rangeSubset) {
        if (rangeSubset == null) {
            return;
        }
        if (rangeSubset.getFieldSubset().size() > 1) {
            throw new WcsException("Multi field coverages are not supported yet", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        FieldSubsetType field = (FieldSubsetType)rangeSubset.getFieldSubset().get(0);
        String fieldId = field.getIdentifier().getValue();
        if (!fieldId.equalsIgnoreCase("contents")) {
            throw new WcsException("Unknown field " + fieldId, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        String interpolation = field.getInterpolationType();
        if (interpolation != null) {
            boolean interpolationSupported = false;
            if (interpolation.equalsIgnoreCase("nearest")) {
                interpolation = "nearest neighbor";
            }
            for (String method : info.getInterpolationMethods()) {
                if (!interpolation.equalsIgnoreCase(method)) continue;
                interpolationSupported = true;
            }
            if (!interpolationSupported) {
                throw new WcsException("The requested Interpolation method is not supported by this Coverage.", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
        if (field.getAxisSubset().size() > 1) {
            throw new WcsException("Multi axis coverages are not supported yet", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        if (field.getAxisSubset().size() == 0) {
            return;
        }
        AxisSubsetType axisSubset = (AxisSubsetType)field.getAxisSubset().get(0);
        String axisId = axisSubset.getIdentifier();
        if (!axisId.equalsIgnoreCase("Bands")) {
            throw new WcsException("Unknown axis " + axisId + " in field " + fieldId, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
        }
        CoverageDimension[] dimensions = info.getDimensions();
        HashSet<String> dimensionMap = new HashSet<String>();
        for (int i = 0; i < dimensions.length; ++i) {
            String keyName = dimensions[i].getName().replace(' ', '_');
            dimensionMap.add(keyName);
        }
        EList keys = axisSubset.getKey();
        int[] bands = new int[keys.size()];
        for (int j = 0; j < bands.length; ++j) {
            String key = (String)keys.get(j);
            String parsedKey = null;
            for (String dimensionName : dimensionMap) {
                if (!dimensionName.equalsIgnoreCase(key)) continue;
                parsedKey = dimensionName;
                break;
            }
            if (parsedKey == null) {
                throw new WcsException("Unknown field/axis/key combination " + fieldId + "/" + axisSubset.getIdentifier() + "/" + key, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
            keys.set(j, parsedKey);
        }
    }

    static {
        HINTS.add((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        HINTS.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)OverviewPolicy.IGNORE));
    }
}

