/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.ContentType;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.util.HeaderReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Server;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.ReadableRepresentation;
import org.restlet.resource.Representation;
import org.restlet.service.ConnectorService;

public abstract class HttpServerCall
extends HttpCall {
    private boolean hostParsed;

    public HttpServerCall(Server server) {
        this(server.getLogger(), server.getAddress(), server.getPort());
    }

    public HttpServerCall(Logger logger, String serverAddress, int serverPort) {
        this.setLogger(logger);
        this.setServerAddress(serverAddress);
        this.setServerPort(serverPort);
        this.hostParsed = false;
    }

    public abstract ReadableByteChannel getRequestChannel();

    public abstract InputStream getRequestStream();

    public abstract WritableByteChannel getResponseChannel();

    public abstract OutputStream getResponseStream();

    public Representation getRequestEntity() {
        Representation result = null;
        InputStream requestStream = this.getRequestStream();
        ReadableByteChannel requestChannel = this.getRequestChannel();
        if (requestStream != null || requestChannel != null) {
            MediaType contentMediaType = null;
            long contentLength = -1L;
            result = requestStream != null ? new InputRepresentation(requestStream, contentMediaType, contentLength) : new ReadableRepresentation(requestChannel, contentMediaType, contentLength);
            for (Parameter header : this.getRequestHeaders()) {
                String value;
                HeaderReader hr;
                if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                    hr = new HeaderReader(header.getValue());
                    value = hr.readValue();
                    while (value != null) {
                        Encoding encoding = Encoding.valueOf(value);
                        if (!encoding.equals(Encoding.IDENTITY)) {
                            result.getEncodings().add(encoding);
                        }
                        value = hr.readValue();
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Language")) {
                    hr = new HeaderReader(header.getValue());
                    value = hr.readValue();
                    while (value != null) {
                        result.getLanguages().add(Language.valueOf(value));
                        value = hr.readValue();
                    }
                    continue;
                }
                if (header.getName().equalsIgnoreCase("Content-Type")) {
                    ContentType contentType = new ContentType(header.getValue());
                    result.setMediaType(contentType.getMediaType());
                    result.setCharacterSet(contentType.getCharacterSet());
                    continue;
                }
                if (!header.getName().equalsIgnoreCase("Content-Length")) continue;
                try {
                    contentLength = Long.parseLong(header.getValue());
                }
                catch (NumberFormatException e) {
                    contentLength = -1L;
                }
                result.setSize(contentLength);
            }
        }
        return result;
    }

    public String getHostDomain() {
        if (!this.hostParsed) {
            this.parseHost();
        }
        return super.getHostDomain();
    }

    public int getHostPort() {
        if (!this.hostParsed) {
            this.parseHost();
        }
        return super.getHostPort();
    }

    private void parseHost() {
        String host = this.getRequestHeaders().getFirstValue("Host", true);
        if (host != null) {
            int colonIndex = host.indexOf(58);
            if (colonIndex != -1) {
                super.setHostDomain(host.substring(0, colonIndex));
                super.setHostPort(Integer.valueOf(host.substring(colonIndex + 1)));
            } else {
                super.setHostDomain(host);
                super.setHostPort(this.getProtocol().getDefaultPort());
            }
        } else {
            this.getLogger().info("Couldn't find the mandatory \"Host\" HTTP header.");
        }
        this.hostParsed = true;
    }

    protected void readRequestHead(InputStream headStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        int next = headStream.read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request method. End of stream reached too early.");
        }
        this.setMethod(sb.toString());
        sb.delete(0, sb.length());
        next = headStream.read();
        while (next != -1 && !HttpUtils.isSpace(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the request URI. End of stream reached too early.");
        }
        this.setRequestUri(sb.toString());
        sb.delete(0, sb.length());
        next = headStream.read();
        while (next != -1 && !HttpUtils.isCarriageReturn(next)) {
            sb.append((char)next);
            next = headStream.read();
        }
        if (next == -1) {
            throw new IOException("Unable to parse the HTTP version. End of stream reached too early.");
        }
        next = headStream.read();
        if (HttpUtils.isLineFeed(next)) {
            this.setVersion(sb.toString());
            sb.delete(0, sb.length());
            Parameter header = HttpUtils.readHeader(headStream, sb);
            while (header != null) {
                this.getRequestHeaders().add(header);
                header = HttpUtils.readHeader(headStream, sb);
            }
        } else {
            throw new IOException("Unable to parse the HTTP version. The carriage return must be followed by a line feed.");
        }
    }

    public void sendResponse(Response response) throws IOException {
        if (response != null) {
            this.writeResponseHead(response);
            Representation entity = response.getEntity();
            if (!(entity == null || response.getRequest().getMethod().equals(Method.HEAD) || response.getStatus().equals(Status.SUCCESS_NO_CONTENT) || response.getStatus().equals(Status.SUCCESS_RESET_CONTENT))) {
                ConnectorService connectorService = this.getConnectorService(response.getRequest());
                if (connectorService != null) {
                    connectorService.beforeSend(entity);
                }
                this.writeResponseBody(entity);
                if (connectorService != null) {
                    connectorService.afterSend(entity);
                }
            }
            if (this.getResponseStream() != null) {
                try {
                    this.getResponseStream().flush();
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.FINE, "Exception while flushing and closing the entity stream.", ioe);
                }
            }
        }
    }

    public void writeResponseBody(Representation entity) throws IOException {
        if (this.getResponseChannel() != null) {
            entity.write(this.getResponseChannel());
        } else if (this.getResponseStream() != null) {
            entity.write(this.getResponseStream());
        }
    }

    public void writeResponseHead(Response response) throws IOException {
    }

    protected void writeResponseHead(OutputStream headStream) throws IOException {
        headStream.write(this.getVersion().getBytes());
        headStream.write(32);
        headStream.write(Integer.toString(this.getStatusCode()).getBytes());
        headStream.write(32);
        headStream.write(this.getReasonPhrase().getBytes());
        headStream.write(13);
        headStream.write(10);
        this.getResponseHeaders().set("Connection", "close", true);
        for (Parameter header : this.getResponseHeaders()) {
            HttpUtils.writeHeader(header, headStream);
        }
        headStream.write(13);
        headStream.write(10);
    }
}

