/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.method.AbstractMethodDefinitionSource;
import org.acegisecurity.intercept.method.MethodDefinitionSourceMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodDefinitionMap
extends AbstractMethodDefinitionSource {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$method$MethodDefinitionMap == null ? (class$org$acegisecurity$intercept$method$MethodDefinitionMap = MethodDefinitionMap.class$("org.acegisecurity.intercept.method.MethodDefinitionMap")) : class$org$acegisecurity$intercept$method$MethodDefinitionMap));
    protected Map methodMap = new HashMap();
    private Map nameMap = new HashMap();
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$MethodDefinitionMap;

    public void addSecureMethod(Method method, ConfigAttributeDefinition attr) {
        logger.info((Object)("Adding secure method [" + method + "] with attributes [" + attr + "]"));
        this.methodMap.put(method, attr);
    }

    public void addSecureMethod(String name, ConfigAttributeDefinition attr) {
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String className = name.substring(0, lastDotIndex);
        String methodName = name.substring(lastDotIndex + 1);
        try {
            Class<?> clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            this.addSecureMethod(clazz, methodName, attr);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class '" + className + "' not found");
        }
    }

    public void addSecureMethod(Class clazz, String mappedName, ConfigAttributeDefinition attr) {
        String name = clazz.getName() + '.' + mappedName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding secure method [" + name + "] with attributes [" + attr + "]"));
        }
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(mappedName) && !this.isMatch(methods[i].getName(), mappedName)) continue;
            matchingMethods.add(methods[i]);
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find method '" + mappedName + "' on " + clazz);
        }
        Iterator it = matchingMethods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            String regMethodName = (String)this.nameMap.get(method);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (regMethodName != null) {
                    logger.debug((Object)("Replacing attributes for secure method [" + method + "]: current name [" + name + "] is more specific than [" + regMethodName + "]"));
                }
                this.nameMap.put(method, name);
                this.addSecureMethod(method, attr);
                continue;
            }
            logger.debug((Object)("Keeping attributes for secure method [" + method + "]: current name [" + name + "] is not more specific than [" + regMethodName + "]"));
        }
    }

    public Iterator getConfigAttributeDefinitions() {
        return this.methodMap.values().iterator();
    }

    public int getMethodMapSize() {
        return this.methodMap.size();
    }

    private boolean isMatch(String methodName, String mappedName) {
        return mappedName.endsWith("*") && methodName.startsWith(mappedName.substring(0, mappedName.length() - 1)) || mappedName.startsWith("*") && methodName.endsWith(mappedName.substring(1, mappedName.length()));
    }

    protected ConfigAttributeDefinition lookupAttributes(Method method) {
        ConfigAttributeDefinition definition = new ConfigAttributeDefinition();
        ConfigAttributeDefinition directlyAssigned = (ConfigAttributeDefinition)this.methodMap.get(method);
        this.merge(definition, directlyAssigned);
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> clazz = interfaces[i];
            try {
                Method interfaceMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                ConfigAttributeDefinition interfaceAssigned = (ConfigAttributeDefinition)this.methodMap.get(interfaceMethod);
                this.merge(definition, interfaceAssigned);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (definition.size() == 0) {
            return null;
        }
        return definition;
    }

    private void merge(ConfigAttributeDefinition definition, ConfigAttributeDefinition toMerge) {
        if (toMerge == null) {
            return;
        }
        Iterator attribs = toMerge.getConfigAttributes();
        while (attribs.hasNext()) {
            definition.addConfigAttribute((ConfigAttribute)attribs.next());
        }
    }

    public void setMappings(List mappings) {
        Iterator it = mappings.iterator();
        while (it.hasNext()) {
            MethodDefinitionSourceMapping mapping = (MethodDefinitionSourceMapping)it.next();
            ConfigAttributeDefinition configDefinition = new ConfigAttributeDefinition();
            Iterator configAttributesIt = mapping.getConfigAttributes().iterator();
            while (configAttributesIt.hasNext()) {
                String s = (String)configAttributesIt.next();
                configDefinition.addConfigAttribute(new SecurityConfig(s));
            }
            this.addSecureMethod(mapping.getMethodName(), configDefinition);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

