/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.acegisecurity.util.SimpleMethodInvocation;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.Assert;

public class MethodInvocationUtils {
    public static MethodInvocation create(Object object, String methodName) {
        return MethodInvocationUtils.create(object, methodName, null);
    }

    public static MethodInvocation create(Object object, String methodName, Object[] args) {
        Assert.notNull((Object)object, (String)"Object required");
        Class[] classArgs = null;
        if (args != null) {
            ArrayList list = new ArrayList();
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i].getClass());
            }
            classArgs = list.toArray(new Class[0]);
        }
        return MethodInvocationUtils.createFromClass(object.getClass(), methodName, classArgs, args);
    }

    public static MethodInvocation createFromClass(Class clazz, String methodName) {
        return MethodInvocationUtils.createFromClass(clazz, methodName, null, null);
    }

    public static MethodInvocation createFromClass(Class clazz, String methodName, Class[] classArgs, Object[] args) {
        Method method;
        Assert.notNull((Object)clazz, (String)"Class required");
        Assert.hasText((String)methodName, (String)"MethodName required");
        try {
            method = clazz.getMethod(methodName, classArgs);
        }
        catch (Exception e) {
            return null;
        }
        return new SimpleMethodInvocation(method, args);
    }
}

