/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.graph.util.Queue;

public class PriorityQueue
implements Collection,
Queue {
    public static double RESIZE_FACTOR = 1.5;
    private Comparator m_comparator = null;
    private Object[] m_values = null;
    private int m_count = 0;
    private HashMap m_obj2index = null;

    public PriorityQueue(Comparator comparator) {
        this.m_comparator = comparator;
        this.m_obj2index = new HashMap();
    }

    public void init(int size) {
        if (this.m_values == null || size > this.m_values.length) {
            this.resize(size + 1, false);
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            this.m_values[i] = null;
        }
        this.m_count = 0;
    }

    public void insert(Object value) {
        ++this.m_count;
        if (this.m_count >= this.m_values.length) {
            this.resize((int)((double)this.m_values.length * RESIZE_FACTOR), true);
        }
        this.m_values[this.m_count] = value;
        this.m_obj2index.put(value, new Integer(this.m_count));
        this.moveUp(this.m_count);
    }

    public Object extract() {
        if (this.m_count == 0) {
            throw new NoSuchElementException("Heap empty.");
        }
        Object value = this.m_values[1];
        this.swap(1, this.m_count);
        this.m_values[this.m_count--] = null;
        this.moveDown(1);
        this.m_obj2index.remove(value);
        return value;
    }

    public Object getRoot() {
        if (this.m_count == 0) {
            throw new NoSuchElementException("Heap Empty.");
        }
        return this.m_values[1];
    }

    public void update() {
        int n = this.size() / 2;
        for (int i = 1; i <= n; ++i) {
            this.update(i);
        }
    }

    public int update(int i) {
        if (i > 1 && this.compare(i, i / 2) < 0) {
            return this.moveUp(i);
        }
        if (2 * i <= this.size() && this.compare(i, 2) > 0 || 2 * i + 1 <= this.size() && this.compare(i, 2 * i + 1) > 0) {
            return this.moveDown(i);
        }
        return i;
    }

    public void update(Object value) {
        Integer index = (Integer)this.m_obj2index.get(value);
        if (index == null) {
            for (int i = 1; i < this.m_count; ++i) {
                Object o = this.m_values[i];
                if (o != value) continue;
                System.out.println();
            }
        }
        this.update(index);
    }

    public boolean isEmpty() {
        return this.m_count == 0;
    }

    public int size() {
        return this.m_count;
    }

    private int moveDown(int n) {
        int minchild = 0;
        if (2 * n <= this.m_count) {
            minchild = 2 * n;
            if (2 * n + 1 <= this.m_count) {
                int n2 = minchild = this.compare(2 * n, 2 * n + 1) < 0 ? 2 * n : 2 * n + 1;
            }
            if (this.compare(minchild, n) < 0) {
                this.swap(minchild, n);
                return this.moveDown(minchild);
            }
        }
        return n;
    }

    private int moveUp(int n) {
        int parent;
        int n2 = parent = n % 2 == 0 ? n / 2 : (n - 1) / 2;
        if (parent > 0 && this.compare(n, parent) < 0) {
            this.swap(n, parent);
            return this.moveUp(parent);
        }
        return n;
    }

    private int compare(int i, int j) {
        return this.m_comparator.compare(this.m_values[i], this.m_values[j]);
    }

    private void resize(int size, boolean preserve) {
        Object[] resized = new Object[size];
        if (preserve) {
            for (int i = 0; i < this.m_values.length && i < size; ++i) {
                resized[i] = this.m_values[i];
            }
        }
        this.m_values = resized;
    }

    public void swap(int i, int j) {
        if (this.m_obj2index.get(this.m_values[i]) == null || this.m_obj2index.get(this.m_values[j]) == null) {
            System.out.println();
        }
        Object tmp = this.m_obj2index.get(this.m_values[i]);
        this.m_obj2index.put(this.m_values[i], this.m_obj2index.get(this.m_values[j]));
        this.m_obj2index.put(this.m_values[j], tmp);
        tmp = this.m_values[i];
        this.m_values[i] = this.m_values[j];
        this.m_values[j] = tmp;
    }

    public void clear() {
        this.init(0);
    }

    public Object[] toArray() {
        return this.m_values;
    }

    public boolean add(Object o) {
        this.insert(o);
        return true;
    }

    public Object get(int i) {
        if (i == 0 && i > this.m_count) {
            return null;
        }
        return this.m_values[i];
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.m_values.length; ++i) {
            if (!this.m_values[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object o) {
        for (int i = 1; i < this.m_values.length; ++i) {
            if (this.m_values[i] != o) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public void remove(int i) {
        if (i < this.m_count) {
            this.swap(i, this.m_count);
            this.m_values[this.m_count--] = null;
            this.update(i);
        } else {
            this.m_values[this.m_count--] = null;
        }
    }

    public boolean addAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("Heap#removeAll(Collection) not supported");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("Heap#retainAll(Collection) not supported");
    }

    public Iterator iterator() {
        return new Iterator(){
            int i = 1;

            public void remove() {
                throw new UnsupportedOperationException("Iterator#remove() not supported");
            }

            public boolean hasNext() {
                return this.i < PriorityQueue.this.m_values.length;
            }

            public Object next() {
                return PriorityQueue.this.m_values[this.i++];
            }
        };
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.m_values.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.m_values.length);
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            a[i] = this.m_values[i];
        }
        if (a.length > this.m_values.length) {
            a[this.m_values.length] = null;
        }
        return a;
    }

    public Object deq() {
        return this.extract();
    }

    public void enq(Object object) {
        this.insert(object);
    }
}

