/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.OutputStream;
import simple.http.MonitoredOutputStream;
import simple.http.OutputMonitor;

class ChunkedOutputStream
extends MonitoredOutputStream {
    private byte[] size = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 13, 10};
    private byte[] index = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private byte[] zero = new byte[]{48, 13, 10, 13, 10};

    public ChunkedOutputStream(OutputStream out, OutputMonitor mon) {
        super(out, mon);
    }

    protected void writeBytes(byte[] buf, int off, int len) throws IOException {
        int pos = 7;
        if (len > 0) {
            int num = len;
            while (num > 0) {
                this.size[pos--] = this.index[num & 0xF];
                num >>>= 4;
            }
            this.out.write(this.size, pos + 1, 9 - pos);
            this.out.write(buf, off, len);
            this.out.write(this.size, 8, 2);
        }
    }

    protected void flushBytes() throws IOException {
        this.out.flush();
    }

    protected void doClose() throws IOException {
        this.out.write(this.zero);
        this.mon.notifyFinished(this.out);
    }
}

