/*
 * Decompiled with CFR 0.152.
 */
package simple.util.lease;

import simple.util.lease.Contract;
import simple.util.lease.Monitor;
import simple.util.lease.ReactiveQueue;

final class LeaseScheduler
extends Thread {
    private ReactiveQueue queue = new ReactiveQueue();
    private Monitor monitor;
    private Contract pending;

    public LeaseScheduler(Monitor monitor) {
        this.monitor = monitor;
        this.start();
    }

    public synchronized void update(Contract lease) {
        if (lease.equals(this.pending)) {
            this.pending = lease;
        }
        this.interrupt(lease);
        this.process(lease);
    }

    private synchronized void process(Contract lease) {
        long wait = lease.getExpiry();
        long minus = -1L * wait;
        this.queue.add(lease, minus);
    }

    private synchronized void interrupt(Contract lease) {
        long expiry = lease.getExpiry();
        if (this.pending != null && expiry < this.pending.getExpiry()) {
            this.interrupt();
        }
        if (this.queue.length() == 0) {
            this.interrupt();
        }
    }

    private synchronized void wait(Contract lease) {
        long expiry = lease.getExpiry();
        try {
            if (expiry > 0L) {
                this.pending(lease);
                this.wait(expiry);
            }
            this.monitor.expire(lease);
        }
        catch (InterruptedException e) {
            this.process(this.pending);
        }
    }

    private synchronized void pending(Contract lease) {
        this.pending = lease;
    }

    public synchronized void run() {
        while (true) {
            Contract lease = (Contract)this.dequeue();
            try {
                this.wait(lease);
            }
            catch (Exception exception) {
            }
        }
    }

    private synchronized Object dequeue() {
        while (this.queue.length() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.queue.remove();
    }
}

