/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.service.ConnectorService;
import org.restlet.service.ConverterService;
import org.restlet.service.DecoderService;
import org.restlet.service.MetadataService;
import org.restlet.service.StatusService;
import org.restlet.service.TunnelService;
import org.restlet.util.Engine;
import org.restlet.util.Helper;

public abstract class Application
extends Restlet {
    public static final String KEY = "org.restlet.application";
    private String name;
    private String description;
    private String author;
    private String owner;
    private Restlet root;
    private ConnectorService connectorService;
    private ConverterService converterService;
    private DecoderService decoderService;
    private MetadataService metadataService;
    private StatusService statusService;
    private TunnelService tunnelService;
    private Helper helper;

    public Application() {
        this(null);
    }

    public Application(Context parentContext) {
        super(null);
        if (Engine.getInstance() != null) {
            this.helper = Engine.getInstance().createHelper(this, parentContext);
            String applicationName = this.getName() == null ? Integer.toString(this.hashCode()) : this.getName();
            String loggerName = Application.class.getCanonicalName() + "." + applicationName;
            this.setContext(this.helper.createContext(loggerName));
        }
        this.name = null;
        this.description = null;
        this.author = null;
        this.owner = null;
        this.root = null;
        this.connectorService = null;
        this.decoderService = null;
        this.metadataService = null;
        this.statusService = null;
        this.tunnelService = null;
    }

    public abstract Restlet createRoot();

    public String getAuthor() {
        return this.author;
    }

    public ConnectorService getConnectorService() {
        if (this.connectorService == null) {
            this.connectorService = new ConnectorService();
        }
        return this.connectorService;
    }

    public ConverterService getConverterService() {
        if (this.converterService == null) {
            this.converterService = new ConverterService();
        }
        return this.converterService;
    }

    public DecoderService getDecoderService() {
        if (this.decoderService == null) {
            this.decoderService = new DecoderService(true);
        }
        return this.decoderService;
    }

    public String getDescription() {
        return this.description;
    }

    private Helper getHelper() {
        return this.helper;
    }

    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = new MetadataService();
        }
        return this.metadataService;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public Restlet getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    public StatusService getStatusService() {
        if (this.statusService == null) {
            this.statusService = new StatusService(true);
        }
        return this.statusService;
    }

    public TunnelService getTunnelService() {
        if (this.tunnelService == null) {
            this.tunnelService = new TunnelService(true, true, true);
        }
        return this.tunnelService;
    }

    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    public void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public void setConverterService(ConverterService converterService) {
        this.converterService = converterService;
    }

    public void setDecoderService(DecoderService decoderService) {
        this.decoderService = decoderService;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    public void setTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }
}

