/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.List;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Message;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.resource.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
extends Message {
    private ChallengeResponse challengeResponse;
    private ClientInfo clientInfo;
    private Conditions conditions;
    private boolean confidential;
    private Series<Cookie> cookies;
    private Reference hostRef;
    private Method method;
    private Reference referrerRef;
    private Reference resourceRef;
    private Reference rootRef;

    public Request() {
        this.confidential = false;
    }

    public Request(Method method, Reference resourceRef) {
        this(method, resourceRef, null);
    }

    public Request(Method method, Reference resourceRef, Representation entity) {
        super(entity);
        this.setMethod(method);
        this.setResourceRef(resourceRef);
    }

    public Request(Method method, String resourceUri) {
        this(method, new Reference(resourceUri));
    }

    public Request(Method method, String resourceUri, Representation entity) {
        this(method, new Reference(resourceUri), entity);
    }

    public ChallengeResponse getChallengeResponse() {
        return this.challengeResponse;
    }

    public ClientInfo getClientInfo() {
        if (this.clientInfo == null) {
            this.clientInfo = new ClientInfo();
        }
        return this.clientInfo;
    }

    public Conditions getConditions() {
        if (this.conditions == null) {
            this.conditions = new Conditions();
        }
        return this.conditions;
    }

    public Series<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new CookieSeries();
        }
        return this.cookies;
    }

    public Reference getHostRef() {
        return this.hostRef;
    }

    public Method getMethod() {
        return this.method;
    }

    public Protocol getProtocol() {
        Protocol result;
        Protocol protocol = result = this.getResourceRef().getBaseRef() != null ? this.getResourceRef().getBaseRef().getSchemeProtocol() : null;
        if (result == null) {
            result = this.getResourceRef() != null ? this.getResourceRef().getSchemeProtocol() : null;
        }
        return result;
    }

    public Reference getReferrerRef() {
        return this.referrerRef;
    }

    public Reference getResourceRef() {
        return this.resourceRef;
    }

    public Reference getRootRef() {
        return this.rootRef;
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    @Override
    public boolean isEntityAvailable() {
        if (this.getMethod().equals(Method.GET) || this.getMethod().equals(Method.HEAD) || this.getMethod().equals(Method.DELETE)) {
            return false;
        }
        return super.isEntityAvailable();
    }

    public void setChallengeResponse(ChallengeResponse response) {
        this.challengeResponse = response;
    }

    public void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setHostRef(Reference hostRef) {
        this.hostRef = hostRef;
    }

    public void setHostRef(String hostUri) {
        this.setHostRef(new Reference(hostUri));
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setReferrerRef(Reference referrerRef) {
        this.referrerRef = referrerRef;
        if (this.referrerRef != null && this.referrerRef.getFragment() != null) {
            this.referrerRef.setFragment(null);
        }
    }

    public void setReferrerRef(String referrerUri) {
        this.setReferrerRef(new Reference(referrerUri));
    }

    public void setResourceRef(Reference resourceRef) {
        this.resourceRef = resourceRef;
    }

    public void setResourceRef(String resourceUri) {
        if (this.getResourceRef() != null) {
            this.setResourceRef(new Reference(this.getResourceRef().getBaseRef(), resourceUri));
        } else {
            this.setResourceRef(new Reference(resourceUri));
        }
    }

    public void setRootRef(Reference rootRef) {
        this.rootRef = rootRef;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieSeries
    extends Series<Cookie> {
        public CookieSeries() {
        }

        public CookieSeries(List<Cookie> delegate) {
            super(delegate);
        }

        @Override
        public Cookie createEntry(String name, String value) {
            return new Cookie(name, value);
        }

        @Override
        public Series<Cookie> createSeries(List<Cookie> delegate) {
            if (delegate != null) {
                return new CookieSeries(delegate);
            }
            return new CookieSeries();
        }
    }
}

