/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import com.noelios.restlet.ext.servlet.ServletConverter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.BeanDelegatingRestlet;
import org.geoserver.rest.BeanResourceFinder;
import org.geoserver.rest.IndexRestlet;
import org.geoserver.rest.PageInfo;
import org.geoserver.rest.RESTMapping;
import org.geoserver.rest.RestletException;
import org.geotools.util.logging.Logging;
import org.restlet.Restlet;
import org.restlet.Router;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RESTDispatcher
extends AbstractController {
    public static String METHOD_PUT = "PUT";
    public static String METHOD_DELETE = "DELETE";
    static Logger LOG = Logging.getLogger((String)"org.geoserver.rest");
    ServletConverter myConverter;
    Router myRouter;
    GeoServer gs;

    public RESTDispatcher(GeoServer gs) {
        this.gs = gs;
        this.setSupportedMethods(new String[]{"GET", "POST", METHOD_PUT, METHOD_DELETE, "HEAD"});
    }

    protected void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.myConverter = new ServletConverter(this.getServletContext());
        this.myConverter.setTarget(this.createRoot());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            this.myConverter.service(req, resp);
        }
        catch (Exception e) {
            RestletException re = null;
            if (e instanceof RestletException) {
                re = (RestletException)e;
            }
            if (re == null && e.getCause() instanceof RestletException) {
                re = (RestletException)e.getCause();
            }
            if (re != null) {
                resp.setStatus(re.getStatus().getCode());
                String reStr = re.getRepresentation().getText();
                if (reStr != null) {
                    LOG.severe(reStr);
                    resp.getOutputStream().write(reStr.getBytes());
                }
            } else {
                LOG.log(Level.SEVERE, "", e);
                resp.setStatus(500);
                if (e.getMessage() != null) {
                    resp.getOutputStream().write(e.getMessage().getBytes());
                }
            }
            resp.getOutputStream().flush();
        }
        return null;
    }

    public void addRoutes(Map m, Router r) {
        for (Map.Entry entry : m.entrySet()) {
            Object restlet = this.getApplicationContext().getBean(entry.getValue().toString()) instanceof Resource ? new BeanResourceFinder(this.getApplicationContext(), entry.getValue().toString()) : new BeanDelegatingRestlet(this.getApplicationContext(), entry.getValue().toString());
            String path = entry.getKey().toString();
            r.attach(path, (Restlet)restlet);
            if (path.indexOf("?") != -1) {
                r.attach(path + "?{q}", (Restlet)restlet);
                continue;
            }
            LOG.fine("Query string already listed in restlet mapping: " + path);
        }
    }

    public Restlet createRoot() {
        if (this.myRouter == null) {
            this.myRouter = new Router(){

                protected synchronized void init(Request request, Response response) {
                    String extension;
                    super.init(request, response);
                    String rootURI = request.getRootRef().toString();
                    String baseURI = null;
                    if (request.getResourceRef().getBaseRef() != null) {
                        baseURI = request.getResourceRef().getBaseRef().toString();
                    }
                    String pageURI = request.getResourceRef().toString();
                    if (RESTDispatcher.this.gs.getGlobal().getProxyBaseUrl() != null) {
                        String host = RequestUtils.proxifiedBaseURL((String)request.getHostRef().toString(), (String)RESTDispatcher.this.gs.getGlobal().getProxyBaseUrl());
                        rootURI = ResponseUtils.appendPath((String)host, (String)request.getRootRef().getPath());
                        baseURI = baseURI != null ? ResponseUtils.appendPath((String)host, (String)request.getResourceRef().getBaseRef().getPath()) : baseURI;
                        pageURI = ResponseUtils.appendPath((String)host, (String)request.getResourceRef().getPath());
                    }
                    if ((extension = ResponseUtils.getExtension((String)pageURI)) != null) {
                        pageURI = pageURI.substring(0, pageURI.length() - extension.length() - 1);
                    }
                    if (pageURI.endsWith("/")) {
                        pageURI = pageURI.substring(0, pageURI.length() - 1);
                    }
                    PageInfo pageInfo = new PageInfo();
                    pageInfo.setRootURI(rootURI);
                    pageInfo.setBaseURI(baseURI);
                    pageInfo.setPageURI(pageURI);
                    pageInfo.setExtension(extension);
                    request.getAttributes().put("org.geoserver.pageDetails", pageInfo);
                }
            };
            for (RESTMapping rm : GeoServerExtensions.extensions(RESTMapping.class)) {
                this.addRoutes(rm.getRoutes(), this.myRouter);
            }
            this.myRouter.attach("", (Restlet)new IndexRestlet(this.myRouter));
        }
        return this.myRouter;
    }
}

