/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.taskdefs.PreSetDef;

public class UnknownElement
extends Task {
    private String elementName;
    private String namespace;
    private String qname;
    private Object realThing;
    private List children = null;
    private boolean presetDefed = false;

    public UnknownElement(String elementName) {
        this.elementName = elementName;
    }

    public List getChildren() {
        return this.children;
    }

    public String getTag() {
        return this.elementName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        if (namespace.equals("ant:current")) {
            ComponentHelper helper = ComponentHelper.getComponentHelper(this.getProject());
            namespace = helper.getCurrentAntlibUri();
        }
        this.namespace = namespace;
    }

    public String getQName() {
        return this.qname;
    }

    public void setQName(String qname) {
        this.qname = qname;
    }

    public RuntimeConfigurable getWrapper() {
        return super.getWrapper();
    }

    public void maybeConfigure() throws BuildException {
        this.configure(this.makeObject(this, this.getWrapper()));
    }

    public void configure(Object realObject) {
        this.realThing = realObject;
        this.getWrapper().setProxy(this.realThing);
        Task task = null;
        if (this.realThing instanceof Task) {
            task = (Task)this.realThing;
            task.setRuntimeConfigurableWrapper(this.getWrapper());
            this.getOwningTarget().replaceChild((Task)this, (Task)this.realThing);
        }
        this.handleChildren(this.realThing, this.getWrapper());
        if (task != null) {
            task.maybeConfigure();
        } else {
            this.getWrapper().maybeConfigure(this.getProject());
        }
    }

    protected void handleOutput(String output) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleOutput(output);
        } else {
            super.handleOutput(output);
        }
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.realThing instanceof Task) {
            return ((Task)this.realThing).handleInput(buffer, offset, length);
        }
        return super.handleInput(buffer, offset, length);
    }

    protected void handleFlush(String output) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleFlush(output);
        } else {
            super.handleFlush(output);
        }
    }

    protected void handleErrorOutput(String output) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(output);
        } else {
            super.handleErrorOutput(output);
        }
    }

    protected void handleErrorFlush(String output) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(output);
        } else {
            super.handleErrorOutput(output);
        }
    }

    public void execute() {
        if (this.realThing == null) {
            throw new BuildException("Could not create task of type: " + this.elementName, this.getLocation());
        }
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).execute();
        }
        this.realThing = null;
    }

    public void addChild(UnknownElement child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    protected void handleChildren(Object parent, RuntimeConfigurable parentWrapper) throws BuildException {
        if (parent instanceof TypeAdapter) {
            parent = ((TypeAdapter)parent).getProxy();
        }
        String parentUri = this.getNamespace();
        Class<?> parentClass = parent.getClass();
        IntrospectionHelper ih = IntrospectionHelper.getHelper(parentClass);
        if (this.children != null) {
            Iterator it = this.children.iterator();
            int i = 0;
            while (it.hasNext()) {
                RuntimeConfigurable childWrapper = parentWrapper.getChild(i);
                UnknownElement child = (UnknownElement)it.next();
                if (!this.handleChild(parentUri, ih, parent, child, childWrapper)) {
                    if (!(parent instanceof TaskContainer)) {
                        ih.throwNotSupported(this.getProject(), parent, child.getTag());
                    } else {
                        TaskContainer container = (TaskContainer)parent;
                        container.addTask(child);
                    }
                }
                ++i;
            }
        }
    }

    protected String getComponentName() {
        return ProjectHelper.genComponentName(this.getNamespace(), this.getTag());
    }

    public void applyPreSet(UnknownElement u) {
        if (this.presetDefed) {
            return;
        }
        this.getWrapper().applyPreSet(u.getWrapper());
        if (u.children != null) {
            ArrayList newChildren = new ArrayList();
            newChildren.addAll(u.children);
            if (this.children != null) {
                newChildren.addAll(this.children);
            }
            this.children = newChildren;
        }
        this.presetDefed = true;
    }

    protected Object makeObject(UnknownElement ue, RuntimeConfigurable w) {
        ComponentHelper helper = ComponentHelper.getComponentHelper(this.getProject());
        String name = ue.getComponentName();
        Object o = helper.createComponent(ue, ue.getNamespace(), name);
        if (o == null) {
            throw this.getNotFoundException("task or type", name);
        }
        if (o instanceof PreSetDef.PreSetDefinition) {
            PreSetDef.PreSetDefinition def = (PreSetDef.PreSetDefinition)o;
            if ((o = def.createObject(ue.getProject())) == null) {
                throw this.getNotFoundException("preset " + name, def.getPreSets().getComponentName());
            }
            ue.applyPreSet(def.getPreSets());
            if (o instanceof Task) {
                Task task = (Task)o;
                task.setTaskType(ue.getTaskType());
                task.setTaskName(ue.getTaskName());
            }
        }
        if (o instanceof Task) {
            Task task = (Task)o;
            task.setOwningTarget(this.getOwningTarget());
            task.init();
        }
        return o;
    }

    protected Task makeTask(UnknownElement ue, RuntimeConfigurable w) {
        Task task = this.getProject().createTask(ue.getTag());
        if (task != null) {
            task.setLocation(this.getLocation());
            task.setOwningTarget(this.getOwningTarget());
            task.init();
        }
        return task;
    }

    protected BuildException getNotFoundException(String what, String elementName) {
        String lSep = System.getProperty("line.separator");
        String msg = "Could not create " + what + " of type: " + elementName + "." + lSep + lSep + "Ant could not find the task or a class this " + "task relies upon." + lSep + lSep + "This is common and has a number of causes; the usual " + lSep + "solutions are to read the manual pages then download and" + lSep + "install needed JAR files, or fix the build file: " + lSep + " - You have misspelt '" + elementName + "'." + lSep + "   Fix: check your spelling." + lSep + " - The task needs an external JAR file to execute" + lSep + "     and this is not found at the right place in the classpath." + lSep + "   Fix: check the documentation for dependencies." + lSep + "   Fix: declare the task." + lSep + " - The task is an Ant optional task and the JAR file and/or libraries" + lSep + "     implementing the functionality were not found at the time you" + lSep + "     yourself built your installation of Ant from the Ant sources." + lSep + "   Fix: Look in the ANT_HOME/lib for the 'ant-' JAR corresponding to the" + lSep + "     task and make sure it contains more than merely a META-INF/MANIFEST.MF." + lSep + "     If all it contains is the manifest, then rebuild Ant with the needed" + lSep + "     libraries present in ${ant.home}/lib/optional/ , or alternatively," + lSep + "     download a pre-built release version from apache.org" + lSep + " - The build file was written for a later version of Ant" + lSep + "   Fix: upgrade to at least the latest release version of Ant" + lSep + " - The task is not an Ant core or optional task " + lSep + "     and needs to be declared using <taskdef>." + lSep + " - You are attempting to use a task defined using " + lSep + "    <presetdef> or <macrodef> but have spelt wrong or not " + lSep + "   defined it at the point of use" + lSep + lSep + "Remember that for JAR files to be visible to Ant tasks implemented" + lSep + "in ANT_HOME/lib, the files must be in the same directory or on the" + lSep + "classpath" + lSep + lSep + "Please neither file bug reports on this problem, nor email the" + lSep + "Ant mailing lists, until all of these causes have been explored," + lSep + "as this is not an Ant bug.";
        return new BuildException(msg, this.getLocation());
    }

    public String getTaskName() {
        return this.realThing == null || !(this.realThing instanceof Task) ? super.getTaskName() : ((Task)this.realThing).getTaskName();
    }

    public Task getTask() {
        if (this.realThing instanceof Task) {
            return (Task)this.realThing;
        }
        return null;
    }

    public Object getRealThing() {
        return this.realThing;
    }

    private boolean handleChild(String parentUri, IntrospectionHelper ih, Object parent, UnknownElement child, RuntimeConfigurable childWrapper) {
        String childName = ProjectHelper.genComponentName(child.getNamespace(), child.getTag());
        if (ih.supportsNestedElement(parentUri, childName)) {
            IntrospectionHelper.Creator creator = ih.getElementCreator(this.getProject(), parentUri, parent, childName, child);
            creator.setPolyType(childWrapper.getPolyType());
            Object realChild = creator.create();
            if (realChild instanceof PreSetDef.PreSetDefinition) {
                PreSetDef.PreSetDefinition def = (PreSetDef.PreSetDefinition)realChild;
                realChild = creator.getRealObject();
                child.applyPreSet(def.getPreSets());
            }
            childWrapper.setCreator(creator);
            childWrapper.setProxy(realChild);
            if (realChild instanceof Task) {
                Task childTask = (Task)realChild;
                childTask.setRuntimeConfigurableWrapper(childWrapper);
                childTask.setTaskName(childName);
                childTask.setTaskType(childName);
                childTask.setLocation(child.getLocation());
            }
            child.handleChildren(realChild, childWrapper);
            return true;
        }
        return false;
    }

    public boolean similar(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        UnknownElement other = (UnknownElement)obj;
        if (!this.equalsString(this.elementName, other.elementName)) {
            return false;
        }
        if (!this.namespace.equals(other.namespace)) {
            return false;
        }
        if (!this.qname.equals(other.qname)) {
            return false;
        }
        if (!this.getWrapper().getAttributeMap().equals(other.getWrapper().getAttributeMap())) {
            return false;
        }
        if (!this.getWrapper().getText().toString().equals(other.getWrapper().getText().toString())) {
            return false;
        }
        if (this.children == null || this.children.size() == 0) {
            return other.children == null || other.children.size() == 0;
        }
        if (other.children == null) {
            return false;
        }
        if (this.children.size() != other.children.size()) {
            return false;
        }
        int i = 0;
        while (i < this.children.size()) {
            UnknownElement child = (UnknownElement)this.children.get(i);
            if (!child.similar(other.children.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equalsString(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

