/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.piecewise;

import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.referencing.piecewise.DefaultDomainElement1D;
import org.geotools.referencing.piecewise.DomainElement1D;
import org.geotools.renderer.i18n.Errors;
import org.geotools.resources.XMath;
import org.geotools.util.NumberRange;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PiecewiseUtilities {
    private PiecewiseUtilities() {
    }

    static void domainElementsOverlap(DomainElement1D[] domainElements, int idx) {
        NumberRange<? extends Number> range1 = domainElements[idx - 1].getRange();
        NumberRange<? extends Number> range2 = domainElements[idx].getRange();
        Comparable[] args = new Comparable[]{range1.getMinValue(), range1.getMaxValue(), range2.getMinValue(), range2.getMaxValue()};
        for (int j = 0; j < args.length; ++j) {
            double value;
            if (!(args[j] instanceof Number) || !Double.isNaN(value = ((Number)((Object)args[j])).doubleValue())) continue;
            String hex = Long.toHexString(Double.doubleToRawLongBits(value));
            args[j] = "NaN(" + hex + ')';
        }
        throw new IllegalArgumentException(Errors.format(12, args));
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    static int binarySearch(double[] array, double val) {
        int low = 0;
        int high = array.length - 1;
        boolean keyIsNaN = Double.isNaN(val);
        while (low <= high) {
            boolean adjustLow;
            long keyRawBits;
            int mid = low + high >> 1;
            double midVal = array[mid];
            if (midVal < val) {
                low = mid + 1;
                continue;
            }
            if (midVal > val) {
                high = mid - 1;
                continue;
            }
            long midRawBits = Double.doubleToRawLongBits(midVal);
            if (midRawBits == (keyRawBits = Double.doubleToRawLongBits(val))) {
                return mid;
            }
            boolean midIsNaN = Double.isNaN(midVal);
            if (keyIsNaN) {
                adjustLow = !midIsNaN || midRawBits < keyRawBits;
            } else {
                boolean bl = adjustLow = !midIsNaN && midRawBits < keyRawBits;
            }
            if (adjustLow) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static boolean isSorted(DefaultDomainElement1D[] domains) {
        if (domains == null) {
            return true;
        }
        for (int i = 1; i < domains.length; ++i) {
            DefaultDomainElement1D d1 = domains[i];
            assert (!(d1.getInputMinimum() > d1.getInputMaximum())) : d1;
            DefaultDomainElement1D d0 = domains[i - 1];
            assert (!(d0.getInputMinimum() > d0.getInputMaximum())) : d0;
            if (PiecewiseUtilities.compare(d0.getInputMaximum(), d1.getInputMinimum()) <= 0) continue;
            return false;
        }
        return true;
    }

    static void checkDimension(DirectPosition point) {
        int dim = point.getDimension();
        if (dim != 1) {
            throw new MismatchedDimensionException(Errors.format(13, new Integer(1), new Integer(dim)));
        }
    }

    static double doubleValue(Class<? extends Number> type, Number number, int direction) {
        assert (direction >= -1 && direction <= 1) : direction;
        return XMath.rool(type, (double)number.doubleValue(), (int)direction);
    }

    static MathTransform1D createLinearTransform1D(double scale, double offset) {
        return LinearTransform1D.create((double)scale, (double)offset);
    }

    static MathTransform1D createLinearTransform1D(NumberRange<? extends Number> sourceRange, NumberRange<? extends Number> destinationRange) {
        double maxDestination;
        Class sType = sourceRange.getElementClass();
        Class dType = destinationRange.getElementClass();
        int sMinInc = sourceRange.isMinIncluded() ? 0 : 1;
        int sMaxInc = sourceRange.isMaxIncluded() ? 0 : -1;
        int dMinInc = destinationRange.isMinIncluded() ? 0 : 1;
        int dMaxInc = destinationRange.isMaxIncluded() ? 0 : -1;
        double minSource = PiecewiseUtilities.doubleValue(sType, (Number)((Object)sourceRange.getMinValue()), sMinInc);
        double maxSource = PiecewiseUtilities.doubleValue(sType, (Number)((Object)sourceRange.getMaxValue()), sMaxInc);
        double minDestination = PiecewiseUtilities.doubleValue(dType, (Number)((Object)destinationRange.getMinValue()), dMinInc);
        if (PiecewiseUtilities.compare(minDestination, maxDestination = PiecewiseUtilities.doubleValue(dType, (Number)((Object)destinationRange.getMaxValue()), dMaxInc)) == 0) {
            return LinearTransform1D.create((double)0.0, (double)minDestination);
        }
        if (PiecewiseUtilities.compare(minSource, maxSource) == 0) {
            throw new IllegalArgumentException("Impossible to map a single value to a range.");
        }
        double scale = (maxDestination - minDestination) / (maxSource - minSource);
        if (Double.isNaN(scale)) {
            scale = 0.0;
        }
        double offset = minDestination - scale * minSource;
        return PiecewiseUtilities.createLinearTransform1D(scale, offset);
    }
}

