/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class ShapeMarkFactory
implements MarkFactory {
    private static final String SHAPE_PREFIX = "shape://";
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    static Map<String, Shape> shapes = new HashMap<String, Shape>();

    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        if (symbolUrl == null) {
            return null;
        }
        String wellKnownName = (String)symbolUrl.evaluate((Object)feature, String.class);
        if (!wellKnownName.startsWith(SHAPE_PREFIX)) {
            return null;
        }
        String name = wellKnownName.substring(SHAPE_PREFIX.length());
        return shapes.get(name);
    }

    static {
        shapes.put("vertline", new Line2D.Double(0.0, -0.5, 0.0, 0.5));
        shapes.put("horline", new Line2D.Double(-0.5, 0.0, 0.5, 0.0));
        shapes.put("slash", new Line2D.Double(-0.5, -0.5, 0.5, 0.5));
        shapes.put("backslash", new Line2D.Double(-0.5, 0.5, 0.5, -0.5));
        shapes.put("dot", new Ellipse2D.Double(-1.0E-6, -1.0E-6, 1.0E-6, 1.0E-6));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.0f);
        gp.lineTo(0.5f, 0.0f);
        gp.moveTo(0.0f, -0.5f);
        gp.lineTo(0.0f, 0.5f);
        shapes.put("plus", gp);
        gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.5f);
        gp.lineTo(0.5f, -0.5f);
        gp.moveTo(-0.5f, -0.5f);
        gp.lineTo(0.5f, 0.5f);
        shapes.put("times", gp);
    }
}

