/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.IOException;
import java.io.OutputStream;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.ResultTypeType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class HitsOutputFormat
extends Response {
    WFS wfs;
    WFSConfiguration configuration;

    public HitsOutputFormat(WFS wfs, WFSConfiguration configuration) {
        super(FeatureCollectionType.class);
        this.wfs = wfs;
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        return request != null && request.getResultType() == ResultTypeType.HITS_LITERAL;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        FeatureCollectionType featureCollection = (FeatureCollectionType)value;
        FeatureCollectionType hits = WfsFactory.eINSTANCE.createFeatureCollectionType();
        hits.setNumberOfFeatures(featureCollection.getNumberOfFeatures());
        hits.setTimeStamp(featureCollection.getTimeStamp());
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        encoder.setEncoding(this.wfs.getCharSet());
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String)this.wfs.getSchemaBaseURL(), (String)"wfs/1.1.0/wfs.xsd"));
        encoder.encode((Object)hits, org.geoserver.wfs.xml.v1_1_0.WFS.FEATURECOLLECTION, output);
    }
}

