/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import org.geoserver.data.util.IOUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeZipOutputFormat
extends WFSGetFeatureOutputFormat
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(ShapeZipOutputFormat.class);
    private String outputFileName;
    private ApplicationContext applicationContext;

    public ShapeZipOutputFormat() {
        super("SHAPE-ZIP");
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/zip";
    }

    @Override
    public String getCapabilitiesElementName() {
        return "SHAPE-ZIP";
    }

    @Override
    protected boolean canHandleInternal(Operation operation) {
        GetFeatureType request = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        this.outputFileName = ((QName)((QueryType)request.getQuery().get(0)).getTypeName().get(0)).getLocalPart();
        return true;
    }

    public String[][] getHeaders(Object value, Operation operation) throws ServiceException {
        return new String[][]{{"Content-Disposition", "attachment; filename=" + this.outputFileName + ".zip"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        File tempDir = IOUtils.createTempDirectory((String)"wfsshptemp");
        try {
            for (FeatureCollection curCollection : featureCollection.getFeature()) {
                if (((SimpleFeatureType)curCollection.getSchema()).getGeometryDescriptor() == null) {
                    throw new WFSException("Cannot write geometryless shapefiles, yet " + curCollection.getSchema() + " has no geometry field");
                }
                Class geomType = ((SimpleFeatureType)curCollection.getSchema()).getGeometryDescriptor().getType().getBinding();
                if (GeometryCollection.class.equals((Object)geomType)) {
                    throw new WFSException("GeometryCollection is not a supported output type for shapefiles");
                }
                if (Geometry.class.equals((Object)geomType)) {
                    this.writeCollectionToShapefiles((FeatureCollection<SimpleFeatureType, SimpleFeature>)curCollection, tempDir, this.getShapefileCharset(getFeature));
                    continue;
                }
                this.writeCollectionToShapefile((FeatureCollection<SimpleFeatureType, SimpleFeature>)curCollection, tempDir, this.getShapefileCharset(getFeature));
            }
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".shp") || name.endsWith(".shx") || name.endsWith(".dbf") || name.endsWith(".prj") || name.endsWith(".cst");
                }
            };
            ZipOutputStream zipOut = new ZipOutputStream(output);
            IOUtils.zipDirectory((File)tempDir, (ZipOutputStream)zipOut, (FilenameFilter)filter);
        }
        finally {
            if (!this.removeDirectory(tempDir)) {
                LOGGER.warning("Could not delete temp directory: " + tempDir.getAbsolutePath());
            }
        }
    }

    private void writeCollectionToShapefile(FeatureCollection<SimpleFeatureType, SimpleFeature> c, File tempDir, Charset charset) {
        SimpleFeatureType schema = (SimpleFeatureType)c.getSchema();
        FeatureStore fstore = null;
        ShapefileDataStore dstore = null;
        try {
            dstore = this.buildStore(tempDir, charset, schema);
            fstore = (FeatureStore)dstore.getFeatureSource();
            fstore.addFeatures(c);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
            throw new ServiceException((Throwable)ioe);
        }
        finally {
            if (dstore != null) {
                dstore.dispose();
            }
        }
    }

    private void writeCollectionToShapefiles(FeatureCollection<SimpleFeatureType, SimpleFeature> c, File tempDir, Charset charset) {
        IOException stored;
        SimpleFeatureType schema = (SimpleFeatureType)c.getSchema();
        HashMap<Class, StoreWriter> writers = new HashMap<Class, StoreWriter>();
        try {
            FeatureIterator it = c.features();
            while (it.hasNext()) {
                SimpleFeature f = (SimpleFeature)it.next();
                if (f.getDefaultGeometry() == null) {
                    LOGGER.warning("Skipping " + f.getID() + " as its geometry is null");
                    continue;
                }
                FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.getFeatureWriter(f, writers, tempDir, charset);
                SimpleFeature fw = (SimpleFeature)writer.next();
                for (AttributeDescriptor d : fw.getFeatureType().getAttributeDescriptors()) {
                    fw.setAttribute(d.getLocalName(), f.getAttribute(d.getLocalName()));
                }
                fw.setDefaultGeometry(f.getDefaultGeometry());
                writer.write();
            }
            stored = null;
        }
        catch (IOException ioe) {
            try {
                LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
                throw new ServiceException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOException stored2 = null;
                for (StoreWriter sw : writers.values()) {
                    try {
                        sw.writer.close();
                        sw.dstore.dispose();
                    }
                    catch (IOException e) {
                        stored2 = e;
                    }
                }
                if (stored2 != null) {
                    throw new ServiceException(stored2);
                }
                throw throwable;
            }
        }
        for (StoreWriter sw : writers.values()) {
            try {
                sw.writer.close();
                sw.dstore.dispose();
            }
            catch (IOException e) {
                stored = e;
            }
        }
        if (stored != null) {
            throw new ServiceException(stored);
        }
    }

    private FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(SimpleFeature f, Map<Class, StoreWriter> writers, File tempDir, Charset charset) throws IOException {
        Class<Point> target;
        Geometry g = (Geometry)f.getDefaultGeometry();
        String suffix = null;
        if (g instanceof Point) {
            target = Point.class;
            suffix = "Point";
        } else if (g instanceof MultiPoint) {
            target = MultiPoint.class;
            suffix = "MPoint";
        } else if (g instanceof MultiPolygon || g instanceof Polygon) {
            target = MultiPolygon.class;
            suffix = "Polygon";
        } else if (g instanceof LineString || g instanceof MultiLineString) {
            target = MultiLineString.class;
            suffix = "Line";
        } else {
            throw new RuntimeException("This should never happen, there's a bug in the SHAPE-ZIP output format. I got a geometry of type " + g.getClass());
        }
        StoreWriter storeWriter = writers.get(target);
        if (storeWriter == null) {
            SimpleFeatureType original = f.getFeatureType();
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor d : original.getAttributeDescriptors()) {
                if (Geometry.class.isAssignableFrom(d.getType().getBinding())) {
                    GeometryDescriptor gd = (GeometryDescriptor)d;
                    builder.add(gd.getLocalName(), target, gd.getCoordinateReferenceSystem());
                    builder.setDefaultGeometry(gd.getLocalName());
                    continue;
                }
                builder.add(d);
            }
            builder.setName(original.getTypeName() + suffix);
            builder.setNamespaceURI(original.getName().getURI());
            SimpleFeatureType retyped = builder.buildFeatureType();
            ShapefileDataStore dstore = this.buildStore(tempDir, charset, retyped);
            storeWriter = new StoreWriter();
            storeWriter.dstore = dstore;
            storeWriter.writer = dstore.getFeatureWriter(retyped.getTypeName(), Transaction.AUTO_COMMIT);
            writers.put(target, storeWriter);
        }
        return storeWriter.writer;
    }

    private Charset getShapefileCharset(Operation getFeature) {
        Charset result = null;
        GetFeatureType gft = (GetFeatureType)getFeature.getParameters()[0];
        if (gft.getFormatOptions() != null && gft.getFormatOptions().get("CHARSET") != null) {
            result = (Charset)gft.getFormatOptions().get("CHARSET");
        } else {
            String charsetName = GeoServerExtensions.getProperty((String)"GS-SHAPEFILE-CHARSET", (ApplicationContext)this.applicationContext);
            if (charsetName != null) {
                result = Charset.forName(charsetName);
            }
        }
        return result != null ? result : Charset.defaultCharset();
    }

    private boolean removeDirectory(File tempDir) {
        if (!tempDir.exists() || !tempDir.isDirectory()) {
            return false;
        }
        File[] files = tempDir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.removeDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        return tempDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShapefileDataStore buildStore(File tempDir, Charset charset, SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
        File file = new File(tempDir, schema.getTypeName() + ".shp");
        ShapefileDataStore sfds = new ShapefileDataStore(file.toURL());
        sfds.setStringCharset(charset);
        File charsetFile = new File(tempDir, schema.getTypeName() + ".cst");
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(charsetFile);
            pw.write(charset.name());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new ServiceException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        try {
            if (schema.getCoordinateReferenceSystem() != null) {
                sfds.forceSchemaCRS(schema.getCoordinateReferenceSystem());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not properly create the .prj file", e);
        }
        return sfds;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class StoreWriter {
        DataStore dstore;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

        private StoreWriter() {
        }
    }
}

