/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSDescribeFeatureTypeOutputFormat;
import org.geotools.gml.producer.FeatureTypeTransformer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class XmlSchemaEncoder
extends WFSDescribeFeatureTypeOutputFormat {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses");
    private static final String SCHEMA_URI = "\"http://www.w3.org/2001/XMLSchema\"";
    private static final String XS_NAMESPACE = "\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";
    private static final String GML_URL = "\"http://www.opengis.net/gml\"";
    private static final String GML_NAMESPACE = "\n  xmlns:gml=\"http://www.opengis.net/gml\"";
    private static final String ELEMENT_FORM_DEFAULT = "\n  elementFormDefault=\"qualified\"";
    private static final String ATTR_FORM_DEFAULT = "\n  attributeFormDefault=\"unqualified\" version=\"1.0\">";
    private static final String TARGETNS_PREFIX = "\n  targetNamespace=\"";
    private static final String TARGETNS_SUFFIX = "\" ";
    private static final String FOOTER = "\n</xs:schema>";
    WFS wfs;
    Data catalog;

    public XmlSchemaEncoder(WFS wfs, Data catalog) {
        super("XMLSCHEMA");
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    protected void write(FeatureTypeInfo[] featureTypeInfos, OutputStream output, Operation describeFeatureType) throws IOException {
        String xmlResponse = this.generateTypes(featureTypeInfos, (DescribeFeatureTypeType)describeFeatureType.getParameters()[0]);
        if (!this.wfs.isVerbose()) {
            xmlResponse = xmlResponse.replaceAll(">\n[ \\t\\n]*", ">");
            xmlResponse = xmlResponse.replaceAll("\n[ \\t\\n]*", " ");
        }
        OutputStreamWriter writer = new OutputStreamWriter(output, this.wfs.getCharSet());
        writer.write(xmlResponse);
        ((Writer)writer).flush();
    }

    private final String generateTypes(FeatureTypeInfo[] infos, DescribeFeatureTypeType request) throws IOException {
        StringBuffer tempResponse = new StringBuffer();
        tempResponse.append("<?xml version=\"1.0\" encoding=\"" + this.wfs.getCharSet().name() + "\"?>" + "\n<xs:schema ");
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)request.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        if (this.allSameType(infos)) {
            FeatureTypeInfo ftInfo = infos[0];
            String targetNs = ftInfo.getNameSpace().getURI();
            tempResponse.append(TARGETNS_PREFIX + targetNs + TARGETNS_SUFFIX);
            tempResponse.append("\n  xmlns:" + ftInfo.getNameSpace().getPrefix() + "=\"" + targetNs + "\"");
            tempResponse.append(GML_NAMESPACE);
            tempResponse.append(XS_NAMESPACE);
            tempResponse.append("\n  elementFormDefault=\"qualified\"\n  attributeFormDefault=\"unqualified\" version=\"1.0\">");
            tempResponse.append("\n\n<xs:import namespace=\"http://www.opengis.net/gml\" schemaLocation=\"" + ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/gml/2.1.2.1/feature.xsd") + "\"/>\n\n");
            tempResponse.append(this.generateSpecifiedTypes(infos));
        } else {
            tempResponse.append(XS_NAMESPACE);
            tempResponse.append("\n  elementFormDefault=\"qualified\"\n  attributeFormDefault=\"unqualified\" version=\"1.0\">");
            HashSet<String> prefixes = new HashSet<String>();
            for (int i = 0; i < infos.length; ++i) {
                FeatureTypeInfo ftInfo = infos[i];
                prefixes.add(ftInfo.getNameSpace().getPrefix());
            }
            Iterator prefixIter = prefixes.iterator();
            while (prefixIter.hasNext()) {
                String prefix = prefixIter.next().toString();
                String wfsBaseUrl = proxifiedBaseUrl.endsWith("/") ? proxifiedBaseUrl + request.getService().toLowerCase() : proxifiedBaseUrl + "/" + request.getService().toLowerCase();
                tempResponse.append(this.getNSImport(prefix, infos, wfsBaseUrl));
            }
        }
        tempResponse.append(FOOTER);
        return tempResponse.toString();
    }

    private StringBuffer getNSImport(String prefix, FeatureTypeInfo[] infos, String baseUrl) {
        LOGGER.finer("prefix is " + prefix);
        StringBuffer retBuffer = new StringBuffer("\n  <xs:import namespace=\"");
        String namespace = this.catalog.getNameSpace(prefix).getURI();
        retBuffer.append(namespace + "\"");
        retBuffer.append("\n        schemaLocation=\"" + baseUrl + "?request=DescribeFeatureType&amp;service=wfs&amp;version=1.0.0&amp;typeName=");
        for (int i = 0; i < infos.length; ++i) {
            FeatureTypeInfo info = infos[i];
            String typeName = info.getName();
            if (!typeName.startsWith(prefix + ":")) continue;
            retBuffer.append(typeName + ",");
        }
        retBuffer.deleteCharAt(retBuffer.length() - 1);
        retBuffer.append("\"/>");
        return retBuffer;
    }

    private String generateSpecifiedTypes(FeatureTypeInfo[] infos) {
        String tempResponse = new String();
        String generatedType = new String();
        HashSet<FeatureTypeInfo> validTypes = new HashSet<FeatureTypeInfo>();
        for (int i = 0; i < infos.length; ++i) {
            FeatureTypeInfo ftInfo = infos[i];
            if (validTypes.contains(ftInfo)) continue;
            File schemaFile = ftInfo.getSchemaFile();
            try {
                if (schemaFile != null && schemaFile.exists() && schemaFile.canRead()) {
                    generatedType = this.writeFile(schemaFile);
                } else {
                    SimpleFeatureType ft2 = ftInfo.getFeatureType();
                    String gType2 = this.generateFromSchema(ft2);
                    if (gType2 != null && gType2 != "") {
                        generatedType = gType2;
                    }
                }
            }
            catch (IOException e) {
                generatedType = "";
            }
            if (generatedType.equals("")) continue;
            tempResponse = tempResponse + generatedType;
            validTypes.add(ftInfo);
        }
        Iterator i = validTypes.iterator();
        while (i.hasNext()) {
            tempResponse = tempResponse + XmlSchemaEncoder.printElement((FeatureTypeInfo)i.next());
        }
        tempResponse = tempResponse + "\n\n";
        return tempResponse;
    }

    private String generateFromSchema(SimpleFeatureType schema) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            FeatureTypeTransformer t = new FeatureTypeTransformer();
            t.setIndentation(4);
            t.setOmitXMLDeclaration(true);
            t.transform((Object)schema, (Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (TransformerException te) {
            LOGGER.log(Level.WARNING, "Error generating schema from feature type", te);
            throw (IOException)new IOException("problem transforming type").initCause(te);
        }
    }

    private static String printElement(FeatureTypeInfo type) {
        return "\n  <xs:element name=\"" + type.getTypeName() + "\" type=\"" + type.getNameSpace().getPrefix() + ":" + type.getSchemaName() + "\" substitutionGroup=\"gml:_Feature\"/>";
    }

    public String writeFile(File inputFile) throws IOException {
        LOGGER.finest("writing file " + inputFile);
        String finalOutput = new String();
        try {
            int bytesRead;
            FileInputStream inputStream = new FileInputStream(inputFile);
            byte[] fileBuffer = new byte[inputStream.available()];
            while ((bytesRead = inputStream.read(fileBuffer)) != -1) {
                String tempOutput = new String(fileBuffer);
                finalOutput = finalOutput + tempOutput;
            }
        }
        catch (IOException e) {
            throw (IOException)new IOException("problem writing featureType information  from " + inputFile).initCause(e);
        }
        return finalOutput;
    }

    public boolean allSameType(FeatureTypeInfo[] infos) {
        boolean sameType = true;
        if (infos.length == 0) {
            return false;
        }
        FeatureTypeInfo first = infos[0];
        for (int i = 0; i < infos.length; ++i) {
            FeatureTypeInfo ftInfo = infos[i];
            if (first.getNameSpace().equals((Object)ftInfo.getNameSpace())) continue;
            return false;
        }
        return sameType;
    }
}

