/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.commons;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public abstract class CommonsFileUploadSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DiskFileItemFactory fileItemFactory = this.newFileItemFactory();
    private final FileUpload fileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
    private boolean uploadTempDirSpecified = false;

    public DiskFileItemFactory getFileItemFactory() {
        return this.fileItemFactory;
    }

    public FileUpload getFileUpload() {
        return this.fileUpload;
    }

    public void setMaxUploadSize(long maxUploadSize) {
        this.fileUpload.setSizeMax(maxUploadSize);
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.fileItemFactory.setSizeThreshold(maxInMemorySize);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.fileUpload.setHeaderEncoding(defaultEncoding);
    }

    protected String getDefaultEncoding() {
        String encoding = this.getFileUpload().getHeaderEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        return encoding;
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.fileItemFactory.setRepository(uploadTempDir.getFile());
        this.uploadTempDirSpecified = true;
    }

    protected boolean isUploadTempDirSpecified() {
        return this.uploadTempDirSpecified;
    }

    protected DiskFileItemFactory newFileItemFactory() {
        return new DiskFileItemFactory();
    }

    protected abstract FileUpload newFileUpload(FileItemFactory var1);

    protected FileUpload prepareFileUpload(String encoding) {
        FileUpload fileUpload;
        FileUpload actualFileUpload = fileUpload = this.getFileUpload();
        if (encoding != null && !encoding.equals(fileUpload.getHeaderEncoding())) {
            actualFileUpload = this.newFileUpload((FileItemFactory)this.getFileItemFactory());
            actualFileUpload.setSizeMax(fileUpload.getSizeMax());
            actualFileUpload.setHeaderEncoding(encoding);
        }
        return actualFileUpload;
    }

    protected MultipartParsingResult parseFileItems(List fileItems, String encoding) {
        HashMap<String, CommonsMultipartFile> multipartFiles = new HashMap<String, CommonsMultipartFile>();
        HashMap<String, String[]> multipartParameters = new HashMap<String, String[]>();
        Iterator it = fileItems.iterator();
        while (it.hasNext()) {
            FileItem fileItem = (FileItem)it.next();
            if (fileItem.isFormField()) {
                String[] curParam;
                String value = null;
                if (encoding != null) {
                    try {
                        value = fileItem.getString(encoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)("Could not decode multipart item '" + fileItem.getFieldName() + "' with encoding '" + encoding + "': using platform default"));
                        }
                        value = fileItem.getString();
                    }
                } else {
                    value = fileItem.getString();
                }
                if ((curParam = (String[])multipartParameters.get(fileItem.getFieldName())) == null) {
                    multipartParameters.put(fileItem.getFieldName(), new String[]{value});
                    continue;
                }
                String[] newParam = StringUtils.addStringToArray((String[])curParam, (String)value);
                multipartParameters.put(fileItem.getFieldName(), newParam);
                continue;
            }
            CommonsMultipartFile file = new CommonsMultipartFile(fileItem);
            if (multipartFiles.put(file.getName(), file) != null) {
                throw new MultipartException("Multiple files for field name [" + file.getName() + "] found - not supported by MultipartResolver");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Found multipart file [" + file.getName() + "] of size " + file.getSize() + " bytes with original filename [" + file.getOriginalFilename() + "], stored " + file.getStorageDescription()));
        }
        return new MultipartParsingResult(multipartFiles, multipartParameters);
    }

    protected void cleanupFileItems(Collection multipartFiles) {
        Iterator it = multipartFiles.iterator();
        while (it.hasNext()) {
            CommonsMultipartFile file = (CommonsMultipartFile)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cleaning up multipart file [" + file.getName() + "] with original filename [" + file.getOriginalFilename() + "], stored " + file.getStorageDescription()));
            }
            file.getFileItem().delete();
        }
    }

    protected static class MultipartParsingResult {
        private final Map multipartFiles;
        private final Map multipartParameters;

        public MultipartParsingResult(Map multipartFiles, Map multipartParameters) {
            this.multipartFiles = multipartFiles;
            this.multipartParameters = multipartParameters;
        }

        public Map getMultipartFiles() {
            return this.multipartFiles;
        }

        public Map getMultipartParameters() {
            return this.multipartParameters;
        }
    }
}

