CREATE CACHED TABLE EPSG_ALIAS(ALIAS_CODE INTEGER NOT NULL,OBJECT_TABLE_NAME VARCHAR(80) NOT NULL,OBJECT_CODE INTEGER NOT NULL,NAMING_SYSTEM_CODE INTEGER NOT NULL,ALIAS VARCHAR(80) NOT NULL,REMARKS VARCHAR(254),CONSTRAINT PK_ALIAS PRIMARY KEY(ALIAS_CODE))
CREATE CACHED TABLE EPSG_AREA(AREA_CODE INTEGER NOT NULL,AREA_NAME VARCHAR(80) NOT NULL,AREA_OF_USE VARCHAR NOT NULL,AREA_SOUTH_BOUND_LAT DOUBLE,AREA_NORTH_BOUND_LAT DOUBLE,AREA_WEST_BOUND_LON DOUBLE,AREA_EAST_BOUND_LON DOUBLE,AREA_POLYGON_FILE_REF VARCHAR(254),ISO_A2_CODE VARCHAR(2),ISO_A3_CODE VARCHAR(3),ISO_N_CODE INTEGER,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_AREA PRIMARY KEY(AREA_CODE))
CREATE CACHED TABLE EPSG_CHANGE(CHANGE_ID DOUBLE NOT NULL,REPORT_DATE DATE NOT NULL,DATE_CLOSED DATE,REPORTER VARCHAR(254) NOT NULL,REQUEST VARCHAR(254) NOT NULL,TABLES_AFFECTED VARCHAR(254),CODES_AFFECTED VARCHAR(254),CHANGE_COMMENT VARCHAR(254),ACTION VARCHAR,CONSTRAINT SYS_CT_48 UNIQUE(CHANGE_ID))
CREATE CACHED TABLE EPSG_COORDINATEAXIS(COORD_AXIS_CODE INTEGER NOT NULL,COORD_SYS_CODE INTEGER NOT NULL,COORD_AXIS_NAME_CODE INTEGER NOT NULL,COORD_AXIS_ORIENTATION VARCHAR(24) NOT NULL,COORD_AXIS_ABBREVIATION VARCHAR(24) NOT NULL,UOM_CODE INTEGER NOT NULL,COORD_AXIS_ORDER SMALLINT NOT NULL,CONSTRAINT PK_COORDINATEAXIS PRIMARY KEY(COORD_SYS_CODE,COORD_AXIS_NAME_CODE),CONSTRAINT SYS_CT_51 UNIQUE(COORD_AXIS_CODE))
CREATE CACHED TABLE EPSG_COORDINATEAXISNAME(COORD_AXIS_NAME_CODE INTEGER NOT NULL,COORD_AXIS_NAME VARCHAR(80) NOT NULL,DESCRIPTION VARCHAR(254),REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDINATEAXISNAME PRIMARY KEY(COORD_AXIS_NAME_CODE))
CREATE CACHED TABLE EPSG_COORDINATEREFERENCESYSTEM(COORD_REF_SYS_CODE INTEGER NOT NULL,COORD_REF_SYS_NAME VARCHAR(80) NOT NULL,AREA_OF_USE_CODE INTEGER NOT NULL,COORD_REF_SYS_KIND VARCHAR(24) NOT NULL,COORD_SYS_CODE INTEGER,DATUM_CODE INTEGER,SOURCE_GEOGCRS_CODE INTEGER,PROJECTION_CONV_CODE INTEGER,CMPD_HORIZCRS_CODE INTEGER,CMPD_VERTCRS_CODE INTEGER,CRS_SCOPE VARCHAR(254) NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),SHOW_CRS SMALLINT NOT NULL,DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDINATEREFERENCESYSTEM PRIMARY KEY(COORD_REF_SYS_CODE))
CREATE CACHED TABLE EPSG_COORDINATESYSTEM(COORD_SYS_CODE INTEGER NOT NULL,COORD_SYS_NAME VARCHAR(254) NOT NULL,COORD_SYS_TYPE VARCHAR(24) NOT NULL,DIMENSION SMALLINT NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(50) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDINATESYSTEM PRIMARY KEY(COORD_SYS_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATION(COORD_OP_CODE INTEGER NOT NULL,COORD_OP_NAME VARCHAR(80) NOT NULL,COORD_OP_TYPE VARCHAR(24) NOT NULL,SOURCE_CRS_CODE INTEGER,TARGET_CRS_CODE INTEGER,COORD_TFM_VERSION VARCHAR(24),COORD_OP_VARIANT SMALLINT,AREA_OF_USE_CODE INTEGER NOT NULL,COORD_OP_SCOPE VARCHAR(254) NOT NULL,COORD_OP_ACCURACY FLOAT,COORD_OP_METHOD_CODE INTEGER,UOM_CODE_SOURCE_COORD_DIFF INTEGER,UOM_CODE_TARGET_COORD_DIFF INTEGER,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),SHOW_OPERATION SMALLINT NOT NULL,DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATION PRIMARY KEY(COORD_OP_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONMETHOD(COORD_OP_METHOD_CODE INTEGER NOT NULL,COORD_OP_METHOD_NAME VARCHAR(50) NOT NULL,REVERSE_OP SMALLINT NOT NULL,FORMULA VARCHAR,EXAMPLE VARCHAR,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATIONMETHOD PRIMARY KEY(COORD_OP_METHOD_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPARAM(PARAMETER_CODE INTEGER NOT NULL,PARAMETER_NAME VARCHAR(80) NOT NULL,DESCRIPTION VARCHAR,INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATIONPARAM PRIMARY KEY(PARAMETER_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPARAMUSAGE(COORD_OP_METHOD_CODE INTEGER NOT NULL,PARAMETER_CODE INTEGER NOT NULL,SORT_ORDER SMALLINT NOT NULL,PARAM_SIGN_REVERSAL VARCHAR(3),CONSTRAINT PK_COORDOPERATIONPARAMUSAGE PRIMARY KEY(PARAMETER_CODE,COORD_OP_METHOD_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPARAMVALUE(COORD_OP_CODE INTEGER NOT NULL,COORD_OP_METHOD_CODE INTEGER NOT NULL,PARAMETER_CODE INTEGER NOT NULL,PARAMETER_VALUE DOUBLE,PARAM_VALUE_FILE_REF VARCHAR(254),UOM_CODE INTEGER,CONSTRAINT PK_COORDOPERATIONPARAMVALUE PRIMARY KEY(COORD_OP_CODE,PARAMETER_CODE,COORD_OP_METHOD_CODE))
CREATE CACHED TABLE EPSG_COORDOPERATIONPATH(CONCAT_OPERATION_CODE INTEGER NOT NULL,SINGLE_OPERATION_CODE INTEGER NOT NULL,OP_PATH_STEP SMALLINT NOT NULL,CONSTRAINT PK_COORDOPERATIONPATH PRIMARY KEY(CONCAT_OPERATION_CODE,SINGLE_OPERATION_CODE))
CREATE CACHED TABLE EPSG_DATUM(DATUM_CODE INTEGER NOT NULL,DATUM_NAME VARCHAR(80) NOT NULL,DATUM_TYPE VARCHAR(24) NOT NULL,ORIGIN_DESCRIPTION VARCHAR(254),REALIZATION_EPOCH INTEGER,ELLIPSOID_CODE INTEGER,PRIME_MERIDIAN_CODE INTEGER,AREA_OF_USE_CODE INTEGER NOT NULL,DATUM_SCOPE VARCHAR(254) NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_DATUM PRIMARY KEY(DATUM_CODE))
CREATE CACHED TABLE EPSG_DEPRECATION(DEPRECATION_ID INTEGER NOT NULL,DEPRECATION_DATE DATE,CHANGE_ID DOUBLE NOT NULL,OBJECT_TABLE_NAME VARCHAR(80),OBJECT_CODE INTEGER,REPLACED_BY INTEGER,DEPRECATION_REASON VARCHAR(254),CONSTRAINT PK_DEPRECATION PRIMARY KEY(DEPRECATION_ID))
CREATE CACHED TABLE EPSG_ELLIPSOID(ELLIPSOID_CODE INTEGER NOT NULL,ELLIPSOID_NAME VARCHAR(80) NOT NULL,SEMI_MAJOR_AXIS DOUBLE NOT NULL,UOM_CODE INTEGER NOT NULL,INV_FLATTENING DOUBLE,SEMI_MINOR_AXIS DOUBLE,ELLIPSOID_SHAPE SMALLINT NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_ELLIPSOID PRIMARY KEY(ELLIPSOID_CODE))
CREATE CACHED TABLE EPSG_NAMINGSYSTEM(NAMING_SYSTEM_CODE INTEGER NOT NULL,NAMING_SYSTEM_NAME VARCHAR(80) NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_NAMINGSYSTEM PRIMARY KEY(NAMING_SYSTEM_CODE))
CREATE CACHED TABLE EPSG_PRIMEMERIDIAN(PRIME_MERIDIAN_CODE INTEGER NOT NULL,PRIME_MERIDIAN_NAME VARCHAR(80) NOT NULL,GREENWICH_LONGITUDE DOUBLE NOT NULL,UOM_CODE INTEGER NOT NULL,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_PRIMEMERIDIAN PRIMARY KEY(PRIME_MERIDIAN_CODE))
CREATE CACHED TABLE EPSG_SUPERSESSION(SUPERSESSION_ID INTEGER NOT NULL,OBJECT_TABLE_NAME VARCHAR(80) NOT NULL,OBJECT_CODE INTEGER NOT NULL,SUPERSEDED_BY INTEGER,SUPERSESSION_TYPE VARCHAR(50),SUPERSESSION_YEAR SMALLINT,REMARKS VARCHAR(254),CONSTRAINT PK_SUPERSESSION PRIMARY KEY(SUPERSESSION_ID))
CREATE CACHED TABLE EPSG_UNITOFMEASURE(UOM_CODE INTEGER NOT NULL,UNIT_OF_MEAS_NAME VARCHAR(80) NOT NULL,UNIT_OF_MEAS_TYPE VARCHAR(50),TARGET_UOM_CODE INTEGER NOT NULL,FACTOR_B DOUBLE,FACTOR_C DOUBLE,REMARKS VARCHAR(254),INFORMATION_SOURCE VARCHAR(254),DATA_SOURCE VARCHAR(40) NOT NULL,REVISION_DATE DATE NOT NULL,CHANGE_ID VARCHAR(50),DEPRECATED SMALLINT NOT NULL,CONSTRAINT PK_UNITOFMEASURE PRIMARY KEY(UOM_CODE))
CREATE CACHED TABLE EPSG_VERSIONHISTORY(VERSION_HISTORY_CODE INTEGER NOT NULL,VERSION_DATE DATE,VERSION_NUMBER VARCHAR(10) NOT NULL,VERSION_REMARKS VARCHAR(254) NOT NULL,SUPERCEDED_BY VARCHAR(10),SUPERCEDES VARCHAR(10),CONSTRAINT PK_VERSIONHISTORY PRIMARY KEY(VERSION_HISTORY_CODE),CONSTRAINT SYS_CT_70 UNIQUE(VERSION_NUMBER))
INSERT INTO EPSG_ALIAS VALUES
(4,'epsg_datum',6258,7300,'ETRF89',''),
(5,'epsg_ellipsoid',7013,7300,'Modified Clarke 1880 (South Africa)','The Clarke 1880 (Arc) figure is one of several modifications to the original definition.  The name Clarke Modified is usually taken to be the RGS modification.  But in southern Africa it is usually taken to be the Arc or Cape modification.'),
(6,'epsg_coordoperation',8570,7300,'ED50 to EUREF89 (2)',''),
(7,'epsg_unitofmeasure',9001,7300,'meter',''),
(8,'epsg_unitofmeasure',9036,7300,'kilometer','Spelling used in US'),
(9,'epsg_coordinatereferencesystem',21100,7300,'Genuk / NEIEZ',''),
(10,'epsg_coordoperation',1036,7301,'OSTN97',''),
(11,'epsg_coordoperation',1123,7301,'Genuk to WGS 84 (1)',''),
(12,'epsg_coordoperation',1149,7301,'ETRF89 to WGS 84 (1)',''),
(13,'epsg_coordoperation',1273,7301,'HD72 to ETRF89 (1)',''),
(14,'epsg_coordoperation',1309,7301,'DHDN to ETRF89 (1)',''),
(15,'epsg_coordoperation',1310,7301,'Pulkovo 1942 to ETRF89 (1)',''),
(16,'epsg_coordoperation',1311,7301,'ED50 to WGS 84 (Common Offshore)',''),
(17,'epsg_coordoperation',1331,7301,'EST92 to ETRF89 (1)',''),
(19,'epsg_coordoperation',1513,7301,'Final Datum 1958 to WGS 84 (1)',''),
(20,'epsg_coordoperation',1571,7301,'Amersfoort to ETRF89 (1)',''),
(21,'epsg_coordoperation',1584,7301,'Levant to WGS 72BE (1)',''),
(22,'epsg_coordoperation',1585,7301,'Levant to WGS 84 (2)',''),
(23,'epsg_coordoperation',1586,7301,'Levant to WGS 84 (3)',''),
(24,'epsg_coordoperation',1587,7301,'Levant to WGS 84 (4)',''),
(26,'epsg_coordoperation',1589,7301,'ED50 to ETRF89 (3)',''),
(28,'epsg_coordoperation',1611,7301,'IRENET95 to ETRF89 (1)',''),
(29,'epsg_coordinatereferencesystem',2140,7301,'NAD83(CSRS98) / SCoPQ zone 3',''),
(30,'epsg_coordinatereferencesystem',2141,7301,'NAD83(CSRS98) / SCoPQ zone 4',''),
(31,'epsg_coordinatereferencesystem',2142,7301,'NAD83(CSRS98) / SCoPQ zone 5',''),
(32,'epsg_coordinatereferencesystem',2143,7301,'NAD83(CSRS98) / SCoPQ zone 6',''),
(33,'epsg_coordinatereferencesystem',2144,7301,'NAD83(CSRS98) / SCoPQ zone 7',''),
(34,'epsg_coordinatereferencesystem',2145,7301,'NAD83(CSRS98) / SCoPQ zone 8',''),
(35,'epsg_coordinatereferencesystem',2146,7301,'NAD83(CSRS98) / SCoPQ zone 9',''),
(36,'epsg_coordinatereferencesystem',2147,7301,'NAD83(CSRS98) / SCoPQ zone 10',''),
(37,'epsg_coordinatereferencesystem',2159,7301,'Sierra Leone 1924 / Peninsular Grid',''),
(38,'epsg_coordinatereferencesystem',2291,7301,'NAD83 / PEI Stereo',''),
(39,'epsg_coordinatereferencesystem',3200,7301,'Final Datum 1958 / Iraq zone',''),
(40,'epsg_coordinatereferencesystem',4132,7301,'Final Datum 1958 (Iran)',''),
(41,'epsg_coordinatereferencesystem',4140,7301,'NAD83(CSRS)',''),
(42,'epsg_coordinatereferencesystem',4172,7301,'National Geodetic System [Argentina]','see http://www.igm.gov.ar/posgar.html'),
(43,'epsg_coordinatereferencesystem',4211,7301,'Genuk',''),
(44,'epsg_datum',4218,7301,'Bogota',''),
(45,'epsg_coordinatereferencesystem',4227,7301,'Levant',''),
(46,'epsg_coordinatereferencesystem',4258,7301,'ETRF89',''),
(47,'epsg_coordinatereferencesystem',4272,7301,'GD49',''),
(48,'epsg_coordinatereferencesystem',4813,7301,'Genuk (Jakarta)',''),
(49,'epsg_datum',5104,7301,'Huang Hai 1956',''),
(50,'epsg_datum',6120,7301,'Old Greek','Adjective "Old" applied since introduction of GGRS87 (code 6121)'),
(51,'epsg_datum',6125,7301,'Samboja P2 exc T9',''),
(52,'epsg_datum',6160,7301,'Quini-Huao',''),
(53,'epsg_datum',6174,7301,'Sierra Leone Peninsular 1924',''),
(54,'epsg_datum',6211,7301,'Genuk',''),
(55,'epsg_datum',6218,7301,'Bogota',''),
(56,'epsg_datum',6222,7301,'South Africa',''),
(57,'epsg_datum',6227,7301,'Levant',''),
(58,'epsg_datum',6258,7301,'European Terrestrial Reference Frame 1989',''),
(59,'epsg_datum',6269,7301,'NAD83 (1986)',''),
(60,'epsg_datum',6272,7301,'GD49',''),
(61,'epsg_datum',6308,7301,'Rikets koordinatsystem 1938',''),
(62,'epsg_ellipsoid',7012,7301,'Clarke Modified 1880','The Clarke 1880 (RGS) figure is one of several modifications to the original definition.  The name Clarke Modified is usually taken to be the RGS modification.'),
(63,'epsg_ellipsoid',7013,7301,'Clarke 1880 (Cape)',''),
(64,'epsg_ellipsoid',7019,7301,'International 1979','Adopted by IUGG 1979 Canberra as the Geodetic Reference Spheroid of 1980 (GRS 1980).'),
(65,'epsg_ellipsoid',7022,7301,'Hayford 1909','Described as a=6378388 m. and b=6356909 m. from which 1/f derived to be 296.95926...   The figure was adopted as the International ellipsoid in 1924 but with 1/f taken as 297 exactly from which b is derved as 6356911.946 m.'),
(66,'epsg_ellipsoid',7029,7301,'McCaw 1924',''),
(67,'epsg_ellipsoid',7030,7301,'WGS84',''),
(68,'epsg_ellipsoid',7036,7301,'International 1967','More usually known as GRS 1967 to avoid confusion with the International 1924 figure.'),
(69,'epsg_ellipsoid',7043,7301,'NWL 10D','Used by Transit Broadcast Ephemeris before 1989. Also referred to as WGS72 spheroid.'),
(70,'epsg_coordoperation',8568,7301,'Levant to WGS 84 (1)',''),
(71,'epsg_coordoperation',8570,7301,'ED50 to ETRF89 (2)',''),
(72,'epsg_coordoperationparam',8602,7301,'Longitude rotation',''),
(73,'epsg_primemeridian',8913,7301,'Kristiania',''),
(74,'epsg_unitofmeasure',9001,7301,'International metre',''),
(75,'epsg_unitofmeasure',9002,7301,'international foot',''),
(76,'epsg_unitofmeasure',9003,7301,'American foot',''),
(77,'epsg_unitofmeasure',9005,7301,'South African geodetic foot','Not to be confused with the Cape foot.'),
(78,'epsg_unitofmeasure',9030,7301,'International nautical mile',''),
(79,'epsg_unitofmeasure',9039,7301,'link (Clarke''s ratio)',''),
(80,'epsg_unitofmeasure',9040,7301,'yard',''),
(81,'epsg_unitofmeasure',9041,7301,'foot',''),
(82,'epsg_unitofmeasure',9042,7301,'chain',''),
(83,'epsg_unitofmeasure',9043,7301,'link',''),
(84,'epsg_unitofmeasure',9050,7301,'yard',''),
(85,'epsg_unitofmeasure',9051,7301,'foot',''),
(86,'epsg_unitofmeasure',9052,7301,'chain',''),
(87,'epsg_unitofmeasure',9053,7301,'link',''),
(88,'epsg_unitofmeasure',9060,7301,'yard',''),
(89,'epsg_unitofmeasure',9061,7301,'foot',''),
(90,'epsg_unitofmeasure',9062,7301,'chain',''),
(91,'epsg_unitofmeasure',9063,7301,'link',''),
(92,'epsg_unitofmeasure',9070,7301,'foot',''),
(93,'epsg_unitofmeasure',9080,7301,'Indian geodetic foot',''),
(94,'epsg_unitofmeasure',9081,7301,'Indian geodetic foot',''),
(95,'epsg_unitofmeasure',9084,7301,'yard','= 3 Indian feet.'),
(96,'epsg_unitofmeasure',9085,7301,'yard','= 3 Indian feet.'),
(97,'epsg_unitofmeasure',9094,7301,'foot',''),
(98,'epsg_unitofmeasure',9114,7301,'mil','Alias also applies to other variations of a mil, especially mil_6300 and mil_6000.'),
(100,'epsg_coordoperation',17001,7301,'Ghana TM',''),
(101,'epsg_coordoperation',17901,7301,'Mount Eden Circuit 1949',''),
(102,'epsg_coordoperation',17902,7301,'Bay of Plenty Circuit 1949',''),
(103,'epsg_coordoperation',17903,7301,'Poverty Bay Circuit 1949',''),
(104,'epsg_coordoperation',17904,7301,'Hawkes Bay Circuit 1949',''),
(105,'epsg_coordoperation',17905,7301,'Taranaki Circuit 1949',''),
(106,'epsg_coordoperation',17906,7301,'Tuhirangi Circuit 1949',''),
(107,'epsg_coordoperation',17907,7301,'Wanganui Circuit 1949',''),
(108,'epsg_coordoperation',17908,7301,'Wairarapa Circuit 1949',''),
(109,'epsg_coordoperation',17909,7301,'Wellington Circuit 1949',''),
(110,'epsg_coordoperation',17910,7301,'Collingwood Circuit 1949',''),
(111,'epsg_coordoperation',17911,7301,'Nelson Circuit 1949',''),
(112,'epsg_coordoperation',17912,7301,'Karamea Circuit 1949',''),
(113,'epsg_coordoperation',17913,7301,'Buller Circuit 1949',''),
(114,'epsg_coordoperation',17914,7301,'Grey Circuit 1949',''),
(115,'epsg_coordoperation',17915,7301,'Amuri Circuit 1949',''),
(116,'epsg_coordoperation',17916,7301,'Marlborough Circuit 1949',''),
(117,'epsg_coordoperation',17917,7301,'Hokitika Circuit 1949',''),
(118,'epsg_coordoperation',17918,7301,'Okarito Circuit 1949',''),
(119,'epsg_coordoperation',17919,7301,'Jacksons Bay Circuit 1949',''),
(120,'epsg_coordoperation',17920,7301,'Mount Pleasant Circuit 1949',''),
(121,'epsg_coordoperation',17921,7301,'Gawler Circuit 1949',''),
(122,'epsg_coordoperation',17922,7301,'Timaru Circuit 1949',''),
(123,'epsg_coordoperation',17923,7301,'Lindis Peak Circuit 1949',''),
(124,'epsg_coordoperation',17924,7301,'Mount Nicholas Circuit 1949',''),
(125,'epsg_coordoperation',17925,7301,'Mount York Circuit 1949',''),
(126,'epsg_coordoperation',17926,7301,'Observation Point Circuit 1949',''),
(127,'epsg_coordoperation',17927,7301,'North Taieri Circuit 1949',''),
(128,'epsg_coordoperation',17928,7301,'Bluff Circuit 1949',''),
(129,'epsg_coordoperation',19906,7301,'IOEPC Lambert','Sometimes seen defined with 2 standard parallels.'),
(130,'epsg_coordoperation',19959,7301,'Gold Coast Grid',''),
(131,'epsg_coordoperation',19963,7301,'Sierra Leone Peninsula Grid',''),
(132,'epsg_coordinatereferencesystem',21100,7301,'Genuk (Jakarta) / NEIEZ',''),
(133,'epsg_coordinatereferencesystem',21148,7301,'Genuk / UTM zone 48S',''),
(134,'epsg_coordinatereferencesystem',21150,7301,'Genuk / UTM zone 50S',''),
(135,'epsg_coordinatereferencesystem',22700,7301,'Levant / Levant Zone',''),
(136,'epsg_coordinatereferencesystem',22770,7301,'Levant / Syria Lambert',''),
(137,'epsg_coordinatereferencesystem',22780,7301,'Levant / Levant Stereographic',''),
(138,'epsg_coordinatereferencesystem',25828,7301,'ETRF89 / UTM zone 28N',''),
(139,'epsg_coordinatereferencesystem',25829,7301,'ETRF89 / UTM zone 29N',''),
(140,'epsg_coordinatereferencesystem',25830,7301,'ETRF89 / UTM zone 30N',''),
(141,'epsg_coordinatereferencesystem',25831,7301,'ETRF89 / UTM zone 31N',''),
(142,'epsg_coordinatereferencesystem',25832,7301,'ETRF89 / UTM zone 32N',''),
(143,'epsg_coordinatereferencesystem',25833,7301,'ETRF89 / UTM zone 33N',''),
(144,'epsg_coordinatereferencesystem',25834,7301,'ETRF89 / UTM zone 34N',''),
(145,'epsg_coordinatereferencesystem',25835,7301,'ETRF89 / UTM zone 35N',''),
(146,'epsg_coordinatereferencesystem',25836,7301,'ETRF89 / UTM zone 36N',''),
(147,'epsg_coordinatereferencesystem',25837,7301,'ETRF89 / UTM zone 37N',''),
(148,'epsg_coordinatereferencesystem',25838,7301,'ETRF89 / UTM zone 38N',''),
(149,'epsg_coordinatereferencesystem',25884,7301,'ETRF89 / TM Baltic93',''),
(150,'epsg_coordinatereferencesystem',27258,7301,'GD49 / UTM zone 58',''),
(151,'epsg_coordinatereferencesystem',27259,7301,'GD49 / UTM zone 59',''),
(152,'epsg_coordinatereferencesystem',27260,7301,'GD49 / UTM zone 60',''),
(153,'epsg_coordinatereferencesystem',27291,7301,'GD49 / North Island Grid',''),
(154,'epsg_coordinatereferencesystem',27292,7301,'GD49 / South Island Grid',''),
(155,'epsg_coordinatereferencesystem',30592,7301,'Nord Sahara 1959/Voirol Unifie S Algerie',''),
(156,'epsg_coordinatereferencesystem',30791,7301,'Nord Sahara 1959 / Lambert Nord Voirol Unifie 1960','Voirol Unifie 1960 is NOT a geodetic datum nor GeogCRS.  It is two Lambert projected coordinate reference systems based on Nord Sahara 1959 Datum. See also code 30792.'),
(157,'epsg_coordinatereferencesystem',30792,7301,'Nord Sahara 1959 / Lambert Sud Voirol Unifie 1960','Voirol Unifie 1960 is NOT a geodetic datum nor GeogCRS.  It is two Lambert projected coordinate reference systems based on Nord Sahara 1959 Datum. See also code 30791.'),
(158,'epsg_coordinatereferencesystem',31170,7301,'Zanderij / Surinam Old TM','Old country name spelling.'),
(159,'epsg_coordinatereferencesystem',31171,7301,'Zanderij / Surinam TM','Old spelling for country name.'),
(160,'epsg_coordinatereferencesystem',31300,7301,'Belge Lambert 72',''),
(161,'epsg_coordoperation',1026,7302,'Madrid to ED50 (1)',''),
(162,'epsg_coordoperation',1027,7302,'Madrid to ED50 (2)',''),
(163,'epsg_coordoperation',1028,7302,'Madrid to ED50 (3)',''),
(164,'epsg_coordoperation',1029,7302,'RD New to ED50/UTM31 (1)',''),
(165,'epsg_coordoperation',1030,7302,'ED50/UTM31 to RD New (1)',''),
(166,'epsg_coordoperation',1031,7302,'RD New to ED50/UTM31 (2)',''),
(167,'epsg_coordoperation',1032,7302,'ED50/UTM31 to RD New (2)',''),
(170,'epsg_coordinatereferencesystem',2000,7302,'Anguilla 1957 / BWI Grid',''),
(171,'epsg_coordinatereferencesystem',2001,7302,'Antigua 1943 / BWI Grid',''),
(172,'epsg_coordinatereferencesystem',2002,7302,'Dominica 1945 / BWI Grid',''),
(173,'epsg_coordinatereferencesystem',2003,7302,'Grenada 1953 / BWI Grid',''),
(174,'epsg_coordinatereferencesystem',2004,7302,'Montserrat 58 / BWI Grid',''),
(175,'epsg_coordinatereferencesystem',2005,7302,'St. Kitts 1955 / BWI Grid',''),
(176,'epsg_coordinatereferencesystem',2006,7302,'St. Lucia 1955 / BWI Grid',''),
(177,'epsg_coordinatereferencesystem',2007,7302,'St. Vincent 45 / BWI Grid',''),
(178,'epsg_coordinatereferencesystem',2008,7302,'CGQ77 / SCoPQ zone 2',''),
(179,'epsg_coordinatereferencesystem',2009,7302,'CGQ77 / SCoPQ zone 3',''),
(180,'epsg_coordinatereferencesystem',2010,7302,'CGQ77 / SCoPQ zone 4',''),
(181,'epsg_coordinatereferencesystem',2011,7302,'CGQ77 / SCoPQ zone 5',''),
(182,'epsg_coordinatereferencesystem',2012,7302,'CGQ77 / SCoPQ zone 6',''),
(183,'epsg_coordinatereferencesystem',2013,7302,'CGQ77 / SCoPQ zone 7',''),
(184,'epsg_coordinatereferencesystem',2014,7302,'CGQ77 / SCoPQ zone 8',''),
(185,'epsg_coordinatereferencesystem',2015,7302,'CGQ77 / SCoPQ zone 9',''),
(186,'epsg_coordinatereferencesystem',2016,7302,'CGQ77 / SCoPQ zone 10',''),
(187,'epsg_coordinatereferencesystem',2036,7302,'NAD83(CSRS) / NB Stereo',''),
(188,'epsg_coordinatereferencesystem',2037,7302,'NAD83(CSRS) / UTM 19N',''),
(189,'epsg_coordinatereferencesystem',2038,7302,'NAD83(CSRS) / UTM 20N',''),
(190,'epsg_coordinatereferencesystem',2039,7302,'Israeli TM Grid',''),
(191,'epsg_coordinatereferencesystem',2040,7302,'Locodjo 65 / UTM 30N',''),
(192,'epsg_coordinatereferencesystem',2041,7302,'Abidjan 87 / UTM 30N',''),
(193,'epsg_coordinatereferencesystem',2042,7302,'Locodjo 65 / UTM 29N',''),
(194,'epsg_coordinatereferencesystem',2043,7302,'Abidjan 87 / UTM 29N',''),
(195,'epsg_coordinatereferencesystem',2044,7302,'Hanoi 72 / Gauss zone 18',''),
(196,'epsg_coordinatereferencesystem',2045,7302,'Hanoi 72 / Gauss zone 19',''),
(197,'epsg_coordinatereferencesystem',2046,7302,'New S African CS zone 15',''),
(198,'epsg_coordinatereferencesystem',2047,7302,'New S African CS zone 17',''),
(199,'epsg_coordinatereferencesystem',2048,7302,'New S African CS zone 19',''),
(200,'epsg_coordinatereferencesystem',2049,7302,'New S African CS zone 21',''),
(201,'epsg_coordinatereferencesystem',2050,7302,'New S African CS zone 23',''),
(202,'epsg_coordinatereferencesystem',2051,7302,'New S African CS zone 25',''),
(203,'epsg_coordinatereferencesystem',2052,7302,'New S African CS zone 27',''),
(204,'epsg_coordinatereferencesystem',2053,7302,'New S African CS zone 29',''),
(205,'epsg_coordinatereferencesystem',2054,7302,'New S African CS zone 31',''),
(206,'epsg_coordinatereferencesystem',2055,7302,'New S African CS zone 33',''),
(207,'epsg_coordinatereferencesystem',2056,7302,'LV95',''),
(208,'epsg_coordinatereferencesystem',2066,7302,'Mount Dillon / Tobago',''),
(209,'epsg_coordinatereferencesystem',2067,7302,'Naparima 1955 / UTM 20N',''),
(210,'epsg_coordinatereferencesystem',2081,7302,'Chos Malal / Argentina 2',''),
(211,'epsg_coordinatereferencesystem',2082,7302,'Pampa d Castillo / Arg 2',''),
(212,'epsg_coordinatereferencesystem',2083,7302,'Hito XVIII / Argentina 2',''),
(213,'epsg_coordinatereferencesystem',2084,7302,'Hito XVIII / UTM 19S',''),
(214,'epsg_coordinatereferencesystem',2089,7302,'Yemen NGN96 / UTM 38N',''),
(215,'epsg_coordinatereferencesystem',2090,7302,'Yemen NGN96 / UTM 39N',''),
(216,'epsg_coordinatereferencesystem',2091,7302,'S Yemen / Gauss zone 8',''),
(217,'epsg_coordinatereferencesystem',2092,7302,'S Yemen / Gauss zone 9',''),
(218,'epsg_coordinatereferencesystem',2096,7302,'Korean 1985 / East Belt',''),
(219,'epsg_coordinatereferencesystem',2097,7302,'Korean 1985 / Cen. Belt',''),
(220,'epsg_coordinatereferencesystem',2098,7302,'Korean 1985 / West Belt',''),
(221,'epsg_coordinatereferencesystem',2099,7302,'Qatar Plane CS',''),
(222,'epsg_coordinatereferencesystem',2136,7301,'Accra / Gold Coast Grid',''),
(223,'epsg_coordinatereferencesystem',2137,7301,'Accra / Ghana TM',''),
(224,'epsg_coordinatereferencesystem',2157,7302,'IRENET95 / ITM',''),
(225,'epsg_coordinatereferencesystem',2200,7302,'ATS77 / NB Stereographic',''),
(226,'epsg_coordinatereferencesystem',2290,7302,'ATS77 / PEI Stereo',''),
(227,'epsg_coordinatereferencesystem',2291,7302,'NAD83(CSRS) / PEI Stereo',''),
(228,'epsg_coordinatereferencesystem',2294,7302,'ATS77 / MTM NS zone 4',''),
(229,'epsg_coordinatereferencesystem',2295,7302,'ATS77 / MTM NS zone 5',''),
(230,'epsg_coordinatereferencesystem',2393,7302,'KKJ / Finland zone 3',''),
(231,'epsg_coordinatereferencesystem',2600,7302,'LKS94','This alias is also used for geographical and geocentric CRSs.'),
(232,'epsg_coordinatereferencesystem',3561,7302,'Old Hawaiian / SP zone 1',''),
(233,'epsg_coordinatereferencesystem',3562,7302,'Old Hawaiian / SP zone 2',''),
(234,'epsg_coordinatereferencesystem',3563,7302,'Old Hawaiian / SP zone 3',''),
(235,'epsg_coordinatereferencesystem',3564,7302,'Old Hawaiian / SP zone 4',''),
(236,'epsg_coordinatereferencesystem',3565,7302,'Old Hawaiian / SP zone 5',''),
(237,'epsg_coordinatereferencesystem',3991,7302,'Puerto Rico SPCS 27',''),
(238,'epsg_coordinatereferencesystem',4134,7302,'PSD93',''),
(239,'epsg_coordinatereferencesystem',4215,7302,'BD 50',''),
(240,'epsg_coordinatereferencesystem',4268,7302,'NAD Michigan',''),
(241,'epsg_coordinatereferencesystem',4313,7302,'BD 72',''),
(242,'epsg_coordinatereferencesystem',4609,7302,'CGQ77',''),
(243,'epsg_coordinatereferencesystem',4809,7302,'BD 50 (Brussels)',''),
(244,'epsg_datum',5100,7302,'msl',''),
(245,'epsg_datum',5101,7302,'ODN',''),
(246,'epsg_datum',5102,7302,'NGVD29',''),
(247,'epsg_datum',5103,7302,'NAVD88',''),
(248,'epsg_datum',5104,7302,'Yellow Sea',''),
(249,'epsg_datum',5105,7302,'Baltic',''),
(250,'epsg_datum',5106,7302,'Caspian',''),
(251,'epsg_datum',5107,7302,'NGF',''),
(252,'epsg_datum',5109,7302,'NAP',''),
(253,'epsg_datum',5111,7302,'AHD',''),
(254,'epsg_datum',5112,7302,'AHD (Tasmania)',''),
(255,'epsg_datum',5114,7301,'CVD28',''),
(256,'epsg_datum',5115,7302,'Piraeus86',''),
(257,'epsg_datum',5116,7302,'N60',''),
(258,'epsg_datum',5117,7302,'RH70',''),
(259,'epsg_datum',5118,7302,'NGF - Lallemand',''),
(260,'epsg_datum',5119,7302,'NGF - IGN69',''),
(261,'epsg_datum',5120,7302,'NGF - IGN78',''),
(262,'epsg_datum',5122,7302,'JSLD',''),
(263,'epsg_datum',5123,7302,'PHD93',''),
(264,'epsg_datum',5127,7302,'LN02',''),
(265,'epsg_datum',5128,7302,'LHN95',''),
(266,'epsg_datum',5129,7302,'EVRF2000',''),
(267,'epsg_coordinatereferencesystem',5701,7302,'ODN',''),
(268,'epsg_coordinatereferencesystem',5702,7302,'NGVD29',''),
(269,'epsg_coordinatereferencesystem',5703,7302,'NAVD88',''),
(270,'epsg_coordinatereferencesystem',5709,7302,'NAP',''),
(271,'epsg_coordinatereferencesystem',5711,7302,'AHD',''),
(272,'epsg_coordinatereferencesystem',5712,7302,'AHD (Tasmania)',''),
(273,'epsg_coordinatereferencesystem',5713,7302,'CGVD28',''),
(274,'epsg_coordinatereferencesystem',5714,7302,'msl height',''),
(275,'epsg_coordinatereferencesystem',5715,7302,'msl depth',''),
(276,'epsg_coordinatereferencesystem',5723,7302,'Japan Levelling Datum',''),
(277,'epsg_coordinatereferencesystem',5724,7302,'PHD93',''),
(278,'epsg_coordinatereferencesystem',5728,7302,'LN02',''),
(279,'epsg_coordinatereferencesystem',5729,7302,'LHN95',''),
(281,'epsg_datum',6121,7302,'GGRS87',''),
(282,'epsg_datum',6122,7302,'ATS77',''),
(283,'epsg_datum',6123,7302,'KKJ',''),
(284,'epsg_datum',6124,7302,'RT90',''),
(285,'epsg_datum',6126,7302,'LKS94 (ETRS89)',''),
(286,'epsg_datum',6130,7302,'Moznet',''),
(287,'epsg_datum',6132,7302,'FD58',''),
(288,'epsg_datum',6133,7302,'EST92',''),
(289,'epsg_datum',6134,7302,'PSD93',''),
(290,'epsg_datum',6140,7302,'NAD83(CSRS98)',''),
(291,'epsg_datum',6151,7302,'CHTRF95',''),
(292,'epsg_datum',6152,7302,'NAD83(HARN)',''),
(293,'epsg_datum',6154,7302,'ED50(ED77)',''),
(294,'epsg_datum',6156,7302,'S-JTSK',''),
(295,'epsg_datum',6159,7302,'ELD79',''),
(296,'epsg_datum',6163,7302,'YNGN96',''),
(297,'epsg_datum',6170,7302,'SIRGAS 1995',''),
(298,'epsg_datum',6171,7302,'RGF93',''),
(299,'epsg_datum',6172,7302,'POSGAR',''),
(300,'epsg_datum',6202,7302,'AGD66',''),
(301,'epsg_datum',6203,7302,'AGD84',''),
(302,'epsg_datum',6204,7302,'Ain el Abd',''),
(303,'epsg_datum',6215,7302,'Belge 1950',''),
(304,'epsg_datum',6230,7302,'ED50',''),
(305,'epsg_datum',6231,7302,'ED87',''),
(306,'epsg_datum',6237,7302,'HD72',''),
(307,'epsg_datum',6238,7302,'ID74',''),
(308,'epsg_datum',6242,7302,'JAD69',''),
(309,'epsg_datum',6246,7302,'KOC',''),
(310,'epsg_datum',6248,7302,'PSAD56',''),
(311,'epsg_datum',6258,7302,'ETRS89',''),
(312,'epsg_datum',6267,7302,'NAD27',''),
(313,'epsg_datum',6269,7302,'NAD83',''),
(314,'epsg_datum',6272,7302,'NZGD49',''),
(315,'epsg_datum',6275,7302,'NTF',''),
(316,'epsg_datum',6278,7302,'OSGB70',''),
(317,'epsg_datum',6279,7302,'OS(SN)80',''),
(318,'epsg_datum',6280,7302,'Padang',''),
(319,'epsg_datum',6283,7302,'GDA94',''),
(320,'epsg_datum',6291,7302,'SAD69',''),
(321,'epsg_datum',6297,7302,'Tananarive',''),
(322,'epsg_datum',6303,7302,'TC(1948)',''),
(323,'epsg_datum',6305,7302,'Voirol Unifie',''),
(324,'epsg_datum',6308,7302,'RT38',''),
(325,'epsg_datum',6312,7302,'MGI',''),
(326,'epsg_datum',6313,7302,'Belge 1972',''),
(327,'epsg_datum',6314,7302,'DHDN',''),
(328,'epsg_datum',6318,7302,'NGN',''),
(329,'epsg_datum',6319,7302,'KUDAMS',''),
(330,'epsg_datum',6322,7302,'WGS 72',''),
(331,'epsg_datum',6324,7302,'WGS 72BE',''),
(332,'epsg_datum',6326,7302,'WGS 84',''),
(333,'epsg_datum',6608,7302,'NAD27(76)',''),
(334,'epsg_datum',6609,7302,'CGQ77',''),
(335,'epsg_datum',6901,7302,'ATF (Paris)',''),
(336,'epsg_datum',6902,7302,'NDG (Paris)',''),
(337,'epsg_ellipsoid',7003,7302,'ANS',''),
(338,'epsg_coordinatereferencesystem',7401,7302,'NTF / France II + Lalle',''),
(339,'epsg_coordinatereferencesystem',7402,7302,'NTF / France II + IGN69',''),
(340,'epsg_coordinatereferencesystem',7403,7302,'NTF / France III + IGN69',''),
(341,'epsg_coordinatereferencesystem',7405,7302,'GB National Grid + ODN',''),
(342,'epsg_coordinatereferencesystem',7407,7302,'NAD27 / TX_N + NGVD29',''),
(343,'epsg_coordoperationparam',8663,7302,'k',''),
(344,'epsg_unitofmeasure',9001,7302,'m',''),
(345,'epsg_unitofmeasure',9002,7302,'ft',''),
(346,'epsg_unitofmeasure',9003,7302,'ftUS',''),
(347,'epsg_unitofmeasure',9005,7302,'ftCla',''),
(348,'epsg_unitofmeasure',9014,7302,'f',''),
(349,'epsg_unitofmeasure',9030,7302,'NM',''),
(350,'epsg_unitofmeasure',9031,7302,'GLM',''),
(351,'epsg_unitofmeasure',9033,7302,'chUS',''),
(352,'epsg_unitofmeasure',9034,7302,'lkUS',''),
(353,'epsg_unitofmeasure',9035,7302,'miUS',''),
(354,'epsg_unitofmeasure',9036,7302,'km',''),
(355,'epsg_unitofmeasure',9037,7302,'ydCla',''),
(356,'epsg_unitofmeasure',9038,7302,'chCla',''),
(357,'epsg_unitofmeasure',9039,7302,'lkCla',''),
(358,'epsg_unitofmeasure',9040,7302,'ydSe',''),
(359,'epsg_unitofmeasure',9041,7302,'ftSe',''),
(360,'epsg_unitofmeasure',9042,7302,'chSe',''),
(361,'epsg_unitofmeasure',9043,7302,'lkSe',''),
(362,'epsg_unitofmeasure',9050,7302,'ydBnA',''),
(363,'epsg_unitofmeasure',9051,7302,'ftBnA',''),
(364,'epsg_unitofmeasure',9052,7302,'chBnA',''),
(365,'epsg_unitofmeasure',9053,7302,'lkBnA',''),
(366,'epsg_unitofmeasure',9060,7302,'ydBnB',''),
(367,'epsg_unitofmeasure',9061,7302,'ftBnB',''),
(368,'epsg_unitofmeasure',9062,7302,'chBnB',''),
(369,'epsg_unitofmeasure',9063,7302,'lkBnB',''),
(370,'epsg_unitofmeasure',9070,7302,'ftBr(65)',''),
(371,'epsg_unitofmeasure',9080,7302,'ftInd',''),
(372,'epsg_unitofmeasure',9081,7302,'ftInd(37)',''),
(373,'epsg_unitofmeasure',9082,7302,'ftInd(62)',''),
(374,'epsg_unitofmeasure',9083,7302,'ftInd(75)',''),
(375,'epsg_unitofmeasure',9084,7302,'ydInd',''),
(376,'epsg_unitofmeasure',9085,7302,'ydInd(37)',''),
(377,'epsg_unitofmeasure',9086,7302,'ydInd(62)',''),
(378,'epsg_unitofmeasure',9087,7302,'ydInd(75)',''),
(379,'epsg_unitofmeasure',9093,7302,'mi',''),
(380,'epsg_unitofmeasure',9094,7302,'ftGC',''),
(381,'epsg_unitofmeasure',9101,7302,'rad',''),
(382,'epsg_unitofmeasure',9102,7302,'deg',''),
(383,'epsg_unitofmeasure',9103,7302,'min',''),
(384,'epsg_unitofmeasure',9104,7302,'sec',''),
(385,'epsg_unitofmeasure',9105,7302,'gr',''),
(386,'epsg_unitofmeasure',9106,7302,'g',''),
(387,'epsg_unitofmeasure',9107,7302,'DMS',''),
(388,'epsg_unitofmeasure',9108,7302,'DMSH',''),
(389,'epsg_unitofmeasure',9109,7302,'\ufffd\ufffd\ufffdrad',''),
(390,'epsg_unitofmeasure',9110,7302,'DDD.MMSSsss',''),
(391,'epsg_unitofmeasure',9111,7302,'DDD.MMm',''),
(392,'epsg_unitofmeasure',9112,7302,'c',''),
(393,'epsg_unitofmeasure',9113,7302,'cc',''),
(394,'epsg_unitofmeasure',9114,7302,'mil',''),
(395,'epsg_unitofmeasure',9202,7302,'ppm',''),
(396,'epsg_unitofmeasure',9204,7302,'Bin330ftUS',''),
(397,'epsg_unitofmeasure',9205,7302,'Bin165ftUS',''),
(398,'epsg_unitofmeasure',9206,7302,'Bin82.5ftUS',''),
(399,'epsg_unitofmeasure',9207,7302,'Bin37.5m',''),
(400,'epsg_unitofmeasure',9208,7302,'Bin25m',''),
(401,'epsg_unitofmeasure',9209,7302,'Bin12.5m',''),
(402,'epsg_unitofmeasure',9210,7302,'Bin6.25m',''),
(403,'epsg_unitofmeasure',9211,7302,'Bin3.125m',''),
(404,'epsg_coordoperationmethod',9633,7302,'OSTN',''),
(405,'epsg_coordoperationmethod',9824,7302,'UTM',''),
(406,'epsg_coordoperation',10101,7302,'Alabama East',''),
(407,'epsg_coordoperation',10102,7302,'Alabama West',''),
(408,'epsg_coordoperation',10131,7302,'Alabama East',''),
(409,'epsg_coordoperation',10132,7302,'Alabama West',''),
(410,'epsg_coordoperation',10201,7302,'Arizona East',''),
(411,'epsg_coordoperation',10202,7302,'Arizona Central',''),
(412,'epsg_coordoperation',10203,7302,'Arizona West',''),
(413,'epsg_coordoperation',10231,7302,'Arizona East',''),
(414,'epsg_coordoperation',10232,7302,'Arizona Central',''),
(415,'epsg_coordoperation',10233,7302,'Arizona West',''),
(416,'epsg_coordoperation',10301,7302,'Arkansas North',''),
(417,'epsg_coordoperation',10302,7302,'Arkansas South',''),
(418,'epsg_coordoperationmethod',9809,7301,'Roussilhe',''),
(419,'epsg_coordoperation',10331,7302,'Arkansas North',''),
(420,'epsg_coordoperation',10332,7302,'Arkansas South',''),
(421,'epsg_coordoperation',10401,7302,'California zone I',''),
(422,'epsg_coordoperation',10402,7302,'California zone II',''),
(423,'epsg_coordoperation',10403,7302,'California zone III',''),
(424,'epsg_coordoperation',10404,7302,'California zone IV',''),
(425,'epsg_coordoperation',10405,7302,'California zone V',''),
(426,'epsg_coordoperation',10406,7302,'California zone VI',''),
(427,'epsg_coordoperation',10407,7302,'California zone VII',''),
(428,'epsg_coordoperation',10431,7302,'California zone 1',''),
(429,'epsg_coordoperation',10432,7302,'California zone 2',''),
(430,'epsg_coordoperation',10433,7302,'California zone 3',''),
(431,'epsg_coordoperation',10434,7302,'California zone 4',''),
(432,'epsg_coordoperation',10435,7302,'California zone 5',''),
(433,'epsg_coordoperation',10436,7302,'California zone 6',''),
(434,'epsg_coordoperation',10501,7302,'Colorado North',''),
(435,'epsg_coordoperation',10503,7302,'Colorado South',''),
(436,'epsg_coordoperation',10531,7302,'Colorado North',''),
(437,'epsg_coordoperation',10533,7302,'Colorado South',''),
(438,'epsg_coordoperation',10600,7302,'Connecticut',''),
(439,'epsg_coordoperation',10630,7302,'Connecticut',''),
(440,'epsg_coordoperation',10700,7302,'Delaware',''),
(441,'epsg_coordoperation',10730,7302,'Delaware',''),
(442,'epsg_coordoperation',10901,7302,'Florida East',''),
(443,'epsg_coordoperation',10902,7302,'Florida West',''),
(444,'epsg_coordoperation',10903,7302,'Florida North',''),
(445,'epsg_coordoperation',10931,7302,'Florida East',''),
(446,'epsg_coordoperation',10932,7302,'Florida West',''),
(447,'epsg_coordoperation',10933,7302,'Florida North',''),
(448,'epsg_coordoperation',11001,7302,'Georgia East',''),
(449,'epsg_coordoperation',11002,7302,'Georgia West',''),
(450,'epsg_coordoperation',11031,7302,'Georgia East',''),
(451,'epsg_coordoperation',11032,7302,'Georgia West',''),
(452,'epsg_coordoperation',11101,7302,'Idaho East',''),
(453,'epsg_coordoperation',11102,7302,'Idaho Central',''),
(454,'epsg_coordoperation',11103,7302,'Idaho West',''),
(455,'epsg_coordoperation',11131,7302,'Idaho East',''),
(456,'epsg_coordoperation',11132,7302,'Idaho Central',''),
(457,'epsg_coordoperation',11133,7302,'Idaho West',''),
(458,'epsg_coordoperation',11201,7302,'Illinois East',''),
(459,'epsg_coordoperation',11202,7302,'Illinois West',''),
(460,'epsg_coordoperation',11231,7302,'Illinois East',''),
(461,'epsg_coordoperation',11232,7302,'Illinois West',''),
(462,'epsg_coordoperation',11301,7302,'Indiana East',''),
(463,'epsg_coordoperation',11302,7302,'Indiana West',''),
(464,'epsg_coordoperation',11331,7302,'Indiana East',''),
(465,'epsg_coordoperation',11332,7302,'Indiana West',''),
(466,'epsg_coordoperation',11401,7302,'Iowa North',''),
(467,'epsg_coordoperation',11402,7302,'Iowa South',''),
(468,'epsg_coordoperation',11431,7302,'Iowa North',''),
(469,'epsg_coordoperation',11432,7302,'Iowa South',''),
(470,'epsg_coordoperation',11501,7302,'Kansas North',''),
(471,'epsg_coordoperation',11502,7302,'Kansas South',''),
(472,'epsg_coordoperation',11531,7302,'Kansas North',''),
(473,'epsg_coordoperation',11532,7302,'Kansas South',''),
(474,'epsg_coordoperation',11601,7302,'Kentucky North',''),
(475,'epsg_coordoperation',11602,7302,'Kentucky South',''),
(476,'epsg_coordoperation',11631,7302,'Kentucky North',''),
(477,'epsg_coordoperation',11632,7302,'Kentucky South',''),
(478,'epsg_coordoperation',11701,7302,'Louisiana North',''),
(479,'epsg_coordoperation',11702,7302,'Louisiana South',''),
(480,'epsg_coordoperation',11731,7302,'Louisiana North',''),
(481,'epsg_coordoperation',11732,7302,'Louisiana South',''),
(482,'epsg_coordoperation',11801,7302,'Maine East',''),
(483,'epsg_coordoperation',11802,7302,'Maine West',''),
(484,'epsg_coordoperation',11831,7302,'Maine East',''),
(485,'epsg_coordoperation',11832,7302,'Maine West',''),
(486,'epsg_coordoperation',11900,7302,'Maryland',''),
(487,'epsg_coordoperation',11930,7302,'Maryland',''),
(488,'epsg_coordoperation',12001,7302,'Massachusetts Mainland',''),
(489,'epsg_coordoperation',12002,7302,'Massachusetts Island',''),
(490,'epsg_coordoperation',12031,7302,'Massachusetts Mainland',''),
(491,'epsg_coordoperation',12032,7302,'Massachusetts Island',''),
(492,'epsg_coordoperation',12101,7302,'Michigan East',''),
(493,'epsg_coordoperation',12102,7302,'Michigan Old Central',''),
(494,'epsg_coordoperation',12111,7302,'Michigan North',''),
(495,'epsg_coordoperation',12112,7302,'Michigan Central',''),
(496,'epsg_coordoperation',12113,7302,'Michigan South',''),
(497,'epsg_coordoperation',12141,7302,'Michigan North',''),
(498,'epsg_coordoperation',12142,7302,'Michigan Central',''),
(499,'epsg_coordoperation',12143,7302,'Michigan South',''),
(500,'epsg_coordoperation',12201,7302,'Minnesota North',''),
(501,'epsg_coordoperation',12202,7302,'Minnesota Central',''),
(502,'epsg_coordoperation',12203,7302,'Minnesota South',''),
(503,'epsg_coordoperation',12231,7302,'Minnesota North',''),
(504,'epsg_coordoperation',12232,7302,'Minnesota Central',''),
(505,'epsg_coordoperation',12233,7302,'Minnesota South',''),
(506,'epsg_coordoperation',12301,7302,'Mississippi East',''),
(507,'epsg_coordoperation',12302,7302,'Mississippi West',''),
(508,'epsg_coordoperation',12331,7302,'Mississippi East',''),
(509,'epsg_coordoperation',12332,7302,'Mississippi West',''),
(510,'epsg_coordoperation',12401,7302,'Missouri  East',''),
(511,'epsg_coordoperation',12402,7302,'Missouri Central',''),
(512,'epsg_coordoperation',12403,7302,'Missouri West',''),
(513,'epsg_coordoperation',12431,7302,'Missouri East',''),
(514,'epsg_coordoperation',12432,7302,'Missouri Central',''),
(515,'epsg_coordoperation',12433,7302,'Missouri West',''),
(516,'epsg_coordoperation',12501,7302,'Montana North',''),
(517,'epsg_coordoperation',12502,7302,'Montana Central',''),
(518,'epsg_coordoperation',12503,7302,'Montana South',''),
(519,'epsg_coordoperation',12530,7302,'Montana',''),
(520,'epsg_coordoperation',12601,7302,'Nebraska North',''),
(521,'epsg_coordoperation',12602,7302,'Nebraska South',''),
(522,'epsg_coordoperation',12630,7302,'Nebraska',''),
(523,'epsg_coordoperation',12701,7302,'Nevada  East',''),
(524,'epsg_coordoperation',12702,7302,'Nevada Central',''),
(525,'epsg_coordoperation',12703,7302,'Nevada West',''),
(526,'epsg_coordoperation',12731,7302,'Nevada East',''),
(527,'epsg_coordoperation',12732,7302,'Nevada Central',''),
(528,'epsg_coordoperation',12733,7302,'Nevada West',''),
(529,'epsg_coordoperation',12800,7302,'New Hampshire',''),
(530,'epsg_coordoperation',12830,7302,'New Hampshire',''),
(531,'epsg_coordoperation',12900,7302,'New Jersey',''),
(532,'epsg_coordoperation',12930,7302,'New Jersey',''),
(533,'epsg_coordoperation',13001,7302,'New Mexico East',''),
(534,'epsg_coordoperation',13002,7302,'New Mexico Central',''),
(535,'epsg_coordoperation',13003,7302,'New Mexico West',''),
(536,'epsg_coordoperation',13031,7302,'New Mexico East',''),
(537,'epsg_coordoperation',13032,7302,'New Mexico Central',''),
(538,'epsg_coordoperation',13033,7302,'New Mexico West',''),
(539,'epsg_coordoperation',13101,7302,'New York East',''),
(540,'epsg_coordoperation',13102,7302,'New York Central',''),
(541,'epsg_coordoperation',13103,7302,'New York  West',''),
(542,'epsg_coordoperation',13104,7302,'New York Long Island',''),
(543,'epsg_coordoperation',13131,7302,'New York East',''),
(544,'epsg_coordoperation',13132,7302,'New York Central',''),
(545,'epsg_coordoperation',13133,7302,'New York  West',''),
(546,'epsg_coordoperation',13134,7302,'New York Long Island',''),
(547,'epsg_coordoperation',13200,7302,'North Carolina',''),
(548,'epsg_coordoperation',13230,7302,'North Carolina',''),
(549,'epsg_coordoperation',13301,7302,'North Dakota North',''),
(550,'epsg_coordoperation',13302,7302,'North Dakota South',''),
(551,'epsg_coordoperation',13331,7302,'North Dakota North',''),
(552,'epsg_coordoperation',13332,7302,'North Dakota South',''),
(553,'epsg_coordoperation',13401,7302,'Ohio North',''),
(554,'epsg_coordoperation',13402,7302,'Ohio South',''),
(555,'epsg_coordoperation',13431,7302,'Ohio North',''),
(556,'epsg_coordoperation',13432,7302,'Ohio South',''),
(557,'epsg_coordoperation',13501,7302,'Oklahoma North',''),
(558,'epsg_coordoperation',13502,7302,'Oklahoma South',''),
(559,'epsg_coordoperation',13531,7302,'Oklahoma North',''),
(560,'epsg_coordoperation',13532,7302,'Oklahoma South',''),
(561,'epsg_coordoperation',13601,7302,'Oregon North',''),
(562,'epsg_coordoperation',13602,7302,'Oregon South',''),
(563,'epsg_coordoperation',13631,7302,'Oregon North',''),
(564,'epsg_coordoperation',13632,7302,'Oregon South',''),
(565,'epsg_coordoperation',13701,7302,'Pennsylvania North',''),
(566,'epsg_coordoperation',13702,7302,'Pennsylvania South',''),
(567,'epsg_coordoperation',13731,7302,'Pennsylvania North',''),
(568,'epsg_coordoperation',13732,7302,'Pennsylvania South',''),
(569,'epsg_coordoperation',13800,7302,'Rhode Island',''),
(570,'epsg_coordoperation',13830,7302,'Rhode Island',''),
(571,'epsg_coordoperation',13901,7302,'South Carolina North',''),
(572,'epsg_coordoperation',13902,7302,'South Carolina South',''),
(573,'epsg_coordoperation',13930,7302,'South Carolina',''),
(574,'epsg_coordoperation',14001,7302,'South Dakota North',''),
(575,'epsg_coordoperation',14002,7302,'South Dakota South',''),
(576,'epsg_coordoperation',14031,7302,'South Dakota North',''),
(577,'epsg_coordoperation',14032,7302,'South Dakota South',''),
(578,'epsg_coordoperation',14100,7302,'Tennessee',''),
(579,'epsg_coordoperation',14130,7302,'Tennessee',''),
(580,'epsg_coordoperation',14201,7302,'Texas North',''),
(581,'epsg_coordoperation',14202,7302,'Texas North Central',''),
(582,'epsg_coordoperation',14203,7302,'Texas Central',''),
(583,'epsg_coordoperation',14204,7302,'Texas South Central',''),
(584,'epsg_coordoperation',14205,7302,'Texas South',''),
(585,'epsg_coordoperation',14231,7302,'Texas North',''),
(586,'epsg_coordoperation',14232,7302,'Texas North Central',''),
(587,'epsg_coordoperation',14233,7302,'Texas Central',''),
(588,'epsg_coordoperation',14234,7302,'Texas South Central',''),
(589,'epsg_coordoperation',14235,7302,'Texas South',''),
(590,'epsg_coordoperation',14301,7302,'Utah North',''),
(591,'epsg_coordoperation',14302,7302,'Utah Central',''),
(592,'epsg_coordoperation',14303,7302,'Utah South',''),
(593,'epsg_coordoperation',14331,7302,'Utah North',''),
(594,'epsg_coordoperation',14332,7302,'Utah Central',''),
(595,'epsg_coordoperation',14333,7302,'Utah South',''),
(596,'epsg_coordoperation',14400,7302,'Vermont',''),
(597,'epsg_coordoperation',14430,7302,'Vermont',''),
(598,'epsg_coordoperation',14501,7302,'Virginia North',''),
(599,'epsg_coordoperation',14502,7302,'Virginia South',''),
(600,'epsg_coordoperation',14531,7302,'Virginia North',''),
(601,'epsg_coordoperation',14532,7302,'Virginia South',''),
(602,'epsg_coordoperation',14601,7302,'Washington North',''),
(603,'epsg_coordoperation',14602,7302,'Washington South',''),
(604,'epsg_coordoperation',14631,7302,'Washington North',''),
(605,'epsg_coordoperation',14632,7302,'Washington South',''),
(606,'epsg_coordoperation',14701,7302,'West Virginia North',''),
(607,'epsg_coordoperation',14702,7302,'West Virginia South',''),
(608,'epsg_coordoperation',14731,7302,'West Virginia North',''),
(609,'epsg_coordoperation',14732,7302,'West Virginia South',''),
(610,'epsg_coordoperation',14801,7302,'Wisconsin North',''),
(611,'epsg_coordoperation',14802,7302,'Wisconsin Central',''),
(612,'epsg_coordoperation',14803,7302,'Wisconsin South',''),
(613,'epsg_coordoperation',14831,7302,'Wisconsin North',''),
(614,'epsg_coordoperation',14832,7302,'Wisconsin Central',''),
(615,'epsg_coordoperation',14833,7302,'Wisconsin South',''),
(616,'epsg_coordoperation',14901,7302,'Wyoming East',''),
(617,'epsg_coordoperation',14902,7302,'Wyoming East Central',''),
(618,'epsg_coordoperation',14903,7302,'Wyoming West Central',''),
(619,'epsg_coordoperation',14904,7302,'Wyoming West',''),
(620,'epsg_coordoperation',14931,7302,'Wyoming East',''),
(621,'epsg_coordoperation',14932,7302,'Wyoming East Central',''),
(622,'epsg_coordoperation',14933,7302,'Wyoming West Central',''),
(623,'epsg_coordoperation',14934,7302,'Wyoming West',''),
(624,'epsg_coordoperation',15001,7302,'Alaska zone 1',''),
(625,'epsg_coordoperation',15002,7302,'Alaska zone 2',''),
(626,'epsg_coordoperation',15003,7302,'Alaska zone 3',''),
(627,'epsg_coordoperation',15004,7302,'Alaska zone 4',''),
(628,'epsg_coordoperation',15005,7302,'Alaska zone 5',''),
(629,'epsg_coordoperation',15006,7302,'Alaska zone 6',''),
(630,'epsg_coordoperation',15007,7302,'Alaska zone 7',''),
(631,'epsg_coordoperation',15008,7302,'Alaska zone 8',''),
(632,'epsg_coordoperation',15009,7302,'Alaska zone 9',''),
(633,'epsg_coordoperation',15010,7302,'Alaska zone 10',''),
(634,'epsg_coordoperation',15031,7302,'Alaska zone 1',''),
(635,'epsg_coordoperation',15032,7302,'Alaska zone 2',''),
(636,'epsg_coordoperation',15033,7302,'Alaska zone 3',''),
(637,'epsg_coordoperation',15034,7302,'Alaska zone 4',''),
(638,'epsg_coordoperation',15035,7302,'Alaska zone 5',''),
(639,'epsg_coordoperation',15036,7302,'Alaska zone 6',''),
(640,'epsg_coordoperation',15037,7302,'Alaska zone 7',''),
(641,'epsg_coordoperation',15038,7302,'Alaska zone 8',''),
(642,'epsg_coordoperation',15039,7302,'Alaska zone 9',''),
(643,'epsg_coordoperation',15040,7302,'Alaska zone 10',''),
(644,'epsg_coordoperation',15101,7302,'Hawaii  zone 1',''),
(645,'epsg_coordoperation',15102,7302,'Hawaii  zone 2',''),
(646,'epsg_coordoperation',15103,7302,'Hawaii  zone 3',''),
(647,'epsg_coordoperation',15104,7302,'Hawaii  zone 4',''),
(648,'epsg_coordoperation',15105,7302,'Hawaii  zone 5',''),
(649,'epsg_coordoperation',15131,7302,'Hawaii zone 1',''),
(650,'epsg_coordoperation',15132,7302,'Hawaii zone 2',''),
(651,'epsg_coordoperation',15133,7302,'Hawaii zone 3',''),
(652,'epsg_coordoperation',15134,7302,'Hawaii zone 4',''),
(653,'epsg_coordoperation',15135,7302,'Hawaii zone 5',''),
(654,'epsg_coordoperation',15201,7302,'Puerto Rico',''),
(655,'epsg_coordoperation',15202,7302,'St. Croix',''),
(656,'epsg_coordoperation',15230,7302,'Puerto Rico & Virgin Is.',''),
(657,'epsg_coordoperation',15914,7302,'BLM 14N (ftUS)',''),
(658,'epsg_coordoperation',15915,7302,'BLM 15N (ftUS)',''),
(659,'epsg_coordoperation',15916,7302,'BLM 16N (ftUS)',''),
(660,'epsg_coordoperation',15917,7302,'BLM 17N (ftUS)',''),
(661,'epsg_coordoperation',16061,7302,'UPS North',''),
(662,'epsg_coordoperation',16062,7302,'UPS South',''),
(663,'epsg_coordoperation',16261,7302,'3-degree Gauss zone 1',''),
(664,'epsg_coordoperation',16262,7302,'3-degree Gauss zone 2',''),
(665,'epsg_coordoperation',16263,7302,'3-degree Gauss zone 3',''),
(666,'epsg_coordoperation',16264,7302,'3-degree Gauss zone 4',''),
(667,'epsg_coordoperation',16265,7302,'3-degree Gauss zone 5',''),
(668,'epsg_coordoperation',16266,7302,'3-degree Gauss zone 6',''),
(669,'epsg_coordoperation',16267,7302,'3-degree Gauss zone 7',''),
(670,'epsg_coordoperation',16268,7302,'3-degree Gauss zone 8',''),
(671,'epsg_coordoperation',16361,7302,'3-deg Gauss-Kruger 3E',''),
(672,'epsg_coordoperation',16362,7302,'3-deg Gauss-Kruger 6E',''),
(673,'epsg_coordoperation',16363,7302,'3-deg Gauss-Kruger 9E',''),
(674,'epsg_coordoperation',16364,7302,'3-deg Gauss-Kruger 12E',''),
(675,'epsg_coordoperation',16365,7302,'3-deg Gauss-Kruger 15E',''),
(676,'epsg_coordoperation',16366,7302,'3-deg Gauss-Kruger 18E',''),
(677,'epsg_coordoperation',16367,7302,'3-deg Gauss-Kruger 21E',''),
(678,'epsg_coordoperation',16368,7302,'3-deg Gauss-Kruger 24E',''),
(679,'epsg_coordoperation',17348,7302,'MGA zone 48',''),
(680,'epsg_coordoperation',17349,7302,'MGA zone 49',''),
(681,'epsg_coordoperation',17350,7302,'MGA zone 50',''),
(682,'epsg_coordoperation',17351,7302,'MGA zone 51',''),
(683,'epsg_coordoperation',17352,7302,'MGA zone 52',''),
(684,'epsg_coordoperation',17353,7302,'MGA zone 53',''),
(685,'epsg_coordoperation',17354,7302,'MGA zone 54',''),
(686,'epsg_coordoperation',17355,7302,'MGA zone 55',''),
(687,'epsg_coordoperation',17356,7302,'MGA zone 56',''),
(688,'epsg_coordoperation',17357,7302,'MGA zone 57',''),
(689,'epsg_coordoperation',17358,7302,'MGA zone 58',''),
(690,'epsg_coordoperation',17448,7302,'AMG zone 48',''),
(691,'epsg_coordoperation',17449,7302,'AMG zone 49',''),
(692,'epsg_coordoperation',17450,7302,'AMG zone 50',''),
(693,'epsg_coordoperation',17451,7302,'AMG zone 51',''),
(694,'epsg_coordoperation',17452,7302,'AMG zone 52',''),
(695,'epsg_coordoperation',17453,7302,'AMG zone 53',''),
(696,'epsg_coordoperation',17454,7302,'AMG zone 54',''),
(697,'epsg_coordoperation',17455,7302,'AMG zone 55',''),
(698,'epsg_coordoperation',17456,7302,'AMG zone 56',''),
(699,'epsg_coordoperation',17457,7302,'AMG zone 57',''),
(700,'epsg_coordoperation',17458,7302,'AMG zone 58',''),
(701,'epsg_coordoperation',17515,7302,'S. African Grid zone 15',''),
(702,'epsg_coordoperation',17517,7302,'S. African Grid zone 17',''),
(703,'epsg_coordoperation',17519,7302,'S. African Grid zone 19',''),
(704,'epsg_coordoperation',17521,7302,'S. African Grid zone 21',''),
(705,'epsg_coordoperation',17523,7302,'S. African Grid zone 23',''),
(706,'epsg_coordoperation',17525,7302,'S. African Grid zone 25',''),
(707,'epsg_coordoperation',17527,7302,'S. African Grid zone 27',''),
(708,'epsg_coordoperation',17529,7302,'S. African Grid zone 29',''),
(709,'epsg_coordoperation',17531,7302,'S. African Grid zone 31',''),
(710,'epsg_coordoperation',17533,7302,'S. African Grid zone 33',''),
(711,'epsg_coordoperation',17611,7302,'SW African Grid zone 11',''),
(712,'epsg_coordoperation',17613,7302,'SW African Grid zone 13',''),
(713,'epsg_coordoperation',17615,7302,'SW African Grid zone 15',''),
(714,'epsg_coordoperation',17617,7302,'SW African Grid zone 17',''),
(715,'epsg_coordoperation',17619,7302,'SW African Grid zone 19',''),
(716,'epsg_coordoperation',17621,7302,'SW African Grid zone 21',''),
(717,'epsg_coordoperation',17623,7302,'SW African Grid zone 23',''),
(718,'epsg_coordoperation',17625,7302,'SW African Grid zone 25',''),
(719,'epsg_coordoperation',17702,7302,'MTM zone 2',''),
(720,'epsg_coordoperation',17801,7302,'Japan zone I',''),
(721,'epsg_coordoperation',17802,7302,'Japan zone II',''),
(722,'epsg_coordoperation',17803,7302,'Japan zone III',''),
(723,'epsg_coordoperation',17804,7302,'Japan zone IV',''),
(724,'epsg_coordoperation',17805,7302,'Japan zone V',''),
(725,'epsg_coordoperation',17806,7302,'Japan zone VI',''),
(726,'epsg_coordoperation',17807,7302,'Japan zone VII',''),
(727,'epsg_coordoperation',17808,7302,'Japan zone VIII',''),
(728,'epsg_coordoperation',17809,7302,'Japan zone IX',''),
(729,'epsg_coordoperation',17810,7302,'Japan zone X',''),
(730,'epsg_coordoperation',17811,7302,'Japan zone XI',''),
(731,'epsg_coordoperation',17812,7302,'Japan zone XII',''),
(732,'epsg_coordoperation',17813,7302,'Japan zone XIII',''),
(733,'epsg_coordoperation',17814,7302,'Japan zone XIV',''),
(734,'epsg_coordoperation',17815,7302,'Japan zone XV',''),
(735,'epsg_coordoperation',17816,7302,'Japan zone XVI',''),
(736,'epsg_coordoperation',17817,7302,'Japan zone XVII',''),
(737,'epsg_coordoperation',17818,7302,'Japan zone XVIII',''),
(738,'epsg_coordoperation',17901,7302,'Mt Eden Circuit',''),
(739,'epsg_coordoperation',17920,7302,'Mt Pleasant Circuit',''),
(740,'epsg_coordoperation',17924,7302,'Mt Nicholas Circuit',''),
(741,'epsg_coordoperation',17925,7302,'Mt York Circuit',''),
(742,'epsg_coordoperation',17926,7302,'Observation Pt Circuit',''),
(743,'epsg_coordoperation',18031,7302,'Argentina 1',''),
(744,'epsg_coordoperation',18032,7302,'Argentina 2',''),
(745,'epsg_coordoperation',18033,7302,'Argentina 3',''),
(746,'epsg_coordoperation',18034,7302,'Argentina 4',''),
(747,'epsg_coordoperation',18035,7302,'Argentina 5',''),
(748,'epsg_coordoperation',18036,7302,'Argentina 6',''),
(749,'epsg_coordoperation',18037,7302,'Argentina 7',''),
(750,'epsg_coordoperation',18044,7302,'M28',''),
(751,'epsg_coordoperation',18045,7302,'M31',''),
(752,'epsg_coordoperation',18046,7302,'M34',''),
(753,'epsg_coordoperation',18051,7302,'Colombia 3W',''),
(754,'epsg_coordoperation',18052,7302,'Colombia Bogota',''),
(755,'epsg_coordoperation',18053,7302,'Colombia 3E',''),
(756,'epsg_coordoperation',18054,7302,'Colombia 6E',''),
(757,'epsg_coordoperation',18071,7302,'Blue Belt',''),
(758,'epsg_coordoperation',18072,7302,'Red Belt',''),
(759,'epsg_coordoperation',18073,7302,'Purple Belt',''),
(760,'epsg_coordoperation',18074,7302,'Extended Purple Belt',''),
(761,'epsg_coordoperation',18141,7302,'North Island Grid',''),
(762,'epsg_coordoperation',18142,7302,'South Island Grid',''),
(763,'epsg_coordoperation',18193,7302,'Finland zone 3',''),
(764,'epsg_coordoperation',18203,7302,'ICS',''),
(765,'epsg_coordoperation',18204,7302,'ITM',''),
(766,'epsg_coordoperation',18231,7302,'India zone I',''),
(767,'epsg_coordoperation',18232,7302,'India zone IIa',''),
(768,'epsg_coordoperation',18233,7302,'India zone IIIa',''),
(769,'epsg_coordoperation',18234,7302,'India zone IVa',''),
(770,'epsg_coordoperation',18235,7302,'India zone IIb',''),
(771,'epsg_coordoperation',18236,7302,'India zone I',''),
(772,'epsg_coordoperation',18237,7302,'India zone IIa',''),
(773,'epsg_coordoperation',18238,7302,'India zone IIb',''),
(774,'epsg_coordoperation',19900,7302,'Bahrain Grid',''),
(775,'epsg_coordoperation',19905,7302,'NEIEZ',''),
(776,'epsg_coordoperation',19917,7302,'NZMG',''),
(777,'epsg_coordoperation',19922,7302,'LV03',''),
(778,'epsg_coordoperation',19923,7302,'LV03C',''),
(779,'epsg_coordoperation',19928,7302,'KTM',''),
(781,'epsg_coordoperation',19931,7302,'EOV',''),
(782,'epsg_coordoperation',19933,7302,'PEI Stereographic ATS77',''),
(783,'epsg_coordoperation',19935,7302,'R.S.O. Malaya',''),
(784,'epsg_coordoperation',19945,7302,'NB Stereographic ATS77',''),
(785,'epsg_coordoperation',19946,7302,'NB Stereographic NAD83',''),
(786,'epsg_coordoperation',19950,7302,'LV95',''),
(787,'epsg_coordoperation',19951,7302,'Nakhl e Taqi',''),
(788,'epsg_coordoperation',19956,7302,'RSO Borneo (chSe)',''),
(789,'epsg_coordoperation',19957,7302,'RSO Borneo (ftSe)',''),
(790,'epsg_coordoperation',19958,7302,'RSO Borneo (m)',''),
(791,'epsg_coordoperation',19960,7302,'PEI Stereographic NAD83',''),
(792,'epsg_coordoperation',19962,7302,'ITM',''),
(793,'epsg_coordinatereferencesystem',20004,7302,'1995 Coord. Sys. zone 4',''),
(794,'epsg_coordinatereferencesystem',20005,7302,'1995 Coord. Sys. zone 5',''),
(795,'epsg_coordinatereferencesystem',20006,7302,'1995 Coord. Sys. zone 6',''),
(796,'epsg_coordinatereferencesystem',20007,7302,'1995 Coord. Sys. zone 7',''),
(797,'epsg_coordinatereferencesystem',20008,7302,'1995 Coord. Sys. zone 8',''),
(798,'epsg_coordinatereferencesystem',20009,7302,'1995 Coord. Sys. zone 9',''),
(799,'epsg_coordinatereferencesystem',20010,7302,'1995 Coord. Sys. zone 10',''),
(800,'epsg_coordinatereferencesystem',20011,7302,'1995 Coord. Sys. zone 11',''),
(801,'epsg_coordinatereferencesystem',20012,7302,'1995 Coord. Sys. zone 12',''),
(802,'epsg_coordinatereferencesystem',20013,7302,'1995 Coord. Sys. zone 13',''),
(803,'epsg_coordinatereferencesystem',20014,7302,'1995 Coord. Sys. zone 14',''),
(804,'epsg_coordinatereferencesystem',20015,7302,'1995 Coord. Sys. zone 15',''),
(805,'epsg_coordinatereferencesystem',20016,7302,'1995 Coord. Sys. zone 16',''),
(806,'epsg_coordinatereferencesystem',20017,7302,'1995 Coord. Sys. zone 17',''),
(807,'epsg_coordinatereferencesystem',20018,7302,'1995 Coord. Sys. zone 18',''),
(808,'epsg_coordinatereferencesystem',20019,7302,'1995 Coord. Sys. zone 19',''),
(809,'epsg_coordinatereferencesystem',20020,7302,'1995 Coord. Sys. zone 20',''),
(810,'epsg_coordinatereferencesystem',20021,7302,'1995 Coord. Sys. zone 21',''),
(811,'epsg_coordinatereferencesystem',20022,7302,'1995 Coord. Sys. zone 22',''),
(812,'epsg_coordinatereferencesystem',20023,7302,'1995 Coord. Sys. zone 23',''),
(813,'epsg_coordinatereferencesystem',20024,7302,'1995 Coord. Sys. zone 24',''),
(814,'epsg_coordinatereferencesystem',20025,7302,'1995 Coord. Sys. zone 25',''),
(815,'epsg_coordinatereferencesystem',20026,7302,'1995 Coord. Sys. zone 26',''),
(816,'epsg_coordinatereferencesystem',20027,7302,'1995 Coord. Sys. zone 27',''),
(817,'epsg_coordinatereferencesystem',20028,7302,'1995 Coord. Sys. zone 28',''),
(818,'epsg_coordinatereferencesystem',20029,7302,'1995 Coord. Sys. zone 29',''),
(819,'epsg_coordinatereferencesystem',20030,7302,'1995 Coord. Sys. zone 30',''),
(820,'epsg_coordinatereferencesystem',20031,7302,'1995 Coord. Sys. zone 31',''),
(821,'epsg_coordinatereferencesystem',20032,7302,'1995 Coord. Sys. zone 32',''),
(822,'epsg_coordinatereferencesystem',20064,7302,'Pulkovo 1995 / Gauss 4N',''),
(823,'epsg_coordinatereferencesystem',20065,7302,'Pulkovo 1995 / Gauss 5N',''),
(824,'epsg_coordinatereferencesystem',20066,7302,'Pulkovo 1995 / Gauss 6N',''),
(825,'epsg_coordinatereferencesystem',20067,7302,'Pulkovo 1995 / Gauss 7N',''),
(826,'epsg_coordinatereferencesystem',20068,7302,'Pulkovo 1995 / Gauss 8N',''),
(827,'epsg_coordinatereferencesystem',20069,7302,'Pulkovo 1995 / Gauss 9N',''),
(828,'epsg_coordinatereferencesystem',20070,7302,'Pulkovo 1995 / Gauss 10N',''),
(829,'epsg_coordinatereferencesystem',20071,7302,'Pulkovo 1995 / Gauss 11N',''),
(830,'epsg_coordinatereferencesystem',20072,7302,'Pulkovo 1995 / Gauss 12N',''),
(831,'epsg_coordinatereferencesystem',20073,7302,'Pulkovo 1995 / Gauss 13N',''),
(832,'epsg_coordinatereferencesystem',20074,7302,'Pulkovo 1995 / Gauss 14N',''),
(833,'epsg_coordinatereferencesystem',20075,7302,'Pulkovo 1995 / Gauss 15N',''),
(834,'epsg_coordinatereferencesystem',20076,7302,'Pulkovo 1995 / Gauss 16N',''),
(835,'epsg_coordinatereferencesystem',20077,7302,'Pulkovo 1995 / Gauss 17N',''),
(836,'epsg_coordinatereferencesystem',20078,7302,'Pulkovo 1995 / Gauss 18N',''),
(837,'epsg_coordinatereferencesystem',20079,7302,'Pulkovo 1995 / Gauss 19N',''),
(838,'epsg_coordinatereferencesystem',20080,7302,'Pulkovo 1995 / Gauss 20N',''),
(839,'epsg_coordinatereferencesystem',20081,7302,'Pulkovo 1995 / Gauss 21N',''),
(840,'epsg_coordinatereferencesystem',20082,7302,'Pulkovo 1995 / Gauss 22N',''),
(841,'epsg_coordinatereferencesystem',20083,7302,'Pulkovo 1995 / Gauss 23N',''),
(842,'epsg_coordinatereferencesystem',20084,7302,'Pulkovo 1995 / Gauss 24N',''),
(843,'epsg_coordinatereferencesystem',20085,7302,'Pulkovo 1995 / Gauss 25N',''),
(844,'epsg_coordinatereferencesystem',20086,7302,'Pulkovo 1995 / Gauss 26N',''),
(845,'epsg_coordinatereferencesystem',20087,7302,'Pulkovo 1995 / Gauss 27N',''),
(846,'epsg_coordinatereferencesystem',20088,7302,'Pulkovo 1995 / Gauss 28N',''),
(847,'epsg_coordinatereferencesystem',20089,7302,'Pulkovo 1995 / Gauss 29N',''),
(848,'epsg_coordinatereferencesystem',20090,7302,'Pulkovo 1995 / Gauss 30N',''),
(849,'epsg_coordinatereferencesystem',20091,7302,'Pulkovo 1995 / Gauss 31N',''),
(850,'epsg_coordinatereferencesystem',20092,7302,'Pulkovo 1995 / Gauss 32N',''),
(851,'epsg_coordinatereferencesystem',20437,7302,'Ain el Abd / UTM 37N',''),
(852,'epsg_coordinatereferencesystem',20438,7302,'Ain el Abd / UTM 38N',''),
(853,'epsg_coordinatereferencesystem',20439,7302,'Ain el Abd / UTM 39N',''),
(854,'epsg_coordinatereferencesystem',20790,7302,'Lisbon / Portuguese National Grid',''),
(855,'epsg_coordinatereferencesystem',21100,7302,'Batavia / NEIEZ',''),
(856,'epsg_coordinatereferencesystem',21291,7302,'Barbados 1938 / BWI Grid',''),
(857,'epsg_coordinatereferencesystem',21292,7302,'Barbados NationaI Grid',''),
(858,'epsg_coordinatereferencesystem',21413,7302,'Beijing / Gauss zone 13',''),
(859,'epsg_coordinatereferencesystem',21414,7302,'Beijing / Gauss zone 14',''),
(860,'epsg_coordinatereferencesystem',21415,7302,'Beijing / Gauss zone 15',''),
(861,'epsg_coordinatereferencesystem',21416,7302,'Beijing / Gauss zone 16',''),
(862,'epsg_coordinatereferencesystem',21417,7302,'Beijing / Gauss zone 17',''),
(863,'epsg_coordinatereferencesystem',21418,7302,'Beijing / Gauss zone 18',''),
(864,'epsg_coordinatereferencesystem',21419,7302,'Beijing / Gauss zone 19',''),
(865,'epsg_coordinatereferencesystem',21420,7302,'Beijing / Gauss zone 20',''),
(866,'epsg_coordinatereferencesystem',21421,7302,'Beijing / Gauss zone 21',''),
(867,'epsg_coordinatereferencesystem',21422,7302,'Beijing / Gauss zone 22',''),
(868,'epsg_coordinatereferencesystem',21423,7302,'Beijing / Gauss zone 23',''),
(869,'epsg_coordinatereferencesystem',21473,7302,'Beijing / Gauss 13N',''),
(870,'epsg_coordinatereferencesystem',21474,7302,'Beijing / Gauss 14N',''),
(871,'epsg_coordinatereferencesystem',21475,7302,'Beijing / Gauss 15N',''),
(872,'epsg_coordinatereferencesystem',21476,7302,'Beijing / Gauss 16N',''),
(873,'epsg_coordinatereferencesystem',21477,7302,'Beijing / Gauss 17N',''),
(874,'epsg_coordinatereferencesystem',21478,7302,'Beijing / Gauss 18N',''),
(875,'epsg_coordinatereferencesystem',21479,7302,'Beijing / Gauss 19N',''),
(876,'epsg_coordinatereferencesystem',21480,7302,'Beijing / Gauss 20N',''),
(877,'epsg_coordinatereferencesystem',21481,7302,'Beijing / Gauss 21N',''),
(878,'epsg_coordinatereferencesystem',21482,7302,'Beijing / Gauss 22N',''),
(879,'epsg_coordinatereferencesystem',21483,7302,'Beijing / Gauss 23N',''),
(880,'epsg_coordinatereferencesystem',21500,7302,'Belge Lambert 50',''),
(881,'epsg_coordinatereferencesystem',21780,7302,'LV03C',''),
(882,'epsg_coordinatereferencesystem',21781,7302,'LV03',''),
(883,'epsg_coordinatereferencesystem',21891,7302,'Bogota / Colombia 3W',''),
(884,'epsg_coordinatereferencesystem',21892,7302,'Bogota / Colombia Bogota',''),
(885,'epsg_coordinatereferencesystem',21893,7302,'Bogota / Colombia 3E',''),
(886,'epsg_coordinatereferencesystem',21894,7302,'Bogota / Colombia 6E',''),
(887,'epsg_coordinatereferencesystem',22191,7302,'C Inchauspe /Argentina 1',''),
(888,'epsg_coordinatereferencesystem',22192,7302,'C Inchauspe /Argentina 2',''),
(889,'epsg_coordinatereferencesystem',22193,7302,'C Inchauspe /Argentina 3',''),
(890,'epsg_coordinatereferencesystem',22194,7302,'C Inchauspe /Argentina 4',''),
(891,'epsg_coordinatereferencesystem',22195,7302,'C Inchauspe /Argentina 5',''),
(892,'epsg_coordinatereferencesystem',22196,7302,'C Inchauspe /Argentina 6',''),
(893,'epsg_coordinatereferencesystem',22197,7302,'C Inchauspe /Argentina 7',''),
(894,'epsg_coordinatereferencesystem',22275,7302,'South African CS zone 15',''),
(895,'epsg_coordinatereferencesystem',22277,7302,'South African CS zone 17',''),
(896,'epsg_coordinatereferencesystem',22279,7302,'South African CS zone 19',''),
(897,'epsg_coordinatereferencesystem',22281,7302,'South African CS zone 21',''),
(898,'epsg_coordinatereferencesystem',22283,7302,'South African CS zone 23',''),
(899,'epsg_coordinatereferencesystem',22285,7302,'South African CS zone 25',''),
(900,'epsg_coordinatereferencesystem',22287,7302,'South African CS zone 27',''),
(901,'epsg_coordinatereferencesystem',22289,7302,'South African CS zone 29',''),
(902,'epsg_coordinatereferencesystem',22291,7302,'South African CS zone 31',''),
(903,'epsg_coordinatereferencesystem',22293,7302,'South African CS zone 33',''),
(904,'epsg_coordinatereferencesystem',22300,7302,'Tunisia Mining Grid',''),
(905,'epsg_coordinatereferencesystem',22523,7302,'Corrego Alegre / UTM 23S',''),
(906,'epsg_coordinatereferencesystem',22524,7302,'Corrego Alegre / UTM 24S',''),
(907,'epsg_coordinatereferencesystem',22994,7302,'Egypt 1907 / Ext. Purple',''),
(908,'epsg_coordinatereferencesystem',23946,7302,'Indian 1954 / UTM 46N',''),
(909,'epsg_coordinatereferencesystem',23947,7302,'Indian 1954 / UTM 47N',''),
(910,'epsg_coordinatereferencesystem',23948,7302,'Indian 1954 / UTM 48N',''),
(911,'epsg_coordinatereferencesystem',24047,7302,'Indian 1975 / UTM 47N',''),
(912,'epsg_coordinatereferencesystem',24048,7302,'Indian 1975 / UTM 48N',''),
(913,'epsg_coordinatereferencesystem',24100,7302,'Jamaica 1875 / Old Grid',''),
(914,'epsg_coordinatereferencesystem',24200,7302,'JAD69 / Jamaica Grid',''),
(915,'epsg_coordinatereferencesystem',24305,7302,'Kalianpur 37 / UTM 45N',''),
(916,'epsg_coordinatereferencesystem',24306,7302,'Kalianpur 37 / UTM 46N',''),
(917,'epsg_coordinatereferencesystem',24311,7302,'Kalianpur 62 / UTM 41N',''),
(918,'epsg_coordinatereferencesystem',24312,7302,'Kalianpur 62 / UTM 42N',''),
(919,'epsg_coordinatereferencesystem',24313,7302,'Kalianpur 62 / UTM 43N',''),
(920,'epsg_coordinatereferencesystem',24342,7302,'Kalianpur 75 / UTM 42N',''),
(921,'epsg_coordinatereferencesystem',24343,7302,'Kalianpur 75 / UTM 43N',''),
(922,'epsg_coordinatereferencesystem',24344,7302,'Kalianpur 75 / UTM 44N',''),
(923,'epsg_coordinatereferencesystem',24345,7302,'Kalianpur 75 / UTM 45N',''),
(924,'epsg_coordinatereferencesystem',24346,7302,'Kalianpur 75 / UTM 46N',''),
(925,'epsg_coordinatereferencesystem',24347,7302,'Kalianpur 75 / UTM 47N',''),
(926,'epsg_coordinatereferencesystem',24370,7302,'Kalianpur / India 0',''),
(927,'epsg_coordinatereferencesystem',24371,7302,'Kalianpur / India I',''),
(928,'epsg_coordinatereferencesystem',24372,7302,'Kalianpur / India IIa',''),
(929,'epsg_coordinatereferencesystem',24373,7302,'Kalianpur / India III',''),
(930,'epsg_coordinatereferencesystem',24374,7302,'Kalianpur / India IV',''),
(931,'epsg_coordinatereferencesystem',24375,7302,'Kalianpur 37 / India IIb',''),
(932,'epsg_coordinatereferencesystem',24376,7302,'Kalianpur 62 / India I',''),
(933,'epsg_coordinatereferencesystem',24377,7302,'Kalianpur 62 / India IIa',''),
(934,'epsg_coordinatereferencesystem',24378,7302,'Kalianpur 75 / India I',''),
(935,'epsg_coordinatereferencesystem',24379,7302,'Kalianpur 75 / India IIa',''),
(936,'epsg_coordinatereferencesystem',24380,7302,'Kalianpur 75 / India IIb',''),
(937,'epsg_coordinatereferencesystem',24381,7302,'Kalianpur 75 / India III',''),
(938,'epsg_coordinatereferencesystem',24382,7302,'Kalianpur / India IIb',''),
(939,'epsg_coordinatereferencesystem',24383,7302,'Kalianpur 75 / India IV',''),
(940,'epsg_coordinatereferencesystem',24892,7302,'PSAD56 / Peru central',''),
(941,'epsg_coordinatereferencesystem',25000,7302,'Leigon / Ghana Grid',''),
(942,'epsg_coordinatereferencesystem',25391,7302,'Luzon / Philippines I',''),
(943,'epsg_coordinatereferencesystem',25392,7302,'Luzon / Philippines II',''),
(944,'epsg_coordinatereferencesystem',25393,7302,'Luzon / Philippines III',''),
(945,'epsg_coordinatereferencesystem',25394,7302,'Luzon / Philippines IV',''),
(946,'epsg_coordinatereferencesystem',25395,7302,'Luzon / Philippines V',''),
(947,'epsg_coordinatereferencesystem',25700,7302,'Makassar / NEIEZ',''),
(948,'epsg_coordinatereferencesystem',25932,7302,'Malongo 1987 / UTM 32S',''),
(949,'epsg_coordinatereferencesystem',26391,7302,'Minna / Nigeria West',''),
(950,'epsg_coordinatereferencesystem',26393,7302,'Minna / Nigeria East',''),
(951,'epsg_coordinatereferencesystem',26591,7302,'Monte Mario / Italy 1',''),
(952,'epsg_coordinatereferencesystem',26592,7302,'Monte Mario / Italy 2',''),
(953,'epsg_coordinatereferencesystem',26632,7302,'M''poraloko / UTM 32N',''),
(954,'epsg_coordinatereferencesystem',26692,7302,'M''poraloko / UTM 32S',''),
(955,'epsg_coordinatereferencesystem',26741,7302,'NAD27 / California I',''),
(956,'epsg_coordinatereferencesystem',26742,7302,'NAD27 / California II',''),
(957,'epsg_coordinatereferencesystem',26743,7302,'NAD27 / California III',''),
(958,'epsg_coordinatereferencesystem',26744,7302,'NAD27 / California IV',''),
(959,'epsg_coordinatereferencesystem',26745,7302,'NAD27 / California V',''),
(960,'epsg_coordinatereferencesystem',26746,7302,'NAD27 / California VI',''),
(961,'epsg_coordinatereferencesystem',26747,7302,'NAD27 / California VII',''),
(962,'epsg_coordinatereferencesystem',26786,7302,'NAD27 / Massachusetts',''),
(963,'epsg_coordinatereferencesystem',26787,7302,'NAD27 / Massachusetts Is',''),
(964,'epsg_coordinatereferencesystem',26792,7302,'NAD27 / Minnesota Cent.',''),
(965,'epsg_coordinatereferencesystem',26801,7302,'NAD27 / Michigan East',''),
(966,'epsg_coordinatereferencesystem',26802,7302,'NAD27 / Michigan Old Cen',''),
(967,'epsg_coordinatereferencesystem',26803,7302,'NAD27 / Michigan West',''),
(968,'epsg_coordinatereferencesystem',26811,7302,'NAD27 / Michigan North',''),
(969,'epsg_coordinatereferencesystem',26812,7302,'NAD27 / Michigan Central',''),
(970,'epsg_coordinatereferencesystem',26813,7302,'NAD27 / Michigan South',''),
(971,'epsg_coordinatereferencesystem',26941,7302,'NAD83 / California 1',''),
(972,'epsg_coordinatereferencesystem',26942,7302,'NAD83 / California 2',''),
(973,'epsg_coordinatereferencesystem',26943,7302,'NAD83 / California 3',''),
(974,'epsg_coordinatereferencesystem',26944,7302,'NAD83 / California 4',''),
(975,'epsg_coordinatereferencesystem',26945,7302,'NAD83 / California 5',''),
(976,'epsg_coordinatereferencesystem',26946,7302,'NAD83 / California 6',''),
(977,'epsg_coordinatereferencesystem',26986,7302,'NAD83 / Massachusetts',''),
(978,'epsg_coordinatereferencesystem',26987,7302,'NAD83 / Massachusetts Is',''),
(979,'epsg_coordinatereferencesystem',26992,7302,'NAD83 / Minnesota Cent.',''),
(980,'epsg_coordinatereferencesystem',27038,7302,'Nahrwan 1967 / UTM 38N',''),
(981,'epsg_coordinatereferencesystem',27039,7302,'Nahrwan 1967 / UTM 39N',''),
(982,'epsg_coordinatereferencesystem',27040,7302,'Nahrwan 1967 / UTM 40N',''),
(983,'epsg_coordinatereferencesystem',27120,7302,'Naparima 1972 / UTM 20N',''),
(984,'epsg_coordinatereferencesystem',27200,7302,'GD49 / NZ Map Grid',''),
(985,'epsg_coordinatereferencesystem',27391,7302,'NGO 1948 / I',''),
(986,'epsg_coordinatereferencesystem',27392,7302,'NGO 1948 / II',''),
(987,'epsg_coordinatereferencesystem',27393,7302,'NGO 1948 / III',''),
(988,'epsg_coordinatereferencesystem',27394,7302,'NGO 1948 / IV',''),
(989,'epsg_coordinatereferencesystem',27395,7302,'NGO 1948 / V',''),
(990,'epsg_coordinatereferencesystem',27396,7302,'NGO 1948 / VI',''),
(991,'epsg_coordinatereferencesystem',27397,7302,'NGO 1948 / VII',''),
(992,'epsg_coordinatereferencesystem',27398,7302,'NGO 1948 / VIII',''),
(993,'epsg_coordinatereferencesystem',27500,7302,'ATF / Nord de Guerre',''),
(994,'epsg_coordinatereferencesystem',27581,7302,'NTF / France I',''),
(995,'epsg_coordinatereferencesystem',27582,7302,'NTF / France II',''),
(996,'epsg_coordinatereferencesystem',27583,7302,'NTF / France III',''),
(997,'epsg_coordinatereferencesystem',27584,7302,'NTF / France IV',''),
(998,'epsg_coordinatereferencesystem',27591,7302,'NTF / Nord France',''),
(999,'epsg_coordinatereferencesystem',27592,7302,'NTF / Centre France',''),
(1000,'epsg_coordinatereferencesystem',27593,7302,'NTF / Sud France',''),
(1001,'epsg_coordinatereferencesystem',27594,7302,'NTF / Corse',''),
(1002,'epsg_coordinatereferencesystem',27700,7302,'British National Grid',''),
(1003,'epsg_coordinatereferencesystem',28191,7302,'Palestine Grid',''),
(1004,'epsg_coordinatereferencesystem',28192,7302,'Palestine Belt',''),
(1005,'epsg_coordinatereferencesystem',28193,7302,'Israeli CS Grid',''),
(1006,'epsg_coordinatereferencesystem',28232,7302,'Point Noire / UTM 32S',''),
(1007,'epsg_coordinatereferencesystem',28402,7302,'1942 Coord. Sys. zone 2',''),
(1008,'epsg_coordinatereferencesystem',28403,7302,'1942 Coord. Sys. zone 3',''),
(1009,'epsg_coordinatereferencesystem',28404,7302,'1942 Coord. Sys. zone 4',''),
(1010,'epsg_coordinatereferencesystem',28405,7302,'1942 Coord. Sys. zone 5',''),
(1011,'epsg_coordinatereferencesystem',28406,7302,'1942 Coord. Sys. zone 6',''),
(1012,'epsg_coordinatereferencesystem',28407,7302,'1942 Coord. Sys. zone 7',''),
(1013,'epsg_coordinatereferencesystem',28408,7302,'1942 Coord. Sys. zone 8',''),
(1014,'epsg_coordinatereferencesystem',28409,7302,'1942 Coord. Sys. zone 9',''),
(1015,'epsg_coordinatereferencesystem',28410,7302,'1942 Coord. Sys. zone 10',''),
(1016,'epsg_coordinatereferencesystem',28411,7302,'1942 Coord. Sys. zone 11',''),
(1017,'epsg_coordinatereferencesystem',28412,7302,'1942 Coord. Sys. zone 12',''),
(1018,'epsg_coordinatereferencesystem',28413,7302,'1942 Coord. Sys. zone 13',''),
(1019,'epsg_coordinatereferencesystem',28414,7302,'1942 Coord. Sys. zone 14',''),
(1020,'epsg_coordinatereferencesystem',28415,7302,'1942 Coord. Sys. zone 15',''),
(1021,'epsg_coordinatereferencesystem',28416,7302,'1942 Coord. Sys. zone 16',''),
(1022,'epsg_coordinatereferencesystem',28417,7302,'1942 Coord. Sys. zone 17',''),
(1023,'epsg_coordinatereferencesystem',28418,7302,'1942 Coord. Sys. zone 18',''),
(1024,'epsg_coordinatereferencesystem',28419,7302,'1942 Coord. Sys. zone 19',''),
(1025,'epsg_coordinatereferencesystem',28420,7302,'1942 Coord. Sys. zone 20',''),
(1026,'epsg_coordinatereferencesystem',28421,7302,'1942 Coord. Sys. zone 21',''),
(1027,'epsg_coordinatereferencesystem',28422,7302,'1942 Coord. Sys. zone 22',''),
(1028,'epsg_coordinatereferencesystem',28423,7302,'1942 Coord. Sys. zone 23',''),
(1029,'epsg_coordinatereferencesystem',28424,7302,'1942 Coord. Sys. zone 24',''),
(1030,'epsg_coordinatereferencesystem',28425,7302,'1942 Coord. Sys. zone 25',''),
(1031,'epsg_coordinatereferencesystem',28426,7302,'1942 Coord. Sys. zone 26',''),
(1032,'epsg_coordinatereferencesystem',28427,7302,'1942 Coord. Sys. zone 27',''),
(1033,'epsg_coordinatereferencesystem',28428,7302,'1942 Coord. Sys. zone 28',''),
(1034,'epsg_coordinatereferencesystem',28429,7302,'1942 Coord. Sys. zone 29',''),
(1035,'epsg_coordinatereferencesystem',28430,7302,'1942 Coord. Sys. zone 30',''),
(1036,'epsg_coordinatereferencesystem',28431,7302,'1942 Coord. Sys. zone 31',''),
(1037,'epsg_coordinatereferencesystem',28432,7302,'1942 Coord. Sys. zone 32',''),
(1038,'epsg_coordinatereferencesystem',28462,7302,'Pulkovo / Gauss 2N',''),
(1039,'epsg_coordinatereferencesystem',28463,7302,'Pulkovo / Gauss 3N',''),
(1040,'epsg_coordinatereferencesystem',28464,7302,'Pulkovo / Gauss 4N',''),
(1041,'epsg_coordinatereferencesystem',28465,7302,'Pulkovo / Gauss 5N',''),
(1042,'epsg_coordinatereferencesystem',28466,7302,'Pulkovo / Gauss 6N',''),
(1043,'epsg_coordinatereferencesystem',28467,7302,'Pulkovo / Gauss 7N',''),
(1044,'epsg_coordinatereferencesystem',28468,7302,'Pulkovo / Gauss 8N',''),
(1045,'epsg_coordinatereferencesystem',28469,7302,'Pulkovo / Gauss 9N',''),
(1046,'epsg_coordinatereferencesystem',28470,7302,'Pulkovo / Gauss 10N',''),
(1047,'epsg_coordinatereferencesystem',28471,7302,'Pulkovo / Gauss 11N',''),
(1048,'epsg_coordinatereferencesystem',28472,7302,'Pulkovo / Gauss 12N',''),
(1049,'epsg_coordinatereferencesystem',28473,7302,'Pulkovo / Gauss 13N',''),
(1050,'epsg_coordinatereferencesystem',28474,7302,'Pulkovo / Gauss 14N',''),
(1051,'epsg_coordinatereferencesystem',28475,7302,'Pulkovo / Gauss 15N',''),
(1052,'epsg_coordinatereferencesystem',28476,7302,'Pulkovo / Gauss 16N',''),
(1053,'epsg_coordinatereferencesystem',28477,7302,'Pulkovo / Gauss 17N',''),
(1054,'epsg_coordinatereferencesystem',28478,7302,'Pulkovo / Gauss 18N',''),
(1055,'epsg_coordinatereferencesystem',28479,7302,'Pulkovo / Gauss 19N',''),
(1056,'epsg_coordinatereferencesystem',28480,7302,'Pulkovo / Gauss 20N',''),
(1057,'epsg_coordinatereferencesystem',28481,7302,'Pulkovo / Gauss 21N',''),
(1058,'epsg_coordinatereferencesystem',28482,7302,'Pulkovo / Gauss 22N',''),
(1059,'epsg_coordinatereferencesystem',28483,7302,'Pulkovo / Gauss 23N',''),
(1060,'epsg_coordinatereferencesystem',28484,7302,'Pulkovo / Gauss 24N',''),
(1061,'epsg_coordinatereferencesystem',28485,7302,'Pulkovo / Gauss 25N',''),
(1062,'epsg_coordinatereferencesystem',28486,7302,'Pulkovo / Gauss 26N',''),
(1063,'epsg_coordinatereferencesystem',28487,7302,'Pulkovo / Gauss 27N',''),
(1064,'epsg_coordinatereferencesystem',28488,7302,'Pulkovo / Gauss 28N',''),
(1065,'epsg_coordinatereferencesystem',28489,7302,'Pulkovo / Gauss 29N',''),
(1066,'epsg_coordinatereferencesystem',28490,7302,'Pulkovo / Gauss 30N',''),
(1067,'epsg_coordinatereferencesystem',28491,7302,'Pulkovo / Gauss 31N',''),
(1068,'epsg_coordinatereferencesystem',28492,7302,'Pulkovo / Gauss 32N',''),
(1069,'epsg_coordinatereferencesystem',28600,7302,'Qatar National Grid',''),
(1070,'epsg_coordinatereferencesystem',29220,7302,'Sapper Hill / UTM 20S',''),
(1071,'epsg_coordinatereferencesystem',29221,7302,'Sapper Hill / UTM 21S',''),
(1072,'epsg_coordinatereferencesystem',29333,7302,'Schwarzeck / UTM 33S',''),
(1073,'epsg_coordinatereferencesystem',29371,7302,'SW African CS zone 11',''),
(1074,'epsg_coordinatereferencesystem',29373,7302,'SW African CS zone 13',''),
(1075,'epsg_coordinatereferencesystem',29375,7302,'SW African CS zone 15',''),
(1076,'epsg_coordinatereferencesystem',29377,7302,'SW African CS zone 17',''),
(1077,'epsg_coordinatereferencesystem',29379,7302,'SW African CS zone 19',''),
(1078,'epsg_coordinatereferencesystem',29381,7302,'SW African CS zone 21',''),
(1079,'epsg_coordinatereferencesystem',29383,7302,'SW African CS zone 23',''),
(1080,'epsg_coordinatereferencesystem',29385,7302,'SW African CS zone 25',''),
(1081,'epsg_coordinatereferencesystem',29700,7302,'Tananarive  / Laborde',''),
(1082,'epsg_coordinatereferencesystem',29738,7302,'Tananarive / UTM 38S',''),
(1083,'epsg_coordinatereferencesystem',29739,7302,'Tananarive / UTM 39S',''),
(1084,'epsg_coordinatereferencesystem',29849,7302,'Timbalai 1948 / UTM 49N',''),
(1085,'epsg_coordinatereferencesystem',29850,7302,'Timbalai 1948 / UTM 50N',''),
(1086,'epsg_coordinatereferencesystem',29871,7302,'Timbalai  / Borneo (ch)',''),
(1087,'epsg_coordinatereferencesystem',29872,7302,'Timbalai  / Borneo (ft)',''),
(1088,'epsg_coordinatereferencesystem',29873,7302,'Timbalai  / Borneo (m)',''),
(1089,'epsg_coordinatereferencesystem',29900,7302,'TM65 / Irish Nat Grid',''),
(1090,'epsg_coordinatereferencesystem',30161,7302,'Tokyo / Japan zone I',''),
(1091,'epsg_coordinatereferencesystem',30162,7302,'Tokyo / Japan zone II',''),
(1092,'epsg_coordinatereferencesystem',30163,7302,'Tokyo / Japan zone III',''),
(1093,'epsg_coordinatereferencesystem',30164,7302,'Tokyo / Japan zone IV',''),
(1094,'epsg_coordinatereferencesystem',30165,7302,'Tokyo / Japan zone V',''),
(1095,'epsg_coordinatereferencesystem',30166,7302,'Tokyo / Japan zone VI',''),
(1096,'epsg_coordinatereferencesystem',30167,7302,'Tokyo / Japan zone VII',''),
(1097,'epsg_coordinatereferencesystem',30168,7302,'Tokyo / Japan zone VIII',''),
(1098,'epsg_coordinatereferencesystem',30169,7302,'Tokyo / Japan zone IX',''),
(1099,'epsg_coordinatereferencesystem',30170,7302,'Tokyo / Japan zone X',''),
(1100,'epsg_coordinatereferencesystem',30171,7302,'Tokyo / Japan zone XI',''),
(1101,'epsg_coordinatereferencesystem',30172,7302,'Tokyo / Japan zone XII',''),
(1102,'epsg_coordinatereferencesystem',30173,7302,'Tokyo / Japan zone XIII',''),
(1103,'epsg_coordinatereferencesystem',30174,7302,'Tokyo / Japan zone XIV',''),
(1104,'epsg_coordinatereferencesystem',30175,7302,'Tokyo / Japan zone XV',''),
(1105,'epsg_coordinatereferencesystem',30176,7302,'Tokyo / Japan zone XVI',''),
(1106,'epsg_coordinatereferencesystem',30177,7302,'Tokyo / Japan zone XVII',''),
(1107,'epsg_coordinatereferencesystem',30178,7302,'Tokyo / Japan zone XVIII',''),
(1108,'epsg_coordinatereferencesystem',30200,7302,'Trinidad 1903 / Trinidad',''),
(1109,'epsg_coordinatereferencesystem',30491,7302,'Voirol /N Algerie ancien',''),
(1110,'epsg_coordinatereferencesystem',30492,7302,'Voirol /S Algerie ancien',''),
(1111,'epsg_coordinatereferencesystem',30729,7302,'Nord Sahara / UTM 29N',''),
(1112,'epsg_coordinatereferencesystem',30730,7302,'Nord Sahara / UTM 30N',''),
(1113,'epsg_coordinatereferencesystem',30731,7302,'Nord Sahara / UTM 31N',''),
(1114,'epsg_coordinatereferencesystem',30732,7302,'Nord Sahara / UTM 32N',''),
(1115,'epsg_coordinatereferencesystem',30791,7302,'Nord Sahara / N Algerie',''),
(1116,'epsg_coordinatereferencesystem',30792,7302,'Nord Sahara / S Algerie',''),
(1117,'epsg_coordinatereferencesystem',31265,7302,'MGI / Gauss zone 5',''),
(1118,'epsg_coordinatereferencesystem',31266,7302,'MGI / Gauss zone 6',''),
(1119,'epsg_coordinatereferencesystem',31267,7302,'MGI / Gauss zone 7',''),
(1120,'epsg_coordinatereferencesystem',31268,7302,'MGI / Gauss zone 8',''),
(1121,'epsg_coordinatereferencesystem',31291,7302,'MGI / Austria West',''),
(1122,'epsg_coordinatereferencesystem',31292,7302,'MGI / Austria Central',''),
(1123,'epsg_coordinatereferencesystem',31293,7302,'MGI / Austria East',''),
(1124,'epsg_coordinatereferencesystem',31370,7302,'BD 72 / Lambert 72',''),
(1125,'epsg_coordinatereferencesystem',31461,7302,'DHDN / Gauss zone 1',''),
(1126,'epsg_coordinatereferencesystem',31462,7302,'DHDN / Gauss zone 2',''),
(1127,'epsg_coordinatereferencesystem',31463,7302,'DHDN / Gauss zone 3',''),
(1128,'epsg_coordinatereferencesystem',31464,7302,'DHDN / Gauss zone 4',''),
(1129,'epsg_coordinatereferencesystem',31465,7302,'DHDN / Gauss zone 5',''),
(1130,'epsg_coordinatereferencesystem',31600,7302,'Stereo 33',''),
(1131,'epsg_coordinatereferencesystem',31700,7302,'Stereo 70',''),
(1132,'epsg_coordinatereferencesystem',32013,7302,'NAD27 / New Mexico Cent.',''),
(1133,'epsg_coordinatereferencesystem',32018,7302,'NAD27 / New York Long Is',''),
(1134,'epsg_coordinatereferencesystem',32020,7302,'NAD27 / North Dakota N',''),
(1135,'epsg_coordinatereferencesystem',32021,7302,'NAD27 / North Dakota S',''),
(1136,'epsg_coordinatereferencesystem',32028,7302,'NAD27 / Pennsylvania N',''),
(1137,'epsg_coordinatereferencesystem',32029,7302,'NAD27 / Pennsylvania S',''),
(1138,'epsg_coordinatereferencesystem',32031,7302,'NAD27 / South Carolina N',''),
(1139,'epsg_coordinatereferencesystem',32033,7302,'NAD27 / South Carolina S',''),
(1140,'epsg_coordinatereferencesystem',32034,7302,'NAD27 / South Dakota N',''),
(1141,'epsg_coordinatereferencesystem',32035,7302,'NAD27 / South Dakota S',''),
(1142,'epsg_coordinatereferencesystem',32038,7302,'NAD27 / Texas North Cen.',''),
(1143,'epsg_coordinatereferencesystem',32040,7302,'NAD27 / Texas South Cen.',''),
(1144,'epsg_coordinatereferencesystem',32050,7302,'NAD27 / West Virginia N',''),
(1145,'epsg_coordinatereferencesystem',32051,7302,'NAD27 / West Virginia S',''),
(1146,'epsg_coordinatereferencesystem',32053,7302,'NAD27 / Wisconsin Cen.',''),
(1147,'epsg_coordinatereferencesystem',32056,7302,'NAD27 / Wyoming E. Cen.',''),
(1148,'epsg_coordinatereferencesystem',32057,7302,'NAD27 / Wyoming W. Cen.',''),
(1149,'epsg_coordinatereferencesystem',32113,7302,'NAD83 / New Mexico Cent.',''),
(1150,'epsg_coordinatereferencesystem',32118,7302,'NAD83 / New York Long Is',''),
(1151,'epsg_coordinatereferencesystem',32120,7302,'NAD83 / North Dakota N',''),
(1152,'epsg_coordinatereferencesystem',32121,7302,'NAD83 / North Dakota S',''),
(1153,'epsg_coordinatereferencesystem',32128,7302,'NAD83 / Pennsylvania N',''),
(1154,'epsg_coordinatereferencesystem',32129,7302,'NAD83 / Pennsylvania S',''),
(1155,'epsg_coordinatereferencesystem',32134,7302,'NAD83 / South Dakota N',''),
(1156,'epsg_coordinatereferencesystem',32135,7302,'NAD83 / South Dakota S',''),
(1157,'epsg_coordinatereferencesystem',32138,7302,'NAD83 / Texas North Cen.',''),
(1158,'epsg_coordinatereferencesystem',32140,7302,'NAD83 / Texas South Cen.',''),
(1159,'epsg_coordinatereferencesystem',32150,7302,'NAD83 / West Virginia N',''),
(1160,'epsg_coordinatereferencesystem',32151,7302,'NAD83 / West Virginia S',''),
(1161,'epsg_coordinatereferencesystem',32153,7302,'NAD83 / Wisconsin Cen.',''),
(1162,'epsg_coordinatereferencesystem',32156,7302,'NAD83 / Wyoming E. Cen.',''),
(1163,'epsg_coordinatereferencesystem',32157,7302,'NAD83 / Wyoming W. Cen.',''),
(1164,'epsg_unitofmeasure',9001,7306,'m',''),
(1165,'epsg_unitofmeasure',9002,7306,'ft',''),
(1166,'epsg_unitofmeasure',9003,7306,'ftUS',''),
(1167,'epsg_unitofmeasure',9005,7306,'ftCla',''),
(1168,'epsg_unitofmeasure',9014,7306,'fathom',''),
(1169,'epsg_unitofmeasure',9030,7306,'nautmi',''),
(1170,'epsg_unitofmeasure',9031,7306,'mGer',''),
(1171,'epsg_unitofmeasure',9033,7306,'chUS',''),
(1172,'epsg_unitofmeasure',9034,7306,'lkUS',''),
(1173,'epsg_unitofmeasure',9035,7306,'miUS',''),
(1174,'epsg_unitofmeasure',9036,7306,'km',''),
(1175,'epsg_unitofmeasure',9037,7306,'ydCla',''),
(1176,'epsg_unitofmeasure',9038,7306,'chCla',''),
(1177,'epsg_unitofmeasure',9039,7306,'lkCla',''),
(1178,'epsg_unitofmeasure',9040,7306,'ydSe',''),
(1179,'epsg_unitofmeasure',9041,7306,'ftSe',''),
(1180,'epsg_unitofmeasure',9042,7306,'chSe',''),
(1181,'epsg_unitofmeasure',9043,7306,'lkSe',''),
(1182,'epsg_unitofmeasure',9050,7306,'ydBnA',''),
(1183,'epsg_unitofmeasure',9051,7306,'ftBnA',''),
(1184,'epsg_unitofmeasure',9052,7306,'chBnA',''),
(1185,'epsg_unitofmeasure',9053,7306,'lkBnA',''),
(1186,'epsg_unitofmeasure',9060,7306,'ydBnB',''),
(1187,'epsg_unitofmeasure',9061,7306,'ftBnB',''),
(1188,'epsg_unitofmeasure',9062,7306,'chBnB',''),
(1189,'epsg_unitofmeasure',9063,7306,'lkBnB',''),
(1190,'epsg_unitofmeasure',9070,7306,'ftBr(65)',''),
(1191,'epsg_unitofmeasure',9080,7306,'ftInd',''),
(1192,'epsg_unitofmeasure',9081,7306,'ftInd(37)',''),
(1193,'epsg_unitofmeasure',9082,7306,'ftInd(62)',''),
(1194,'epsg_unitofmeasure',9083,7306,'ftInd(75)',''),
(1195,'epsg_unitofmeasure',9084,7306,'ydInd',''),
(1196,'epsg_unitofmeasure',9085,7306,'ydInd(37)',''),
(1197,'epsg_unitofmeasure',9086,7306,'ydInd(62)',''),
(1198,'epsg_unitofmeasure',9087,7306,'ydInd(75)',''),
(1199,'epsg_unitofmeasure',9093,7306,'mi',''),
(1200,'epsg_unitofmeasure',9094,7306,'ftGC',''),
(1201,'epsg_unitofmeasure',9101,7306,'rad',''),
(1202,'epsg_unitofmeasure',9102,7306,'dega',''),
(1203,'epsg_unitofmeasure',9103,7306,'mina',''),
(1204,'epsg_unitofmeasure',9104,7306,'seca',''),
(1205,'epsg_unitofmeasure',9105,7306,'gr',''),
(1206,'epsg_unitofmeasure',9106,7306,'gon',''),
(1207,'epsg_unitofmeasure',9107,7306,'dega',''),
(1208,'epsg_unitofmeasure',9108,7306,'dega',''),
(1209,'epsg_unitofmeasure',9109,7306,'urad',''),
(1210,'epsg_unitofmeasure',9110,7306,'dega',''),
(1211,'epsg_unitofmeasure',9111,7306,'dega',''),
(1212,'epsg_unitofmeasure',9112,7306,'cgr',''),
(1213,'epsg_unitofmeasure',9113,7306,'ccgr',''),
(1214,'epsg_unitofmeasure',9114,7306,'mila',''),
(1215,'epsg_coordoperationmethod',9824,7302,'UTM grid system',''),
(1216,'epsg_coordinatereferencesystem',4143,7301,'C\ufffd\ufffd\ufffdte D''Ivoire','Same alias also applied to Locodjo 1965 (code 4142).'),
(1217,'epsg_coordinatereferencesystem',4143,7301,'Port Bouet','Same alias also applied to Locodjo 1965 (code 4142).'),
(1218,'epsg_coordinatereferencesystem',4142,7301,'Port Bouet','Same alias also applied to Abidjan 1987 (code 4143).'),
(1219,'epsg_coordinatereferencesystem',4142,7301,'C\ufffd\ufffd\ufffdte D''Ivoire','Same alias also applied to Abidjan 1987 (code 4143).'),
(1220,'epsg_coordinatereferencesystem',2164,7301,'Cote d''Ivoire / TM 5 NW','Same alias used for Abidjan 1987 / TM 5 NW (code 2165).'),
(1221,'epsg_coordinatereferencesystem',2164,7301,'Port Bouet / TM 5 NW','Same alias used for Abidjan 1987 / TM 5 NW (code 2165).'),
(1222,'epsg_coordinatereferencesystem',2165,7301,'Cote d''Ivoire / TM 5 NW','Same alias used for Locodjo 1965 / TM 5 NW (code 2164).'),
(1223,'epsg_coordinatereferencesystem',2165,7301,'Port Bouet / TM 5 NW','Same alias used for Abidjan 1987 / TM 5 NW (code 2165).'),
(1224,'epsg_coordoperation',1588,7301,'ED50 to EUREF89 (1)',''),
(1225,'epsg_coordoperation',1588,7301,'ED50 to ETRF89 (1)',''),
(1227,'epsg_coordoperation',1589,7301,'ED50 to EUREF89 (3)',''),
(1229,'epsg_datum',6181,7301,'LUREF',''),
(1230,'epsg_datum',6180,7302,'EST97',''),
(1231,'epsg_datum',6179,7301,'42/58',''),
(1232,'epsg_datum',6178,7301,'42/83',''),
(1233,'epsg_datum',6312,7308,'HR1901',''),
(1234,'epsg_datum',6312,7309,'D48',''),
(1235,'epsg_coordoperationmethod',9807,7301,'Gauss-Kruger',''),
(1236,'epsg_coordoperationmethod',9807,7302,'TM',''),
(1237,'epsg_datum',6818,7301,'Jednotn\ufffd\ufffd\ufffd Trigonometrick\ufffd\ufffd\ufffd S\ufffd\ufffd\ufffdte Katastr\ufffd\ufffd\ufffdln\ufffd\ufffd\ufffd (Ferro)',''),
(1238,'epsg_coordinatereferencesystem',2393,7301,'KKJ / Basic Coordinate System zone 3',''),
(1239,'epsg_coordinatereferencesystem',2391,7301,'KKJ / Basic Coordinate System zone 1',''),
(1240,'epsg_coordinatereferencesystem',2392,7301,'KKJ / Basic Coordinate System zone 2',''),
(1241,'epsg_coordinatereferencesystem',2394,7301,'KKJ / Basic Coordinate System zone 4',''),
(1242,'epsg_coordinatereferencesystem',31467,7301,'DHDN / 3-degree Gauss-Kruger zone 3',''),
(1243,'epsg_coordinatereferencesystem',31468,7301,'DHDN / 3-degree Gauss-Kruger zone 4',''),
(1244,'epsg_coordinatereferencesystem',31469,7301,'DHDN / 3-degree Gauss-Kruger zone 5',''),
(1247,'epsg_coordinatereferencesystem',4178,7301,'42/83',''),
(1248,'epsg_coordinatereferencesystem',31466,7301,'DHDN / 3-degree Gauss-Kruger zone 2',''),
(1249,'epsg_coordinatereferencesystem',2166,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3',''),
(1250,'epsg_coordinatereferencesystem',2167,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4',''),
(1251,'epsg_coordinatereferencesystem',4181,7301,'LUREF',''),
(1253,'epsg_coordinatereferencesystem',4258,7301,'EUREF89',''),
(1254,'epsg_coordinatereferencesystem',2180,7301,'EUREF89 / CS92',''),
(1255,'epsg_coordinatereferencesystem',4312,7308,'HR1901',''),
(1256,'epsg_coordinatereferencesystem',4312,7309,'D48',''),
(1257,'epsg_coordinatereferencesystem',4805,7308,'HR1901 (Ferro)',''),
(1258,'epsg_coordinatereferencesystem',4805,7309,'D48 (Ferro)',''),
(1259,'epsg_coordinatereferencesystem',31275,7308,'HDKS zone 5','HDKS = Hrvatski Drzavni Koordinatni Sustav'),
(1260,'epsg_coordinatereferencesystem',31276,7308,'HDKS zone 6','HDKS = Hrvatski Drzavni Koordinatni Sustav'),
(1261,'epsg_coordinatereferencesystem',31275,7309,'D48 zone 5',''),
(1262,'epsg_coordinatereferencesystem',2169,7301,'LUREF / Gauss',''),
(1263,'epsg_coordinatereferencesystem',3396,7301,'DHDN / Gauss-Kruger zone 3','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(1264,'epsg_coordinatereferencesystem',3397,7301,'DHDN / Gauss-Kruger zone 4','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(1265,'epsg_coordinatereferencesystem',3398,7301,'DHDN / Gauss-Kruger zone 4','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(1266,'epsg_coordinatereferencesystem',3399,7301,'DHDN / Gauss-Kruger zone 5','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(1267,'epsg_coordoperation',1620,7308,'HR1901 to ETRS89 (2)',''),
(1268,'epsg_coordoperation',1619,7307,'AT_MGI to ETRS89','EuroGeographics quote this transformation with reduced precision to the translation and scale differenve parameter values.'),
(1269,'epsg_coordoperation',1622,7307,'CZ_S-JTSK to ETRS89',''),
(1270,'epsg_coordoperation',1620,7307,'HR_HDKS to ETRS89',''),
(1271,'epsg_coordoperation',1624,7307,'SK_S-JTSK to ETRS89',''),
(1272,'epsg_coordoperation',1626,7307,'DK_ED50 to ETRS89',''),
(1273,'epsg_coordoperation',1628,7307,'GI_ED50 to ETRS89',''),
(1274,'epsg_coordoperation',1630,7307,'ES_ED50 (BAL99) to ETRS89',''),
(1275,'epsg_coordoperation',1632,7307,'ES_ED50 (EST99) to ETRS89',''),
(1276,'epsg_coordoperation',1634,7307,'ES_ED50 (ZNW99) to ETRS89',''),
(1277,'epsg_coordoperation',1636,7307,'TR_ED50 to ETRS89',''),
(1278,'epsg_coordoperation',1638,7307,'FI_KKJ to ETRS89',''),
(1279,'epsg_coordoperation',1640,7307,'IE_Ireland65 to ETRS89','IE_Ireland65 to ETRS89 applies to the Republic of Ireland. Also referred to in EuroGeographics as NI_Ireland65 to ETRS89 for Northern Ireland.'),
(1280,'epsg_coordoperation',1642,7307,'LU_LUREF to ETRS89',''),
(1281,'epsg_coordoperation',1644,7307,'PL_42/58 to ETRS89',''),
(1282,'epsg_coordoperation',1646,7307,'CH_CH1903 to ETRS89',''),
(1283,'epsg_coordoperation',1647,7307,'CH_CH1903+ to ETRS89',''),
(1284,'epsg_coordoperation',1648,7307,'EE_L-EST97 to ETRS89',''),
(1285,'epsg_coordoperation',1650,7307,'FR_ED50 to ETRS89',''),
(1286,'epsg_coordoperation',1651,7307,'FR_NTF to ETRS89',''),
(1287,'epsg_coordoperation',1653,7307,'NO_NGO1948 to ETRS89',''),
(1288,'epsg_coordoperation',1657,7307,'PT_D73 to ETRS89',''),
(1289,'epsg_coordoperation',1655,7307,'PT_DLX(HAY) to ETRS89',''),
(1290,'epsg_coordoperation',1652,7307,'BE_BD72 to ETRS89',''),
(1291,'epsg_coordinatereferencesystem',31282,7302,'MGI / Austria Central',''),
(1292,'epsg_coordinatereferencesystem',31283,7302,'MGI / Austria East',''),
(1293,'epsg_coordinatereferencesystem',31281,7302,'MGI / Austria West',''),
(1294,'epsg_datum',6176,7302,'AAD98',''),
(1295,'epsg_coordinatereferencesystem',4176,7302,'AAD98',''),
(1296,'epsg_datum',6167,7302,'NZGD2000',''),
(1297,'epsg_coordinatereferencesystem',2193,7302,'NZGD2000 / NZTM',''),
(1298,'epsg_coordoperation',19971,7302,'NZTM',''),
(1299,'epsg_datum',6186,7302,'S-JTSK',''),
(1300,'epsg_datum',5119,7301,'Nivellement general de la France','This alias is also used for other datum realisations: see NGF - Lallemand (code 5118) and NGF - IGN78 (code 5120).'),
(1301,'epsg_datum',5119,7301,'NGF','This alias is also used for other datum realisations: see NGF - Lallemand (code 5118) and NGF - IGN78 (code 5120).'),
(1302,'epsg_datum',5120,7301,'IGN78',''),
(1303,'epsg_datum',5118,7301,'NGF','This alias is also used for other datum realisations: see NGF - IGN69 (code 5119) and NGF - IGN78 (code 5120).'),
(1304,'epsg_datum',5120,7301,'Nivellement general de la France','This alias is also used for other datum realisations: see NGF - Lallemand (code 5118) and NGF - IGN69 (code 5119).'),
(1305,'epsg_datum',5118,7301,'Nivellement general de la France','This alias is also used for other datum realisations: see NGF - IGN69 (code 5119) and NGF - IGN78 (code 5120).'),
(1306,'epsg_datum',6143,7301,'C\ufffd\ufffd\ufffdte D''Ivoire (Ivory Coast)','This alias is not unique: it is also used for code 6142.'),
(1307,'epsg_datum',6142,7301,'C\ufffd\ufffd\ufffdte D''Ivoire (Ivory Coast)','This alias is not unique: it is also used for code 6143.'),
(1308,'epsg_coordinatereferencesystem',4300,7301,'1975 Mapping Adjustment',''),
(1309,'epsg_coordinatereferencesystem',2196,7301,'EUREF89 / Kp2000 Jutland',''),
(1310,'epsg_coordinatereferencesystem',2196,7301,'System 2000 Jylland zoner',''),
(1311,'epsg_coordinatereferencesystem',2197,7301,'EUREF89 / Kp2000 Zealand',''),
(1312,'epsg_coordinatereferencesystem',2197,7301,'System 2000 Sjaelland zoner',''),
(1313,'epsg_coordinatereferencesystem',2198,7301,'EUREF89 / Kp2000 Bornholm',''),
(1314,'epsg_coordinatereferencesystem',2198,7301,'System 2000 Bornholm zoner',''),
(1315,'epsg_datum',6189,7301,'SIRGAS-REGVEN',''),
(1316,'epsg_datum',6189,7302,'REGVEN',''),
(1317,'epsg_datum',6171,7300,'R\ufffd\ufffd\ufffdseau G\ufffd\ufffd\ufffdod\ufffd\ufffd\ufffdsique Fran\ufffd\ufffd\ufffdais 1993',''),
(1318,'epsg_datum',6172,7300,'Posiciones Geod\ufffd\ufffd\ufffdsicas Argentinas',''),
(1319,'epsg_datum',6186,7300,'Jednotn\ufffd\ufffd\ufffd Trigonometrick\ufffd\ufffd\ufffd S\ufffd\ufffd\ufffdte Katastr\ufffd\ufffd\ufffdln\ufffd\ufffd\ufffd',''),
(1322,'epsg_coordoperation',15304,7302,'Arizona East (ft)',''),
(1323,'epsg_coordoperation',15305,7302,'Arizona Central (ft)',''),
(1324,'epsg_coordoperation',15306,7302,'Arizona West (ft)',''),
(1325,'epsg_coordoperation',15307,7302,'California zone 1 (ftUS)',''),
(1326,'epsg_coordoperation',15308,7302,'California zone 2 (ftUS)',''),
(1327,'epsg_coordoperation',15309,7302,'California zone 3 (ftUS)',''),
(1328,'epsg_coordoperation',15310,7302,'California zone 4 (ftUS)',''),
(1329,'epsg_coordoperation',15311,7302,'California zone 5 (ftUS)',''),
(1330,'epsg_coordoperation',15312,7302,'California zone 6 (ftUS)',''),
(1331,'epsg_coordoperation',15313,7302,'Colorado North (ftUS)',''),
(1332,'epsg_coordoperation',15314,7302,'Colorado Central (ftUS)',''),
(1333,'epsg_coordoperation',15315,7302,'Colorado South (ftUS)',''),
(1334,'epsg_coordoperation',15316,7301,'Connecticut (ft US)',''),
(1335,'epsg_coordoperation',15317,7302,'Delaware (ftUS)',''),
(1336,'epsg_coordoperation',15318,7301,'Florida East (ft US)',''),
(1337,'epsg_coordoperation',15319,7302,'Florida West (ftUS)',''),
(1338,'epsg_coordoperation',15320,7302,'Florida North (ftUS)',''),
(1339,'epsg_coordoperation',15321,7302,'Georgia East (ftUS)',''),
(1340,'epsg_coordoperation',15322,7302,'Georgia West (ftUS)',''),
(1341,'epsg_coordoperation',15323,7302,'Idaho East (ftUS)',''),
(1342,'epsg_coordoperation',15324,7302,'Idaho Central (ftUS)',''),
(1343,'epsg_coordoperation',15325,7302,'Idaho West (ftUS)',''),
(1344,'epsg_coordoperation',15326,7302,'Indiana East (ftUS)',''),
(1345,'epsg_coordoperation',15327,7302,'Indiana West (ftUS)',''),
(1346,'epsg_coordoperation',15328,7302,'Kentucky North (ftUS)',''),
(1347,'epsg_coordoperation',15329,7302,'Kentucky South (ftUS)',''),
(1348,'epsg_coordoperation',15330,7302,'Maryland (ftUS)',''),
(1349,'epsg_coordoperation',15331,7302,'Massachusetts Mainland (ftUS)',''),
(1350,'epsg_coordoperation',15332,7302,'Massachusetts Island (ftUS)',''),
(1351,'epsg_coordoperation',15333,7302,'Michigan North (ft)',''),
(1352,'epsg_coordoperation',15334,7302,'Michigan Central (ft)',''),
(1353,'epsg_coordoperation',15335,7302,'Michigan South (ft)',''),
(1354,'epsg_coordoperation',15336,7302,'Mississippi East (ftUS)',''),
(1355,'epsg_coordoperation',15337,7302,'Mississippi West (ftUS)',''),
(1356,'epsg_coordoperation',15338,7301,'Montana (ftUS)',''),
(1357,'epsg_coordoperation',15339,7302,'New Mexico East (ftUS)',''),
(1358,'epsg_coordoperation',15340,7302,'New Mexico Central (ftUS)',''),
(1359,'epsg_coordoperation',15341,7302,'New Mexico West (ftUS)',''),
(1360,'epsg_coordoperation',15342,7302,'New York East (ftUS)',''),
(1361,'epsg_coordoperation',15343,7302,'New York Central (ftUS)',''),
(1362,'epsg_coordoperation',15344,7302,'New York  West (ftUS)',''),
(1363,'epsg_coordoperation',15345,7302,'New York Long Island (ftUS)',''),
(1364,'epsg_coordoperation',15346,7302,'North Carolina (ftUS)',''),
(1365,'epsg_coordoperation',15347,7302,'North Dakota North (ft)',''),
(1366,'epsg_coordoperation',15348,7302,'North Dakota South (ft)',''),
(1367,'epsg_coordoperation',15349,7302,'Oklahoma North (ftUS)',''),
(1368,'epsg_coordoperation',15350,7302,'Oklahoma South (ftUS)',''),
(1369,'epsg_coordoperation',15351,7302,'Oregon North (ft)',''),
(1370,'epsg_coordoperation',15352,7302,'Oregon South (ft)',''),
(1371,'epsg_coordoperation',15353,7302,'Pennsylvania North (ftUS)',''),
(1372,'epsg_coordoperation',15354,7301,'Pennsylvania South (ftUS)',''),
(1373,'epsg_coordoperation',15355,7302,'South Carolina (ft)',''),
(1374,'epsg_coordoperation',15356,7302,'Tennessee (ftUS)',''),
(1375,'epsg_coordoperation',15357,7302,'Texas North (ftUS)',''),
(1376,'epsg_coordoperation',15358,7302,'Texas North Central (ftUS)',''),
(1377,'epsg_coordoperation',15359,7302,'Texas Central (ftUS)',''),
(1378,'epsg_coordoperation',15360,7302,'Texas South Central (ftUS)',''),
(1379,'epsg_coordoperation',15361,7302,'Texas South (ftUS)',''),
(1380,'epsg_coordoperation',15362,7302,'Utah North (ft)',''),
(1381,'epsg_coordoperation',15363,7302,'Utah Central (ft)',''),
(1382,'epsg_coordoperation',15364,7302,'Utah South (ft)',''),
(1383,'epsg_coordoperation',15365,7302,'Virginia North (ftUS)',''),
(1384,'epsg_coordoperation',15366,7302,'Virginia South (ftUS)',''),
(1385,'epsg_coordoperation',15367,7302,'Washington North (ftUS)',''),
(1386,'epsg_coordoperation',15368,7302,'Washington South (ftUS)',''),
(1387,'epsg_coordoperation',15369,7302,'Wisconsin North (ftUS)',''),
(1388,'epsg_coordoperation',15370,7302,'Wisconsin Central (ftUS)',''),
(1389,'epsg_coordoperation',15371,7302,'Wisconsin South (ftUS)',''),
(1390,'epsg_datum',6190,7302,'POSGAR 98',''),
(1391,'epsg_datum',6190,7300,'Posiciones Geod\ufffd\ufffd\ufffdsicas Argentinas 1998',''),
(1392,'epsg_coordinatereferencesystem',4190,7301,'National Geodetic System [Argentina]','See information source.'),
(1393,'epsg_datum',6182,7301,'Observatario Flores',''),
(1394,'epsg_datum',6182,7302,'Azores Occidental 1939',''),
(1395,'epsg_datum',6183,7301,'Graciosa','The same name is also used for the 1995 adjustment (see datum code 6665).'),
(1396,'epsg_datum',6183,7302,'Azores Central 1948',''),
(1397,'epsg_datum',6184,7301,'Sao Bras','The same name is also used for the 1995 adjustment (see datum code 6664).'),
(1398,'epsg_datum',6184,7302,'Azores Oriental 1940',''),
(1399,'epsg_coordinatereferencesystem',4182,7301,'Observatorio Flores',''),
(1400,'epsg_coordinatereferencesystem',4183,7301,'Graciosa','The same name is also used for the 1995 adjustment (see CRS code 4665).'),
(1401,'epsg_coordinatereferencesystem',4184,7301,'Sao Braz','The same name is also used for the 1995 adjustment (see CRS code 4664).'),
(1402,'epsg_coordoperation',18084,7301,'France zone IV',''),
(1403,'epsg_coordoperation',18083,7301,'France zone III',''),
(1404,'epsg_coordoperation',18082,7301,'France zone II',''),
(1405,'epsg_coordoperation',18081,7301,'France zone I',''),
(1406,'epsg_coordoperation',18093,7301,'Sud France',''),
(1407,'epsg_coordoperation',18094,7301,'Corse',''),
(1408,'epsg_coordoperation',18092,7301,'Centre France',''),
(1409,'epsg_coordoperation',18091,7301,'Nord France',''),
(1410,'epsg_coordinatereferencesystem',27561,7301,'NTF (Paris) / Nord France',''),
(1411,'epsg_coordinatereferencesystem',27562,7301,'NTF (Paris) / Centre France',''),
(1412,'epsg_coordinatereferencesystem',27563,7301,'NTF (Paris) / Sud France',''),
(1413,'epsg_coordinatereferencesystem',27564,7301,'NTF (Paris) / Corse',''),
(1414,'epsg_coordinatereferencesystem',27571,7301,'NTF (Paris) / France I',''),
(1415,'epsg_coordinatereferencesystem',27572,7301,'NTF (Paris) / France II',''),
(1416,'epsg_coordinatereferencesystem',27573,7301,'NTF (Paris) / France III',''),
(1417,'epsg_coordinatereferencesystem',27574,7301,'NTF (Paris) / France IV',''),
(1418,'epsg_coordinatereferencesystem',27572,7301,'NTF (Paris) / Lambert zone II etendu',''),
(1419,'epsg_datum',6156,7300,'Jednotn\ufffd\ufffd\ufffd Trigonometrick\ufffd\ufffd\ufffd S\ufffd\ufffd\ufffdte Katastr\ufffd\ufffd\ufffdln\ufffd\ufffd\ufffd',''),
(1421,'epsg_coordoperation',1751,7301,'Amersfoort to ETRF89 (1)',''),
(1422,'epsg_coordinatereferencesystem',2168,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5',''),
(1423,'epsg_coordoperation',15302,7302,'Tennessee',''),
(1424,'epsg_coordoperation',16269,7302,'3-degree Gauss zone 9',''),
(1425,'epsg_coordoperation',16270,7302,'3-degree Gauss zone 10',''),
(1426,'epsg_coordoperation',16271,7302,'3-degree Gauss zone 11',''),
(1427,'epsg_coordoperation',16272,7302,'3-degree Gauss zone 12',''),
(1428,'epsg_coordoperation',16273,7302,'3-degree Gauss zone 13',''),
(1429,'epsg_coordoperation',16274,7302,'3-degree Gauss zone 14',''),
(1430,'epsg_coordoperation',16275,7302,'3-degree Gauss zone 15',''),
(1431,'epsg_datum',6123,7300,'Kartastokoordinaattij\ufffd\ufffd\ufffdrjestelm\ufffd\ufffd\ufffd (1966)',''),
(1432,'epsg_coordinatereferencesystem',2181,7301,'ED50 / Turkey zone 9',''),
(1433,'epsg_coordinatereferencesystem',2182,7301,'ED50 / Turkey zone 10',''),
(1434,'epsg_coordinatereferencesystem',2183,7301,'ED50 / Turkey zone 11',''),
(1435,'epsg_coordinatereferencesystem',2184,7301,'ED50 / Turkey zone 12',''),
(1436,'epsg_coordinatereferencesystem',2185,7301,'ED50 / Turkey zone 13',''),
(1437,'epsg_coordinatereferencesystem',2186,7301,'ED50 / Turkey zone 14',''),
(1438,'epsg_coordinatereferencesystem',2187,7301,'ED50 / Turkey zone 15',''),
(1439,'epsg_coordinatereferencesystem',2188,7301,'Observatorio Flores / UTM zone 25N',''),
(1440,'epsg_coordinatereferencesystem',2189,7301,'Graciosa / UTM zone 26N','The same name is also used for the 1995 adjustment (see CRS code 3063).'),
(1441,'epsg_coordinatereferencesystem',2190,7301,'Sao Braz / UTM zone 26N','The same name is also used for the 1995 adjustment (see CRS code 3062).'),
(1442,'epsg_coordoperation',1781,7310,'PD/83 to ETRS89',''),
(1443,'epsg_coordoperation',1782,7310,'RD/83 to ETRS89',''),
(1444,'epsg_coordinatereferencesystem',4207,7301,'Lisbon 1937',''),
(1445,'epsg_coordinatereferencesystem',4803,7301,'Lisbon 1937 (Lisbon)',''),
(1446,'epsg_coordinatereferencesystem',20791,7301,'Lisbon 1937 (Lisbon)/Portuguese Grid',''),
(1447,'epsg_coordinatereferencesystem',20790,7301,'Lisbon 1937 (Lisbon)/Portuguese National Grid',''),
(1448,'epsg_coordoperation',18411,7301,'Afrique Occidentale Fran\ufffd\ufffd\ufffdaise Senegal zone',''),
(1449,'epsg_coordoperation',18412,7301,'Afrique Occidentale Fran\ufffd\ufffd\ufffdaise C\ufffd\ufffd\ufffdte d''Ivoire zone',''),
(1450,'epsg_coordoperation',18413,7301,'Afrique Occidentale Fran\ufffd\ufffd\ufffdaise Dahomey zone',''),
(1451,'epsg_coordoperation',18415,7301,'Afrique Equatoriale Fran\ufffd\ufffd\ufffdaise ouest zone',''),
(1452,'epsg_coordoperation',18416,7301,'Afrique Equatoriale Fran\ufffd\ufffd\ufffdaise centrale zone',''),
(1453,'epsg_coordoperation',18417,7301,'Afrique Equatoriale Fran\ufffd\ufffd\ufffdaise est zone',''),
(1454,'epsg_coordoperation',18414,7301,'Afrique Occidentale Fran\ufffd\ufffd\ufffdaise Niger zone',''),
(1455,'epsg_coordoperation',18411,7302,'AOF Senegal zone',''),
(1456,'epsg_coordoperation',18412,7302,'AOF C\ufffd\ufffd\ufffdte d''Ivoire zone',''),
(1457,'epsg_coordoperation',18413,7302,'AOF Dahomey zone',''),
(1458,'epsg_coordoperation',18414,7302,'AOF Niger zone',''),
(1459,'epsg_coordoperation',18415,7302,'AEF west',''),
(1460,'epsg_coordoperation',18416,7302,'AEF central',''),
(1461,'epsg_coordoperation',18417,7302,'AEF east',''),
(1462,'epsg_coordoperationmethod',9823,7301,'Plate Carr\ufffd\ufffd\ufffde','This alias only applies if the latitude of natural origin is at the equator.'),
(1464,'epsg_coordoperation',1469,7301,'C\ufffd\ufffd\ufffdte D''Ivoire to WGS 84 (1)','Same alias also applied to Abidjan 1987 to WGS 84 (1) (code 1470).'),
(1465,'epsg_coordoperation',1469,7301,'Port Bouet to WGS 84 (1)','Same alias also applied to Abidjan 1987 to WGS 84 (1) (code 1470).'),
(1466,'epsg_coordoperation',1470,7301,'C\ufffd\ufffd\ufffdte D''Ivoire to WGS 84 (1)','Same alias also applied to Locodjo 1965 to WGS 84 (1) (code 1469).'),
(1467,'epsg_coordoperation',1470,7301,'Port Bouet to WGS 84 (1)','Same alias also applied to Locodjo 1965 to WGS 84 (1) (code 1469).'),
(1468,'epsg_coordinatereferencesystem',2040,7301,'Port Bouet / UTM zone 30N','Same alias used for Abidjan 1987 / UTM zone 30N (code 2041).'),
(1469,'epsg_coordinatereferencesystem',2040,7301,'C\ufffd\ufffd\ufffdte d''Ivoire / UTM zone 30N','Same alias used for Abidjan 1987 / UTM zone 30N (code 2041).'),
(1470,'epsg_coordinatereferencesystem',2041,7301,'Port Bouet / UTM zone 30N','Same alias used for Locodjo 1965 / UTM zone 30N (code 2040).'),
(1471,'epsg_coordinatereferencesystem',2041,7301,'C\ufffd\ufffd\ufffdte d''Ivoire / UTM zone 30N','Same alias used for Locodjo 1965 / UTM zone 30N (code 2040).'),
(1472,'epsg_coordinatereferencesystem',2042,7301,'Port Bouet / UTM zone 29N','Same alias used for Abidjan 1987 / UTM zone 29N (code 2043).'),
(1473,'epsg_coordinatereferencesystem',2042,7301,'C\ufffd\ufffd\ufffdte d''Ivoire / UTM zone 29N','Same alias used for Abidjan 1987 / UTM zone 29N (code 2043).'),
(1474,'epsg_coordinatereferencesystem',2043,7301,'Port Bouet / UTM zone 29N','Same alias used for Locodjo 1965 / UTM zone 29N (code 2042).'),
(1475,'epsg_coordinatereferencesystem',2043,7301,'C\ufffd\ufffd\ufffdte d''Ivoire / UTM zone 29N','Same alias used for Locodjo 1965 / UTM zone 29N (code 2042).'),
(1479,'epsg_coordoperation',18421,7301,'Greenland zone 1 west',''),
(1480,'epsg_coordoperation',18428,7301,'Greenland zone 8 west',''),
(1481,'epsg_coordinatereferencesystem',2297,7301,'Qornoq 1927 / Greenland zone 1 west',''),
(1482,'epsg_coordinatereferencesystem',2307,7301,'Qornoq 1927 / Greenland zone 8 west',''),
(1483,'epsg_coordinatereferencesystem',32113,7301,'NAD83 / New Mexico Central (m)',''),
(1484,'epsg_coordinatereferencesystem',26949,7301,'NAD83 / Arizona Central (m)',''),
(1485,'epsg_coordinatereferencesystem',26929,7301,'NAD83 / Alabama East (m)',''),
(1486,'epsg_coordinatereferencesystem',26930,7301,'NAD83 / Alabama West (m)',''),
(1487,'epsg_coordinatereferencesystem',26931,7301,'NAD83 / Alaska zone 1 (m)',''),
(1488,'epsg_coordinatereferencesystem',26940,7301,'NAD83 / Alaska zone 10 (m)',''),
(1489,'epsg_coordinatereferencesystem',26932,7301,'NAD83 / Alaska zone 2 (m)',''),
(1490,'epsg_coordinatereferencesystem',26933,7301,'NAD83 / Alaska zone 3 (m)',''),
(1491,'epsg_coordinatereferencesystem',26934,7301,'NAD83 / Alaska zone 4 (m)',''),
(1492,'epsg_coordinatereferencesystem',26935,7301,'NAD83 / Alaska zone 5 (m)',''),
(1493,'epsg_coordinatereferencesystem',26936,7301,'NAD83 / Alaska zone 6 (m)',''),
(1494,'epsg_coordinatereferencesystem',26937,7301,'NAD83 / Alaska zone 7 (m)',''),
(1495,'epsg_coordinatereferencesystem',26938,7301,'NAD83 / Alaska zone 8 (m)',''),
(1496,'epsg_coordinatereferencesystem',26939,7301,'NAD83 / Alaska zone 9 (m)',''),
(1497,'epsg_coordinatereferencesystem',26948,7301,'NAD83 / Arizona East (m)',''),
(1498,'epsg_coordinatereferencesystem',26950,7301,'NAD83 / Arizona West (m)',''),
(1499,'epsg_coordinatereferencesystem',26951,7301,'NAD83 / Arkansas North (m)',''),
(1500,'epsg_coordinatereferencesystem',26952,7301,'NAD83 / Arkansas South (m)',''),
(1501,'epsg_coordinatereferencesystem',26941,7301,'NAD83 / California zone 1 (m)',''),
(1502,'epsg_coordinatereferencesystem',26942,7301,'NAD83 / California zone 2 (m)',''),
(1503,'epsg_coordinatereferencesystem',26943,7301,'NAD83 / California zone 3 (m)',''),
(1504,'epsg_coordinatereferencesystem',26944,7301,'NAD83 / California zone 4 (m)',''),
(1505,'epsg_coordinatereferencesystem',26945,7301,'NAD83 / California zone 5 (m)',''),
(1506,'epsg_coordinatereferencesystem',26946,7301,'NAD83 / California zone 6 (m)',''),
(1507,'epsg_coordinatereferencesystem',26954,7301,'NAD83 / Colorado Central (m)',''),
(1508,'epsg_coordinatereferencesystem',26953,7301,'NAD83 / Colorado North (m)',''),
(1509,'epsg_coordinatereferencesystem',26955,7301,'NAD83 / Colorado South (m)',''),
(1510,'epsg_coordinatereferencesystem',26956,7301,'NAD83 / Connecticut (m)',''),
(1511,'epsg_coordinatereferencesystem',26957,7301,'NAD83 / Delaware (m)',''),
(1512,'epsg_coordinatereferencesystem',26958,7301,'NAD83 / Florida East (m)',''),
(1513,'epsg_coordinatereferencesystem',26960,7301,'NAD83 / Florida North (m)',''),
(1514,'epsg_coordinatereferencesystem',26959,7301,'NAD83 / Florida West (m)',''),
(1515,'epsg_coordinatereferencesystem',26966,7301,'NAD83 / Georgia East (m)',''),
(1516,'epsg_coordinatereferencesystem',26967,7301,'NAD83 / Georgia West (m)',''),
(1517,'epsg_coordinatereferencesystem',26961,7301,'NAD83 / Hawaii zone 1 (m)',''),
(1518,'epsg_coordinatereferencesystem',26962,7301,'NAD83 / Hawaii zone 2 (m)',''),
(1519,'epsg_coordinatereferencesystem',26963,7301,'NAD83 / Hawaii zone 3 (m)',''),
(1520,'epsg_coordinatereferencesystem',26964,7301,'NAD83 / Hawaii zone 4 (m)',''),
(1521,'epsg_coordinatereferencesystem',26965,7301,'NAD83 / Hawaii zone 5 (m)',''),
(1522,'epsg_coordinatereferencesystem',26969,7301,'NAD83 / Idaho Central (m)',''),
(1523,'epsg_coordinatereferencesystem',26968,7301,'NAD83 / Idaho East (m)',''),
(1524,'epsg_coordinatereferencesystem',26970,7301,'NAD83 / Idaho West (m)',''),
(1525,'epsg_coordinatereferencesystem',26971,7301,'NAD83 / Illinois East (m)',''),
(1526,'epsg_coordinatereferencesystem',26972,7301,'NAD83 / Illinois West (m)',''),
(1527,'epsg_coordinatereferencesystem',26973,7301,'NAD83 / Indiana East (m)',''),
(1528,'epsg_coordinatereferencesystem',26974,7301,'NAD83 / Indiana West (m)',''),
(1529,'epsg_coordinatereferencesystem',26975,7301,'NAD83 / Iowa North (m)',''),
(1530,'epsg_coordinatereferencesystem',26976,7301,'NAD83 / Iowa South (m)',''),
(1531,'epsg_coordinatereferencesystem',26977,7301,'NAD83 / Kansas North (m)',''),
(1532,'epsg_coordinatereferencesystem',26978,7301,'NAD83 / Kansas South (m)',''),
(1533,'epsg_coordinatereferencesystem',2205,7301,'NAD83 / Kentucky North (m)',''),
(1534,'epsg_coordinatereferencesystem',26980,7301,'NAD83 / Kentucky South (m)',''),
(1535,'epsg_coordinatereferencesystem',26981,7301,'NAD83 / Louisiana North (m)',''),
(1536,'epsg_coordinatereferencesystem',26982,7301,'NAD83 / Louisiana South (m)',''),
(1537,'epsg_coordinatereferencesystem',26983,7301,'NAD83 / Maine East (m)',''),
(1538,'epsg_coordinatereferencesystem',26984,7301,'NAD83 / Maine West (m)',''),
(1539,'epsg_coordinatereferencesystem',26985,7301,'NAD83 / Maryland (m)',''),
(1540,'epsg_coordinatereferencesystem',26987,7301,'NAD83 / Massachusetts Island (m)',''),
(1541,'epsg_coordinatereferencesystem',26986,7301,'NAD83 / Massachusetts Mainland (m)',''),
(1542,'epsg_coordinatereferencesystem',26989,7301,'NAD83 / Michigan Central (m)',''),
(1543,'epsg_coordinatereferencesystem',26988,7301,'NAD83 / Michigan North (m)',''),
(1544,'epsg_coordinatereferencesystem',26990,7301,'NAD83 / Michigan South (m)',''),
(1545,'epsg_coordinatereferencesystem',26992,7301,'NAD83 / Minnesota Central (m)',''),
(1546,'epsg_coordinatereferencesystem',26991,7301,'NAD83 / Minnesota North (m)',''),
(1547,'epsg_coordinatereferencesystem',26993,7301,'NAD83 / Minnesota South (m)',''),
(1548,'epsg_coordinatereferencesystem',26994,7301,'NAD83 / Mississippi East (m)',''),
(1549,'epsg_coordinatereferencesystem',26995,7301,'NAD83 / Mississippi West (m)',''),
(1550,'epsg_coordinatereferencesystem',26997,7301,'NAD83 / Missouri Central (m)',''),
(1551,'epsg_coordinatereferencesystem',26996,7301,'NAD83 / Missouri East (m)',''),
(1552,'epsg_coordinatereferencesystem',26998,7301,'NAD83 / Missouri West (m)',''),
(1553,'epsg_coordinatereferencesystem',32100,7301,'NAD83 / Montana (m)',''),
(1554,'epsg_coordinatereferencesystem',32104,7301,'NAD83 / Nebraska (m)',''),
(1555,'epsg_coordinatereferencesystem',32108,7301,'NAD83 / Nevada Central (m)',''),
(1556,'epsg_coordinatereferencesystem',32107,7301,'NAD83 / Nevada East (m)',''),
(1557,'epsg_coordinatereferencesystem',32109,7301,'NAD83 / Nevada West (m)',''),
(1558,'epsg_coordinatereferencesystem',32110,7301,'NAD83 / New Hampshire (m)',''),
(1559,'epsg_coordinatereferencesystem',32111,7301,'NAD83 / New Jersey (m)',''),
(1560,'epsg_coordinatereferencesystem',32112,7301,'NAD83 / New Mexico East (m)',''),
(1561,'epsg_coordinatereferencesystem',32114,7301,'NAD83 / New Mexico West (m)',''),
(1562,'epsg_coordinatereferencesystem',32116,7301,'NAD83 / New York Central (m)',''),
(1563,'epsg_coordinatereferencesystem',32115,7301,'NAD83 / New York East (m)',''),
(1564,'epsg_coordinatereferencesystem',32118,7301,'NAD83 / New York Long Island (m)',''),
(1565,'epsg_coordinatereferencesystem',32117,7301,'NAD83 / New York West (m)',''),
(1566,'epsg_coordinatereferencesystem',32119,7301,'NAD83 / North Carolina (m)',''),
(1567,'epsg_coordinatereferencesystem',32120,7301,'NAD83 / North Dakota North (m)',''),
(1568,'epsg_coordinatereferencesystem',32121,7301,'NAD83 / North Dakota South (m)',''),
(1569,'epsg_coordinatereferencesystem',32122,7301,'NAD83 / Ohio North (m)',''),
(1570,'epsg_coordinatereferencesystem',32123,7301,'NAD83 / Ohio South (m)',''),
(1571,'epsg_coordinatereferencesystem',32124,7301,'NAD83 / Oklahoma North (m)',''),
(1572,'epsg_coordinatereferencesystem',32125,7301,'NAD83 / Oklahoma South (m)',''),
(1573,'epsg_coordinatereferencesystem',32126,7301,'NAD83 / Oregon North (m)',''),
(1574,'epsg_coordinatereferencesystem',32127,7301,'NAD83 / Oregon South (m)',''),
(1575,'epsg_coordinatereferencesystem',32128,7301,'NAD83 / Pennsylvania North (m)',''),
(1576,'epsg_coordinatereferencesystem',32129,7301,'NAD83 / Pennsylvania South (m)',''),
(1577,'epsg_coordinatereferencesystem',32130,7301,'NAD83 / Rhode Island (m)',''),
(1578,'epsg_coordinatereferencesystem',32133,7301,'NAD83 / South Carolina (m)',''),
(1579,'epsg_coordinatereferencesystem',32134,7301,'NAD83 / South Dakota North (m)',''),
(1580,'epsg_coordinatereferencesystem',32135,7301,'NAD83 / South Dakota South (m)',''),
(1581,'epsg_coordinatereferencesystem',32136,7301,'NAD83 / Tennessee (m)',''),
(1582,'epsg_coordinatereferencesystem',32139,7301,'NAD83 / Texas Central (m)',''),
(1583,'epsg_coordinatereferencesystem',32137,7301,'NAD83 / Texas North (m)',''),
(1584,'epsg_coordinatereferencesystem',32138,7301,'NAD83 / Texas North Central (m)',''),
(1585,'epsg_coordinatereferencesystem',32141,7301,'NAD83 / Texas South (m)',''),
(1586,'epsg_coordinatereferencesystem',32140,7301,'NAD83 / Texas South Central (m)',''),
(1587,'epsg_coordinatereferencesystem',32143,7301,'NAD83 / Utah Central (m)',''),
(1588,'epsg_coordinatereferencesystem',32142,7301,'NAD83 / Utah North (m)',''),
(1589,'epsg_coordinatereferencesystem',32144,7301,'NAD83 / Utah South (m)',''),
(1590,'epsg_coordinatereferencesystem',32145,7301,'NAD83 / Vermont (m)',''),
(1591,'epsg_coordinatereferencesystem',32146,7301,'NAD83 / Virginia North (m)',''),
(1592,'epsg_coordinatereferencesystem',32147,7301,'NAD83 / Virginia South (m)',''),
(1593,'epsg_coordinatereferencesystem',32148,7301,'NAD83 / Washington North (m)',''),
(1594,'epsg_coordinatereferencesystem',32149,7301,'NAD83 / Washington South (m)',''),
(1595,'epsg_coordinatereferencesystem',32150,7301,'NAD83 / West Virginia North (m)',''),
(1596,'epsg_coordinatereferencesystem',32151,7301,'NAD83 / West Virginia South (m)',''),
(1597,'epsg_coordinatereferencesystem',32153,7301,'NAD83 / Wisconsin Central (m)',''),
(1598,'epsg_coordinatereferencesystem',32152,7301,'NAD83 / Wisconsin North (m)',''),
(1599,'epsg_coordinatereferencesystem',32154,7301,'NAD83 / Wisconsin South (m)',''),
(1600,'epsg_coordinatereferencesystem',32155,7301,'NAD83 / Wyoming East (m)',''),
(1601,'epsg_coordinatereferencesystem',32156,7301,'NAD83 / Wyoming East Central (m)',''),
(1602,'epsg_coordinatereferencesystem',32158,7301,'NAD83 / Wyoming West (m)',''),
(1603,'epsg_coordinatereferencesystem',32157,7301,'NAD83 / Wyoming West Central (m)',''),
(1604,'epsg_coordinatereferencesystem',32161,7301,'NAD83 / Puerto Rico & Virgin Is. (m)',''),
(1605,'epsg_coordoperation',10131,7301,'Alabama CS83 East zone',''),
(1606,'epsg_coordoperation',10132,7301,'Alabama CS83 West zone',''),
(1607,'epsg_coordoperation',10231,7301,'Arizona CS83 East zone',''),
(1608,'epsg_coordoperation',10232,7301,'Arizona CS83 Central zone',''),
(1609,'epsg_coordoperation',10233,7301,'Arizona CS83 West zone',''),
(1610,'epsg_coordoperation',10331,7301,'Arkansas CS83 North zone',''),
(1611,'epsg_coordoperation',10332,7301,'Arkansas CS83 South zone',''),
(1612,'epsg_coordoperation',10431,7301,'California CS83 zone 1',''),
(1613,'epsg_coordoperation',10432,7301,'California CS83 zone 2',''),
(1614,'epsg_coordoperation',10433,7301,'California CS83 zone 3',''),
(1615,'epsg_coordoperation',10434,7301,'California CS83 zone 4',''),
(1616,'epsg_coordoperation',10435,7301,'California CS83 zone 5',''),
(1617,'epsg_coordoperation',10436,7301,'California CS83 zone 6',''),
(1618,'epsg_coordoperation',10531,7301,'Colorado CS83 North zone',''),
(1619,'epsg_coordoperation',10532,7301,'Colorado CS83 Central zone',''),
(1620,'epsg_coordoperation',10533,7301,'Colorado CS83 South zone',''),
(1621,'epsg_coordoperation',10630,7301,'Connecticut CS83',''),
(1622,'epsg_coordoperation',10730,7301,'Delaware CS83',''),
(1623,'epsg_coordoperation',10931,7301,'Florida CS83 East zone',''),
(1624,'epsg_coordoperation',10932,7301,'Florida CS83 West zone',''),
(1625,'epsg_coordoperation',10933,7301,'Florida CS83 North zone',''),
(1626,'epsg_coordoperation',11031,7301,'Georgia CS83 East zone',''),
(1627,'epsg_coordoperation',11032,7301,'Georgia CS83 West zone',''),
(1628,'epsg_coordoperation',11131,7301,'Idaho CS83 East zone',''),
(1629,'epsg_coordoperation',11132,7301,'Idaho CS83 Central zone',''),
(1630,'epsg_coordoperation',11133,7301,'Idaho CS83 West zone',''),
(1631,'epsg_coordoperation',11231,7301,'Illinois CS83 East zone',''),
(1632,'epsg_coordoperation',11232,7301,'Illinois CS83 West zone',''),
(1633,'epsg_coordoperation',11331,7301,'Indiana CS83 East zone',''),
(1634,'epsg_coordoperation',11332,7301,'Indiana CS83 West zone',''),
(1635,'epsg_coordoperation',11431,7301,'Iowa CS83 North zone',''),
(1636,'epsg_coordoperation',11432,7301,'Iowa CS83 South zone',''),
(1637,'epsg_coordoperation',11531,7301,'Kansas CS83 North zone',''),
(1638,'epsg_coordoperation',11532,7301,'Kansas CS83 South zone',''),
(1640,'epsg_coordoperation',11632,7301,'Kentucky CS83 South zone',''),
(1641,'epsg_coordoperation',11731,7301,'Louisiana CS83 North zone',''),
(1642,'epsg_coordoperation',11732,7301,'Louisiana CS83 South zone',''),
(1643,'epsg_coordoperation',11831,7301,'Maine CS83 East zone',''),
(1644,'epsg_coordoperation',11832,7301,'Maine CS83 West zone',''),
(1645,'epsg_coordoperation',11930,7301,'Maryland CS83',''),
(1646,'epsg_coordoperation',12031,7301,'Massachusetts CS83 Mainland zone',''),
(1647,'epsg_coordoperation',12032,7301,'Massachusetts CS83 Island zone',''),
(1648,'epsg_coordoperation',12141,7301,'Michigan CS83 North zone',''),
(1649,'epsg_coordoperation',12142,7301,'Michigan CS83 Central zone',''),
(1650,'epsg_coordoperation',12143,7301,'Michigan CS83 South zone',''),
(1651,'epsg_coordoperation',12231,7301,'Minnesota CS83 North zone',''),
(1652,'epsg_coordoperation',12232,7301,'Minnesota CS83 Central zone',''),
(1653,'epsg_coordoperation',12233,7301,'Minnesota CS83 South zone',''),
(1654,'epsg_coordoperation',12331,7301,'Mississippi CS83 East zone',''),
(1655,'epsg_coordoperation',12332,7301,'Mississippi CS83 West zone',''),
(1656,'epsg_coordoperation',12431,7301,'Missouri CS83 East zone',''),
(1657,'epsg_coordoperation',12433,7301,'Missouri CS83 West zone',''),
(1658,'epsg_coordoperation',12530,7301,'Montana CS83',''),
(1659,'epsg_coordoperation',12630,7301,'Nebraska CS83',''),
(1660,'epsg_coordoperation',12731,7301,'Nevada CS83 East zone',''),
(1661,'epsg_coordoperation',12732,7301,'Nevada CS83 Central zone',''),
(1662,'epsg_coordoperation',12733,7301,'Nevada CS83 West zone',''),
(1663,'epsg_coordoperation',12830,7301,'New Hampshire CS83',''),
(1664,'epsg_coordoperation',12930,7301,'New Jersey CS83',''),
(1665,'epsg_coordoperation',13031,7301,'New Mexico CS83 East zone',''),
(1666,'epsg_coordoperation',13032,7301,'New Mexico CS83 Central zone',''),
(1667,'epsg_coordoperation',13033,7301,'New Mexico CS83 West zone',''),
(1668,'epsg_coordoperation',13131,7301,'New York CS83 East zone',''),
(1669,'epsg_coordoperation',13132,7301,'New York CS83 Central zone',''),
(1670,'epsg_coordoperation',13133,7301,'New York CS83 West zone',''),
(1671,'epsg_coordoperation',13134,7301,'New York CS83 Long Island zone',''),
(1672,'epsg_coordoperation',13230,7301,'North Carolina CS83',''),
(1673,'epsg_coordoperation',13331,7301,'North Dakota CS83 North zone',''),
(1674,'epsg_coordoperation',13332,7301,'North Dakota CS83 South zone',''),
(1675,'epsg_coordoperation',13431,7301,'Ohio CS83 North zone',''),
(1676,'epsg_coordoperation',13432,7301,'Ohio CS83 South zone',''),
(1677,'epsg_coordoperation',13531,7301,'Oklahoma CS83 North zone',''),
(1678,'epsg_coordoperation',13532,7301,'Oklahoma CS83 South zone',''),
(1679,'epsg_coordoperation',13631,7301,'Oregon CS83 North zone',''),
(1680,'epsg_coordoperation',13632,7301,'Oregon CS83 South zone',''),
(1681,'epsg_coordoperation',13731,7301,'Pennsylvania CS83 North zone',''),
(1682,'epsg_coordoperation',13732,7301,'Pennsylvania CS83 South zone',''),
(1683,'epsg_coordoperation',13830,7301,'Rhode Island CS83',''),
(1684,'epsg_coordoperation',13930,7301,'South Carolina CS83',''),
(1685,'epsg_coordoperation',14031,7301,'South Dakota CS83 North zone',''),
(1686,'epsg_coordoperation',14032,7301,'South Dakota CS83 South zone',''),
(1687,'epsg_coordoperation',14130,7301,'Tennessee CS83',''),
(1688,'epsg_coordoperation',14231,7301,'Texas CS83 North zone',''),
(1689,'epsg_coordoperation',14232,7301,'Texas CS83 North Central zone',''),
(1690,'epsg_coordoperation',14233,7301,'Texas CS83 Central zone',''),
(1691,'epsg_coordoperation',14234,7301,'Texas CS83 South Central zone',''),
(1692,'epsg_coordoperation',14235,7301,'Texas CS83 South zone',''),
(1693,'epsg_coordoperation',14331,7301,'Utah CS83 North zone',''),
(1694,'epsg_coordoperation',14332,7301,'Utah CS83 Central zone',''),
(1695,'epsg_coordoperation',14333,7301,'Utah CS83 South zone',''),
(1696,'epsg_coordoperation',14430,7301,'Vermont CS83',''),
(1697,'epsg_coordoperation',14531,7301,'Virginia CS83 North zone',''),
(1698,'epsg_coordoperation',14532,7301,'Virginia CS83 South zone',''),
(1699,'epsg_coordoperation',14631,7301,'Washington CS83 North zone',''),
(1700,'epsg_coordoperation',14632,7301,'Washington CS83 South zone',''),
(1701,'epsg_coordoperation',14731,7301,'West Virginia CS83 North zone',''),
(1702,'epsg_coordoperation',14732,7301,'West Virginia CS83 South zone',''),
(1703,'epsg_coordoperation',14831,7301,'Wisconsin CS83 North zone',''),
(1704,'epsg_coordoperation',14832,7301,'Wisconsin CS83 Central zone',''),
(1705,'epsg_coordoperation',14833,7301,'Wisconsin CS83 South zone',''),
(1706,'epsg_coordoperation',14931,7301,'Wyoming CS83 East zone',''),
(1707,'epsg_coordoperation',14932,7301,'Wyoming CS83 East Central zone',''),
(1708,'epsg_coordoperation',14933,7301,'Wyoming CS83 West Central zone',''),
(1709,'epsg_coordoperation',14934,7301,'Wyoming CS83 West zone',''),
(1710,'epsg_coordoperation',15031,7301,'Alaska CS83 zone 1',''),
(1711,'epsg_coordoperation',15032,7301,'Alaska CS83 zone 2',''),
(1712,'epsg_coordoperation',15033,7301,'Alaska CS83 zone 3',''),
(1713,'epsg_coordoperation',15034,7301,'Alaska CS83 zone 4',''),
(1714,'epsg_coordoperation',15035,7301,'Alaska CS83 zone 5',''),
(1715,'epsg_coordoperation',15036,7301,'Alaska CS83 zone 6',''),
(1716,'epsg_coordoperation',15037,7301,'Alaska CS83 zone 7',''),
(1717,'epsg_coordoperation',15038,7301,'Alaska CS83 zone 8',''),
(1718,'epsg_coordoperation',15039,7301,'Alaska CS83 zone 9',''),
(1719,'epsg_coordoperation',15040,7301,'Alaska CS83 zone 10',''),
(1720,'epsg_coordoperation',15131,7301,'Hawaii CS83 zone 1',''),
(1721,'epsg_coordoperation',15132,7301,'Hawaii CS83 zone 2',''),
(1722,'epsg_coordoperation',15133,7301,'Hawaii CS83 zone 3',''),
(1723,'epsg_coordoperation',15134,7301,'Hawaii CS83 zone 4',''),
(1724,'epsg_coordoperation',15135,7301,'Hawaii CS83 zone 5',''),
(1725,'epsg_coordoperation',15230,7301,'Puerto Rico & Virgin Islands CS83',''),
(1726,'epsg_coordoperation',15303,7301,'Kentucky CS83 North zone',''),
(1727,'epsg_coordoperation',12432,7301,'Missouri CS83 Central zone',''),
(1728,'epsg_coordoperation',15303,7302,'Kentucky North',''),
(1729,'epsg_coordoperation',10532,7302,'Colorado Central',''),
(1730,'epsg_coordinatereferencesystem',4282,7301,'Congo 1960 Pointe Noire',''),
(1731,'epsg_coordinatereferencesystem',28232,7301,'Congo 1960 Pointe Noire / UTM zone 32S',''),
(1732,'epsg_coordoperation',1801,7301,'Congo 1960 Pointe Noire to WGS 84 (2)',''),
(1733,'epsg_coordoperation',1802,7301,'Congo 1960 Pointe Noire to WGS 84 (3)',''),
(1734,'epsg_coordoperation',1200,7301,'Congo 1960 Pointe Noire to WGS 84 (1)',''),
(1735,'epsg_coordoperation',15914,7301,'BLM zone 14N in feet',''),
(1736,'epsg_coordoperation',15915,7301,'BLM zone 15N in feet',''),
(1737,'epsg_coordoperation',15916,7301,'BLM zone 16N in feet',''),
(1738,'epsg_coordoperation',15917,7301,'BLM zone 17N in feet',''),
(1739,'epsg_coordinatereferencesystem',21149,7301,'Genuk / UTM zone 49S',''),
(1740,'epsg_coordinatereferencesystem',2308,7301,'Genuk / TM 109 SE',''),
(1741,'epsg_datum',5133,7302,'AIOC95',''),
(1742,'epsg_coordinatereferencesystem',5705,7301,'Kronstadt',''),
(1743,'epsg_datum',6199,7301,'New Egyptian','Old Egyptian is an alias for Egypt 1907 (code 6229).'),
(1744,'epsg_datum',6229,7301,'Old Egyptian','New Egyptian is an alias for Egypt 1930 (code 6199).'),
(1745,'epsg_coordinatereferencesystem',4199,7301,'New Egyptian','Old Egyptian is an alias for Egypt 1907 (code 4229).'),
(1746,'epsg_coordinatereferencesystem',4229,7301,'Old Egyptian','New Egyptian is an alias for Egypt 1930 (code 4199).'),
(1747,'epsg_coordoperation',1516,7301,'PSAD56 to WGS 84 (1)',''),
(1748,'epsg_coordoperation',1813,7301,'Genuk to WGS 84 (ONWJ)',''),
(1749,'epsg_coordinatereferencesystem',32064,7301,'NAD27 / UTM zone 14N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 14N (code 26714). UTM is a metric system so strictly this is not UTM.'),
(1750,'epsg_coordinatereferencesystem',32065,7301,'NAD27 / UTM zone 15N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 15N (code 26715). UTM is a metric system so strictly this is not UTM.'),
(1751,'epsg_coordinatereferencesystem',32066,7301,'NAD27 / UTM zone 16N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 16N (code 26716). UTM is a metric system so strictly this is not UTM.'),
(1752,'epsg_coordinatereferencesystem',32067,7301,'NAD27 / UTM zone 17N (ftUS)','Non-metric equivalent of NAD27 / UTM zone 17N (code 26717). UTM is a metric system so strictly this is not UTM.'),
(1754,'epsg_coordinatereferencesystem',2319,7301,'ED50 / 3-degree Gauss-Kruger CM 27E',''),
(1755,'epsg_coordinatereferencesystem',2320,7301,'ED50 / 3-degree Gauss-Kruger CM 30E',''),
(1756,'epsg_coordinatereferencesystem',2321,7301,'ED50 / 3-degree Gauss-Kruger CM 33E',''),
(1757,'epsg_coordinatereferencesystem',2322,7301,'ED50 / 3-degree Gauss-Kruger CM 36E',''),
(1758,'epsg_coordinatereferencesystem',2323,7301,'ED50 / 3-degree Gauss-Kruger CM 39E',''),
(1759,'epsg_coordinatereferencesystem',2324,7301,'ED50 / 3-degree Gauss-Kruger CM 42E',''),
(1760,'epsg_coordinatereferencesystem',2325,7301,'ED50 / 3-degree Gauss-Kruger CM 45E',''),
(1761,'epsg_datum',6612,7302,'JGD2000',''),
(1762,'epsg_datum',5137,7301,'Huang Hai 1985',''),
(1763,'epsg_datum',5135,7302,'HKPD',''),
(1765,'epsg_coordinatereferencesystem',5736,7301,'Huang Hai 1956',''),
(1766,'epsg_coordinatereferencesystem',5738,7302,'HKPD',''),
(1767,'epsg_coordinatereferencesystem',2343,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 105E',''),
(1768,'epsg_coordinatereferencesystem',2344,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 111E',''),
(1769,'epsg_coordinatereferencesystem',2338,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 75E',''),
(1770,'epsg_coordinatereferencesystem',2342,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 99E',''),
(1771,'epsg_coordinatereferencesystem',2348,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 135E',''),
(1772,'epsg_coordinatereferencesystem',2339,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 81E',''),
(1773,'epsg_coordinatereferencesystem',2340,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 87E',''),
(1774,'epsg_coordinatereferencesystem',2341,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 93E',''),
(1775,'epsg_coordinatereferencesystem',2345,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 117E',''),
(1776,'epsg_coordinatereferencesystem',2346,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 123E',''),
(1777,'epsg_coordinatereferencesystem',2347,7301,'Xian 1980 / 6-degree Gauss-Kruger CM 129E',''),
(1778,'epsg_datum',6611,7302,'HK80',''),
(1779,'epsg_datum',5135,7301,'Ordnance Datum','This is the former name.'),
(1780,'epsg_datum',5136,7301,'Admiralty Datum','This is the former name.'),
(1781,'epsg_coordinatereferencesystem',5737,7301,'Huang Hai 1985',''),
(1782,'epsg_coordinatereferencesystem',2326,7302,'HK 1980 Grid System',''),
(1783,'epsg_coordinatereferencesystem',4611,7302,'HK1980',''),
(1784,'epsg_coordoperationparam',8802,7301,'Central Meridian','Abbeviated as "CM".'),
(1785,'epsg_coordoperationparam',8802,7302,'CM','Abbreviation for "Central Meridian".'),
(1786,'epsg_coordinatereferencesystem',2327,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 13','Part of the China National Coordinate System of 1980.'),
(1787,'epsg_coordinatereferencesystem',2328,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 14','Part of the China National Coordinate System of 1980.'),
(1788,'epsg_coordinatereferencesystem',2329,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 15','Part of the China National Coordinate System of 1980.'),
(1789,'epsg_coordinatereferencesystem',2330,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 16','Part of the China National Coordinate System of 1980.'),
(1790,'epsg_coordinatereferencesystem',2331,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 17','Part of the China National Coordinate System of 1980.'),
(1791,'epsg_coordinatereferencesystem',2332,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 18','Part of the China National Coordinate System of 1980.'),
(1792,'epsg_coordinatereferencesystem',2333,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 19','Part of the China National Coordinate System of 1980.'),
(1793,'epsg_coordinatereferencesystem',2334,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 20','Part of the China National Coordinate System of 1980.'),
(1794,'epsg_coordinatereferencesystem',2335,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 21','Part of the China National Coordinate System of 1980.'),
(1795,'epsg_coordinatereferencesystem',2336,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 22','Part of the China National Coordinate System of 1980.'),
(1796,'epsg_coordinatereferencesystem',2333,7301,'Xian 1980 / 6-degree Gauss-Kruger zone 23','Part of the China National Coordinate System of 1980.'),
(1797,'epsg_coordinatereferencesystem',21413,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 13',''),
(1798,'epsg_coordinatereferencesystem',21414,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 14',''),
(1799,'epsg_coordinatereferencesystem',21415,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 15',''),
(1800,'epsg_coordinatereferencesystem',21416,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 16',''),
(1801,'epsg_coordinatereferencesystem',21417,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 17',''),
(1802,'epsg_coordinatereferencesystem',21418,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 18',''),
(1803,'epsg_coordinatereferencesystem',21419,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 19',''),
(1804,'epsg_coordinatereferencesystem',21420,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 20',''),
(1805,'epsg_coordinatereferencesystem',21421,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 21',''),
(1806,'epsg_coordinatereferencesystem',21422,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 22',''),
(1807,'epsg_coordinatereferencesystem',21423,7301,'Beijing 1954 / 6-degree Gauss-Kruger zone 23',''),
(1808,'epsg_coordinatereferencesystem',21453,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 75E',''),
(1809,'epsg_coordinatereferencesystem',21454,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 81E',''),
(1810,'epsg_coordinatereferencesystem',21455,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 87E',''),
(1811,'epsg_coordinatereferencesystem',21456,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 93E',''),
(1812,'epsg_coordinatereferencesystem',21457,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 99E',''),
(1813,'epsg_coordinatereferencesystem',21458,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 105E',''),
(1814,'epsg_coordinatereferencesystem',21459,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 111E',''),
(1815,'epsg_coordinatereferencesystem',21460,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 117E',''),
(1816,'epsg_coordinatereferencesystem',21461,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 123E',''),
(1817,'epsg_coordinatereferencesystem',21462,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 129E',''),
(1818,'epsg_coordinatereferencesystem',21463,7301,'Beijing 1954 / 6-degree Gauss-Kruger CM 135E',''),
(1819,'epsg_coordoperation',5405,7302,'HKPD to Hong Kong Chart (1)',''),
(1820,'epsg_coordinatereferencesystem',2044,7301,'Hanoi 1972 / 6-degree Gauss-Kruger zone 18',''),
(1821,'epsg_coordinatereferencesystem',2045,7301,'Hanoi 1972 / 6-degree Gauss-Kruger zone 19',''),
(1822,'epsg_coordinatereferencesystem',2462,7301,'Albanian 1987 / 6-degree Gauss-Kruger zone 4',''),
(1823,'epsg_coordinatereferencesystem',2397,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3',''),
(1824,'epsg_coordinatereferencesystem',2398,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4',''),
(1825,'epsg_coordinatereferencesystem',2399,7301,'Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3',''),
(1826,'epsg_coordinatereferencesystem',2395,7302,'S Yemen / Gauss zone 8',''),
(1827,'epsg_coordinatereferencesystem',2396,7302,'S Yemen / Gauss zone 9',''),
(1828,'epsg_coordinatereferencesystem',2396,7301,'South Yemen / 6-degree Gauss-Kruger zone 9',''),
(1829,'epsg_coordinatereferencesystem',2395,7301,'South Yemen / 6-degree Gauss-Kruger zone 8',''),
(1830,'epsg_coordoperation',18031,7301,'Gauss-Kruger zone 1',''),
(1831,'epsg_coordoperation',18032,7301,'Gauss-Kruger zone 2',''),
(1832,'epsg_coordoperation',18033,7301,'Gauss-Kruger zone 3',''),
(1833,'epsg_coordoperation',18034,7301,'Gauss-Kruger zone 4',''),
(1834,'epsg_coordoperation',18035,7301,'Gauss-Kruger zone 5',''),
(1835,'epsg_coordoperation',18036,7301,'Gauss-Kruger zone 6',''),
(1836,'epsg_coordoperation',18037,7301,'Gauss-Kruger zone 7',''),
(1837,'epsg_coordinatereferencesystem',22191,7301,'Campo Inchauspe / Gauss-Kruger zone 1',''),
(1838,'epsg_coordinatereferencesystem',22192,7301,'Campo Inchauspe / Gauss-Kruger zone 2',''),
(1839,'epsg_coordinatereferencesystem',22193,7301,'Campo Inchauspe / Gauss-Kruger zone 3',''),
(1840,'epsg_coordinatereferencesystem',22194,7301,'Campo Inchauspe / Gauss-Kruger zone 4',''),
(1841,'epsg_coordinatereferencesystem',22195,7301,'Campo Inchauspe / Gauss-Kruger zone 5',''),
(1842,'epsg_coordinatereferencesystem',22196,7301,'Campo Inchauspe / Gauss-Kruger zone 6',''),
(1843,'epsg_coordinatereferencesystem',22197,7301,'Campo Inchauspe / Gauss-Kruger zone 7',''),
(1844,'epsg_coordinatereferencesystem',2081,7301,'Chos Malal 1914 / Gauss-Kruger zone 2',''),
(1845,'epsg_coordinatereferencesystem',2082,7301,'Pampa del Castillo / Gauss-Kruger zone 2',''),
(1846,'epsg_coordinatereferencesystem',2083,7301,'Hito XVIII 1963 / Gauss-Kruger zone 2',''),
(1847,'epsg_coordinatereferencesystem',20004,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 4',''),
(1848,'epsg_coordinatereferencesystem',20005,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 5',''),
(1849,'epsg_coordinatereferencesystem',20006,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 6',''),
(1850,'epsg_coordinatereferencesystem',20007,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 7',''),
(1851,'epsg_coordinatereferencesystem',20008,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 8',''),
(1852,'epsg_coordinatereferencesystem',20009,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 9',''),
(1853,'epsg_coordinatereferencesystem',20010,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 10',''),
(1854,'epsg_coordinatereferencesystem',20011,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 11',''),
(1855,'epsg_coordinatereferencesystem',20012,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 12',''),
(1856,'epsg_coordinatereferencesystem',20013,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 13',''),
(1857,'epsg_coordinatereferencesystem',20014,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 14',''),
(1858,'epsg_coordinatereferencesystem',20015,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 15',''),
(1859,'epsg_coordinatereferencesystem',20016,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 16',''),
(1860,'epsg_coordinatereferencesystem',20017,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 17',''),
(1861,'epsg_coordinatereferencesystem',20018,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 18',''),
(1862,'epsg_coordinatereferencesystem',20019,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 19',''),
(1863,'epsg_coordinatereferencesystem',20020,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 20',''),
(1864,'epsg_coordinatereferencesystem',20021,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 21',''),
(1865,'epsg_coordinatereferencesystem',20022,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 22',''),
(1866,'epsg_coordinatereferencesystem',20023,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 23',''),
(1867,'epsg_coordinatereferencesystem',20024,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 24',''),
(1868,'epsg_coordinatereferencesystem',20025,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 25',''),
(1869,'epsg_coordinatereferencesystem',20026,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 26',''),
(1870,'epsg_coordinatereferencesystem',20027,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 27',''),
(1871,'epsg_coordinatereferencesystem',20028,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 28',''),
(1872,'epsg_coordinatereferencesystem',20029,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 29',''),
(1873,'epsg_coordinatereferencesystem',20030,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 30',''),
(1874,'epsg_coordinatereferencesystem',20031,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 31',''),
(1875,'epsg_coordinatereferencesystem',20032,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger zone 32',''),
(1876,'epsg_coordinatereferencesystem',28402,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 2',''),
(1877,'epsg_coordinatereferencesystem',28403,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 3',''),
(1878,'epsg_coordinatereferencesystem',28404,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 4',''),
(1879,'epsg_coordinatereferencesystem',28405,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 5',''),
(1880,'epsg_coordinatereferencesystem',28406,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 6',''),
(1881,'epsg_coordinatereferencesystem',28407,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 7',''),
(1882,'epsg_coordinatereferencesystem',28408,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 8',''),
(1883,'epsg_coordinatereferencesystem',28409,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 9',''),
(1884,'epsg_coordinatereferencesystem',28410,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 10',''),
(1885,'epsg_coordinatereferencesystem',28411,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 11',''),
(1886,'epsg_coordinatereferencesystem',28412,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 12',''),
(1887,'epsg_coordinatereferencesystem',28413,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 13',''),
(1888,'epsg_coordinatereferencesystem',28414,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 14',''),
(1889,'epsg_coordinatereferencesystem',28415,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 15',''),
(1890,'epsg_coordinatereferencesystem',28416,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 16',''),
(1891,'epsg_coordinatereferencesystem',28417,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 17',''),
(1892,'epsg_coordinatereferencesystem',28418,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 18',''),
(1893,'epsg_coordinatereferencesystem',28419,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 19',''),
(1894,'epsg_coordinatereferencesystem',28420,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 20',''),
(1895,'epsg_coordinatereferencesystem',28421,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 21',''),
(1896,'epsg_coordinatereferencesystem',28422,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 22',''),
(1897,'epsg_coordinatereferencesystem',28423,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 23',''),
(1898,'epsg_coordinatereferencesystem',28424,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 24',''),
(1899,'epsg_coordinatereferencesystem',28425,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 25',''),
(1900,'epsg_coordinatereferencesystem',28426,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 26',''),
(1901,'epsg_coordinatereferencesystem',28427,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 27',''),
(1902,'epsg_coordinatereferencesystem',28428,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 28',''),
(1903,'epsg_coordinatereferencesystem',28429,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 29',''),
(1904,'epsg_coordinatereferencesystem',28430,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 30',''),
(1905,'epsg_coordinatereferencesystem',28431,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 31',''),
(1906,'epsg_coordinatereferencesystem',28432,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger zone 32',''),
(1907,'epsg_coordinatereferencesystem',2463,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 21E',''),
(1908,'epsg_coordinatereferencesystem',2464,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 27E',''),
(1909,'epsg_coordinatereferencesystem',2465,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 33E',''),
(1910,'epsg_coordinatereferencesystem',2466,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 39E',''),
(1911,'epsg_coordinatereferencesystem',2467,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 45E',''),
(1912,'epsg_coordinatereferencesystem',2468,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 51E',''),
(1913,'epsg_coordinatereferencesystem',2469,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 57E',''),
(1914,'epsg_coordinatereferencesystem',2470,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 63E',''),
(1915,'epsg_coordinatereferencesystem',2471,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 69E',''),
(1916,'epsg_coordinatereferencesystem',2472,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 75E',''),
(1917,'epsg_coordinatereferencesystem',2473,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 81E',''),
(1918,'epsg_coordinatereferencesystem',2474,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 87E',''),
(1919,'epsg_coordinatereferencesystem',2475,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 93E',''),
(1920,'epsg_coordinatereferencesystem',2476,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 99E',''),
(1921,'epsg_coordinatereferencesystem',2477,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 105E',''),
(1922,'epsg_coordinatereferencesystem',2478,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 111E',''),
(1923,'epsg_coordinatereferencesystem',2479,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 117E',''),
(1924,'epsg_coordinatereferencesystem',2480,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 123E',''),
(1925,'epsg_coordinatereferencesystem',2481,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 129E',''),
(1926,'epsg_coordinatereferencesystem',2482,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 135E',''),
(1927,'epsg_coordinatereferencesystem',2483,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 141E',''),
(1928,'epsg_coordinatereferencesystem',2484,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 147E',''),
(1929,'epsg_coordinatereferencesystem',2485,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 153E',''),
(1930,'epsg_coordinatereferencesystem',2486,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 159E',''),
(1931,'epsg_coordinatereferencesystem',2487,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 165E',''),
(1932,'epsg_coordinatereferencesystem',2488,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 171E',''),
(1933,'epsg_coordinatereferencesystem',2489,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 177E',''),
(1934,'epsg_coordinatereferencesystem',2490,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 177W',''),
(1935,'epsg_coordinatereferencesystem',2491,7301,'Pulkovo 1995 / 6-degree Gauss-Kruger CM 171W',''),
(1936,'epsg_coordinatereferencesystem',2492,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 9E',''),
(1937,'epsg_coordinatereferencesystem',2493,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 15E',''),
(1938,'epsg_coordinatereferencesystem',2494,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 21E',''),
(1939,'epsg_coordinatereferencesystem',2495,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 27E',''),
(1940,'epsg_coordinatereferencesystem',2496,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 33E',''),
(1941,'epsg_coordinatereferencesystem',2497,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 39E',''),
(1942,'epsg_coordinatereferencesystem',2498,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 45E',''),
(1943,'epsg_coordinatereferencesystem',2499,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 51E',''),
(1944,'epsg_coordinatereferencesystem',2500,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 57E',''),
(1945,'epsg_coordinatereferencesystem',2501,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 63E',''),
(1946,'epsg_coordinatereferencesystem',2502,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 69E',''),
(1947,'epsg_coordinatereferencesystem',2503,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 75E',''),
(1948,'epsg_coordinatereferencesystem',2504,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 81E',''),
(1949,'epsg_coordinatereferencesystem',2505,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 87E',''),
(1950,'epsg_coordinatereferencesystem',2506,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 93E',''),
(1951,'epsg_coordinatereferencesystem',2507,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 99E',''),
(1952,'epsg_coordinatereferencesystem',2508,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 105E',''),
(1953,'epsg_coordinatereferencesystem',2509,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 111E',''),
(1954,'epsg_coordinatereferencesystem',2510,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 117E',''),
(1955,'epsg_coordinatereferencesystem',2511,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 123E',''),
(1956,'epsg_coordinatereferencesystem',2512,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 129E',''),
(1957,'epsg_coordinatereferencesystem',2513,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 135E',''),
(1958,'epsg_coordinatereferencesystem',2514,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 141E',''),
(1959,'epsg_coordinatereferencesystem',2515,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 147E',''),
(1960,'epsg_coordinatereferencesystem',2516,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 153E',''),
(1961,'epsg_coordinatereferencesystem',2517,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 159E',''),
(1962,'epsg_coordinatereferencesystem',2518,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 165E',''),
(1963,'epsg_coordinatereferencesystem',2519,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 171E',''),
(1964,'epsg_coordinatereferencesystem',2520,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 177E',''),
(1965,'epsg_coordinatereferencesystem',2521,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 177W',''),
(1966,'epsg_coordinatereferencesystem',2522,7301,'Pulkovo 1942 / 6-degree Gauss-Kruger CM 171W',''),
(1967,'epsg_unitofmeasure',9115,7302,'DM',''),
(1968,'epsg_unitofmeasure',9115,7306,'dega',''),
(1991,'epsg_coordinatereferencesystem',4327,7311,'DGN-95 (geographic 3D)','Datum Geodesi Nasional 1995 (DGN-95) is a synonym for WGS 84 in Indonesia.'),
(1992,'epsg_coordinatereferencesystem',4328,7311,'DGN-95 (geocentric)','Datum Geodesi Nasional 1995 (DGN-95) is a synonym for WGS 84 in Indonesia.'),
(1994,'epsg_coordoperation',1814,7301,'Genuk to WGS 84 (3)',''),
(1996,'epsg_datum',6820,7302,'Segara (Jakarta)',''),
(1997,'epsg_datum',6613,7302,'Segara',''),
(1998,'epsg_datum',6613,7301,'Samboja','Samboja-1 is one of two stations used as the baseline for extension to government triangulation by Total Indonesia in 1970-71.'),
(1999,'epsg_datum',6613,7301,'P2 Exc','P2 Exc is one of two stations used as the baseline for extension to government triangulation by Total Indonesia in 1970-71. P2 Exc is a replacement satellite station to the destroyed station P2.'),
(2000,'epsg_datum',6613,7301,'P2 Exc-T9','P2 Exc was a replacement satellite station to the destroyed station P2 from which several Toran stations including T9 were coordinated in 1970-71. When further control work was executed in 1995 P2 Exc was by then destroyed and T9 was used as its origin.'),
(2001,'epsg_coordinatereferencesystem',4613,7301,'Samboja','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and P2 Exc-T9.'),
(2002,'epsg_coordinatereferencesystem',4613,7301,'P2 Exc-T9','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and Samboja.'),
(2003,'epsg_coordinatereferencesystem',4613,7301,'P2 Exc','Oil industry extension in the Mahakam delta region. Also known as P2 Exc-T9 and Samboja.'),
(2004,'epsg_coordoperation',1838,7301,'Samboja to WGS 84 (4)',''),
(2005,'epsg_coordoperation',1838,7301,'P2 Exc-T9 to WGS 84 (4)',''),
(2006,'epsg_datum',6614,7302,'QND95',''),
(2008,'epsg_coordinatereferencesystem',2933,7301,'Samboja / UTM zone 50S',''),
(2009,'epsg_coordinatereferencesystem',2933,7301,'P2 Exc-T9 / UTM zone 50S',''),
(2010,'epsg_unitofmeasure',9110,7301,'sexagesimal degree',''),
(2011,'epsg_coordinatereferencesystem',2952,7301,'NAD83(CSRS) / SCoPQ zone 10',''),
(2012,'epsg_coordinatereferencesystem',2945,7301,'NAD83(CSRS) / SCoPQ zone 3',''),
(2013,'epsg_coordinatereferencesystem',2946,7301,'NAD83(CSRS) / SCoPQ zone 4',''),
(2014,'epsg_coordinatereferencesystem',2947,7301,'NAD83(CSRS) / SCoPQ zone 5',''),
(2015,'epsg_coordinatereferencesystem',2948,7301,'NAD83(CSRS) / SCoPQ zone 6',''),
(2016,'epsg_coordinatereferencesystem',2949,7301,'NAD83(CSRS) / SCoPQ zone 7',''),
(2017,'epsg_coordinatereferencesystem',2950,7301,'NAD83(CSRS) / SCoPQ zone 8',''),
(2018,'epsg_coordinatereferencesystem',2951,7301,'NAD83(CSRS) / SCoPQ zone 9',''),
(2019,'epsg_coordoperation',18071,7301,'Green Belt',''),
(2020,'epsg_coordinatereferencesystem',22991,7301,'Egypt 1907 / Green Belt',''),
(2021,'epsg_coordoperationparam',8806,7301,'False westing','This alias applies only in the case of projection methods which have an axis positive west, e.g. Transverse Mercator (South Orientated).'),
(2022,'epsg_coordoperationparam',8807,7301,'False southing','This alias applies only in the case of projection methods which have an axis positive south, e.g. Transverse Mercator (South Orientated).'),
(2023,'epsg_ellipsoid',7050,7301,'GRS 1967',''),
(2024,'epsg_coordoperation',18131,7301,'Zone 1 Nord Maroc',''),
(2025,'epsg_coordoperation',18132,7301,'Zone 2 Sud Maroc',''),
(2026,'epsg_coordoperation',18134,7301,'Zone 3 Sahara Nord',''),
(2027,'epsg_coordoperation',18135,7301,'Zone 4 Sahara Sud',''),
(2028,'epsg_coordinatereferencesystem',26191,7301,'Merchich / Zone 1 Nord Maroc',''),
(2029,'epsg_coordinatereferencesystem',26192,7301,'Merchich / Zone 2 Sud Maroc',''),
(2030,'epsg_coordinatereferencesystem',26194,7301,'Merchich / Zone 3 Sahara Nord',''),
(2031,'epsg_coordinatereferencesystem',26195,7301,'Merchich / Zone 4 Sahara Sud',''),
(2032,'epsg_datum',6620,7301,'12th Parallel traverse',''),
(2033,'epsg_coordinatereferencesystem',4620,7301,'12th Parallel traverse',''),
(2034,'epsg_datum',5131,7302,'Belfast',''),
(2035,'epsg_datum',5101,7301,'Newlyn',''),
(2036,'epsg_coordinatereferencesystem',5732,7301,'Belfast Lough',''),
(2038,'epsg_coordoperation',1887,7301,'Observatario Flores to WGS 84 (1)',''),
(2040,'epsg_coordoperation',1886,7301,'Graciosa to WGS 84 (1)',''),
(2041,'epsg_coordoperation',1885,7301,'Sao Braz to WGS 84 (1)',''),
(2042,'epsg_coordoperation',1890,7302,'AAD98 to WGS 84 (1)',''),
(2043,'epsg_coordinatereferencesystem',31281,7312,'Gebrauchsnetz M28',''),
(2044,'epsg_coordinatereferencesystem',31282,7312,'Gebrauchsnetz M31',''),
(2045,'epsg_coordinatereferencesystem',31283,7312,'Gebrauchsnetz M34',''),
(2046,'epsg_coordinatereferencesystem',31288,7312,'Bundesmeldenetz M28',''),
(2047,'epsg_coordinatereferencesystem',31289,7312,'Bundesmeldenetz M31',''),
(2048,'epsg_coordinatereferencesystem',31290,7312,'Bundesmeldenetz M34',''),
(2049,'epsg_coordoperation',5401,7301,'Belfast Lough to Malin Head',''),
(2051,'epsg_coordoperation',1895,7301,'RT90 to ETRS89 (2)','Supersedes RT90 to ETRS89 (1) (code 1437).'),
(2054,'epsg_unitofmeasure',104,7302,'DMH',''),
(2055,'epsg_unitofmeasure',102,7302,'Hdeg',''),
(2056,'epsg_unitofmeasure',102,7306,'dega',''),
(2057,'epsg_unitofmeasure',101,7302,'degH',''),
(2058,'epsg_unitofmeasure',101,7306,'dega',''),
(2059,'epsg_unitofmeasure',104,7306,'dega',''),
(2060,'epsg_unitofmeasure',105,7306,'dega',''),
(2061,'epsg_unitofmeasure',105,7302,'HDM',''),
(2062,'epsg_unitofmeasure',108,7302,'HDMS',''),
(2063,'epsg_unitofmeasure',108,7306,'dega',''),
(2064,'epsg_unitofmeasure',9121,7302,'DDDMMSS.sss',''),
(2065,'epsg_unitofmeasure',9121,7306,'dega',''),
(2066,'epsg_unitofmeasure',9120,7302,'HDMS',''),
(2067,'epsg_unitofmeasure',9120,7306,'dega',''),
(2068,'epsg_unitofmeasure',9119,7302,'HDM',''),
(2069,'epsg_unitofmeasure',9119,7306,'dega',''),
(2070,'epsg_unitofmeasure',9117,7302,'Hdeg',''),
(2071,'epsg_unitofmeasure',9117,7306,'dega',''),
(2072,'epsg_unitofmeasure',9118,7302,'DMH',''),
(2073,'epsg_unitofmeasure',9118,7306,'dega',''),
(2074,'epsg_unitofmeasure',9116,7302,'degH',''),
(2075,'epsg_unitofmeasure',9116,7306,'dega',''),
(2076,'epsg_datum',6637,7302,'Perroud 1950',''),
(2077,'epsg_datum',6634,7301,'MHNC72',''),
(2078,'epsg_datum',6627,7302,'RGR92',''),
(2079,'epsg_datum',6624,7302,'RGFG95',''),
(2080,'epsg_datum',6623,7302,'CSG67',''),
(2082,'epsg_datum',6648,7302,'ITRF89',''),
(2083,'epsg_datum',6649,7302,'ITRF90',''),
(2084,'epsg_datum',6650,7302,'ITRF91',''),
(2085,'epsg_datum',6651,7302,'ITRF92',''),
(2086,'epsg_datum',6652,7302,'ITRF93',''),
(2087,'epsg_datum',6653,7302,'ITRF94',''),
(2088,'epsg_datum',6654,7302,'ITRF96',''),
(2089,'epsg_datum',6655,7302,'ITRF97',''),
(2090,'epsg_datum',6656,7302,'ITRF2000',''),
(2091,'epsg_datum',6623,7301,'Guyane Francaise',''),
(2093,'epsg_datum',5151,7302,'NGNC69',''),
(2095,'epsg_coordinatereferencesystem',4346,7301,'ETRF89 (geocentric)',''),
(2096,'epsg_coordinatereferencesystem',4346,7301,'EUREF89 (geocentric)',''),
(2097,'epsg_datum',6638,7302,'St. Pierre et Miquelon 1950',''),
(2098,'epsg_coordinatereferencesystem',4638,7302,'St. Pierre et Miquelon 1950',''),
(2099,'epsg_coordinatereferencesystem',66386405,7302,'St Pierre et Miquelon 1950 (deg)',''),
(2100,'epsg_coordoperation',1923,7302,'St. Pierre et Miquelon 1950 to WGS 84 (1)',''),
(2101,'epsg_coordoperation',19981,7302,'Lambert NC',''),
(2102,'epsg_coordinatereferencesystem',2984,7302,'RGNC 1991 / Lambert NC',''),
(2103,'epsg_coordoperation',13633,7302,'Oregon Lambert',''),
(2104,'epsg_coordoperation',15374,7302,'Oregon Lambert (ft)',''),
(2106,'epsg_coordinatereferencesystem',2985,7302,'Petrels 1972 / Terre Adelie Stereo',''),
(2107,'epsg_coordinatereferencesystem',2986,7302,'Perroud 1950 / Terre Adelie Stereo',''),
(2108,'epsg_coordinatereferencesystem',4634,7301,'MHNC72',''),
(2109,'epsg_coordinatereferencesystem',66346405,7301,'MHNC72 (deg)',''),
(2110,'epsg_coordinatereferencesystem',2982,7301,'MHNC72 / UTM zone 58S',''),
(2111,'epsg_coordoperation',1909,7301,'Fort Desaix to RRAF 1991 (1)',''),
(2112,'epsg_coordoperation',1910,7301,'Fort Desaix to RRAF 1991 (2)',''),
(2113,'epsg_coordoperation',1903,7301,'Fort Marigot to RRAF 1991 (1)',''),
(2114,'epsg_coordoperation',1904,7301,'Sainte Anne to RRAF 1991 (1)',''),
(2115,'epsg_coordoperation',1905,7301,'Sainte Anne to RRAF 1991 (2)',''),
(2116,'epsg_datum',6647,7302,'ITRF88',''),
(2117,'epsg_datum',6645,7302,'RGNC91',''),
(2118,'epsg_datum',6640,7302,'RRAF91',''),
(2119,'epsg_coordinatereferencesystem',61436405,7301,'C\ufffd\ufffd\ufffdte D''Ivoire (deg)','Same alias also applied to Locodjo 1965 (deg) (code 61426405).'),
(2120,'epsg_coordinatereferencesystem',61436405,7301,'Port Bouet (deg)','Same alias also applied to Locodjo 1965 (deg) (code 61426405).'),
(2121,'epsg_coordinatereferencesystem',61766413,7302,'AAD98 (3D deg)',''),
(2122,'epsg_coordinatereferencesystem',4339,7302,'AAD98 (3D)',''),
(2123,'epsg_coordinatereferencesystem',61766405,7302,'AAD98 (deg)',''),
(2124,'epsg_coordinatereferencesystem',4340,7302,'AAD98 (geocentric)',''),
(2125,'epsg_coordinatereferencesystem',61836405,7301,'Graciosa (deg)','The same name is also used for the 1995 adjustment (see CRS code 66656405).'),
(2126,'epsg_coordinatereferencesystem',61826405,7301,'Observatorio Flores (deg)',''),
(2127,'epsg_coordinatereferencesystem',61846405,7301,'Sao Braz (deg)',''),
(2128,'epsg_coordinatereferencesystem',62116405,7301,'Genuk (deg)',''),
(2129,'epsg_coordinatereferencesystem',68136405,7301,'Genuk (Jakarta) (deg)',''),
(2130,'epsg_coordinatereferencesystem',62156405,7302,'BD 50 (deg)',''),
(2131,'epsg_coordinatereferencesystem',68096405,7302,'BD 50 (Brussels) (deg)',''),
(2132,'epsg_coordinatereferencesystem',63136405,7302,'BD 72 (deg)',''),
(2133,'epsg_coordinatereferencesystem',62276405,7301,'Levant (deg)',''),
(2134,'epsg_coordinatereferencesystem',63146405,7310,'PD/83 (deg)','Used for describing result of transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(2135,'epsg_coordinatereferencesystem',63146405,7310,'RD/83 (deg)','Used for describing result of transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(2136,'epsg_coordinatereferencesystem',62296405,7301,'Old Egyptian (deg)','New Egyptian (deg) is an alias for Egypt 1930 (deg) (code 61996405).'),
(2137,'epsg_coordinatereferencesystem',61996405,7301,'New Egyptian (deg)','Old Egyptian (deg) is an alias for Egypt 1907 (deg) (code 62296405).'),
(2138,'epsg_coordinatereferencesystem',62586413,7301,'ETRF89 (3D deg)',''),
(2139,'epsg_coordinatereferencesystem',4345,7301,'ETRF89 (3D)',''),
(2140,'epsg_coordinatereferencesystem',62586405,7301,'ETRF89 (deg)',''),
(2141,'epsg_coordinatereferencesystem',62586413,7301,'EUREF89 (3D deg)',''),
(2142,'epsg_coordinatereferencesystem',4345,7301,'EUREF89 (3D)',''),
(2143,'epsg_coordinatereferencesystem',62586405,7301,'EUREF89 (deg)',''),
(2144,'epsg_coordinatereferencesystem',61326405,7301,'Final Datum 1958 (Iran) (deg)',''),
(2145,'epsg_coordinatereferencesystem',66116405,7302,'HK1980 (deg)',''),
(2146,'epsg_coordinatereferencesystem',62076405,7301,'Lisbon 1937 (deg)',''),
(2147,'epsg_coordinatereferencesystem',68036405,7301,'Lisbon 1937 (Lisbon) (deg)',''),
(2148,'epsg_coordinatereferencesystem',4356,7302,'LKS94 (geocentric)',''),
(2149,'epsg_coordinatereferencesystem',61266405,7302,'LKS94 (deg)',''),
(2150,'epsg_coordinatereferencesystem',4126,7302,'LKS94','This same alias is used for both geographical and projected CRSs.'),
(2151,'epsg_coordinatereferencesystem',4355,7302,'LKS94 (3D)',''),
(2152,'epsg_coordinatereferencesystem',61266413,7302,'LKS94 (3D deg)',''),
(2153,'epsg_coordinatereferencesystem',61426405,7301,'C\ufffd\ufffd\ufffdte D''Ivoire (deg)','Same alias also applied to Abidjan 1987 (deg) (code 61436405).'),
(2154,'epsg_coordinatereferencesystem',61426405,7301,'Port Bouet (deg)','Same alias also applied to Abidjan 1987 (deg) (code 61436405).'),
(2155,'epsg_coordinatereferencesystem',61816405,7301,'LUREF (deg)',''),
(2156,'epsg_coordinatereferencesystem',63126405,7309,'D48 (deg)',''),
(2157,'epsg_coordinatereferencesystem',68056405,7309,'D48 (Ferro) (deg)',''),
(2158,'epsg_coordinatereferencesystem',63126405,7308,'HR1901 (deg)',''),
(2159,'epsg_coordinatereferencesystem',68056405,7308,'HR1901 (Ferro) (deg)',''),
(2160,'epsg_coordinatereferencesystem',62686405,7302,'NAD Michigan (deg)',''),
(2161,'epsg_coordinatereferencesystem',66096405,7302,'CGQ77 (deg)',''),
(2162,'epsg_coordinatereferencesystem',62726405,7301,'GD49 (deg)',''),
(2163,'epsg_coordinatereferencesystem',61346405,7302,'PSD93 (deg)',''),
(2164,'epsg_coordinatereferencesystem',66206405,7301,'12th Parallel traverse (deg)',''),
(2165,'epsg_coordinatereferencesystem',62826405,7301,'Congo 1960 Pointe Noire (deg)',''),
(2166,'epsg_coordinatereferencesystem',61906413,7301,'National Geodetic System [Argentina] (3D deg)','see http://www.igm.gov.ar/posgar.html'),
(2167,'epsg_coordinatereferencesystem',4365,7301,'National Geodetic System [Argentina] (3D)','see http://www.igm.gov.ar/posgar.html'),
(2168,'epsg_coordinatereferencesystem',61906405,7301,'National Geodetic System [Argentina] (deg)','see http://www.igm.gov.ar/posgar.html'),
(2169,'epsg_coordinatereferencesystem',4366,7301,'National Geodetic System [Argentina] (geocentric)','see http://www.igm.gov.ar/posgar.html'),
(2170,'epsg_coordinatereferencesystem',61786405,7301,'42/83 (deg)',''),
(2171,'epsg_coordinatereferencesystem',66136405,7301,'P2 Exc (deg)','Oil industry extension in the Mahakam delta region. Also known as P2 Exc-T9 and Samboja.'),
(2172,'epsg_coordinatereferencesystem',66136405,7301,'P2 Exc-T9 (deg)','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and Samboja.'),
(2173,'epsg_coordinatereferencesystem',66136405,7301,'Samboja (deg)','Oil industry extension in the Mahakam delta region. Also known as P2 Exc and P2 Exc-T9.'),
(2174,'epsg_coordinatereferencesystem',4820,7301,'Samboja (Jakarta)',''),
(2175,'epsg_coordinatereferencesystem',68206405,7301,'Samboja (Jakarta) (deg)',''),
(2176,'epsg_coordinatereferencesystem',63006405,7301,'1975 Mapping Adjustment (deg)',''),
(2177,'epsg_coordinatereferencesystem',63266405,7311,'DGN-95 (deg)','Datum Geodesi Nasional 1995 (DGN-95) is a synonym for WGS 84 in Indonesia.'),
(2179,'epsg_area',2832,7302,'BC',''),
(2180,'epsg_coordoperation',19984,7302,'BC Albers',''),
(2181,'epsg_coordoperation',17311,7301,'7.5 gon V 0:-15',''),
(2182,'epsg_coordoperation',17312,7301,'5 gon V 0:-15',''),
(2183,'epsg_coordoperation',17313,7301,'0 gon 0:-15',''),
(2184,'epsg_coordoperation',17314,7301,'2.5 gon O 0:-15',''),
(2185,'epsg_coordoperation',17315,7301,'5 gon O 0:-15',''),
(2186,'epsg_coordoperation',19929,7301,'2.5 gon V 0:-15',''),
(2187,'epsg_coordoperation',19929,7301,'Swedish National Projection',''),
(2188,'epsg_coordinatereferencesystem',3019,7301,'RT90 7.5 gon V 0:-15',''),
(2190,'epsg_coordinatereferencesystem',3020,7301,'RT90 5 gon V 0:-15',''),
(2191,'epsg_coordinatereferencesystem',3021,7301,'RT90 2.5 gon V 0:-15',''),
(2192,'epsg_coordinatereferencesystem',3022,7301,'RT90 0 gon 0:-15',''),
(2193,'epsg_coordinatereferencesystem',3023,7301,'RT90 2.5 gon O 0:-15',''),
(2194,'epsg_coordinatereferencesystem',3024,7301,'RT90 5 gon O 0:-15',''),
(2195,'epsg_datum',6659,7302,'ISN93',''),
(2196,'epsg_coordoperation',19985,7301,'ETRS-LCC',''),
(2197,'epsg_coordoperation',19986,7301,'ETRS-LAEA',''),
(2199,'epsg_datum',6300,7302,'TM75',''),
(2200,'epsg_datum',6300,7301,'1975 Mapping Adjustment',''),
(2201,'epsg_coordoperation',1953,7307,'(IE_Ireland65 to ETRS89 - see alias remarks)','IE_Ireland65 to ETRS89 applies to the Republic of Ireland. Also referred to in EuroGeographics as NI_Ireland65 to ETRS89 for Northern Ireland.'),
(2202,'epsg_unitofmeasure',9095,7302,'ftBr(36)',''),
(2203,'epsg_unitofmeasure',9095,7306,'ftBr(36)',''),
(2204,'epsg_unitofmeasure',9095,7301,'foot',''),
(2205,'epsg_datum',5153,7302,'NGG1977',''),
(2206,'epsg_datum',5154,7301,'Martinique 1987',''),
(2208,'epsg_datum',5159,7301,'IGN89',''),
(2209,'epsg_datum',5156,7301,'Reunion 1989',''),
(2210,'epsg_datum',5156,7302,'IGN89',''),
(2211,'epsg_datum',5155,7301,'IGN 1988',''),
(2212,'epsg_datum',5154,7302,'IGN87',''),
(2214,'epsg_datum',6661,7302,'LKS92',''),
(2215,'epsg_datum',6615,7301,'Madeira SE Base',''),
(2216,'epsg_datum',6665,7301,'Graciosa','The same name is also used for the 1948 adjustment (see datum code 6183).'),
(2217,'epsg_datum',6665,7302,'Azores Central 1995',''),
(2218,'epsg_datum',6665,7301,'Base SW','The same name is also used for the 1948 adjustment (see datum code 6183).'),
(2219,'epsg_datum',6183,7301,'Base SW','The same name is also used for the 1995 adjustment (see datum code 6665).'),
(2220,'epsg_datum',6664,7301,'Sao Bras','The same name is also used for the 1940 adjustment (see datum code 6184).'),
(2221,'epsg_datum',6664,7302,'Azores Oriental 1995',''),
(2222,'epsg_datum',6615,7301,'Base SE','The same name is also used for the 1995 adjustment (see datum code 6663).'),
(2223,'epsg_datum',6663,7301,'Base SE','The same name is also used for the 1936 adjustment (see datum code 6615).'),
(2224,'epsg_datum',6663,7301,'Madeira SE Base 1995',''),
(2225,'epsg_coordinatereferencesystem',4183,7301,'Base SW','The same name is also used for the 1995 adjustment (see CRS code 4665).'),
(2226,'epsg_coordinatereferencesystem',4665,7301,'Base SW','The same name is also used for the 1948 adjustment (see CRS code 4183).'),
(2227,'epsg_coordinatereferencesystem',4665,7301,'Graciosa','The same name is also used for the 1948 adjustment (see CRS code 4183).'),
(2228,'epsg_coordinatereferencesystem',2189,7301,'Base SW / UTM zone 26N','The same name is also used for the 1995 adjustment (see CRS code 3063).'),
(2229,'epsg_coordinatereferencesystem',4664,7301,'Sao Braz','The same name is also used for the 1940 adjustment (see CRS code 4184).'),
(2230,'epsg_coordinatereferencesystem',3062,7301,'Sao Braz / UTM zone 26N','The same name is also used for the 1940 adjustment (see CRS code 2190).'),
(2231,'epsg_coordinatereferencesystem',3063,7301,'Base SW / UTM zone 26N','The same name is also used for the 1948 adjustment (see CRS code 2189).'),
(2232,'epsg_coordinatereferencesystem',3063,7301,'Graciosa / UTM zone 26N','The same name is also used for the 1948 adjustment (see CRS code 2189).'),
(2233,'epsg_coordinatereferencesystem',4615,7301,'Porto Santo 1936',''),
(2234,'epsg_coordinatereferencesystem',4663,7301,'Base SE','The same name is also used for the 1936 adjustment (see CRS code 4615).'),
(2235,'epsg_coordinatereferencesystem',2942,7301,'Base SE / UTM zone 28N','The same name is also used for the 1995 adjustment (see CRS code 3061).'),
(2236,'epsg_coordinatereferencesystem',3061,7301,'Base SE / UTM zone 28N','The same name is also used for the 1948 adjustment (see CRS code 2942).'),
(2237,'epsg_datum',6615,7301,'Porto Santo',''),
(2238,'epsg_coordoperation',1886,7301,'Base SW to WGS 84 (1)',''),
(2239,'epsg_coordoperation',1888,7301,'Base SE to WGS 84 (1)',''),
(2240,'epsg_coordoperation',1966,7301,'Base SE to WGS 84 (2)',''),
(2241,'epsg_coordoperation',1967,7301,'Base SE to WGS 84 (3)',''),
(2242,'epsg_coordoperation',1980,7301,'Graciosa to WGS 84 (10)',''),
(2243,'epsg_coordoperation',1981,7301,'Base SW to WGS 84 (11)',''),
(2244,'epsg_coordoperation',1972,7301,'Base SW to WGS 84 (2)',''),
(2245,'epsg_coordoperation',1973,7301,'Base SW to WGS 84 (3)',''),
(2246,'epsg_coordoperation',1974,7301,'Base SW to WGS 84 (4)',''),
(2247,'epsg_coordoperation',1975,7301,'Base SW to WGS 84 (5)',''),
(2248,'epsg_coordoperation',1976,7301,'Base SW to WGS 84 (6)',''),
(2249,'epsg_coordoperation',1977,7301,'Base SW to WGS 84 (7)',''),
(2250,'epsg_coordoperation',1978,7301,'Base SW to WGS 84 (8)',''),
(2251,'epsg_coordoperation',1979,7301,'Base SW to WGS 84 (9)',''),
(2252,'epsg_coordoperation',1980,7301,'Base SW to WGS 84 (10)',''),
(2253,'epsg_coordoperation',1981,7301,'Graciosa to WGS 84 (11)',''),
(2254,'epsg_coordoperation',1972,7301,'Graciosa to WGS 84 (2)',''),
(2255,'epsg_coordoperation',1973,7301,'Graciosa to WGS 84 (3)',''),
(2256,'epsg_coordoperation',1974,7301,'Graciosa to WGS 84 (4)',''),
(2257,'epsg_coordoperation',1975,7301,'Graciosa to WGS 84 (5)',''),
(2258,'epsg_coordoperation',1976,7301,'Graciosa to WGS 84 (6)',''),
(2259,'epsg_coordoperation',1977,7301,'Graciosa to WGS 84 (7)',''),
(2260,'epsg_coordoperation',1978,7301,'Graciosa to WGS 84 (8)',''),
(2261,'epsg_coordoperation',1979,7301,'Graciosa to WGS 84 (9)',''),
(2262,'epsg_coordoperation',1992,7302,'D73 to ETRS89 (3)',''),
(2263,'epsg_coordoperation',1968,7301,'Sao Braz to WGS 84 (2)',''),
(2264,'epsg_coordoperation',1969,7301,'Sao Braz to WGS 84 (3)',''),
(2265,'epsg_coordoperation',1970,7301,'Sao Braz to WGS 84 (4)',''),
(2266,'epsg_coordoperation',1971,7301,'Sao Braz to WGS 84 (5)',''),
(2267,'epsg_coordoperation',1982,7301,'Observatario Flores to WGS 84 (2)',''),
(2268,'epsg_coordoperation',1984,7301,'Lisbon 1937 to WGS 84 (3)',''),
(2269,'epsg_coordoperation',1756,7301,'Lisbon 1937 (Lisbon) to Lisbon 1937 (1)',''),
(2270,'epsg_coordoperation',8637,7301,'Lisbon 1937 (Lisbon) to WGS 84 (1)',''),
(2271,'epsg_coordoperation',1655,7301,'Lisbon 1937 to ETRS89 (1)',''),
(2272,'epsg_coordoperation',1790,7301,'Lisbon 1937 to ETRS89 (2)',''),
(2273,'epsg_coordoperation',1988,7302,'Lisbon 1937 to WGS 84 (4)',''),
(2274,'epsg_coordoperation',17336,7301,'0 gon 0:-15',''),
(2275,'epsg_coordoperation',17337,7301,'2.5 gon O 0:-15',''),
(2276,'epsg_coordoperation',17338,7301,'5 gon O 0:-15',''),
(2277,'epsg_coordoperation',17335,7301,'5 gon V 0:-15',''),
(2278,'epsg_coordoperation',17334,7301,'7.5 gon V 0:-15',''),
(2279,'epsg_coordinatereferencesystem',3028,7301,'RT38 0 gon 0:-15',''),
(2280,'epsg_coordinatereferencesystem',3029,7301,'RT38 2.5 gon O 0:-15',''),
(2281,'epsg_coordinatereferencesystem',3027,7301,'RT38 2.5 gon V 0:-15',''),
(2282,'epsg_coordinatereferencesystem',3030,7301,'RT38 5 gon O 0:-15',''),
(2283,'epsg_coordinatereferencesystem',3026,7301,'RT38 5 gon V 0:-15',''),
(2284,'epsg_coordinatereferencesystem',3025,7301,'RT38 2.5 gon V 0:-15',''),
(2285,'epsg_datum',6667,7301,'IKBD-92',''),
(2286,'epsg_unitofmeasure',9122,7302,'deg',''),
(2287,'epsg_unitofmeasure',9122,7306,'dega',''),
(2288,'epsg_coordinatereferencesystem',66656405,7301,'Base SW (deg)','The same name is also used for the 1948 adjustment (see CRS code 61836405).'),
(2289,'epsg_coordinatereferencesystem',61836405,7301,'Base SW (deg)','The same name is also used for the 1995 adjustment (see CRS code 66656405).'),
(2290,'epsg_coordinatereferencesystem',66656405,7301,'Graciosa (deg)','The same name is also used for the 1948 adjustment (see CRS code 61836405).'),
(2291,'epsg_coordinatereferencesystem',66646405,7301,'Sao Braz (deg)','The same name is also used for the 1940 adjustment (see CRS code 61846405).'),
(2292,'epsg_coordinatereferencesystem',4615,7301,'Base SE','The same name is also used for the 1995 adjustment (see CRS code 4663).'),
(2293,'epsg_coordinatereferencesystem',66156405,7301,'Base SE (deg)','The same name is also used for the 1936 adjustment (see CRS code 66636405).'),
(2294,'epsg_coordinatereferencesystem',66636405,7301,'Base SE (deg)','The same name is also used for the 1936 adjustment (see CRS code 66156405).'),
(2295,'epsg_coordinatereferencesystem',66156405,7301,'Porto Santo 1936 (deg)',''),
(2296,'epsg_coordoperation',1792,7302,'D73 to ETRS89 (2)',''),
(2297,'epsg_coordoperation',1657,7302,'D73 to ETRS89 (1)',''),
(2298,'epsg_coordoperation',1983,7302,'D73 to WGS 84 (3)',''),
(2299,'epsg_coordoperation',1987,7302,'D73 to WGS 84 (4)',''),
(2300,'epsg_coordoperation',1986,7302,'B DLx to WGS 84 (1)',''),
(2301,'epsg_coordoperation',1990,7302,'B DLx to WGS 84 (2)',''),
(2302,'epsg_coordoperation',1655,7302,'DLx to ETRS89 (1)',''),
(2303,'epsg_coordoperation',1790,7302,'DLx to ETRS89 (2)',''),
(2304,'epsg_coordoperation',1984,7302,'DLx to WGS 84 (3)',''),
(2305,'epsg_coordoperation',1988,7302,'DLx to WGS 84 (3)',''),
(2306,'epsg_coordinatereferencesystem',25884,7301,'LKS92 / TM Baltic93','Alias used in Latvia.'),
(2307,'epsg_coordinatereferencesystem',25884,7301,'LKS94 / TM Baltic93','Alias used in Lithuania.'),
(2308,'epsg_coordinatereferencesystem',25884,7301,'EST97 / TM Baltic93','Alias used in Estonia.'),
(2309,'epsg_coordinatereferencesystem',3300,7301,'EST92','This same alias is used for both geographical and projected CRSs.'),
(2310,'epsg_coordinatereferencesystem',3301,7301,'EST97','This same alias is used for both geographical and projected CRSs.'),
(2311,'epsg_coordinatereferencesystem',3059,7301,'LKS92','This alias is used for both geographical and projected CRSs.'),
(2312,'epsg_coordoperation',1997,7302,'DLx to ETRS89 (2)',''),
(2313,'epsg_coordoperation',1997,7301,'Lisbon 1937 to ETRS89 (2)',''),
(2314,'epsg_datum',6668,7302,'ED79',''),
(2315,'epsg_datum',6131,7301,'Indian (DMA Reduced)',''),
(2316,'epsg_coordinatereferencesystem',4131,7301,'Indian (DMA Reduced)',''),
(2317,'epsg_coordinatereferencesystem',61316405,7301,'Indian (DMA Reduced) (deg)',''),
(2318,'epsg_coordinatereferencesystem',3176,7301,'Indian (DMA Reduced) / TM 106 NE',''),
(2319,'epsg_coordinatereferencesystem',3148,7301,'Indian (DMA Reduced) / UTM zone 48N',''),
(2320,'epsg_coordinatereferencesystem',3149,7301,'Indian (DMA Reduced) / UTM zone 49N',''),
(2321,'epsg_coordinatereferencesystem',4930,7302,'AAD98',''),
(2322,'epsg_coordinatereferencesystem',4936,7301,'ETRF89',''),
(2323,'epsg_coordinatereferencesystem',4936,7301,'EUREF89',''),
(2324,'epsg_coordinatereferencesystem',4960,7301,'National Geodetic System [Argentina]','See information source.'),
(2326,'epsg_coordinatereferencesystem',4950,7301,'LKS94 (ETRS89)',''),
(2327,'epsg_coordinatereferencesystem',4931,7302,'AAD98',''),
(2328,'epsg_coordinatereferencesystem',4937,7301,'ETRF89',''),
(2329,'epsg_coordinatereferencesystem',4937,7301,'EUREF89',''),
(2330,'epsg_coordinatereferencesystem',4951,7301,'LKS94 (ETRS89)',''),
(2331,'epsg_coordinatereferencesystem',4961,7301,'National Geodetic System [Argentina]','See information source.'),
(2333,'epsg_datum',6265,7301,'Rome 1940',''),
(2334,'epsg_datum',6806,7301,'Rome 1940 (Rome)',''),
(2335,'epsg_datum',6670,7302,'IGM95',''),
(2336,'epsg_coordinatereferencesystem',4265,7301,'Rome 1940',''),
(2337,'epsg_coordinatereferencesystem',4806,7301,'Rome 1940 (Rome)',''),
(2338,'epsg_coordinatereferencesystem',3004,7301,'Rome 1940 / Italy zone 2',''),
(2339,'epsg_coordinatereferencesystem',3003,7301,'Rome 1940 / Italy zone 1',''),
(2340,'epsg_coordoperation',1094,7301,'Rome 1940 to WGS 84 (11)',''),
(2341,'epsg_coordoperation',1093,7301,'Rome 1940 to WGS 84 (10)',''),
(2342,'epsg_coordoperation',1092,7301,'Rome 1940 to WGS 84 (9)',''),
(2343,'epsg_coordoperation',1091,7301,'Rome 1940 to WGS 84 (8)',''),
(2344,'epsg_coordoperation',1090,7302,'Rome 1940 to WGS 84 (7)',''),
(2345,'epsg_coordoperation',1089,7301,'Rome 1940 to WGS 84 (6)',''),
(2346,'epsg_coordoperation',1088,7301,'Rome 1940 to WGS 84 (5)',''),
(2347,'epsg_coordoperation',1664,7301,'Rome 1940 to WGS 84 (3)',''),
(2348,'epsg_coordoperation',1663,7301,'Rome 1940 to ETRS89 (3)',''),
(2349,'epsg_coordoperation',1661,7301,'Rome 1940 to ETRS89 (2)',''),
(2350,'epsg_coordoperation',1660,7301,'Rome 1940 to WGS 84 (4)',''),
(2351,'epsg_coordoperation',1169,7301,'Rome 1940 to WGS 84 (1)',''),
(2352,'epsg_coordoperation',1662,7301,'Rome 1940 to WGS 84 (2)',''),
(2353,'epsg_coordoperation',1659,7301,'Rome 1940 to ETRS89 (1)',''),
(2354,'epsg_coordoperation',19995,7302,'Jordan TM',''),
(2355,'epsg_coordinatereferencesystem',3066,7301,'ED50 / Jordan Transverse Mercator',''),
(2356,'epsg_datum',6673,7302,'CI1979',''),
(2357,'epsg_coordoperation',16065,7301,'UTM zone 35N',''),
(2358,'epsg_datum',5172,7302,'NG-L',''),
(2359,'epsg_coordoperation',1642,7302,'LUREF to ETRS89 (1)',''),
(2360,'epsg_coordoperation',1643,7302,'LUREF to WGS 84 (1)',''),
(2361,'epsg_coordoperation',1079,7302,'LUREF to WGS 84 (2)',''),
(2362,'epsg_coordoperation',1078,7302,'LUREF to ETRS89 (1)',''),
(2363,'epsg_datum',5174,7302,'NN1954',''),
(2364,'epsg_datum',5173,7301,'TNVCN99',''),
(2365,'epsg_coordoperation',10021,7302,'ETRS89 to ODN (1)',''),
(2366,'epsg_coordoperation',10022,7301,'ETRS89 to Belfast Lough (1)',''),
(2367,'epsg_datum',6173,7301,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(2368,'epsg_coordinatereferencesystem',2157,7302,'ETRS89 / ITM','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(2370,'epsg_coordinatereferencesystem',4173,7301,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(2371,'epsg_coordoperationmethod',9636,7301,'Molodenski-Badekas transformation',''),
(2372,'epsg_coordoperationmethod',9607,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Position Vector 7-param. Transformation method (code 9606).'),
(2373,'epsg_coordoperationmethod',9606,7301,'Bursa-Wolf','This names is ambiguous as it is also applied to the Coordinate Frame rotation method (code 9607).'),
(2374,'epsg_coordoperation',1071,7301,'Old Israeli to New Israeli (1)',''),
(2375,'epsg_coordoperation',1072,7301,'Old Israel to New Israel (1)',''),
(2376,'epsg_datum',6141,7301,'New Israeli Datum',''),
(2377,'epsg_datum',6281,7301,'Old Israeli Datum','Alias used within Israel.'),
(2378,'epsg_datum',6281,7302,'OID','Abbreviation of "Old Israeli Datum"; used within Israel.'),
(2379,'epsg_datum',6141,7302,'NID','Abbreviation of "New Israeli Datum"; used within Israel.'),
(2380,'epsg_datum',6674,7302,'SIRGAS 2000',''),
(2381,'epsg_coordinatereferencesystem',4269,7301,'NAD83 (1986)',''),
(2382,'epsg_coordinatereferencesystem',4170,7301,'SIRGAS 1995',''),
(2383,'epsg_coordinatereferencesystem',4974,7301,'SIRGAS 1995',''),
(2384,'epsg_coordinatereferencesystem',32000,7301,'SIRGAS 1995 / UTM zone 25S',''),
(2385,'epsg_coordinatereferencesystem',31999,7301,'SIRGAS 1995 / UTM zone 24S',''),
(2386,'epsg_coordinatereferencesystem',31998,7301,'SIRGAS 1995 / UTM zone 23S',''),
(2387,'epsg_coordinatereferencesystem',31997,7301,'SIRGAS 1995 / UTM zone 22S',''),
(2388,'epsg_coordinatereferencesystem',31996,7301,'SIRGAS 1995 / UTM zone 21S',''),
(2389,'epsg_coordinatereferencesystem',31995,7301,'SIRGAS 1995 / UTM zone 20S',''),
(2390,'epsg_coordinatereferencesystem',31994,7301,'SIRGAS 1995 / UTM zone 19S',''),
(2391,'epsg_coordinatereferencesystem',31993,7301,'SIRGAS 1995 / UTM zone 18S',''),
(2392,'epsg_coordinatereferencesystem',31992,7301,'SIRGAS 1995 / UTM zone 17S',''),
(2393,'epsg_coordinatereferencesystem',31991,7301,'SIRGAS 1995 / UTM zone 22N',''),
(2394,'epsg_coordinatereferencesystem',31990,7301,'SIRGAS 1995 / UTM zone 21N',''),
(2395,'epsg_coordinatereferencesystem',31989,7301,'SIRGAS 1995 / UTM zone 20N',''),
(2396,'epsg_coordinatereferencesystem',31988,7301,'SIRGAS 1995 / UTM zone 19N',''),
(2397,'epsg_coordinatereferencesystem',31987,7301,'SIRGAS 1995 / UTM zone 18N',''),
(2398,'epsg_coordinatereferencesystem',31986,7301,'SIRGAS 1995 / UTM zone 17N',''),
(2399,'epsg_coordinatereferencesystem',4975,7301,'SIRGAS 1995',''),
(2401,'epsg_coordinatereferencesystem',3069,7302,'NAD27 / WTM 27',''),
(2402,'epsg_coordinatereferencesystem',5723,7302,'JSLD',''),
(2403,'epsg_coordoperation',15545,7301,'SIRGAS 1995 geog3D to geog2D',''),
(2406,'epsg_coordoperation',15544,7301,'SIRGAS 1995 geocentric to geog3D',''),
(2407,'epsg_coordoperation',15508,7301,'ETRF89 geocentric to geog3D',''),
(2408,'epsg_coordoperation',15508,7301,'EUREF89 geocentric to geog3D',''),
(2409,'epsg_coordoperation',15509,7301,'ETRF89 geocentric to geog3D',''),
(2410,'epsg_coordoperation',15509,7301,'EUREF89 geocentric to geog3D',''),
(2411,'epsg_coordoperation',15500,7302,'AAD98 geocentric to geog3D',''),
(2412,'epsg_coordoperation',15501,7302,'AAD98 geog3D to geog2D',''),
(2413,'epsg_datum',6678,7302,'Lao 1997',''),
(2414,'epsg_datum',5182,7302,'DHHN85',''),
(2415,'epsg_datum',5183,7302,'SNN76',''),
(2417,'epsg_coordoperation',5412,7302,'CD to PWD (1)',''),
(2418,'epsg_coordoperation',5413,7302,'CD to WD',''),
(2419,'epsg_coordoperation',5414,7302,'WD to PWD',''),
(2420,'epsg_datum',5172,7302,'NG95',''),
(2421,'epsg_datum',5176,7302,'GHA',''),
(2422,'epsg_datum',5177,7302,'NVN99',''),
(2423,'epsg_datum',5178,7301,'RNGAP',''),
(2424,'epsg_datum',5180,7301,'REDNAP',''),
(2425,'epsg_datum',5181,7302,'DHHN92',''),
(2426,'epsg_datum',5185,7301,'EOMA 1980',''),
(2427,'epsg_datum',5186,7302,'PWD',''),
(2428,'epsg_datum',5187,7302,'WD',''),
(2429,'epsg_datum',5188,7302,'CD',''),
(2431,'epsg_coordinatereferencesystem',5787,7301,'Baltic 1980',''),
(2432,'epsg_coordinatereferencesystem',5782,7301,'REDNAP',''),
(2435,'epsg_coordinatereferencesystem',3072,7301,'Maine Coordinate System of 2000 East Zone','This alias also used for NAD83(HARN) / Maine CS2000 East.'),
(2436,'epsg_coordinatereferencesystem',3073,7301,'Maine Coordinate System of 2000 Central Zone','This alias also used for NAD83(HARN) / Maine CS2000 Central.'),
(2437,'epsg_coordinatereferencesystem',3074,7301,'Maine Coordinate System of 2000 West Zone','This alias also used for NAD83(HARN) / Maine CS2000 West.'),
(2438,'epsg_coordinatereferencesystem',2802,7301,'Maine Coordinate System of 1983 East Zone','This alias also used for NAD83 / Maine East.'),
(2439,'epsg_coordinatereferencesystem',2803,7302,'Maine Coordinate System of 1983 West Zone','This alias also used for NAD83 / Maine West.'),
(2440,'epsg_coordinatereferencesystem',26783,7301,'Maine Coordinate System of 1927 East Zone',''),
(2441,'epsg_coordinatereferencesystem',26784,7301,'Maine Coordinate System of 1927 West Zone',''),
(2442,'epsg_coordinatereferencesystem',26984,7301,'Maine Coordinate System of 1983 West Zone','This alias also used for NAD83(HARN) / Maine West.'),
(2443,'epsg_coordinatereferencesystem',26983,7301,'Maine Coordinate System of 1983 East Zone','This alias also used for NAD83(HARN) / Maine East.'),
(2444,'epsg_coordoperation',12150,7301,'Michigan GeoRef',''),
(2445,'epsg_coordinatereferencesystem',3078,7301,'Michigan GeoRef','This alias also used for NAD83(HARN) / Michigan Oblique Mercator.'),
(2446,'epsg_coordoperation',14251,7302,'TSMS',''),
(2447,'epsg_coordoperation',14254,7302,'TCMS/AEA',''),
(2448,'epsg_coordoperation',14253,7302,'TCMS/LC',''),
(2449,'epsg_coordinatereferencesystem',3081,7302,'NAD83 / TSMS',''),
(2450,'epsg_coordinatereferencesystem',3083,7302,'TCMS/AEA','This abbreviation also used for NAD83(HARN) / Texas Centric Albers Equal Area.'),
(2451,'epsg_coordinatereferencesystem',3083,7301,'Texas Centric Mapping System / Albers Equal Area','This alias also used for NAD83(HARN) / Texas Centric Albers Equal Area.'),
(2452,'epsg_coordinatereferencesystem',3082,7301,'Texas Centric Mapping System / Lambert Conformal','This alias also used for NAD83(HARN) / Texas Centric Lambert Conformal.'),
(2453,'epsg_coordinatereferencesystem',3082,7302,'TCMS/LC','This abbreviation also used for NAD83(HARN) / Texas Centric Lambert Conformal.'),
(2454,'epsg_coordoperation',19997,7302,'KTM',''),
(2455,'epsg_coordoperation',10088,7302,'JAD69 / National Grid to Ja1875 / Old Grid (1)',''),
(2456,'epsg_coordoperation',10087,7302,'Ja1875 / Old Grid to JAD69 / National Grid (1)',''),
(2457,'epsg_coordoperation',15527,7301,'NAD83(HPGN) geog3D to geog2D',''),
(2458,'epsg_coordoperation',15526,7301,'NAD83(HPGN) geocentric to geog3D',''),
(2459,'epsg_coordinatereferencesystem',3091,7301,'NAD83(HPGN) / Kentucky Single Zone (ftUS)',''),
(2460,'epsg_coordinatereferencesystem',3089,7301,'NAD83 / Kentucky (ftUS)',''),
(2461,'epsg_coordinatereferencesystem',3087,7301,'NAD83(HPGN) / Florida GDL Albers',''),
(2462,'epsg_coordinatereferencesystem',3085,7301,'NAD83(HPGN) / Texas Centric Albers Equal Area',''),
(2463,'epsg_coordinatereferencesystem',3084,7301,'NAD83(HPGN) / Texas Centric Lambert Conformal',''),
(2464,'epsg_coordinatereferencesystem',3079,7301,'NAD83(HPGN) / Michigan Oblique Mercator',''),
(2465,'epsg_coordinatereferencesystem',3077,7301,'NAD83(HPGN) / Maine CS2000 West',''),
(2466,'epsg_coordinatereferencesystem',3076,7301,'NAD83(HPGN) / Maine CS2000 Central',''),
(2467,'epsg_coordinatereferencesystem',3075,7301,'NAD83(HPGN) / Maine CS2000 East',''),
(2468,'epsg_coordinatereferencesystem',3071,7301,'NAD83(HPGN) / Wisconsin Transverse Mercator',''),
(2469,'epsg_coordinatereferencesystem',3070,7302,'NAD83 / WTM 83',''),
(2470,'epsg_coordinatereferencesystem',3088,7301,'NAD83 / Kentucky',''),
(2471,'epsg_coordinatereferencesystem',3090,7301,'NAD83(HARN) / Kentucky',''),
(2472,'epsg_coordinatereferencesystem',3091,7301,'NAD83(HARN) / Kentucky (ftUS)',''),
(2473,'epsg_coordinatereferencesystem',3090,7301,'NAD83(HPGN) / Kentucky Single Zone',''),
(2474,'epsg_datum',6152,7301,'NAD83 (High Precision Geodetic Network)',''),
(2475,'epsg_datum',6152,7301,'NAD83 (HPGN)',''),
(2476,'epsg_coordinatereferencesystem',4152,7301,'NAD83(HPGN)',''),
(2477,'epsg_coordinatereferencesystem',4956,7301,'NAD83(HPGN)',''),
(2478,'epsg_coordinatereferencesystem',4957,7301,'NAD83(HPGN)',''),
(2479,'epsg_coordinatereferencesystem',2195,7301,'NAD83(HPGN) / UTM zone 2S',''),
(2480,'epsg_coordinatereferencesystem',2759,7301,'NAD83(HPGN) / Alabama East',''),
(2481,'epsg_coordinatereferencesystem',2760,7301,'NAD83(HPGN) / Alabama West',''),
(2482,'epsg_coordinatereferencesystem',2761,7301,'NAD83(HPGN) / Arizona East',''),
(2483,'epsg_coordinatereferencesystem',2762,7301,'NAD83(HPGN) / Arizona Central',''),
(2484,'epsg_coordinatereferencesystem',2763,7301,'NAD83(HPGN) / Arizona West',''),
(2485,'epsg_coordinatereferencesystem',2764,7301,'NAD83(HPGN) / Arkansas North',''),
(2486,'epsg_coordinatereferencesystem',2765,7301,'NAD83(HPGN) / Arkansas South',''),
(2487,'epsg_coordinatereferencesystem',2766,7301,'NAD83(HPGN) / California zone 1',''),
(2488,'epsg_coordinatereferencesystem',2767,7301,'NAD83(HPGN) / California zone 2',''),
(2489,'epsg_coordinatereferencesystem',2768,7301,'NAD83(HPGN) / California zone 3',''),
(2490,'epsg_coordinatereferencesystem',2769,7301,'NAD83(HPGN) / California zone 4',''),
(2491,'epsg_coordinatereferencesystem',2770,7301,'NAD83(HPGN) / California zone 5',''),
(2492,'epsg_coordinatereferencesystem',2771,7301,'NAD83(HPGN) / California zone 6',''),
(2493,'epsg_coordinatereferencesystem',2772,7301,'NAD83(HPGN) / Colorado North',''),
(2494,'epsg_coordinatereferencesystem',2773,7301,'NAD83(HPGN) / Colorado Central',''),
(2495,'epsg_coordinatereferencesystem',2774,7301,'NAD83(HPGN) / Colorado South',''),
(2496,'epsg_coordinatereferencesystem',2775,7301,'NAD83(HPGN) / Connecticut',''),
(2497,'epsg_coordinatereferencesystem',2776,7301,'NAD83(HPGN) / Delaware',''),
(2498,'epsg_coordinatereferencesystem',2777,7301,'NAD83(HPGN) / Florida East',''),
(2499,'epsg_coordinatereferencesystem',2778,7301,'NAD83(HPGN) / Florida West',''),
(2500,'epsg_coordinatereferencesystem',2779,7301,'NAD83(HPGN) / Florida North',''),
(2501,'epsg_coordinatereferencesystem',2780,7301,'NAD83(HPGN) / Georgia East',''),
(2502,'epsg_coordinatereferencesystem',2781,7301,'NAD83(HPGN) / Georgia West',''),
(2503,'epsg_coordinatereferencesystem',2782,7301,'NAD83(HPGN) / Hawaii zone 1',''),
(2504,'epsg_coordinatereferencesystem',2783,7301,'NAD83(HPGN) / Hawaii zone 2',''),
(2505,'epsg_coordinatereferencesystem',2784,7301,'NAD83(HPGN) / Hawaii zone 3',''),
(2506,'epsg_coordinatereferencesystem',2785,7301,'NAD83(HPGN) / Hawaii zone 4',''),
(2507,'epsg_coordinatereferencesystem',2786,7301,'NAD83(HPGN) / Hawaii zone 5',''),
(2508,'epsg_coordinatereferencesystem',2787,7301,'NAD83(HPGN) / Idaho East',''),
(2509,'epsg_coordinatereferencesystem',2788,7301,'NAD83(HPGN) / Idaho Central',''),
(2510,'epsg_coordinatereferencesystem',2789,7301,'NAD83(HPGN) / Idaho West',''),
(2511,'epsg_coordinatereferencesystem',2790,7301,'NAD83(HPGN) / Illinois East',''),
(2512,'epsg_coordinatereferencesystem',2791,7301,'NAD83(HPGN) / Illinois West',''),
(2513,'epsg_coordinatereferencesystem',2792,7301,'NAD83(HPGN) / Indiana East',''),
(2514,'epsg_coordinatereferencesystem',2793,7301,'NAD83(HPGN) / Indiana West',''),
(2515,'epsg_coordinatereferencesystem',2794,7301,'NAD83(HPGN) / Iowa North',''),
(2516,'epsg_coordinatereferencesystem',2795,7301,'NAD83(HPGN) / Iowa South',''),
(2517,'epsg_coordinatereferencesystem',2796,7301,'NAD83(HPGN) / Kansas North',''),
(2518,'epsg_coordinatereferencesystem',2797,7301,'NAD83(HPGN) / Kansas South',''),
(2519,'epsg_coordinatereferencesystem',2798,7301,'NAD83(HPGN) / Kentucky North',''),
(2520,'epsg_coordinatereferencesystem',2799,7301,'NAD83(HPGN) / Kentucky South',''),
(2521,'epsg_coordinatereferencesystem',2800,7301,'NAD83(HPGN) / Louisiana North',''),
(2522,'epsg_coordinatereferencesystem',2801,7301,'NAD83(HPGN) / Louisiana South',''),
(2523,'epsg_coordinatereferencesystem',2802,7301,'NAD83(HPGN) / Maine East',''),
(2524,'epsg_coordinatereferencesystem',2803,7301,'NAD83(HPGN) / Maine West',''),
(2525,'epsg_coordinatereferencesystem',2804,7301,'NAD83(HPGN) / Maryland',''),
(2526,'epsg_coordinatereferencesystem',2805,7301,'NAD83(HPGN) / Massachusetts Mainland',''),
(2527,'epsg_coordinatereferencesystem',2806,7301,'NAD83(HPGN) / Massachusetts Island',''),
(2528,'epsg_coordinatereferencesystem',2807,7301,'NAD83(HPGN) / Michigan North',''),
(2529,'epsg_coordinatereferencesystem',2808,7301,'NAD83(HPGN) / Michigan Central',''),
(2530,'epsg_coordinatereferencesystem',2809,7301,'NAD83(HPGN) / Michigan South',''),
(2531,'epsg_coordinatereferencesystem',2810,7301,'NAD83(HPGN) / Minnesota North',''),
(2532,'epsg_coordinatereferencesystem',2811,7301,'NAD83(HPGN) / Minnesota Central',''),
(2533,'epsg_coordinatereferencesystem',2812,7301,'NAD83(HPGN) / Minnesota South',''),
(2534,'epsg_coordinatereferencesystem',2813,7301,'NAD83(HPGN) / Mississippi East',''),
(2535,'epsg_coordinatereferencesystem',2814,7301,'NAD83(HPGN) / Mississippi West',''),
(2536,'epsg_coordinatereferencesystem',2815,7301,'NAD83(HPGN) / Missouri East',''),
(2537,'epsg_coordinatereferencesystem',2816,7301,'NAD83(HPGN) / Missouri Central',''),
(2538,'epsg_coordinatereferencesystem',2817,7301,'NAD83(HPGN) / Missouri West',''),
(2539,'epsg_coordinatereferencesystem',2818,7301,'NAD83(HPGN) / Montana',''),
(2540,'epsg_coordinatereferencesystem',2819,7301,'NAD83(HPGN) / Nebraska',''),
(2541,'epsg_coordinatereferencesystem',2820,7301,'NAD83(HPGN) / Nevada East',''),
(2542,'epsg_coordinatereferencesystem',2821,7301,'NAD83(HPGN) / Nevada Central',''),
(2543,'epsg_coordinatereferencesystem',2822,7301,'NAD83(HPGN) / Nevada West',''),
(2544,'epsg_coordinatereferencesystem',2823,7301,'NAD83(HPGN) / New Hampshire',''),
(2545,'epsg_coordinatereferencesystem',2824,7301,'NAD83(HPGN) / New Jersey',''),
(2546,'epsg_coordinatereferencesystem',2825,7301,'NAD83(HPGN) / New Mexico East',''),
(2547,'epsg_coordinatereferencesystem',2826,7301,'NAD83(HPGN) / New Mexico Central',''),
(2548,'epsg_coordinatereferencesystem',2827,7301,'NAD83(HPGN) / New Mexico West',''),
(2549,'epsg_coordinatereferencesystem',2828,7301,'NAD83(HPGN) / New York East',''),
(2550,'epsg_coordinatereferencesystem',2829,7301,'NAD83(HPGN) / New York Central',''),
(2551,'epsg_coordinatereferencesystem',2830,7301,'NAD83(HPGN) / New York West',''),
(2552,'epsg_coordinatereferencesystem',2831,7301,'NAD83(HPGN) / New York Long Island',''),
(2553,'epsg_coordinatereferencesystem',2832,7301,'NAD83(HPGN) / North Dakota North',''),
(2554,'epsg_coordinatereferencesystem',2833,7301,'NAD83(HPGN) / North Dakota South',''),
(2555,'epsg_coordinatereferencesystem',2834,7301,'NAD83(HPGN) / Ohio North',''),
(2556,'epsg_coordinatereferencesystem',2835,7301,'NAD83(HPGN) / Ohio South',''),
(2557,'epsg_coordinatereferencesystem',2836,7301,'NAD83(HPGN) / Oklahoma North',''),
(2558,'epsg_coordinatereferencesystem',2837,7301,'NAD83(HPGN) / Oklahoma South',''),
(2559,'epsg_coordinatereferencesystem',2838,7301,'NAD83(HPGN) / Oregon North',''),
(2560,'epsg_coordinatereferencesystem',2839,7301,'NAD83(HPGN) / Oregon South',''),
(2561,'epsg_coordinatereferencesystem',2840,7301,'NAD83(HPGN) / Rhode Island',''),
(2562,'epsg_coordinatereferencesystem',2841,7301,'NAD83(HPGN) / South Dakota North',''),
(2563,'epsg_coordinatereferencesystem',2842,7301,'NAD83(HPGN) / South Dakota South',''),
(2564,'epsg_coordinatereferencesystem',2843,7301,'NAD83(HPGN) / Tennessee',''),
(2565,'epsg_coordinatereferencesystem',2844,7301,'NAD83(HPGN) / Texas North',''),
(2566,'epsg_coordinatereferencesystem',2845,7301,'NAD83(HPGN) / Texas North Central',''),
(2567,'epsg_coordinatereferencesystem',2846,7301,'NAD83(HPGN) / Texas Central',''),
(2568,'epsg_coordinatereferencesystem',2847,7301,'NAD83(HPGN) / Texas South Central',''),
(2569,'epsg_coordinatereferencesystem',2848,7301,'NAD83(HPGN) / Texas South',''),
(2570,'epsg_coordinatereferencesystem',2849,7301,'NAD83(HPGN) / Utah North',''),
(2571,'epsg_coordinatereferencesystem',2850,7301,'NAD83(HPGN) / Utah Central',''),
(2572,'epsg_coordinatereferencesystem',2851,7301,'NAD83(HPGN) / Utah South',''),
(2573,'epsg_coordinatereferencesystem',2852,7301,'NAD83(HPGN) / Vermont',''),
(2574,'epsg_coordinatereferencesystem',2853,7301,'NAD83(HPGN) / Virginia North',''),
(2575,'epsg_coordinatereferencesystem',2854,7301,'NAD83(HPGN) / Virginia South',''),
(2576,'epsg_coordinatereferencesystem',2855,7301,'NAD83(HPGN) / Washington North',''),
(2577,'epsg_coordinatereferencesystem',2856,7301,'NAD83(HPGN) / Washington South',''),
(2578,'epsg_coordinatereferencesystem',2857,7301,'NAD83(HPGN) / West Virginia North',''),
(2579,'epsg_coordinatereferencesystem',2858,7301,'NAD83(HPGN) / West Virginia South',''),
(2580,'epsg_coordinatereferencesystem',2859,7301,'NAD83(HPGN) / Wisconsin North',''),
(2581,'epsg_coordinatereferencesystem',2860,7301,'NAD83(HPGN) / Wisconsin Central',''),
(2582,'epsg_coordinatereferencesystem',2861,7301,'NAD83(HPGN) / Wisconsin South',''),
(2583,'epsg_coordinatereferencesystem',2862,7301,'NAD83(HPGN) / Wyoming East',''),
(2584,'epsg_coordinatereferencesystem',2863,7301,'NAD83(HPGN) / Wyoming East Central',''),
(2585,'epsg_coordinatereferencesystem',2864,7301,'NAD83(HPGN) / Wyoming West Central',''),
(2586,'epsg_coordinatereferencesystem',2865,7301,'NAD83(HPGN) / Wyoming West',''),
(2587,'epsg_coordinatereferencesystem',2866,7301,'NAD83(HPGN) / Puerto Rico & Virgin Is.',''),
(2588,'epsg_coordinatereferencesystem',2867,7301,'NAD83(HPGN) / Arizona East (ft)',''),
(2589,'epsg_coordinatereferencesystem',2868,7301,'NAD83(HPGN) / Arizona Central (ft)',''),
(2590,'epsg_coordinatereferencesystem',2869,7301,'NAD83(HPGN) / Arizona West (ft)',''),
(2591,'epsg_coordinatereferencesystem',2870,7301,'NAD83(HPGN) / California zone 1 (ftUS)',''),
(2592,'epsg_coordinatereferencesystem',2871,7301,'NAD83(HPGN) / California zone 2 (ftUS)',''),
(2593,'epsg_coordinatereferencesystem',2872,7301,'NAD83(HPGN) / California zone 3 (ftUS)',''),
(2594,'epsg_coordinatereferencesystem',2873,7301,'NAD83(HPGN) / California zone 4 (ftUS)',''),
(2595,'epsg_coordinatereferencesystem',2874,7301,'NAD83(HPGN) / California zone 5 (ftUS)',''),
(2596,'epsg_coordinatereferencesystem',2875,7301,'NAD83(HPGN) / California zone 6 (ftUS)',''),
(2597,'epsg_coordinatereferencesystem',2876,7301,'NAD83(HPGN) / Colorado North (ftUS)',''),
(2598,'epsg_coordinatereferencesystem',2877,7301,'NAD83(HPGN) / Colorado Central (ftUS)',''),
(2599,'epsg_coordinatereferencesystem',2878,7301,'NAD83(HPGN) / Colorado South (ftUS)',''),
(2600,'epsg_coordinatereferencesystem',2879,7301,'NAD83(HPGN) / Connecticut (ftUS)',''),
(2601,'epsg_coordinatereferencesystem',2880,7301,'NAD83(HPGN) / Delaware (ftUS)',''),
(2602,'epsg_coordinatereferencesystem',2881,7301,'NAD83(HPGN) / Florida East (ftUS)',''),
(2603,'epsg_coordinatereferencesystem',2882,7301,'NAD83(HPGN) / Florida West (ftUS)',''),
(2604,'epsg_coordinatereferencesystem',2883,7301,'NAD83(HPGN) / Florida North (ftUS)',''),
(2605,'epsg_coordinatereferencesystem',2884,7301,'NAD83(HPGN) / Georgia East (ftUS)',''),
(2606,'epsg_coordinatereferencesystem',2885,7301,'NAD83(HPGN) / Georgia West (ftUS)',''),
(2607,'epsg_coordinatereferencesystem',2886,7301,'NAD83(HPGN) / Idaho East (ftUS)',''),
(2608,'epsg_coordinatereferencesystem',2887,7301,'NAD83(HPGN) / Idaho Central (ftUS)',''),
(2609,'epsg_coordinatereferencesystem',2888,7301,'NAD83(HPGN) / Idaho West (ftUS)',''),
(2610,'epsg_coordinatereferencesystem',2891,7301,'NAD83(HPGN) / Kentucky North (ftUS)',''),
(2611,'epsg_coordinatereferencesystem',2892,7301,'NAD83(HPGN) / Kentucky South (ftUS)',''),
(2612,'epsg_coordinatereferencesystem',2893,7301,'NAD83(HPGN) / Maryland (ftUS)',''),
(2613,'epsg_coordinatereferencesystem',2894,7301,'NAD83(HPGN) / Massachusetts Mainland (ftUS)',''),
(2614,'epsg_coordinatereferencesystem',2895,7301,'NAD83(HPGN) / Massachusetts Island (ftUS)',''),
(2615,'epsg_coordinatereferencesystem',2896,7301,'NAD83(HPGN) / Michigan North (ft)',''),
(2616,'epsg_coordinatereferencesystem',2897,7301,'NAD83(HPGN) / Michigan Central (ft)',''),
(2617,'epsg_coordinatereferencesystem',2898,7301,'NAD83(HPGN) / Michigan South (ft)',''),
(2618,'epsg_coordinatereferencesystem',2899,7301,'NAD83(HPGN) / Mississippi East (ftUS)',''),
(2619,'epsg_coordinatereferencesystem',2900,7301,'NAD83(HPGN) / Mississippi West (ftUS)',''),
(2620,'epsg_coordinatereferencesystem',2901,7301,'NAD83(HPGN) / Montana (ft)',''),
(2621,'epsg_coordinatereferencesystem',2902,7301,'NAD83(HPGN) / New Mexico East (ftUS)',''),
(2622,'epsg_coordinatereferencesystem',2903,7301,'NAD83(HPGN) / New Mexico Central (ftUS)',''),
(2623,'epsg_coordinatereferencesystem',2904,7301,'NAD83(HPGN) / New Mexico West (ftUS)',''),
(2624,'epsg_coordinatereferencesystem',2905,7301,'NAD83(HPGN) / New York East (ftUS)',''),
(2625,'epsg_coordinatereferencesystem',2906,7301,'NAD83(HPGN) / New York Central (ftUS)',''),
(2626,'epsg_coordinatereferencesystem',2907,7301,'NAD83(HPGN) / New York West (ftUS)',''),
(2627,'epsg_coordinatereferencesystem',2908,7301,'NAD83(HPGN) / New York Long Island (ftUS)',''),
(2628,'epsg_coordinatereferencesystem',2909,7301,'NAD83(HPGN) / North Dakota North (ft)',''),
(2629,'epsg_coordinatereferencesystem',2910,7301,'NAD83(HPGN) / North Dakota South (ft)',''),
(2630,'epsg_coordinatereferencesystem',2911,7301,'NAD83(HPGN) / Oklahoma North (ftUS)',''),
(2631,'epsg_coordinatereferencesystem',2912,7301,'NAD83(HPGN) / Oklahoma South (ftUS)',''),
(2632,'epsg_coordinatereferencesystem',2913,7301,'NAD83(HPGN) / Oregon North (ft)',''),
(2633,'epsg_coordinatereferencesystem',2914,7301,'NAD83(HPGN) / Oregon South (ft)',''),
(2634,'epsg_coordinatereferencesystem',2915,7301,'NAD83(HPGN) / Tennessee (ftUS)',''),
(2635,'epsg_coordinatereferencesystem',2916,7301,'NAD83(HPGN) / Texas North (ftUS)',''),
(2636,'epsg_coordinatereferencesystem',2917,7301,'NAD83(HPGN) / Texas North Central (ftUS)',''),
(2637,'epsg_coordinatereferencesystem',2918,7301,'NAD83(HPGN) / Texas Central (ftUS)',''),
(2638,'epsg_coordinatereferencesystem',2919,7301,'NAD83(HPGN) / Texas South Central (ftUS)',''),
(2639,'epsg_coordinatereferencesystem',2920,7301,'NAD83(HPGN) / Texas South (ftUS)',''),
(2640,'epsg_coordinatereferencesystem',2921,7301,'NAD83(HPGN) / Utah North (ft)',''),
(2641,'epsg_coordinatereferencesystem',2922,7301,'NAD83(HPGN) / Utah Central (ft)',''),
(2642,'epsg_coordinatereferencesystem',2923,7301,'NAD83(HPGN) / Utah South (ft)',''),
(2643,'epsg_coordinatereferencesystem',2924,7301,'NAD83(HPGN) / Virginia North (ftUS)',''),
(2644,'epsg_coordinatereferencesystem',2925,7301,'NAD83(HPGN) / Virginia South (ftUS)',''),
(2645,'epsg_coordinatereferencesystem',2926,7301,'NAD83(HPGN) / Washington North (ftUS)',''),
(2646,'epsg_coordinatereferencesystem',2927,7301,'NAD83(HPGN) / Washington South (ftUS)',''),
(2647,'epsg_coordinatereferencesystem',2928,7301,'NAD83(HPGN) / Wisconsin North (ftUS)',''),
(2648,'epsg_coordinatereferencesystem',2929,7301,'NAD83(HPGN) / Wisconsin Central (ftUS)',''),
(2649,'epsg_coordinatereferencesystem',2930,7301,'NAD83(HPGN) / Wisconsin South (ftUS)',''),
(2650,'epsg_coordinatereferencesystem',2967,7301,'NAD83(HPGN) / Indiana East (ftUS)',''),
(2651,'epsg_coordinatereferencesystem',2968,7301,'NAD83(HPGN) / Indiana West (ftUS)',''),
(2652,'epsg_coordinatereferencesystem',2993,7301,'NAD83(HPGN) / Oregon Lambert',''),
(2653,'epsg_coordinatereferencesystem',2994,7301,'NAD83(HPGN) / Oregon Lambert (ft)',''),
(2654,'epsg_coordoperation',1578,7301,'American Samoa 1962 to NAD83(HPGN) (1)',''),
(2655,'epsg_coordoperation',1579,7301,'American Samoa 1962 to NAD83(HPGN) (2)',''),
(2656,'epsg_coordoperation',1068,7301,'Guam 1963 to NAD83(HPGN) (1)',''),
(2657,'epsg_coordoperation',8460,7301,'NAD27 to NAD83(HPGN) (1)',''),
(2658,'epsg_coordoperation',8469,7301,'NAD27 to NAD83(HPGN) (10)',''),
(2659,'epsg_coordoperation',8470,7301,'NAD27 to NAD83(HPGN) (11)',''),
(2660,'epsg_coordoperation',8471,7302,'NAD27 to NAD83(HPGN) (12)',''),
(2661,'epsg_coordoperation',8472,7301,'NAD27 to NAD83(HPGN) (13)',''),
(2662,'epsg_coordoperation',8473,7301,'NAD27 to NAD83(HPGN) (14)',''),
(2663,'epsg_coordoperation',8474,7301,'NAD27 to NAD83(HPGN) (15)',''),
(2664,'epsg_coordoperation',8475,7301,'NAD27 to NAD83(HPGN) (16)',''),
(2665,'epsg_coordoperation',8476,7301,'NAD27 to NAD83(HPGN) (17)',''),
(2666,'epsg_coordoperation',8477,7302,'NAD27 to NAD83(HPGN) (18)',''),
(2667,'epsg_coordoperation',8478,7301,'NAD27 to NAD83(HPGN) (19)',''),
(2668,'epsg_coordoperation',8461,7301,'NAD27 to NAD83(HPGN) (2)',''),
(2669,'epsg_coordoperation',8479,7301,'NAD27 to NAD83(HPGN) (20)',''),
(2670,'epsg_coordoperation',8480,7302,'NAD27 to NAD83(HPGN) (21)',''),
(2671,'epsg_coordoperation',8482,7301,'NAD27 to NAD83(HPGN) (22)',''),
(2672,'epsg_coordoperation',8483,7301,'NAD27 to NAD83(HPGN) (23)',''),
(2673,'epsg_coordoperation',8484,7301,'NAD27 to NAD83(HPGN) (24)',''),
(2674,'epsg_coordoperation',8485,7301,'NAD27 to NAD83(HPGN) (25)',''),
(2675,'epsg_coordoperation',8486,7301,'NAD27 to NAD83(HPGN) (26)',''),
(2676,'epsg_coordoperation',8487,7301,'NAD27 to NAD83(HPGN) (27)',''),
(2677,'epsg_coordoperation',8488,7301,'NAD27 to NAD83(HPGN) (28)',''),
(2678,'epsg_coordoperation',8489,7301,'NAD27 to NAD83(HPGN) (29)',''),
(2679,'epsg_coordoperation',8462,7301,'NAD27 to NAD83(HPGN) (3)',''),
(2680,'epsg_coordoperation',8509,7302,'NAD27 to NAD83(HPGN) (30)',''),
(2681,'epsg_coordoperation',8510,7301,'NAD27 to NAD83(HPGN) (31)',''),
(2682,'epsg_coordoperation',8511,7301,'NAD27 to NAD83(HPGN) (32)',''),
(2683,'epsg_coordoperation',8512,7301,'NAD27 to NAD83(HPGN) (33)',''),
(2684,'epsg_coordoperation',8513,7301,'NAD27 to NAD83(HPGN) (34)',''),
(2685,'epsg_coordoperation',8514,7301,'NAD27 to NAD83(HPGN) (35)',''),
(2686,'epsg_coordoperation',8553,7301,'NAD27 to NAD83(HPGN) (36)',''),
(2687,'epsg_coordoperation',8554,7301,'NAD27 to NAD83(HPGN) (37)',''),
(2688,'epsg_coordoperation',8586,7302,'NAD27 to NAD83(HPGN) (38)',''),
(2689,'epsg_coordoperation',8587,7301,'NAD27 to NAD83(HPGN) (39)',''),
(2690,'epsg_coordoperation',8463,7301,'NAD27 to NAD83(HPGN) (4)',''),
(2691,'epsg_coordoperation',8588,7301,'NAD27 to NAD83(HPGN) (40)',''),
(2692,'epsg_coordoperation',8589,7301,'NAD27 to NAD83(HPGN) (41)',''),
(2693,'epsg_coordoperation',8464,7301,'NAD27 to NAD83(HPGN) (5)',''),
(2694,'epsg_coordoperation',8465,7301,'NAD27 to NAD83(HPGN) (6)',''),
(2695,'epsg_coordoperation',8466,7301,'NAD27 to NAD83(HPGN) (7)',''),
(2696,'epsg_coordoperation',8467,7301,'NAD27 to NAD83(HPGN) (8)',''),
(2697,'epsg_coordoperation',8468,7301,'NAD27 to NAD83(HPGN) (9)',''),
(2698,'epsg_coordoperation',1474,7301,'NAD83 to NAD83(HPGN) (1)',''),
(2699,'epsg_coordoperation',1483,7301,'NAD83 to NAD83(HPGN) (10)',''),
(2700,'epsg_coordoperation',1484,7301,'NAD83 to NAD83(HPGN) (11)',''),
(2701,'epsg_coordoperation',1485,7301,'NAD83 to NAD83(HPGN) (12)',''),
(2702,'epsg_coordoperation',1486,7301,'NAD83 to NAD83(HPGN) (13)',''),
(2703,'epsg_coordoperation',1487,7301,'NAD83 to NAD83(HPGN) (14)',''),
(2704,'epsg_coordoperation',1488,7301,'NAD83 to NAD83(HPGN) (15)',''),
(2705,'epsg_coordoperation',1489,7301,'NAD83 to NAD83(HPGN) (16)',''),
(2706,'epsg_coordoperation',1490,7301,'NAD83 to NAD83(HPGN) (17)',''),
(2707,'epsg_coordoperation',1491,7301,'NAD83 to NAD83(HPGN) (18)',''),
(2708,'epsg_coordoperation',1492,7301,'NAD83 to NAD83(HPGN) (19)',''),
(2709,'epsg_coordoperation',1475,7301,'NAD83 to NAD83(HPGN) (2)',''),
(2710,'epsg_coordoperation',1493,7301,'NAD83 to NAD83(HPGN) (20)',''),
(2711,'epsg_coordoperation',1494,7301,'NAD83 to NAD83(HPGN) (21)',''),
(2712,'epsg_coordoperation',1495,7302,'NAD83 to NAD83(HPGN) (22)',''),
(2713,'epsg_coordoperation',1496,7301,'NAD83 to NAD83(HPGN) (23)',''),
(2714,'epsg_coordoperation',1497,7301,'NAD83 to NAD83(HPGN) (24)',''),
(2715,'epsg_coordoperation',1498,7301,'NAD83 to NAD83(HPGN) (25)',''),
(2716,'epsg_coordoperation',1499,7301,'NAD83 to NAD83(HPGN) (26)',''),
(2717,'epsg_coordoperation',1500,7301,'NAD83 to NAD83(HPGN) (27)',''),
(2718,'epsg_coordoperation',1501,7301,'NAD83 to NAD83(HPGN) (28)',''),
(2719,'epsg_coordoperation',1502,7301,'NAD83 to NAD83(HPGN) (29)',''),
(2720,'epsg_coordoperation',1476,7301,'NAD83 to NAD83(HPGN) (3)',''),
(2721,'epsg_coordoperation',1503,7301,'NAD83 to NAD83(HPGN) (30)',''),
(2722,'epsg_coordoperation',1520,7301,'NAD83 to NAD83(HPGN) (31)',''),
(2723,'epsg_coordoperation',1521,7301,'NAD83 to NAD83(HPGN) (32)',''),
(2724,'epsg_coordoperation',1522,7301,'NAD83 to NAD83(HPGN) (33)',''),
(2725,'epsg_coordoperation',1523,7301,'NAD83 to NAD83(HPGN) (34)',''),
(2726,'epsg_coordoperation',1524,7301,'NAD83 to NAD83(HPGN) (35)',''),
(2727,'epsg_coordoperation',1525,7301,'NAD83 to NAD83(HPGN) (36)',''),
(2728,'epsg_coordoperation',1526,7301,'NAD83 to NAD83(HPGN) (37)',''),
(2729,'epsg_coordoperation',1553,7301,'NAD83 to NAD83(HPGN) (38)',''),
(2730,'epsg_coordoperation',1554,7301,'NAD83 to NAD83(HPGN) (39)',''),
(2731,'epsg_coordoperation',1477,7301,'NAD83 to NAD83(HPGN) (4)',''),
(2732,'epsg_coordoperation',1704,7301,'NAD83 to NAD83(HPGN) (40)',''),
(2733,'epsg_coordoperation',1705,7301,'NAD83 to NAD83(HPGN) (41)',''),
(2734,'epsg_coordoperation',1706,7301,'NAD83 to NAD83(HPGN) (42)',''),
(2735,'epsg_coordoperation',1707,7301,'NAD83 to NAD83(HPGN) (43)',''),
(2736,'epsg_coordoperation',1478,7301,'NAD83 to NAD83(HPGN) (5)',''),
(2737,'epsg_coordoperation',1479,7301,'NAD83 to NAD83(HPGN) (6)',''),
(2738,'epsg_coordoperation',1480,7301,'NAD83 to NAD83(HPGN) (7)',''),
(2739,'epsg_coordoperation',1481,7301,'NAD83 to NAD83(HPGN) (8)',''),
(2740,'epsg_coordoperation',1482,7301,'NAD83 to NAD83(HPGN) (9)',''),
(2741,'epsg_coordoperation',1580,7301,'NAD83(HPGN) to WGS 84 (1)',''),
(2742,'epsg_coordoperation',1900,7301,'NAD83(HPGN) to WGS 84 (2)',''),
(2743,'epsg_coordoperation',1901,7301,'NAD83(HPGN) to WGS 84 (3)',''),
(2744,'epsg_coordoperation',8508,7301,'Old Hawaiian to NAD83(HPGN) (1)',''),
(2745,'epsg_coordoperation',8481,7301,'Puerto Rico to NAD83(HPGN) (1)',''),
(2746,'epsg_coordinatereferencesystem',3088,7301,'NAD83 / Kentucky Single Zone (m)',''),
(2748,'epsg_coordinatereferencesystem',3089,7302,'KY1Z',''),
(2749,'epsg_coordinatereferencesystem',3091,7302,'KY1Z',''),
(2750,'epsg_coordoperation',11630,7301,'SPCS83 Kentucky Single Zone',''),
(2751,'epsg_datum',6625,7301,'Fort Desaix',''),
(2752,'epsg_datum',6622,7301,'Sainte Anne',''),
(2753,'epsg_datum',6626,7301,'Piton des Neiges',''),
(2754,'epsg_coordinatereferencesystem',4622,7301,'Sainte Anne',''),
(2755,'epsg_coordinatereferencesystem',4625,7301,'Fort Desaix',''),
(2756,'epsg_coordinatereferencesystem',4626,7301,'Piton des Neiges',''),
(2757,'epsg_coordinatereferencesystem',2970,7301,'Sainte Anne / UTM zone 20N',''),
(2758,'epsg_coordinatereferencesystem',2973,7301,'Fort Desaix / UTM zone 20N',''),
(2759,'epsg_coordinatereferencesystem',2990,7301,'Piton des Neiges / TM Reunion',''),
(2760,'epsg_coordoperation',1905,7301,'Sainte Anne to WGS 84 (2)',''),
(2761,'epsg_coordoperation',1904,7301,'Sainte Anne to WGS 84 (1)',''),
(2762,'epsg_coordoperation',1910,7301,'Fort Desaix to WGS 84 (2)',''),
(2763,'epsg_coordoperation',1909,7301,'Fort Desaix to WGS 84 (1)',''),
(2764,'epsg_coordoperation',1926,7301,'Piton des Neiges to RGR92 (1)',''),
(2765,'epsg_coordoperation',1911,7301,'Piton des Neiges to WGS 84 (1)',''),
(2766,'epsg_coordoperation',1964,7301,'RGR92 to Piton des Neiges (1)',''),
(2767,'epsg_datum',5189,7302,'NGC',''),
(2768,'epsg_coordinatereferencesystem',5757,7301,'IGN 1988',''),
(2769,'epsg_coordinatereferencesystem',5756,7301,'IGN 1987',''),
(2770,'epsg_coordinatereferencesystem',5758,7301,'IGN 1989',''),
(2771,'epsg_coordinatereferencesystem',5793,7301,'IGN 1950',''),
(2772,'epsg_coordinatereferencesystem',5794,7301,'IGN 1955',''),
(2773,'epsg_datum',5192,7301,'IGN 1955',''),
(2774,'epsg_coordinatereferencesystem',5795,7301,'IGN 1951',''),
(2775,'epsg_coordoperation',10004,7301,'RRAF 1991 to IGN 1987 (1)',''),
(2776,'epsg_coordoperation',10005,7301,'RRAF 1991 to IGN 1988 (1)',''),
(2777,'epsg_coordoperation',10006,7301,'RRAF 1991 to IGN 1988 (2)',''),
(2778,'epsg_coordoperation',10007,7300,'RRAF 1991 to IGN 1988 (3)',''),
(2779,'epsg_coordoperation',10008,7301,'RRAF 1991 to IGN 1988 (4)',''),
(2780,'epsg_coordoperation',10009,7301,'RRAF 1991 to IGN 1988 (5)',''),
(2781,'epsg_coordoperation',10010,7301,'RRAF 1991 to IGN 1988 (6)',''),
(2782,'epsg_coordoperation',10012,7301,'RGR92 to IGN 1989 (1)',''),
(2783,'epsg_datum',5191,7301,'IGN 1950',''),
(2784,'epsg_coordinatereferencesystem',3106,7302,'Gulshan 303 / Bangladesh TM',''),
(2785,'epsg_coordinatereferencesystem',3108,7301,'ETRS89 / New Guernsey Grid',''),
(2786,'epsg_coordinatereferencesystem',3109,7301,'ETRF89 / Jersey Transverse Mercator',''),
(2787,'epsg_coordinatereferencesystem',3109,7302,'ETRS89 / JTM',''),
(2788,'epsg_coordinatereferencesystem',3109,7301,'ETRF89 / JTM',''),
(2789,'epsg_datum',5114,7301,'Canadian Vertical Datum of 1928',''),
(2790,'epsg_datum',5114,7302,'CGVD28',''),
(2791,'epsg_coordinatereferencesystem',5713,7301,'CVD28',''),
(2792,'epsg_coordinatereferencesystem',5713,7301,'Canadian Vertical Datum of 1928',''),
(2793,'epsg_coordinatereferencesystem',3108,7301,'ETRF89 / Guernsey Grid',''),
(2794,'epsg_datum',6683,7302,'PRS92',''),
(2795,'epsg_coordoperation',17360,7301,'Vicgrid',''),
(2797,'epsg_coordoperation',17362,7301,'Geoscience Australia Lambert',''),
(2798,'epsg_coordinatereferencesystem',3110,7301,'Vicgrid',''),
(2799,'epsg_datum',6683,7301,'Modified Luzon Datum',''),
(2800,'epsg_coordoperation',15708,7301,'New Luzon to WGS 84 (1)',''),
(2801,'epsg_coordinatereferencesystem',4994,7301,'New Luzon',''),
(2802,'epsg_coordinatereferencesystem',4683,7301,'New Luzon',''),
(2803,'epsg_coordinatereferencesystem',4995,7301,'New Luzon',''),
(2804,'epsg_coordinatereferencesystem',3125,7301,'New Luzon / Philippines zone 5',''),
(2805,'epsg_coordinatereferencesystem',3124,7301,'New Luzon / Philippines zone 4',''),
(2806,'epsg_coordinatereferencesystem',3123,7302,'New Luzon / Philippines zone 3',''),
(2807,'epsg_coordinatereferencesystem',3122,7301,'New Luzon / Philippines zone 2',''),
(2808,'epsg_coordinatereferencesystem',3121,7301,'New Luzon / Philippines zone 1',''),
(2809,'epsg_coordoperation',17363,7302,'BCSG02',''),
(2810,'epsg_datum',6686,7301,'MAGNA-SIRGAS',''),
(2811,'epsg_coordinatereferencesystem',21897,7302,'Bogota / Colombia Bogota',''),
(2812,'epsg_coordinatereferencesystem',21899,7302,'Bogota / Colombia 6E',''),
(2813,'epsg_coordinatereferencesystem',21898,7302,'Bogota / Colombia 3E',''),
(2814,'epsg_coordinatereferencesystem',21896,7302,'Bogota / Colombia 3W',''),
(2815,'epsg_coordoperation',1886,7313,'Graciosa Base SW to WGS 84',''),
(2816,'epsg_coordoperation',1887,7313,'Observatorio Meteorologico 1939 to WGS 84','Source CRS as carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called the source CRS "Observatorio 1966".'),
(2818,'epsg_coordoperation',1306,7313,'Hermannskogel to WGS 84',''),
(2819,'epsg_coordoperation',1287,7313,'S-42 to WGS 84 (code SPK-A)',''),
(2820,'epsg_coordoperation',1288,7313,'S-42 to WGS 84 (code SPK-B)',''),
(2821,'epsg_coordoperation',1289,7313,'S-42 to WGS 84 (code SPK-C)',''),
(2822,'epsg_coordoperation',1290,7313,'S-42 to WGS 84 (code SPK-D)',''),
(2823,'epsg_coordoperation',1291,7313,'S-42 to WGS 84 (code SPK-E)',''),
(2824,'epsg_coordoperation',1292,7313,'S-42 to WGS 84 (code SPK-F)',''),
(2825,'epsg_coordoperation',1293,7313,'S-42 to WGS 84 (code SPK-G)',''),
(2826,'epsg_coordoperation',1897,7313,'Gunung Segara to WGS 84',''),
(2827,'epsg_coordinatereferencesystem',3034,7307,'ETRS - LCC',''),
(2828,'epsg_coordinatereferencesystem',3035,7307,'ETRS - LAEA',''),
(2829,'epsg_coordinatereferencesystem',3038,7307,'ETRS - TM26',''),
(2830,'epsg_coordinatereferencesystem',3039,7307,'ETRS - TM27',''),
(2831,'epsg_coordinatereferencesystem',3040,7307,'ETRS - TM28',''),
(2832,'epsg_coordinatereferencesystem',3041,7307,'ETRS - TM29',''),
(2833,'epsg_coordinatereferencesystem',3042,7307,'ETRS - TM30',''),
(2834,'epsg_coordinatereferencesystem',3043,7307,'ETRS - TM31',''),
(2835,'epsg_coordinatereferencesystem',3044,7307,'ETRS - TM32',''),
(2836,'epsg_coordinatereferencesystem',3045,7307,'ETRS - TM33',''),
(2837,'epsg_coordinatereferencesystem',3046,7307,'ETRS - TM34',''),
(2838,'epsg_coordinatereferencesystem',3047,7307,'ETRS - TM35',''),
(2839,'epsg_coordinatereferencesystem',3048,7307,'ETRS - TM36',''),
(2840,'epsg_coordinatereferencesystem',3049,7307,'ETRS - TM37',''),
(2841,'epsg_coordinatereferencesystem',3050,7307,'ETRS - TM38',''),
(2842,'epsg_coordinatereferencesystem',3051,7307,'ETRS - TM39',''),
(2844,'epsg_coordinatereferencesystem',4936,7307,'ETRS89 / (X, Y, Z)',''),
(2845,'epsg_coordinatereferencesystem',4937,7307,'ETRS89',''),
(2846,'epsg_coordinatereferencesystem',5730,7307,'EVRF_AMST / NH',''),
(2848,'epsg_coordinatereferencesystem',2462,7307,'AL_ALB87 / TM_6',''),
(2849,'epsg_coordinatereferencesystem',5777,7307,'AL_DUR / NOH',''),
(2850,'epsg_coordinatereferencesystem',5778,7307,'AT_TRIE / NOH',''),
(2851,'epsg_coordinatereferencesystem',31281,7307,'AT_MGI / AT_TM','This same identifier used for each of West, Central and East zones.'),
(2852,'epsg_coordinatereferencesystem',31282,7307,'AT_MGI / AT_TM','This same identifier used for each of West, Central and East zones.'),
(2853,'epsg_coordinatereferencesystem',31283,7307,'AT_MGI / AT_TM','This same identifier used for each of West, Central and East zones.'),
(2854,'epsg_coordinatereferencesystem',31370,7307,'(BE_BD72 / LAMB72 - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2855,'epsg_coordoperation',5415,7307,'AT_TRIE / NOH to EVRF2000',''),
(2856,'epsg_coordinatereferencesystem',5786,7307,'BG_KRON / NH',''),
(2857,'epsg_coordoperation',5416,7307,'BG_KRON / NH to EVRF2000',''),
(2858,'epsg_coordinatereferencesystem',31275,7307,'HR_HDKS / HR_TM','This same identifier used for both of zones 5 and 6.'),
(2859,'epsg_coordinatereferencesystem',31276,7307,'HR_HDKS / HR_TM','This same identifier used for both of zones 5 and 6.'),
(2860,'epsg_coordinatereferencesystem',2065,7307,'CZ_S-JTSK / KROVAK','The EuroGeographics projection description differs from that given here but is equivalent.'),
(2861,'epsg_coordinatereferencesystem',2065,7307,'SK_S-JTSK / KROVAK','The EuroGeographics projection description differs from that given here but is equivalent.'),
(2862,'epsg_coordinatereferencesystem',23032,7307,'(DK_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 33.'),
(2863,'epsg_coordinatereferencesystem',23033,7307,'(DK_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 32.'),
(2864,'epsg_coordoperation',5417,7307,'DK_DK10 / OH to EVRF2000',''),
(2865,'epsg_coordinatereferencesystem',5733,7307,'DK_DK10 / OH',''),
(2866,'epsg_coordinatereferencesystem',3301,7307,'EE_L-EST97 / EST_LAMB',''),
(2867,'epsg_coordinatereferencesystem',5705,7307,'EE_KRON / NH',''),
(2868,'epsg_coordinatereferencesystem',5705,7301,'Baltic 1977',''),
(2869,'epsg_datum',5105,7301,'Baltic 1977',''),
(2870,'epsg_coordinatereferencesystem',5705,7302,'BHS77',''),
(2871,'epsg_coordoperation',5418,7307,'EE_KRON / NH to EVRF2000',''),
(2872,'epsg_coordinatereferencesystem',2393,7307,'FI_KKJ / FI_TM',''),
(2873,'epsg_coordinatereferencesystem',5717,7307,'FI_HELS / OH',''),
(2874,'epsg_coordoperation',10098,7307,'(FI_KKJ to ETRS89)','This identifier is for an equivalent transformation using the Position Vector method.'),
(2875,'epsg_coordoperation',5432,7307,'FI_HELS / OH to EVRF2000',''),
(2876,'epsg_coordoperation',5419,7307,'FR_MARS / NH to EVRF2000',''),
(2877,'epsg_coordinatereferencesystem',2192,7307,'(FR_ED50 / EUROLAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2878,'epsg_coordinatereferencesystem',27562,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2879,'epsg_coordinatereferencesystem',27564,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2880,'epsg_coordinatereferencesystem',27561,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2881,'epsg_coordinatereferencesystem',27563,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2882,'epsg_coordinatereferencesystem',27572,7307,'(FR_NTF / FR_LAMB - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2883,'epsg_coordinatereferencesystem',2154,7307,'(FR_RGF93 / LAMB93 - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2884,'epsg_coordinatereferencesystem',5720,7307,'FR_MARS / NH',''),
(2885,'epsg_coordinatereferencesystem',31466,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2886,'epsg_coordinatereferencesystem',31467,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2887,'epsg_coordinatereferencesystem',31468,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2888,'epsg_coordinatereferencesystem',31469,7307,'DE_DHDN / GK_3','This EuroGeographics identifier is used for each of zones 2 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2889,'epsg_coordinatereferencesystem',3398,7307,'DE_RD/83 / GK_3','This EuroGeographics identifier is used for both of zones 4 and 5. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2890,'epsg_coordinatereferencesystem',3399,7307,'DE_RD/83 / GK_3','This EuroGeographics identifier is used for both of zones 4 and 5. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2891,'epsg_coordinatereferencesystem',3396,7307,'DE_PD/83 / GK_3','This EuroGeographics identifier is used for both of zones 3 and 4. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2892,'epsg_coordinatereferencesystem',3397,7307,'DE_PD/83 / GK_3','This EuroGeographics identifier is used for both of zones 3 and 4. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2893,'epsg_coordinatereferencesystem',5785,7307,'DE_KRON / NH',''),
(2894,'epsg_coordinatereferencesystem',5783,7307,'DE_AMST / NH',''),
(2895,'epsg_coordinatereferencesystem',5784,7307,'DE_AMST / NOH',''),
(2896,'epsg_coordinatereferencesystem',2399,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note:  In this identifier, GK_3 indicates system zone width, not zone number).'),
(2897,'epsg_coordinatereferencesystem',2398,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note:  In this identifier, GK_3 indicates system zone width, not zone number).'),
(2898,'epsg_coordinatereferencesystem',2397,7307,'DE_42/83 / GK_3','This EuroGeographics identifier is used for each of zones 3 to 5 inclusive. (Note: In this identifier, GK_3 indicates system zone width, not zone number).'),
(2899,'epsg_coordinatereferencesystem',3045,7307,'DE_ETRS89 / UTM',''),
(2900,'epsg_coordoperation',5422,7307,'DE_KRON / NH to EVRF2000',''),
(2901,'epsg_coordoperation',5420,7307,'DE_AMST / NH to EVRF2000',''),
(2902,'epsg_coordoperation',5421,7307,'DE_AMST / NOH to EVRF2000',''),
(2903,'epsg_coordoperation',1779,7307,'DE_DHDN (Middle) to ETRS89',''),
(2904,'epsg_coordoperation',1780,7307,'DE_DHDN (North) to ETRS89',''),
(2905,'epsg_coordoperation',1776,7307,'DE_DHDN (whole country, 2001) to ETRS89',''),
(2906,'epsg_coordoperation',1778,7307,'DE_DHDN (South) to ETRS89',''),
(2907,'epsg_coordoperation',1309,7307,'DE_DHDN (whole country, 1995) to ETRS89',''),
(2908,'epsg_coordoperation',1781,7307,'DE_PD/83 to ETRS89',''),
(2909,'epsg_coordoperation',1782,7307,'DE_RD/83 to ETRS89',''),
(2910,'epsg_coordoperation',1775,7307,'DE_42/83 to ETRS89',''),
(2911,'epsg_coordinatereferencesystem',23030,7307,'(GI_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2912,'epsg_coordinatereferencesystem',5701,7307,'GB_NEWL / OH',''),
(2913,'epsg_coordoperation',5433,7307,'GB_NEWL / OH to EVRF2000',''),
(2914,'epsg_coordoperation',1314,7307,'GB_OSGB36 to ETRS89',''),
(2915,'epsg_coordinatereferencesystem',2100,7307,'(GR_GGRS87 / GR_TM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2916,'epsg_coordinatereferencesystem',27700,7307,'(GB_OSGB36 / NATIONALGRID - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2917,'epsg_coordinatereferencesystem',5787,7307,'HU_KRON / NH',''),
(2918,'epsg_coordoperation',5424,7307,'HU_KRON / NH to EVRF2000',''),
(2919,'epsg_coordinatereferencesystem',5731,7307,'IE_MALH / OH',''),
(2920,'epsg_coordinatereferencesystem',29902,7307,'(IE_IRELAND65 / IRELAND75_IRISHGRID - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2921,'epsg_coordinatereferencesystem',29902,7307,'(NI_IRELAND65 / IRELAND75_IRISHGRID - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2922,'epsg_coordinatereferencesystem',23033,7307,'(IT_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 32.'),
(2923,'epsg_coordinatereferencesystem',23032,7307,'(IT_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is also used for zone 33.'),
(2924,'epsg_coordinatereferencesystem',3003,7307,'(IT_ROMA40 / EAST_WEST - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for each of zones 1 and 2.'),
(2925,'epsg_coordinatereferencesystem',3004,7307,'(IT_ROMA40 / EAST_WEST - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for each of zones 1 and 2.'),
(2926,'epsg_coordoperation',1659,7307,'IT_ROMA40 (peninsular part) to ETRS89',''),
(2927,'epsg_coordoperation',1661,7307,'IT_ROMA40 (Sardinia) to ETRS89',''),
(2928,'epsg_coordoperation',1663,7307,'IT_ROMA40 (Sicily) to ETRS89',''),
(2929,'epsg_coordinatereferencesystem',3059,7307,'LV_LKS-92 / LV_TM',''),
(2930,'epsg_coordinatereferencesystem',2600,7307,'LT_LKS94 / LT_TM',''),
(2931,'epsg_coordoperation',5434,7307,'LT_KRON / NH',''),
(2932,'epsg_coordinatereferencesystem',5774,7307,'LU_AMST / OH',''),
(2933,'epsg_coordinatereferencesystem',2169,7307,'LU_LUREF / LU_TM',''),
(2934,'epsg_coordinatereferencesystem',28992,7307,'(NL_RD / DUTCH_ST - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2935,'epsg_coordinatereferencesystem',5709,7307,'NL_AMST / OH',''),
(2936,'epsg_coordoperation',5425,7307,'NL_AMST / OH to EVRF2000',''),
(2937,'epsg_coordoperation',1751,7307,'NL_RD to ETRS89',''),
(2938,'epsg_coordinatereferencesystem',3044,7307,'NO_ETRS89 / UTM',''),
(2939,'epsg_coordinatereferencesystem',3045,7307,'NO_ETRS89 / UTM',''),
(2940,'epsg_coordinatereferencesystem',3047,7307,'NO_ETRS89 / UTM',''),
(2941,'epsg_coordinatereferencesystem',27391,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2942,'epsg_coordinatereferencesystem',27392,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2943,'epsg_coordinatereferencesystem',27393,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2944,'epsg_coordinatereferencesystem',27394,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2945,'epsg_coordinatereferencesystem',27395,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2946,'epsg_coordinatereferencesystem',27396,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2947,'epsg_coordinatereferencesystem',27397,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2948,'epsg_coordinatereferencesystem',27398,7307,'NO_NGO1948 / NO_TM','This EuroGeographics identifier is used for all of zones 1 to 8.'),
(2949,'epsg_coordinatereferencesystem',5776,7307,'NO_TREG / NOH',''),
(2950,'epsg_coordoperation',5426,7307,'NO_TREG / NOH to EVRF2000',''),
(2951,'epsg_coordinatereferencesystem',2180,7307,'PL_EUREF89 / 1992',''),
(2952,'epsg_coordinatereferencesystem',2179,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2953,'epsg_coordinatereferencesystem',2178,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2954,'epsg_coordinatereferencesystem',2177,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2955,'epsg_coordinatereferencesystem',2176,7307,'PL_EUREF89 / 2000','This EuroGeographics identifier is used for all of zones 5 to 8.'),
(2956,'epsg_coordinatereferencesystem',2171,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2957,'epsg_coordinatereferencesystem',2172,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2958,'epsg_coordinatereferencesystem',2173,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2959,'epsg_coordinatereferencesystem',2174,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2960,'epsg_coordinatereferencesystem',2175,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(2961,'epsg_coordoperation',1992,7307,'PT_D73 to ETRS89',''),
(2962,'epsg_coordoperation',1997,7307,'PT_DLX(HAY) to ETRS89',''),
(2963,'epsg_coordoperation',5427,7307,'PT_CASC / OH to EVRF2000',''),
(2964,'epsg_coordinatereferencesystem',5780,7307,'PT_CASC / OH',''),
(2965,'epsg_coordinatereferencesystem',2942,7307,'(PT_MAD / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2966,'epsg_coordinatereferencesystem',27492,7307,'PT_D73 / TM_D73',''),
(2967,'epsg_coordinatereferencesystem',2190,7307,'(PT_AZO_ORIE / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2968,'epsg_coordinatereferencesystem',2188,7307,'(PT_AZO_OCCI / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2969,'epsg_coordinatereferencesystem',2189,7307,'(PT_AZO_CENT / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2970,'epsg_coordinatereferencesystem',5705,7307,'SK_KRON / NH',''),
(2971,'epsg_coordoperation',5435,7307,'SK_KRON / NH to EVRF2000',''),
(2972,'epsg_coordoperation',5428,7307,'SI_TRIE / NOH to EVRF2000',''),
(2973,'epsg_coordinatereferencesystem',5779,7307,'SI_TRIE / NOH',''),
(2974,'epsg_coordinatereferencesystem',2170,7307,'SI_D48 / SI_TM',''),
(2975,'epsg_coordinatereferencesystem',2170,7309,'D48 / Slovenia Grid',''),
(2976,'epsg_coordoperation',1785,7307,'SI_D48 to ETRS89',''),
(2977,'epsg_coordoperation',1785,7309,'D48 to ETRS89 (3)',''),
(2978,'epsg_coordoperation',1786,7309,'D48 to WGS 84 (5)',''),
(2979,'epsg_coordoperation',5429,7307,'ES_ALIC / OH to EVRF2000',''),
(2980,'epsg_coordinatereferencesystem',23028,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2981,'epsg_coordinatereferencesystem',23029,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2982,'epsg_coordinatereferencesystem',23030,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2983,'epsg_coordinatereferencesystem',23031,7307,'(ES_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(2984,'epsg_coordinatereferencesystem',5718,7307,'SE_AMST / NH',''),
(2985,'epsg_coordinatereferencesystem',3021,7307,'SE_RT90 / SE_TM',''),
(2986,'epsg_coordoperation',1895,7307,'SE_RT90 to ETRS89',''),
(2987,'epsg_coordoperation',5431,7307,'CH_MARS / UNCOR to EVRF2000',''),
(2988,'epsg_coordinatereferencesystem',5728,7307,'CH_MARS / UNCOR',''),
(2989,'epsg_coordinatereferencesystem',5729,7307,'CH_MARS / OH',''),
(2990,'epsg_coordinatereferencesystem',2056,7307,'(CH_CH1903+ / CH_PROJECTION+ - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2991,'epsg_coordinatereferencesystem',21781,7307,'(CH_CH1903 / CH_PROJECTION - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east.'),
(2992,'epsg_coordinatereferencesystem',5775,7307,'TR_ANT / OH',''),
(2993,'epsg_coordinatereferencesystem',2319,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2994,'epsg_coordinatereferencesystem',2320,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2995,'epsg_coordinatereferencesystem',2321,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2996,'epsg_coordinatereferencesystem',2322,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2997,'epsg_coordinatereferencesystem',2323,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2998,'epsg_coordinatereferencesystem',2324,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(2999,'epsg_coordinatereferencesystem',2325,7307,'TR_ED50 / TR_TM','This EuroGeographics identifier is used for all of zones TM27 through TM45.'),
(3000,'epsg_coordinatereferencesystem',23035,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3001,'epsg_coordinatereferencesystem',23036,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3002,'epsg_coordinatereferencesystem',23037,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3003,'epsg_coordinatereferencesystem',23038,7307,'(TR_ED50 / UTM - see alias remarks)','This EuroGeographics identifier is for a CRS similar to this but with CS axes in order north, east. The same identifier is used for several other zones.'),
(3004,'epsg_coordoperation',1155,7313,'Indian to WGS 84 (code IND-B)',''),
(3005,'epsg_coordoperation',1156,7313,'Indian to WGS 84 (code IND-I)',''),
(3006,'epsg_coordoperation',1247,7313,'Indian to WGS 84 (code IND-P)',''),
(3007,'epsg_coordoperation',1256,7313,'Oman to WGS 84',''),
(3008,'epsg_coordoperation',1561,7313,'Qatar National to WGS 84',''),
(3009,'epsg_coordoperation',1956,7313,'Ireland 1965 to WGS 84',''),
(3010,'epsg_coordoperation',1125,7313,'Bogota Observatory to WGS 84',''),
(3011,'epsg_coordoperation',1131,7313,'Chua Astro to WGS 84',''),
(3012,'epsg_coordoperation',1892,7313,'Provisional South Chilean 1963 to WGS 84',''),
(3013,'epsg_coordoperation',1227,7313,'Tananarive Observatory to WGS 84',''),
(3014,'epsg_coordoperation',15750,7313,'Fort Thomas 1955 to WGS 84',''),
(3015,'epsg_coordoperation',1900,7301,'NAD83(CORS96) to WGS 84 (2)',''),
(3016,'epsg_coordoperation',1901,7301,'NAD83(CORS96) to WGS 84 (3)',''),
(3017,'epsg_coordinatereferencesystem',5782,7307,'ES_ALIC / OH',''),
(3018,'epsg_datum',6687,7302,'RGPF',''),
(3019,'epsg_datum',6688,7301,'MHEFO 55',''),
(3020,'epsg_datum',6628,7301,'IGN 1952',''),
(3021,'epsg_datum',6692,7302,'MOP 1983',''),
(3022,'epsg_datum',6628,7301,'Tahiti',''),
(3023,'epsg_datum',6629,7301,'Tahaa',''),
(3024,'epsg_coordinatereferencesystem',4692,7301,'MOP 1983',''),
(3025,'epsg_coordinatereferencesystem',4629,7301,'Tahaa',''),
(3026,'epsg_coordinatereferencesystem',4628,7301,'Tahiti',''),
(3027,'epsg_coordinatereferencesystem',3306,7301,'MOP 1983 / UTM zone 5S',''),
(3028,'epsg_coordinatereferencesystem',2977,7301,'Tahaa / UTM zone 5S',''),
(3029,'epsg_coordinatereferencesystem',2976,7301,'Tahiti / UTM zone 6S',''),
(3030,'epsg_coordoperation',1913,7301,'Tahaa to WGS 84 (1)',''),
(3031,'epsg_coordoperation',1924,7301,'Tahiti to WGS 84 (1)',''),
(3032,'epsg_coordinatereferencesystem',4688,7301,'MHEFO 55',''),
(3033,'epsg_coordinatereferencesystem',3303,7301,'MHEFO 55 / UTM zone 7S',''),
(3034,'epsg_coordoperation',15760,7301,'MHEFO 55 to RGPF (1)',''),
(3035,'epsg_coordoperation',15772,7301,'MHEFO 55 to WGS 84 (1)',''),
(3036,'epsg_datum',5195,7302,'NGPF',''),
(3037,'epsg_coordoperation',17364,7302,'NSW Lambert',''),
(3038,'epsg_coordoperationparam',8733,7302,'Io',''),
(3039,'epsg_coordoperationparam',8734,7302,'Jo',''),
(3040,'epsg_coordoperationparam',8735,7302,'Eo',''),
(3041,'epsg_coordoperationparam',8736,7302,'No',''),
(3042,'epsg_datum',6694,7302,'POSGAR 94',''),
(3043,'epsg_datum',6694,7301,'POSGAR','This alias is ambiguous, used for both POSGAR 94 and POSGAR 98.'),
(3044,'epsg_datum',6190,7301,'POSGAR','This alias is ambiguous, used for both POSGAR 94 and POSGAR 98.'),
(3045,'epsg_datum',6694,7300,'Posiciones Geod\ufffd\ufffd\ufffdsicas Argentinas 1994',''),
(3046,'epsg_coordoperation',10420,7301,'Teale Albers',''),
(3047,'epsg_coordinatereferencesystem',3309,7301,'NAD27 / California (Teale) Albers',''),
(3048,'epsg_coordinatereferencesystem',3310,7301,'NAD83 / California (Teale) Albers',''),
(3049,'epsg_coordinatereferencesystem',3311,7301,'NAD83(HARN) / California (Teale) Albers',''),
(3050,'epsg_coordinatereferencesystem',4943,7301,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(3051,'epsg_coordinatereferencesystem',4942,7302,'ETRS89','In Northern Ireland usually called ETRS89, in Republic usually referred to as IRENET95.'),
(3052,'epsg_coordinatereferencesystem',4697,7301,'IGC 1962',''),
(3055,'epsg_coordoperation',17401,7302,'Katanga Lambert',''),
(3056,'epsg_coordoperation',17402,7302,'Katanga TM',''),
(3057,'epsg_coordoperation',17412,7302,'Congo TM zone 12',''),
(3058,'epsg_coordoperation',17414,7302,'Congo TM zone 14',''),
(3059,'epsg_coordoperation',17416,7302,'Congo TM zone 16',''),
(3060,'epsg_coordoperation',17418,7302,'Congo TM zone 18',''),
(3061,'epsg_coordoperation',17420,7302,'Congo TM zone 20',''),
(3062,'epsg_coordoperation',17422,7302,'Congo TM zone 22',''),
(3063,'epsg_coordoperation',17424,7302,'Congo TM zone 24',''),
(3064,'epsg_coordoperation',17426,7302,'Congo TM zone 26',''),
(3065,'epsg_coordoperation',17428,7302,'Congo TM zone 28',''),
(3066,'epsg_coordoperation',17430,7302,'Congo TM zone 30',''),
(3067,'epsg_coordinatereferencesystem',3120,7307,'PL_42/58 / 1965','This EuroGeographics identifier is used for all of zones 1 to 5.'),
(3068,'epsg_coordinatereferencesystem',3328,7314,'System GUGiK-80',''),
(3069,'epsg_coordinatereferencesystem',3329,7314,'System 1942/15 (3)',''),
(3070,'epsg_coordinatereferencesystem',3330,7314,'System 1942/18 (3)',''),
(3071,'epsg_coordinatereferencesystem',3331,7314,'System 1942/21 (3)',''),
(3072,'epsg_coordinatereferencesystem',3332,7314,'System 1942/24 (3)',''),
(3073,'epsg_coordinatereferencesystem',3333,7314,'System 1942/15 (6)',''),
(3074,'epsg_coordinatereferencesystem',3334,7314,'System 1942/21 (6)',''),
(3075,'epsg_coordinatereferencesystem',3335,7314,'System 1942/27 (6)',''),
(3076,'epsg_coordinatereferencesystem',2172,7314,'System 1965 zone II',''),
(3077,'epsg_coordinatereferencesystem',2173,7314,'System 1965 zone III',''),
(3078,'epsg_coordinatereferencesystem',2174,7314,'System 1965 zone IV',''),
(3079,'epsg_coordinatereferencesystem',2175,7314,'System 1965 zone V',''),
(3080,'epsg_coordinatereferencesystem',2176,7314,'System 2000/15',''),
(3081,'epsg_coordinatereferencesystem',2177,7314,'System 2000/18',''),
(3082,'epsg_coordinatereferencesystem',2178,7314,'System 2000/21',''),
(3083,'epsg_coordinatereferencesystem',2179,7314,'System 2000/24',''),
(3084,'epsg_coordinatereferencesystem',2180,7314,'System 1992',''),
(3085,'epsg_coordinatereferencesystem',3120,7314,'System 1965 zone I',''),
(3086,'epsg_coordinatereferencesystem',3346,7302,'LKS94','This alias is also used for geographical and geocentric CRSs.'),
(3087,'epsg_coordinatereferencesystem',3346,7307,'LT_LKS94 / LT_TM',''),
(3088,'epsg_coordinatereferencesystem',3346,7301,'Lietuvos Koordinaciu Sistema 1994',''),
(3089,'epsg_datum',6701,7302,'IGCB 1955',''),
(3090,'epsg_datum',6701,7301,'Bas Congo 1955',''),
(3091,'epsg_coordinatereferencesystem',4701,7301,'Bas Congo 1955',''),
(3092,'epsg_coordinatereferencesystem',3339,7301,'Bas Congo 1955 / Congo TM zone 12',''),
(3093,'epsg_coordinatereferencesystem',3340,7301,'Bas Congo 1955 / Congo TM zone 14',''),
(3094,'epsg_coordinatereferencesystem',3341,7301,'Bas Congo 1955 / Congo TM zone 16',''),
(3095,'epsg_coordinatereferencesystem',3342,7301,'Bas Congo 1955 / UTM zone 33S',''),
(3096,'epsg_coordoperation',19898,7302,'PDC Mercator',''),
(3097,'epsg_coordinatereferencesystem',3347,7302,'NAD83 / STC Lambert',''),
(3098,'epsg_coordinatereferencesystem',3348,7302,'NAD83(CSRS) / STC Lambert',''),
(3099,'epsg_coordinatereferencesystem',3348,7301,'NAD83 / STC Lambert','See CRS remarks.'),
(3100,'epsg_datum',6182,7313,'Observatorio Meteorologico 1939','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called this "Observatorio 1966".'),
(3101,'epsg_datum',6182,7313,'Observatorio 1966','As incorrectly carried in NIMA TR8350.2 original edition (September 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by \ufffd\ufffd\ufffdObservatorio Meteorologico 1939\ufffd\ufffd\ufffd.'),
(3103,'epsg_coordinatereferencesystem',4182,7313,'Observatorio 1966','As incorrectly carried in NIMA TR8350.2 original edition (September 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by \ufffd\ufffd\ufffdObservatorio Meteorologico 1939\ufffd\ufffd\ufffd.'),
(3104,'epsg_coordinatereferencesystem',4182,7313,'Observatorio Meteorologico 1939','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called this "Observatorio 1966".'),
(3105,'epsg_coordinatereferencesystem',2188,7313,'Observatorio Meteorologico 1939 / UTM zone 25N','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called the base geographic CRS "Observatorio 1966."'),
(3106,'epsg_datum',6616,7313,'Selvagem Grande 1938','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called this "Marco Astro".'),
(3107,'epsg_datum',6616,7313,'Marco Astro','As incorrectly carried in NIMA TR8350.2 original edition (Sept. 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by \ufffd\ufffd\ufffdObservatorio Meteorologico 1939\ufffd\ufffd\ufffd. Not to be confused with Marcus Island Astro.'),
(3108,'epsg_coordinatereferencesystem',4616,7313,'Marco Astro','As incorrectly carried in NIMA TR8350.2 original edition (Sept. 1987), from which the name has widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by \ufffd\ufffd\ufffdObservatorio Meteorologico 1939\ufffd\ufffd\ufffd. Not to be confused with Marcus Island Astro.'),
(3109,'epsg_coordinatereferencesystem',4616,7313,'Selvagem Grande 1938','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called this "Marco Astro".'),
(3110,'epsg_coordinatereferencesystem',2943,7313,'Selvagem Grande 1938 / UTM zone 28N','As carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called the base geographic CRS "Marco Astro".'),
(3111,'epsg_coordoperation',1887,7313,'Observatorio 1966 to WGS 84','Source CRS as incorrectly carried in NIMA TR8350.2 original edition (September 1987), from which the name has been widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by \ufffd\ufffd\ufffdObservatorio Meteorologico 1939\ufffd\ufffd\ufffd.'),
(3112,'epsg_coordoperation',1965,7313,'Marco Astro to WGS 84','Source CRS as incorrectly carried in NIMA TR8350.2 original edition (Sept. 1987), from which the name has been widely adopted. Replaced in TR8350.2 3rd Edition Amendment 1 (January 2000) by \ufffd\ufffd\ufffdSelvagem Grande 1938\ufffd\ufffd\ufffd.'),
(3113,'epsg_coordoperation',1965,7313,'Selvagem Grande 1938 to WGS 84','Source CRS as carried in NIMA 8350.2 3rd Edition Amendment 1 (January 2000).  Prior versions of TR8350.2 erroneously called this "Marco Astro".'),
(3114,'epsg_datum',6703,7302,'Mhast 1951',''),
(3115,'epsg_datum',6705,7301,'Mhast','This same alias is also used for Mhast (onshore) and Malongo 1987.'),
(3116,'epsg_datum',6704,7301,'Mhast','This same alias is also used for Mhast offshore and Malongo 1987.'),
(3117,'epsg_datum',6259,7301,'Mhast','This same alias is also used for Mhast (onshore) and Mhast (offshore).'),
(3118,'epsg_coordinatereferencesystem',4259,7301,'Mhast','This same alias is also used for Mhast (onshore) and Mhast (offshore).'),
(3119,'epsg_coordinatereferencesystem',25932,7301,'Mhast / UTM zone 32S','This same alias is also used for projected CRSs using Mhast (onshore) or Mhast (offshore) as base geographic CRS, with UTM zone 32S.'),
(3120,'epsg_coordinatereferencesystem',4705,7301,'Mhast','This same alias is also used for Mhast (onshore) and Malongo 1987.'),
(3121,'epsg_coordinatereferencesystem',4704,7301,'Mhast','This same alias is also used for Mhast offshore and Malongo 1987.'),
(3122,'epsg_coordinatereferencesystem',3354,7301,'Mhast / UTM zone 32S','This same alias is also used for projected CRSs using Mhast (onshore) or Malongo 1987 as base geographic CRS, with UTM zone 32S.'),
(3123,'epsg_coordinatereferencesystem',3353,7301,'Mhast / UTM zone 32S','This same alias is also used for projected CRSs using Mhast (offshore) or Malongo 1987 as base geographic CRS, with UTM zone 32S.'),
(3124,'epsg_coordoperation',15790,7301,'Mhast to WGS 72BE (1)',''),
(3125,'epsg_coordoperation',8656,7301,'Mhast to WGS 84 (4)',''),
(3126,'epsg_datum',6699,7301,'Le Pouce (Mauritius 94)','Mauritius 1994 is a GPS-derived coordinate set consistent with the Le Pouce 1934 coordinate set.'),
(3127,'epsg_datum',6699,7301,'Le Pouce (Mauritius PN 94)','Mauritius PN 1994 is a GPS-derived coordinate set retaining GPS scale and orientation and consistent with the Le Pouce 1934 coordinate set to better than 2 metres.'),
(3128,'epsg_coordinatereferencesystem',4699,7301,'Le Pouce (Mauritius 94)','Mauritius 1994 is a GPS-derived coordinate set for 80 stations exactly consistent with Le Pouce 1934 coordinates.'),
(3129,'epsg_coordinatereferencesystem',4699,7301,'Le Pouce (Mauritius PN 94)','Mauritius Precise Network (PN) 1994 is a GPS-derived coordinate set for 80 stations retaining GPS scale and direction and consistent with Le Pouce 1934 coordinates to better than 2 metres.'),
(3130,'epsg_coordinatereferencesystem',3337,7301,'Le Pouce (Mauritius 94) / Mauritius Grid',''),
(3131,'epsg_coordinatereferencesystem',3337,7301,'Le Pouce (Mauritius PN 94) / Mauritius Grid',''),
(3132,'epsg_coordoperation',15784,7301,'Le Pouce (Mauritius 94) to WGS 84 (1)',''),
(3133,'epsg_coordoperation',15784,7301,'Le Pouce (Mauritius PN 94) to WGS 84 (1)',''),
(3134,'epsg_coordinatereferencesystem',4700,7301,'Mauritanian Mining Cadastre 1999',''),
(3135,'epsg_coordinatereferencesystem',3367,7301,'Mauritanian Mining Cadastre 1999 / UTM zone 28N',''),
(3136,'epsg_coordinatereferencesystem',3368,7301,'Mauritanian Mining Cadastre 1999 / UTM zone 29N',''),
(3137,'epsg_coordinatereferencesystem',3369,7301,'Mauritanian Mining Cadastre 1999 / UTM zone 30N',''),
(3138,'epsg_coordoperation',15857,7301,'Mining Cadastre 1999 / UTM zone 28N to Mauritania 1999 / UTM zone 28N (1)',''),
(3139,'epsg_coordoperation',15858,7301,'Mining Cadastre 1999 / UTM zone 29N to Mauritania 1999 / UTM zone 29N (1)',''),
(3140,'epsg_coordoperation',15859,7301,'Mining Cadastre 1999 / UTM zone 30N to Mauritania 1999 / UTM zone 30N (1)',''),
(3141,'epsg_coordoperation',15795,7313,'Astro Tern Island (FRIG) 1961 to WGS 84','Found in DMA TR8350.2 3rd edition under this name.'),
(3142,'epsg_coordoperation',15795,7313,'Astro B4 Sorol Atoll to WGS 84','Found in DMA TR8350.2 original 1987 under this name.'),
(3143,'epsg_coordoperation',15794,7313,'Anna 1 Astro 1965 to WGS 84',''),
(3144,'epsg_datum',6725,7301,'Johnston Atoll 1961',''),
(3145,'epsg_coordinatereferencesystem',58530,7302,'HK1963',''),
(3146,'epsg_coordoperation',15796,7313,'Astro Beacon "E" 1945 to WGS 84',''),
(3147,'epsg_coordoperation',15798,7313,'Astro DOS 71/4 to WGS 84',''),
(3148,'epsg_coordoperation',15799,7313,'Astronomic Station 1952 to WGS 84',''),
(3149,'epsg_coordoperation',15809,7313,'Johnston Island 1961 Astro to WGS 84',''),
(3150,'epsg_coordoperation',15809,7301,'Johnston Atoll 1961 to WGS 84 (1)',''),
(3151,'epsg_coordoperation',15810,7313,'Kusaie Astro 1951 to WGS 84',''),
(3152,'epsg_coordoperation',15813,7313,'ISTS 061 Astro 1968 to WGS 84',''),
(3153,'epsg_coordoperation',15814,7313,'L. C. 5 Astro 1961 to WGS 84',''),
(3154,'epsg_coordoperation',15816,7313,'Tristan Astro 1968 to WGS 84',''),
(3155,'epsg_coordoperation',15817,7313,'Midway Astro 1961 to WGS 84','This same alias also used for replacement transformation (see code 15818).'),
(3156,'epsg_coordoperation',15818,7313,'Midway Astro 1961 to WGS 84','This same alias also used for superseded transformation (see code 15817).'),
(3157,'epsg_coordoperation',15819,7313,'Pitcairn Astro 1967 to WGS 84',''),
(3158,'epsg_coordoperation',15820,7313,'Santo (DOS) 1965 to WGS 84',''),
(3159,'epsg_coordoperation',15822,7313,'Wake - Eniwetok 1960 to WGS 84',''),
(3160,'epsg_coordoperation',15823,7313,'Wake Island Astro 1952 to WGS 84',''),
(3161,'epsg_coordoperation',15811,7313,'Antigua Island Astro 1943 to WGS 84',''),
(3162,'epsg_coordoperation',15805,7313,'DOS 1968 to WGS 84',''),
(3163,'epsg_coordoperation',15807,7313,'GUX 1 Astro to WGS 84',''),
(3164,'epsg_coordinatereferencesystem',4725,7301,'Johnston Atoll 1961',''),
(3165,'epsg_datum',6737,7301,'Korea 2000',''),
(3166,'epsg_coordoperation',15808,7313,'ISTS 073 Astro 1969 to WGS 84',''),
(3167,'epsg_coordoperation',15803,7313,'Canton Astro 1966 to WGS 84',''),
(3168,'epsg_coordoperation',15801,7313,'Bellevue IGN to WGS 84',''),
(3169,'epsg_coordinatereferencesystem',2987,7301,'St. Pierre et Miquelon 1950 / UTM zone 21N',''),
(3170,'epsg_datum',6740,7302,'PZ-90',''),
(3171,'epsg_datum',6739,7301,'HK63(67)',''),
(3172,'epsg_datum',6738,7302,'HK63',''),
(3173,'epsg_coordinatereferencesystem',4838,7302,'HK63',''),
(3174,'epsg_coordinatereferencesystem',4839,7302,'HK63(67)',''),
(3175,'epsg_coordoperation',15842,7302,'HK63(67) to WGS 84 (1)',''),
(3176,'epsg_coordoperation',15842,7313,'Hong Kong 1963 to WGS 84',''),
(3177,'epsg_coordoperation',15844,7301,'CS42 to PZ-90 (1)',''),
(3178,'epsg_coordoperation',15865,7301,'CS42 to WGS 84 (16)',''),
(3179,'epsg_coordinatereferencesystem',7415,7315,'RDNAP',''),
(3180,'epsg_datum',6690,7301,'IGN79 Tahiti',''),
(3181,'epsg_datum',6639,7301,'Uvea SHOM 1978',''),
(3182,'epsg_coordinatereferencesystem',4690,7301,'IGN79 Tahiti',''),
(3183,'epsg_coordinatereferencesystem',4639,7301,'Uvea SHOM 1978',''),
(3184,'epsg_coordoperation',15847,7301,'Ueva SHOM 1978 to WGS 84 (2)',''),
(3185,'epsg_coordinatereferencesystem',3355,7302,'S-650 TL / Red Belt',''),
(3186,'epsg_coordoperation',15792,7302,'S-650 TL to WGS 72BE (1)',''),
(3187,'epsg_coordinatereferencesystem',4706,7302,'S-650 TL',''),
(3188,'epsg_coordoperation',8657,7302,'S-650 TL to WGS 84 (1)',''),
(3189,'epsg_coordoperation',15846,7302,'S-650 TL to WGS 84 (2)',''),
(3190,'epsg_datum',6706,7302,'S-650 TL',''),
(3191,'epsg_coordoperation',1888,7313,'Porto Santo 1936 to WGS 84',''),
(3192,'epsg_coordoperation',1444,7313,'Montserrat Island Astro 1958 to WGS 84',''),
(3193,'epsg_coordoperation',15850,7313,'Kerguelen Island 1949 to WGS 84',''),
(3194,'epsg_coordoperation',15741,7301,'Levant to WGS 84 (2)',''),
(3195,'epsg_coordinatereferencesystem',2004,7301,'Montserrat 58 / British West Indies Grid',''),
(3196,'epsg_coordinatereferencesystem',4604,7302,'Montserrat 58',''),
(3197,'epsg_coordoperation',15861,7301,'Mining Cadastre 1999 / UTM zone 28N to WGS 84 / UTM zone 28N (1)',''),
(3198,'epsg_coordoperation',15862,7301,'Mining Cadastre 1999 / UTM zone 29N to WGS 84 / UTM zone 29N (1)',''),
(3199,'epsg_coordoperation',15863,7301,'Mining Cadastre 1999 / UTM zone 30N to WGS 84 / UTM zone 30N (1)',''),
(3200,'epsg_datum',6741,7302,'FD54',''),
(3201,'epsg_datum',6742,7302,'GDM2000',''),
(3202,'epsg_coordinatereferencesystem',3386,7301,'KKJ / Basic Coordinate System zone 0',''),
(3203,'epsg_coordinatereferencesystem',3387,7301,'KKJ / Basic Coordinate System zone 5',''),
(3204,'epsg_coordinatereferencesystem',4669,7301,'LKS94 (ETRS89)',''),
(3205,'epsg_coordoperation',1283,7301,'LKS94 (ETRS89)  to WGS 84 (1)',''),
(3206,'epsg_coordoperation',1274,7301,'Pulkovo 1942 to LKS94(ETRS89) (1)',''),
(3212,'epsg_datum',6745,7302,'RD/83',''),
(3213,'epsg_datum',6746,7302,'PD/83','PD/83 is so-named to distinguish this datum from RD/83. The fundamental point Rauenberg was destroyed in 1910 and replaced by the station at Potsdam.'),
(3214,'epsg_coordoperation',15868,7307,'DE_RD/83 to ETRS89',''),
(3215,'epsg_coordoperation',15867,7307,'DE_PD/83 to ETRS89',''),
(3217,'epsg_datum',6747,7302,'GR96',''),
(3218,'epsg_datum',6720,7302,'FGD 1986',''),
(3219,'epsg_coordinatereferencesystem',32164,7301,'NAD83 / UTM zone 14N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 14N (code 26914). UTM is a metric system so strictly this is not UTM.'),
(3220,'epsg_coordinatereferencesystem',32165,7301,'NAD83 / UTM zone 15N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 15N (code 26915). UTM is a metric system so strictly this is not UTM.'),
(3221,'epsg_coordinatereferencesystem',32166,7301,'NAD83 / UTM zone 16N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 16N (code 26916). UTM is a metric system so strictly this is not UTM.'),
(3222,'epsg_coordinatereferencesystem',32167,7301,'NAD83 / UTM zone 17N (ftUS)','Non-metric equivalent of NAD83 / UTM zone 17N (code 26917). UTM is a metric system so strictly this is not UTM.'),
(3223,'epsg_coordinatereferencesystem',32664,7301,'WGS 84 / UTM zone 14N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 14N (code 32614). UTM is a metric system so strictly this is not UTM.'),
(3224,'epsg_coordinatereferencesystem',32665,7301,'WGS 84 / UTM zone 15N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 15N (code 32615). UTM is a metric system so strictly this is not UTM.'),
(3225,'epsg_coordinatereferencesystem',32666,7301,'WGS 84 / UTM zone 16N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 16N (code 32616). UTM is a metric system so strictly this is not UTM.'),
(3226,'epsg_coordinatereferencesystem',32667,7301,'WGS 84 / UTM zone 17N (ftUS)','Non-metric equivalent of WGS 84 / UTM zone 17N (code 32617). UTM is a metric system so strictly this is not UTM.'),
(3227,'epsg_coordoperation',19881,7302,'Alberta 10-TM Forest',''),
(3228,'epsg_coordoperation',19882,7302,'Alberta 10-TM Resource',''),
(3229,'epsg_coordinatereferencesystem',4720,7302,'FGD 1986',''),
(3230,'epsg_datum',6720,7301,'Fiji 1986',''),
(3231,'epsg_coordinatereferencesystem',3143,7302,'FGD 1986 / Fiji Map Grid',''),
(3232,'epsg_coordinatereferencesystem',3144,7302,'fk54',''),
(3233,'epsg_coordinatereferencesystem',3144,7301,'Faroe Cadastre 1954',''),
(3234,'epsg_coordinatereferencesystem',3145,7302,'fke',''),
(3235,'epsg_coordinatereferencesystem',3173,7301,'Faroe Cadastre 1989',''),
(3236,'epsg_coordoperation',15877,7302,'FGD 1986 to WGS 84 (2)',''),
(3237,'epsg_coordoperation',15876,7302,'FGD 1986 to WGS 84 (1)',''),
(3238,'epsg_coordinatereferencesystem',4752,7301,'Viti Levu 1916','The report on the 1912 survey work was issued in 1916.'),
(3239,'epsg_coordinatereferencesystem',3140,7301,'Viti Levu 1916 / Viti Levu Grid','The report on the 1912 survey work was issued in 1916.'),
(3240,'epsg_datum',6752,7301,'Viti Levu 1916','The survey network adjustment of 1912 was published in 1916.'),
(3241,'epsg_datum',6748,7301,'Vanua Levu 1917','The survey network adjustment of 1915 was published in 1917.'),
(3242,'epsg_coordinatereferencesystem',4748,7301,'Vanua Levu 1917','The report on the 1915 survey work was issued in 1917.'),
(3243,'epsg_coordinatereferencesystem',3139,7301,'Vanua Levu 1917 / Vanua Levu Grid','The report on the 1915 survey work was issued in 1917.'),
(3244,'epsg_coordoperation',15878,7301,'Vanua Levu 1917 to WGS 84 (1)',''),
(3245,'epsg_coordinatereferencesystem',3400,7301,'NAD83 / 10TM AEP Forest','Same alias may be used for NAD83(CSRS) / 10-TM (Forest). See CRS code 3402.'),
(3246,'epsg_coordinatereferencesystem',3401,7301,'NAD83 / 10TM AEP Resource','Same alias may be used for NAD83(CSRS) / 10-TM (Resource). See CRS code 3403.'),
(3247,'epsg_coordinatereferencesystem',3403,7301,'NAD83 / 10TM AEP Resource','This CRS may sometimes be called "NAD83 / 10TM AEP Resource". That is the name of a different system (see CRS code 3401) but at the scales involved the submeter positional differences are not considered significant.'),
(3248,'epsg_coordinatereferencesystem',3402,7301,'NAD83 / 10TM AEP Forest','This CRS may sometimes be called "NAD83 / 10TM AEP Forest". That is the name of a different system (see CRS code 3400) but at the scales involved the submeter positional differences are not considered significant.'),
(3249,'epsg_unitofmeasure',9097,7301,'international chain',''),
(3250,'epsg_unitofmeasure',9096,7301,'international yard',''),
(3251,'epsg_unitofmeasure',9098,7301,'international link',''),
(3252,'epsg_unitofmeasure',9096,7302,'yd',''),
(3253,'epsg_unitofmeasure',9097,7302,'ch',''),
(3254,'epsg_unitofmeasure',9098,7302,'lk',''),
(3255,'epsg_coordoperation',15897,7301,'Viti Levu 1916 to WGS 84 (1)',''),
(3256,'epsg_coordinatereferencesystem',3152,7301,'ST74 0 gon 65:-1',''),
(3257,'epsg_datum',6749,7301,'RGNC91-93',''),
(3258,'epsg_datum',6749,7302,'RGNC',''),
(3259,'epsg_coordinatereferencesystem',3163,7301,'RGNC / Lambert New Caledonia',''),
(3260,'epsg_coordoperation',16301,7301,'6-degree Gauss-Kruger CM 3E',''),
(3261,'epsg_coordoperation',16302,7301,'6-degree Gauss-Kruger CM 9E',''),
(3262,'epsg_coordoperation',16303,7301,'6-degree Gauss-Kruger CM 15E',''),
(3263,'epsg_coordoperation',16303,7301,'6-degree Gauss-Kruger CM 21E',''),
(3264,'epsg_coordoperation',16305,7301,'6-degree Gauss-Kruger CM 27E',''),
(3265,'epsg_coordoperation',16306,7301,'6-degree Gauss-Kruger CM 33E',''),
(3266,'epsg_coordoperation',16307,7301,'6-degree Gauss-Kruger CM 39E',''),
(3267,'epsg_coordoperation',16308,7301,'6-degree Gauss-Kruger CM 45E',''),
(3268,'epsg_coordoperation',16309,7301,'6-degree Gauss-Kruger CM 51E',''),
(3269,'epsg_coordoperation',16310,7301,'6-degree Gauss-Kruger CM 57E',''),
(3270,'epsg_coordoperation',16311,7301,'6-degree Gauss-Kruger CM 63E',''),
(3271,'epsg_coordoperation',16312,7301,'6-degree Gauss-Kruger CM 69E',''),
(3272,'epsg_coordoperation',16313,7301,'6-degree Gauss-Kruger CM 75E',''),
(3273,'epsg_coordoperation',16314,7301,'6-degree Gauss-Kruger CM 81E',''),
(3274,'epsg_coordoperation',16315,7301,'6-degree Gauss-Kruger CM 87E',''),
(3275,'epsg_coordoperation',16316,7301,'6-degree Gauss-Kruger CM 93E',''),
(3276,'epsg_coordoperation',16317,7301,'6-degree Gauss-Kruger CM 99E',''),
(3277,'epsg_coordoperation',16318,7301,'6-degree Gauss-Kruger CM 105E',''),
(3278,'epsg_coordoperation',16319,7301,'6-degree Gauss-Kruger CM 111E',''),
(3279,'epsg_coordoperation',16320,7301,'6-degree Gauss-Kruger CM 117E',''),
(3280,'epsg_coordoperation',16321,7301,'6-degree Gauss-Kruger CM 123E',''),
(3281,'epsg_coordoperation',16322,7301,'6-degree Gauss-Kruger CM 129E',''),
(3282,'epsg_coordoperation',16323,7301,'6-degree Gauss-Kruger CM 135E',''),
(3283,'epsg_coordoperation',16324,7301,'6-degree Gauss-Kruger CM 141E',''),
(3284,'epsg_coordoperation',16325,7301,'6-degree Gauss-Kruger CM 147E',''),
(3285,'epsg_coordoperation',16326,7301,'6-degree Gauss-Kruger CM 153E',''),
(3286,'epsg_coordoperation',16327,7301,'6-degree Gauss-Kruger CM 159E',''),
(3287,'epsg_coordoperation',16328,7301,'6-degree Gauss-Kruger CM 165E',''),
(3288,'epsg_coordoperation',16329,7301,'6-degree Gauss-Kruger CM 171E',''),
(3289,'epsg_coordoperation',16330,7301,'6-degree Gauss-Kruger CM 177E',''),
(3290,'epsg_coordoperation',16331,7301,'6-degree Gauss-Kruger CM 177W',''),
(3291,'epsg_coordoperation',16332,7301,'6-degree Gauss-Kruger CM 171W',''),
(3292,'epsg_coordoperation',16333,7301,'6-degree Gauss-Kruger CM 165W',''),
(3293,'epsg_coordoperation',16334,7301,'6-degree Gauss-Kruger CM 159W',''),
(3294,'epsg_coordoperation',16335,7301,'6-degree Gauss-Kruger CM 153W',''),
(3295,'epsg_coordoperation',16336,7301,'6-degree Gauss-Kruger CM 147W',''),
(3296,'epsg_coordoperation',16337,7301,'6-degree Gauss-Kruger CM 141W',''),
(3297,'epsg_coordoperation',16338,7301,'6-degree Gauss-Kruger CM 135W',''),
(3298,'epsg_coordoperation',16339,7301,'6-degree Gauss-Kruger CM 129W',''),
(3299,'epsg_coordoperation',16340,7301,'6-degree Gauss-Kruger CM 123W',''),
(3300,'epsg_coordoperation',16341,7301,'6-degree Gauss-Kruger CM 117W',''),
(3301,'epsg_coordoperation',16342,7301,'6-degree Gauss-Kruger CM 111W',''),
(3302,'epsg_coordoperation',16343,7301,'6-degree Gauss-Kruger CM 105W',''),
(3303,'epsg_coordoperation',16344,7301,'6-degree Gauss-Kruger CM 99W',''),
(3304,'epsg_coordoperation',16345,7301,'6-degree Gauss-Kruger CM 93W',''),
(3305,'epsg_coordoperation',16346,7301,'6-degree Gauss-Kruger CM 87W',''),
(3306,'epsg_coordoperation',16347,7301,'6-degree Gauss-Kruger CM 81W',''),
(3307,'epsg_coordoperation',16348,7301,'6-degree Gauss-Kruger CM 75W',''),
(3308,'epsg_coordoperation',16349,7301,'6-degree Gauss-Kruger CM 69W',''),
(3309,'epsg_coordoperation',16350,7301,'6-degree Gauss-Kruger CM 63W',''),
(3310,'epsg_coordoperation',16351,7301,'6-degree Gauss-Kruger CM 57W',''),
(3311,'epsg_coordoperation',16352,7301,'6-degree Gauss-Kruger CM 51W',''),
(3312,'epsg_coordoperation',16353,7301,'6-degree Gauss-Kruger CM 45W',''),
(3313,'epsg_coordoperation',16354,7301,'6-degree Gauss-Kruger CM 39W',''),
(3314,'epsg_coordoperation',16355,7301,'6-degree Gauss-Kruger CM 33W',''),
(3315,'epsg_coordoperation',16356,7301,'6-degree Gauss-Kruger CM 27W',''),
(3316,'epsg_coordoperation',16357,7301,'6-degree Gauss-Kruger CM 21W',''),
(3317,'epsg_coordoperation',16358,7301,'6-degree Gauss-Kruger CM 15W',''),
(3318,'epsg_coordoperation',16359,7301,'6-degree Gauss-Kruger CM 9W',''),
(3319,'epsg_coordoperation',16360,7301,'6-degree Gauss-Kruger CM 3W',''),
(3320,'epsg_datum',6298,7301,'Timbalai 1968',''),
(3321,'epsg_datum',6298,7301,'Borneo Triangulation of 1968',''),
(3322,'epsg_datum',6298,7302,'BT68',''),
(3323,'epsg_coordinatereferencesystem',4298,7301,'Timbalai 1968',''),
(3324,'epsg_coordinatereferencesystem',4298,7301,'BT68',''),
(3325,'epsg_coordinatereferencesystem',29849,7301,'BT68 / UTM zone 49N',''),
(3326,'epsg_coordinatereferencesystem',29850,7301,'BT68 / UTM zone 50N',''),
(3327,'epsg_coordinatereferencesystem',29873,7301,'BT68 / RSO Borneo (m)',''),
(3328,'epsg_coordinatereferencesystem',29849,7301,'Timbalai 1968 / UTM zone 49N',''),
(3329,'epsg_coordinatereferencesystem',29850,7301,'Timbalai 1968 / UTM zone 50N',''),
(3330,'epsg_coordinatereferencesystem',29873,7301,'Timbalai 1968 / RSO Borneo (m)',''),
(3331,'epsg_coordoperation',1228,7301,'Timbalai 1968 to WGS 84 (1)',''),
(3332,'epsg_coordoperation',1228,7301,'BT68 to WGS 84 (1)',''),
(3333,'epsg_coordoperation',1592,7301,'Timbalai 1968 to WGS 84 (2)',''),
(3334,'epsg_coordoperation',1592,7301,'BT68 to WGS 84 (2)',''),
(3335,'epsg_coordoperation',1615,7301,'Timbalai 1968 to WGS 84 (3)',''),
(3336,'epsg_coordoperation',1615,7301,'BT68 to WGS 84 (3)',''),
(3337,'epsg_coordoperation',1852,7301,'Timbalai 1968 to WGS 84 (4)',''),
(3338,'epsg_coordoperation',1852,7301,'BT68 to WGS 84 (4)',''),
(3339,'epsg_datum',6245,7301,'Malaysia Revised Triangulation 1968',''),
(3340,'epsg_datum',6245,7302,'MRT68',''),
(3341,'epsg_coordinatereferencesystem',4245,7301,'MRT68',''),
(3342,'epsg_coordinatereferencesystem',24500,7301,'MRT68 / Singapore Grid',''),
(3343,'epsg_coordinatereferencesystem',24547,7301,'MRT68 / UTM zone 47N',''),
(3344,'epsg_coordinatereferencesystem',24548,7301,'MRT68 / UTM zone 48N',''),
(3345,'epsg_coordoperation',1158,7313,'Kertau 1948 to WGS 84','MRT68 superseded MRT48. OGP believes that the info source used 1968 data for derivation of the transformation, but mislabelled it.'),
(3346,'epsg_coordoperation',1158,7301,'MRT68 to WGS 84 (1)',''),
(3347,'epsg_coordoperation',15896,7301,'Kertau (RSO) to MRT68 (1)',''),
(3348,'epsg_unitofmeasure',9301,7301,'chain',''),
(3349,'epsg_unitofmeasure',9301,7302,'chSe(T)',''),
(3350,'epsg_coordinatereferencesystem',3169,7301,'RGNC / UTM zone 57S',''),
(3351,'epsg_coordinatereferencesystem',3170,7301,'RGNC / UTM zone 58S',''),
(3352,'epsg_coordinatereferencesystem',3171,7301,'RGNC / UTM zone 59S',''),
(3353,'epsg_datum',6714,7301,'Bellevue (IGN)',''),
(3354,'epsg_datum',6730,7301,'Santo (DOS)',''),
(3355,'epsg_coordinatereferencesystem',4714,7301,'Bellevue (IGN)',''),
(3356,'epsg_coordinatereferencesystem',4730,7301,'Santo (DOS)',''),
(3357,'epsg_coordoperation',15801,7301,'Bellevue (IGN) to WGS 84 (1)',''),
(3358,'epsg_coordinatereferencesystem',3143,7302,'Fiji 1986 / FMG',''),
(3359,'epsg_coordinatereferencesystem',3153,7301,'NAD83 / BC Albers','This CRS may sometimes be called "NAD83 / BC Albers". That is the name of a different system (see CRS code 3005) but at the scales involved the submeter positional differences are not considered significant.'),
(3360,'epsg_coordinatereferencesystem',3173,7302,'fk89','This abbreviation is used for datum, geogCRS and projCRS.'),
(3361,'epsg_coordinatereferencesystem',4753,7301,'FD54a',''),
(3362,'epsg_datum',6753,7301,'FD54a',''),
(3363,'epsg_coordinatereferencesystem',3311,7301,'NAD83(HPGN) / California (Teale) Albers',''),
(3364,'epsg_coordinatereferencesystem',3358,7301,'NAD83(HPGN) / North Carolina',''),
(3365,'epsg_coordinatereferencesystem',3359,7301,'NAD83(HPGN) / North Carolina (ftUS)',''),
(3366,'epsg_coordinatereferencesystem',3360,7301,'NAD83(HPGN) / South Carolina',''),
(3367,'epsg_coordinatereferencesystem',3361,7301,'NAD83(HPGN) / South Carolina (ft)',''),
(3368,'epsg_coordinatereferencesystem',3362,7301,'NAD83(HPGN) / Pennsylvania North',''),
(3369,'epsg_coordinatereferencesystem',3363,7301,'NAD83(HPGN) / Pennsylvania North (ftUS)',''),
(3370,'epsg_coordinatereferencesystem',3364,7301,'NAD83(HPGN) / Pennsylvania South',''),
(3371,'epsg_coordinatereferencesystem',3365,7301,'NAD83(HPGN) / Pennsylvania South (ftUS)',''),
(3372,'epsg_coordinatereferencesystem',3075,7301,'Maine Coordinate System of 2000 East Zone','This alias also used for NAD83 / Maine CS2000 East.'),
(3373,'epsg_coordinatereferencesystem',3076,7301,'Maine Coordinate System of 2000 Central Zone','This alias also used for NAD83 / Maine CS2000 Central.'),
(3374,'epsg_coordinatereferencesystem',3077,7301,'Maine Coordinate System of 2000 West Zone','This alias also used for NAD83 / Maine CS2000 West.'),
(3375,'epsg_coordoperation',19871,7302,'RSO Malaya (m)',''),
(3376,'epsg_coordoperation',19872,7302,'RSO Malaya (m)',''),
(3377,'epsg_coordoperation',15905,7301,'Viti Levu Grid to FMG (1)',''),
(3378,'epsg_coordoperation',15906,7302,'Vanua Levu Grid to FMG (1)',''),
(3379,'epsg_datum',6754,7302,'LGD2006',''),
(3380,'epsg_coordinatereferencesystem',3079,7301,'Michigan GeoRef','This alias also used for NAD83 / Michigan Oblique Mercator.'),
(3381,'epsg_coordinatereferencesystem',3085,7302,'TCMS/AEA','This abbreviation also used for NAD83 / Texas Centric Albers Equal Area.'),
(3382,'epsg_coordinatereferencesystem',3085,7301,'Texas Centric Mapping System / Albers Equal Area','This alias also used for NAD83 / Texas Centric Albers Equal Area.'),
(3383,'epsg_coordinatereferencesystem',3084,7301,'Texas Centric Mapping System / Lambert Conformal','This alias also used for NAD83 / Texas Centric Lambert Conformal.'),
(3384,'epsg_coordinatereferencesystem',3084,7302,'TCMS/LC','This abbreviation also used for NAD83 / Texas Centric Lambert Conformal.'),
(3385,'epsg_datum',6755,7302,'DGN95',''),
(3386,'epsg_datum',6755,7301,'Indonesian Geodetic Datum 1995',''),
(3387,'epsg_datum',6755,7301,'IGD95',''),
(3388,'epsg_coordinatereferencesystem',4755,7301,'IGD95',''),
(3389,'epsg_coordinatereferencesystem',4898,7301,'IGD95',''),
(3390,'epsg_coordinatereferencesystem',4897,7301,'IGD95',''),
(3391,'epsg_coordinatereferencesystem',23866,7301,'IGD95 / UTM zone 46N',''),
(3392,'epsg_coordinatereferencesystem',23867,7301,'IGD95 / UTM zone 47N',''),
(3393,'epsg_coordinatereferencesystem',23868,7301,'IGD95 / UTM zone 48N',''),
(3394,'epsg_coordinatereferencesystem',23869,7301,'IGD95 / UTM zone 49N',''),
(3395,'epsg_coordinatereferencesystem',23870,7301,'IGD95 / UTM zone 50N',''),
(3396,'epsg_coordinatereferencesystem',23871,7301,'IGD95 / UTM zone 51N',''),
(3397,'epsg_coordinatereferencesystem',23872,7301,'IGD95 / UTM zone 52N',''),
(3398,'epsg_coordinatereferencesystem',23877,7301,'IGD95 / UTM zone 47S',''),
(3399,'epsg_coordinatereferencesystem',23878,7301,'IGD95 / UTM zone 48S',''),
(3400,'epsg_coordinatereferencesystem',23879,7301,'IGD95 / UTM zone 49S',''),
(3401,'epsg_coordinatereferencesystem',23880,7301,'IGD95 / UTM zone 50S',''),
(3402,'epsg_coordinatereferencesystem',23881,7301,'IGD95 / UTM zone 51S',''),
(3403,'epsg_coordinatereferencesystem',23882,7301,'IGD95 / UTM zone 52S',''),
(3404,'epsg_coordinatereferencesystem',23883,7301,'IGD95 / UTM zone 53S',''),
(3405,'epsg_coordinatereferencesystem',23884,7301,'IGD95 / UTM zone 54S',''),
(3406,'epsg_coordoperation',15912,7301,'IGD95 to WGS 84 (1)',''),
(3407,'epsg_coordoperation',15911,7301,'ID74 to IGD95 (1)',''),
(3408,'epsg_datum',6697,7302,'IGC 1962 6th Parallel South',''),
(3409,'epsg_datum',6756,7302,'VN-2000',''),
(3410,'epsg_coordinatereferencesystem',3404,7301,'NAD83(HPGN) / North Carolina (ftUS)',''),
(3411,'epsg_coordoperation',19867,7302,'NSIDC EASE-grid north projection',''),
(3412,'epsg_coordoperation',19868,7302,'NSIDC EASE-grid south projection',''),
(3413,'epsg_coordoperation',19869,7302,'NSIDC EASE-grid global projection',''),
(3414,'epsg_datum',6896,7302,'ITRF2005',''),
(3415,'epsg_coordinatereferencesystem',3414,7301,'SVY21 plane coordinate system',''),
(3416,'epsg_datum',6647,7301,'IERS Terrestrial Reference Frame 1988','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3417,'epsg_datum',6648,7301,'IERS Terrestrial Reference Frame 1989','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3418,'epsg_datum',6649,7301,'IERS Terrestrial Reference Frame 1990','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3419,'epsg_datum',6650,7301,'IERS Terrestrial Reference Frame 1991','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3420,'epsg_datum',6651,7301,'IERS Terrestrial Reference Frame 1992','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3421,'epsg_datum',6652,7301,'IERS Terrestrial Reference Frame 1993','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3422,'epsg_datum',6653,7301,'IERS Terrestrial Reference Frame 1994','Original name was IERS Terrestrial Reference Frame. IERS changed to International in 1996.'),
(3423,'epsg_coordoperation',1314,7301,'OSGB 1936 to WGS 84 (Petroleum)',''),
(3424,'epsg_unitofmeasure',9099,7301,'yard',''),
(3425,'epsg_unitofmeasure',9099,7302,'ydSe(T)',''),
(3426,'epsg_unitofmeasure',9300,7301,'foot',''),
(3427,'epsg_unitofmeasure',9300,7302,'ftSe(T)',''),
(3428,'epsg_unitofmeasure',9302,7301,'link',''),
(3429,'epsg_unitofmeasure',9302,7302,'lkSe(T)',''),
(3430,'epsg_coordoperation',15397,7301,'GLGIS Albers (basin)',''),
(3431,'epsg_coordoperation',15398,7301,'GLGIS Albers (basin+SLS)',''),
(3432,'epsg_coordinatereferencesystem',3174,7301,'NAD83 / GLGIS Albers (basin)',''),
(3433,'epsg_coordinatereferencesystem',3175,7301,'NAD83 / GLGIS Albers (basin+SLS)',''),
(3434,'epsg_datum',5204,7301,'IGLD 1955',''),
(3435,'epsg_datum',5205,7301,'IGLD 1985',''),
(3436,'epsg_coordoperation',19866,7301,'NSIDC Sea Ice south',''),
(3437,'epsg_coordoperation',19865,7301,'NSIDC Sea Ice north',''),
(3438,'epsg_coordinatereferencesystem',7416,7301,'EUREF89 / UTM zone 32N + DVR90',''),
(3439,'epsg_coordinatereferencesystem',7417,7301,'EUREF89 / UTM zone 33N + DVR90',''),
(3440,'epsg_coordinatereferencesystem',7418,7301,'EUREF89 / Kp2000 Jutland + DVR90',''),
(3441,'epsg_coordinatereferencesystem',7419,7301,'EUREF89 / Kp2000 Zealand + DVR90',''),
(3442,'epsg_coordinatereferencesystem',7420,7301,'EUREF89 / Kp2000 Bornholm + DVR90',''),
(3443,'epsg_coordinatereferencesystem',3415,7302,'WGS 72BE / SCS Lambert',''),
(3444,'epsg_coordoperation',15377,7301,'Iowa CS83 North zone (ftUS)',''),
(3445,'epsg_coordoperation',15378,7302,'Iowa CS83 South zone (ftUS)',''),
(3446,'epsg_coordoperation',15379,7301,'Kansas CS83 North zone (ftUS)',''),
(3447,'epsg_coordoperation',15380,7301,'Kansas CS83 South zone (ftUS)',''),
(3448,'epsg_coordoperation',15381,7301,'Nevada CS83 East zone (ftUS)',''),
(3449,'epsg_coordoperation',15382,7301,'Nevada CS83 Central zone (ftUS)',''),
(3450,'epsg_coordoperation',15383,7301,'Nevada CS83 West zone (ftUS)',''),
(3451,'epsg_coordoperation',15384,7301,'New Jersey CS83 (ftUS)',''),
(3452,'epsg_coordoperation',15385,7301,'Arkansas CS83 North zone (ftUS)',''),
(3453,'epsg_coordoperation',15386,7301,'Arkansas CS83 South zone (ftUS)',''),
(3454,'epsg_coordoperation',15387,7301,'Illinois CS83 East zone (ftUS)',''),
(3455,'epsg_coordoperation',15388,7301,'Illinois CS83 West zone (ftUS)',''),
(3456,'epsg_coordoperation',15389,7301,'New Hampshire CS83 (ftUS)',''),
(3457,'epsg_coordoperation',15390,7301,'Rhode Island CS83 (ftUS)',''),
(3458,'epsg_coordinatereferencesystem',3425,7301,'NAD83(HPGN) / Iowa North (ft US)',''),
(3459,'epsg_coordinatereferencesystem',3426,7301,'NAD83(HPGN) / Iowa South (ft US)',''),
(3460,'epsg_coordinatereferencesystem',3427,7301,'NAD83(HPGN) / Kansas North (ft US)',''),
(3461,'epsg_coordinatereferencesystem',3428,7301,'NAD83(HPGN) / Kansas South (ft US)',''),
(3462,'epsg_coordinatereferencesystem',3429,7301,'NAD83(HPGN) / Nevada East (ft US)',''),
(3463,'epsg_coordinatereferencesystem',3430,7301,'NAD83(HPGN) / Nevada Central (ft US)',''),
(3464,'epsg_coordinatereferencesystem',3431,7301,'NAD83(HPGN) / Nevada West (ft US)',''),
(3465,'epsg_coordinatereferencesystem',3432,7301,'NAD83(HPGN) / New Jersey (ft US)',''),
(3466,'epsg_coordinatereferencesystem',3441,7301,'NAD83(HPGN) / Arkansas North (ftUS)',''),
(3467,'epsg_coordinatereferencesystem',3442,7301,'NAD83(HPGN) / Arkansas South (ftUS)',''),
(3468,'epsg_coordinatereferencesystem',3443,7301,'NAD83(HPGN) / Illinois East (ftUS)',''),
(3469,'epsg_coordinatereferencesystem',3444,7302,'NAD83(HPGN) / Illinois West (ftUS)',''),
(3470,'epsg_coordinatereferencesystem',3445,7301,'NAD83(HPGN) / New Hampshire (ftUS)',''),
(3471,'epsg_coordinatereferencesystem',3446,7301,'NAD83(HPGN) / Rhode Island (ftUS)',''),
(3472,'epsg_datum',5206,7302,'DVR90',''),
(3473,'epsg_coordinatereferencesystem',3447,7302,'ETRS89 / Lambert 2005',''),
(3474,'epsg_coordinatereferencesystem',4746,7301,'DHDN','PD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Thuringen.'),
(3475,'epsg_coordinatereferencesystem',3396,7301,'PD/83 / 3-degree Gauss-Kruger zone 3',''),
(3476,'epsg_coordinatereferencesystem',3397,7301,'PD/83 / 3-degree Gauss-Kruger zone 4',''),
(3477,'epsg_coordinatereferencesystem',4745,7301,'DHDN','RD/83 is the result of the transformation from Pulkovo 1942(83) to DHDN for Sachsen.'),
(3478,'epsg_coordinatereferencesystem',3398,7301,'RD/83 / 3-degree Gauss-Kruger zone 4',''),
(3479,'epsg_coordinatereferencesystem',3399,7301,'RD/83 / 3-degree Gauss-Kruger zone 5',''),
(3480,'epsg_coordinatereferencesystem',29701,7302,'Tananarive  / Laborde',''),
(3481,'epsg_coordoperation',19911,7301,'Laborde Grid',''),
(3482,'epsg_coordinatereferencesystem',29702,7302,'Tananarive (Paris) / Laborde Grid',''),
(3483,'epsg_coordinatereferencesystem',3448,7301,'WGS 84 / Jamaica Metric Grid 2001',''),
(3484,'epsg_coordoperation',15391,7301,'Louisiana CS83 North zone (ftUS)',''),
(3485,'epsg_coordoperation',15392,7301,'Louisiana CS83 South zone (ftUS)',''),
(3486,'epsg_coordoperation',15393,7301,'Louisiana CS83 Offshore zone (ftUS)',''),
(3487,'epsg_coordoperation',15394,7302,'South Dakota CS83 North zone (ftUS)',''),
(3488,'epsg_coordoperation',15395,7301,'South Dakota CS83 South zone (ftUS)',''),
(3489,'epsg_coordinatereferencesystem',32199,7301,'NAD83 / Louisiana Offshore (m)',''),
(3491,'epsg_coordinatereferencesystem',3072,7301,'NAD83 / Maine CS2000 East (m)',''),
(3492,'epsg_coordinatereferencesystem',3074,7301,'NAD83 / Maine CS2000 West (m)',''),
(3493,'epsg_coordinatereferencesystem',2759,7301,'NAD83(HARN) / Alabama East (m)',''),
(3494,'epsg_coordinatereferencesystem',2760,7301,'NAD83(HARN) / Alabama West (m)',''),
(3495,'epsg_coordinatereferencesystem',2762,7301,'NAD83(HARN) / Arizona Central (m)',''),
(3496,'epsg_coordinatereferencesystem',2761,7301,'NAD83(HARN) / Arizona East (m)',''),
(3497,'epsg_coordinatereferencesystem',2763,7301,'NAD83(HARN) / Arizona West (m)',''),
(3498,'epsg_coordinatereferencesystem',2764,7301,'NAD83(HARN) / Arkansas North (m)',''),
(3499,'epsg_coordinatereferencesystem',2765,7301,'NAD83(HARN) / Arkansas South (m)',''),
(3500,'epsg_coordinatereferencesystem',2766,7301,'NAD83(HARN) / California zone 1 (m)',''),
(3501,'epsg_coordinatereferencesystem',2767,7301,'NAD83(HARN) / California zone 2 (m)',''),
(3502,'epsg_coordinatereferencesystem',2768,7301,'NAD83(HARN) / California zone 3 (m)',''),
(3503,'epsg_coordinatereferencesystem',2769,7301,'NAD83(HARN) / California zone 4 (m)',''),
(3504,'epsg_coordinatereferencesystem',2770,7301,'NAD83(HARN) / California zone 5 (m)',''),
(3505,'epsg_coordinatereferencesystem',2771,7301,'NAD83(HARN) / California zone 6 (m)',''),
(3506,'epsg_coordinatereferencesystem',2773,7301,'NAD83(HARN) / Colorado Central (m)',''),
(3507,'epsg_coordinatereferencesystem',2772,7301,'NAD83(HARN) / Colorado North (m)',''),
(3508,'epsg_coordinatereferencesystem',2774,7301,'NAD83(HARN) / Colorado South (m)',''),
(3509,'epsg_coordinatereferencesystem',2775,7301,'NAD83(HARN) / Connecticut (m)',''),
(3510,'epsg_coordinatereferencesystem',2776,7301,'NAD83(HARN) / Delaware (m)',''),
(3511,'epsg_coordinatereferencesystem',2777,7301,'NAD83(HARN) / Florida East (m)',''),
(3512,'epsg_coordinatereferencesystem',2779,7301,'NAD83(HARN) / Florida North (m)',''),
(3513,'epsg_coordinatereferencesystem',2778,7301,'NAD83(HARN) / Florida West (m)',''),
(3514,'epsg_coordinatereferencesystem',2780,7301,'NAD83(HARN) / Georgia East (m)',''),
(3515,'epsg_coordinatereferencesystem',2781,7301,'NAD83(HARN) / Georgia West (m)',''),
(3516,'epsg_coordinatereferencesystem',2782,7302,'NAD83(HARN) / Hawaii zone 1 (m)',''),
(3517,'epsg_coordinatereferencesystem',2783,7302,'NAD83(HARN) / Hawaii zone 2 (m)',''),
(3518,'epsg_coordinatereferencesystem',2784,7302,'NAD83(HARN) / Hawaii zone 3 (m)',''),
(3519,'epsg_coordinatereferencesystem',2785,7302,'NAD83(HARN) / Hawaii zone 4 (m)',''),
(3520,'epsg_coordinatereferencesystem',2786,7302,'NAD83(HARN) / Hawaii zone 5 (m)',''),
(3521,'epsg_coordinatereferencesystem',2788,7301,'NAD83(HARN) / Idaho Central (m)',''),
(3522,'epsg_coordinatereferencesystem',2787,7301,'NAD83(HARN) / Idaho East (m)',''),
(3523,'epsg_coordinatereferencesystem',2789,7301,'NAD83(HARN) / Idaho West (m)',''),
(3524,'epsg_coordinatereferencesystem',2790,7302,'NAD83(HARN) / Illinois East (m)',''),
(3525,'epsg_coordinatereferencesystem',2791,7301,'NAD83(HARN) / Illinois West (m)',''),
(3526,'epsg_coordinatereferencesystem',2792,7301,'NAD83(HARN) / Indiana East (m)',''),
(3527,'epsg_coordinatereferencesystem',2793,7301,'NAD83(HARN) / Indiana West (m)',''),
(3528,'epsg_coordinatereferencesystem',2794,7301,'NAD83(HARN) / Iowa North (m)',''),
(3529,'epsg_coordinatereferencesystem',2795,7301,'NAD83(HARN) / Iowa South (m)',''),
(3530,'epsg_coordinatereferencesystem',2796,7301,'NAD83(HARN) / Kansas North (m)',''),
(3531,'epsg_coordinatereferencesystem',2797,7301,'NAD83(HARN) / Kansas South (m)',''),
(3532,'epsg_coordinatereferencesystem',2798,7301,'NAD83(HARN) / Kentucky North (m)',''),
(3533,'epsg_coordinatereferencesystem',2799,7302,'NAD83(HARN) / Kentucky South (m)',''),
(3534,'epsg_coordinatereferencesystem',3090,7301,'NAD83(HARN) / Kentucky Single Zone (m)',''),
(3535,'epsg_coordinatereferencesystem',2800,7301,'NAD83(HARN) / Louisiana North (m)',''),
(3536,'epsg_coordinatereferencesystem',3456,7301,'NAD83(HPGN) / Louisiana North (ftUS)',''),
(3537,'epsg_coordinatereferencesystem',2801,7301,'NAD83(HARN) / Louisiana South (m)',''),
(3538,'epsg_coordinatereferencesystem',3457,7301,'NAD83(HPGN) / Louisiana South (ftUS)',''),
(3540,'epsg_coordinatereferencesystem',3075,7301,'NAD83(HARN) / Maine CS2000 East (m)',''),
(3541,'epsg_coordinatereferencesystem',3077,7301,'NAD83(HARN) / Maine CS2000 West (m)',''),
(3552,'epsg_coordinatereferencesystem',2802,7301,'NAD83(HARN) / Maine East (m)',''),
(3553,'epsg_coordinatereferencesystem',2803,7302,'NAD83(HARN) / Maine West (m)',''),
(3554,'epsg_coordinatereferencesystem',2804,7301,'NAD83(HARN) / Maryland (m)',''),
(3555,'epsg_coordinatereferencesystem',2806,7302,'NAD83(HARN) / Massachusetts Island (m)',''),
(3556,'epsg_coordinatereferencesystem',2805,7301,'NAD83(HARN) / Massachusetts Mainland (m)',''),
(3557,'epsg_coordinatereferencesystem',2808,7301,'NAD83(HARN) / Michigan Central (m)',''),
(3558,'epsg_coordinatereferencesystem',2807,7301,'NAD83(HARN) / Michigan North (m)',''),
(3559,'epsg_coordinatereferencesystem',2809,7301,'NAD83(HARN) / Michigan South (m)',''),
(3560,'epsg_coordinatereferencesystem',2811,7301,'NAD83(HARN) / Minnesota Central (m)',''),
(3561,'epsg_coordinatereferencesystem',2810,7301,'NAD83(HARN) / Minnesota North (m)',''),
(3562,'epsg_coordinatereferencesystem',2812,7301,'NAD83(HARN) / Minnesota South (m)',''),
(3563,'epsg_coordinatereferencesystem',2813,7301,'NAD83(HARN) / Mississippi East (m)',''),
(3564,'epsg_coordinatereferencesystem',2814,7301,'NAD83(HARN) / Mississippi West (m)',''),
(3565,'epsg_coordinatereferencesystem',2816,7301,'NAD83(HARN) / Missouri Central (m)',''),
(3566,'epsg_coordinatereferencesystem',2815,7301,'NAD83(HARN) / Missouri East (m)',''),
(3567,'epsg_coordinatereferencesystem',2817,7301,'NAD83(HARN) / Missouri West (m)',''),
(3568,'epsg_coordinatereferencesystem',2818,7301,'NAD83(HARN) / Montana (m)',''),
(3569,'epsg_coordinatereferencesystem',2819,7301,'NAD83(HARN) / Nebraska (m)',''),
(3570,'epsg_coordinatereferencesystem',2821,7301,'NAD83(HARN) / Nevada Central (m)',''),
(3571,'epsg_coordinatereferencesystem',2820,7301,'NAD83(HARN) / Nevada East (m)',''),
(3572,'epsg_coordinatereferencesystem',2822,7301,'NAD83(HARN) / Nevada West (m)',''),
(3573,'epsg_coordinatereferencesystem',2823,7301,'NAD83(HARN) / New Hampshire (m)',''),
(3574,'epsg_coordinatereferencesystem',2824,7301,'NAD83(HARN) / New Jersey (m)',''),
(3575,'epsg_coordinatereferencesystem',2826,7301,'NAD83(HARN) / New Mexico Central (m)',''),
(3576,'epsg_coordinatereferencesystem',2825,7301,'NAD83(HARN) / New Mexico East (m)',''),
(3577,'epsg_coordinatereferencesystem',2827,7301,'NAD83(HARN) / New Mexico West (m)',''),
(3578,'epsg_coordinatereferencesystem',2829,7301,'NAD83(HARN) / New York Central (m)',''),
(3579,'epsg_coordinatereferencesystem',2828,7301,'NAD83(HARN) / New York East (m)',''),
(3580,'epsg_coordinatereferencesystem',2831,7301,'NAD83(HARN) / New York Long Island (m)',''),
(3581,'epsg_coordinatereferencesystem',2830,7301,'NAD83(HARN) / New York West (m)',''),
(3582,'epsg_coordinatereferencesystem',3358,7301,'NAD83(HARN) / North Carolina (m)',''),
(3583,'epsg_coordinatereferencesystem',2832,7301,'NAD83(HARN) / North Dakota North (m)',''),
(3584,'epsg_coordinatereferencesystem',2833,7301,'NAD83(HARN) / North Dakota South (m)',''),
(3585,'epsg_coordinatereferencesystem',2834,7301,'NAD83(HARN) / Ohio North (m)',''),
(3586,'epsg_coordinatereferencesystem',2835,7301,'NAD83(HARN) / Ohio South (m)',''),
(3587,'epsg_coordinatereferencesystem',2836,7301,'NAD83(HARN) / Oklahoma North (m)',''),
(3588,'epsg_coordinatereferencesystem',2837,7301,'NAD83(HARN) / Oklahoma South (m)',''),
(3589,'epsg_coordinatereferencesystem',2993,7301,'NAD83(HARN) / Oregon Lambert (m)',''),
(3590,'epsg_coordinatereferencesystem',2838,7301,'NAD83(HARN) / Oregon North (m)',''),
(3591,'epsg_coordinatereferencesystem',2839,7301,'NAD83(HARN) / Oregon South (m)',''),
(3592,'epsg_coordinatereferencesystem',3362,7301,'NAD83(HARN) / Pennsylvania North (m)',''),
(3593,'epsg_coordinatereferencesystem',3364,7302,'NAD83(HARN) / Pennsylvania South (m)',''),
(3594,'epsg_coordinatereferencesystem',2840,7301,'NAD83(HARN) / Rhode Island (m)',''),
(3595,'epsg_coordinatereferencesystem',3360,7301,'NAD83(HARN) / South Carolina (m)',''),
(3596,'epsg_coordinatereferencesystem',2841,7301,'NAD83(HARN) / South Dakota North (m)',''),
(3597,'epsg_coordinatereferencesystem',3458,7301,'NAD83(HPGN) / South Dakota North (ftUS)',''),
(3598,'epsg_coordinatereferencesystem',2842,7301,'NAD83(HARN) / South Dakota South (m)',''),
(3599,'epsg_coordinatereferencesystem',3459,7301,'NAD83(HPGN) / South Dakota South (ftUS)',''),
(3600,'epsg_coordinatereferencesystem',2843,7301,'NAD83(HARN) / Tennessee (m)',''),
(3601,'epsg_coordinatereferencesystem',2846,7301,'NAD83(HARN) / Texas Central (m)',''),
(3602,'epsg_coordinatereferencesystem',2844,7301,'NAD83(HARN) / Texas North (m)',''),
(3603,'epsg_coordinatereferencesystem',2845,7301,'NAD83(HARN) / Texas North Central (m)',''),
(3604,'epsg_coordinatereferencesystem',2848,7301,'NAD83(HARN) / Texas South (m)',''),
(3605,'epsg_coordinatereferencesystem',2847,7302,'NAD83(HARN) / Texas South Central (m)',''),
(3606,'epsg_coordinatereferencesystem',2850,7301,'NAD83(HARN) / Utah Central (m)',''),
(3607,'epsg_coordinatereferencesystem',2849,7301,'NAD83(HARN) / Utah North (m)',''),
(3608,'epsg_coordinatereferencesystem',2851,7301,'NAD83(HARN) / Utah South (m)',''),
(3609,'epsg_coordinatereferencesystem',2852,7301,'NAD83(HARN) / Vermont (m)',''),
(3610,'epsg_coordinatereferencesystem',2853,7301,'NAD83(HARN) / Virginia North (m)',''),
(3611,'epsg_coordinatereferencesystem',2854,7301,'NAD83(HARN) / Virginia South (m)',''),
(3612,'epsg_coordinatereferencesystem',2855,7301,'NAD83(HARN) / Washington North (m)',''),
(3613,'epsg_coordinatereferencesystem',2856,7301,'NAD83(HARN) / Washington South (m)',''),
(3614,'epsg_coordinatereferencesystem',2857,7301,'NAD83(HARN) / West Virginia North (m)',''),
(3615,'epsg_coordinatereferencesystem',2858,7301,'NAD83(HARN) / West Virginia South (m)',''),
(3616,'epsg_coordinatereferencesystem',2860,7301,'NAD83(HARN) / Wisconsin Central (m)',''),
(3617,'epsg_coordinatereferencesystem',2859,7301,'NAD83(HARN) / Wisconsin North (m)',''),
(3618,'epsg_coordinatereferencesystem',2861,7301,'NAD83(HARN) / Wisconsin South (m)',''),
(3619,'epsg_coordinatereferencesystem',2862,7301,'NAD83(HARN) / Wyoming East (m)',''),
(3620,'epsg_coordinatereferencesystem',2863,7301,'NAD83(HARN) / Wyoming East Central (m)',''),
(3621,'epsg_coordinatereferencesystem',2865,7301,'NAD83(HARN) / Wyoming West (m)',''),
(3622,'epsg_coordinatereferencesystem',2864,7301,'NAD83(HARN) / Wyoming West Central (m)',''),
(3623,'epsg_coordoperation',15298,7302,'Utah Central (ftUS)',''),
(3624,'epsg_coordoperation',15297,7302,'Utah North (ftUS)',''),
(3625,'epsg_coordoperation',15299,7302,'Utah South (ftUS)',''),
(3626,'epsg_coordinatereferencesystem',3568,7301,'NAD83(HPGN) / Utah North (ftUS)',''),
(3627,'epsg_coordinatereferencesystem',3569,7301,'NAD83(HPGN) / Utah Central (ftUS)',''),
(3628,'epsg_coordinatereferencesystem',3570,7301,'NAD83(HPGN) / Utah South (ftUS)',''),
(3629,'epsg_coordoperation',17295,7302,'North Pole LAEA Bering Sea',''),
(3630,'epsg_coordoperation',17296,7302,'North Pole LAEA Alaska',''),
(3631,'epsg_coordoperation',17297,7302,'North Pole LAEA Canada',''),
(3632,'epsg_coordoperation',17298,7302,'North Pole LAEA Atlantic',''),
(3633,'epsg_coordoperation',17299,7302,'North Pole LAEA Europe',''),
(3634,'epsg_coordoperation',17300,7302,'North Pole LAEA Russia',''),
(3635,'epsg_coordinatereferencesystem',3448,7301,'JAD2001 / Jamaica Metric Grid 2001',''),
(3636,'epsg_datum',6758,7302,'JAD2001',''),
(3637,'epsg_coordoperation',19860,7302,'Jamaica Metric Grid',''),
(3638,'epsg_coordoperation',18001,7302,'Austria GK West Zone',''),
(3639,'epsg_coordoperation',18002,7302,'Austria GK Central Zone',''),
(3640,'epsg_coordoperation',18003,7302,'Austria GK East Zone',''),
(3641,'epsg_coordoperation',18004,7302,'Austria GK West',''),
(3642,'epsg_coordoperation',18005,7302,'Austria GK Central',''),
(3643,'epsg_coordoperation',18006,7302,'Austria GK East',''),
(3644,'epsg_coordoperation',18007,7302,'Austria GK M28',''),
(3645,'epsg_coordoperation',18008,7302,'Austria GK M31',''),
(3646,'epsg_coordoperation',18009,7302,'Austria GK M34',''),
(3647,'epsg_coordinatereferencesystem',3416,7301,'ETRF89 / Austria Lambert',''),
(3648,'epsg_coordinatereferencesystem',2176,7301,'ETRF89 / Poland CS2000 zone 5',''),
(3649,'epsg_coordinatereferencesystem',2177,7301,'ETRF89 / Poland CS2000 zone 6',''),
(3650,'epsg_coordinatereferencesystem',2178,7301,'ETRF89 / Poland CS2000 zone 7',''),
(3651,'epsg_coordinatereferencesystem',2179,7301,'ETRF89 / Poland CS2000 zone 8',''),
(3653,'epsg_coordinatereferencesystem',2180,7301,'ETRF89 / Poland CS92',''),
(3654,'epsg_coordinatereferencesystem',2196,7301,'ETRF89 / Kp2000 Jutland',''),
(3655,'epsg_coordinatereferencesystem',2197,7302,'ETRF89 / Kp2000 Zealand',''),
(3656,'epsg_coordinatereferencesystem',2198,7301,'ETRF89 / Kp2000 Bornholm',''),
(3657,'epsg_coordinatereferencesystem',2213,7301,'ETRF89 / TM 30 NE',''),
(3658,'epsg_coordinatereferencesystem',3034,7301,'ETRF89 / ETRS-LCC',''),
(3659,'epsg_coordinatereferencesystem',3035,7301,'ETRF89 / ETRS-LAEA',''),
(3660,'epsg_coordinatereferencesystem',3038,7302,'ETRF89 / ETRS-TM26',''),
(3661,'epsg_coordinatereferencesystem',3039,7302,'ETRF89 / ETRS-TM27',''),
(3662,'epsg_coordinatereferencesystem',3040,7302,'ETRF89 / ETRS-TM28',''),
(3663,'epsg_coordinatereferencesystem',3041,7302,'ETRF89 / ETRS-TM29',''),
(3664,'epsg_coordinatereferencesystem',3042,7302,'ETRF89 / ETRS-TM30',''),
(3665,'epsg_coordinatereferencesystem',3043,7302,'ETRF89 / ETRS-TM31',''),
(3666,'epsg_coordinatereferencesystem',3044,7302,'ETRF89 / ETRS-TM32',''),
(3667,'epsg_coordinatereferencesystem',3045,7302,'ETRF89 / ETRS-TM33',''),
(3668,'epsg_coordinatereferencesystem',3046,7302,'ETRF89 / ETRS-TM34',''),
(3669,'epsg_coordinatereferencesystem',3047,7302,'ETRF89 / ETRS-TM35',''),
(3670,'epsg_coordinatereferencesystem',3048,7302,'ETRF89 / ETRS-TM36',''),
(3671,'epsg_coordinatereferencesystem',3049,7302,'ETRF89 / ETRS-TM37',''),
(3672,'epsg_coordinatereferencesystem',3050,7302,'ETRF89 / ETRS-TM38',''),
(3673,'epsg_coordinatereferencesystem',3051,7302,'ETRF89 / ETRS-TM39',''),
(3674,'epsg_coordinatereferencesystem',3067,7301,'ETRF89 / ETRS-TM35FIN',''),
(3675,'epsg_coordinatereferencesystem',3126,7301,'ETRF89 / ETRS-GK19FIN',''),
(3676,'epsg_coordinatereferencesystem',3127,7301,'ETRF89 / ETRS-GK20FIN',''),
(3677,'epsg_coordinatereferencesystem',3128,7301,'ETRF89 / ETRS-GK21FIN',''),
(3678,'epsg_coordinatereferencesystem',3129,7301,'ETRF89 / ETRS-GK22FIN',''),
(3679,'epsg_coordinatereferencesystem',3130,7301,'ETRF89 / ETRS-GK23FIN',''),
(3680,'epsg_coordinatereferencesystem',3131,7301,'ETRF89 / ETRS-GK24FIN',''),
(3681,'epsg_coordinatereferencesystem',3132,7301,'ETRF89 / ETRS-GK25FIN',''),
(3682,'epsg_coordinatereferencesystem',3133,7301,'ETRF89 / ETRS-GK26FIN',''),
(3683,'epsg_coordinatereferencesystem',3134,7301,'ETRF89 / ETRS-GK27FIN',''),
(3684,'epsg_coordinatereferencesystem',3135,7301,'ETRF89 / ETRS-GK28FIN',''),
(3685,'epsg_coordinatereferencesystem',3136,7301,'ETRF89 / ETRS-GK29FIN',''),
(3686,'epsg_coordinatereferencesystem',3137,7301,'ETRF89 / ETRS-GK30FIN',''),
(3687,'epsg_coordinatereferencesystem',3138,7301,'ETRF89 / ETRS-GK31FIN',''),
(3688,'epsg_coordinatereferencesystem',3145,7301,'ETRF89 / Faroe Lambert',''),
(3689,'epsg_coordinatereferencesystem',3447,7301,'ETRF89 / Belgian Lambert 2005',''),
(3690,'epsg_coordinatereferencesystem',7409,7301,'ETRF89 + EVRF2000',''),
(3691,'epsg_coordinatereferencesystem',7416,7302,'ETRF89 / UTM zone 32N + DVR90',''),
(3692,'epsg_coordinatereferencesystem',7417,7302,'ETRF89 / UTM zone 33N + DVR90',''),
(3694,'epsg_coordinatereferencesystem',7418,7301,'ETRF89 / Kp2000 Jutland + DVR90',''),
(3695,'epsg_coordinatereferencesystem',7419,7301,'ETRF89 / Kp2000 Zealand + DVR90',''),
(3696,'epsg_coordinatereferencesystem',7420,7301,'ETRF89 / Kp2000 Bornholm + DVR90',''),
(3697,'epsg_coordinatereferencesystem',3399,7301,'RD/83 / 3-degree Gauss zone 5',''),
(3698,'epsg_coordinatereferencesystem',3398,7301,'RD/83 / 3-degree Gauss zone 4',''),
(3699,'epsg_coordinatereferencesystem',3396,7301,'PD/83 / 3-degree Gauss zone 3',''),
(3700,'epsg_coordinatereferencesystem',3397,7301,'PD/83 / 3-degree Gauss zone 4',''),
(3701,'epsg_coordinatereferencesystem',3463,7301,'Maine Coordinate System of 2000 Central Zone','This alias also used for NAD83(HARN) / Maine CS2000 Central.'),
(3702,'epsg_coordinatereferencesystem',3463,7301,'NAD83 / Maine CS2000 Central (m)',''),
(3703,'epsg_coordinatereferencesystem',3464,7301,'Maine Coordinate System of 2000 Central Zone','This alias also used for NAD83 / Maine CS2000 Central.'),
(3704,'epsg_coordinatereferencesystem',3464,7301,'NAD83(HARN) / Maine CS2000 Central (m)',''),
(3705,'epsg_coordinatereferencesystem',3464,7301,'NAD83(HPGN) / Maine CS2000 Central','')
INSERT INTO EPSG_AREA VALUES
(1024,'Afghanistan','Afghanistan',29.41,38.5,60.54,74.96,'','AF','AFG',4,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1025,'Albania','Albania - onshore and offshore.',39.67,42.69,18.45,21.06,'','AL','ALB',8,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1026,'Algeria','Algeria - onshore and offshore.',18.98,37.09,-8.67,11.99,'','DZ','DZA',12,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1027,'American Samoa','American Samoa - onshore and offshore.',-14.57,-11.03,-171.11,-169.12,'','AS','ASM',16,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1028,'Andorra','Andorra',42.49,42.66,1.49,1.77,'','AD','AND',20,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1029,'Angola','Angola - onshore and offshore.',-18.05,-4.39,8.4,24.1,'','AO','AGO',24,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1030,'Anguilla','Anguilla - onshore and offshore.',17.94,21.65,-63.91,-60.67,'','AI','AIA',660,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1031,'Antarctica','Antarctica',-90.0,-60.0,-180.0,180.0,'','AQ','ATA',10,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1032,'Antigua and Barbuda','Antigua and Barbuda - Antigua, Barbuda and Redonda.',16.45,20.66,-63.35,-58.45,'','AG','ATG',28,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1033,'Argentina','Argentina - onshore and offshore.',-60.04,-21.8,-73.62,-53.5,'','AR','ARG',32,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1034,'Armenia','Armenia',38.86,41.33,43.48,46.65,'','AM','ARM',51,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1035,'Aruba','Aruba - onshore and offshore.',12.16,15.29,-70.46,-69.47,'','AW','ABW',533,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1036,'Australia','Australia - onshore and offshore. Includes Lord Howe Island, Macquarie Islands, Ashmore and Cartier Islands.',-60.04,-8.86,110.77,174.1,'','AU','AUS',36,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1037,'Austria','Austria',46.41,49.02,9.53,17.17,'','AT','AUT',40,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1038,'Azerbaijan','Azerbaijan - onshore and offshore.',38.41,41.94,44.82,50.41,'','AZ','AZE',31,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1039,'Bahamas','Bahamas - onshore and offshore.',20.37,30.48,-80.95,-70.67,'','BS','BHS',44,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1040,'Bahrain','Bahrain - onshore and offshore.',25.57,27.18,50.3,51.41,'','BH','BHR',48,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1041,'Bangladesh','Bangladesh - onshore and offshore.',15.09,26.65,88.1,92.72,'','BD','BGD',50,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1042,'Barbados','Barbados - onshore and offshore.',11.04,14.75,-60.71,-57.5,'','BB','BRB',52,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1043,'Belarus','Belarus',51.29,56.22,23.18,32.76,'','BY','BLR',112,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1044,'Belgium','Belgium - onshore and offshore.',49.53,51.83,2.12,6.4,'','BE','BEL',56,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1045,'Belize','Belize - onshore and offshore.',15.87,19.55,-89.27,-84.16,'','BZ','BLZ',84,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1046,'Benin','Benin - onshore and offshore.',2.68,12.4,0.78,3.86,'','BJ','BEN',204,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1047,'Bermuda','Bermuda - onshore and offshore.',28.87,35.77,-68.23,-61.34,'','BM','BMU',60,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1048,'Bhutan','Bhutan',26.72,28.34,88.8,92.17,'','BT','BTN',64,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1049,'Bolivia','Bolivia',-22.91,-9.69,-69.69,-57.49,'','BO','BOL',68,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1050,'Bosnia and Herzegowina','Bosnia and Herzegowina',42.27,45.28,15.67,19.67,'','BA','BIH',70,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1051,'Botswana','Botswana',-26.88,-17.78,20.0,29.37,'','BW','BWA',72,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1052,'Bouvet Island','Bouvet Island - onshore and offshore.',-60.04,-50.8,-1.36,7.06,'','BV','BVT',74,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1053,'Brazil','Brazil - onshore and offshore. Includes Rocas, Fernando de Noronha archipelago, Trindade, Ihlas Martim Vaz and Sao Pedro e Sao Paulo.',-35.89,7.25,-74.05,-26.12,'','BR','BRA',76,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1054,'British Indian Ocean Territory','British Indian Ocean Territory - onshore and offshore - Chagos Archipelago.',-10.69,-4.04,68.65,77.13,'','IO','IOT',86,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1055,'Brunei Darussalam','Brunei Darussalam - onshore and offshore.',4.02,8.83,111.58,115.42,'','BN','BRN',96,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1056,'Bulgaria','Bulgaria - onshore and offshore.',41.27,44.26,22.37,30.59,'','BG','BGR',100,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1057,'Burkina Faso','Burkina Faso',9.4,15.08,-5.52,2.4,'','BF','BFA',854,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1058,'Burundi','Burundi',-4.46,-2.3,29.0,30.87,'','BI','BDI',108,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1059,'Cambodia','Cambodia - onshore and offshore.',7.42,14.71,101.42,107.7,'','KH','KHM',116,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1060,'Cameroon','Cameroon - onshore and offshore.',1.66,13.09,8.38,16.22,'','CM','CMR',120,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1061,'Canada','Canada - onshore and offshore - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; Northwest Territories; Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon.',41.68,85.05,-141.15,-48.06,'','CA','CAN',124,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-07-21','2002.341 2005.89 2004.463',0),
(1062,'Cape Verde','Cape Verde - onshore and offshore. Includes Boa Vista, Brava, Fogo, Maio, Sal, Santo Antao, Sao Nicolau, Sao Tiago, Sao Vicente.',11.39,20.66,-28.86,-19.55,'','CV','CPV',132,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1063,'Cayman Islands','Cayman Islands - onshore and offshore. Includes Grand Cayman, Little Cayman and Cayman Brac.',16.5,20.78,-84.69,-78.3,'','KY','CYM',136,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1064,'Central African Republic','Central African Republic',2.22,11.01,14.42,27.51,'','CF','CAF',140,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1065,'Chad','Chad',7.46,23.51,13.47,24.0,'','TD','TCD',148,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-09-25','2002.341 2006.54',0),
(1066,'Chile','Chile - onshore and offshore. Includes Easter Island, Juan Fernandez Islands, San Felix, and Sala y Gomez.',-60.04,-17.52,-113.28,-66.39,'','CL','CHL',152,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1067,'China','China - onshore and offshore.',7.16,53.59,73.66,134.85,'','CN','CHN',156,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1068,'Christmas Island','Christmas Island - onshore and offshore.',-14.74,-8.46,101.76,109.51,'','CX','CXR',162,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1069,'Cocos (Keeling) Islands','Cocos (Keeling) Islands - onshore and offshore.',-15.54,-5.89,93.54,102.43,'','CC','CCK',166,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1070,'Colombia','Colombia - onshore and offshore. Includes San Andres y Providencia, Malpelo Islands, Roncador Bank, Serrana Bank and Serranilla Bank.',-4.22,15.93,-85.79,-66.91,'','CO','COL',170,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1071,'Comoros','Comoros - onshore and offshore. Includes Anjouan, Grande Comore, Moheli and other islands.',-13.04,-8.21,42.56,45.77,'','KM','COM',174,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1072,'Congo','Congo - onshore and offshore.',-7.13,3.72,8.87,18.65,'','CG','COG',178,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1073,'Cook Islands','Cook Islands - onshore and offshore.',-23.46,-7.75,-171.1,-155.59,'','CK','COK',184,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1074,'Costa Rica','Costa Rica - onshore and offshore.',1.97,11.77,-89.09,-81.49,'','CR','CRI',188,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1075,'Cote d''Ivoire (Ivory Coast)','C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast) - onshore and offshore.',0.84,10.74,-8.61,-2.49,'','CI','CIV',384,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1076,'Croatia','Croatia - onshore and offshore.',42.47,46.57,13.02,19.5,'','HR','HRV',191,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1077,'Cuba','Cuba - onshore and offshore.',19.08,24.96,-86.99,-73.61,'','CU','CUB',192,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1078,'Cyprus','Cyprus - onshore and offshore.',33.05,36.31,29.94,35.22,'','CY','CYP',196,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1079,'Czech Republic','Czech Republic',48.56,51.09,12.11,18.98,'','CZ','CZE',203,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1080,'Denmark','Denmark - onshore and offshore.',54.39,58.79,3.25,15.49,'','DK','DNK',208,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1081,'Djibouti','Djibouti - onshore and offshore.',10.94,12.83,41.78,44.05,'','DJ','DJI',262,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1082,'Dominica','Dominica - onshore and offshore.',14.78,17.28,-62.52,-57.64,'','DM','DMA',212,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1083,'Dominican Republic','Dominican Republic - onshore and offshore.',15.02,23.62,-73.5,-66.17,'','DO','DOM',214,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1084,'Timor-Leste (East Timor)','Timor-Leste (East Timor) - onshore and offshore. Includes enclave of Oe-Cussi (Okusi).',-11.02,-8.05,124.05,127.79,'','TL','TLS',626,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1085,'Ecuador','Ecuador - onshore and offshore. Includes Galapagos Islands (Archipelago de Colon).',-5.01,4.89,-95.43,-75.26,'','EC','ECU',218,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1086,'Egypt','Egypt - onshore and offshore.',21.99,33.75,24.71,36.9,'','EG','EGY',818,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1087,'El Salvador','El Salvador - onshore and offshore.',10.63,14.46,-93.47,-87.6,'','SV','SLV',222,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1088,'Equatorial Guinea','Equatorial Guinea - onshore and offshore. Includes Rio Muni, Bioko, Annobon, Corisco, Elobey Chico, and Ebony Grande.',-2.5,4.09,4.78,11.36,'','GQ','GNQ',226,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1089,'Eritrea','Eritrea - onshore and offshore.',12.33,18.57,36.4,43.3,'','ER','ERI',232,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1090,'Estonia','Estonia - onshore and offshore.',57.57,59.7,21.84,28.0,'','EE','EST',233,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1091,'Ethiopia','Ethiopia',3.4,14.88,32.99,48.12,'','ET','ETH',231,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1092,'Falkland Islands (Malvinas)','Falkland Islands (Malvinas) - onshore and offshore.',-60.04,-47.59,-65.25,-47.71,'','FK','FLK',238,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1093,'Faroe Islands','Faroe Islands - onshore and offshore.',59.87,67.48,-14.51,-0.49,'','FO','FRO',234,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1094,'Fiji','Fiji - onshore and offshore. Includes Viti Levu, Vanua Levu, Taveuni, the Yasawa Group, the Kadavu Group, the Lau Islands and Rotuma Islands.',-25.1,-9.79,172.87,-176.16,'','FJ','FJI',242,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-07-20','2002.341 2005.89 2006.50',0),
(1095,'Finland','Finland - onshore and offshore.',59.3,70.13,19.09,31.59,'','FI','FIN',246,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1096,'France','France - onshore and offshore.',41.18,51.54,-9.62,10.3,'','FR','FRA',250,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1097,'French Guiana','French Guiana - onshore and offshore.',2.11,9.06,-54.65,-49.62,'','GF','GUF',254,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1098,'French Polynesia','French Polynesia - onshore and offshore. Includes Society archipelago, Tuamotu archipelago, Marquezas Islands, Gambier Islands, Austral Islands, and Clipperton Island.',-29.0,-7.0,-155.0,-132.0,'','PF','PYF',258,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1099,'French Southern Territories','French Southern Territories - onshore and offshore. Includes Kerguelen Islands, Crozet Islands, St. Paul & Amsterdam islands.',-53.26,-34.2,46.86,80.92,'','TF','ATF',260,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1100,'Gabon','Gabon - onshore and offshore.',-6.39,2.33,5.91,14.55,'','GA','GAB',266,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1101,'Gambia','Gambia - onshore and offshore.',13.02,13.83,-20.11,-13.81,'','GM','GMB',270,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1102,'Georgia','Georgia - onshore and offshore.',41.12,43.56,39.4,46.8,'','GE','GEO',268,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1103,'Germany','Germany - onshore and offshore.',47.27,55.9,3.3,15.03,'','DE','DEU',276,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1104,'Ghana','Ghana - onshore and offshore.',1.08,11.17,-3.9,1.34,'','GH','GHA',288,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1105,'Gibraltar','Gibraltar - onshore and offshore.',36.13,36.17,-5.39,-5.37,'','GI','GIB',292,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1106,'Greece','Greece - onshore and offshore. Includes Aegean Islands, Ionian Islands, Dodecanese Islands, Crete, and Mount Athos.',33.23,41.77,18.27,29.97,'','GR','GRC',300,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1107,'Greenland','Greenland - onshore and offshore.',53.7,85.05,-75.1,5.37,'','GL','GRL',304,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1108,'Grenada','Grenada and southern Grenadine Islands - onshore and offshore.',11.13,12.57,-62.64,-60.51,'','GD','GRD',308,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1109,'Guadeloupe','Guadeloupe - onshore and offshore. Includes Grande Terre, Basse Terre, Marie Galante, Les Saintes, Iles de la Petite Terre, Desirade, Saint-Barthelemy, and northern St. Martin.',15.46,20.82,-63.91,-57.8,'','GP','GLP',312,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1110,'Guam','Guam - onshore and offshore.',12.76,14.01,140.08,145.59,'','GU','GUM',316,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1111,'Guatemala','Guatemala - onshore and offshore.',11.17,18.92,-94.95,-83.84,'','GT','GTM',320,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1112,'Guinea','Guinea - onshore and offshore.',6.38,12.69,-17.07,-7.65,'','GN','GIN',324,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1113,'Guinea-Bissau','Guinea-Bissau - onshore and offshore.',8.22,12.69,-18.52,-13.65,'','GW','GNB',624,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1114,'Guyana','Guyana - onshore and offshore.',1.19,11.98,-61.43,-55.72,'','GY','GUY',328,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1115,'Haiti','Haiti - onshore and offshore.',15.04,20.78,-74.75,-71.67,'','HT','HTI',332,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1116,'Heard Island and McDonald Islands','Heard Island and McDonald Islands - onshore and offshore.',-60.04,-48.83,70.09,78.31,'','HM','HMD',334,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1117,'Honduras','Honduras - onshore and offshore. Includes Swan Islands.',12.99,18.52,-89.4,-80.72,'','HN','HND',340,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1118,'China - Hong Kong','China - Hong Kong - onshore and offshore.',22.16,22.62,113.89,114.57,'','HK','HKG',344,'"Hong Kong" in ISO 3166.','EPSG','EPSG','2006-02-01','2002.16 2005.89',0),
(1119,'Hungary','Hungary',45.78,48.6,16.12,22.91,'','HU','HUN',348,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1120,'Iceland','Iceland - onshore and offshore.',59.87,69.23,-28.64,-10.32,'','IS','ISL',352,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1121,'India','India - onshore and offshore. Includes Amandivis, Laccadives, Minicoy, Andaman Islands, Nicobar Islands, and Sikkim.',3.12,35.55,66.16,97.45,'','IN','IND',356,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1122,'Indonesia','Indonesia - onshore and offshore.',-13.01,7.92,91.66,141.1,'','ID','IDN',360,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1123,'Iran','Iran - onshore and offshore.',23.35,39.8,44.06,63.37,'','IR','IRN',364,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1124,'Iraq','Iraq - onshore and offshore.',29.06,37.41,38.82,49.4,'','IQ','IRQ',368,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1125,'Ireland','Ireland - onshore and offshore.',48.13,56.72,-13.42,-5.2,'','IE','IRL',372,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1126,'Israel','Israel - onshore and offshore.',29.51,33.98,33.47,35.69,'','IL','ISR',376,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1127,'Italy','Italy - onshore and offshore.',34.49,47.12,5.95,18.97,'','IT','ITA',380,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1128,'Jamaica','Jamaica - onshore and offshore. Includes Morant Cays and Pedro Cays.',14.63,19.42,-80.74,-74.38,'','JM','JAM',388,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1129,'Japan','Japan - onshore and offshore.',19.01,45.92,122.49,160.09,'','JP','JPN',392,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1130,'Jordan','Jordan',29.21,33.4,34.98,39.33,'','JO','JOR',400,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1131,'Kazakhstan','Kazakhstan - onshore and offshore.',40.67,55.57,46.52,87.41,'','KZ','KAZ',398,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1132,'Kenya','Kenya - onshore and offshore.',-4.9,5.03,33.93,45.17,'','KE','KEN',404,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1133,'Kiribati','Kiribati - onshore and offshore. Includes Fanning Island, Washington Island and Christmas in the Line Islands, Ocean Islands, Phoenix Islands.',-12.51,5.0,160.22,-147.84,'','KI','KIR',296,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1134,'Korea, Democratic People''s Republic of (North Korea)','Democratic People''s Republic of Korea (North Korea) - onshore and offshore.',36.41,43.03,123.44,134.1,'','KP','PRK',408,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1135,'Korea, Republic of (South Korea)','Republic of Korea (South Korea) - onshore and offshore.',31.6,39.16,122.52,132.1,'','KR','KOR',410,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1136,'Kuwait','Kuwait - onshore and offshore.',28.56,30.1,46.57,49.24,'','KW','KWT',414,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1137,'Kyrgyzstan','Kyrgyzstan',39.24,43.25,69.3,80.33,'','KG','KGZ',417,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1138,'Laos','Laos',13.92,22.51,100.15,107.76,'','LA','LAO',418,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1139,'Latvia','Latvia - onshore and offshore.',55.64,58.12,20.98,28.23,'','LV','LVA',428,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1140,'Lebanon','Lebanon - onshore and offshore.',33.08,34.96,34.37,36.65,'','LB','LBN',422,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1141,'Lesotho','Lesotho',-30.68,-28.59,27.03,29.47,'','LS','LSO',426,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1142,'Liberia','Liberia - onshore and offshore.',0.84,8.57,-13.67,-7.37,'','LR','LBR',430,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1143,'Libya','Libya - onshore and offshore.',19.51,36.0,9.31,25.98,'','LY','LBY',434,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1144,'Liechtenstein','Liechtenstein',47.09,47.3,9.48,9.64,'','LI','LIE',438,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1145,'Lithuania','Lithuania - onshore and offshore.',53.92,56.48,21.07,26.82,'','LT','LTU',440,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1146,'Luxembourg','Luxembourg',49.48,50.21,5.73,6.53,'','LU','LUX',442,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1147,'China - Macau','China - Macau - onshore and offshore.',22.09,22.31,113.59,113.69,'','MO','MAC',446,'"Macau" in ISO 3166.','EPSG','EPSG','2006-02-01','2002.341 2005.89',0),
(1148,'Macedonia, The Former Yugoslav Republic of','The Former Yugoslav Republic of Macedonia',40.84,42.37,20.43,23.05,'','MK','MKD',807,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1149,'Madagascar','Madagascar - onshore and offshore.',-28.89,-10.6,41.14,55.34,'','MG','MDG',450,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1150,'Malawi','Malawi',-17.15,-9.38,32.7,35.95,'','MW','MWI',454,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1151,'Malaysia','Malaysia - onshore and offshore. Includes peninsular Malayasia, Sabah and Sarawak.',0.85,10.07,98.12,119.68,'','MY','MYS',458,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-04-07','2002.341 2005.89 2006.253',0),
(1152,'Maldives','Maldives - onshore and offshore.',-4.04,8.09,69.22,77.13,'','MV','MDV',462,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1153,'Mali','Mali',10.15,25.02,-12.25,4.26,'','ML','MLI',466,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1154,'Malta','Malta - onshore and offshore.',35.07,36.61,13.48,15.37,'','MT','MLT',470,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1155,'Marshall Islands','Marshall Islands - onshore and offshore.',3.09,21.01,157.09,178.61,'','MH','MHL',584,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1156,'Martinique','Martinique - onshore and offshore.',14.14,16.77,-62.57,-57.51,'','MQ','MTQ',474,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1157,'Mauritania','Mauritania - onshore and offshore.',14.73,27.31,-20.41,-4.81,'','MR','MRT',478,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1158,'Mauritius','Mauritius - onshore and offshore. Includes Rodrigues, Agalega Islands, and Cargados Carajos.',-23.82,-9.85,55.32,63.87,'','MU','MUS',480,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1159,'Mayotte','Mayotte - onshore and offshore.',-14.37,-11.32,44.13,45.77,'','YT','MYT',175,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1160,'Mexico','Mexico - onshore and offshore.',12.24,32.74,-121.91,-84.69,'','MX','MEX',484,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1161,'Micronesia, Federated States of','Federated States of Micronesia - onshore and offshore. Includes Caroline Islands, Yap, Truk, Ponape, Kosrae.',0.0,12.76,136.66,168.43,'','FM','FSM',583,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1162,'Moldova, Republic of','Republic of Moldova',45.48,48.52,26.48,30.26,'','MD','MDA',498,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1163,'Monaco','Monaco - onshore and offshore.',43.68,43.8,7.4,7.5,'','MC','MCO',492,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1164,'Mongolia','Mongolia',41.56,52.17,87.76,119.98,'','MN','MNG',496,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1165,'Montserrat','Montserrat - onshore and offshore.',16.09,17.04,-63.16,-61.88,'','MS','MSR',500,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1166,'Morocco','Morocco - onshore and offshore.',27.68,36.23,-13.77,-1.01,'','MA','MAR',504,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1167,'Mozambique','Mozambique - onshore and offshore.',-26.88,-9.56,30.23,43.0,'','MZ','MOZ',508,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1168,'Myanmar (Burma)','Myanmar (Burma) - onshore and offshore.',9.47,28.57,91.07,101.23,'','MM','MMR',104,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/isoISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1169,'Namibia','Namibia - onshore and offshore.',-31.2,-16.99,8.32,25.28,'','NA','NAM',516,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1170,'Nauru','Nauru - onshore and offshore.',-3.5,0.0,164.1,168.43,'','NR','NRU',520,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1171,'Nepal','Nepal',26.36,30.46,80.1,88.25,'','NP','NPL',524,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1172,'Netherlands','Netherlands - onshore and offshore.',50.78,55.8,2.48,7.37,'','NL','NLD',528,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1173,'Netherlands Antilles','Netherlands Antilles - onshore and offshore. Includes Bonaire, Curacao, Saba, St. Eustatius, and southern St. Martin',11.67,18.07,-69.59,-62.82,'','AN','ANT',530,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1174,'New Caledonia','New Caledonia - onshore and offshore. Isle de Pins, Loyalty Islands, Huon Islands, Belep archipelago, Chesterfield Islands, and Walpole.',-23.46,-17.26,157.09,173.89,'','NC','NCL',540,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1175,'New Zealand','New Zealand - onshore and offshore. Includes Antipodes Islands, Auckland Islands, Bounty Islands, Chatham Islands, Cambell Island, Kermadec Islands, and Snares Islands.',-55.95,-22.74,157.41,-170.89,'','NZ','NZL',554,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1176,'Nicaragua','Nicaragua - onshore and offshore.',9.34,16.49,-91.47,-79.97,'','NI','NIC',558,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1177,'Niger','Niger',11.7,23.54,0.17,16.01,'','NE','NER',562,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1178,'Nigeria','Nigeria - onshore and offshore.',0.93,13.9,2.7,14.68,'','NG','NGA',566,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1179,'Niue','Niue - onshore and offshore.',-19.85,-17.09,-171.1,-166.85,'','NU','NIU',570,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1180,'Norfolk Island','Norfolk Island - onshore and offshore.',-32.37,-25.35,164.73,172.01,'','NF','NFK',574,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1181,'Northern Mariana Islands','Northern Mariana Islands - onshore and offshore.',12.76,21.01,140.08,157.09,'','MP','MNP',580,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1182,'Norway','Norway - onshore and offshore.',56.12,74.04,-2.41,32.02,'','NO','NOR',578,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1183,'Oman','Oman - onshore and offshore. Includes Kuria Muria Islands.',14.01,26.75,51.9,63.05,'','OM','OMN',512,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1184,'Pakistan','Pakistan - onshore and offshore.',20.59,37.08,60.91,77.87,'','PK','PAK',586,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1185,'Palau','Palau - onshore and offshore.',0.0,10.91,130.66,146.42,'','PW','PLW',585,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1186,'Panama','Panama - onshore and offshore.',5.24,12.48,-84.26,-77.15,'','PA','PAN',591,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1187,'Papua New Guinea (PNG)','Papua New Guinea (PNG) - onshore and offshore. Includes Bismark archipelago, Louisade archipelago, Admiralty Islands, d''Entrecasteaux Islands, northern Solomon Islands, Trobriand Islands, New Britain, New Ireland, Woodlark, and associated islands.',-12.01,0.0,140.93,164.1,'','PG','PNG',598,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1188,'Paraguay','Paraguay',-27.6,-19.31,-62.68,-54.28,'','PY','PRY',600,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1189,'Peru','Peru - onshore and offshore.',-20.72,-0.03,-84.73,-68.72,'','PE','PER',604,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1190,'Philippines','Philippines - onshore and offshore.',2.25,21.43,116.09,140.08,'','PH','PHL',608,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1191,'Pitcairn','Pitcairn - Pitcairn Island, Henderson Island, Ducie Island and Oeno Atoll.',-26.77,-22.01,-132.08,-122.07,'','PN','PCN',612,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1192,'Poland','Poland - onshore and offshore.',49.03,55.95,14.14,24.16,'','PL','POL',616,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1193,'Portugal','Portugal - onshore and offshore.',29.68,43.13,-34.63,-6.18,'','PT','PRT',620,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1194,'Puerto Rico','Puerto Rico - onshore and offshore.',14.94,21.81,-75.43,-64.06,'','PR','PRI',630,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1195,'Qatar','Qatar - onshore and offshore.',24.48,27.03,50.61,53.07,'','QA','QAT',634,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1196,'Reunion','Reunion - onshore and offshore - Reunion island, Ile Europa, Bassas da India, Juan de Nova, Iles Glorieuses, and Ile Tromelin.',-25.92,-10.6,37.58,58.27,'','RE','REU',638,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1197,'Romania','Romania - onshore and offshore.',43.62,48.26,20.26,31.5,'','RO','ROU',642,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1198,'Russian Federation','Russian Federation - onshore and offshore.',35.16,81.9,19.15,-168.25,'','RU','RUS',643,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1199,'Rwanda','Rwanda',-2.83,-1.06,28.87,30.91,'','RW','RWA',646,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1200,'Saint Kitts and Nevis','Saint Kitts and Nevis - onshore and offshore.',16.58,17.75,-63.63,-62.21,'','KN','KNA',659,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1201,'Saint Lucia','Saint Lucia - onshore and offshore.',13.38,14.37,-62.71,-60.14,'','LC','LCA',662,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1202,'Saint Vincent and the Grenadines','Saint Vincent and the northern Grenadine Islands - onshore and offshore.',12.15,13.76,-62.75,-60.39,'','VC','VCT',670,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1203,'Samoa','Samoa - onshore and offshore.',-15.51,-10.37,-175.35,-171.1,'','WS','WSM',882,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1204,'San Marino','San Marino',43.92,44.01,12.41,12.52,'','SM','SMR',674,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1205,'Sao Tome and Principe','Sao Tome and Principe - onshore and offshore.',-0.67,2.44,4.78,8.53,'','ST','STP',678,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1206,'Saudi Arabia','Saudi Arabia - onshore and offshore.',15.9,32.26,34.27,55.7,'','SA','SAU',682,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1207,'Senegal','Senegal - onshore and offshore.',9.5,16.7,-20.21,-11.37,'','SN','SEN',686,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1208,'Seychelles','Seychelles - onshore and offshore - Alphonse, Bijoutier, St. Francois Islands, St. Pierre islet, Cosmoledo Islands, Amirantes, Aldabra, Farquhar, and Desroches.',-10.61,-3.01,45.77,56.98,'','SC','SYC',690,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1209,'Sierra Leone','Sierra Leone - onshore and offshore.',4.27,10.0,-15.68,-10.27,'','SL','SLE',694,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1210,'Singapore','Singapore - onshore and offshore.',1.12,1.46,103.62,104.16,'','SG','SGP',702,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1211,'Slovakia (Slovak Republic)','Slovakia (Slovak Republic)',47.74,49.65,16.84,22.58,'','SK','SVK',703,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1212,'Slovenia','Slovenia - onshore and offshore.',45.44,46.91,13.37,16.68,'','SI','SVN',705,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1213,'Solomon Islands','Solomon Islands - onshore and offshore - southern Solomon Islands, primarily Guadalcanal, Malaita, San Cristobel, Santa Isobel, Choiseul.',-13.26,-3.5,154.09,171.1,'','SB','SLB',90,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1214,'Somalia','Somalia - onshore and offshore.',-2.39,13.4,41.01,54.98,'','SO','SOM',706,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1215,'South Africa','South Africa - onshore and offshore, including Marion Island, and Prince Edward Island.',-50.34,-22.14,14.03,41.16,'','ZA','ZAF',710,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1216,'South Georgia and the South Sandwich Islands','South Georgia and the South Sandwich Islands - onshore and offshore.',-62.95,-49.28,-47.71,-22.76,'','GS','SGS',239,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1217,'Spain','Spain - onshore and offshore.',27.35,45.96,-21.6,6.3,'','ES','ESP',724,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1218,'Sri Lanka','Sri Lanka - onshore and offshore.',2.51,11.04,77.06,87.55,'','LK','LKA',144,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1219,'Saint Helena','Saint Helena - onshore and offshore, including Ascension, Gough Island, Inaccessible, Nightingale Islands, and Tristan da Cunha.',-43.81,-3.21,-18.13,-2.16,'','SH','SHN',654,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1220,'Saint Pierre and Miquelon','Saint Pierre and Miquelon - onshore and offshore.',43.53,47.39,-58.02,-55.12,'','PM','SPM',666,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1221,'Sudan','Sudan - onshore and offshore.',3.49,22.25,21.84,39.41,'','SD','SDN',736,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1222,'Suriname','Suriname - onshore and offshore.',1.84,9.51,-58.11,-52.87,'','SR','SUR',740,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1223,'Svalbard and Jan Mayen','Svalbard and Jan Mayen - onshore and offshore. Includes Bear Island.',66.24,85.05,-16.22,35.02,'','SJ','SJM',744,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1224,'Swaziland','Swaziland',-27.31,-25.74,30.82,32.15,'','SZ','SWZ',748,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1225,'Sweden','Sweden - onshore and offshore.',55.2,69.1,10.57,24.18,'','SE','SWE',752,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1226,'Switzerland','Switzerland',45.85,47.84,5.97,10.49,'','CH','CHE',756,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1227,'Syria','Syria - onshore and offshore.',32.33,37.34,35.08,42.4,'','SY','SYR',760,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1228,'Taiwan, Province of China','Taiwan, Province of China - onshore and offshore - Taiwan Island, Penghu (Pescadores) Islands.',21.43,26.36,118.07,122.49,'','TW','TWN',158,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1229,'Tajikistan','Tajikistan',36.7,41.07,67.3,75.23,'','TJ','TJK',762,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1230,'Tanzania','Tanzania - onshore and offshore.',-11.75,-1.0,29.36,43.51,'','TZ','TZA',834,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1231,'Thailand','Thailand - onshore and offshore.',5.63,20.47,95.59,105.7,'','TH','THA',764,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1232,'Togo','Togo - onshore and offshore.',2.45,11.15,-0.15,1.94,'','TG','TGO',768,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1233,'Tokelau','Tokelau - onshore and offshore.',-11.51,-7.75,-175.35,-166.85,'','TK','TKL',772,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1234,'Tonga','Tonga - onshore and offshore.',-24.38,-15.51,-179.18,-171.1,'','TO','TON',776,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1235,'Trinidad and Tobago','Trinidad and Tobago - onshore and offshore.',9.82,11.68,-62.08,-58.53,'','TT','TTO',780,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1236,'Tunisia','Tunisia - onshore and offshore.',30.25,38.43,7.5,13.74,'','TN','TUN',788,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1237,'Turkey','Turkey - onshore and offshore.',34.47,43.93,25.59,44.85,'','TR','TUR',792,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1238,'Turkmenistan','Turkmenistan - onshore and offshore.',35.16,42.75,52.54,66.82,'','TM','TKM',795,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1239,'Turks and Caicos Islands','Turks and Caicos Islands - onshore and offshore.',20.49,25.04,-72.75,-68.41,'','TC','TCA',796,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1240,'Tuvalu','Tuvalu - onshore and offshore. Funafuti, Nanumanga, Nui, Nanomea, Nurakita, Niutao, Nukufetau, Nukulaelae, and Vaitupu.',-12.76,-3.5,168.43,-175.14,'','TV','TUV',798,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1241,'Uganda','Uganda',-1.48,4.23,29.58,35.05,'','UG','UGA',800,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1242,'Ukraine','Ukraine - onshore and offshore.',43.5,52.38,22.17,40.29,'','UA','UKR',804,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1243,'United Arab Emirates (UAE)','United Arab Emirates (UAE) - onshore and offshore. Abu Dhabi, Dubai, Sharjah, Umm al Qaywayn, Al Fujairah, Ras al Khaymah.',22.64,26.29,51.16,57.03,'','AE','ARE',784,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1244,'United Kingdom (UK)','United Kingdom (UK) - onshore and offshore - England, Scotland including Orkney and Shetland Islands, Wales, Northern Ireland (Ulster), Channel Islands, and the Isle of Man.',48.24,63.92,-19.51,3.4,'','GB','GBR',826,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1245,'United States (USA)','United States (USA) - onshore and offshore.',15.32,74.79,168.33,-66.02,'','US','USA',840,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1246,'United States Minor Outlying Islands','United States Minor Outlying Islands - onshore and offshore - Baker Island, Howland Islands, Jarvis Island, Johnston Atoll, Kingman Reef, Midway Islands, Palmyra Islands, and Wake Island.',-0.75,32.05,163.15,-158.8,'','UM','UMI',581,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1247,'Uruguay','Uruguay - onshore and offshore.',-37.87,-30.12,-58.51,-50.45,'','UY','URY',858,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1248,'Uzbekistan','Uzbekistan',37.21,45.61,55.98,72.3,'','UZ','UZB',860,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1249,'Vanuatu','Vanuatu - onshore and offshore. Aese, Ambrym, Aoba, Epi, Efete, Erromango, Espiritu Santo, Maewo, Malakula, Malo, Paama, Penecost, Shepherd, Tanna, Tutuba and Banks Islands.',-20.76,-12.76,157.09,174.56,'','VU','VUT',548,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-07-29','2002.341 2005.89 2006.51',0),
(1250,'Holy See (Vatican City State)','Holy See (Vatican City State)',41.9,41.91,12.44,12.46,'','VA','VAT',336,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1251,'Venezuela','Venezuela - onshore and offshore.',0.65,16.76,-73.36,-57.38,'','VE','VEN',862,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1252,'Vietnam','Vietnam - onshore and offshore.',6.0,23.39,102.2,113.32,'','VN','VNM',704,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1253,'Virgin Islands, British','British Virgin Islands - onshore and offshore - Anegada, Jost Van Dyke, Tortola, and Virgin Gorda.',17.21,21.7,-64.9,-63.88,'','VG','VGB',92,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1254,'Virgin Islands, US','US Virgin Islands - onshore and offshore - St. Croix, St. John, and St. Thomas.',16.76,21.71,-65.44,-63.89,'','VI','VIR',850,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1255,'Wallis and Futuna','Wallis and Futuna - onshore and offshore - Uvea, Futuna, and Alofi.',-15.51,-11.51,178.3,-175.14,'','WF','WLF',876,'Area crosses 180-degree meridian.','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1256,'Western Sahara','Western Sahara - onshore and offshore.',20.78,27.68,-20.36,-8.67,'','EH','ESH',732,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1257,'Yemen','Yemen - onshore and offshore.',11.61,19.01,41.44,55.03,'','YE','YEM',887,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1258,'Yugoslavia - Serbia and Montenegro','Yugoslavia - Union of Serbia and Montenegro - onshore and offshore.',41.82,46.23,18.44,23.05,'','YU','YUG',891,'','EPSG','EPSG','2006-02-01','2002.341 2003.06 2005.89',1),
(1259,'Congo DR (Zaire)','The Democratic Republic of the Congo (Zaire) - onshore and offshore.',-13.46,5.38,12.21,31.3,'','CD','COD',180,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2006-02-01','2002.341 2005.89',0),
(1260,'Zambia','Zambia',-18.09,-8.2,22.01,33.72,'','ZM','ZMB',894,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1261,'Zimbabwe','Zimbabwe',-22.43,-15.63,25.25,33.09,'','ZW','ZWE',716,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','2002.341',0),
(1262,'World','World.',-90.0,90.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1263,'Not specified','Not specified.',-90.0,90.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1264,'United Kingdom (UK) - Great Britain onshore; Isle of Man','United Kingdom (UK) - Great Britain - England  Scotland  Wales - onshore; Isle of Man.',49.96,60.84,-7.56,1.78,'','','',NULL,'','EPSG','EPSG','2006-01-16','2005.88',0),
(1265,'Argentina - Comodoro Rivadavia','Argentina - Comodoro Rivadavia area.',-46.7,-45.2,-69.5,-67.1,'','','',NULL,'','EPSG','EPSG','2006-02-03','2005.89',0),
(1266,'Venezuela - Puerto La Cruz','Venezuela - Puerto La Cruz area.',10.0,10.3,-64.7,-64.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1267,'Venezuela - Barinas','Venezuela - Barinas area.',7.29,9.02,-71.85,-67.54,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1268,'Venezuela - Falcon state','Venezuela - Falcon state.',10.31,12.2,-71.28,-68.24,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1269,'Venezuela - Pedregal area of Falcon state','Venezuela - Pedregal area of Falcon state.',10.8,11.25,-70.4,-69.7,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1270,'Venezuela - Maracaibo south','Venezuela - south Maracaibo area.',9.0,10.0,-72.15,-71.0,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1271,'Africa - Eritrea, Ethiopia and Sudan','Eritrea; Ethiopia; Sudan.',3.41,22.23,21.83,47.99,'','','',NULL,'','EPSG','EPSG','2003-03-06','2002.81',0),
(1272,'Asia - Middle East - Bahrain, Kuwait and Saudi Arabia','Bahrain; Kuwait; Saudi Arabia.',16.38,32.15,34.57,55.67,'','','',NULL,'','EPSG','EPSG','2006-01-30','2006.09',0),
(1273,'Antigua','Antigua and Barbuda - Antigua.',16.99,17.72,-61.89,-61.67,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(1274,'Brazil - Aratu','Brazil - coastal and offshore areas south of 2 deg 55 min South.',-34.0,-2.9,-53.0,-34.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1275,'Netherlands - onshore','Netherlands - onshore.',50.75,53.47,3.37,7.21,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1276,'Africa - Botswana, Malawi, Zambia, Zimbabwe.','Botswana; Malawi; Zambia; Zimbabwe.',-26.88,-8.19,20.0,35.92,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1277,'Africa - Kenya, Tanzania and Uganda','Kenya; Tanzania; Uganda.',-11.74,4.62,29.34,41.91,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1278,'Antarctica - Australian sector','Antarctica - Australian sector.',-90.0,-60.0,45.0,160.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1279,'Australasia - Australia and PNG - AGD66','Australia - Australian Capital Territory (ACT); New South Wales (NSW); Northern Territory (NT); Tasmania; Victoria.  Papua New Guinea (PNG).',-45.0,-1.0,129.0,155.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1280,'Australia - Western Australia','Australia - Western Australia (WA).',-35.14,-13.73,112.91,129.0,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1281,'Australia - mainland','Australia - Australian Capital Territory (ACT); New South Wales (NSW); Northern Territory (NT); Queensland; South Australia (SA); Western Australia (WA); Victoria.',-39.15,-10.14,112.91,153.62,'','','',NULL,'','EPSG','EPSG','2007-01-23','2007.009',0),
(1282,'Australia - Tasmania','Australia - Tasmania (Tas).',-54.75,-39.57,143.83,158.96,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1283,'Canada - Maritime Provinces','Canada - New Brunswick (NB); Nova Scotia (NS); Prince Edward Island (PEI).',43.46,48.07,-69.05,-59.81,'','','',NULL,'','EPSG','EPSG','1997-07-22','',0),
(1284,'Europe - Soviet Union, Slovakia','Armenia;  Azerbaijan;  Belorus;  Estonia;  Georgia;  Kazakhstan;  Kyrgyzstan;  Latvia;  Lithuania;  Moldavia;  Russian Federation; Slovakia; Tajikistan;  Turkmenistan;  Ukraine;  Uzbekistan.',35.15,81.85,16.84,-169.69,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2006-06-02','2006.38',0),
(1285,'Indonesia - Java','Indonesia - Java.',-8.78,-5.73,105.11,115.57,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1286,'Europe - Liechtenstein and Switzerland.','Liechtenstein; Switzerland.',45.83,47.81,5.97,10.49,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1287,'Indonesia - Banga & Belitung Islands.','Indonesia - Banga & Belitung Islands.',-3.25,-1.49,105.12,108.29,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1288,'Angola - Angola proper','Angola - Angola proper - onshore and offshore.',-18.05,-5.75,12.11,24.1,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1289,'Canada - CVD28','Canada - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Nova Scotia (NS); Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan.',41.68,62.56,-139.05,-57.1,'','','',NULL,'','EPSG','EPSG','1996-12-12','',0),
(1290,'Africa - Botswana and South Africa.','Botswana; South Africa.',-46.97,-17.78,16.48,37.89,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1291,'Asia - FSU - Caspian Sea','Azerbaijan - offshore; Kazakhstan - offshore;  Russian Federation - Caspian Sea;  Turkmenistan - offshore.',36.58,47.11,46.68,54.76,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1292,'Argentina - Neuquen province','Argentina - Neuquen province.',-41.1,-36.14,-71.95,-68.25,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1293,'Brazil - Corrego Alegre','Brazil - south of 18 deg South; north of 18 deg South and east of 54 deg West.',-35.89,-2.8,-58.2,-34.5,'','','',NULL,'','Ajustamento da Rede Planimetrica do SGB, IBGE.','EPSG','2006-12-30','2005.841',0),
(1294,'Portugal - onshore','Portugal - onshore.',37.01,42.15,-9.49,-6.19,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1295,'Germany - DHDN','Germany - onshore - Baden-Wurtemberg, Bayern, Hessen, Niedersachsen, Nordrhein-Westfalen, Rheinland-Pfalz, Saarland, Schleswig-Holstein. Also former DDR states of Sachsen and Thuringen by transformation.',47.27,55.06,5.87,15.03,'','','',NULL,'','EPSG','EPSG','2001-06-05','',1),
(1296,'Europe - ED50 by country','Europe - west - Denmark; Faroe Islands; France offshore; Israel offshore; Italy including San Marino and Vatican City State; Ireland offshore; Netherlands offshore; Germany; Greece (offshore); North Sea; Norway; Spain; Svalbard; Turkey; United Kingdom UKCS offshore. Egypt - Western Desert.',31.0,75.0,-15.6,35.8,'','','',NULL,'','EPSG','EPSG','2006-03-16','2003.141 2004.15 2004.63 2005.46 2005.471 2005.89',0),
(1297,'Europe - west','Europe - west.',36.0,71.05,-8.95,31.6,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.89',0),
(1298,'Europe - ETRS89','Europe: Albania; Andorra; Austria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia; Cyprus; Czech Republic; Denmark; Estonia; Finland; Faroe Islands; France; Germany; Greece; Hungary; Ireland; Italy; Latvia; Liechtenstein; Lithuania; Luxembourg; Malta; Netherlands; Norway; Poland; Portugal; Romania; San Marino; Serbia and Montenegro; Slovakia; Slovenia; Spain; Svalbard; Sweden; Switzerland; United Kingdom (UK) including Channel Islands and Isle of Man; Vatican City State.',34.5,71.05,-10.67,31.55,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.89',0),
(1299,'Europe - EVRF2000','Europe: Andorra; Austria; Belgium; Bosnia and Herzegovina; Croatia; Czech Republic; Denmark; Estonia; Finland; France - mainland; Germany; Hungary; Italy - mainland and Sicily; Latvia; Liechtenstein; Lithuania; Luxembourg; Netherlands; Norway; Poland; Portugal; Romania; San Marino; Slovakia; Slovenia; Spain - mainland; Sweden; Switzerland; United Kingdom (UK) - Great Britain mainland; Vatican City State.',36.6,71.05,-9.5,31.55,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.89',0),
(1300,'Iran - FD58','Iran - Gulf coast and Arwaz areas.',27.25,33.0,47.0,52.7,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1301,'Portugal - central Azores','Portugal - central Azores - Graciosa, Terceira, Sao Jorge, Pico, Faial.',38.35,39.15,-28.85,-27.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1302,'Asia - Cambodia and Vietnam - onshore','Cambodia - onshore; Vietnam - onshore.',8.56,23.32,102.14,109.46,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1303,'South America - Tierra del Fuego.','Argentina and Chile - Tierra del Fuego.',-56.0,-52.4,-72.1,-65.1,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1304,'Asia - Myanmar and Thailand','Myanmar (Burma); Thailand.',5.63,28.55,92.2,105.64,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1305,'Europe - Ireland (Republic and Ulster) - onshore','Ireland - onshore. United Kingdom (UK) - Northern Ireland (Ulster) - onshore.',51.33,55.4,-10.6,-5.33,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1306,'Europe - Czechoslovakia','Czech Republic; Slovakia.',47.74,51.05,12.09,22.56,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1307,'Asia - Bangladesh; India; Myanmar; Pakistan.','Bangladesh; India; Myanmar (Burma); Pakistan.',6.75,37.06,60.87,101.17,'','','',NULL,'','EPSG','EPSG','2004-04-27','2004.27',0),
(1308,'Asia - Bangladesh; India; Pakistan.','Bangladesh; India; Pakistan.',6.75,37.06,60.87,97.38,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1309,'Asia - Malaysia (west) and Singapore.','Malaysia - West Malaysia; Singapore.',1.26,6.71,99.64,104.29,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1310,'Kuwait - Kuwait City','Kuwait - Kuwait City.',29.25,29.45,47.67,48.15,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1311,'Venezuela - Cabinas','Venezuela - Cabinas area.',10.15,10.6,-71.55,-71.3,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1312,'Venezuela - Lake Maracaibo','Venezuela - Lake Maracaibo area.',9.0,10.6,-72.15,-71.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1313,'Venezuela - Loma Quintana','Venezuela - north.',7.75,12.22,-73.36,-60.75,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1314,'Portugal - Madeira islands','Portugal - Madeira, Porto Santo and Desertas islands.',32.39,33.15,-17.27,-16.25,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1315,'Mozambique - west - Tete province','Mozambique - west - Tete province.',-17.5,-14.0,30.23,34.5,'','','',NULL,'','EPSG','EPSG','1998-04-16','',0),
(1316,'Indonesia - Sulawesi SW','Indonesia - south west Sulawesi.',-7.9,2.0,117.6,121.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1317,'Angola - Cabinda offshore','Angola - Cabinda offshore.',-6.0,-5.03,10.6,12.23,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1318,'Angola - Cabinda','Angola - Cabinda.',-5.77,-4.39,12.11,13.09,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1319,'Venezuela - Maracaibo area','Venezuela - Maracaibo area.',9.0,10.6,-72.15,-70.5,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1320,'Venezuela - Maturin','Venezuela - Maturin area.',9.1,10.13,-64.3,-63.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1321,'Europe - MGI','Austria. Bosnia and Herzegowina. Croatia. FYR Macedonia. Slovenia. Yugoslavia (Serbia, Montenegro).',40.84,49.02,9.53,23.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1322,'Trinidad and Tobago - Tobago','Trinidad and Tobago - Tobago - onshore.',11.08,11.39,-60.91,-60.37,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1323,'United States (USA) - conus','United States (USA) - Alabama; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',24.53,49.39,-124.85,-67.07,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1324,'United States (USA) (all states)','United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',15.32,74.79,168.33,-66.02,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2001-09-03','',0),
(1325,'North America - all Canada and USA subunits','North America: Canada - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; North West Territories; Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',23.94,80.0,170.0,-44.0,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2006-07-21','2006.462 2004.463',0),
(1326,'France - mainland','France - mainland.',42.25,51.1,-5.2,8.23,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1327,'France - Corsica','France - Corsica.',41.33,43.05,8.5,9.6,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1328,'Indonesia - Kalimantan E - Mahakam delta','Indonesia - east Kalimantan - Mahakam delta area.',-1.35,0.0,116.9,118.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1329,'Mozambique - south','Mozambique - south.',-26.88,-19.75,31.3,35.6,'','','',NULL,'','EPSG','EPSG','1998-04-16','',0),
(1330,'United States (USA) - Alaska','United States (USA) - Alaska',51.35,71.35,172.4,-129.99,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2001-09-03','',0),
(1331,'United States (USA) - Alaska - St. George Island','United States (USA) - Alaska - Pribilof Islands - St. George Island.',56.53,56.61,-169.78,-169.46,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1332,'United States (USA) - Alaska - St. Lawrence Island','United States (USA) - Alaska - St. Lawrence Island.',62.93,63.79,-171.85,-168.69,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1333,'United States (USA) - Alaska - St. Paul Island','United States (USA) - Alaska - Pribilof Islands - St. Paul Island.',57.1,57.25,-170.43,-170.08,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1334,'United States (USA) - Hawaii','United States (USA) - Hawaii.',18.9,22.24,-160.55,-154.8,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1335,'Caribbean - Puerto Rico and the Virgin Islands','Puerto Rico; Virgin Islands (British); Virgin Islands (US).',17.68,18.52,-67.27,-64.32,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1336,'Canada - CSRS98','Canada - Alberta; New Brunswick; Saskatchewan; Prince Edward Island; and Quebec.',44.61,62.56,-120.0,-57.1,'','','',NULL,'','EPSG','EPSG','2000-10-19','',1),
(1337,'United States (USA) - HARN','American Samoa - Tutuila, Aunu''u, Ofu, Olesega, Ta''u and Rose islands. Guam. Puerto Rico and the Virgin Islands (PRVI). United States (USA) - Alabama; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',-14.57,49.39,-170.85,-64.56,'','','',NULL,'','National Geodetic Survey','EPSG','2006-01-31','2001.60 2004.23 2004.75 2005.23 2005.891',0),
(1338,'Iran - Taheri refinery','Iran - Taheri refinery site.',27.4,27.6,52.5,52.7,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1339,'Trinidad and Tobago - Trinidad','Trinidad and Tobago - Trinidad - onshore and offshore.',9.82,11.68,-62.08,-58.53,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1340,'Yemen - South Yemen','Yemen - South Yemen.',12.0,15.0,42.5,53.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1341,'South America by country','South America - Argentina, Brazil, Bolivia, Chile, Colombia, Ecuador, French Guiana, Guyana, Paraguay, Peru, Suriname, Uruguay, Venezuela.',-56.15,13.0,-82.0,-34.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1342,'Sierra Leone - Freetown Peninsula','Sierra Leone - Freetown Peninsula.',8.1,8.6,-13.33,-13.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1343,'Germany - East Germany all states','Germany - states of former East Germany - Brandenburg; Mecklenburg-Vorpommern; Sachsen; Sachsen-Anhalt; Thuringen.',50.17,54.72,9.87,15.03,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1344,'Portugal - western Azores','Portugal - western Azores - Flores, Corvo.',39.35,39.75,-31.3,-31.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1345,'Portugal - eastern Azores','Portugal - eastern Azores - Sao Miguel, Santa Maria.',36.9,37.95,-25.9,-24.95,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1346,'Qatar - onshore','Qatar - onshore.',24.48,26.18,50.75,51.64,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1347,'Belgium - onshore','Belgium - onshore.',49.51,51.5,2.54,6.4,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1348,'South America - PSAD56','Aruba; Brazil - offshore - Amazon Cone; Bolivia; Chile; Ecuador; Guyana; Netherlands Antilles (Bonaire, Curacao); Peru; [Venezuela].',-49.0,12.63,-81.4,-56.86,'','','',NULL,'','EPSG','EPSG','2006-06-22','2005.144 2006.48',0),
(1349,'North America - NAD27','North and central America: Antigua and Barbuda. Belize. Canada - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; North West Territories; Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon. Costa Rica. Cuba. El Salvador. Guatemala. Honduras. Mexico. Nicaragua. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.  Virgin Islands (British).  Virgin Islands (US).',8.0,72.0,172.0,-52.0,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2006-07-21','2004.463',0),
(1350,'North America - NAD83','North America: Canada - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; North West Territories; Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',14.25,83.2,172.0,-52.0,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2006-07-19','2006.462 2002.463 2006.464',0),
(1351,'Asia - Middle East - Nahrwan','Arabian Gulf; Iraq; Kuwait; Qatar - offshore; United Arab Emirates (UAE) - Abu Dhabi; Dubai; Sharjah; Ajman; Fujairah; Ras Al Kaimah; Umm Al Qaiwain.',22.63,37.41,38.82,56.38,'','','',NULL,'','EPSG','EPSG','2006-06-02','2006.34',0),
(1352,'Norway - onshore','Norway - onshore.',57.95,71.2,4.6,32.02,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1353,'France - onshore','France - onshore.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2000-03-07','',1),
(1354,'Europe - British Isles - UK and Ireland','Ireland - onshore.  United Kingdom (UK) - onshore - England; Scotland; Wales; Northern Ireland. Isle of Man.',49.96,60.84,-10.48,1.75,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1355,'Indonesia - Sumatra','Indonesia - Sumatra.',-6.5,6.0,95.0,108.55,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1356,'Asia - Middle East - Israel, Jordan and Palestine Territory','Israel; Jordan; Palestine Territory.',29.19,33.38,34.22,39.3,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.34',0),
(1357,'Europe - eastern and FSU','Armenia; Azerbaijan; Belarus; Estonia; Georgia; Kazakhstan; Kyrgyzstan; Latvia; Lithuania; Moldova; Russian Federation; Tajikistan; Turkmenistan; Ukraine; Uzbekistan; Germany (former DDR); Czech Republic; Slovakia; Hungary; Poland; Romania; Latvia; Lithuania; Estonia; Albania.',35.1,78.0,9.87,-169.73,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2006-06-02','2006.38',0),
(1358,'South America - SAD69','South America - Brazil east of 50 deg West; west of 50 deg West and south of 15 deg South.',-35.89,4.5,-60.46,-34.75,'','','',NULL,'','EPSG','EPSG','2005-07-01','',0),
(1359,'Indonesia - Kalimantan SE','Indonesia - southeast Kalimantan.',-5.72,2.5,114.0,118.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1360,'Indonesia - Kalimantan E','Indonesia - east Kalimantan.',-5.72,4.4,113.69,119.62,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1361,'Sudan - south','Sudan - south.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','1995-06-02','',1),
(1362,'Asia - Brunei and East Malaysia','Brunei; Malaysia - East Malaysia (Sabah; Sarawak).',0.85,7.35,109.55,119.26,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1363,'United Arab Emirates (UAE) - Abu Dhabi and Dubai - onshore','United Arab Emirates (UAE) - Abu Dhabi onshore and Dubai onshore.',22.6,26.0,51.16,54.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1364,'Asia - Japan and Korea','Japan; North Korea; South Korea.',24.25,45.49,123.68,145.81,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1365,'Algeria - N of 32 deg N','Algeria - north of 32 deg North.',32.0,37.09,-2.92,9.09,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1366,'Africa - Algeria, Morocco and Tunisia','Algeria; Morocco; Tunisia.',18.98,37.34,-13.17,11.99,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1367,'Canada - Ontario','Canada - Ontario.',41.68,56.86,-95.15,-74.32,'','','',NULL,'','EPSG','EPSG','1999-05-12','',0),
(1368,'Canada - Quebec','Canada - Quebec.',44.99,62.56,-79.76,-57.1,'','','',NULL,'','EPSG','EPSG','1999-10-22','',0),
(1369,'France - Alsace','France - Alsace.',47.4,49.1,6.8,8.23,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1370,'Venezuela - Deltana','Venezuela - Deltana area.',7.9,10.2,-62.8,-60.0,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1371,'Venezuela - Guarico state','Venezuela - Guarico state.',7.6,10.02,-68.0,-64.78,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1372,'United States (USA) - Alabama','United States (USA) - Alabama.',30.2,35.0,-88.48,-84.89,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1373,'United States (USA) - Arizona','United States (USA) - Arizona.',31.33,37.0,-114.75,-109.05,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1374,'United States (USA) - Arkansas','United States (USA) - Arkansas.',33.0,36.49,-94.63,-89.65,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1375,'United States (USA) - California','United States (USA) - California.',32.51,42.0,-124.42,-114.13,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1376,'United States (USA) - Colorado','United States (USA) - Colorado.',37.0,41.0,-109.05,-102.05,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1377,'United States (USA) - Connecticut','United States (USA) - Connecticut - counties of Fairfield; Hartford; Litchfield; Middlesex; New Haven; New London; Tolland; Windham.',40.95,42.05,-73.73,-71.78,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1378,'United States (USA) - Delaware','United States (USA) - Delaware - counties of Kent; New Castle; Sussex.',38.44,39.84,-75.78,-74.95,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1379,'United States (USA) - Florida','United States (USA) - Florida.',24.43,31.0,-87.64,-80.02,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1380,'United States (USA) - Georgia','United States (USA) - Georgia.',30.35,35.0,-85.02,-80.79,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1381,'United States (USA) - Idaho','United States (USA) - Idaho.',42.0,49.0,-117.24,-111.05,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1382,'United States (USA) - Illinois','United States (USA) - Illinois.',36.97,42.5,-91.51,-87.5,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1383,'United States (USA) - Indiana','United States (USA) - Indiana.',37.77,41.75,-88.09,-84.81,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1384,'United States (USA) - Iowa','United States (USA) - Iowa.',40.37,43.51,-96.64,-90.13,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1385,'United States (USA) - Kansas','United States (USA) - Kansas.',36.99,40.0,-102.05,-94.59,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1386,'United States (USA) - Kentucky','United States (USA) - Kentucky.',36.5,39.14,-89.42,-81.98,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1387,'United States (USA) - Louisiana','United States (USA) - Louisiana.',28.88,33.03,-94.05,-88.81,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1388,'United States (USA) - Maine','United States (USA) - Maine.',42.98,47.46,-71.08,-66.89,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1389,'United States (USA) - Maryland','United States (USA) - Maryland - counties of Allegany; Anne Arundel; Baltimore; Calvert; Caroline; Carroll; Cecil; Charles; Dorchester; Frederick; Garrett; Harford; Howard; Kent; Montgomery; Prince Georges; Queen Annes; Somerset; St. Marys; Talbot; Washington; Wicomico; Worcester.',37.88,39.72,-79.49,-74.98,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1390,'United States (USA) - Massachusetts','United States (USA) - Massachusetts.',41.2,42.89,-73.51,-69.86,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1391,'United States (USA) - Michigan','United States (USA) - Michigan.',41.7,48.3,-90.41,-82.12,'','','',NULL,'','EPSG','EPSG','1996-12-12','',0),
(1392,'United States (USA) - Minnesota','United States (USA) - Minnesota.',43.5,49.39,-97.24,-89.47,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1393,'United States (USA) - Mississippi','United States (USA) - Mississippi.',30.13,35.0,-91.24,-88.1,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1394,'United States (USA) - Missouri','United States (USA) - Missouri.',36.0,40.61,-95.78,-89.1,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1395,'United States (USA) - Montana','United States (USA) - Montana - counties of Beaverhead; Big Horn; Blaine; Broadwater; Carbon; Carter; Cascade; Chouteau; Custer; Daniels; Dawson; Deer Lodge; Fallon; Fergus; Flathead; Gallatin; Garfield; Glacier; Golden Valley; Granite; Hill; Jefferson; Judith Basin; Lake; Lewis and Clark; Liberty; Lincoln; Madison; McCone; Meagher; Mineral; Missoula; Musselshell; Park; Petroleum; Phillips; Pondera; Powder River; Powell; Prairie; Ravalli; Richland; Roosevelt; Rosebud; Sanders; Sheridan; Silver Bow; Stillwater; Sweet Grass; Teton; Toole; Treasure; Valley; Wheatland; Wibaux; Yellowstone.',44.36,49.0,-116.04,-104.02,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1396,'United States (USA) - Nebraska','United States (USA) - Nebraska - counties of Adams; Antelope; Arthur; Banner; Blaine; Boone; Box Butte; Boyd; Brown; Buffalo; Burt; Butler; Cass; Cedar; Chase; Cherry; Cheyenne; Clay; Colfax; Cuming; Custer; Dakota; Dawes; Dawson; Deuel; Dixon; Dodge; Douglas; Dundy; Fillmore; Franklin; Frontier; Furnas; Gage; Garden; Garfield; Gosper; Grant; Greeley; Hall; Hamilton; Harlan; Hayes; Hitchcock; Holt; Hooker; Howard; Jefferson; Johnson; Kearney; Keith; Keya Paha; Kimball; Knox; Lancaster; Lincoln; Logan; Loup; Madison; McPherson; Merrick; Morrill; Nance; Nemaha; Nuckolls; Otoe; Pawnee; Perkins; Phelps; Pierce; Platte; Polk; Red Willow; Richardson; Rock; Saline; Sarpy; Saunders; Scotts Bluff; Seward; Sheridan; Sherman; Sioux; Stanton; Thayer; Thomas; Thurston; Valley; Washington; Wayne; Webster; Wheeler; York.',40.0,43.0,-104.06,-95.32,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1397,'United States (USA) - Nevada','United States (USA) - Nevada.',35.0,42.0,-120.0,-114.05,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1398,'United States (USA) - New Hampshire','United States (USA) - New Hampshire - counties of Belknap; Carroll; Cheshire; Coos; Grafton; Hillsborough; Merrimack; Rockingham; Strafford; Sullivan.',42.7,45.31,-72.56,-70.65,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1399,'United States (USA) - New Jersey','United States (USA) - New Jersey - counties of Atlantic; Bergen; Burlington; Camden; Cape May; Cumberland; Essex; Gloucester; Hudson; Hunterdon; Mercer; Middlesex; Monmouth; Morris; Ocean; Passaic; Salem; Somerset; Sussex; Union; Warren.',38.65,41.36,-75.56,-73.88,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1400,'United States (USA) - New Mexico','United States (USA) - New Mexico.',31.33,37.0,-109.05,-103.0,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1401,'United States (USA) - New York','United States (USA) - New York.',40.47,45.03,-79.76,-71.75,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1402,'United States (USA) - North Carolina','United States (USA) - North Carolina - counties of Alamance; Alexander; Alleghany; Anson; Ashe; Avery; Beaufort; Bertie; Bladen; Brunswick; Buncombe; Burke; Cabarrus; Caldwell; Camden; Carteret; Caswell; Catawba; Chatham; Cherokee; Chowan; Clay; Cleveland; Columbus; Craven; Cumberland; Currituck; Dare; Davidson; Davie; Duplin; Durham; Edgecombe; Forsyth; Franklin; Gaston; Gates; Graham; Granville; Greene; Guilford; Halifax; Harnett; Haywood; Henderson; Hertford; Hoke; Hyde; Iredell; Jackson; Johnston; Jones; Lee; Lenoir; Lincoln; Macon; Madison; Martin; McDowell; Mecklenburg; Mitchell; Montgomery; Moore; Nash; New Hanover; Northampton; Onslow; Orange; Pamlico; Pasquotank; Pender; Perquimans; Person; Pitt; Polk; Randolph; Richmond; Robeson; Rockingham; Rowan; Rutherford; Sampson; Scotland; Stanly; Stokes; Surry; Swain; Transylvania; Tyrrell; Union; Vance; Wake; Warren; Washington; Watauga; Wayne; Wilkes; Wilson; Yadkin; Yancey.',33.8,36.58,-84.32,-75.43,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1403,'United States (USA) - North Dakota','United States (USA) - North Dakota.',45.93,49.0,-104.05,-96.57,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1404,'United States (USA) - Ohio','United States (USA) - Ohio.',38.4,42.32,-84.81,-80.52,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1405,'United States (USA) - Oklahoma','United States (USA) - Oklahoma.',33.61,37.01,-103.0,-94.43,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1406,'United States (USA) - Oregon','United States (USA) - Oregon.',42.0,46.29,-124.6,-116.46,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1407,'United States (USA) - Pennsylvania','United States (USA) - Pennsylvania.',39.71,42.51,-80.52,-74.69,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1408,'United States (USA) - Rhode Island','United States (USA) - Rhode Island - counties of Bristol; Kent; Newport; Providence; Washington.',41.12,42.02,-71.9,-71.1,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1409,'United States (USA) - South Carolina','United States (USA) - South Carolina - counties of Abbeville; Aiken; Allendale; Anderson; Bamberg; Barnwell; Beaufort; Berkeley; Calhoun; Charleston; Cherokee; Chester; Chesterfield; Clarendon; Colleton; Darlington; Dillon; Dorchester; Edgefield; Fairfield; Florence; Georgetown; Greenville; Greenwood; Hampton; Horry; Jasper; Kershaw; Lancaster; Laurens; Lee; Lexington; Marion; Marlboro; McCormick; Newberry; Oconee; Orangeburg; Pickens; Richland; Saluda; Spartanburg; Sumter; Union; Williamsburg; York.',32.0,35.21,-83.36,-78.5,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1410,'United States (USA) - South Dakota','United States (USA) - South Dakota.',42.49,45.94,-104.07,-96.46,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1411,'United States (USA) - Tennessee','United States (USA) - Tennessee - counties of Anderson; Bedford; Benton; Bledsoe; Blount; Bradley; Campbell; Cannon; Carroll; Carter; Cheatham; Chester; Claiborne; Clay; Cocke; Coffee; Crockett; Cumberland; Davidson; De Kalb; Decatur; Dickson; Dyer; Fayette; Fentress; Franklin; Gibson; Giles; Grainger; Greene; Grundy; Hamblen; Hamilton; Hancock; Hardeman; Hardin; Hawkins; Haywood; Henderson; Henry; Hickman; Houston; Humphreys; Jackson; Jefferson; Johnson; Knox; Lake; Lauderdale; Lawrence; Lewis; Lincoln; Loudon; Macon; Madison; Marion; Marshall; Maury; McMinn; McNairy; Meigs; Monroe; Montgomery; Moore; Morgan; Obion; Overton; Perry; Pickett; Polk; Putnam; Rhea; Roane; Robertson; Rutherford; Scott; Sequatchie; Sevier; Shelby; Smith; Stewart; Sullivan; Sumner; Tipton; Trousdale; Unicoi; Union; Van Buren; Warren; Washington; Wayne; Weakley; White; Williamson; Wilson.',35.0,36.68,-90.32,-81.66,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1412,'United States (USA) - Texas','United States (USA) - Texas.',25.83,36.5,-106.63,-93.51,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1413,'United States (USA) - Utah','United States (USA) - Utah.',37.0,42.0,-114.05,-109.05,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1414,'United States (USA) - Vermont','United States (USA) - Vermont - counties of Addison; Bennington; Caledonia; Chittenden; Essex; Franklin; Grand Isle; Lamoille; Orange; Orleans; Rutland; Washington; Windham; Windsor.',42.7,45.0,-73.44,-71.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1415,'United States (USA) - Virginia','United States (USA) - Virginia.',36.53,39.45,-83.68,-75.17,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1416,'United States (USA) - Washington','United States (USA) - Washington.',45.55,49.0,-124.75,-116.9,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1417,'United States (USA) - West Virginia','United States (USA) - West Virginia.',37.2,40.63,-82.65,-77.73,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1418,'United States (USA) - Wisconsin','United States (USA) - Wisconsin.',42.49,47.29,-92.88,-86.25,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1419,'United States (USA) - Wyoming','United States (USA) - Wyoming.',41.0,45.0,-111.05,-104.05,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(1420,'Canada - Quebec - E of 57 deg W','Canada - Quebec - east of 57 deg West.',46.6,53.76,-57.0,-54.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1421,'Canada - Quebec - 60 to 57 deg W.','Canada - Quebec between 60 and 57 deg West.',50.1,52.0,-60.0,-57.1,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1422,'Canada - Quebec - 63 to 60 deg W','Canada - Quebec between 63 and 60 deg West.',47.13,52.0,-63.0,-60.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1423,'Canada - Quebec - 66 to 63 deg W','Canada - Quebec between 66 and 63 deg West.',47.88,60.52,-66.0,-63.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1424,'Canada - Quebec - 69 to 66 deg W','Canada - Quebec between 69 and  66 deg West.',47.1,59.1,-69.0,-66.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1425,'Canada - Quebec - 72 to 69 deg W','Canada - Quebec between 72 and 69 deg West.',44.99,61.9,-72.0,-69.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1426,'Canada - Quebec - 75 to 72 deg W','Canada - Quebec between 75 and 72 deg West.',44.99,62.56,-75.0,-72.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1427,'Canada - Quebec - 78 to 75 deg W','Canada - Quebec between 78 and 75 deg West.',45.28,62.56,-78.0,-75.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1428,'Canada - Quebec - W of 78 deg W','Canada - Quebec west of 78 deg West.',46.13,62.5,-79.76,-78.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1429,'Canada - Ontario - E of 75 deg W','Canada - Ontario - east of 75 deg West.',44.8,45.8,-75.0,-74.32,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1430,'Canada - Ontario - 78 to 75 deg W','Canada - Ontario - between 78 and 75 deg West.',43.6,46.4,-78.0,-75.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1431,'Canada - Ontario - MTM zone 10','Canada - Ontario - between 81 deg and 78 deg West: south of 46 deg North in area to west of 80 deg 15 min West, south of 47 deg North in area between 80 deg 15 min and 79 deg 30 min West, entire province between 79 deg 30 min and 78 deg West.',42.4,46.0,-79.5,-78.0,'','','',NULL,'','EPSG','EPSG','2004-10-01','2004.54',0),
(1432,'Canada - Ontario - MTM zone 11','Canada - Ontario - south of 46 deg North and west of 81 deg West.',41.68,46.0,-83.59,-81.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1433,'Canada - Ontario - MTM zone 12','Canada - Ontario - between 82 deg 30 min and 79 deg 30 min West: north of 46 deg North in area between 82 deg 30 min and 80 deg 15 min West, north of 47 deg North in area between 80 deg 15 min and 79 deg 30 min West.',46.0,55.3,-82.5,-79.5,'','','',NULL,'','EPSG','EPSG','2004-10-01','2004.54',0),
(1434,'Canada - Ontario - MTM zone 13','Canada - Ontario - between 85 deg 30 min and 82 deg 30 min West and north of 46 deg North.',46.0,55.53,-85.5,-82.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1435,'Canada - Ontario - 88.5 to 85.5 deg W','Canada - Ontario - between 88 deg 30 min and 85 deg 30 min West.',47.2,56.7,-88.5,-85.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1436,'Canada - Ontario - 91.5 to 88.5 deg W','Canada - Ontario - between 91 deg 30 min and 88 deg 30 min West.',47.8,56.86,-91.5,-88.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1437,'Canada - Ontario - 94.5 to 91.5 deg W','Canada - Ontario - between 94 deg 30 min and 91 deg 30 min West.',48.0,55.3,-94.5,-91.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1438,'Canada - Ontario - W of 94.5 deg W','Canada - Ontario - west of 94 deg 30 min West.',48.5,55.3,-95.15,-94.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1439,'Canada - Ontario - 96 to 90 deg W','Canada - Ontario - between 96 and 90 deg West.',48.0,56.3,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1440,'Canada - Ontario - 90 to 84 deg W','Canada - Ontario - between 90 and 84 deg West.',46.0,56.86,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1441,'Canada - Ontario - 84 to 78 deg W','Canada - Ontario - between 84 and 78 deg West.',41.68,55.4,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1442,'Canada - Ontario - E of 78 deg W','Canada - Ontario - east of 78 deg West.',43.6,46.4,-78.0,-74.32,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1443,'Canada - Quebec - 78 to 72 deg W','Canada - Quebec - between 78 and 72 deg West.',44.99,62.56,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1444,'Canada - Quebec - 72 to 66 deg W','Canada - Quebec - between 72 and 66 deg West.',44.99,61.9,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1445,'Canada - Quebec - 66 to 60 deg W','Canada - Quebec - between 66 and 60 deg West.',47.13,60.52,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1446,'Canada - Quebec - E of 60 deg W','Canada - Quebec - east of 60 deg West.',50.1,52.0,-60.0,-57.1,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1447,'Canada - New Brunswick','Canada - New Brunswick (NB).',44.61,48.07,-69.05,-63.78,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1448,'Canada - 72 to 66 deg W, S of 62 deg N','Canada south of 60 deg North and between 72 and 66 deg West - New Brunswick (NB), Labrador, Nova Scotia (NS), Quebec.',44.6,61.5,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.462',0),
(1449,'Canada - 66 to 60 deg W, S of 60 deg N','Canada south of 60 deg North and between 66 and 60 deg West - New Brunswick (NB), Labrador, Nova Scotia (NS), Prince Edward Island (PEI), Quebec.',43.2,60.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2002.41 2006.462',0),
(1450,'Cote d''Ivoire (Ivory Coast) - E of 6 deg W','C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast) east of 6 deg West.',3.9,10.47,-6.0,-2.49,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1451,'Cote d''Ivoire (Ivory Coast) - W of 6 deg W','C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast) west of 6 deg West.',3.9,10.74,-8.61,-6.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1452,'Vietnam - W of 108 deg E','Vietnam - west of 108 deg East.',6.0,23.39,102.2,108.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1453,'Vietnam - E of 108 deg E','Vietnam - east of 108 deg East.',7.0,21.55,108.0,113.32,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1454,'Namibia - Walvis Bay','Namibia - Walvis Bay.',-23.1,-22.8,14.4,14.6,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.89',0),
(1455,'South Africa - W of 18 deg E','South Africa - west of 18 deg East.',-31.4,-28.04,16.4,18.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1456,'South Africa - 18 to 20 deg E','South Africa - between 18 and 20 deg East.',-34.85,-28.45,18.0,20.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1457,'South Africa - 20 to 22 deg E','South Africa - between 20 and 22 deg East.',-34.85,-24.7,20.0,22.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1458,'South Africa - 22 to 24 deg E','South Africa - between 22 and 24 deg East.',-34.25,-25.2,22.0,24.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1459,'South Africa - 24 to 26 deg E','Lesotho  - west of 26 deg East. South Africa - between 24 and 26 deg East.',-34.25,-24.7,24.0,26.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1460,'South Africa - 26 to 28 deg E','Lesotho  - east of 26 deg East.  South Africa - between 26 and 28 deg East.',-33.8,-22.9,26.0,28.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1461,'South Africa - 28 to 30 deg E','South Africa - between 28 and 30 deg East.',-33.0,-22.1,28.0,30.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1462,'South Africa - 30 to 32 deg E','South Africa - between 30 and 32 deg East.  Swaziland.',-31.3,-22.2,30.0,32.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1463,'South Africa - E of 32 deg E','South Africa - east of 32 deg East.',-28.9,-26.8,32.0,32.9,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1464,'Iran - W of 48 deg E','Iran - west of 48 deg East.',30.95,39.8,44.06,48.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1465,'Iran - 48 to 54 deg E','Iran - between 48 and 54 deg East.',25.8,39.7,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1466,'Iran - 54 to 60 deg E','Iran - between 54 and 60 deg East.',25.3,38.25,54.0,60.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1467,'Iran - E of 60 deg E','Iran - east of 60 deg East.',25.0,36.9,60.0,63.37,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1468,'Guinea - W of 12 deg W','Guinea - west of 12 deg West.',6.38,12.69,-17.07,-12.0,'','','',NULL,'','EPSG','EPSG','1999-12-09','',0),
(1469,'Guinea - E of 12 deg W','Guinea - east of 12 deg West.',6.38,12.69,-12.0,-7.65,'','','',NULL,'','EPSG','EPSG','1999-12-09','',0),
(1470,'Libya - W of 10 degrees E','Libya - west of 10 deg East.',25.33,30.45,9.31,10.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1471,'Libya - 10 to 12 degrees E','Libya - between 10 and 12 deg East.',23.5,33.18,10.0,12.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1472,'Libya - 12 to 14 degrees E','Libya - between 12 and 14 deg East.',22.8,33.0,12.0,14.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1473,'Libya - 14 to 16 degrees E','Libya - between 14 and 16 deg East.',22.6,32.67,14.0,16.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1474,'Libya - 16 to 18 degrees E','Libya - between 16 and 18 deg East.',22.5,31.3,16.0,18.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1475,'Libya - 18 to 20 degrees E','Libya - between 18 and 20 deg East.',21.5,32.05,18.0,20.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1476,'Libya - 20 to 22 degrees E','Libya - between 20 and 22 deg East.',20.5,33.0,20.0,22.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1477,'Libya - 22 to 24 degrees E','Libya - between 22 and 24 deg East.',19.51,33.0,22.0,24.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1478,'Libya - E of 24 degrees E','Libya - east of 24 deg East.',19.51,32.05,24.0,25.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1479,'Libya - W of 12 degrees E','Libya - west of 12 deg East.',23.5,33.18,9.31,12.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1480,'Libya - 12 to 18 degrees E','Libya - between 12 and 18 deg East.',22.6,33.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1481,'Libya - 18 to 24 degrees E','Libya - between 18 and 24 deg East.',19.51,33.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1482,'Libya - W of 15 degrees E','Libya - west of 15 deg East.',22.5,33.18,9.31,15.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1483,'Argentina - Neuquen province - 70.5 to 67.5 deg W','Argentina - Neuquen province between 70 deg 30 min and 67 deg 30 min West.',-40.5,-36.14,-70.5,-67.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1484,'Argentina - Comodoro Rivadavia - W of 67.5 deg W','Argentina - Comodoro Rivadavia area west of 67 deg 30 min West.',-66.7,-45.2,-69.5,-67.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1485,'Argentina - Tierra del Fuego - onshore W of 67.5 deg W','Argentina - Tierra del Fuego onshore west of 67 deg 30 min West.',-54.95,-52.65,-68.64,-67.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1486,'Argentina - Tierra del Fuego - offshore','Argentina - Tierra del Fuego offshore.',-55.0,-52.64,-68.64,-61.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1487,'Cuba - N of 21.5 deg N','Cuba - north of 21deg 30min North.',21.5,23.2,-84.95,-77.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1488,'Cuba - S of 21.5 deg N','Cuba - south of 21deg 30min North.',19.08,21.5,-83.2,-73.61,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1489,'Tunisia - offshore','Tunisia - offshore.',33.13,38.43,8.62,13.74,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1490,'Yemen - W of 48 deg E','Yemen - west of 48 deg East.',12.57,17.98,41.44,48.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1491,'Yemen - E of 48 deg E','Yemen - east of 48 deg East.',11.61,19.01,48.0,55.03,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1492,'Yemen - South Yemen - W of 48 deg E','Yemen - South Yemen west of 48 deg East.',12.0,15.0,42.5,48.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1493,'Yemen - South Yemen - E of 48 deg E','Yemen - South Yemen east of 48 deg East.',13.5,15.0,48.0,53.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1494,'Vietnam - Meekong delta','Vietnam - Meekong delta.',8.54,12.33,104.5,107.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1495,'Vietnam - offshore Nam Con Son basin','Vietnam - offshore Nam Con Son basin.',7.33,10.75,107.0,109.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1496,'Korea, Republic of (South Korea) - E of 128 deg E','Republic of Korea (South Korea) - east of 128 deg East.',34.6,38.64,128.0,129.6,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1497,'Korea, Republic of (South Korea) - 126 to 128 deg E','Republic of Korea (South Korea) - between 126 and 128 deg East.',33.9,38.33,126.0,128.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1498,'Korea, Republic of (South Korea) - W of 126 deg E','Republic of Korea (South Korea) - west of 126 deg East.',34.2,37.7,125.1,126.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1499,'Venezuela - Maracaibo - blocks I II and III.','Venezuela - Maracaibo area offshore blocks I, II and III.',10.0,10.6,-71.5,-71.0,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(1500,'New Zealand - North Island','New Zealand - North Island.',-41.6,-34.0,172.0,178.6,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1501,'New Zealand - South Island','New Zealand - South Island.',-46.8,-40.4,166.33,174.5,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1502,'New Zealand - offshore W of 168 deg E','New Zealand - offshore west of 168 deg East.',-50.0,-43.0,166.0,168.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1503,'New Zealand - offshore 168 to 174 deg E','New Zealand - offshore between 168 and 174 deg East.',-50.0,-33.0,168.0,174.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1504,'New Zealand - offshore E of 174 deg E','New Zealand - offshore east of 174 deg East.',-43.0,-33.0,174.0,179.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1505,'Ghana - offshore','Ghana - offshore.',1.08,6.1,-3.9,1.34,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1506,'Canada - 108 to 102 deg W, S of 60 deg N','Canada south of 60 deg North and between 108 and 102 deg West - Saskatchewan.',49.0,60.0,-108.0,-102.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.462',0),
(1507,'Canada - 114 to 108 deg W, S of 60 deg N','Canada south of 60 deg North and between 114 and 108 deg West - Alberta, Saskatchewan.',49.0,60.0,-114.0,-108.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2004.462',0),
(1508,'Canada - 120 to 114 deg W, S of 60 deg N','Canada south of 60 deg North and between 120 and 114 deg West - Alberta, British Columbia (BC).',49.0,60.0,-120.0,-114.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2004.462',0),
(1509,'Sierra Leone - W of 12 deg W','Sierra Leone - west of 12 deg West.',7.2,9.95,-13.33,-12.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1510,'Sierra Leone - E of 12 deg W','Sierra Leone - east of 12 deg West.',6.9,10.0,-12.0,-10.27,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1511,'United States (USA) - conus and Alaska','United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',24.53,71.35,172.4,-67.07,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2001-06-05','',0),
(1512,'Germany - East Germany - W of 10.5 deg E','Germany - states of former East Germany - west of 10 deg 30 min East - Thuringen.',50.35,51.58,9.87,10.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1513,'Germany - East Germany - 10.5 to 13.5 deg E','Germany - states of former East Germany - between 10 deg 30 min and 13 deg 30 min East - Brandenburg; Mecklenburg-Vorpommern; Sachsen; Sachsen-Anhalt; Thuringen.',50.17,54.72,10.5,13.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1514,'Germany - East Germany - E of 13.5 deg E','Germany - states of former East Germany - east of 13 deg 30 min East - Brandenburg; Mecklenburg-Vorpommern; Sachsen.',50.67,54.6,13.5,15.03,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1515,'Poland - zone I','Poland - southeast - south of 52 deg 20 min North and east of 18 deg East.',49.03,52.33,18.0,24.16,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1516,'Poland - zone II','Poland - northeast - north of 51 deg 20 min North and east of 19 deg East.',51.33,54.6,10.0,23.9,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1517,'Poland - zone III','Poland - northwest - north of 52 deg 10 min North and west of 20 deg East.',52.17,54.83,14.14,20.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1518,'Poland - zone IV','Poland - southwest - south of  53 deg 20 min North and west of 19 deg 05 min East.',49.33,53.33,14.14,19.08,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1519,'Poland - zone V','Poland - south central - between 49 deg 20 min North and 51 deg 20 min North, 18 deg 20 min East and 19 deg 40min East.',49.33,51.33,18.33,19.67,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1520,'Poland - W of 16.5 deg E','Poland - west of 16 deg 30 min East.',50.25,54.5,14.14,16.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1521,'Poland - 16.5 to 19.5 deg E','Poland - between 16 deg 30 min and 19 deg 30 min East.',49.33,54.83,16.5,19.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1522,'Poland - 19.5 to 22.5 deg E','Poland - between 19 deg 30 min and 22 deg 30 min East.',49.09,54.5,19.5,22.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1523,'Poland - E of 22.5 deg E','Poland - east of 22 deg 30 min East.',49.03,54.45,22.5,24.16,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1524,'Turkey - W of 28.5 deg E','Turkey west of 28 deg 30 min East.',36.5,42.1,25.59,28.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1525,'Turkey - 28.5 to 31.5 deg E','Turkey between 28 deg 30 min and 31 deg 30 min East.',36.05,42.1,28.5,31.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1526,'Turkey - 31.5 to 34.5 deg E','Turkey between 31 deg 30 min and 34 deg 30 min East.',35.9,42.1,31.5,34.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1527,'Turkey - 34.5 to 37.5 deg E','Turkey between 34 deg 30 min and 37 deg 30 min East.',35.7,42.1,34.5,37.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1528,'Turkey - 37.5 to 40.5 deg E','Turkey between 37 deg 30 min and 40 deg 30 min East.',36.6,41.15,37.5,40.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1529,'Turkey - 40.5 to 43.5 deg E','Turkey between 40 deg 30 min and 43 deg 30 min East.',37.0,41.6,40.5,43.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1530,'Turkey - E of 43.5 deg E','Turkey east of 43 deg 30 min East.',36.9,41.5,43.5,44.85,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1531,'Canada - Maritime Provinces - W of 66 deg W','Canada - New Brunswick (NB) and Nova Scotia (NS) - west of 66 deg West.',44.61,48.07,-69.05,-66.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(1532,'Canada - Maritime Provinces - E of 66 deg W','Canada - New Brunswick (NB) and Nova Scotia east of 66 deg West; Prince Edward Island (PEI).',43.46,48.07,-66.0,-59.81,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(1533,'Canada - Prince Edward Island','Canada - Prince Edward Island (PEI).',45.95,47.04,-64.42,-61.97,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1534,'Canada - Nova Scotia - E of 63 deg W','Canada - Nova Scotia - east of 63 deg West.',46.6,47.03,-63.0,-59.81,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1535,'Canada - Nova Scotia - W of 63 deg W','Canada - Nova Scotia - west of 63 deg West.',43.46,45.8,-66.2,-63.0,'','','',NULL,'','EPSG','EPSG','1999-05-24','',0),
(1536,'Finland - 19.5 to 22.5 deg E','Finland - between 19 deg 30 min and 22 deg 30 min East.',59.8,69.3,19.5,22.5,'','','',NULL,'','EPSG','EPSG','2006-03-31','2006.27',0),
(1537,'Finland - 22.5 deg to 25.5 deg E','Finland - between 22 deg 30 min and 25 deg 30 min East.',59.75,69.9,22.5,25.5,'','','',NULL,'','EPSG','EPSG','1997-07-22','',0),
(1538,'Finland - 25.5 to 28.5 deg E. Also all country.','Finland - between 25 deg 30 min and 28 deg 30 min East for Basic Coordinate System and all Finland for Uniform Coordinate System.',59.3,70.13,19.09,31.59,'','','',NULL,'','EPSG','EPSG','2001-09-03','',0),
(1539,'Finland - 28.5 to 31.5 deg E','Finland - between 28 deg 30 min and 31 deg 30 min East.',60.95,69.9,28.5,31.5,'','','',NULL,'','EPSG','EPSG','2006-03-31','2006.27',0),
(1540,'Mozambique - W of 36 deg E','Mozambique - west of 36 deg East.',-26.88,-11.4,30.23,36.0,'','','',NULL,'','EPSG','EPSG','1998-04-16','',0),
(1541,'Mozambique - E of 36 deg E','Mozambique - east of 36 deg East.',-19.0,-9.56,36.0,42.0,'','','',NULL,'','EPSG','EPSG','1998-04-16','',0),
(1542,'Asia - Cambodia and Vietnam - W of 108 deg E','Cambodia; Vietnam west of 108 deg East.',8.56,23.32,102.14,108.0,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1544,'Oman - W of 54 deg E','Oman - west of 54 deg East.',16.6,19.7,51.9,54.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1545,'Oman - E of 54 deg E','Oman - east of 54 deg East.',16.8,26.4,54.0,59.9,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1546,'United States (USA) - Hawaii - island of Hawaii','United States (USA) - Hawaii - island of Hawaii.',18.9,20.27,-156.06,-154.8,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1547,'United States (USA) - Hawaii - Maui; Kahoolawe; Lanai; Molokai.','United States (USA) - Hawaii - Maui; Kahoolawe; Lanai; Molokai.',20.49,21.22,-157.31,-155.97,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1548,'United States (USA) - Hawaii - Oahu.','United States (USA) - Hawaii - Oahu.',21.25,21.72,-158.29,-157.64,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1549,'United States (USA) - Hawaii - Kauai.','United States (USA) - Hawaii - Kauai.',21.87,22.24,-159.79,-159.29,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1550,'United States (USA) - Hawaii - Niihau.','United States (USA) - Hawaii - Niihau.',21.77,22.03,-160.25,-160.04,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1551,'Grenada and southern Grenadines - onshore','Grenada and southern Grenadine Islands - onshore.',11.95,12.53,-61.8,-61.35,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.89',0),
(1552,'Africa - Eritrea, Ethiopia and Sudan - 36 to 42 deg E','Eritrea. Ethiopia - between 36 and 42 degrees East.  Sudan - east of 36 degrees East.',3.41,22.23,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2003-01-16','2002.81',0),
(1553,'Ethiopia - E of 42 deg E','Ethiopia - east of 42 degrees East.',4.1,12.9,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2003-01-16','2002.81',0),
(1554,'Somalia - W of 48 deg E','Somalia - west of 48 degrees East.',1.6,11.5,41.01,48.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1555,'Somalia - E of 48 deg E','Somalia - east of 48 degrees East.',4.5,11.95,48.0,51.4,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1556,'Australia - 102 to 108 deg E','Australia - between 102 and 108 deg East.',-56.0,-10.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1557,'Australia - 108 to 114 deg E','Australia - between 108 and 114 deg East.',-27.5,-21.7,108.0,114.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1558,'Australia - 114 to 120 deg E','Australia - between 114 and 120 deg East.',-35.2,-19.6,114.0,120.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1559,'Australia - 120 to 126 deg E','Australia - between 120 and 126 deg East.',-34.2,-13.6,120.0,126.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1560,'Australia - 126 to 132 deg E','Australia - between 126 and 132 deg East.',-32.5,-10.7,126.0,132.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1561,'Australia - 132 to 138 deg E','Australia - between 132 and 138 deg East.',-36.1,-10.7,132.0,138.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1562,'Australia - 138 to 144 deg E','Australia - between 138 and 144 deg East.',-40.3,-10.1,138.0,144.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1563,'Australia - 144 to 150 deg E','Australia - between 144 and 150 deg East.',-44.1,-13.7,144.0,150.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1564,'Australia - 150 to 156 deg E','Australia - between 150 and 156 deg East.',-37.8,-21.7,150.0,156.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1565,'Australia - 156 to 162 deg E','Australia - between 156 and 162 deg East.',-54.8,-54.7,156.0,162.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1566,'Australia - 162 to 168 deg E','Australia - between 162 and 168 deg East.',-56.0,-10.0,162.0,168.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1567,'Australasia - Australia and PNG - 138 to 144 deg E','Australia - between 138 and 144 deg East.  Papua New Guinea (PNG) - west of 144 deg East.',-40.14,-2.35,138.0,144.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1568,'Australasia - Australia and PNG - 144 to 150 deg E','Australia - between 144 and 150 deg East.  Papua New Guinea (PNG) - east of 144 deg East.',-54.75,-1.71,144.0,150.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1569,'Saudi Arabia - 36 to 42 deg E','Saudi Arabia - between 36 and 42 deg East.',16.1,32.26,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-05-12','2005.11',0),
(1570,'Asia - Middle East - Kuwait and Saudi - 48 to 54 deg E','Kuwait - east of 48 deg East. Saudi Arabia - between of 48 and 54 deg East.',17.95,30.04,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2005-05-12','2005.11',0),
(1571,'Asia - Middle East - Kuwait and Saudi - 42 to 48 deg E','Kuwait - west of 48 deg East. Saudi Arabia - between of 42 and 48 deg East.',16.38,31.22,42.0,48.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1572,'Brazil - Aratu - W of 48 deg W','Brazil - coastal and offshore areas south of 2 deg 55 min South and west of 48 deg West - Pelotas basin.',-34.0,-26.0,-53.0,-48.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1573,'Brazil - Aratu - 48 to 42 deg W','Brazil - coastal and offshore areas south of 2 deg 55 min South and between 48 and 42 deg West - Santos basin.',-27.83,-23.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1574,'Brazil - Aratu - 42 to 36 deg W','Brazil - coastal and offshore areas south of 2 deg 55 min South and between 42 and 36 deg West; - Campos; Espirito Santo and Santos basins.',-27.83,-18.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1575,'Africa - Botswana and Zambia - W of 24 deg E','Botswana and Zambia - west of 24 deg East.',-26.88,-8.19,20.0,24.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1576,'Africa - Botswana, Zambia and Zimbabwe - 24 to 30 deg E','Botswana - east of 24 deg East; Zambia - between 24 and 30 deg East; Zimbabwe west of 30 deg East .',-26.88,-8.19,24.0,30.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1577,'Africa - Malawi, Zambia and Zimbabwe - E of 30 deg E','Malawi.  Zambia and Zimbabwe - east of 30 deg East.',-22.41,-8.19,30.0,35.92,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1578,'Uganda - N of equator and W of 30 deg E','Uganda - north of equator and west of 30 deg East.',0.0,4.23,29.58,30.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1579,'Africa - Tanzania and Uganda - S of equator and W of 30 deg E','Tanzania - west of 30 deg East; Uganda south of equator and west of 30 deg East.',-6.91,0.0,29.34,30.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1580,'Africa - Kenya and Uganda - N of equator and 30 to 36 deg E','Kenya - north of equator and west of 36 deg East; Uganda north of equator and east of 30 deg East.',0.0,4.62,30.0,36.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1581,'Africa - Kenya, Tanzania and Uganda - S of equator and 30 to 36 deg E','Kenya - south of equator and west of 36 deg East; Tanzania - 30 to 36 deg East; Uganda south of equator and east of 30 deg East.',-11.74,0.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1582,'Kenya - N of equator and E of 36 deg E','Kenya - north of equator and east of 36 deg East.',0.0,4.45,36.0,41.87,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1583,'Africa - Kenya and Tanzania - S of equator and E of 36 deg E','Kenya - south of equator and east of 36 deg East; Tanzania - east of 36 deg East.',-11.74,0.0,36.0,41.91,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1584,'Indonesia - Java - W of 108 deg E','Indonesia - Java - west of 108 deg East.',-7.75,-5.9,105.1,108.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1585,'Indonesia - Java - E of 114 deg E','Indonesia - Java - east of 114 deg East.',-8.85,-6.9,114.0,114.6,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1586,'Indonesia - Java - 108 to 114 deg E','Indonesia - Java - between 108 and 114 deg East.',-8.67,-6.25,108.0,114.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1587,'China - W of 78 deg E','China - west of 78 deg East.',35.44,41.07,73.62,78.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1588,'China - 78 to 84 deg E','China - between 78 and 84 deg East.',29.16,47.22,78.0,84.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1589,'China - 84 to 90 deg E','China - between 84 and 90 deg East.',27.32,49.17,84.0,90.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1590,'China - 90 to 96 deg E','China - between 90 and 96 deg East.',27.73,47.89,90.0,96.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1591,'China - 96 to 102 deg E','China - between 96 and 102 deg East.',21.14,43.17,96.0,102.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1592,'China - 102 to 108 deg E','China - between 102 and 108 deg East.',21.54,42.47,102.0,108.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1593,'China - 108 to 114 deg E','China - between 108 and 114 deg East.',18.17,45.1,108.0,114.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1594,'China - 114 to 120 deg E','China - between 114 and 120 deg East.',22.19,51.52,114.0,120.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1595,'China - 120 to 126 deg E','China - between 120 and 126 deg East.',21.93,53.55,120.0,126.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1596,'China - 126 to 132 deg E','China - between 126 and 132 deg East.',40.89,52.78,126.0,132.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1597,'China - E of 132 deg E','China - east of 132 deg East.',45.02,48.39,132.0,134.77,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1598,'Colombia - W of 75d 35m W','Colombia - west of 1 deg 30 min W of Bogota (75d 34m 51.30s W of Greenwich).',0.0,12.6,-85.79,-75.58,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(1599,'Colombia - 75d 35m to 72d 35m W','Colombia - between 1 deg 30 min W and 1 deg 30 min E of Bogota (75d 35m W and 72d 35m W of Greenwich).',-2.5,11.9,-75.58,-72.58,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(1600,'Colombia - 72d 35m to 69d 35m W','Colombia - between 1 deg 30 min and 4 deg 30 min E of Bogota (72d 35m and 69d 34m W of Greenwich).',-4.22,12.6,-72.58,-69.58,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(1601,'Colombia - E of 69d 35m W','Colombia - east of 4 deg 30 min E of Bogota (69d 34m 51.3s W of Greenwich).',1.15,6.35,-69.58,-66.91,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(1602,'Colombia - offshore W of 78 deg W','Colombia - offshore west of 78 deg W of Greenwich.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2000-10-19','',1),
(1603,'Colombia - offshore Caribbean W of 72 deg W','Colombia - offshore Caribbean west of 72 deg W of Greenwich.',7.87,13.5,-78.0,-71.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1604,'Angola - Angola proper - offshore','Angola - Angola proper - offshore.',-17.17,-6.03,10.0,13.86,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1605,'Angola - Angola proper - offshore block 15','Angola - Angola proper - offshore block 15.',-6.58,-6.03,10.83,11.67,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1606,'Angola - Angola proper - offshore - W of 12 deg E','Angola - Angola proper - offshore - west of 12 deg East.',-17.17,-6.03,10.0,12.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1607,'Angola - 12 to 18 deg E','Angola - between 12 and 18 deg East.',-17.47,-4.39,12.0,18.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(1608,'Argentina - W of 70.5 deg W','Argentina - west of 70 deg 30 min West.',-52.0,-36.15,-73.62,-70.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1609,'Argentina - 70.5 to 67.5 deg W','Argentina - between 70 deg 30 min and 67 deg 30 min West.',-54.95,-24.1,-70.5,-67.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1610,'Argentina - 67.5 to 64.5 deg W','Argentina - between 67 deg 30 min and 64 deg 30 min West.',-55.2,-21.8,-67.5,-64.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1611,'Argentina - 64.5 to 61.5 deg W','Argentina - between 64 deg 30 min and 61 deg 30 min West.',-55.0,-22.0,-64.5,-61.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1612,'Argentina - 61.5 to 58.5 deg W','Argentina - between 61 deg 30 min and 58 deg 30 min West.',-39.2,-23.4,-61.5,-58.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1613,'Argentina - 58.5 to 55.5 deg W','Argentina - between 58 deg 30 min and 55 deg 30 min West.',-38.5,-25.1,-58.5,-55.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1614,'Argentina - E of 55.5 deg W','Argentina - east of 55 deg 30 min West.',-27.9,-25.5,-55.5,-53.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1615,'Botswana - W of 21 deg E','Botswana - west of 21 deg East.',-26.88,-22.0,20.0,21.0,'','','',NULL,'','EPSG','EPSG','1995-12-08','',0),
(1616,'Botswana - 21 to 27 deg E','Botswana - between 21 and 27deg East.',-26.88,-17.78,21.0,27.0,'','','',NULL,'','EPSG','EPSG','1995-12-08','',0),
(1617,'Botswana - E of 27 deg E','Botswana - east of 27 deg East.',-23.7,-19.9,27.0,29.37,'','','',NULL,'','EPSG','EPSG','1995-12-08','',0),
(1618,'Tunisia - onshore','Tunisia - onshore.',30.25,37.35,7.5,11.63,'','','',NULL,'','EPSG','EPSG','1999-11-15','',0),
(1619,'Tunisia - N of 34 deg 39 min N','Tunisia - north of 38.5 grads (34 deg 39 min) North.',34.65,37.35,8.25,11.27,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1620,'Tunisia - S of 34 deg 39 min N','Tunisia - south of 38.5 grads (34 deg 39 min) North.',30.25,34.65,7.5,11.63,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1621,'Brazil - Corrego Alegre - W of 42 deg W','Brazil - NE coastal area between 45 deg West and 42 deg West.',-3.9,-1.5,-45.0,-42.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1622,'Brazil - Corrego Alegre - E of 42 deg W','Brazil - NE coastal area between 42 deg West and 40 deg West.',-4.0,-2.7,-42.0,-40.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',1),
(1623,'Asia - Middle East - Lebanon and Syria','Lebanon. Syrian Arab Republic.',32.31,37.29,35.1,42.38,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1624,'Germany - W of 7.5 deg E','Germany - west of 7 deg 30 min East - Niedersachsen, Nordrhein-Westfalen, Rheinland-Pfalz, Saarland.',49.1,53.75,5.87,7.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1625,'Germany - 7.5 to 10.5 deg E','Germany - former West Germany onshore between 7 deg 30 min and 10 deg 30 min East - Baden-Wurtemberg, Bayern, Hessen, Niedersachsen, Nordrhein-Westfalen, Rhineland-Pfalz, Schleswig-Holstein.',47.27,55.06,7.5,10.5,'','','',NULL,'','EPSG','EPSG','2006-06-12','2006.41',0),
(1626,'Germany - 10.5 to 13.5 deg E','Germany - former West Germany onshore between 10 deg 30 min and 13 deg 30 min East - Bayern, Niedersachsen, Schleswig-Holstein.',47.27,55.06,10.5,13.5,'','','',NULL,'','EPSG','EPSG','2006-06-12','2006.41',0),
(1627,'Germany - 13.5 to 16.5 deg E','Germany - former West Germany onshore east of 13 deg 30 min East - Bayern.',47.27,55.06,13.5,16.5,'','','',NULL,'','EPSG','EPSG','2006-06-12','2006.41',0),
(1628,'Germany - W of 4.5 deg E','Germany - onshore - west of 4 deg 30 min East.',NULL,NULL,NULL,NULL,'','','',NULL,'Not valid - do not use !','EPSG','EPSG','2000-03-07','',1),
(1629,'United Kingdom (UK) - offshore North Sea','United Kingdom (UK) - offshore - North Sea.',49.5,63.83,-4.0,3.4,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1630,'Netherlands - offshore','Netherlands - offshore North Sea.',51.5,55.8,2.5,6.4,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1631,'Europe - 18 to 12 deg W and ED50 by country','Europe - between 18 and 12 deg West - Ireland offshore; Spain (Canary Islands); United Kingdom (UKCS) offshore.',27.6,60.0,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1632,'Europe - 12 to 6 deg W and ED50 by country','Europe - between 12 and 6 deg West - Faroe Islands - onshore; Spain; Ireland offshore; United Kingdom (UKCS) offshore.',36.15,60.0,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.14 2005.471',0),
(1633,'Europe - 6 to 0 deg W and ED50 by country','Europe - between 6 deg West and 0 deg East - France offshore; Gibraltar; Ireland offshore; Spain; United Kingdom - UKCS offshore - North Sea west of 0 d eg East).',35.95,63.95,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2005-09-29','2005.14 2005.46',0),
(1634,'Europe - 0 to 6 deg E and ED50 by country','Europe - between 0 and 6 deg East - Denmark (North Sea); Germany offshore; Netherlands offshore; Norway; Spain (Balearic Islands); United Kingdom (UKCS) offshore.',38.6,67.0,0.0,6.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1635,'Europe - 6 to 12 deg E and ED50 by country','Europe - between 6 and 12 deg East - Denmark; Germany offshore; Italy; Netherlands offshore; Norway; Svalbard.',38.85,79.85,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2003.141 2005.14',0),
(1636,'Europe - 12 to 18 deg E and ED50 by country','Europe - between 12 and 18 deg East - Denmark (Bornholm); Italy including San Marino and Vatican City State; Norway; Svalbard.',35.5,80.05,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2006-02-01','2003.141 2005.14 2005.89',0),
(1637,'Europe - 18 to 24 deg E and ED50 by country','Europe - between 18 and 24 deg East - Greece - offshore; Norway; Svalbard.',34.75,80.05,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2003.141 2005.14',0),
(1638,'Europe - 24 to 30 deg E and ED50 by country','Europe - between 24 and 30 deg East - Greece - offshore; Norway; Svalbard; Turkey.  Egypt - Western Desert.',34.75,80.05,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2003.141 2005.14',0),
(1639,'Europe - 0 to 36 deg E and ED50 by country','Europe - between 30 and 36 deg East - Israel - offshore, Turkey.',31.0,43.3,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1640,'Europe - 36 to 42 deg E and ED50 by country','Europe - between 36 and 42 deg East - Turkey.',35.83,43.3,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1641,'Europe - 42 to 48 deg E and ED50 by country','Europe - between 42 and 48 deg East - Turkey.',37.0,41.65,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1642,'Egypt - Sinai peninsula','Egypt - Sinai peninsula.',27.7,31.31,32.5,36.9,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(1643,'Egypt - E of 29 deg E','Egypt - east of 29 deg East.',21.99,33.75,29.0,36.9,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1644,'Egypt - W of 29 deg E; N of 28 deg 11 min N','Egypt - west of 29 deg E; north of approximately 28 deg 11 min North.',28.18,33.58,24.71,29.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1645,'Egypt - W of 29 deg E; S of 28 deg 11 min N','Egypt - west of 29 deg E; south of approximately 28 deg 11 min North.',21.99,28.18,25.0,29.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1646,'Europe - Estonia;  Latvia;  Lithuania.','Estonia;  Latvia;  Lithuania.',53.92,59.67,20.9,28.3,'','','',NULL,'','EPSG','EPSG','1998-12-14','',0),
(1647,'Indonesia - W of 96 deg E, N hem','Indonesia - north of equator and west of 96 deg East.',0.0,5.6,91.66,96.0,'','','',NULL,'','EPSG','EPSG','1995-08-08','',0),
(1648,'Indonesia - W of 96 deg E, S hem','Indonesia - south of equator and west of 96 deg East.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','1995-08-08','',1),
(1649,'Indonesia - 96 to 102 deg E, N hem','Indonesia - north of equator and between 96 and 102 deg East.',0.0,5.4,96.0,102.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1650,'Indonesia - 96 to 102 deg E, S hem','Indonesia - south of equator and between 96 and 102 deg East.',-4.0,0.0,96.0,102.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1651,'Indonesia - 102 to 108 deg E, N hem','Indonesia - north of equator and between 102 and 108 deg East.',0.0,4.1,102.0,108.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1652,'Indonesia - 102 to 108 deg E, S hem','Indonesia - south of equator and between 102 and 108 deg East.',-7.9,0.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1653,'Indonesia - 108 to 114 deg E, N hem','Indonesia - north of equator and between 108 and 114 deg East.',0.0,4.2,108.0,114.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1654,'Indonesia - 108 to 114 deg E, S hem','Indonesia - south of equator and between 108 and 114 deg East.',-8.8,0.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1655,'Indonesia - 114 to 120 deg E, N hem','Indonesia - north of equator and between 114 and 120 deg East.',0.0,4.5,114.0,120.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1656,'Indonesia - 114 to 120 deg E, S hem','Indonesia - south of equator and between 114 and 120 deg East.',-10.33,0.0,114.0,120.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1657,'Indonesia - 120 to 126 deg E, N hem','Indonesia - north of equator and between 120 and 126 deg East.',0.0,3.75,120.0,126.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1658,'Indonesia - 120 to 126 deg E, S hem','Indonesia - south of equator and between 120 and 126 deg East.',-11.1,0.0,120.0,126.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1659,'Indonesia - 126 to 132 deg E, N hem','Indonesia - north of equator and between 126 and 132 deg East.',0.0,4.5,126.0,132.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1660,'Indonesia - 126 to 132 deg E, S hem','Indonesia - south of equator and between 126 and 132 deg East.',-9.0,0.0,126.0,132.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1661,'Indonesia - 132 to 138 deg E, N hem','Indonesia - north of equator and east of 132 deg East.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','1995-07-21','',1),
(1662,'Indonesia - 132 to 138 deg E, S hem','Indonesia - south of equator and between 132 and 138 deg East.',-8.7,0.0,132.0,138.0,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1663,'Indonesia - E of 138 deg E, S hem','Indonesia - south of equator and east of 138 deg East.',-9.42,0.0,138.0,141.1,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1664,'Myanmar (Burma) - W of 96 deg E','Myanmar (Burma) - west of 96 deg East.',15.6,27.1,92.0,96.0,'','','',NULL,'','EPSG','EPSG','1998-06-13','',0),
(1665,'Asia - Myanmar and Thailand - 96 to 102 deg E','Myanmar (Burma) - east of 96 deg East; Thailand - west of 102 deg East.',5.63,28.55,96.0,102.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1666,'Thailand - E of 102 deg E','Thailand - east of 102 deg East.',5.63,20.47,102.0,105.7,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1667,'Thailand - W of 102 deg E','Thailand - west of 102 deg East.',5.63,20.47,98.17,102.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1668,'Pakistan - N of 35 deg 35 min N','Pakistan - north of 35 deg 35 min North.',35.58,37.08,71.1,77.87,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1669,'Asia - India; Pakistan - 28 to 35.5 deg N','India north of 28 deg North; Pakistan 28 deg to 35 deg 35 min North.',28.0,35.58,60.87,97.38,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1670,'Asia - India; Pakistan - zone IIa','India - between 21 and 28 deg North and west of 82 deg East; Pakistan - south of 28 deg North.',21.0,28.0,60.87,82.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1671,'Asia - Bangladesh; India; Myanmar; Pakistan - zone Ilb','Bangladesh; India - north of 22 deg North and east of 82 deg East; Myanmar (Burma) - north of 22 deg North.',21.0,28.0,82.0,102.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','2004.27',0),
(1672,'India - 15 to 21 deg N','India - between 15 and 21 deg North.',15.0,21.0,70.1,87.0,'','','',NULL,'','EPSG','EPSG','2000-04-23','',0),
(1673,'India - S of 15 deg N','India - south of 15 deg North.',8.0,15.0,73.9,80.4,'','','',NULL,'','EPSG','EPSG','2000-04-23','',0),
(1674,'Bangladesh - W of 90 deg E','Bangladesh - west of 90 deg East.',21.6,26.63,88.04,90.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1675,'Bangladesh - E of 90 deg E','Bangladesh - east of 90 deg East.',20.74,25.3,90.0,92.67,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1676,'India - N of 28 deg N','India - north of 28 deg North.',28.0,35.55,70.33,97.45,'','','',NULL,'','EPSG','EPSG','2000-04-23','',0),
(1677,'India - 21 to 28deg N and W of 82 deg E','India - between 21 and 28 deg North and west of 82 deg East.',21.0,28.0,68.1,82.0,'','','',NULL,'','EPSG','EPSG','2000-04-23','',0),
(1678,'India - N of 21 deg N and E of 82 deg E','India - north of 21 deg North and east of 82 deg East.',21.0,29.33,82.0,97.45,'','','',NULL,'','EPSG','EPSG','2000-04-23','',0),
(1679,'India - W of 72 deg E','India - west of 72 deg East.',20.6,28.33,68.1,72.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1680,'India - 72 to 78 deg E','India - between 72 and 78 deg East.',8.0,35.55,72.0,78.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1681,'India - 78 to 84 deg E','India - between 78 and 84 deg East.',8.33,35.55,78.0,84.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1682,'India - 84 to 90 deg E','India - between 84 and 90 deg East.',18.15,28.15,84.0,90.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1683,'India - 90 to 96 deg E','India - between 90 and 96 deg East.',10.45,35.55,90.0,96.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1684,'India - E of 96 deg E','India - east of 96 deg East.',27.0,35.55,96.0,97.45,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1685,'Pakistan - N of 28 deg N','Pakistan - north of 28 deg North.',28.0,37.08,60.91,77.87,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1686,'Pakistan - S of 28 deg N','Pakistan - south of 28 deg North.',23.6,28.0,-61.5,71.8,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1687,'Pakistan - W of 66 deg E','Pakistan - west of 66 deg East.',25.0,29.83,60.91,66.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1688,'Pakistan - 66 to 72 deg E','Pakistan - between 66 and 72 deg East.',23.6,36.6,66.0,72.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1689,'Pakistan - E of 72 deg E','Pakistan - east of 72 deg East.',28.2,37.08,72.0,77.87,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1690,'Malaysia - West Malaysia','Malaysia - West Malaysia.',1.2,6.75,99.67,105.75,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1691,'Malaysia - West Malaysia - W of 102 deg E','Malaysia - West Malaysia west of 102 deg East.',2.4,6.75,99.67,102.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1692,'Malaysia - West Malaysia - E of 102 deg E','Malaysia - West Malaysia east of 102 deg East.',1.2,6.25,102.0,105.75,'','','',NULL,'','EPSG','EPSG','1995-07-21','',0),
(1693,'Venezuela - W of 72 deg W','Venezuela - west of 72 deg West.',7.0,11.5,-73.36,-72.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1694,'Venezuela - 72 to 66 deg W','Venezuela - between 72 and 66 deg West.',0.75,12.2,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1695,'Venezuela - E of 66 deg W','Venezuela - east of 66 deg West.',0.65,11.2,-66.0,-57.38,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1696,'Gabon - N of equator','Gabon - north of equator.',0.0,2.33,9.33,14.51,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1697,'Gabon - S of equator','Gabon - south of equator.',-4.0,0.0,8.7,14.55,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1698,'Philippines - zone I','Philippines - west of 118 deg East.',7.7,9.3,116.9,118.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1699,'Philippines - zone II','Philippines - Palawan; Calamian Islands.',6.9,12.33,118.0,120.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1700,'Philippines - zone III','Philippines - Luzon (except SE part;); Mindoro.',5.4,20.75,119.75,122.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1701,'Philippines - zone IV','Philippines - SE Luzon; Tablas; Masbate; Panay; Cebu; Negros; west Mindanao.',6.33,14.5,122.0,124.45,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1702,'Philippines - zone V','Philippines - east Mindanao; Bohol; Samar.',5.3,12.75,123.8,126.7,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1703,'Morocco - N of 31.5 deg N','Morocco north of 35 grads (31 deg 30 min) North.',31.5,35.95,-9.75,-1.01,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1704,'Morocco - 27.9 to 31.5 deg N','Morocco between 31 and 35 grads (27 deg 54 min and 31 deg 30 min) North.',27.9,31.5,-13.0,-3.5,'','','',NULL,'','EPSG','EPSG','1996-09-12','',1),
(1705,'Morocco - S of 27.9 deg N','Morocco south of 31grads  (27 deg 54 min) North.',21.06,27.9,-17.0,-8.67,'','','',NULL,'','EPSG','EPSG','1996-09-12','',1),
(1706,'Austria - W of 11 deg 50 min E','Austria west of 11deg 50min East of Greenwich (29 deg 30 min East of Ferro).',46.7,47.7,9.53,11.83,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1707,'Austria - 11 deg 50 min to 14deg 50min E','Austria between 11deg 50min and 14deg 50min East of Greenwich (29 deg 30 min and 32 deg 30 min East of Ferro).',46.3,48.8,11.83,14.83,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1708,'Austria - E of 14 deg 50 min E','Austria east of 14deg 50min East of Greenwich (32 deg 30 min East of Ferro).',46.5,49.02,14.83,17.17,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1709,'Europe - former Yugoslavia - W of 16.5 deg E','Bosnia and Herzegowina west of 16 deg 30 min E; Croatia west of 16 deg 30 min E; Slovenia.',43.01,46.88,13.38,16.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1710,'Europe - former Yugoslavia - 16.5 to 19.5 deg E','Bosnia and Herzegowina east of 16 deg 30 min E; Croatia east of 16 deg 30 min E; Serbia and Montenegro - west of 19 deg 30 min E.',41.85,46.55,16.5,19.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1711,'Europe - former Yugoslavia - 19.5 to 22.5 deg E','FYR Macedonia west of 22 deg 30 min E; Serbia and Montenegro - between 19 deg 30 min and 22 deg 30 min E.',40.86,46.18,19.5,22.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1712,'Europe - former Yugoslavia - E of 22.5 deg E','FYR Macedonia and Serbia and Montenegro - east of 22 deg 30 min E.',41.12,44.69,22.5,23.03,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(1713,'Nigeria - E of 10.5 deg E','Nigeria east of 10 deg 30 min East.',6.45,13.75,10.5,14.68,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1714,'Nigeria - 6.5 to 10.5 deg E','Nigeria between 6 deg 30 min and 10 deg 30 min East.',4.22,13.52,6.5,10.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1715,'Nigeria - W of 6.5 deg E','Nigeria west of 6 deg 30 min East.',4.25,13.9,2.67,6.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1716,'Nigeria - offshore deep water - W of 6 deg E','Nigeria - offshore beyond continental shelf west of 6 deg East.',2.25,6.2,2.7,6.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1717,'Nigeria - offshore deep water','Nigeria - offshore beyond continental shelf.',2.25,6.2,2.7,8.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1718,'Italy - W of 12 deg E','Italy - west of 12 deg East.',8.8,47.05,6.65,12.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1719,'Italy - E of 12 deg E','Italy - east of 12 deg East including San Marino and Vatican City State.',36.6,47.09,12.0,18.53,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1720,'United States (USA) - Michigan - SPCS - E','United States (USA) - Michigan - counties of Alcona; Alpena; Arenac; Bay; Cheboygan; Clinton; Crawford; Genesee; Gladwin; Gratiot; Hillsdale; Huron; Ingham; Iosco; Jackson; Lapeer; Lenawee; Livingston; Macomb; Midland; Monroe; Montmorency; Oakland; Ogemaw; Oscoda; Otsego; Presque Isle; Roscommon; Saginaw; Sanilac; Shiawassee; St. Clair; Tuscola; Washtenaw; Wayne.',45.06,45.82,-84.83,-82.12,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(1721,'United States (USA) - Michigan - SPCS - old central','United States (USA) - Michigan - counties of Allegan; Antrim; Barry; Benzie; Berrien; Branch; Calhoun; Cass; Charlevoix; Clare; Eaton; Emmet; Grand Traverse; Ionia; Isabella; Kalamazoo; Kalkaska; Kent; Lake; Leelanau; Manistee; Mason; Mecosta; Missaukee; Montcalm; Muskegon; Newaygo; Oceana; Osceola; Ottawa; St. Joseph; Van Buren; Wexford.',41.75,45.88,-87.14,-84.6,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1722,'United States (USA) - Michigan - SPCS - W','United States (USA) - Michigan - counties of Alger; Baraga; Chippewa; Delta; Dickinson; Gogebic; Houghton; Iron; Keweenaw; Luce; Mackinac; Marquette; Menominee; Ontonagon; Schoolcraft.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2000-03-07','',1),
(1723,'United States (USA) - Michigan - SPCS - N','United States (USA) - Michigan north of approximately 45d 45m North - counties of Alger; Baraga; Chippewa; Delta; Dickinson; Gogebic; Houghton; Iron; Keweenaw; Luce; Mackinac; Marquette; Menominee; Ontonagon; Schoolcraft.',45.24,48.3,-90.41,-83.42,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1724,'United States (USA) - Michigan - SPCS - central','United States (USA) - Michigan between approximately 45d 45m & 43d 55m North - counties of Alcona; Alpena; Antrim; Arenac; Benzie; Charlevoix; Cheboygan; Clare; Crawford; Emmet; Gladwin; Grand Traverse; Iosco; Kalkaska; Lake; Leelanau; Manistee; Mason; Missaukee; Montmorency; Ogemaw; Osceola; Oscoda; Otsego; Presque Isle; Roscommon; Wexford.',43.81,45.88,-87.09,-82.24,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1725,'United States (USA) - Michigan - SPCS - S','United States (USA) - Michigan south of approximately 43d 55m North - counties of Allegan; Barry; Bay; Berrien; Branch; Calhoun; Cass; Clinton; Eaton; Genesee; Gratiot; Hillsdale; Huron; Ingham; Ionia; Isabella; Jackson; Kalamazoo; Kent; Lapeer; Lenawee; Livingston; Macomb; Mecosta; Midland; Monroe; Montcalm; Muskegon; Newaygo; Oakland; Oceana; Ottawa; Saginaw; Sanilac; Shiawassee; St. Clair; St. Joseph; Tuscola; Van Buren; Washtenaw; Wayne.',41.75,44.17,-87.14,-82.12,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(1726,'Mozambique - offshore','Mozambique - offshore.',-26.8,-17.0,33.0,39.0,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(1727,'Suriname - offshore','Suriname - offshore.',5.73,7.0,-57.15,-53.0,'','','',NULL,'','EPSG','EPSG','2000-06-10','',0),
(1728,'Algeria - N of 34 deg 39 min N','Algeria - north of 38.5 grads (34 deg 39 min) North.',34.65,37.09,-2.22,8.66,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1729,'Algeria - 31 deg 30 min to 34 deg 39 min N','Algeria - 35 grads to 38.5 grads (31 deg 30 min to 34 deg 39 min) North.',31.5,34.65,3.5,9.25,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.143',0),
(1730,'North America - NAVD88','North America: Canada - Alberta; British Columbia (BC); Manitoba; New Brunswick (NB); Newfoundland and Labrador; North West Territories; Nova Scotia (NS); Nunavut; Ontario; Prince Edward Island (PEI); Quebec; Saskatchewan; Yukon. United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',25.0,58.0,-168.0,-52.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',1),
(1731,'France - N of 48.15 deg N','France north of 53.5 grads (48 deg 09 min) North.',48.15,51.1,-5.2,8.23,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1732,'France - 45.45 to 48.15 deg N','France 50.5 to 53.5 grads (45 deg 27 min to 48 deg 09 min) North.',45.45,48.15,-4.7,7.67,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1733,'France - S of 45.45 deg N','France south of 50.5 grads (45 deg 27 min) North.',42.33,45.45,-1.76,7.77,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1734,'France - 45.45 to 48.15 deg N. Also all mainland.','France 50.5 to 53.5 grads (45 deg 27 min to 48 deg 09 min) North. Also used over all mainland France.',42.25,51.1,-5.2,8.23,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1735,'Algeria - W of 6 deg W','Algeria - west of 6 deg West (of Greenwich).',25.66,29.85,-8.67,-6.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1736,'Algeria - 6 to 0 deg W','Algeria - between 6 deg West and 0 deg East (of Greenwich).',21.79,35.91,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1737,'Algeria - 0 to 6 deg E','Algeria - between 0 and 6 deg East (of Greenwich).',18.98,37.09,0.0,6.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1738,'Algeria - E of 6 deg E','Algeria - east of 6 deg East (of Greenwich).',19.41,37.09,6.0,11.99,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1739,'Kuwait - W of 48 deg E','Kuwait - west of 48 deg East.',28.56,30.1,46.57,48.0,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1740,'Kuwait - E of 48 deg E','Kuwait - east of 48 deg East.',28.56,30.02,48.0,49.4,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1741,'Norway - zone I','Norway - west of 3deg 30min W of Oslo (7deg 13min 22.5sec E of Greenwich).',57.95,63.05,4.6,7.22,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1742,'Norway - zone II','Norway - between 3deg 30min W and 1deg 10min W of Oslo (7deg 13min 22.5sec E  and 9deg 33min 22.5sec E of Greenwich).',57.95,63.8,7.22,9.56,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1743,'Norway - zone III','Norway - between 1deg 10min W and 1deg 15min E of Oslo (9deg 33min 22.5sec E and 11deg 58min 22.5sec E of Greenwich).',58.9,65.75,9.56,11.97,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1744,'Norway - zone IV','Norway - between 1deg 15min E and 4deg 20min E of Oslo (11deg 58min 22.5sec E and 15deg 03min 22.5sec E of Greenwich).',59.9,69.0,11.97,15.06,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1745,'Norway - zone V','Norway - between 4deg 20min E and 8deg 10min E of Oslo (15deg 03min 22.5sec E and 18deg 53min 22.5sec E of Greenwich).',66.15,70.2,15.06,18.89,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1746,'Norway - zone VI','Norway - between 8deg 10min E and 12deg 10min E of Oslo (18deg 53min 22.5sec E and 22deg 53min 22.5sec E of Greenwich).',68.35,70.8,18.89,22.89,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1747,'Norway - zone VII','Norway - between 12deg 10min E and 16deg 15min E of Oslo (22deg 53min 22.5sec E and 26deg 58min 22.5sec E of Greenwich).',68.5,71.2,18.89,26.97,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1748,'Norway - zone VIII','Norway - east of 16deg 15min E of Oslo (26deg 58min 22.5sec E of Greenwich).',69.0,71.15,26.97,31.2,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(1749,'Asia - Middle East - Nahrwan / UTM 39','Iraq - east of 48 deg East. Kuwait - east of 48 deg East.  Qatar - offshore.  United Arab Emirates (UAE) - Abu Dhabi - west of 54 deg East.',22.75,31.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2006-06-02','2006.34',0),
(1750,'United Arab Emirates (UAE) - E of 54 deg E','United Arab Emirates (UAE) - Abu Dhabi east of 54 deg East; Dubai; Sharjah; Ajman; Fujairah; Ras Al Kaimah; Umm Al Qaiwain.',22.6,26.29,54.0,57.03,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1751,'Peru - E of 73 deg W','Peru - east of 73 deg West.',-18.6,-2.0,-73.0,-68.72,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1752,'Peru - 79 to 73 deg W','Peru - between 79 and 73 deg West.',-16.52,-0.03,-79.0,-73.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1753,'Peru - W of 79 deg W','Peru - west of 79 deg West.',-8.55,-3.33,-81.33,-79.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(1754,'Brazil - Amazon Cone','Brazil - offshore - Amazon Cone.',-2.0,5.0,-50.0,-47.0,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(1755,'South America - 84 to 78 deg W, S hem and PSAD56 by country','South America - Ecuador and Peru - between 84 and 78 deg West, southern hemisphere.',-10.4,0.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.144',0),
(1756,'South America - 78 to 72 deg W, N hem and PSAD56 by country','South America (Ecuador;  [Venezuela]) between 78 and 72 deg West, northern hemisphere.',0.0,11.56,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1757,'South America - 78 to 72 deg W, S hem and PSAD56 by country','South America (Chile; Ecuador; Peru) between 78 and 72 deg West, southern hemisphere.',-49.0,0.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1758,'South America - 72 to 66 deg W, N hem and PSAD56 by country','South America (Aruba, Netherlands Antilles (Bonaire, Curacao); [Venezuela]) between 72 and 66 deg West, northern hemisphere.',0.7,12.63,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1759,'South America - 72 to 66 deg W, S hem and PSAD56 by country','South America (Bolivia; Chile; Peru) between 72 and 66 deg West, southern hemisphere.',-41.2,-2.17,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1760,'South America - 66 to 60 deg W, N hem and PSAD56 by country','South America (Guyana; [Venezuela]) between 66 and 60 deg West, northern hemisphere.',0.65,11.17,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1761,'South America - 66 to 60 deg W, S hem and PSAD56 by country','South America (Bolivia) between 66 and 60 deg West, southern hemisphere.',-22.91,-9.69,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1762,'South America - 60 to 54 deg W, S hem and PSAD56 by country','South America (Guyana) between 60 and 54 deg West, northern hemisphere.',1.19,8.41,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2005.14',0),
(1763,'Russia - W of 24 deg E','Russian Federation - west of 24 deg East - Kaliningrad.',54.32,55.3,19.2,22.9,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(1764,'Russia - 24 to 30 deg E','Russian Federation - between 24 and 30 deg East.',55.71,69.45,27.34,30.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1765,'Russia - 30 to 36 deg E','Russian Federation - between 30 and 36 deg East.',50.42,70.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1766,'Russia - 36 to 42 deg E','Russian Federation - between 36 and 42 deg East.',43.2,69.18,36.0,42.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1767,'Russia - 42 to 48 deg E','Russian Federation - between 42 and 48 deg East.',41.17,68.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1768,'Russia - 48 to 54 deg E','Russian Federation - between 48 and 54 deg East.',41.4,73.33,48.0,54.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1769,'Russia - 54 to 60 deg E','Russian Federation - between 54 and 60 deg East.',50.5,76.0,54.0,60.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1770,'Russia - 60 to 66 deg E','Russian Federation - between 60 and 66 deg East.',50.6,76.67,60.0,66.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1771,'Russia - 66 to 72 deg E','Russian Federation - between 66 and 72 deg East .',54.05,77.0,66.0,72.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1772,'Russia - 72 to 78 deg E','Russian Federation - between 72 and 78 deg East.',53.2,73.0,72.0,78.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1773,'Russia - 78 to 84 deg E','Russian Federation - between 78 and 84 deg East.',50.5,74.0,78.0,84.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1774,'Russia - 84 to 90 deg E','Russian Federation - between 84 and 90 deg East.',49.1,76.0,84.0,90.0,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(1775,'Russia - 90 to 96 deg E','Russian Federation - between 90 and 96 deg East.',50.0,76.0,90.0,96.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1776,'Russia - 96 to 102 deg E','Russian Federation - between 96 and 102 deg East.',49.75,77.0,96.0,102.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1777,'Russia - 102 to 108 deg E','Russian Federation - between 102 and 108 deg East.',49.7,77.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1778,'Russia - 108 to 114 deg E','Russian Federation - between 108 and 114 deg East.',49.1,76.5,108.0,114.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1779,'Russia - 114 to 120 deg E','Russian Federation - between 114 and 120 deg East.',49.45,75.0,114.0,120.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1780,'Russia - 120 to 126 deg E','Russian Federation - between 120 and 126 deg East.',51.45,74.0,120.0,126.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1781,'Russia - 126 to 132 deg E','Russian Federation - between 126 and 132 deg East.',42.25,73.5,126.0,132.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1782,'Russia - 132 to 138 deg E','Russian Federation - between 132 and 138 deg East.',42.6,76.0,132.0,138.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1783,'Russia - 138 to 144 deg E','Russian Federation - between 138 and 144 deg East.',45.8,76.0,138.0,144.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1784,'Russia - 144 to 150 deg E','Russian Federation - between 144 and 150 deg East.',44.3,76.0,144.0,150.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1785,'Russia - 150 to 156 deg E','Russian Federation - between 150 and 156 deg East.',45.75,72.0,150.0,156.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1786,'Russia - 156 to 162 deg E','Russian Federation - between 156 and 162 deg East.',50.33,71.0,156.0,162.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1787,'Russia - 162 to 168 deg E','Russian Federation - between 162 and 168 deg East.',55.33,70.0,162.0,168.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1788,'Russia - 168 to 174 deg E','Russian Federation - between 168 and 174 deg East.',59.8,71.0,168.0,174.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1789,'Russia - 174 to 180 deg E','Russian Federation - between 174 and 180 deg East .',61.7,71.5,174.0,180.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1790,'Russia - 180 to 174 deg W','Russian Federation - between 180 deg East and 174 deg West.',64.15,71.5,-180.0,-174.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1791,'Russia - E of 174 deg W','Russian Federation - east of 174 deg West.',64.15,67.2,-174.0,-168.25,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1792,'Europe - 12 to 18 deg E and Pulkovo by country','Czech Republic and Germany (former DDR) - east of 12 deg East; Slovakia - west of 18 deg East.',47.75,54.83,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2005-11-02','2002.361 2005.59',0),
(1793,'Europe - 18 to 24 deg E and Pulkovo by country','Belarus, Estonia, Latvia, Lithuania & Ukraine - west of 24 deg East. Russian Federation - Kaliningrad. Slovakia east of 18 deg East.',47.74,59.29,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2006-07-14','2002.361 2005.59 2006.59',0),
(1794,'Europe - FSU - 24 to 30 deg E and Pulkovo by country','Belarus - west of 30 deg East;  Estonia; Latvia & Lithuania - east of 24 deg East;  Moldova;  Russian Federation &  Ukraine - 24 to 30 deg East.',45.21,69.47,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1795,'Europe - FSU- 30 to 36 deg E','Belarus & Moldova - east of 30 deg East;  Russian Federation  &  Ukraine  - 30 to 36 deg East.',44.38,69.96,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2006-07-14','2002.361 2006.59',0),
(1796,'Europe - FSU - 36 to 42 deg E','Georgia - west of 36 deg East;  Russian Federation - 36 to 42 deg East;  Ukraine - east of 36 deg East.',41.43,69.17,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1797,'Europe - FSU - 42 to 48 deg E','Armenia - west of 48 deg East;  Azerbaijan - west of 48 deg East;  Georgia - east of 42 deg East;  Kazakhstan - west of 48 deg East; Russian Federation - 42 to 48 deg East.',38.84,80.86,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2006-07-14','2002.361 2006.59',0),
(1798,'Asia - FSU - 48 to 54 deg E','Azerbaijan - east of 48 deg East;  Kazakhstan - 48 to 54 deg East;  Russian Federation - 48 to 54 deg East;  Turkmenistan - west of 54 deg East.',37.0,84.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2006-07-14','2002.361 2006.59',0),
(1799,'Asia - FSU - 54 to 60 deg E','Kazakhstan;  Russian Federation;  Turkmenistan  - 54 deg  to 60 deg East; Uzbekistan - west of 60 deg East.',36.6,84.0,54.0,60.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1800,'Asia - FSU - 60 to 66 deg E','Kazakhstan;  Russian Federation;  Uzbekistan - 60 to 66 deg East;  Turkmenistan - east of 60 deg East.',34.9,84.0,60.0,66.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1801,'Asia - FSU - 66 to 72 deg E','Kazakhstan, Russian Federation & Uzbekistan - 66 to 72 deg East;  Kyrgyzstan & Tajikistan - west of 72 deg East.',36.4,84.0,66.0,72.0,'','','',NULL,'','EPSG','EPSG','2006-07-14','2002.361 2006.38 2006.59',0),
(1802,'Asia - FSU - 72 to 78 deg E','Kazakhstan; Kyrgyzstan; Russian Federation - 72 to 78 deg East; Tajikistan & Uzbekistan - east of 72 deg East.',36.4,84.0,72.0,78.0,'','','',NULL,'','EPSG','EPSG','2006-07-14','2002.361 2006.38 2006.59',0),
(1803,'Asia - FSU - 78 to 84 deg E','Kazakhstan &  Russian Federation - 78 to 84 deg East; Kyrgyzstan - east of 78 deg East.',40.7,84.0,78.0,84.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1804,'Asia - FSU - 84 to 90 deg E','Kazakhstan - east of 84 deg East;  Russian Federation - 84 to 90 deg East.',46.7,84.0,84.0,90.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1805,'Europe - 6 to 12 deg E and Pulkovo by country','Czech Republic and Germany (former DDR) - west of 12 deg East.',50.21,54.18,9.93,12.0,'','','',NULL,'','EPSG','EPSG','2002-06-22','2002.361',0),
(1806,'South America - UTM 17S and SAD69 by country','South America - between 84 and 78 deg West; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1807,'South America - UTM 18N and SAD69 by country','South America - between 78 and 72 deg West; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1808,'South America - UTM 18S and SAD69 by country','South America - between 78 and 72 deg West; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1809,'South America - UTM 19N and SAD69 by country','South America - between 72 and 66 deg West; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1810,'South America - UTM 19S and SAD69 by country','South America - between 72 and 66 deg West; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1811,'South America - UTM 20N and SAD69 by country','South America - between 66 and 60 deg West; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1812,'South America - UTM 20S and SAD69 by country','South America - between 66 and 60 deg West; southern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1813,'South America - UTM 21N and SAD69','South America - between 60 and 54 deg West; northern hemisphere.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',1),
(1814,'Brazil - 60 to 54 deg W and south of 15 deg S.','Brazil - between 60 and 54 deg West and south of 15 deg South.',-31.95,-15.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-12-30','2005.144 2005.841',0),
(1815,'Brazil - offshore - deep water Amazon cone.','Brazil - offshore - deep water Amazon cone.',2.5,4.5,-50.0,-47.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.144',0),
(1816,'Brazil - 54 to 48 deg W.','Brazil - between 54 and 48 deg West.',-33.8,-4.33,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.144',0),
(1817,'Brazil - 48 to 42 deg West.','Brazil - between 48 and 42 deg West.',-26.3,0.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.144',0),
(1818,'Brazil - 42 to 36 deg W.','Brazil - between 42 and 36 deg West.',-23.0,-2.8,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.144',0),
(1819,'Brazil - 36 to 30deg W.','Brazil - between 36 and 30deg West.',-10.05,-5.15,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.144',0),
(1820,'Falkland Islands - W of 60 deg W','Falkland Islands (Malvinas) - west of 60 deg West.',-60.0,-47.6,-65.0,60.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1821,'Falkland Islands - E of 60 deg W','Falkland Islands (Malvinas) - east of 60 deg West.',-60.0,-47.6,-60.0,-48.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1822,'Namibia - offshore','Namibia - offshore.',-28.7,-17.2,10.0,16.4,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(1823,'South America - 84 to 78 deg W, N hem','South America - between 84 and 78deg West; northern hemisphere.',0.0,2.68,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1824,'South America - 84 to 78 deg W, S hem','South America - between 84 and 78deg West; southern hemisphere.',-10.4,0.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1825,'South America - 78 to 72 deg W, N hem','South America - between 78 and 72deg West; northern hemisphere.',0.0,12.2,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1826,'South America - 78 to 72 deg W, S hem','South America - between 78 and 72deg West; southern hemisphere.',-54.8,0.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1827,'South America - 72 to 66 deg W, N hem','South America - between 72 and 66deg West; northern hemisphere.',0.0,13.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1828,'South America - 72 to 66 deg W, S hem','South America - between 72 and 66deg West; southern hemisphere.',-56.15,0.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1829,'South America - 66 to 60 deg W, N hem','South America - between 66 and 60deg West; northern hemisphere.',0.0,11.2,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1830,'South America - 66 to 60 deg W, S hem','South America - between 66 and 60deg West; southern hemisphere.',-55.33,0.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1831,'South America - 60 to 54 deg W, N hem','South America - between 60 and 54deg West; northern hemisphere.',0.0,8.56,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1832,'South America - 60 to 54 deg W, S hem','South America - between 60 and 54deg West; southern hemisphere.',-38.9,0.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1833,'South America - 54 to 48 deg W, N hem','South America - between 54 and 48deg West; northern hemisphere.',0.0,5.75,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1834,'South America - 54 to 48 deg W, S hem','South America - between 54 and 48deg West; southern hemisphere.',-34.6,0.0,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1835,'South America - 48 to 42 deg W','South America - between 48 and 42deg West.',-26.3,0.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1836,'South America - 42 to 36 deg W','South America - between 42 and 36deg West.',-23.0,0.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','2005.14',0),
(1837,'South America - 36 to 30 deg W','South America - between 36 and 30deg West.',-9.9,0.0,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1838,'Namibia - W of 12 deg E','Namibia - west of 12 deg East.',-18.33,-17.1,11.6,12.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1839,'Namibia - 12 to 14 deg E','Namibia - between 12 and 14 deg East.',-21.83,-16.99,12.0,14.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1840,'Namibia - 14 to 16 deg E','Namibia - between 14 and 16 deg East.',-28.4,-17.33,14.0,16.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1841,'Namibia - 16 to 18 deg E','Namibia - between 16 and 18 deg East.',-28.9,-17.33,16.0,18.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1842,'Namibia - 18 to 20 deg E','Namibia - between 18 and 20 deg East.',-29.0,-17.33,18.0,20.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1843,'Namibia - 20 to 22 deg E','Namibia - between 20 and 22 deg East.',-22.0,-17.8,20.0,22.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1844,'Namibia - 22 to 24 deg E','Namibia - between 22 and 24 deg East.',-18.55,-17.5,22.0,24.0,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1845,'Namibia - E of 24 deg E','Namibia - east of 24 deg East.',-18.3,-17.4,24.0,25.28,'','','',NULL,'','EPSG','EPSG','1997-06-16','',0),
(1846,'Sudan - south - W of 30 deg E','Sudan south - west of 30 deg East.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','1995-06-02','',1),
(1847,'Sudan - south - E of 30 deg E','Sudan south - east of 30 deg East.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','1995-06-02','',1),
(1848,'Madagascar - offshore - W of 48 deg E','Madagascar - offshore west of 48 deg East.',-26.33,-12.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1849,'Madagascar - offshore - E of 48 deg E','Madagascar - offshore east of 48 deg East.',-25.0,-11.5,48.0,51.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1850,'United Arab Emirates (UAE) - Abu Dhabi - W of 54 deg E','United Arab Emirates (UAE) - Abu Dhabi west of 54 deg East.',22.77,25.65,51.16,54.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1851,'Malaysia - East Malaysia','Malaysia - East Malaysia (Sabah; Sarawak).',0.85,7.5,109.5,119.3,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(1852,'Asia - Brunei and East Malaysia - 108 to 114 deg E','Brunei - offshore; Malaysia - East Malaysia (Sarawak west of 114 deg East).',0.85,4.8,109.55,114.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1853,'Asia - Brunei and East Malaysia - 114 to 120 deg E','Brunei - offshore; Malaysia - East Malaysia (Sabah, Sarawak east of 114 deg East).',1.25,7.35,114.0,119.26,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(1854,'Japan - zone I','Japan - Kyushu west of approximately 130 deg East - Nagasaki-ken; islands of Kagoshima-ken between 27 and 32 deg N and between 128 deg 18 min and 130 deg E (between 128 deg 18 min and 30 deg 13 min E for Amami islands).',26.95,34.71,128.3,130.22,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1855,'Japan - zone II','Japan - Kyushu east of approximately 130 deg East - Fukuoka-ken; Saga-ken; Kumamoto-ken; Oita-ken; Miyazaki-ken; Kagoshima-ken (except for area within Japan Plane Rectangular Coordinate System zone I).',30.92,34.02,129.64,132.15,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1856,'Japan - zone III','Japan - Honshu west of approximately 133 deg 15 min East - Yamaguchi-ken; Shimane-ken; Hiroshima-ken.',33.67,36.35,130.75,133.53,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1857,'Japan - zone IV','Japan - Shikoku - Kagawa-ken; Ehime-ken; Tokushima-ken; Kochi-ken.',32.65,34.6,131.92,134.85,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1858,'Japan - zone V','Japan - Honshu between approximately 133 deg 15 min and 135 deg 10 min East - Hyogo-ken; Tottori-ken; Okayama-ken.',34.11,35.67,133.13,135.48,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1859,'Japan - zone VI','Japan - Honshu between approximately 135 deg 10 min and 136 deg 45 min East - Kyoto-fu; Osaka-fu; Fukui-ken; Shiga-ken; Mie-ken; Nara-ken; Wakayama-ken.',33.4,36.3,134.84,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1860,'Japan - zone VII','Japan - Honshu between approximately 136 deg 15 min and 137 deg 45 min East - Ishikawa-ken; Toyama-ken; Gifu-ken; Aichi-ken.',34.55,37.54,136.25,137.85,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1861,'Japan - zone VIII','Japan - Honshu between approximately 137 deg 45 min and 139 deg East - Niigata-ken; Nagano-ken; Yamanashi-ken; Shizuoka-ken.',34.09,38.66,137.47,139.93,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1862,'Japan - zone IX','Japan - Honshu - Tokyo-to. (Excludes offshore island areas of Tokyo-to covered by Japan Plane Rectangular Coordinate System zones XIV, XVIII and XIX).',32.33,35.92,138.93,140.86,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1863,'Japan - zone X','Japan - Honshu north of 38 deg North approximately - Aomori-ken; Akita-ken; Yamagata-ken; Iwate-ken; Miyagi-ken.',37.73,41.63,139.5,142.08,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1864,'Japan - zone XI','Japan - Hokkaido west of approximately 141 deg  East  - Otaru city; Hakodate city; Date city; Usu-gun and Abuta-gun of Iburi-shicyo; area of Hiyama-shicyo; area of Shiribeshi-shicyo; Oshima-shicyo.',41.33,45.5,139.33,141.25,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1865,'Japan - zone XII','Japan - Hokkaido between approximately 141 and 143 deg min East - Sapporo city; Asahikawa city; Wakkanai city; Rumoi city; Bibai city; Yubari city; Iwamizawa city; Tomakomai city; Muroran city; Shibetsu city; Nayoro city; Ashibetsu city; Akabira city; Mikasa city; Takikawa city; Sunagawa city; Ebetsu city; Chitose city; Utashinai city; Fukagawa city; Monbetsu city; Furano city; Noboribetsu city; Eniwa city; Ishikari-shicyo; Monbetsu-gun of Abashiri-shicyo; Kamikawa-shicyo; Soya-shicyo; Hidaka-shicyo; Iburi-shicyo (except Usu-gun and Abuta-gun); Sorachi-shicyo; Rumoi-shicyo.',41.85,45.5,141.25,143.25,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1866,'Japan - zone XIII','Japan - Hokkaido east of approximately 143 deg East  - Kitami city; Obihiro city; Kushiro city; Abashiri city; Nemuro city; Nemuro-shicyo; Kushiro-shicyo; Abashiri-shicyo (except Monbetsu-gun); Tokachi-shicyo.',41.85,44.33,143.25,146.98,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1867,'Japan - zone XIV','Japan - Tokyo-to south of 28 deg North & between 140 deg 30 min & 143 deg East.',23.5,28.0,140.5,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1868,'Japan - zone XV','Japan - Okinawa-ken between 126 and 130 deg East.',23.9,27.1,126.0,130.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1869,'Japan - zone XVI','Japan - Okinawa-ken west of 126 deg East.',23.9,25.78,122.49,126.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1870,'Japan - zone XVII','Japan - Okinawa-ken east of 130 deg East.',23.9,26.25,130.0,131.67,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1871,'Japan - zone XVIII','Japan - Tokyo-to south of 28 deg North and west of 140 deg 30 min East.',23.5,28.0,134.0,140.5,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1872,'Japan - zone XIX','Japan - Tokyo-to south of 28 deg North & east of 143 deg East.',23.5,28.0,143.0,155.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(1873,'World - N hemisphere - 180 to 174 deg W','Between 180 deg and 174 deg West; northern hemisphere.',0.0,84.0,-180.0,-174.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1874,'World - S hemisphere - 180 to 174 deg W','Between 180 deg and 174 deg West; southern hemisphere.',-80.0,0.0,-180.0,-174.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1875,'World - N hemisphere - 174 to 168 deg W','Between 174 and 168 deg West; northern hemisphere.',0.0,84.0,-174.0,-168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1876,'World - S hemisphere - 174 to 168 deg W','Between 174 and 168 deg West; southern hemisphere.',-80.0,0.0,-174.0,-168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1877,'World - N hemisphere - 168 to 162 deg W','Between 168 and 162 deg West; northern hemisphere.',0.0,84.0,-168.0,-162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1878,'World - S hemisphere - 168 to 162 deg W','Between 168 and 162 deg West; southern hemisphere.',-80.0,0.0,-168.0,-162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1879,'World - N hemisphere - 162 to 156 deg W','Between 162 and 156 deg West; northern hemisphere.',0.0,84.0,-162.0,-156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1880,'World - S hemisphere - 162 to 156 deg W','Between 162 and 156 deg West; southern hemisphere.',-80.0,0.0,-162.0,-156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1881,'World - N hemisphere - 156 to 150 deg W','Between 156 and 150 deg West; northern hemisphere.',0.0,84.0,-156.0,-150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1882,'World - S hemisphere - 156 to 150 deg W','Between 156 and 150 deg West; northern hemisphere.',-80.0,0.0,-156.0,-150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1883,'World - N hemisphere - 150 to 144 deg W','Between 150 and 144 deg West; northern hemisphere.',0.0,84.0,-150.0,-144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1884,'World - S hemisphere - 150 to 144 deg W','Between 150 and 144 deg West; southern hemisphere.',-80.0,0.0,-150.0,-144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1885,'World - N hemisphere - 144 to 138 deg W','Between 144 and 138 deg West; northern hemisphere.',0.0,84.0,-144.0,-138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1886,'World - S hemisphere - 144 to 138 deg W','Between 144 and 138 deg West; southern hemisphere.',-80.0,0.0,-144.0,-138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1887,'World - N hemisphere - 138 to 132 deg W','Between 138 and 132 deg West; northern hemisphere.',0.0,84.0,-138.0,-132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1888,'World - S hemisphere - 138 to 132 deg W','Between 138 and 132 deg West; southern hemisphere.',-80.0,0.0,-138.0,-132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1889,'World - N hemisphere - 132 to 126 deg W','Between 132 and 126 deg West; northern hemisphere.',0.0,84.0,-132.0,-126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1890,'World - S hemisphere - 132 to 126 deg W','Between 132 and 126 deg West; southern hemisphere.',-80.0,0.0,-132.0,-126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1891,'World - N hemisphere - 126 to 120 deg W','Between 126 and 120 deg West; northern hemisphere.',0.0,84.0,-126.0,-120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1892,'World - S hemisphere - 126 to 120 deg W','Between 126 and 120 deg West; southern hemisphere.',-80.0,0.0,-126.0,-120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1893,'World - N hemisphere - 120 to 114 deg W','Between 120 and 114 deg West; northern hemisphere.',0.0,84.0,-120.0,-114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1894,'World - S hemisphere - 120 to 114 deg W','Between 120 and 114 deg West; southern hemisphere.',-80.0,0.0,-120.0,-114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1895,'World - N hemisphere - 114 to 108 deg W','Between 114 and 108 deg West; northern hemisphere.',0.0,84.0,-114.0,-108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1896,'World - S hemisphere - 114 to 108 deg W','Between 114 and 108 deg West; southern hemisphere.',-80.0,0.0,-114.0,-108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1897,'World - N hemisphere - 108 to 102 deg W','Between 108 and 102 deg West; northern hemisphere.',0.0,84.0,-108.0,-102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1898,'World - S hemisphere - 108 to 102 deg W','Between 108 and 102 deg West; southern hemisphere.',-80.0,0.0,-108.0,-102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1899,'World - N hemisphere - 102 to 96 deg W','Between 102 and 96 deg West; northern hemisphere.',0.0,84.0,-102.0,-96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1900,'World - S hemisphere - 102 to 96 deg W','Between 102 and 96 deg West; southern hemisphere.',-80.0,0.0,-102.0,-96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1901,'World - N hemisphere - 96 to 90 deg W','Between 96 and 90 deg West; northern hemisphere.',0.0,84.0,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1902,'World - S hemisphere - 96 to 90 deg W','Between 96 and 90 deg West; southern hemisphere.',-80.0,0.0,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1903,'World - N hemisphere - 90 to 84 deg W','Between 90 and 84 deg West; northern hemisphere.',0.0,84.0,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1904,'World - S hemisphere - 90 to 84 deg W','Between 90 and 84 deg West; southern hemisphere.',-80.0,0.0,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1905,'World - N hemisphere - 84 to 78 deg W','Between 84 and 78 deg West; northern hemisphere.',0.0,84.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1906,'World - S hemisphere - 84 to 78 deg W','Between 84 and 78 deg West; southern hemisphere.',-80.0,0.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1907,'World - N hemisphere - 78 to 72 deg W','Between 78 and 72 deg West; northern hemisphere.',0.0,84.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1908,'World - S hemisphere - 78 to 72 deg W','Between 78 and 72 deg West; southern hemisphere.',-80.0,0.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1909,'World - N hemisphere - 72 to 66 deg W','Between 72 and 66 deg West; northern hemisphere.',0.0,84.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1910,'World - S hemisphere - 72 to 66 deg W','Between 72 and 66 deg West; southern hemisphere.',-80.0,0.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1911,'World - N hemisphere - 66 to 60 deg W','Between 66 and 60 deg West; northern hemisphere.',0.0,84.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1912,'World - S hemisphere - 66 to 60 deg W','Between 66 and 60 deg West; southern hemisphere.',-80.0,0.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1913,'World - N hemisphere - 60 to 54 deg W','Between 60 and 54 deg West; northern hemisphere.',0.0,84.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1914,'World - S hemisphere - 60 to 54 deg W','Between 60 and 54 deg West; southern hemisphere.',-80.0,0.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1915,'World - N hemisphere - 54 to 48 deg W','Between 54 and 48 deg West; northern hemisphere.',0.0,84.0,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1916,'World - S hemisphere - 54 to 48 deg W','Between 54 and 48 deg West; southern hemisphere.',-80.0,0.0,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1917,'World - N hemisphere - 48 to 42 deg W','Between 48 and 42 deg West; northern hemisphere.',0.0,84.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1918,'World - S hemisphere - 48 to 42 deg W','Between 48 and 42 deg West; southern hemisphere.',-80.0,0.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1919,'World - N hemisphere - 42 to 36 deg W','Between 42 and 36 deg West; northern hemisphere.',0.0,84.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1920,'World - S hemisphere - 42 to 36 deg W','Between 42 and 36 deg West; southern hemisphere.',-80.0,0.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1921,'World - N hemisphere - 36 to 30  deg W','Between 36 and 30 deg West; northern hemisphere.',0.0,84.0,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1922,'World - S hemisphere - 36 to 30 deg W','Between 36 and 30 deg West; southern hemisphere.',-80.0,0.0,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1923,'World - N hemisphere - 30 to 24 deg W','Between 30 and 24 deg West; northern hemisphere.',0.0,84.0,-30.0,-24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1924,'World - S hemisphere - 30 to 24 deg W','Between 30 and 24 deg West; southern hemisphere.',-80.0,0.0,-30.0,-24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1925,'World - N hemisphere - 24 to 18 deg W','Between 24 and 18 deg West; northern hemisphere.',0.0,84.0,-24.0,-18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1926,'World - S hemisphere - 24 to 18 deg W','Between 24 and 18 deg West; southern hemisphere.',-80.0,0.0,-24.0,-18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1927,'World - N hemisphere - 18 to 12 deg W','Between 18 and 12 deg West; northern hemisphere.',0.0,84.0,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1928,'World - S hemisphere - 18 to 12 deg W','Between 18 and 12 deg West; southern hemisphere.',-80.0,0.0,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1929,'World - N hemisphere - 12 to 6 deg W','Between 12 and 6 deg West; northern hemisphere.',0.0,84.0,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1930,'World - S hemisphere - 12 to 6 deg W','Between 12 and 6 deg West; southern hemisphere.',-80.0,0.0,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1931,'World - N hemisphere - 6 to 0 deg W','Between 6 deg West and 0 deg East; northern hemisphere.',0.0,84.0,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1932,'World - S hemisphere - 6 to 0 deg W','Between 6 deg West and 0 deg East; southern hemisphere.',-80.0,0.0,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1933,'World - N hemisphere - 0 to 6 deg E','Between 0 and 6 deg East; northern hemisphere.',0.0,84.0,0.0,6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1934,'World - S hemisphere - 0 to 6 deg E','Between 0 and 6 deg East; southern hemisphere.',-80.0,0.0,0.0,6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1935,'World - N hemisphere - 6 to 12 deg E','Between 6 and 12 deg East; northern hemisphere.',0.0,84.0,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1936,'World - S hemisphere - 6 to 12 deg E','Between 6 and 12 deg East; southern hemisphere.',-80.0,0.0,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1937,'World - N hemisphere - 12 to 18 deg E','Between 12 and 18 deg East; northern hemisphere.',0.0,84.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1938,'World - S hemisphere - 12 to 18 deg E','Between 12 and 18 deg East; southern hemisphere.',-80.0,0.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1939,'World - N hemisphere - 18 to 24 deg E','Between 18 and 24 deg East; northern hemisphere.',0.0,84.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1940,'World - S hemisphere - 18 to 24 deg E','Between 18 and 24 deg East; southern hemisphere.',-80.0,0.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1941,'World - N hemisphere - 24 to 30 deg E','Between 24 and 30 deg East; northern hemisphere.',0.0,84.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1942,'World - S hemisphere - 24 to 30 deg E','Between 24 and 30 deg East; southern hemisphere.',-80.0,0.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1943,'World - N hemisphere - 30 to 36 deg E','Between 30 and 36 deg East; northern hemisphere.',0.0,84.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1944,'World - S hemisphere - 30 to 36 deg E','Between 30 and 36 deg East; southern hemisphere.',-80.0,0.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1945,'World - N hemisphere - 36 to 42 deg E','Between 36 and 42 deg East; northern hemisphere.',0.0,84.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1946,'World - S hemisphere - 36 to 42 deg E','Between 36 and 42 deg East; southern hemisphere.',-80.0,0.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1947,'World - N hemisphere - 42 to 48 deg E','Between 42 and 48 deg East; northern hemisphere.',0.0,84.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1948,'World - S hemisphere - 42 to 48 deg E','Between 42 and 48 deg East; southern hemisphere.',-80.0,0.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1949,'World - N hemisphere - 48 to 54 deg E','Between 48 and 54 deg East; northern hemisphere.',0.0,84.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1950,'World - S hemisphere - 48 to 54 deg E','Between 48 and 54 deg East; southern hemisphere.',-80.0,0.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1951,'World - N hemisphere - 54 to 60 deg E','Between 54 and 60 deg East; northern hemisphere.',0.0,84.0,54.0,60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1952,'World - S hemisphere - 54 to 60 deg E','Between 54 and 60 deg East; southern hemisphere.',-80.0,0.0,54.0,60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1953,'World - N hemisphere - 60 to 66 deg E','Between 60 and 66 deg East; northern hemisphere.',0.0,84.0,60.0,66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1954,'World - S hemisphere - 60 to 66 deg E','Between 60 and 66 deg East; southern hemisphere.',-80.0,0.0,60.0,66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1955,'World - N hemisphere - 66 to 72 deg E','Between 66 and 72 deg East; northern hemisphere.',0.0,84.0,66.0,72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1956,'World - S hemisphere - 66 to 72 deg E','Between 66 and 72 deg East; southern hemisphere.',-80.0,0.0,66.0,72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1957,'World - N hemisphere - 72 to 78 deg E','Between 72 and 78 deg East; northern hemisphere.',0.0,84.0,72.0,78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1958,'World - S hemisphere - 72 to 78 deg E','Between 72 and 78 deg East; southern hemisphere.',-80.0,0.0,72.0,78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1959,'World - N hemisphere - 78 to 84 deg E','Between 78 and 84 deg East; northern hemisphere.',0.0,84.0,78.0,84.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1960,'World - S hemisphere - 78 to 84 deg E','Between 78 and 84 deg East; southern hemisphere.',-80.0,0.0,78.0,84.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1961,'World - N hemisphere - 84 to 90 deg E','Between 84 and 90 deg East; northern hemisphere.',0.0,84.0,84.0,90.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1962,'World - S hemisphere - 84 to 90 deg E','Between 84 and 90 deg East; southern hemisphere.',-80.0,0.0,84.0,90.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1963,'World - N hemisphere - 90 to 96 deg E','Between 90 and 96 deg East; northern hemisphere.',0.0,84.0,90.0,96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1964,'World - S hemisphere - 90 to 96 deg E','Between 90 and 96 deg East; southern hemisphere.',-80.0,0.0,90.0,96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1965,'World - N hemisphere - 96 to 102 deg E','Between 96 and 102eg East; northern hemisphere.',0.0,84.0,96.0,102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1966,'World - S hemisphere - 96 to 102 deg E','Between 96 and 102eg East; southern hemisphere.',-80.0,0.0,96.0,102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1967,'World - N hemisphere - 102 to 108 deg E','Between 102 and 108 deg East; northern hemisphere.',0.0,84.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1968,'World - S hemisphere - 102 to 108 deg E','Between 102 and 108 deg East; southern hemisphere.',-80.0,0.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1969,'World - N hemisphere - 108 to 114 deg E','Between 108 and 114 deg East; northern hemisphere.',0.0,84.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1970,'World - S hemisphere - 108 to 114 deg E','Between 108 and 114 deg East; southern hemisphere.',-80.0,0.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1971,'World - N hemisphere - 114 to 120 deg E','Between 114 and 120 deg East; northern hemisphere.',0.0,84.0,114.0,120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1972,'World - S hemisphere - 114 to 120 deg E','Between 114 and 120 deg East; southern hemisphere.',-80.0,0.0,114.0,120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1973,'World - N hemisphere - 120 to 126 deg E','Between 120 and 126 deg East; northern hemisphere.',0.0,84.0,120.0,126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1974,'World - S hemisphere - 120 to 126 deg E','Between 120 and 126 deg East; southern hemisphere.',-80.0,0.0,120.0,126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1975,'World - N hemisphere - 126 to 132 deg E','Between 126 and 132 deg East; northern hemisphere.',0.0,84.0,126.0,132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1976,'World - S hemisphere - 126 to 132 deg E','Between 126 and 132 deg East; southern hemisphere.',-80.0,0.0,126.0,132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1977,'World - N hemisphere - 132 to 138 deg E','Between 132 and 138 deg East; northern hemisphere.',0.0,84.0,132.0,138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1978,'World - S hemisphere - 132 to 138 deg E','Between 132 and 138 deg East; southern hemisphere.',-80.0,0.0,132.0,138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1979,'World - N hemisphere - 138 to 144 deg E','Between 138 and 144 deg East; northern hemisphere.',0.0,84.0,138.0,144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1980,'World - S hemisphere - 138 to 144 deg E','Between 138 and 144 deg East; southern hemisphere.',-80.0,0.0,138.0,144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1981,'World - N hemisphere - 144 to 150 deg E','Between 144 and 150 deg East; northern hemisphere.',0.0,84.0,144.0,150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1982,'World - S hemisphere - 144 to 150 deg E','Between 144 and 150 deg East; southern hemisphere.',-80.0,0.0,144.0,150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1983,'World - N hemisphere - 150 to 156 deg E','Between 150 and 156 deg East; northern hemisphere.',0.0,84.0,150.0,156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1984,'World - S hemisphere - 150 to 156 deg E','Between 150 and 156 deg East; southern hemisphere.',-80.0,0.0,150.0,156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1985,'World - N hemisphere - 156 to 162 deg E','Between 156 and 162 deg East; northern hemisphere.',0.0,84.0,156.0,162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1986,'World - S hemisphere - 156 to 162 deg E','Between 156 and 162 deg East; southern hemisphere.',-80.0,0.0,156.0,162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1987,'World - N hemisphere - 162 to 168 deg E','Between 162 and 168 deg East; northern hemisphere.',0.0,84.0,162.0,168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1988,'World - S hemisphere - 162 to 168 deg E','Between 162 and 168 deg East; southern hemisphere.',-80.0,0.0,162.0,168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1989,'World - N hemisphere - 168 to 174 deg E','Between 168 and 174 deg East; northern hemisphere.',0.0,84.0,168.0,174.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1990,'World - S hemisphere - 168 to 174 deg E','Between 168 and 174 deg East; southern hemisphere.',-80.0,0.0,168.0,174.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1991,'World - N hemisphere - 174 to 180 deg E','Between 174 and 180 deg; northern hemisphere.',0.0,84.0,174.0,180.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1992,'World - S hemisphere - 174 to 180 deg E','Between 174 and 180 deg; southern hemisphere.',-80.0,0.0,174.0,180.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(1993,'Vietnam - 102 to 108 deg E and WGS72BE','Between 102 and 108 deg East; northern hemisphere.  Vietnam - offshore.',0.0,84.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1994,'Vietnam - 108 to 114 deg E and WGS72BE','Between 108 and 114 deg East; northern hemisphere. Vietnam - offshore.',0.0,84.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1995,'Indonesia - 108 to 114 deg E and S hem and WGS72BE','Between 108 and 114 deg East; southern hemisphere.  Indonesia - offshore.',-80.0,0.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1996,'World - N of 60 deg N','Northern hemisphere - north of 60 deg North.',60.0,90.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2006-02-03','2005.14 2005.89',0),
(1997,'World - S of 60 deg S','Southern hemisphere - south of 60 deg South.',-90.0,-60.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2006-02-03','2005.14 2005.89',0),
(1998,'World - between 0 and 84 deg N','Northern hemisphere between equator and 84 deg North.',0.0,84.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(1999,'World - between 0 and 80 deg S','Southern hemisphere between equator and 80 deg South.',-80.0,0.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2000,'World - N hemisphere - 180 to 174 deg W - by country','Between 180 deg and 174 deg West; northern hemisphere; Russian Federation; United States (USA) - Alaska (AK).',0.0,84.0,-180.0,-174.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.144 2005.52',0),
(2001,'World - S hemisphere - 180 to 174 deg W - by country','Between 180 deg and 174 deg West; southern hemisphere.',-80.0,0.0,-180.0,-174.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2002,'World - N hemisphere - 174 to 168 deg W - by country','Between 174 and 168 deg West; northern hemisphere. Russian Federation; United States (USA) - Alaska (AK).',0.0,84.0,-174.0,-168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2003,'World - S hemisphere - 174 to 168 deg W - by country','Between 174 and 168 deg West; southern hemisphere.',-80.0,0.0,-174.0,-168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2004,'World - N hemisphere - 168 to 162 deg W - by country','Between 168 and 162 deg West; northern hemisphere. United States (USA) - Alaska (AK).',0.0,84.0,-168.0,-162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2005,'World - S hemisphere - 168 to 162 deg W - by country','Between 168 and 162 deg West; southern hemisphere.',-80.0,0.0,-168.0,-162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2006,'World - N hemisphere - 162 to 156 deg W - by country','Between 162 and 156 deg West; northern hemisphere. United States (USA) - Alaska (AK).',0.0,84.0,-162.0,-156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2007,'World - S hemisphere - 162 to 156 deg W - by country','Between 162 and 156 deg West; southern hemisphere.',-80.0,0.0,-162.0,-156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2008,'World - N hemisphere - 156 to 150 deg W - by country','Between 156 and 150 deg West; northern hemisphere. United States (USA) - Alaska (AK).',0.0,84.0,-156.0,-150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2009,'World - S hemisphere - 156 to 150 deg W - by country','Between 156 and 150 deg West; southern hemisphere.',-80.0,0.0,-156.0,-150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2010,'World - N hemisphere - 150 to 144 deg W - by country','Between 150 and 144 deg West; northern hemisphere. United States (USA) - Alaska (AK).',0.0,84.0,-150.0,-144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2011,'World - S hemisphere - 150 to 144 deg W - by country','Between 150 and 144 deg West; southern hemisphere.',-80.0,0.0,-150.0,-144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2012,'World - N hemisphere - 144 to 138 deg W - by country','Between 144 and 138 deg West; northern hemisphere. Canada - British Columbia (BC); Yukon. United States (USA) - Alaska (AK).',0.0,84.0,-144.0,-138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2013,'World - S hemisphere - 144 to 138 deg W - by country','Between 144 and 138 deg West; southern hemisphere.',-80.0,0.0,-144.0,-138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2014,'World - N hemisphere - 138 to 132 deg W - by country','Between 138 and 132 deg West; northern hemisphere. Canada - British Columbia (BC); North West Territiories; Yukon. United States (USA) - Alaska (AK).',0.0,84.0,-138.0,-132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2015,'World - S hemisphere - 138 to 132 deg W - by country','Between 138 and 132 deg West; southern hemisphere.',-80.0,0.0,-138.0,-132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2016,'World - N hemisphere - 132 to 126 deg W - by country','Between 132 and 126 deg West; northern hemisphere. Canada - British Columbia (BC); North West Territories; Yukon. United States (USA) - Alaska (AK).',0.0,84.0,-132.0,-126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2017,'World - S hemisphere - 132 to 126 deg W - by country','Between 132 and 126 deg West; southern hemisphere.',-80.0,0.0,-132.0,-126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2018,'World - N hemisphere - 126 to 120 deg W - by country','Between 126 and 120 deg West; northern hemisphere. Canada - British Columbia (BC); North West Territories; Nunavut; Yukon. United States (USA) - Alaska (AK).',0.0,84.0,-126.0,-120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2019,'World - S hemisphere - 126 to 120 deg W - by country','Between 126 and 120 deg West; southern hemisphere.',-80.0,0.0,-126.0,-120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2020,'World - N hemisphere - 120 to 114 deg W - by country','Between 120 and 114 deg West; northern hemisphere. Canada - Alberta; British Columbia (BC); North West Territories; Nunavut. Mexico. United States (USA).',0.0,84.0,-120.0,-114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2021,'World - S hemisphere - 120 to 114 deg W - by country','Between 120 and 114 deg West; southern hemisphere.',-80.0,0.0,-120.0,-114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2022,'World - N hemisphere - 114 to 108 deg W - by country','Between 114 and 108 deg West; northern hemisphere. Canada - Alberta; North West Territories; Nunavut; Saskatchewan.  Mexico.  United States (USA).',0.0,84.0,-114.0,-108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2023,'World - S hemisphere - 114 to 108 deg W - by country','Between 114 and 108 deg West; southern hemisphere.',-80.0,0.0,-114.0,-108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2024,'World - N hemisphere - 108 to 102 deg W - by country','Between 108 and 102 deg West; northern hemisphere. Canada - North West Territories; Nunavut; Saskatchewan.  Mexico.  United States (USA).',0.0,84.0,-108.0,-102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2025,'World - S hemisphere - 108 to 102 deg W - by country','Between 108 and 102 deg West; southern hemisphere.',-80.0,0.0,-108.0,-102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2026,'World - N hemisphere - 102 to 96 deg W - by country','Between 102 and 96 deg West; northern hemisphere. Canada - Manitoba; Nunavut; Saskatchewan.  Mexico.  United States (USA).',0.0,84.0,-102.0,-96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2027,'World - S hemisphere - 102 to 96 deg W - by country','Between 102 and 96 deg West; southern hemisphere.',-80.0,0.0,-102.0,-96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2028,'World - N hemisphere - 96 to 90 deg W deg W - by country','Between 96 and 90 deg West; northern hemisphere. Canada - Manitoba; Nunavut; Ontario.  Ecuador -Galapagos. Guatemala.  Mexico.  United States (USA).',0.0,84.0,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2006-07-30','2005.144 2006.',0),
(2029,'World - S hemisphere - 96 to 90 deg W - by country','Between 96 and 90 deg West; southern hemisphere. Ecuador - Galapagos.',-80.0,0.0,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2006-07-30','2005.144',0),
(2030,'World - N hemisphere - 90 to 84 deg W - by country','Between 90 and 84 deg West; northern hemisphere. Belize. Canada - Manitoba; Nunavut; Ontario.  Costa Rica. Cuba. Ecuador - Galapagos. El Salvador. Guatemala. Honduras. Mexico. Nicaragua. Puerto Rico. United States (USA).',0.0,84.0,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2006-07-30','2005.144',0),
(2031,'World - S hemisphere - 90 to 84 deg W - by country','Between 90 and 84 deg West; southern hemisphere. Ecuador - Galapagos.',-80.0,0.0,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2006-07-30','2005.144',0),
(2032,'World - N hemisphere - 84 to 78 deg W - by country','Between 84 and 78 deg West; northern hemisphere. Bahamas. Ecuador - north of equator. Canada - Nunavut; Ontario; Quebec.  Cayman Islands.  Colombia. Costa Rica. Jamaica. Nicaragua. Panama. Puerto Rico. United States (USA).',0.0,84.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2033,'World - S hemisphere - 84 to 78 deg W - by country','Between 84 and 78 deg West; southern hemisphere. Ecuador. Peru.',-80.0,0.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2034,'World - N hemisphere - 78 to 72 deg W - by country','Between 78 and 72 deg West; northern hemisphere. Bahamas. Canada - Nunavut; Ontario; Quebec. Colombia. Cuba. Ecuador. Greenland. Haiti. Jamica. Panama. Turks and Caicos Islands. United States (USA). Venezuela.',0.0,84.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2035,'World - S hemisphere - 78 to 72 deg W - by country','Between 78 and 72 deg West; southern hemisphere. Argentina. Brazil. Chile. Colombia. Ecuador. Peru.',-80.0,0.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2036,'World - N hemisphere - 72 to 66 deg W - by country','Between 72 and 66 deg West; northern hemisphere. Aruba. Bahamas. Brazil. Canada - New Brunswick (NB); Labrador; Nunavut; Nova Scotia (NS); Quebec. Colombia. Dominican Republic. Greenland. Netherlands Antilles. Puerto Rico. Turks and Caicos Islands. United States. Venezuela.',0.0,84.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2005.144 2006.463',0),
(2037,'World - S hemisphere - 72 to 66 deg W - by country','Between 72 and 66 deg West; southern hemisphere. Argentina. Bolivia. Brazil. Chile. Colombia. Peru.',-80.0,0.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2038,'World - N hemisphere - 66 to 60 deg W - by country','Between 66 and 60 deg West; northern hemisphere. Anguilla. Antigua & Barbuda. Bermuda. Brazil. Canada - New Brunswick (NB); Labrador; Nova Scotia (NS); Nunavut; Prince Edward Island (PEI); Quebec. Dominica. Greenland. Grenada. Guadeloupe. Guyana. Martinique. Montserrat. Saint Kitts and Nevis. Saint Lucia. Saint Vncent and the Grenadines. Trinidad and Tobago. Venezuela. Virgin islands.',0.0,84.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2005.144 2006.463',0),
(2039,'World - S hemisphere - 66 to 60 deg W - by country','Between 66 and 60 deg West; southern hemisphere. Argentina. Bolivia. Brazil. Falkland Islands (Malvinas). Paraguay.',-80.0,0.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2040,'World - N hemisphere - 60 to 54deg W - by country','Between 60 and 54 deg West; northern hemisphere. Barbados. Brazil. Canada - Newfoundland and Labrador, Quebec. French Guiana. Greenland. Guyana. St. Pierre and Miquelon. Suriname.',0.0,84.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2005.144 2006.40',0),
(2041,'World - S hemisphere - 60 to 54 deg W - by country','Between 60 and 54 deg West; southern hemisphere. Argentina. Bolivia. Brazil. Falkland Islands (Malvinas). Paraguay. Uruguay.',-80.0,0.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2042,'World - N hemisphere - 54 to 48 deg W - by country','Between 54 and 48 deg West; northern hemisphere. Brazil. Canada - Newfoundland. French Guiana. Greenland.',0.0,84.0,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2043,'World - S hemisphere - 54 to 48 deg W - by country','Between 54 and 48 deg West; southern hemisphere. Brazil.  Uruguay.',-80.0,0.0,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2044,'World - N hemisphere - 48 to 42 deg W - by country','Between 48 and 42 deg West; northern hemisphere. Greenland.',0.0,84.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2045,'World - S hemisphere - 48 to 42 deg W - by country','Between 48 and 42 deg West; southern hemisphere. Brazil.',-80.0,0.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2046,'World - N hemisphere - 42 to 36 deg W - by country','Between 42 and 36 deg West; northern hemisphere. Greenland.',0.0,84.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2047,'World - S hemisphere - 42 to 36 deg W - by country','Between 42 and 36 deg West; southern hemisphere. Brazil. South Georgia and the South Sandwich Islands.',-80.0,0.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2048,'World - N hemisphere - 36 to 30 deg W - by country','Between 36 and 30 deg West; northern hemisphere. Greenland.',0.0,84.0,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2049,'World - S hemisphere - 36 to 30 deg W - by country','Between 36 and 30 deg West; southern hemisphere. Brazil.',-80.0,0.0,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2050,'World - N hemisphere - 30 to 24 deg W - by country','Between 30 and 24 deg West; northern hemisphere. Greenland. Iceland.',0.0,84.0,-30.0,-24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2051,'World - S hemisphere - 30 to 24 deg W - by country','Between 30 and 24 deg West; southern hemisphere.',-80.0,0.0,-30.0,-24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2052,'World - N hemisphere - 24 to 18 deg W - by country','Between 24 and 18 deg West; northern hemisphere. Greenland. Iceland.',0.0,84.0,-24.0,-18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2053,'World - S hemisphere - 24 to 18 deg W - by country','Between 24 and 18 deg West; southern hemisphere.',-80.0,0.0,-24.0,-18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2054,'World - N hemisphere - 18 to 12 deg W - by country','Between 18 and 12 deg West; northern hemisphere. Gambia. Greenland. Guinea. Guinea-Bissau. Iceland. Ireland - offshore Porcupine Basin. Mauritania. Morocco. Senegal. Sierra Leone. Western Sahara.',0.0,84.0,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2055,'World - S hemisphere - 18 to 12 deg W - by country','Between 18 and 12 deg West; southern hemisphere.',-80.0,0.0,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2056,'World - N hemisphere - 12 to 6 deg W - by country','Between 12 and 6 deg West; northern hemisphere. Algeria. Cote D''Ivoire (Ivory Coast). Faroe Islands. Guinea. Ireland. Jan Mayen. Mali. Mauritania. Morocco. Portugal. Sierra Leone. Spain. United Kingdom (UK). Western Sahara.',0.0,84.0,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2057,'World - S hemisphere - 12 to 6 deg W - by country','Between 12 and 6 deg West; southern hemisphere.',-80.0,0.0,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2058,'World - N hemisphere - 6 to 0 deg W - by country','Between 6 deg West and 0 deg East; northern hemisphere. Algeria. Burkina Faso. Cote'' Ivoire (Ivory Coast). Faroe Islands - offshore. France. Ghana. Gibraltar. Ireland - offshore Irish Sea. Mali. Mauritania. Morocco. Spain. United Kingdom (UK).',0.0,84.0,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2059,'World - S hemisphere - 6 to 0 deg W - by country','Between 6 deg West and 0 deg East; southern hemisphere.',-80.0,0.0,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2060,'World - N hemisphere - 0 to 6 deg E - by country','Between 0 and 6 deg East; northern hemisphere. Algeria. Andorra. Benin. Burkina Faso. Denmark - North Sea. France. Germany - North Sea. Ghana. Luxembourg. Mali. Netherlands. Niger. Nigeria. Norway. Spain. Togo. United Kingdom (UK) - North Sea.',0.0,84.0,0.0,6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2061,'World - S hemisphere - 0 to 6 deg E - by country','Between 0 and 6 deg East; southern hemisphere.',-80.0,0.0,0.0,6.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2062,'World - N hemisphere - 6 to 12 deg E - by country','Between 6 and 12 deg East; northern hemisphere. Algeria. Austria. Cameroon. Denmark. Equatorial Guinea. France. Gabon. Germany. Italy. Libya. Liechtenstein. Monaco. Netherlands. Niger. Nigeria. Norway. Sao Tome and Principe. Svalbard. Sweden. Switzerland. Tunisia. Vatican City State.',0.0,84.0,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2063,'World - S hemisphere - 6 to 12 deg E - by country','Between 6 and 12 deg East; southern hemisphere. Angola. Congo. Gabon. Namibia.',-80.0,0.0,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2064,'World - N hemisphere - 12 to 18 deg E - by country','Between 12 and 18 deg East; northern hemisphere. Austria. Bosnia and Herzegowina. Cameroon. Central African Republic. Chad. Congo. Croatia. Czech Republic. Democratic Republic of the Congo (Zaire). Gabon. Germany. Hungary. Italy. Libya. Malta. Niger. Nigeria. Norway. Poland. San Marino. Slovakia. Slovenia. Svalbard. Sweden. Vatican City State.',0.0,84.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.144 2005.89',0),
(2065,'World - S hemisphere - 12 to 18 deg E - by country','Between 12 and 18 deg East; southern hemisphere. Angola. Congo. Democratic Republic of the Congo (Zaire). Gabon. Namibia. South Africa.',-80.0,0.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2066,'World - N hemisphere - 18 to 24 deg E - by country','Between 18 and 24 deg East; northern hemisphere. Albania. Belarus. Bosnia and Herzegowina. Bulgaria. Central African Republic. Chad. Croatia. Democratic Republic of the Congo (Zaire). Estonia. Finland. FYR Macedonia. Greece. Hungary. Italy. Latvia. Libya. Lithuania. Norway, including Svalbard and Bjornoys. Poland. Romania. Russian Federation. Slovakia. Sudan. Sweden. Ukraine. Yugoslavia.',0.0,84.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2067,'World - S hemisphere - 18 to 24 deg E - by country','Between 18 and 24 deg East; southern hemisphere. Angola. Botswana. Democratic Republic of the Congo (Zaire). Namibia. South Africa. Zambia.',-80.0,0.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2068,'World - N hemisphere - 24 to 30 deg E - by country','Between 24 and 30 deg East; northern hemisphere. Belarus. Bulgaria. Central African Republic. Democratic Republic of the Congo (Zaire). Egypt. Estonia. Finland. Greece. Latvia. Lesotho. Libya. Lithuania. Moldova. Norway. Poland. Romania. Russian Federation. Sudan. Svalbard. Turkey. Uganda. Ukraine.',0.0,84.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2069,'World - S hemisphere - 24 to 30 deg E - by country','Between 24 and 30 deg East; southern hemisphere. Botswana. Burundi. Democratic Republic of the Congo (Zaire). Rwanda. South Africa. Tanzania. Uganda. Zambia. Zimbabwe.',-80.0,0.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2070,'World - N hemisphere - 30 to 36 deg E - by country','Between 30 and 36 deg East; northern hemisphere. Belarus. Cyprus. Egypt. Ethiopia. Finland. Israel. Jordan. Kenya. Lebanon. Norway. Russian Federation. Saudi Arabia. Sudan. Syria. Turkey. Uganda. Ukraine.',0.0,84.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2071,'World - S hemisphere - 30 to 36 deg E - by country','Between 30 and 36 deg East; southern hemisphere. Burundi. Kenya. Malawi. Mozambique. Rwanda. South Africa. Swaziland. Tanzania. Uganda. Zambia. Zimbabwe.',-80.0,0.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2072,'World - N hemisphere - 36 to 42 deg E - by country','Between 36 and 42 deg East; northern hemisphere. Djibouti. Egypt. Eritrea. Ethiopia. Georgia. Iraq. Jordan. Kenya. Lebanon. Russian Federation. Saudi Arabia. Somalia. Sudan. Syria. Turkey. Ukraine.',0.0,84.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2073,'World - S hemisphere - 36 to 42 deg E - by country','Between 36 and 42 deg East; southern hemisphere. Kenya. Mozambique. Tanzania.',-80.0,0.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2074,'World - N hemisphere - 42 to 48 deg E - by country','Between 42 and 48 deg East; northern hemisphere. Armenia. Azerbaijan. Djibouti. Eritrea. Ethiopia. Georgia. Islamic Republic of Iran. Iraq. kazakhstan. Kuwait. Russian Federation. Saudi Arabia. Somalia. Turkey. Yemen.',0.0,84.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2075,'World - S hemisphere - 42 to 48 deg E - by country','Between 42 and 48 deg East; southern hemisphere. Madagascar.',-80.0,0.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2076,'World - N hemisphere - 48 to 54 deg E - by country','Between 48 and 54 deg East; northern hemisphere. Azerbaijan. Bahrain. Islamic Republic of Iran. Iraq. Kazakhstan. Kuwait. Oman. Qatar. Russian Federation. Saudi Arabia. Somalia. Turkmenistan. United Arab Emirates. Yemen.',0.0,84.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2006-06-02','2005.144 2006.34',0),
(2077,'World - S hemisphere - 48 to 54 deg E - by country','Between 48 and 54 deg East; southern hemisphere. Madagascar.',-80.0,0.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2078,'World - N hemisphere - 54 to 60 deg E - by country','Between 54 and 60 deg East; northern hemisphere. Islamic Republic of Iran. kazakhstan. Oman. Russian Federation. Saudi Arabia. Turkmenistan. United Arab Emirates. Uzbekistan.',0.0,84.0,54.0,60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2079,'World - S hemisphere - 54 to 60 deg E - by country','Between 54 and 60 deg East; southern hemisphere. Seychelles.',-80.0,0.0,54.0,60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2080,'World - N hemisphere - 60 to 66 deg E - by country','Between 60 and 66 deg East; northern hemisphere. Afghanistan. Islamic Republic of Iran. kazakhstan. Pakistan. Russian Federation. Turkmenistan.  Uzbekistan.',0.0,84.0,60.0,66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2081,'World - S hemisphere - 60 to 66 deg E - by country','Between 60 and 66 deg East; southern hemisphere.',-80.0,0.0,60.0,66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2082,'World - N hemisphere - 66 to 72 deg E - by country','Between 66 and 72 deg East; northern hemisphere. Afghanistan. India. Kazakhstan. Kyrgyzstan. Pakistan. Russian Federation. Tajikistan. Uzbekistan.',0.0,84.0,66.0,72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2083,'World - S hemisphere - 66 to 72 deg E - by country','Between 66 and 72 deg East; southern hemisphere.',-80.0,0.0,66.0,72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2084,'World - N hemisphere - 72 to 78 deg E - by country','Between 72 and 78 deg East; northern hemisphere. China. India. Kazakhstan. Kyrgyzstan. Maldives. Pakistan. Russian Federation. Tajikistan.',0.0,84.0,72.0,78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2085,'World - S hemisphere - 72 to 78 deg E - by country','Between 72 and 78 deg East; southern hemisphere.',-80.0,0.0,72.0,78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2086,'World - N hemisphere - 78 to 84 deg E - by country','Between 78 and 84 deg East; northern hemisphere. China. India. Kazakhstan. Kyrgyzstan. Nepal. Russian Federation. Sri Lanka.',0.0,84.0,78.0,84.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2087,'World - S hemisphere - 78 to 84 deg E - by country','Between 78 and 84 deg East; southern hemisphere.',-80.0,0.0,78.0,84.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2088,'World - N hemisphere - 84 to 90 deg E - by country','Between 84 and 90 deg East; northern hemisphere. Bangladesh. Bhutan. China. India. Kazakhstan. Mongolia. Nepal. Russian Federation.',0.0,84.0,84.0,90.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2089,'World - S hemisphere - 84 to 90 deg E - by country','Between 84 and 90 deg East; southern hemisphere.',-80.0,0.0,84.0,90.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2090,'World - N hemisphere - 90 to 96 deg E - by country','Between 90 and 96 deg East; northern hemisphere. Bangladesh. Bhutan. China. Indonesia. Mongolia. Myanmar (Burma). Russian Federation.',0.0,84.0,90.0,96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2091,'World - S hemisphere - 90 to 96 deg E - by country','Between 90 and 96 deg East; southern hemisphere.',-80.0,0.0,90.0,96.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2092,'World - N hemisphere - 96 to 102 deg E - by country','Between 96 and 102 deg East; northern hemisphere. China. Indonesia. Laos. Malaysia - West Malaysia. Mongolia. Myanmar (Burma). Russian Federation. Thailand.',0.0,84.0,96.0,102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2093,'World - S hemisphere - 96 to 102 deg E - by country','Between 96 and 102 deg East; southern hemisphere. Indonesia.',-80.0,0.0,96.0,102.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2094,'World - N hemisphere - 102 to 108 deg E - by country','Between 102 and 108 deg East; northern hemisphere. Cambodia. China. Indonesia. Laos. Malaysia - West Malaysia. Mongolia. Russian Federation. Singapore. Thailand. Vietnam.',0.0,84.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2095,'World - S hemisphere - 102 to 108 deg E - by country','Between 102 and 108 deg East; southern hemisphere. Indonesia.',-80.0,0.0,102.0,108.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2096,'World - N hemisphere - 108 to 114 deg E - by country','Between 108 and 114 deg East; northern hemisphere. China. Hong Kong. Indonesia. Macau. Malaysia - East Malaysia - Sarawak. Mongolia. Russian Federation. Vietnam.',0.0,84.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2097,'World - S hemisphere - 108 to 114 deg E - by country','Between 108 and 114 deg East; southern hemisphere. Australia. Indonesia.',-80.0,0.0,108.0,114.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2098,'World - N hemisphere - 114 to 120 deg E - by country','Between 114 and 120 deg East; northern hemisphere. Brunei. China. Hong Kong. Indonesia. Malaysia - East Malaysia - Sarawak. Mongolia. Philippines. Russian Federation. Taiwan.',0.0,84.0,114.0,120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2099,'World - S hemisphere - 114 to 120 deg E - by country','Between 114 and 120 deg East; southern hemisphere. Australia. Indonesia.',-80.0,0.0,114.0,120.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2100,'World - N hemisphere - 120 to 126 deg E - by country','Between 120 and 126 deg East; northern hemisphere. China. Indonesia. Japan. North Korea. Philippines. Russian Federation.  South Korea. Taiwan.',0.0,84.0,120.0,126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2101,'World - S hemisphere - 120 to 126 deg E - by country','Between 120 and 126 deg East; southern hemisphere. Australia. East Timor. Indonesia.',-80.0,0.0,120.0,126.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2102,'World - N hemisphere - 126 to 132 deg E - by country','Between 126 and 132 deg East; northern hemisphere. China. Indonesia. Japan. North Korea. Russian Federation. South Korea.',0.0,84.0,126.0,132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2103,'World - S hemisphere - 126 to 132 deg E - by country','Between 126 and 132 deg East; southern hemisphere. Australia. East Timor. Indonesia.',-80.0,0.0,126.0,132.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2104,'World - N hemisphere - 132 to 138 deg E - by country','Between 132 and 138 deg East; northern hemisphere. China. Japan. Russian Federation.',0.0,84.0,132.0,138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2105,'World - S hemisphere - 132 to 138 deg E - by country','Between 132 and 138 deg East; southern hemisphere. Australia.  Indonesia.',-80.0,0.0,132.0,138.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2106,'World - N hemisphere - 138 to 144 deg E - by country','Between 138 and 144 deg East; northern hemisphere. Japan. Russian Federation.',0.0,84.0,138.0,144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2107,'World - S hemisphere - 138 to 144 deg E - by country','Between 138 and 144 deg East; southern hemisphere. Australia. Indonesia. Papua New Guinea.',-80.0,0.0,138.0,144.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2108,'World - N hemisphere - 144 to 150 deg E - by country','Between 144 and 150 deg East; northern hemisphere. Japan. Russian Federation.',0.0,84.0,144.0,150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2109,'World - S hemisphere - 144 to 150 deg E - by country','Between 144 and 150 deg East; southern hemisphere. Australia. Papua New Guinea.',-80.0,0.0,144.0,150.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2110,'World - N hemisphere - 150 to 156 deg E - by country','Between 150 and 156 deg East; northern hemisphere. Russian Federation.',0.0,84.0,150.0,156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2111,'World - S hemisphere - 150 to 156 deg E - by country','Between 150 and 156 deg East; southern hemisphere. Australia. Papua New Guinea.',-80.0,0.0,150.0,156.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2112,'World - N hemisphere - 156 to 162 deg E - by country','Between 156 and 162 deg East; northern hemisphere. Russian Federation.',0.0,84.0,156.0,162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2113,'World - S hemisphere - 156 to 162 deg E - by country','Between 156 and 162 deg East; southern hemisphere.',-80.0,0.0,156.0,162.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2114,'World - N hemisphere - 162 to 168 deg E - by country','Between 162 and 168 deg East; northern hemisphere. Russian Federation.',0.0,84.0,162.0,168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2115,'World - S hemisphere - 162 to 168 deg E - by country','Between 162 and 168 deg East; southern hemisphere.',-80.0,0.0,162.0,168.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2116,'World - N hemisphere - 168 to 168 deg E - by country','Between 168 and 174 deg East; northern hemisphere. Russian Federation; United States (USA) - Alaska (AK).',0.0,84.0,168.0,174.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.144 2005.52',0),
(2117,'World - S hemisphere - 168 to 174 deg E - by country','Between 168 and 174 deg East; southern hemisphere. New Zealand.',-80.0,0.0,168.0,174.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2118,'World - N hemisphere - 174 to 180 deg E - by country','Between 174 and 180 deg East; northern hemisphere. Russian Federation; United States (USA) - Alaska (AK).',0.0,84.0,174.0,180.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.144 2005.52',0),
(2119,'World - S hemisphere - 174 to 180 deg E - by country','Between 174 and 180 deg East; southern hemisphere. New Zealand.',-80.0,0.0,174.0,180.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2120,'Guatemala - N of 15 deg 50 min N','Guatemala - north of 15 deg 50 min North.',15.83,18.92,-94.95,-83.84,'','','',NULL,'','EPSG','EPSG','1999-08-16','',0),
(2121,'Guatemala - S of 15 deg 50 min N','Guatemala - south of 15 deg 50 min North.',11.17,15.83,-94.95,-83.84,'','','',NULL,'','EPSG','EPSG','2000-01-06','',0),
(2122,'Europe - 18 to 12 deg W and ETRS89 by country','Europe - between 18 and 12 deg West - United Kingdom (UKCS) offshore.',56.83,60.0,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2123,'Europe - 12 to 6 deg W and ETRS89 by country','Europe - between 12 and 6 deg West - Faroe Islands; United Kingdom (UKCS) offshore.',48.15,60.0,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2006-06-22','2005.14 2005.471',0),
(2124,'Europe - 6 to 0 deg W and ETRS89 by country','Europe - between 6 and 0 deg West.',34.75,62.33,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2125,'Europe - 0 to 6 deg E and ETRS89 by country','Europe - between 0 and 6 deg East.',38.5,62.33,0.0,6.0,'','','',NULL,'Note: Norway onshore west of 6 deg East uses zone 32.','EPSG','EPSG','2005-04-12','2005.14',0),
(2126,'Europe - 6 to 12 deg E and ETRS89 by country','Europe - between 6 and 12 deg East - Norway - onshore west of 12 deg East.',57.9,65.67,5.05,12.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2127,'Europe - 12 to 18 deg E and ETRS89 by country','Europe - between 12 and 18 deg East - Germany - Brandenburg; Norway and Svalbard between 12 and 21 deg East.',35.5,80.05,12.0,21.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2128,'Europe - 18 to 24 deg E and ETRS89 by country','Europe - between 18 and 24 deg East.',34.8,75.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2129,'Europe - 24 to 30 deg E and ETRS89 by country','Europe - between 24 and 30 deg East - Norway and Svalbard between 21 and 30 deg East.',69.1,80.05,21.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2130,'Europe - 0 to 36 deg E and ETRS89 by country','Europe - between 30 and 36 deg East.',34.5,75.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2131,'Europe - 36 to 42 deg E and ETRS89 by country','Europe - between 36 and 42 deg East.',35.75,75.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.142005.14',0),
(2132,'Europe - 42 to 48 deg E and ETRS89 by country','Europe - between 42 and 48 deg East.',37.0,41.65,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2133,'United States (USA) - 168 to 162 deg W','United States (USA) - between 168 and 162 deg West. Alaska and offshore continental shelf (OCS).',49.6,74.3,-168.0,-162.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.52',0),
(2134,'United States (USA) - 162 to 156 deg W','United States (USA) - between 162 and 156 deg West. Alaska and offshore continental shelf (OCS).',51.1,74.7,-162.0,-156.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.52',0),
(2135,'United States (USA) - 156 to 150 deg W','United States (USA) - between 156 and 150 deg West. Alaska and offshore continental shelf (OCS).',52.1,74.7,-156.0,-150.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.52',0),
(2136,'United States (USA) - 150 to 144 deg W','United States (USA) - between 150 and 144 deg West. Alaska and offshore continental shelf (OCS).',54.0,74.2,-150.0,-144.0,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.52',0),
(2137,'North America - 144 to 138 deg W','North America - between 144 and 138 deg West. Canada - British Columbia (BC); Yukon. United States (USA) - Alaska (AK).',58.7,71.33,-144.0,-138.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(2138,'North America - 138 to 132 deg W','North America - between 138 and 132 deg West. Canada - British Columbia (BC); North West Territiories; Yukon. United States (USA) - Alaska (AK).',52.5,71.0,-138.0,-132.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(2139,'North America - 132 to 126 deg W','North America - between 132 and 126 deg West. Canada - British Columbia (BC); North West Territories; Yukon. United States (USA) - Alaska (AK).',49.0,71.0,-132.0,-126.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(2140,'North America - 126 to 120 deg W','North America - between 126 and 120 deg West. Canada - British Columbia (BC); North West Territories; Nunavut; Yukon. United States (USA) - Alaska (AK).',34.4,77.0,-126.0,-120.0,'','','',NULL,'','EPSG','EPSG','2004-05-21','2004.39',0),
(2141,'North America - 120 to 114 deg W and NAD27 by country','North America - between 120 and 114 deg West. Canada - Alberta; British Columbia (BC); North West Territories; Nunavut. Mexico. United States (USA).',27.0,78.33,-120.0,-114.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2004.464',0),
(2142,'North America - 114 to 108 deg W and NAD27 by country','North America - between 114 and 108 deg West. Canada - Alberta; North West Territories; Nunavut; Saskatchewan. Mexico. United States (USA).',24.83,79.25,-114.0,-108.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2004.464',0),
(2143,'North America - 108 to 102 deg W and NAD27 by country','North America - between 108 and 102 deg West. Canada - North West Territories; Nunavut; Saskatchewan. Mexico. United States (USA).',17.83,80.1,-108.0,-102.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2004.464',0),
(2144,'North America - 102 to 96 deg W and NAD27 by country','North America - between 102 and 96 deg West. Canada - Manitoba; Nunavut; Saskatchewan. Mexico. United States (USA).',15.5,81.0,-102.0,-96.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2004.464',0),
(2145,'North America - 96 to 90 deg W and NAD27 by country','North America - between 96 and 90 deg West. Canada - Manitoba; Nunavut; Ontario.  Guatemala.  Mexico.  United States (USA).',13.57,82.0,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2006-06-12','',0),
(2146,'North America - 90 to 84 deg W and NAD27 by country','North America - between 90 and 84 deg West. Belize. Canada - Manitoba; Nunavut; Ontario. Costa Rica. Cuba. El Salvador. Guatemala. Honduras. Mexico. Nicaragua. United States (USA).',9.1,82.5,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2006-06-12','',0),
(2147,'North America - 84 to 78 deg W and NAD27 by country','North America - between 84 and 78 deg West. Canada - Nunavut; Ontario; Quebec. Costa Rica. Cuba. Nicaragua. United States (USA).',8.0,83.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2006-06-12','',0),
(2148,'North America - 78 to 72 deg W and NAD27 by country','North America - between 78 and 72 deg West. Canada - Nunavut; Ontario; Quebec. Cuba. United States (USA).',19.6,83.2,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2006-06-12','',0),
(2149,'North America - 72 to 66 deg W','North America - between 72 and 66 deg West. Canada - New Brunswick (NB); Labrador; Nunavut; Nova Scotia (NS); Quebec. United States (USA).',40.8,83.2,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2004.463',0),
(2150,'North America - 66 to 60 deg W','North America - between 66 and 60 deg West. Canada - New Brunswick (NB); Labrador; Nova Scotia (NS); Nunavut; Prince Edward Island (PEI); Quebec. United States (USA) offshore Atlantic',43.33,83.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(2151,'Canada - 60 to 54 deg W','Canada south of 60 deg North and between 60 and 54 deg West  - Newfoundland and Labrador; Quebec.',46.71,55.5,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2006.463',0),
(2152,'Canada - 54 to 48 deg W','Canada between 54 and 48 deg West - Newfoundland.',46.5,49.7,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(2153,'Canada - 48 to 42 deg W','Canada offshore Atlantic - between 48 and 42 deg West.',44.0,48.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','1995-06-02','',0),
(2154,'United States (USA) - Alabama - SPCS - E','United States (USA) - Alabama east of approximately 86d 37m West - counties Barbour; Bullock; Calhoun; Chambers; Cherokee; Clay; Cleburne; Coffee; Coosa; Covington; Crenshaw; Dale; De Kalb; Elmore; Etowah; Geneva; Henry; Houston; Jackson; Lee; Macon; Madison; Marshall; Montgomery; Pike; Randolph; Russell; St.Clair; Talladega; Tallapoosa.',31.0,35.0,-86.79,-84.89,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2155,'United States (USA) - Alabama - SPCS - W','United States (USA) - Alabama west of approximately 86d 37m West - counties Autauga; Baldwin; Bibb; Blount; Butler; Chilton; Choctaw; Clarke; Colbert; Conecuh; Cullman; Dallas; Escambia; Fayette; Franklin; Greene; Hale; Jefferson; Lamar; Lauderdale; Lawrence; Limestone; Lowndes; Marengo; Marion; Mobile; Monroe; Morgan; Perry; Pickens; Shelby; Sumter; Tuscaloosa; Walker; Washington; Wilcox; Winston.',30.2,35.0,-88.48,-86.3,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2156,'United States (USA) - Alaska - Panhandle','United States (USA) - Alaska - east of 141 deg West; i.e. Panhandle.',54.5,60.36,-141.0,-129.99,'','','',NULL,'','EPSG','EPSG','1996-09-12','',0),
(2157,'United States (USA) - Alaska - Aleutian Islands','United States (USA) - Alaska - Aleutian Islands.',51.2,55.05,172.4,-163.05,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','1999-04-22','',0),
(2158,'United States (USA) - Alaska - 144 to 141 deg W','United States (USA) - Alaska - between 144 and 141 deg West.',51.35,71.35,-144.0,-141.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2159,'United States (USA) - Alaska - 148 to 144 deg W','United States (USA) - Alaska - between 148 and 144 deg West.',51.35,71.35,-148.0,-144.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2160,'United States (USA) - Alaska - 152 to 148 deg W','United States (USA) - Alaska - between 152 and 148 deg West.',51.35,71.35,-152.0,-148.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2161,'United States (USA) - Alaska - 156 to 152 deg W','United States (USA) - Alaska - between 156 and 152 deg West.',51.35,71.35,-156.0,-152.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2162,'United States (USA) - Alaska - 160 to 156 deg W','United States (USA) - Alaska - between 160 and 156 deg West.',51.35,71.35,-160.0,-156.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2163,'United States (USA) - Alaska - 164 to 160 deg W','United States (USA) - Alaska - between 164 and 160 deg West.',51.35,71.35,-164.0,-160.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2164,'United States (USA) - Alaska - N of 54.5 deg N; 168 to 164 deg W','United States (USA) - Alaska - north of 54d 30m North and between 168 to 164 deg West.',54.5,71.35,-168.0,-164.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2165,'United States (USA) - Alaska - N of 54.5 deg N; W of 168 deg W','United States (USA) - Alaska - north of 54d 30m North and west of 168 deg West.',54.5,63.79,-173.11,-168.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2166,'United States (USA) - Arizona - SPCS - central','United States (USA) - Arizona between approximately 110d 45m and 113d 20m West - counties Coconino; Maricopa; Pima; Pinal; Santa Cruz; Yavapai.',31.33,37.0,-113.33,-110.45,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2167,'United States (USA) - Arizona - SPCS - E','United States (USA) - Arizona east of approximately 110d 45m West - counties Apache; Cochise; Gila; Graham; Greenlee; Navajo.',31.33,37.0,-111.72,-109.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2168,'United States (USA) - Arizona - SPCS - W','United States (USA) - Arizona west of approximately 113d 20m West - counties La Paz; Mohave; Yuma.',32.04,37.0,-114.75,-112.52,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2169,'United States (USA) - Arkansas - SPCS - N','United States (USA) - Arkansas north of approximately 34d 50m North - counties Baxter; Benton; Boone; Carroll; Clay; Cleburne; Conway; Craighead; Crawford; Crittenden; Cross; Faulkner; Franklin; Fulton; Greene; Independence; Izard; Jackson; Johnson; Lawrence; Logan; Madison; Marion; Mississippi; Newton; Perry; Poinsett; Pope; Randolph; Scott; Searcy; Sebastian; Sharp; St. Francis; Stone; Van Buren; Washington; White; Woodruff; Yell.',34.66,36.49,-94.63,-89.65,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2170,'United States (USA) - Arkansas - SPCS - S','United States (USA) - Arkansas south of approximately 34d 50m North - counties Arkansas; Ashley; Bradley; Calhoun; Chicot; Clark; Cleveland; Columbia; Dallas; Desha; Drew; Garland; Grant; Hempstead; Hot Spring; Howard; Jefferson; Lafayette; Lee; Lincoln; Little River; Lonoke; Miller; Monroe; Montgomery; Nevada; Ouachita; Phillips; Pike; Polk; Prairie; Pulaski; Saline; Sevier; Union.',33.0,35.09,-94.49,-90.06,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2171,'United States (USA) - GoM OCS - W of 96 deg W','United States (USA) - Gulf of Mexico outer continental shelf (GoM OCS) west of approximately 96 deg West - protraction areas Corpus Christi; Port Isabel.',25.97,27.61,-96.98,-95.87,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2172,'United States (USA) - GoM OCS - 96 to 90 deg W','United States (USA) - Gulf of Mexico outer continental shelf (GoM OCS) between approximately 96 deg and 90 deg West - protraction areas East Breaks (EB); Alaminos Canyon (AC); Garden Banks (GB); Keathley Canyon (KC); Sigsbee Escarpment; Ewing Bank (EW); Green Canyon (GC); Walker Ridge (WR); Amery Terrace.',25.61,28.68,-95.91,-89.91,'','','',NULL,'','EPSG','EPSG','2006-03-06','2004.59',0),
(2173,'United States (USA) - GoM OCS - 90 to 84 deg W','United States (USA) - Gulf of Mexico outer continental shelf (GoM OCS) between approximately 90 deg and 84 deg West - protraction areas Mobile (MO); Viosca Knoll (VK); Mississippi Canyon (MC); Atwater Valley (AT); Lund; Lund South; Pensacola; Destin Dome (DD); De Soto Canyon; Lloyd; Henderson; Florida Plain; Campeche Escarpment; Apalachicola; Florida Middle Ground; The Elbow; Vernon Basin; Howell Hook; Rankin.',23.97,30.23,-89.94,-83.94,'','','',NULL,'','EPSG','EPSG','2006-03-06','2004.59',0),
(2174,'United States (USA) - GoM OCS - E of 84 deg W','United States (USA) - Gulf of Mexico outer continental shelf (GoM OCS) east of approximately 84 deg West - protraction areas Gainesville; Tarpon Springs; St. Petersburg; Charlotte Harbor; Pulley Ridge; Dry Tortugas; Tortugas Valley; Miami; Key West.',23.82,29.92,-84.08,-81.18,'','','',NULL,'','EPSG','EPSG','2006-03-06','2004.59',0),
(2175,'United States (USA) - California - SPCS - 1','United States (USA) - California north of approximately 40 deg North - counties Del Norte; Humboldt; Lassen; Modoc; Plumas; Shasta; Siskiyou; Tehama; Trinity.',39.6,42.0,-124.42,-120.0,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2176,'United States (USA) - California - SPCS - 2','United States (USA) - California between approximately 40 deg & 38d 15m North - counties Alpine; Amador; Butte; Colusa; El Dorado; Glenn; Lake; Mendocino; Napa; Nevada; Placer; Sacramento; Sierra; Solano; Sonoma; Sutter; Yolo; Yuba.',38.03,40.15,-124.07,-119.54,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2177,'United States (USA) - California - SPCS - 3','United States (USA) - California between approximately 38d 15m & 37d North - counties Alameda; Calaveras; Contra Costa; Madera; Marin; Mariposa; Merced; Mono; San Francisco; San Joaquin; San Mateo; Santa Clara; Santa Cruz; Stanislaus; Tuolumne.',36.74,38.7,-123.09,-117.82,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2178,'United States (USA) - California - SPCS - 4','United States (USA) - California between approximately 37d & 35d 30m North - counties Fresno; Inyo; Kings; Monterey; San Benito; Tulare.',35.78,37.58,-122.0,-115.65,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2179,'United States (USA) - California - SPCS27 - 5','United States (USA) - California between approximately 35d 50m & 34d North excluding LA - counties Kern; San Bernardino; San Luis Obispo; Santa Barbara; Ventura.',33.16,35.81,-121.36,-114.13,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2180,'United States (USA) - California - SPCS - 6','United States (USA) - California south of approximately 38d 30m North - counties Imperial; Orange; Riverside; San Diego.',32.51,34.08,-118.14,-114.43,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2181,'United States (USA) - California - SPCS27 - 7','United States (USA) - California - Los Angeles county.',32.75,34.82,-118.98,-117.63,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2182,'United States (USA) - California - SPCS83 - 5','United States (USA) - California between approximately 35d 50m & 34d North - counties Kern; Los Angeles; San Bernardino; San Luis Obispo; Santa Barbara; Ventura.',32.75,35.81,-121.36,-114.13,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2183,'United States (USA) - Colorado - SPCS - C','United States (USA) - Colorado between approximately 39d 50m & 38d 30m North - counties Arapahoe; Chaffee; Cheyenne; Clear Creek; Delta; Denver; Douglas; Eagle; El Paso; Elbert; Fremont; Garfield; Gunnison; Jefferson; Kit Carson; Lake; Lincoln; Mesa; Park; Pitkin; Summit; Teller.',38.14,40.09,-109.05,-102.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2184,'United States (USA) - Colorado - SPCS - N','United States (USA) - Colorado north of approximately 39d 50m North - counties Adams; Boulder; Gilpin; Grand; Jackson; Larimer; Logan; Moffat; Morgan; Phillips; Rio Blanco; Routt; Sedgwick; Washington; Weld; Yuma.',39.56,41.0,-109.05,-102.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2185,'United States (USA) - Colorado - SPCS - S','United States (USA) - Colorado south of approximately 38d 30m North - counties Alamosa; Archuleta; Baca; Bent; Conejos; Costilla; Crowley; Custer; Dolores; Hinsdale; Huerfano; Kiowa; La Plata; Las Animas; Mineral; Montezuma; Montrose; Otero; Ouray; Prowers; Pueblo; Rio Grande; Saguache; San Juan; San Miguel.',37.0,38.67,-109.05,-102.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2186,'United States (USA) - Florida - SPCS - E','United States (USA) - Florida east of approximately 81d 45m West - counties of Brevard; Broward; Clay; Collier; Dade; Duval; Flagler; Glades; Hendry; Highlands; Indian River; Lake; Martin; Monroe; Nassau; Okeechobee; Orange; Osceola; Palm Beach; Putnam; Seminole; St. Johns; St. Lucie; Volusia.',24.43,30.83,-82.05,-80.02,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2187,'United States (USA) - Florida - SPCS - N','United States (USA) - Florida north of approximately 29d 30m North & west of approximately 82d West - counties of Alachua; Baker; Bay; Bradford; Calhoun; Columbia; Dixie; Escambia; Franklin; Gadsden; Gilchrist; Gulf; Hamilton; Holmes; Jackson; Jefferson; Lafayette; Leon; Liberty; Madison; Okaloosa; Santa Rosa; Suwannee; Taylor; Union; Wakulla; Walton; Washington.',29.28,31.0,-87.64,-82.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2188,'United States (USA) - Florida - SPCS - W','United States (USA) - Florida west of approximately 81d 45m West & south of approximately 29d 30m North - counties of Charlotte; Citrus; De Soto; Hardee; Hernando; Hillsborough; Lee; Levy; Manatee; Marion; Pasco; Pinellas; Polk; Sarasota; Sumter.',26.31,29.59,-83.18,-81.13,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2189,'United States (USA) - Georgia - SPCS - E','United States (USA) - Georgia east of approximately 83d 15m West - counties of Appling; Atkinson; Bacon; Baldwin; Brantley; Bryan; Bulloch; Burke; Camden; Candler; Charlton; Chatham; Clinch; Coffee; Columbia; Dodge; Echols; Effingham; Elbert; Emanuel; Evans; Franklin; Glascock; Glynn; Greene; Hancock; Hart; Jeff Davis; Jefferson; Jenkins; Johnson; Lanier; Laurens; Liberty; Lincoln; Long; Madison; McDuffie; McIntosh; Montgomery; Oglethorpe; Pierce; Richmond; Screven; Stephens; Taliaferro; Tattnall; Telfair; Toombs; Treutlen; Ware; Warren; Washington; Wayne; Wheeler; Wilkes; Wilkinson.',30.35,34.69,-83.46,-80.79,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2190,'United States (USA) - Georgia - SPCS - W','United States (USA) - Georgia west of approximately 83d 15m West - counties of Baker; Banks; Barrow; Bartow; Ben Hill; Berrien; Bibb; Bleckley; Brooks; Butts; Calhoun; Carroll; Catoosa; Chattahoochee; Chattooga; Cherokee; Clarke; Clay; Clayton; Cobb; Colquitt; Cook; Coweta; Crawford; Crisp; Dade; Dawson; De Kalb; Decatur; Dooly; Dougherty; Douglas; Early; Fannin; Fayette; Floyd; Forsyth; Fulton; Gilmer; Gordon; Grady; Gwinnett; Habersham; Hall; Haralson; Harris; Heard; Henry; Houston; Irwin; Jackson; Jasper; Jones; Lamar; Lee; Lowndes; Lumpkin; Macon; Marion; Meriwether; Miller; Mitchell; Monroe; Morgan; Murray; Muscogee; Newton; Oconee; Paulding; Peach; Pickens; Pike; Polk; Pulaski; Putnam; Quitman; Rabun; Randolph; Rockdale; Schley; Seminole; Spalding; Stewart; Sumter; Talbot; Taylor; Terrell; Thomas; Tift; Towns; Troup; Turner; Twiggs; Union; Upson; Walker; Walton; Webster; White; Whitfield; Wilcox; Worth.',30.62,35.0,-85.02,-83.0,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2191,'United States (USA) - Idaho - SPCS - central','United States (USA) - Idaho between approximately 113d & 115d West - counties of Blaine; Butte; Camas; Cassia; Custer; Gooding; Jerome; Lemhi; Lincoln; Minidoka; Twin Falls.',42.0,45.71,-115.3,-112.69,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2192,'United States (USA) - Idaho - SPCS - E','United States (USA) - Idaho east of approximately 113d West - counties of Bannock; Bear Lake; Bingham; Bonneville; Caribou; Clark; Franklin; Fremont; Jefferson; Madison; Oneida; Power; Teton.',42.0,44.76,-113.24,-111.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2193,'United States (USA) - Idaho - SPCS - W','United States (USA) - Idaho - west of approximately 115d West - counties of Ada; Adams; Benewah; Boise; Bonner; Boundary; Canyon; Clearwater; Elmore; Gem; Idaho; Kootenai; Latah; Lewis; Nez Perce; Owyhee; Payette; Shoshone; Valley; Washington.',42.0,49.0,-117.24,-114.3,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2194,'United States (USA) - Illinois - SPCS - E','United States (USA) - Illinois east of approximately 89d 05m West - counties of Boone; Champaign; Clark; Clay; Coles; Cook; Crawford; Cumberland; De Kalb; De Witt; Douglas; Du Page; Edgar; Edwards; Effingham; Fayette; Ford; Franklin; Gallatin; Grundy; Hamilton; Hardin; Iroquois; Jasper; Jefferson; Johnson; Kane; Kankakee; Kendall; La Salle; Lake; Lawrence; Livingston; Macon; Marion; Massac; McHenry; McLean; Moultrie; Piatt; Pope; Richland; Saline; Shelby; Vermilion; Wabash; Wayne; White; Will; Williamson.',37.0,42.5,-89.27,-87.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2195,'United States (USA) - Illinois - SPCS - W','United States (USA) - Illinois west of approximately 89d 05m West - counties of Adams; Alexander; Bond; Brown; Bureau; Calhoun; Carroll; Cass; Christian; Clinton; Fulton; Greene; Hancock; Henderson; Henry; Jackson; Jersey; Jo Daviess; Knox; Lee; Logan; Macoupin; Madison; Marshall; Mason; McDonough; Menard; Mercer; Monroe; Montgomery; Morgan; Ogle; Peoria; Perry; Pike; Pulaski; Putnam; Randolph; Rock Island; Sangamon; Schuyler; Scott; St. Clair; Stark; Stephenson; Tazewell; Union; Warren; Washington; Whiteside; Winnebago; Woodford.',36.97,42.5,-91.51,-88.93,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2196,'United States (USA) - Indiana - SPCS - E','United States (USA) - Indiana east of approximately 86d 25m West - counties of Adams; Allen; Bartholomew; Blackford; Brown; Cass; Clark; De Kalb; Dearborn; Decatur; Delaware; Elkhart; Fayette; Floyd; Franklin; Fulton; Grant; Hamilton; Hancock; Harrison; Henry; Howard; Huntington; Jackson; Jay; Jefferson; Jennings; Johnson; Kosciusko; Lagrange; Madison; Marion; Marshall; Miami; Noble; Ohio; Randolph; Ripley; Rush; Scott; Shelby; St. Joseph; Steuben; Switzerland; Tipton; Union; Wabash; Washington; Wayne; Wells; Whitley.',37.95,41.75,-86.58,-84.81,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2197,'United States (USA) - Indiana - SPCS - W','United States (USA) - Indiana west of approximately 86d 25m West - counties of Benton; Boone; Carroll; Clay; Clinton; Crawford; Daviess; Dubois; Fountain; Gibson; Greene; Hendricks; Jasper; Knox; La Porte; Lake; Lawrence; Martin; Monroe; Montgomery; Morgan; Newton; Orange; Owen; Parke; Perry; Pike; Porter; Posey; Pulaski; Putnam; Spencer; Starke; Sullivan; Tippecanoe; Vanderburgh; Vermillion; Vigo; Warren; Warrick; White.',37.77,41.75,-88.09,-86.24,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2198,'United States (USA) - Iowa - SPCS - N','United States (USA) - Iowa north of approximately 42deg North - counties of Allamakee; Benton; Black Hawk; Boone; Bremer; Buchanan; Buena Vista; Butler; Calhoun; Carroll; Cerro Gordo; Cherokee; Chickasaw; Clay; Clayton; Crawford; Delaware; Dickinson; Dubuque; Emmet; Fayette; Floyd; Franklin; Greene; Grundy; Hamilton; Hancock; Hardin; Howard; Humboldt; Ida; Jackson; Jones; Kossuth; Linn; Lyon; Marshall; Mitchell; Monona; O''Brien; Osceola; Palo Alto; Plymouth; Pocahontas; Sac; Sioux; Story; Tama; Webster; Winnebago; Winneshiek; Woodbury; Worth; Wright.',41.86,43.51,-96.64,-90.15,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2199,'United States (USA) - Iowa - SPCS - S','United States (USA) - Iowa south of approximately 42deg North - counties of Adair; Adams; Appanoose; Audubon; Cass; Cedar; Clarke; Clinton; Dallas; Davis; Decatur; Des Moines; Fremont; Guthrie; Harrison; Henry; Iowa; Jasper; Jefferson; Johnson; Keokuk; Lee; Louisa; Lucas; Madison; Mahaska; Marion; Mills; Monroe; Montgomery; Muscatine; Page; Polk; Pottawattamie; Poweshiek; Ringgold; Scott; Shelby; Taylor; Union; Van Buren; Wapello; Warren; Washington; Wayne.',40.37,42.03,-96.14,-90.13,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2200,'United States (USA) - Kansas - SPCS - N','United States (USA) - Kansas north of approximately 38d 45m North - counties of Atchison; Brown; Cheyenne; Clay; Cloud; Decatur; Dickinson; Doniphan; Douglas; Ellis; Ellsworth; Geary; Gove; Graham; Jackson; Jefferson; Jewell; Johnson; Leavenworth; Lincoln; Logan; Marshall; Mitchell; Morris; Nemaha; Norton; Osborne; Ottawa; Phillips; Pottawatomie; Rawlins; Republic; Riley; Rooks; Russell; Saline; Shawnee; Sheridan; Sherman; Smith; Thomas; Trego; Wabaunsee; Wallace; Washington; Wyandotte.',38.52,40.0,-102.05,-94.59,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2201,'United States (USA) - Kansas - SPCS - S','United States (USA) - Kansas south of approximately 38d 45m North - counties of Allen; Anderson; Barber; Barton; Bourbon; Butler; Chase; Chautauqua; Cherokee; Clark; Coffey; Comanche; Cowley; Crawford; Edwards; Elk; Finney; Ford; Franklin; Grant; Gray; Greeley; Greenwood; Hamilton; Harper; Harvey; Haskell; Hodgeman; Kearny; Kingman; Kiowa; Labette; Lane; Linn; Lyon; Marion; McPherson; Meade; Miami; Montgomery; Morton; Neosho; Ness; Osage; Pawnee; Pratt; Reno; Rice; Rush; Scott; Sedgwick; Seward; Stafford; Stanton; Stevens; Sumner; Wichita; Wilson; Woodson.',36.99,38.87,-102.05,-94.59,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2202,'United States (USA) - Kentucky - SPCS - N','United States (USA) - Kentucky north of approximately 37d 55m North - counties of Anderson; Bath; Boone; Bourbon; Boyd; Bracken; Bullitt; Campbell; Carroll; Carter; Clark; Elliott; Fayette; Fleming; Franklin; Gallatin; Grant; Greenup; Harrison; Henry; Jefferson; Jessamine; Kenton; Lawrence; Lewis; Mason; Menifee; Montgomery; Morgan; Nicholas; Oldham; Owen; Pendleton; Robertson; Rowan; Scott; Shelby; Spencer; Trimble; Woodford.',37.74,39.14,-85.93,-82.46,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2203,'United States (USA) - Kentucky - SPCS - S','United States (USA) - Kentucky south of approximately 37d 55m North - counties of Adair; Allen; Ballard; Barren; Bell; Boyle; Breathitt; Breckinridge; Butler; Caldwell; Calloway; Carlisle; Casey; Christian; Clay; Clinton; Crittenden; Cumberland; Daviess; Edmonson; Estill; Floyd; Fulton; Garrard; Graves; Grayson; Green; Hancock; Hardin; Harlan; Hart; Henderson; Hickman; Hopkins; Jackson; Johnson; Knott; Knox; Larue; Laurel; Lee; Leslie; Letcher; Lincoln; Livingston; Logan; Lyon; Madison; Magoffin; Marion; Marshall; Martin; McCracken; McCreary; McLean; Meade; Mercer; Metcalfe; Monroe; Muhlenberg; Nelson; Ohio; Owsley; Perry; Pike; Powell; Pulaski; Rockcastle; Russell; Simpson; Taylor; Todd; Trigg; Union; Warren; Washington; Wayne; Webster; Whitley; Wolfe.',36.5,38.0,-89.42,-81.98,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2204,'United States (USA) - Louisiana - SPCS - N','United States (USA) - Louisiana north of approximately 30d 55m North - counties of Avoyelles; Bienville; Bossier; Caddo; Caldwell; Catahoula; Claiborne; Concordia; De Soto; East Carroll; Franklin; Grant; Jackson; La Salle; Lincoln; Madison; Morehouse; Natchitoches; Ouachita; Rapides; Red River; Richland; Sabine; Tensas; Union; Vernon; Webster; West Carroll; Winn.',30.84,33.03,-94.05,-90.89,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2205,'United States (USA) - Louisiana - SPCS27 - S','United States (USA) - Louisiana south of approximately 30d 55m North - counties of Acadia; Allen; Ascension; Assumption; Beauregard; Calcasieu; Cameron; East Baton Rouge; East Feliciana; Evangeline; Iberia; Iberville; Jefferson; Jefferson Davis; Lafayette; LaFourche; Livingston; Orleans; Plaquemines; Pointe Coupee; St. Bernard; St. Charles; St. Helena; St. James; St. John the Baptist; St. Landry; St. Martin; St. Mary; St. Tammany; Tangipahoa; Terrebonne; Vermilion; Washington; West Baton Rouge; West Feliciana. Also Gulf of Mexico outer continental shelf (GoM OCS) protraction areas West Cameron (WC); East Cameron (EC); Vermilion; South Marsh Island; Eugene Island; Ship Shoal; South Pelto; Bay Marchand; South Timbalier; Grand Isle; West Delta; South Pass; Main Pass; Breton Sound; Chandeleur.',27.83,31.02,-93.93,-87.77,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2206,'United States (USA) - Maine - SPCS - E','United States (USA) - Maine east of approximately 69d 30m West - counties of Aroostook; Hancock; Knox; Penobscot; Piscataquis; Waldo; Washington.',43.85,47.46,-70.02,-66.89,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2207,'United States (USA) - Maine - SPCS - W','United States (USA) - Maine west of approximately 69d 30m West - counties of Androscoggin; Cumberland; Franklin; Kennebec; Lincoln; Oxford; Sagadahoc; Somerset; York.',42.98,46.57,-71.08,-69.26,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2208,'United States (USA) - Massachusetts - SPCS - islands','United States (USA) - Massachusetts offshore - counties of Dukes; Nantucket.',41.2,41.51,-70.87,-69.9,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2209,'United States (USA) - Massachusetts - SPCS - mainland','United States (USA) - Massachusetts onshore - counties of Barnstable; Berkshire; Bristol; Essex; Franklin; Hampden; Hampshire; Middlesex; Norfolk; Plymouth; Suffolk; Worcester.',41.35,42.89,-73.51,-69.86,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2210,'United States (USA) - Montana - SPCS27 - central','United States (USA) - Montana between approximately 47d 50m & 46d 40m North - counties of Cascade; Dawson; Fergus; Garfield; Judith Basin; Lake; Lewis and Clark; McCone; Meagher; Mineral; Missoula; Petroleum; Powell; Prairie; Richland; Sanders; Wibaux.',46.18,48.26,-116.04,-104.02,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2211,'United States (USA) - Montana - SPCS27 - N','United States (USA) - Montana north of approximately 47d 50m North - counties of Blaine; Chouteau; Daniels; Flathead; Glacier; Hill; Liberty; Lincoln; Phillips; Pondera; Roosevelt; Sheridan; Teton; Toole; Valley.',47.42,49.0,-116.04,-104.02,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2212,'United States (USA) - Montana - SPCS27 - S','United States (USA) - Montana south of approximately 46d 40m North - counties of Beaverhead; Big Horn; Broadwater; Carbon; Carter; Custer; Deer Lodge; Fallon; Gallatin; Golden Valley; Granite; Jefferson; Madison; Musselshell; Park; Powder River; Ravalli; Rosebud; Silver Bow; Stillwater; Sweet Grass; Treasure; Wheatland; Yellowstone.',44.36,46.83,-114.56,-104.02,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2213,'United States (USA) - Minnesota - SPCS - central','United States (USA) - Minnesota between approximately 47d 10m & 45d 30m North - counties of Aitkin; Becker; Benton; Carlton; Cass; Chisago; Clay; Crow Wing; Douglas; Grant; Hubbard; Isanti; Kanabec; Mille Lacs; Morrison; Otter Tail; Pine; Pope; Stearns; Stevens; Todd; Traverse; Wadena; Wilkin.',45.28,47.48,-96.87,-92.27,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2214,'United States (USA) - Minnesota - SPCS - N','United States (USA) - Minnesota north of approximately 47d 10m North - counties of Beltrami; Clearwater; Cook; Itasca; Kittson; Koochiching; Lake; Lake of the Woods; Mahnomen; Marshall; Norman; Pennington; Polk; Red Lake; Roseau; St. Louis.',46.64,49.39,-97.24,-89.47,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2215,'United States (USA) - Minnesota - SPCS - S','United States (USA) - Minnesota south of approximately 45d 30m North - counties of Anoka; Big Stone; Blue Earth; Brown; Carver; Chippewa; Cottonwood; Dakota; Dodge; Faribault; Fillmore; Freeborn; Goodhue; Hennepin; Houston; Jackson; Kandiyohi; Lac Qui Parle; Le Sueur; Lincoln; Lyon; Martin; McLeod; Meeker; Mower; Murray; Nicollet; Nobles; Olmsted; Pipestone; Ramsey; Redwood; Renville; Rice; Rock; Scott; Sherburne; Sibley; Steele; Swift; Wabasha; Waseca; Washington; Watonwan; Winona; Wright; Yellow Medicine.',43.5,45.59,-96.85,-91.22,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2216,'United States (USA) - Mississippi - SPCS - E','United States (USA) - Mississippi east of approximately 89d 40m West - counties of Alcorn; Attala; Benton; Calhoun; Chickasaw; Choctaw; Clarke; Clay; Covington; Forrest; George; Greene; Hancock; Harrison; Itawamba; Jackson; Jasper; Jones; Kemper; Lafayette; Lamar; Lauderdale; Leake; Lee; Lowndes; Marshall; Monroe; Neshoba; Newton; Noxubee; Oktibbeha; Pearl River; Perry; Pontotoc; Prentiss; Scott; Smith; Stone; Tippah; Tishomingo; Union; Wayne; Webster; Winston.',30.13,35.0,-89.96,-88.1,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2217,'United States (USA) - Mississippi - SPCS - W','United States (USA) - Mississippi west of approximately 89d 40m West - counties of Adams; Amite; Bolivar; Carroll; Claiborne; Coahoma; Copiah; De Soto; Franklin; Grenada; Hinds; Holmes; Humphreys; Issaquena; Jefferson; Jefferson Davis; Lawrence; Leflore; Lincoln; Madison; Marion; Montgomery; Panola; Pike; Quitman; Rankin; Sharkey; Simpson; Sunflower; Tallahatchie; Tate; Tunica; Walthall; Warren; Washington; Wilkinson; Yalobusha; Yazoo.',31.0,35.0,-91.24,-89.38,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2218,'United States (USA) - Missouri - SPCS - central','United States (USA) - Missouri between approximately 91d 45m & 93d 35m West - counties of Adair; Audrain; Benton; Boone; Callaway; Camden; Carroll; Chariton; Christian; Cole; Cooper; Dallas; Douglas; Greene; Grundy; Hickory; Howard; Howell; Knox; Laclede; Linn; Livingston; Macon; Maries; Mercer; Miller; Moniteau; Monroe; Morgan; Osage; Ozark; Pettis; Phelps; Polk; Pulaski; Putnam; Randolph; Saline; Schuyler; Scotland; Shelby; Stone; Sullivan; Taney; Texas; Webster; Wright.',36.5,40.61,-93.77,-91.4,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2219,'United States (USA) - Missouri - SPCS - E','United States (USA) - Missouri east of approximately 91d 45m West - counties of Bollinger; Butler; Cape Girardeau; Carter; Clark; Crawford; Dent; Dunklin; Franklin; Gasconade; Iron; Jefferson; Lewis; Lincoln; Madison; Marion; Mississippi; Montgomery; New Madrid; Oregon; Pemiscot; Perry; Pike; Ralls; Reynolds; Ripley; Scott; Shannon; St. Charles; St. Francois; St. Louis; Ste. Genevieve; Stoddard; Warren; Washington; Wayne.',36.0,40.61,-91.94,-89.1,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2220,'United States (USA) - Missouri - SPCS - W','United States (USA) - Missouri west of approximately 93d 35m West - counties of Andrew; Atchison; Barry; Barton; Bates; Buchanan; Caldwell; Cass; Cedar; Clay; Clinton; Dade; Daviess; De Kalb; Gentry; Harrison; Henry; Holt; Jackson; Jasper; Johnson; Lafayette; Lawrence; McDonald; Newton; Nodaway; Platte; Ray; St. Clair; Vernon; Worth.',36.5,40.61,-95.78,-93.5,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2221,'United States (USA) - Nebraska - SPCS27 - N','United States (USA) - Nebraska - counties of Antelope; Blaine; Box Butte; Boyd; Brown; Burt; Cedar; Cherry; Cuming; Dakota; Dawes; Dixon; Garfield; Grant; Holt; Hooker; Keya Paha; Knox; Loup; Madison; Pierce; Rock; Sheridan; Sioux; Stanton; Thomas; Thurston; Wayne; Wheeler.',41.73,43.0,-104.06,-96.08,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2222,'United States (USA) - Nebraska - SPCS27 - S','United States (USA) - Nebraska - counties of Adams; Arthur; Banner; Boone; Buffalo; Butler; Cass; Chase; Cheyenne; Clay; Colfax; Custer; Dawson; Deuel; Dodge; Douglas; Dundy; Fillmore; Franklin; Frontier; Furnas; Gage; Garden; Gosper; Greeley; Hall; Hamilton; Harlan; Hayes; Hitchcock; Howard; Jefferson; Johnson; Kearney; Keith; Kimball; Lancaster; Lincoln; Logan; McPherson; Merrick; Morrill; Nance; Nemaha; Nuckolls; Otoe; Pawnee; Perkins; Phelps; Platte; Polk; Red Willow; Richardson; Saline; Sarpy; Saunders; Scotts Bluff; Seward; Sherman; Thayer; Valley; Washington; Webster; York.',40.0,42.0,-104.06,-95.32,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2223,'United States (USA) - Nevada - SPCS - central','United States (USA) - Nevada between approximately 117d 15m and 116d West - counties of Lander; Nye.',36.0,41.0,-118.19,-115.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2224,'United States (USA) - Nevada - SPCS - E','United States (USA) - Nevada east of approximately 116d  West - counties of Clark; Elko; Eureka; Lincoln; White Pine.',35.0,42.0,-117.01,-114.05,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2225,'United States (USA) - Nevada - SPCS - W','United States (USA) - Nevada west of approximately 117d 15m West - counties of Churchill; Douglas; Esmeralda; Humboldt; Lyon; Mineral; Pershing; Storey; Washoe.',36.97,42.0,-120.0,-117.01,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2226,'Canada - Newfoundland - E of 54.5 deg W','Canada - Newfoundland - east of 54 deg 30 min West.',46.6,49.8,-54.5,-52.62,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(2227,'Canada - Newfoundland - 57.5 to 54.5 deg W','Canada - Newfoundland and Labrador between 57 deg 30 min and 54 de 30 min West.',46.6,54.7,-57.5,-54.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(2228,'United States (USA) - New Mexico - SPCS - E','United States (USA) - New Mexico east of approximately 105d West - counties of Chaves; Colfax; Curry; De Baca; Eddy; Guadalupe; Harding; Lea; Mora; Quay; Roosevelt; San Miguel; Union.',32.0,37.0,-105.72,-103.0,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2229,'United States (USA) - New Mexico - SPCS27 - central','United States (USA) - New Mexico between approximately 105d & 107d 15m West - counties of Bernalillo; Dona Ana; Lincoln; Los Alamos; Otero; Rio Arriba; Sandoval; Santa Fe; Socorro; Taos; Torrance.',31.78,37.0,-107.72,-104.85,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2230,'United States (USA) - New Mexico - SPCS27 - W','United States (USA) - New Mexico west of approximately 107d 15m West - counties of Catron; Cibola; Grant; Hidalgo; Luna; McKinley; San Juan; Sierra; Valencia.',31.33,37.0,-109.05,-106.41,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2231,'United States (USA) - New Mexico - SPCS83 - central','United States (USA) - New Mexico between approximately 105d & 107d 15m West - counties of Bernalillo; Dona Ana; Lincoln; Los Alamos; Otero; Rio Arriba; Sandoval; Santa Fe; Socorro; Taos; Torrance; Valencia.',31.78,37.0,-107.72,-104.85,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2232,'United States (USA) - New Mexico - SPCS83 - W','United States (USA) - New Mexico west of approximately 107d 15m West - counties of Catron; Cibola; Grant; Hidalgo; Luna; McKinley; San Juan; Sierra.',31.33,37.0,-109.05,-106.88,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2233,'United States (USA) - New York - SPCS - central','United States (USA) - New York between approximately 75d 15m & 77d 30m West - counties of Broome; Cayuga; Chemung; Chenango; Cortland; Jefferson; Lewis; Madison; Oneida; Onondaga; Ontario; Oswego; Schuyler; Seneca; Steuben; Tioga; Tompkins; Wayne; Yates.',42.0,44.4,-77.75,-75.07,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2234,'United States (USA) - New York - SPCS - E','United States (USA) - New York mainland east of approximately 75d 15m West - counties of Albany; Clinton; Columbia; Delaware; Dutchess; Essex; Franklin; Fulton; Greene; Hamilton; Herkimer; Montgomery; Orange; Otsego; Putnam; Rensselaer; Rockland; Saratoga; Schenectady; Schoharie; St. Lawrence; Sullivan; Ulster; Warren; Washington; Westchester.',40.88,45.03,-75.86,-73.25,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2235,'United States (USA) - New York - SPCS - Long island','United States (USA) - New York - counties of Bronx; Kings; Nassau; New York; Queens; Richmond; Suffolk.',40.47,41.31,-74.27,-71.75,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2236,'United States (USA) - New York - SPCS - W','United States (USA) - New York west of approximately 77d 30m West - counties of Allegany; Cattaraugus; Chautauqua; Erie; Genesee; Livingston; Monroe; Niagara; Orleans; Wyoming.',42.0,43.64,-79.76,-77.37,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2237,'United States (USA) - North Dakota - SPCS - N','United States (USA) - North Dakota north of approximately 47d 25m North - counties of Benson; Bottineau; Burke; Cavalier; Divide; Eddy; Foster; Grand Forks; Griggs; McHenry; McKenzie; McLean; Mountrial; Nelson; Pembina; Pierce; Ramsey; Renville; Rolette; Sheridan; Steele; Towner; Traill; Walsh; Ward; Wells; Williams.',47.15,49.0,-104.05,-96.83,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2238,'United States (USA) - North Dakota - SPCS - S','United States (USA) - North Dakota south of approximately 47d 25m North - counties of Adams; Barnes; Billings; Bowman; Burleigh; Cass; Dickey; Dunn; Emmons; Golden Valley; Grant; Hettinger; Kidder; La Moure; Logan; McIntosh; Mercer; Morton; Oliver; Ransom; Richland; Sargent; Sioux; Slope; Stark; Stutsman.',45.93,47.81,-104.05,-96.57,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2239,'United States (USA) - Ohio - SPCS - N','United States (USA) - Ohio north of approximately 40d 15m North - counties of Allen;Ashland; Ashtabula; Auglaize; Carroll; Columbiana; Coshocton; Crawford; Cuyahoga; Defiance; Delaware; Erie; Fulton; Geauga; Hancock; Hardin; Harrison; Henry; Holmes; Huron; Jefferson; Knox; Lake; Logan; Lorain; Lucas; Mahoning; Marion; Medina; Mercer; Morrow; Ottawa; Paulding; Portage; Putnam; Richland; Sandusky; Seneca; Shelby; Stark; Summit; Trumbull; Tuscarawas; Union; Van Wert; Wayne; Williams; Wood; Wyandot.',40.1,42.32,-84.81,-80.52,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2240,'United States (USA) - Ohio - SPCS - S','United States (USA) - Ohio south of approximately 40d 15m North - counties of Adams; Athens; Belmont; Brown; Butler; Champaign; Clark; Clermont; Clinton; Darke; Fairfield; Fayette; Franklin; Gallia; Greene; Guernsey; Hamilton; Highland; Hocking; Jackson; Lawrence; Licking; Madison; Meigs; Miami; Monroe; Montgomery; Morgan; Muskingum; Noble; Perry; Pickaway; Pike; Preble; Ross; Scioto; Vinton; Warren; Washington.',38.4,40.35,-84.81,-80.69,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2241,'United States (USA) - Oklahoma - SPCS - N','United States (USA) - Oklahoma north of approximately 35d 20m North - counties of Adair; Alfalfa; Beaver; Blaine; Canadian; Cherokee; Cimarron; Craig; Creek; Custer; Delaware; Dewey; Ellis; Garfield; Grant; Harper; Kay; Kingfisher; Lincoln; Logan; Major; Mayes; Muskogee; Noble; Nowata; Okfuskee; Oklahoma; Okmulgee; Osage; Ottawa; Pawnee; Payne; Roger Mills; Rogers; Sequoyah; Texas; Tulsa; Wagoner; Washington; Woods; Woodward.',35.26,37.01,-103.0,-94.43,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2242,'United States (USA) - Oklahoma - SPCS - S','United States (USA) - Oklahoma south of approximately 35d 20m North - counties of Atoka; Beckham; Bryan; Caddo; Carter; Choctaw; Cleveland; Coal; Comanche; Cotton; Garvin; Grady; Greer; Harmon; Haskell; Hughes; Jackson; Jefferson; Johnston; Kiowa; Latimer; Le Flore; Love; Marshall; McClain; McCurtain; McIntosh; Murray; Pittsburg; Pontotoc; Pottawatomie; Pushmataha; Seminole; Stephens; Tillman; Washita.',33.61,35.55,-100.0,-94.43,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2243,'United States (USA) - Oregon - SPCS - N','United States (USA) - Oregon north of approximately 44d 15m North - counties of Baker; Benton; Clackamas; Clatsop; Columbia; Gilliam; Grant; Hood River; Jefferson; Lincoln; Linn; Marion; Morrow; Multnomah; Polk; Sherman; Tillamook; Umatilla; Union; Wallowa; Wasco; Washington; Wheeler; Yamhill.',43.96,46.29,-124.15,-116.46,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2244,'United States (USA) - Oregon - SPCS - S','United States (USA) - Oregon south of approximately 44d 15m North - counties of Coos; Crook; Curry; Deschutes; Douglas; Harney; Jackson; Josephine; Klamath; Lake; Lane; Malheur.',42.0,44.56,-124.6,-116.88,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2245,'United States (USA) - Pennsylvania - SPCS - N','United States (USA) - Pennsylvania north of approximately 40d 50m North - counties of Bradford; Cameron; Carbon; Centre; Clarion; Clearfield; Clinton; Columbia; Crawford; Elk; Erie; Forest; Jefferson; Lackawanna; Luzerne; Lycoming; McKean; Mercer; Monroe; Montour; Northumberland; Pike; Potter; Sullivan; Susquehanna; Tioga; Union; Venango; Warren; Wayne; Wyoming.',40.6,42.51,-80.52,-74.69,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2246,'United States (USA) - Pennsylvania - SPCS - S','United States (USA) - Pennsylvania south of approximately 40d 50m North - counties of Adams; Allegheny; Armstrong; Beaver; Bedford; Berks; Blair; Bucks; Butler; Cambria; Chester; Cumberland; Dauphin; Delaware; Fayette; Franklin; Fulton; Greene; Huntingdon; Indiana; Juniata; Lancaster; Lawrence; Lebanon; Lehigh; Mifflin; Montgomery; Northampton; Perry; Philadelphia; Schuylkill; Snyder; Somerset; Washington; Westmoreland; York.',39.71,41.18,-80.52,-74.72,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2247,'United States (USA) - South Carolina  - SPCS27 - N','United States (USA) - South Carolina - counties of Abbeville; Anderson; Calhoun; Cherokee; Chester; Chesterfield; Darlington; Dillon; Edgefield; Fairfield; Florence; Greenville; Greenwood; Horry; Kershaw; Lancaster; Laurens; Lee; Lexington; Marion; Marlboro; McCormick; Newberry; Oconee; Pickens; Richland; Saluda; Spartanburg; Sumter; Union; York.',33.53,35.21,-83.36,-78.5,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2248,'United States (USA) - South Carolina  - SPCS27 - S','United States (USA) - South Carolina - counties of Aiken; Allendale; Bamberg; Barnwell; Beaufort; Berkeley; Charleston; Clarendon; Colleton; Dorchester; Georgetown; Hampton; Jasper; Orangeburg; Williamsburg.',32.0,33.95,-82.02,-78.9,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2249,'United States (USA) - South Dakota - SPCS - N','United States (USA) - South Dakota north of approximately 44d 20m North - counties of Beadle; Brookings; Brown; Butte; Campbell; Clark; Codington; Corson; Day; Deuel; Dewey; Edmunds; Faulk; Grant; Hamlin; Hand; Harding; Hyde; Kingsbury; Lawrence; Marshall; McPherson; Meade; Perkins; Potter; Roberts; Spink; Sully; Walworth; Ziebach.',44.14,45.94,-104.07,-96.46,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2250,'United States (USA) - South Dakota - SPCS - S','United States (USA) - South Dakota south of approximately 44d 20m North - counties of Aurora; Bennett; Bon Homme; Brule; Buffalo; Charles Mix; Clay; Custer; Davison; Douglas; Fall River; Gregory; Haakon; Hanson; Hughes; Hutchinson; Jackson; Jerauld; Jones; Lake; Lincoln; Lyman; McCook; Mellette; Miner; Minnehaha; Moody; Pennington; Sanborn; Shannon; Stanley; Todd; Tripp; Turner; Union; Yankton.',42.49,44.78,-104.07,-96.46,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2251,'Caribbean - Puerto Rico and the US Virgin Islands','Puerto Rico and Virgin Islands (US).',17.68,18.52,-67.27,-64.56,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2252,'United States (USA) - Texas - SPCS - central','United States (USA) - Texas between approximately 32deg & 30d 10m North - counties of Anderson; Angelina; Bastrop; Bell; Blanco; Bosque; Brazos; Brown; Burleson; Burnet; Cherokee; Coke; Coleman; Comanche; Concho; Coryell; Crane; Crockett; Culberson; Ector; El Paso; Falls; Freestone; Gillespie; Glasscock; Grimes; Hamilton; Hardin; Houston; Hudspeth; Irion; Jasper; Jeff Davis; Kimble; Lampasas; Lee; Leon; Liberty; Limestone; Llano; Loving; Madison; Mason; McCulloch; McLennan; Menard; Midland; Milam; Mills; Montgomery; Nacogdoches; Newton; Orange; Pecos; Polk; Reagan; Reeves; Robertson; Runnels; Sabine; San Augustine; San Jacinto; San Saba; Schleicher; Shelby; Sterling; Sutton; Tom Green; Travis; Trinity; Tyler; Upton; Walker; Ward; Washington; Williamson; Winkler.',29.78,32.26,-106.63,-93.51,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2253,'United States (USA) - Texas - SPCS - N','United States (USA) - Texas north of approximately 34d 20m North - counties of: Armstrong; Briscoe; Carson; Castro; Childress; Collingsworth; Dallam; Deaf Smith; Donley; Gray; Hall; Hansford; Hartley; Hemphill; Hutchinson; Lipscomb; Moore; Ochiltree; Oldham; Parmer; Potter; Randall; Roberts; Sherman; Swisher; Wheeler.',34.31,36.5,-103.05,-100.0,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2254,'United States (USA) - Texas - SPCS - N central','United States (USA) - Texas between approximately 34d 20m & 32deg North - counties of: Andrews; Archer; Bailey; Baylor; Borden; Bowie; Callahan; Camp; Cass; Clay; Cochran; Collin; Cooke; Cottle; Crosby; Dallas; Dawson; Delta; Denton; Dickens; Eastland; Ellis; Erath; Fannin; Fisher; Floyd; Foard; Franklin; Gaines; Garza; Grayson; Gregg; Hale; Hardeman; Harrison; Haskell; Henderson; Hill; Hockley; Hood; Hopkins; Howard; Hunt; Jack; Johnson; Jones; Kaufman; Kent; King; Knox; Lamar; Lamb; Lubbock; Lynn; Marion; Martin; Mitchell; Montague; Morris; Motley; Navarro; Nolan; Palo Pinto; Panola; Parker; Rains; Red River; Rockwall; Rusk; Scurry; Shackelford; Smith; Somervell; Stephens; Stonewall; Tarrant; Taylor; Terry; Throckmorton; Titus; Upshur; Van Zandt; Wichita; Wilbarger; Wise; Wood; Yoakum; Young.',31.74,34.58,-103.05,-94.0,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2255,'United States (USA) - Texas - SPCS27 - S','United States (USA) - Texas south of approximately 28d 05m North - counties of Brooks; Cameron; Duval; Hidalgo; Jim Hogg; Jim Wells; Kenedy; Kleberg; Nueces; San Patricio; Starr; Webb; Willacy; Zapata.  Gulf of Mexico outer continental shelf (GoM OCS) protraction areas: South Padre Island; North Padre Island; Mustang Island.',25.83,28.2,-100.2,-95.37,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2256,'United States (USA) - Texas - SPCS27 - S central','United States (USA) - Texas between approximately 30d 10m & 28d 05m North - counties of Aransas; Atascosa; Austin; Bandera; Bee; Bexar; Brazoria; Brewster; Caldwell; Calhoun; Chambers; Colorado; Comal; De Witt; Dimmit; Edwards; Fayette; Fort Bend; Frio; Galveston; Goliad; Gonzales; Guadalupe; Harris; Hays; Jackson; Jefferson; Karnes; Kendall; Kerr; Kinney; La Salle; Lavaca; Live Oak; Matagorda; Maverick; McMullen; Medina; Presidio; Real; Refugio; Terrell; Uvalde; Val Verde; Victoria; Waller; Wharton; Wilson; Zavala.  Gulf of Mexico outer continental shelf (GoM OCS) protraction areas: Matagorda Island; Brazos; Galveston; High Island.',27.82,30.66,-105.0,-93.41,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2257,'United States (USA) - Utah - SPCS - central','United States (USA) - Utah between approximately 40d 50m & 38d 30m North - counties of Carbon; Duchesne; Emery; Grand; Juab; Millard; Salt Lake; Sanpete; Sevier; Tooele; Uintah; Utah; Wasatch.',38.5,41.08,-114.05,-109.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2258,'United States (USA) - Utah - SPCS - N','United States (USA) - Utah north of approximately 40d 50m North - counties of Box Elder; Cache; Daggett; Davis; Morgan; Rich; Summit; Weber.',40.55,42.0,-114.05,-109.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2259,'United States (USA) - Utah - SPCS - S','United States (USA) - Utah south of approximately 38d 30m North - counties of Beaver; Garfield; Iron; Kane; Piute; San Juan; Washington; Wayne.',37.0,38.58,-114.05,-109.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2260,'United States (USA) - Virginia - SPCS - N','United States (USA) - Virginia north of approximately 38d 05m North - counties of Arlington; Augusta; Bath; Caroline; Clarke; Culpeper; Fairfax; Fauquier; Frederick; Greene; Highland; King George; Loudoun; Madison; Orange; Page; Prince William; Rappahannock; Rockingham; Shenandoah; Spotsylvania; Stafford; Warren; Westmoreland.',37.77,39.45,-80.05,-76.5,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2261,'United States (USA) - Virginia - SPCS - S','United States (USA) - Virginia south of approximately 38d 05m North - counties of Accomack; Albemarle; Alleghany; Amelia; Amherst; Appomattox; Bedford; Bland; Botetourt; Bristol; Brunswick; Buchanan; Buckingham; Campbell; Carroll; Charles City; Charlotte; Chesapeake; Chesterfield; Colonial Heights; Craig; Cumberland; Dickenson; Dinwiddie; Essex; Floyd; Fluvanna; Franklin; Giles; Gloucester; Goochland; Grayson; Greensville; Halifax; Hampton; Hanover; Henrico; Henry; Isle of Wight; James City; King and Queen; King William; Lancaster; Lee; Louisa; Lunenburg; Lynchburg; Mathews; Mecklenburg; Middlesex; Montgomery; Nelson; New Kent; Newport News; Norfolk; Northampton; Northumberland; Norton; Nottoway; Patrick; Petersburg; Pittsylvania; Portsmouth; Powhatan; Prince Edward; Prince George; Pulaski; Richmond; Roanoke; Rockbridge; Russell; Scott; Smyth; Southampton; Suffolk; Surry; Sussex; Tazewell; Washington; Wise; Wythe; York.',36.53,38.27,-83.68,-75.17,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2262,'United States (USA) - Washington - SPCS27 - N','United States (USA) - Washington north of approximately 47d 30m North - counties of Chelan; Clallam; Douglas; Ferry; Island; Jefferson; King; Kitsap; Lincoln; Okanogan; Pend Oreille; San Juan; Skagit; Snohomish; Spokane; Stevens; Whatcom.',-47.08,49.0,-124.75,-117.03,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2263,'United States (USA) - Washington - SPCS27 - S','United States (USA) - Washington south of approximately 47d 30m North - counties of Adams; Asotin; Benton; Clark; Columbia; Cowlitz; Franklin; Garfield; Grant; Grays Harbor; Kittitas; Klickitat; Lewis; Mason; Pacific; Pierce; Skamania; Thurston; Wahkiakum; Walla Walla; Whitman; Yakima.',45.55,47.95,-124.5,-116.9,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2264,'United States (USA) - West Virginia - SPCS - N','United States (USA) - West Virginia north of approximately 39deg North - counties of Barbour; Berkeley; Brooke; Doddridge; Grant; Hampshire; Hancock; Hardy; Harrison; Jefferson; Marion; Marshall; Mineral; Monongalia; Morgan; Ohio; Pleasants; Preston; Ritchie; Taylor; Tucker; Tyler; Wetzel; Wirt; Wood.',38.75,40.63,-81.76,-77.73,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2265,'United States (USA) - West Virginia - SPCS - S','United States (USA) - West Virginia south of approximately 39deg North - counties of Boone; Braxton; Cabell; Calhoun; Clay; Fayette; Gilmer; Greenbrier; Jackson; Kanawha; Lewis; Lincoln; Logan; Mason; McDowell; Mercer; Mingo; Monroe; Nicholas; Pendleton; Pocahontas; Putnam; Raleigh; Randolph; Roane; Summers; Upshur; Wayne; Webster; Wyoming.',37.2,39.18,-82.65,-79.05,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2266,'United States (USA) - Wisconsin - SPCS - central','United States (USA) - Wisconsin between approximately 45d 35m & 44d 15m North - counties of Barron; Brown; Buffalo; Chippewa; Clark; Door; Dunn; Eau Claire; Jackson; Kewaunee; Langlade; Lincoln; Marathon; Marinette; Menominee; Oconto; Outagamie; Pepin; Pierce; Polk; Portage; Rusk; Shawano; St. Croix; Taylor; Trempealeau; Waupaca; Wood.',43.98,46.02,-92.88,-86.25,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2267,'United States (USA) - Wisconsin - SPCS - N','United States (USA) - Wisconsin north of approximately 45d 35m North - counties of Ashland; Bayfield; Burnett; Douglas; Florence; Forest; Iron; Oneida; Price; Sawyer; Vilas; Washburn.',45.37,47.29,-92.88,-88.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2268,'United States (USA) - Wisconsin - SPCS - S','United States (USA) - Wisconsin south of approximately 44d 15m North - counties of Adams; Calumet; Columbia; Crawford; Dane; Dodge; Fond Du Lac; Grant; Green; Green Lake; Iowa; Jefferson; Juneau; Kenosha; La Crosse; Lafayette; Manitowoc; Marquette; Milwaukee; Monroe; Ozaukee; Racine; Richland; Rock; Sauk; Sheboygan; Vernon; Walworth; Washington; Waukesha; Waushara; Winnebago.',42.49,44.33,-91.43,-86.9,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2269,'United States (USA) - Wyoming - SPCS - E','United States (USA) - Wyoming east of approximately 106d West - counties of Albany; Campbell; Converse; Crook; Goshen; Laramie; Niobrara; Platte; Weston.',41.0,45.0,-106.33,-104.05,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2270,'United States (USA) - Wyoming - SPCS - E central','United States (USA) - Wyoming between approximately 106d & 108d 10m West - counties of Big Horn; Carbon; Johnson; Natrona; Sheridan; Washakie.',41.0,45.0,-108.62,-106.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2271,'United States (USA) - Wyoming - SPCS - W','United States (USA) - Wyoming west of approximately 109d 40m West - counties of Lincoln; Sublette; Teton; Uinta.',41.0,45.0,-111.05,-109.04,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2272,'United States (USA) - Wyoming - SPCS - W central','United States (USA) - Wyoming between approximately 108d 10m & 109d 40m West - counties of Fremont; Hot Springs; Park; Sweetwater.',41.0,45.0,-110.17,-107.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2273,'United States (USA) - Washington - SPCS83 - N','United States (USA) - Washington north of approximately 47d 30m North - counties of Chelan; Clallam; Douglas; Ferry; Grant north of approximately 47d30m; Island; Jefferson; King; Kitsap; Lincoln; Okanogan; Pend Oreille; San Juan; Skagit; Snohomish; Spokane; Stevens; Whatcom.',-47.08,49.0,-124.75,-117.03,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2274,'United States (USA) - Washington - SPCS83 - S','United States (USA) - Washington south of approximately 47d 30m North - counties of Adams; Asotin; Benton; Clark; Columbia; Cowlitz; Franklin; Garfield; Grant south of approximately 47d30m; Grays Harbor; Kittitas; Klickitat; Lewis; Mason; Pacific; Pierce; Skamania; Thurston; Wahkiakum; Walla Walla; Whitman; Yakima.',45.55,47.6,-124.5,-116.9,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2275,'Canada - Newfoundland - 60.5 to 57.5 deg W','Canada - Newfoundland and Labrador between 60 deg and 57 deg 30 min West.',47.4,55.9,-60.5,-57.5,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(2276,'Canada - Quebec and Labrador - 63 to 60 deg W','Canada - Quebec and Labrador between 63 deg and 60 deg West.',47.13,59.1,-63.0,-60.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(2277,'Canada - Quebec and Labrador - 66 to 63 deg W','Canada - Quebec and Labrador between 66 deg and 63 deg West.',47.88,60.52,-66.0,-63.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(2278,'Canada - Quebec and Labrador - 69 to 66 deg W','Canada - Quebec and Labrador between 69 deg and  66 deg West.',47.1,59.1,-69.0,-66.0,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(2279,'Canada - Quebec and Ontario - 75 to 72 deg W','Canada - Quebec between 75 deg and 72 deg West.; Canada - Ontario - east of 75 deg West.',44.99,62.56,-75.0,-72.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(2280,'Canada - Quebec and Ontario - 78 to 75 deg W','Canada - Quebec and Ontario - between 78 deg and 75 deg West.',43.5,62.56,-78.0,-75.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(2281,'Canada - Quebec and Ontario - MTM zone 10','Canada - Quebec west of 78 deg West; Canada - Ontario - between 79 deg 30 min and 78 deg W in area to north of 47 deg N; between 80 deg 15 min and 78 deg W in area between 46 deg and 47 deg N; between 81 deg and 78 deg W in area south of 46 deg N.',42.1,62.46,-81.0,-78.0,'','','',NULL,'','EPSG','EPSG','1997-11-13','',0),
(2282,'Cote d''Ivoire (Ivory Coast) - Abidjan area','C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast) - Abidjan area.',5.13,5.92,-4.8,-3.4,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(2283,'Australia - Australian Capital Territory (ACT)','Australia - Australian Capital Territory (ACT).',-35.92,-35.16,148.77,149.4,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2284,'Australia - Northern Territory (NT)','Australia - Northern Territory (NT).',-26.0,-11.02,129.0,138.0,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2285,'Australia - Victoria','Australia - Victoria (Vic).',-39.15,-34.0,140.95,149.98,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2286,'Australia - New South Wales (NSW) and Victoria','Australia - New South Wales (NSW) and Victoria.',-39.15,-28.15,140.95,153.62,'','','',NULL,'','EPSG','EPSG','2002-11-18','2002.82',0),
(2287,'Australia - SE Australia (ACT NSW Vic)','Australia - Australian Capital Territory (ACT), New South Wales (NSW), Victoria.',-39.15,-28.15,140.95,153.62,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2288,'American Samoa - Tutuila and Aunu''u islands','American Samoa - Tutuila and Aunu''u islands.',-14.38,-14.24,-170.85,-170.54,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2289,'American Samoa - Ofu, Olesega and Ta''u islands','American Samoa - Ofu, Olesega and Ta''u islands.',-14.28,-14.16,-169.68,-169.41,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2290,'Canada - Quebec, Newfoundland and Labrador - MTM zone 3','Canada - Newfoundland and Labrador between 60 deg and 57 deg 30 min West; Canada - Quebec between 60 deg and 57 deg West.',47.4,55.36,-60.0,-57.5,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(2291,'Australasia - Australia and PNG - 150 to 156 deg E','Australia - between 150 and 156 deg East.  Papua New Guinea east of 150 deg East.',-37.8,-1.36,150.0,156.0,'','','',NULL,'','EPSG','EPSG','1995-12-02','',0),
(2292,'Myanmar (Burma) - 15 to 21 deg N','Myanmar (Burma) - between 15 and 21 deg North.',15.0,21.0,92.0,101.23,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(2293,'Myanmar (Burma) - S of 15 deg N','Myanmar (Burma) - south of 15 deg North.',9.47,15.0,97.75,99.75,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(2294,'Asia - Middle East - Iraq zone','Islamic Republic of Iran - south of 36 deg North. Iraq. Kuwait.',25.08,37.38,38.79,63.33,'','','',NULL,'','EPSG','EPSG','1996-04-12','',0),
(2295,'Caribbean - Windward and Leeward Islands','Windward Islands - Dominica  Grenada  Saint Lucia  Saint Vincent;  Leeward Islands - Anguilla   Antigua (excluding Barbuda)  Montserrat   Saint Kitts and Nevis; Barbados.',12.0,18.27,-63.17,-59.43,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2296,'Cote d''Ivoire (Ivory Coast) - offshore.','C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast) - offshore.',3.9,5.13,-7.55,-2.75,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2297,'United States (USA) - California - N of 38 deg N','United States (USA) - California north of 38 deg North.',38.0,42.0,-124.42,-118.57,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2298,'United States (USA) - California - S of 38 deg N','United States (USA) - California south of 38 deg North',32.51,38.0,-123.05,-114.13,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2299,'World - N hemisphere - 3-degree CM 003 deg E','Between 1 deg 30 min and 4 deg 30 min East, northern hemisphere.',0.0,84.0,1.5,4.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2300,'World - N hemisphere - 3-degree CM 006 deg E','Between 4 deg 30 min and 7 deg 30 min East, northern hemisphere.',0.0,84.0,4.5,7.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2301,'World - N hemisphere - 3-degree CM 009 deg E','Between 7 deg 30 min and 10 deg 30 min East, northern hemisphere.',0.0,84.0,7.5,10.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2302,'World - N hemisphere - 3-degree CM 012 deg E','Between 10 deg 30 min and 13 deg 30 min East, northern hemisphere.',0.0,84.0,10.5,13.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2303,'World - N hemisphere - 3-degree CM 015 deg E','Between 13 deg 30 min and 16 deg 30 min East, northern hemisphere.',0.0,84.0,13.5,16.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2304,'World - N hemisphere - 3-degree CM 018 deg E','Between 16 deg 30 min and 19 deg 30 min East, northern hemisphere.',0.0,84.0,16.5,19.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2305,'World - N hemisphere - 3-degree CM 021 deg E','Between 19 deg 30 min and 22 deg 30 min East, northern hemisphere.',0.0,84.0,19.5,22.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2306,'World - N hemisphere - 3-degree CM 024 deg E','Between 22 deg 30 min and 25 deg 30 min East, northern hemisphere.',0.0,84.0,22.5,25.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2307,'Brazil - Campos; Espirito Santo and Santos basins','Brazil - offshore - Campos; Espirito Santo and Santos basins.',-27.83,-18.18,-48.45,-38.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2308,'Brazil - Tucano basin north','Brazil - Tucano basin north.',-9.8,-9.0,-39.0,-37.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2309,'Brazil - Tucano basin central','Brazil - Tucano basin central.',-10.6,-9.8,-39.0,-37.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2310,'Brazil - Tucano basin south','Brazil - Tucano basin south.',-11.4,-10.6,-39.0,-37.5,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2311,'Africa - Kenya and Tanzania','Kenya; Tanzania.',-11.74,4.62,29.34,41.91,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2312,'Africa - Botswana, Lesotho, Malawi, Swaziland, Zambia, Zimbabwe','Botswana; Lesotho; Malawi; Swaziland; Zambia; Zimbabwe.',-30.65,-8.2,20.0,35.92,'','','',NULL,'','EPSG','EPSG','2005-09-30','2005.15',0),
(2313,'Canada - Nova Scotia','Canada - Nova Scotia.',43.46,47.03,-66.2,-59.81,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2314,'Asia - FSU - Caspian states','Azerbaijan; Kazakhstan; Russian Federation; Turkmenistan - Caspian Sea',35.15,81.85,26.0,90.0,'','','',NULL,'','EPSG','EPSG','1999-09-07','',0),
(2315,'Colombia - Cusiana','Colombia - Casanare province BP Cusiana/Cupiagua field areas.  Also used by Total in Rivera and Gatanas blocks.',4.75,5.67,-73.0,-72.25,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2316,'Angola - offshore block 5','Angola - offshore block 5.',-8.58,-7.75,12.58,13.4,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2317,'Angola - offshore block 2','Angola - offshore block 2.',-7.0,-6.03,12.08,12.84,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2318,'Angola - offshore block 3','Angola - offshore block 3.',-7.33,-6.67,11.75,12.5,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2319,'Angola - offshore block 7','Angola - offshore block 7.',-10.08,-9.42,12.67,13.4,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2320,'Angola - offshore blocks 7 8 24 + WGC spec','Angola - offshore blocks 7 and 8.  Also used rounded to integer metre in offshore block 24 and for GSI/HGS/Western Geophysical speculative seismic data throughout offshore Angola.',-17.17,-6.03,10.0,13.86,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2321,'Angola - offshore blocks 1 and 16','Angola - offshore blocks 1 and 16.',-7.25,-6.03,11.08,12.08,'','','',NULL,'','EPSG','EPSG','1998-12-14','',0),
(2322,'Angola - offshore blocks 3  7  15 and 17.','Angola - offshore blocks 3, 7,15 and 17.',-6.58,-6.03,10.83,11.67,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2323,'Angola - offshore blocks 1 16 and 18.','Angola - offshore blocks 1, 16 and 18.',-8.33,-6.03,11.08,12.75,'','','',NULL,'','EPSG','EPSG','1998-12-14','',0),
(2324,'Angola - offshore blocks 2  3 17 and 31-33.','Angola - offshore blocks 2,  3, 17 and 31-33.',-8.58,-6.03,10.47,12.84,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2325,'Argentina - Neuquen province Chos Malal area','Argentina - Neuquen province - Chos Malal area.',-37.8,-37.0,-70.7,-69.9,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2326,'Germany - West Germany all states','Germany - states of former West Germany - Baden-Wurtemberg, Bayern, Hessen, Niedersachsen, Nordrhein-Westfalen, Rheinland-Pfalz, Saarland, Schleswig-Holstein.',47.27,55.04,5.87,13.83,'','','',NULL,'','EPSG','EPSG','2006-06-12','2006.41',0),
(2327,'Syria - Al Whaleed area','Syria - Al Whaleed area',35.5,35.7,39.9,40.15,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2328,'Syria - Shaddadeh area','Syria - Shaddadeh area (36d N 41d E)',35.8,36.5,40.5,41.5,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2329,'Syria - Deir area','Syria - Deir area (35d 22m N 40d 06m E)',35.25,35.5,40.0,40.5,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2330,'Europe - North Sea','Denmark - North Sea;  Germany - North Sea;  Netherlands - offshore;  Norway - North Sea south of 62 deg N; United Kingdom (UKCS) - North Sea south of 62 deg N.',52.0,62.0,-4.0,8.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2331,'Norway - offshore N of 65 deg N','Norway - offshore north of 65 deg North.',65.0,72.0,-0.5,32.02,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2332,'Norway - offshore N of 65 deg N;  Svalbard','Norway - offshore north of 65 deg N;   Also Svalbard.',65.0,80.75,-0.5,32.02,'','','',NULL,'','EPSG','EPSG','2003-06-27','2003.141',0),
(2333,'Norway - offshore 62 to 65 deg N and W of 5 deg E','Norway - offshore between 62 and 65 deg North and west of 5 deg East.',62.0,65.0,-0.5,5.0,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2334,'Norway - North Sea - offshore S of 62 deg N.','Norway - North Sea - offshore south of 62 deg North.',56.12,62.0,1.5,8.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2335,'Spain - Balearic Islands','Spain - Balearic Islands.',38.62,40.08,1.2,4.33,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2336,'Spain - mainland except northwest','Spain - mainland except northwest (north of 41 deg 30m N and west of 4 deg 30 min W).',35.98,41.5,-7.5,3.27,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2337,'Spain - northwest','Spain - northwest (north of 41 deg 30m N and west of 4 deg 30 min W).',41.5,43.8,-9.3,-4.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2338,'Europe - Portugal and Spain','Portugal; Spain - mainland.',35.95,43.78,-9.5,3.3,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2339,'Italy - Sardinia','Italy - Sardinia.',38.5,41.5,8.0,10.0,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(2340,'Italy - Sicily','Italy - Sicily.',36.5,38.5,12.0,16.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2341,'Egypt - Gulf of Suez','Egypt - Gulf of Suez.',27.3,29.96,32.3,34.25,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2342,'Europe - common offshore','North Sea: Denmark - offshore; United Kingdom - UKCS offshore east of 6 deg West. Ireland - offshore.',49.05,63.9,-15.6,8.0,'','','',NULL,'','EPSG','EPSG','2004-09-01','2004.48',0),
(2343,'Europe - British Isles and Channel Islands','Ireland; United Kingdom (UK - England; Scotland; Wales; Northern Ireland) including Isle of Man and Channel Islands.',48.17,63.9,-27.0,3.4,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2344,'Europe - Finland and Norway','Finland; Norway.',57.87,71.05,5.3,31.6,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2345,'Asia - Middle East - Iraq; Israel; Jordan; Lebanon; Kuwait; Saudi Arabia; Syria.','Iraq; Israel; Jordan; Lebanon; Kuwait; Saudi Arabia; Syria.',16.38,37.38,34.27,55.67,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2346,'World - WGS72BE to WGS84 - by country','World.  Vietnam - offshore.',-90.0,90.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','1996-12-12','',0),
(2347,'Algeria - N of 31.5 deg North','Algeria - north of 35g (31 deg 30 min) North.',31.5,37.09,-3.89,9.23,'','','',NULL,'','EPSG','EPSG','1998-03-12','',0),
(2348,'Brunei - offshore','Brunei Darussalam - offshore.',4.58,6.1,113.0,115.15,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2349,'Brunei - onshore','Brunei Darussalam - onshore.',4.02,5.05,114.1,115.36,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2350,'Mozambique - A','Mozambique - Maputo province and southern part of Gaza province; i.e. south of approximately 24 deg S.',-26.88,-24.0,31.8,35.6,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2351,'Mozambique - B','Mozambique - provinces of Gaza; Inhambane and southern parts of Sofala and Manhica; i.e. between approximately 24 and 20 deg South.',-24.0,-20.0,31.33,35.6,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2352,'Mozambique - C','Mozambique - provinces of Sofala north of Beira corridor; Manhica; Tete and Zambezia; i.e. between approximately 20 and 16 deg South.',-20.0,-16.0,31.18,40.15,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2353,'Mozambique - D','Mozambique - provinces of Nampula; Niassa; Cabo Delgado; i.e. north of approximately 16 deg S.',-16.0,-9.56,30.23,40.9,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2354,'Indonesia - Kalimantan','Indonesia - Kalimantan.',-5.72,4.4,104.94,119.62,'','','',NULL,'','EPSG','EPSG','1998-03-12','',0),
(2355,'Falkland Islands - East Falkland Island','Falkland Islands (Malvinas) - East Falkland Island.',-52.5,-51.25,-59.75,-57.5,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2356,'Ecuador - Galapagos','Ecuador - Baltra; Galapagos.',-1.6,1.75,-92.0,-89.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2357,'Argentina - Tierra del Fuego','Argentina - Tierra del Fuego',-55.05,-52.64,-68.64,-63.81,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2358,'Thailand - Bongkot field','Thailand - Bongkot field.',7.3,8.3,102.2,102.7,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2359,'Vietnam - near 16 deg N','Vietnam - near 16 deg North.',15.9,16.1,107.45,108.4,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2360,'Vietnam - Con Son Island','Vietnam - Con Son Island.',8.62,8.76,106.53,106.75,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2361,'Myanmar (Burma) - Moattama area','Myanmar (Burma) - Moattama area.',14.5,16.5,94.0,98.0,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2362,'Iran - Kangan district','Iran - Kangan district.',27.7,28.2,51.8,52.5,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(2363,'Venezuela - east','Venezuela - east - Delta Amacuro; Anzoategui; Bolivar; Monagas; Sucre states.',7.0,10.8,-66.0,-57.38,'','','',NULL,'','EPSG','EPSG','1999-11-05','',0),
(2364,'Philippines - onshore excluding Mindanao','Philippines - onshore excluding Mindanao.',7.5,21.0,116.0,127.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2365,'Philippines - Mindanao','Philippines - Mindanao.',4.0,10.0,119.0,127.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2366,'Spain - mainland','Spain - mainland.',35.98,43.8,-9.3,3.27,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2367,'Spain - mainland NE','Spain - mainland north of the parallel of 42 deg N from the Atlantic Ocean to 42 deg N  4 deg W of Greenwich and then a line from 42 deg N  4 deg W of Greenwich through 40 deg N 0 deg E of Greenwich.',40.0,43.8,-9.3,3.27,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2368,'Spain - mainland SW','Spain - mainland south of the parallel of 42 deg N from the Atlantic Ocean to 42 deg N  4 deg W of Greenwich and then a line from 42 deg N  4 deg W of Greenwich through 40 deg N 0 deg E of Greenwich.',35.98,42.0,-7.5,0.25,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2369,'Seychelles - Mahe Island','Seychelles - Mahe Island.',-5.0,-4.5,55.0,56.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2370,'Europe - Boznia and Herzegovina; Croatia; Serbia; Slovenia.','Boznia and Herzegovina; Croatia; Serbia; Slovenia.',41.85,46.88,13.38,23.01,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2371,'Nigeria - south','Nigeria - south.',3.0,6.5,5.0,8.5,'','','',NULL,'','EPSG','EPSG','2001-08-28','',0),
(2372,'Italy - mainland','Italy - mainland including San Marino and Vatican City State.',37.75,47.09,6.65,18.53,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2373,'United States (USA) - Alaska including EEZ.','United States (USA) - Alaska including EEZ.',50.0,80.0,170.0,-129.99,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2001-08-28','',0),
(2374,'United States (USA) - conus including EEZ.','United States (USA) - lower 48 states including EEZ - Alabama; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming. US Gulf of Mexico (GoM) OCS.',23.94,49.39,-126.77,-62.0,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(2375,'Canada - Saskatchewan','Canada - Saskatchewan.',49.0,60.0,-110.0,-101.37,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2376,'Canada - Alberta','Canada - Alberta.',49.0,60.0,-120.0,-110.0,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2377,'United States (USA) - Delaware and Maryland','United States (USA) - Delaware and Maryland.',37.88,39.84,-79.49,-74.95,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2378,'United States (USA) - New England - south (CT, MA, NH, RI, VT)','United States (USA) - Connecticut; Massachusetts; New Hampshire; Rhode Island; Vermont.',40.95,45.31,-73.73,-69.86,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2379,'United States (USA) - Texas E of 100 deg W','United States (USA) - Texas east of 100 deg West.',25.83,34.59,-100.0,-93.51,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2380,'United States (USA) - Texas W of 100 deg W','United States (USA) - Texas west of 100 deg West.',28.0,36.5,-106.63,-100.0,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2381,'United States (USA) - Oregon and Washington.','United States (USA) - Oregon and Washington.',42.0,49.0,-124.75,-116.47,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2382,'United States (USA) - Idaho and Montana - E of 113 deg W','United States (USA) - Idaho and Montana - east of 113 deg West.',42.0,49.0,-113.0,-104.02,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2383,'United States (USA) - Idaho and Montana - W of 113 deg W','United States (USA) - Idaho and Montana - west of 113 deg West.',42.0,49.0,-117.24,-113.0,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2384,'Canada - Alberta and British Columbia.','Canada - Alberta; British Columbia (BC).',48.3,60.0,-139.05,-110.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2385,'Panama - Canal Zone','Panama - Canal Zone.',8.95,9.35,-79.9,-79.5,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2386,'Greenland - Hayes Peninsula','Greenland - Hayes Peninsula.',76.0,80.0,-70.0,-60.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2387,'United States (USA) - Alaska - Aleutian Islands east of 180 deg','United States (USA) - Alaska - Aleutian Islands east of 180 deg.',51.2,55.05,-180.0,-163.05,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(2388,'United States (USA) - Alaska - Aleutian Islands west of 180 deg','United States (USA) - Alaska - Aleutian Islands west of 180 deg.',51.35,52.13,172.4,180.0,'','','',NULL,'','EPSG','EPSG','1997-04-11','',0),
(2389,'United States (USA) - conus east of Mississippi River','United States (USA) - CONUS east of Mississippi River including Louisiana; Missouri; Minnesota.',24.53,48.72,-94.41,-67.07,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2390,'United States (USA) - conus west of Mississippi River','United States (USA) - CONUS west of Mississippi River.',25.83,49.39,-124.85,-89.1,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2391,'Oman - Masirah Island','Oman - Masirah Island.',20.0,20.9,58.5,59.5,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2392,'United Arab Emirates (UAE) - Abu al Bu Khoosh','United Arab Emirates (UAE) - Abu Dhabi - Abu al Bu Khoosh',25.5,25.65,53.0,53.25,'','','',NULL,'','EPSG','EPSG','2000-03-07','',0),
(2393,'Algeria - Hassi Messaoud','Algeria - Hassi Messaoud.',31.5,32.0,5.5,6.5,'','','',NULL,'','EPSG','EPSG','2000-06-23','',0),
(2394,'United Kingdom (UK) - Great Britain and UKCS','United Kingdom (UKCS) - Great Britain (GB) - England; Scotland; Wales; UKCS including North Sea.',49.15,63.83,-6.0,3.4,'','','',NULL,'','EPSG','EPSG','1998-11-11','',0),
(2395,'United Kingdom (UK) - England','United Kingdom (UK) - England.',49.94,55.81,-6.37,1.78,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2396,'United Kingdom (UK) - England; Wales; Isle of Man','United Kingdom (UK) - England; Wales; Isle of Man.',49.94,55.81,-6.37,1.78,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2397,'United Kingdom (UK) - Scotland','United Kingdom (UK) - Scotland (including Orkney and Shetland Islands).',54.62,58.67,-7.67,-0.72,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2398,'United Kingdom (UK) - Wales','United Kingdom (UK) - Wales.',51.37,53.43,-5.34,-2.64,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2399,'South America - Bolivia; Chile; Colombia;  Ecuador; Guyana; Peru; Venezuela.','Bolivia; Chile; Colombia;  Ecuador; Guyana; Peru; Venezuela.',-17.8,12.5,-82.0,-57.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2400,'Bolivia - Madidi','Bolivia - Madidi.',-21.8,-21.5,-64.0,-63.67,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2401,'Bolivia - Block 20','Bolivia - Block 20.',-21.8,-21.5,-64.0,-63.67,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2402,'Chile - north','Chile - north (near 19 deg South).',-21.46,-17.51,-70.41,-68.44,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2403,'Chile - south','Chile - south (near 43 deg South).',-49.25,-39.29,-75.72,-71.11,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2404,'Oman - block 4','Oman - block 4.',19.58,21.17,56.5,59.02,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2405,'Kazakhstan - Caspian Sea','Kazakhstan - Caspian Sea.',36.57,47.2,46.7,54.76,'','','',NULL,'','EPSG','EPSG','2000-02-02','',0),
(2406,'Qatar - offshore','Qatar - offshore.',24.6,27.03,50.61,53.07,'','','',NULL,'','EPSG','EPSG','2000-10-19','',0),
(2407,'Greenland - S of 72 deg N','Greenland - south of 72 deg North.',59.75,72.0,-55.0,-40.0,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2408,'Japan - Okinawa','Japan - Okinawa.',26.0,27.5,127.5,128.5,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2409,'Asia - Japan and South Korea','Japan; South Korea; Okinawa.',24.25,45.49,123.68,145.81,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2410,'Canada - NWT; Nunavut; Saskatchewan','Canada - Northwest Territories; Nunavut; Saskatchewan.',49.0,83.11,-136.45,-61.08,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2411,'Asia - India and Nepal','India; Nepal.',6.75,35.51,68.14,97.38,'','','',NULL,'','EPSG','EPSG','1999-10-20','',0),
(2412,'United States (USA) - Alaska mainland','United States (USA) - Alaska mainland.',54.35,71.35,-173.11,-129.99,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2413,'Bahamas (Except San Salvador Island)','Bahamas (Except San Salvador Island).',20.37,30.48,-80.95,-70.67,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2414,'Bahamas (San Salvador Island)','Bahamas (San Salvador Island).',23.94,24.13,-74.57,-74.42,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2415,'Canada - Manitoba and Ontario','Canada - Manitoba; Ontario.',41.68,60.0,-102.0,-74.32,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2416,'Canada - New Brunswick; Newfoundland and Labrador; Nova Scotia; Quebec','Canada - New Brunswick (NB); Newfoundland and Labrador; Nova Scotia (NS); Quebec.',43.46,62.56,-79.76,-52.62,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.463',0),
(2417,'Canada - Yukon','Canada - Yukon.',60.0,69.65,-141.0,-123.82,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2418,'Caribbean - central (DMA tfm)','Antigua; Barbados; Barbuda; Cuba; Dominican Republic; Grand Cayman; Jamaica; Turks and Caicos Islands. Note: does not include other islands within this geographic area.',16.5,23.77,-85.16,-61.62,'','','',NULL,'','EPSG','EPSG','2005-05-21','2004.54 2005.22',0),
(2419,'Central America - Belize to Costa Rica','Belize; Costa Rica; El Salvador; Guatemala; Honduras; Nicaragua.',8.03,18.49,-92.25,-82.56,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2420,'Europe - west (DMA ED50 mean)','Austria; Belgium; Denmark; Finland; Faroe islands; France; Germany (west); Gibraltar; Greece; Italy; Luxembourg; Netherlands; Norway; Portugal; Spain; Sweden; Switzerland.',36.0,71.05,-9.4,31.6,'','','',NULL,'','EPSG','EPSG','2006-03-16','2005.47 2005.471',0),
(2421,'Europe - west central (by country)','Austria; Denmark; France; Germany (west); Netherlands; Switzerland.',42.5,57.5,-4.6,22.5,'','','',NULL,'','EPSG','EPSG','1996-10-18','',0),
(2424,'United States (USA) - HARN','American Samoa; Puerto Rico and the Virgin Islands; United States (USA) - Alabama; Alaska; Arizona; Arkansas; California; Colorado; Connecticut; Delaware; Florida; Georgia; Hawaii; Idaho; Illinois; Indiana; Iowa; Kansas; Kentucky; Louisiana; Maine; Maryland; Massachusetts; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; Nevada; New Hampshire; New Jersey; New Mexico; New York; North Carolina; North Dakota; Ohio; Oklahoma; Oregon; Pennsylvania; Rhode Island; South Carolina; South Dakota; Tennessee; Texas; Utah; Vermont; Virginia; Washington; West Virginia; Wisconsin; Wyoming.',NULL,NULL,NULL,NULL,'','','',NULL,'','EPSG','EPSG','2000-10-19','',1),
(2425,'Japan - 45d 20m to 46d N; 141d to 142d E','Japan - 45deg 20min to 46deg North; 141deg to 142deg East.',45.33,46.0,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2426,'Japan - 45d 20m to 46d N; 142d to 143d E','Japan - 45deg 20min to 46deg North; 142deg to 143deg East.',45.33,46.0,142.0,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2427,'Japan - 44deg 40min to 45deg 20min N; 141deg to 142deg E','Japan - 44deg 40min to 45deg 20min North; 141deg to 142deg East.',44.67,45.33,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2428,'Japan - 44deg 40min to 45deg 20min N; 142deg to 143deg E','Japan - 44deg 40min to 45deg 20min North; 142deg to 143deg East.',44.67,45.33,142.0,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2429,'Japan - 44deg to 44deg 40min N; 141deg to 142deg E','Japan - 44deg to 44deg 40min North; 141deg to 142deg East.',44.0,44.67,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2430,'Japan - 44deg to 44deg 40min N; 142deg to 143deg E','Japan - 44deg to 44deg 40min North; 142deg to 143deg East.',44.0,44.67,142.0,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2431,'Japan - 44deg to 44deg 40min N; 143deg to 144deg E','Japan - 44deg to 44deg 40min North; 143deg to 144deg East.',44.0,44.67,143.0,144.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2432,'Japan - 44deg to 44deg 40min N; 144deg to 145deg E','Japan - 44deg to 44deg 40min North; 144deg to 145deg East.',44.0,44.67,144.0,145.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2433,'Japan - 43deg 20min to 44deg N; 141deg to 142deg E','Japan - 43deg 20min to 44deg North; 141deg to 142deg East.',43.33,44.0,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2434,'Japan - 43deg 20min to 44deg N; 142deg to 143deg E','Japan - 43deg 20min to 44deg North; 142deg to 143deg East.',43.33,44.0,142.0,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2435,'Japan - 43deg 20min to 44deg N; 143deg to 144deg E','Japan - 43deg 20min to 44deg North; 143deg to 144deg East.',43.33,44.0,143.0,144.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2436,'Japan - 43deg 20min to 44deg N; 144deg to 145deg E','Japan - 43deg 20min to 44deg North; 144deg to 145deg East.',43.33,44.0,144.0,145.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2437,'Japan - 43deg 20min to 44deg N; 145deg to 146deg E','Japan - 43deg 20min to 44deg North; 145deg to 146deg East.',43.33,44.0,145.0,146.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2438,'Japan - 42deg 40min to 43deg 20min N; 140deg to 141deg E','Japan - 42deg 40min to 43deg 20min North; 140deg to 141deg East.',42.67,43.33,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2439,'Japan - 42deg 40min to 43deg 20min N; 141deg to 142deg E','Japan - 42deg 40min to 43deg 20min North; 141deg to 142deg East.',42.67,43.33,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1999-11-12','',0),
(2440,'Japan - 42deg 40min to 43deg 20min N; 142deg to 143deg E','Japan - 42deg 40min to 43deg 20min North; 142deg to 143deg East.',42.67,43.33,142.0,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2441,'Japan - 42deg 40min to 43deg 20min N; 143deg to 144deg E','Japan - 42deg 40min to 43deg 20min North; 143deg to 144deg East.',42.67,43.33,143.0,144.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2442,'Japan - 42deg 40min to 43deg 20min N; 144deg to 145deg E','Japan - 42deg 40min to 43deg 20min North; 144deg to 145deg East.',42.67,43.33,144.0,145.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2443,'Japan - 42deg 40min to 43deg 20min N; 145deg to 146deg E','Japan - 42deg 40min to 43deg 20min North; 145deg to 146deg East.',42.67,43.33,145.0,146.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2444,'Japan - 42deg to 42deg 40min N; 139deg to 140deg E','Japan - 42deg to 42deg 40min North; 139deg to 140deg East.',42.0,42.67,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2445,'Japan - 42deg to 42deg 40min N; 140deg to 141deg E','Japan - 42deg to 42deg 40min North; 140deg to 141deg East.',42.0,42.67,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2446,'Japan - 42deg to 42deg 40min N; 141deg to 142deg E','Japan - 42deg to 42deg 40min North; 141deg to 142deg East.',42.0,42.67,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2447,'Japan - 42deg to 42deg 40min N; 142deg to 143deg E','Japan - 42deg to 42deg 40min North; 142deg to 143deg East.',42.0,42.67,142.0,143.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2448,'Japan - 42deg to 42deg 40min N; 143deg to 144deg E','Japan - 42deg to 42deg 40min North; 143deg to 144deg East.',42.0,42.67,143.0,144.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2449,'Japan - 41deg 20min to 42deg N; 140deg to 141deg E','Japan - 41deg 20min to 42deg North; 140deg to 141deg East.',41.33,42.0,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2450,'Japan - 41deg 20min to 42deg N; 141deg to 142deg E','Japan - 41deg 20min to 42deg North; 141deg to 142deg East.',41.33,42.0,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2451,'Japan - 40deg 40min to 41deg 20min N; 140deg to 141deg E','Japan - 40deg 40min to 41deg 20min North; 140deg to 141deg East.',40.67,41.33,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2452,'Japan - 40deg 40min to 41deg 20min N; 141deg to 142deg E','Japan - 40deg 40min to 41deg 20min North; 141deg to 142deg East.',40.67,41.33,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2453,'Japan - 40deg to 40deg 40min N; 139deg to 140deg E','Japan - 40deg to 40deg 40min North; 139deg to 140deg East.',40.0,40.67,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2454,'Japan - 40deg to 40deg 40min N; 140deg to 141deg E','Japan - 40deg to 40deg 40min North; 140deg to 141deg East.',40.0,40.67,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2455,'Japan - 40deg to 40deg 40min N; 141deg to 142deg E','Japan - 40deg to 40deg 40min North; 141deg to 142deg East.',40.0,40.67,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2456,'Japan - 39deg 20min to 40deg N; 139deg to 140deg E','Japan - 39deg 20min to 40deg North; 139deg to 140deg East.',39.33,40.0,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2457,'Japan - 39deg 20min to 40deg N; 140deg to 141deg E','Japan - 39deg 20min to 40deg North; 140deg to 141deg East.',39.33,40.0,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2458,'Japan - 39deg 20min to 40deg N; 141deg to 142deg E','Japan - 39deg 20min to 40deg North; 141deg to 142deg East.',39.33,40.0,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2459,'Japan - 38deg 40min to 39deg 20min N; 139deg to 140deg E','Japan - 38deg 40min to 39deg 20min North; 139deg to 140deg East.',38.67,39.33,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2460,'Japan - 38deg 40min to 39deg 20min N; 140deg to 141deg E','Japan - 38deg 40min to 39deg 20min North; 140deg to 141deg East.',38.67,39.33,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2461,'Japan - 38deg 40min to 39deg 20min N; 141deg to 142deg E','Japan - 38deg 40min to 39deg 20min North; 141deg to 142deg East.',38.67,39.33,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2462,'Japan - 38deg to 38deg 40min N; 139deg to 140deg E','Japan - 38deg to 38deg 40min North; 139deg to 140deg East.',38.0,38.67,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2463,'Japan - 38deg to 38deg 40min N; 140deg to 141deg E','Japan - 38deg to 38deg 40min North; 140deg to 141deg East.',38.0,38.67,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2464,'Japan - 38deg to 38deg 40min N; 141deg to 142deg E','Japan - 38deg to 38deg 40min North; 141deg to 142deg East.',38.0,38.67,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2465,'Japan - 37deg 20min to 38deg N; 136deg to 137deg E','Japan - 37deg 20min to 38deg North; 136deg to 137deg East.',37.33,38.0,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2466,'Japan - 37deg 20min to 38deg N; 137deg to 138deg E','Japan - 37deg 20min to 38deg North; 137deg to 138deg East.',37.33,38.0,137.0,138.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2467,'Japan - 37deg 20min to 38deg N; 138deg to 139deg E','Japan - 37deg 20min to 38deg North; 138deg to 139deg East.',37.33,38.0,138.0,139.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2468,'Japan - 37deg 20min to 38deg N; 139deg to 140deg E','Japan - 37deg 20min to 38deg North; 139deg to 140deg East.',37.33,38.0,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2469,'Japan - 37deg 20min to 38deg N; 140deg to 141deg E','Japan - 37deg 20min to 38deg North; 140deg to 141deg East.',37.33,38.0,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2470,'Japan - 37deg 20min to 38deg N; 141deg to 142deg E','Japan - 37deg 20min to 38deg North; 141deg to 142deg East.',37.33,38.0,141.0,142.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2471,'Japan - 36deg 40min to 37deg 20min N; 136deg to 137deg E','Japan - 36deg 40min to 37deg 20min North; 136deg to 137deg East.',36.67,37.33,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2472,'Japan - 36deg 40min to 37deg 20min N; 137deg to 138deg E','Japan - 36deg 40min to 37deg 20min North; 137deg to 138deg East.',36.67,37.33,137.0,138.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2473,'Japan - 36deg 40min to 37deg 20min N; 138deg to 139deg E','Japan - 36deg 40min to 37deg 20min North; 138deg to 139deg East.',36.67,37.33,138.0,139.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2474,'Japan - 36deg 40min to 37deg 20min N; 139deg to 140deg E','Japan - 36deg 40min to 37deg 20min North; 139deg to 140deg East.',36.67,37.33,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2475,'Japan - 36deg 40min to 37deg 20min N; 140deg to 141deg E','Japan - 36deg 40min to 37deg 20min North; 140deg to 141deg East.',36.67,37.33,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2476,'Japan - 36deg to 36deg 40min N; 136deg to 137deg E','Japan - 36deg to 36deg 40min North; 136deg to 137deg East.',36.0,36.67,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2477,'Japan - 36deg to 36deg 40min N; 137deg to 138deg E','Japan - 36deg to 36deg 40min North; 137deg to 138deg East.',36.0,36.67,137.0,138.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2478,'Japan - 36deg to 36deg 40min N; 138deg to 139deg E','Japan - 36deg to 36deg 40min North; 138deg to 139deg East.',36.0,36.67,138.0,139.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2479,'Japan - 36deg to 36deg 40min N; 139deg to 140deg E','Japan - 36deg to 36deg 40min North; 139deg to 140deg East.',36.0,36.67,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2480,'Japan - 36deg to 36deg 40min N; 140deg to 141deg E','Japan - 36deg to 36deg 40min North; 140deg to 141deg East.',36.0,36.67,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2481,'Japan - 35deg 20min to 36deg N; 132deg to 133deg E','Japan - 35deg 20min to 36deg North; 132deg to 133deg East.',35.33,36.0,132.0,133.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2482,'Japan - 35deg 20min to 36deg N; 133deg to 134deg E','Japan - 35deg 20min to 36deg North; 133deg to 134deg East.',35.33,36.0,133.0,134.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2483,'Japan - 35deg 20min to 36deg N; 134deg to 135deg E','Japan - 35deg 20min to 36deg North; 134deg to 135deg East.',35.33,36.0,134.0,135.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2484,'Japan - 35deg 20min to 36deg N; 135deg to 136deg E','Japan - 35deg 20min to 36deg North; 135deg to 136deg East.',35.33,36.0,135.0,136.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2485,'Japan - 35deg 20min to 36deg N; 136deg to 137deg E','Japan - 35deg 20min to 36deg North; 136deg to 137deg East.',35.33,36.0,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2486,'Japan - 35deg 20min to 36deg N; 137deg to 138deg E','Japan - 35deg 20min to 36deg North; 137deg to 138deg East.',35.33,36.0,137.0,138.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2487,'Japan - 35deg 20min to 36deg N; 138deg to 139deg E','Japan - 35deg 20min to 36deg North; 138deg to 139deg East.',35.33,36.0,138.0,139.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2488,'Japan - 35deg 20min to 36deg N; 139deg to 140deg E','Japan - 35deg 20min to 36deg North; 139deg to 140deg East.',35.33,36.0,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2489,'Japan - 35deg 20min to 36deg N; 140deg to 141deg E','Japan - 35deg 20min to 36deg North; 140deg to 141deg East.',35.33,36.0,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2490,'Japan - 34deg 40min to 35deg 20min N; 132deg to 133deg E','Japan - 34deg 40min to 35deg 20min North; 132deg to 133deg East.',34.67,35.33,132.0,133.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2491,'Japan - 34deg 40min to 35deg 20min N; 133deg to 134deg E','Japan - 34deg 40min to 35deg 20min North; 133deg to 134deg East.',34.67,35.33,133.0,134.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2492,'Japan - 34deg 40min to 35deg 20min N; 134deg to 135deg E','Japan - 34deg 40min to 35deg 20min North; 134deg to 135deg East.',34.67,35.33,134.0,135.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2493,'Japan - 34deg 40min to 35deg 20min N; 135deg to 136deg E','Japan - 34deg 40min to 35deg 20min North; 135deg to 136deg East.',34.67,35.33,135.0,136.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2494,'Japan - 34deg 40min to 35deg 20min N; 136deg to 137deg E','Japan - 34deg 40min to 35deg 20min North; 136deg to 137deg East.',34.67,35.33,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2495,'Japan - 34deg 40min to 35deg 20min N; 137deg to 138deg E','Japan - 34deg 40min to 35deg 20min North; 137deg to 138deg East.',34.67,35.33,137.0,138.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2496,'Japan - 34deg 40min to 35deg 20min N; 138deg to 139deg E','Japan - 34deg 40min to 35deg 20min North; 138deg to 139deg East.',34.67,35.33,138.0,139.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2497,'Japan - 34deg 40min to 35deg 20min N; 139deg to 140deg E','Japan - 34deg 40min to 35deg 20min North; 139deg to 140deg East.',34.67,35.33,139.0,140.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2498,'Japan - 34deg 40min to 35deg 20min N; 140deg to 141deg E','Japan - 34deg 40min to 35deg 20min North; 140deg to 141deg East.',34.67,35.33,140.0,141.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2499,'Japan - 34deg to 34deg 40min N; 130deg to 131deg E','Japan - 34deg to 34deg 40min North; 130deg to 131deg East.',34.0,34.67,130.0,131.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2500,'Japan - 34deg to 34deg 40min N; 131deg to 132deg E','Japan - 34deg to 34deg 40min North; 131deg to 132deg East.',34.0,34.67,131.0,132.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2501,'Japan - 34deg to 34deg 40min N; 132deg to 133deg E','Japan - 34deg to 34deg 40min North; 132deg to 133deg East.',34.0,34.67,132.0,133.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2502,'Japan - 34deg to 34deg 40min N; 133deg to 134deg E','Japan - 34deg to 34deg 40min North; 133deg to 134deg East.',34.0,34.67,133.0,134.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2503,'Japan - 34deg to 34deg 40min N; 134deg to 135deg E','Japan - 34deg to 34deg 40min North; 134deg to 135deg East.',34.0,34.67,134.0,135.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2504,'Japan - 34deg to 34deg 40min N; 135deg to 136deg E','Japan - 34deg to 34deg 40min North; 135deg to 136deg East.',34.0,34.67,135.0,136.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2505,'Japan - 34deg to 34deg 40min N; 136deg to 137deg E','Japan - 34deg to 34deg 40min North; 136deg to 137deg East.',34.0,34.67,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2506,'Japan - 34deg to 34deg 40min N; 137deg to 138deg E','Japan - 34deg to 34deg 40min North; 137deg to 138deg East.',34.0,34.67,137.0,138.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2507,'Japan - 34deg to 34deg 40min N; 138deg to 139deg E','Japan - 34deg to 34deg 40min North; 138deg to 139deg East.',34.0,34.67,138.0,139.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2508,'Japan - 33deg 20min to 34deg N; 129deg to 130deg E','Japan - 33deg 20min to 34deg North; 129deg to 130deg East.',33.33,34.0,129.0,130.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2509,'Japan - 33deg 20min to 34deg N; 130deg to 131deg E','Japan - 33deg 20min to 34deg North; 130deg to 131deg East.',33.33,34.0,130.0,131.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2510,'Japan - 33deg 20min to 34deg N; 131deg to 132deg E','Japan - 33deg 20min to 34deg North; 131deg to 132deg East.',33.33,34.0,131.0,132.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2511,'Japan - 33deg 20min to 34deg N; 132deg to 133deg E','Japan - 33deg 20min to 34deg North; 132deg to 133deg East.',33.33,34.0,132.0,133.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2512,'Japan - 33deg 20min to 34deg N; 133deg to 134deg E','Japan - 33deg 20min to 34deg North; 133deg to 134deg East.',33.33,34.0,133.0,134.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2513,'Japan - 33deg 20min to 34deg N; 134deg to 135deg E','Japan - 33deg 20min to 34deg North; 134deg to 135deg East.',33.33,34.0,134.0,135.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2514,'Japan - 33deg 20min to 34deg N; 135deg to 136deg E','Japan - 33deg 20min to 34deg North; 135deg to 136deg East.',33.33,34.0,135.0,136.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2515,'Japan - 33deg 20min to 34deg N; 136deg to 137deg E','Japan - 33deg 20min to 34deg North; 136deg to 137deg East.',33.33,34.0,136.0,137.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2516,'Japan - 32deg 40min to 33deg 20min N; 129deg to 130deg E','Japan - 32deg 40min to 33deg 20min North; 129deg to 130deg East.',32.67,33.33,129.0,130.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2517,'Japan - 32deg 40min to 33deg 20min N; 130deg to 131deg E','Japan - 32deg 40min to 33deg 20min North; 130deg to 131deg East.',32.67,33.33,130.0,131.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2518,'Japan - 32deg 40min to 33deg 20min N; 131deg to 132deg E','Japan - 32deg 40min to 33deg 20min North; 131deg to 132deg East.',32.67,33.33,131.0,132.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2519,'Japan - 32deg 40min to 33deg 20min N; 132deg to 133deg E','Japan - 32deg 40min to 33deg 20min North; 132deg to 133deg East.',32.67,33.33,132.0,133.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2520,'Japan - 32deg 40min to 33deg 20min N; 133deg to 134deg E','Japan - 32deg 40min to 33deg 20min North; 133deg to 134deg East.',32.67,33.33,133.0,134.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2521,'Japan - 32deg 40min to 33deg 20min N; 134deg to 135deg E','Japan - 32deg 40min to 33deg 20min North; 134deg to 135deg East.',32.67,33.33,134.0,135.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2522,'Japan - 32deg to 32deg 40min N; 130deg to 131deg E','Japan - 32deg to 32deg 40min North; 130deg to 131deg East.',32.0,32.67,130.0,131.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2523,'Japan - 32deg to 32deg 40min N; 131deg to 132deg E','Japan - 32deg to 32deg 40min North; 131deg to 132deg East.',32.0,32.67,131.0,132.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2524,'Japan - 31deg 20min to 32deg N; 130deg to 131deg E','Japan - 31deg 20min to 32deg North; 130deg to 131deg East.',31.33,32.0,130.0,131.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2525,'Japan - 31deg 20min to 32deg N; 131deg to 132deg E','Japan - 31deg 20min to 32deg North; 131deg to 132deg East.',31.33,32.0,131.0,132.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2526,'Japan - 30deg 40min to 31deg 20min N; 130deg to 131deg E','Japan - 30deg 40min to 31deg 20min North; 130deg to 131deg East.',30.67,31.33,130.0,131.0,'','','',NULL,'','EPSG','EPSG','1998-12-12','',0),
(2527,'United States (USA) - Texas - SPCS83 - S central','United States (USA) - Texas between approximately 30d 10m & 28d 05m North - counties of Aransas; Atascosa; Austin; Bandera; Bee; Bexar; Brazoria; Brewster; Caldwell; Calhoun; Chambers; Colorado; Comal; De Witt; Dimmit; Edwards; Fayette; Fort Bend; Frio; Galveston; Goliad; Gonzales; Guadalupe; Harris; Hays; Jackson; Jefferson; Karnes; Kendall; Kerr; Kinney; La Salle; Lavaca; Live Oak; Matagorda; Maverick; McMullen; Medina; Presidio; Real; Refugio; Terrell; Uvalde; Val Verde; Victoria; Waller; Wharton; Wilson; Zavala.',27.82,30.66,-105.0,-93.83,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2528,'United States (USA) - Texas - SPCS83 - S','United States (USA) - Texas south of approximately 28d 05m North - counties of Brooks; Cameron; Duval; Hidalgo; Jim Hogg; Jim Wells; Kenedy; Kleberg; Nueces; San Patricio; Starr; Webb; Willacy; Zapata.',25.83,28.2,-100.2,-97.12,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2529,'United States (USA) - Louisiana - SPCS83 - S','United States (USA) - Louisiana south of approximately 30d 55m North - counties of Acadia; Allen; Ascension; Assumption; Beauregard; Calcasieu; Cameron; East Baton Rouge; East Feliciana; Evangeline; Iberia; Iberville; Jefferson; Jefferson Davis; Lafayette; LaFourche; Livingston; Orleans; Plaquemines; Pointe Coupee; St. Bernard; St. Charles; St. Helena; St. James; St. John the Baptist; St. Landry; St. Martin; St. Mary; St. Tammany; Tangipahoa; Terrebonne; Vermilion; Washington; West Baton Rouge; West Feliciana.',28.88,31.02,-93.93,-88.81,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2530,'United Kingdom (UK) - Northern Ireland - onshore','United Kingdom (UK) - Northern Ireland (Ulster) - onshore.',54.01,55.31,-8.2,-5.42,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2531,'Denmark - Jutland and Fuen','Denmark - Jutland and Fuen.',54.73,57.75,8.09,11.2,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2532,'Denmark - Zealand and Lolland','Denmark - Zealand and Lolland.',54.56,56.13,10.88,12.62,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2533,'Denmark - Bornholm','Denmark - Bornholm.',54.99,55.31,14.68,15.15,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2534,'World - N hemisphere - 3-degree CM 027 deg E','Between 25 deg 30 min and 28 deg 30 min East, northern hemisphere.',0.0,84.0,25.5,28.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2535,'World - N hemisphere - 3-degree CM 030 deg E','Between 28 deg 30 min and 31 deg 30 min East, northern hemisphere.',0.0,84.0,28.5,31.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2536,'World - N hemisphere - 3-degree CM 033 deg E','Between 31 deg 30 min and 34 deg 30 min East, northern hemisphere.',0.0,84.0,31.5,34.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2537,'World - N hemisphere - 3-degree CM 036 deg E','Between 34 deg 30 min and 37 deg 30 min East, northern hemisphere.',0.0,84.0,34.5,37.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2538,'World - N hemisphere - 3-degree CM 039 deg E','Between 37 deg 30 min and 40 deg 30 min East, northern hemisphere.',0.0,84.0,37.5,40.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2539,'World - N hemisphere - 3-degree CM 042 deg E','Between 40 deg 30 min and 43 deg 30 min East, northern hemisphere.',0.0,84.0,40.5,43.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2540,'World - N hemisphere - 3-degree CM 045 deg E','Between 43 deg 30 min and 46 deg 30 min East, northern hemisphere.',0.0,84.0,43.5,46.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2541,'Germany - West Germany N','Germany - states of former West Germany - north of 52deg 20min N.',52.33,55.04,6.64,11.65,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2542,'Germany - West Germany C','Germany - states of former West Germany - between 50deg 20min and 52deg 20min N.',50.33,52.33,5.87,12.42,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2543,'Germany - West Germany S','Germany - states of former West Germany - south of 50deg 20min N.',47.27,50.33,6.09,13.83,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2544,'Germany - Thuringen','Germany - Thuringen.',50.19,51.65,9.87,12.65,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2545,'Germany - Sachsen','Germany - Sachsen.',50.15,51.69,11.87,15.05,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2546,'Romania - offshore','Romania - offshore.',43.62,45.2,28.56,31.5,'','','',NULL,'','EPSG','EPSG','2001-11-06','',0),
(2547,'Serbia and Montenegro - Montenegro','Serbia and Montenegro - Montenegro.',41.82,43.53,18.44,20.37,'','','',NULL,'','EPSG','EPSG','2006-02-03','2005.89',0),
(2548,'Africa - AOF W of 10deg W','French West Africa west of 10deg West - Guinea, Mauritania, Senegal.',8.3,26.0,-17.5,-10.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2549,'Africa - AOF 10 to 3.5deg W','French West Africa between 10deg and 3deg 30min West - Burkina Faso, Cote d''Ivoire (Ivory Coast), Guinea, Mali, Mauritania.',4.25,27.3,-10.0,-3.5,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2550,'Africa - AOF 3.5deg W to 4deg E','French West Africa between 3deg 30min West and 4deg East. - Benin, Burkina Faso, Mali, Niger, Togo.',6.0,24.3,-3.5,4.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2551,'Africa - AOF 4 to 9deg E','French West Africa east of 4deg East - Niger.',12.7,23.54,4.0,9.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2552,'Africa - AEF 9 to 14deg E','French Equatorial Africa west of 14deg East - Cameroon, Congo, Gabon.',-5.1,13.1,8.7,14.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2553,'Africa - AEF 14 to 21deg E','French Equatorial Africa between 14deg and 21deg East - Cameroon, Central African Republic, Congo.',-5.1,13.1,14.0,21.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2554,'Africa - AEF east of 21deg E','French Equatorial Africa east of 21deg East - Central African Republic.',4.0,11.01,21.0,27.51,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2555,'Cameroon - coastal area','Cameroon - coastal area.',1.5,5.0,8.4,12.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2556,'Greenland - north of 81 deg N','Greenland - north of 81 deg North.',81.0,85.05,-63.67,-13.67,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2557,'Greenland - east - 78 to 81 deg N','Greenland - east of 44 deg West and between 78 deg and 81 deg North.',78.0,81.0,-44.0,-11.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2558,'Greenland - east - 75 to 78 deg N','Greenland - east of 42 deg West and between 75 deg and 78 deg North.',75.0,78.0,-42.0,-17.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2559,'Greenland - east - 72 to 75 deg N','Greenland - east of 38 deg West and between 72 deg and 75 deg North.',72.0,75.0,-38.0,-17.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2560,'Greenland - east - 69 to 72 deg N','Greenland - east of 38 deg West and between 69 deg and 72 deg North.',69.0,72.0,-38.0,-20.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2561,'Greenland - east - 66 to 69 deg N','Greenland - east of 42 deg West and between 66 deg and 69 deg North.',66.0,69.0,-42.0,-25.25,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2562,'Greenland - east - 63 to 66 deg N','Greenland - east of 46 deg West and between 63 deg and 66 deg North.',63.0,66.0,-46.0,-35.8,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2563,'Greenland - west - 78 to 81 deg N','Greenland - west of 44 deg West and between 78 deg and 81 deg North.',78.0,81.0,-73.0,-44.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2564,'Greenland - west - 75 to 78 deg N','Greenland - west of 44 deg West and between 75 deg and 78 deg North.',75.0,78.0,-73.0,-44.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2565,'Greenland - west - 72 to 75 deg N','Greenland - west of 38 deg West and between 72 deg and 75 deg North.',72.0,75.0,-60.0,-38.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2566,'Greenland - west - 69 to 72 deg N','Greenland - west of 38 deg West and between 69 deg and 72 deg North.',69.0,72.0,-57.0,-38.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2567,'Greenland - west - 66 to 69 deg N','Greenland - west of 42 deg West and between 66 deg and 69 deg North.',66.0,69.0,-54.0,-42.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2568,'Greenland - west - 63 to 66 deg N','Greenland - west of 46 deg West and between 63 deg and 66 deg North.',63.0,66.0,-54.0,-46.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2569,'Greenland - S of 63 deg N','Greenland - south of 63 deg North.',59.75,63.0,-50.75,-41.25,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2570,'Greenland - Scoresbysund area','Greenland - Scoresbysund area.',68.0,75.0,-30.0,-21.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2571,'Greenland - Ammassalik area','Greenland - Ammassalik area.',65.0,68.0,-40.0,-28.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2572,'Greenland - E of 48d W','Greenland - east of 48 deg West.',60.5,83.6,-48.0,-11.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2573,'Greenland - W of 48d W','Greenland - west of 48 deg West.',59.75,83.0,-73.5,-48.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2574,'Congo - coastal area and offshore','Congo - coastal area and offshore.',-5.5,-4.0,11.0,12.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2575,'Australia - all states','Australia - Australian Capital Territory (ACT); New South Wales (NSW); Northern Territory (NT); Queensland (Qld); South Australia (SA); Tasmania (Tas); Western Australia (WA); Victoria (Vic).',-45.0,-10.0,108.0,155.0,'','','',NULL,'','EPSG','EPSG','2007-01-23','2007.009',0),
(2576,'Australia - AGD84','Australia - Queensland (Qld), South Australia (SA), Western Australia (WA).',-39.0,-10.0,108.0,155.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2577,'Indonesia - Java Sea - ONWJ','Indonesia - Java Sea - offshore northwest Java.',-6.0,-2.75,106.0,110.0,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2588,'Indonesia - Java Sea - E','Indonesia - eastern Java Sea.',-7.0,-4.0,112.0,118.5,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2589,'Indonesia - Irian Jaya - Tangguh','Indonesia - Irian Jaya - Tangguh.',-3.3,-2.15,131.67,134.0,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2590,'Cameroon - Garoua area','Cameroon - Garoua area.',9.0,9.8,13.0,14.0,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2591,'Cameroon - N''Djamena area','Cameroon - N''Djamena area.',12.0,12.2,15.0,15.3,'','','',NULL,'','EPSG','EPSG','2002-01-18','',0),
(2592,'Azerbaijan - offshore and Sangachal','Azerbaijan - offshore and Sangachal terminal.',40.12,40.33,49.4,51.7,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2593,'Asia - FSU - Azerbaijan and Georgia','Azerbaijan and Georgia',38.26,43.58,40.0,51.68,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2594,'Azerbaijan - coastal area Baku to Astara','Azerbaijan - coastal area Baku to Astara.',38.41,40.42,48.7,50.4,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2595,'Egypt - Western Desert','Egypt - Western Desert.',27.5,30.82,25.0,30.74,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2596,'Argentina - Tierra del Fuego - offshore W of 66W','Argentina - Tierra del Fuego offshore west of 66 deg West.',-54.6,-52.64,-68.64,-66.0,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2597,'Argentina - Tierra del Fuego - offshore E of 66W','Argentina - Tierra del Fuego offshore east of 66 deg West.',-55.0,-52.64,-66.0,-61.0,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2598,'Algeria - District 3','Algeria - District 3 (In Salah).',25.0,32.0,1.5,3.25,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2599,'Algeria - In Amenas','Algeria - In Amenas block.',27.5,28.25,9.0,9.7,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2600,'Algeria - Hassi Bir Reikaz','Algeria - Hassi Bir Reikaz.',31.3,31.5,6.8,7.2,'','','',NULL,'','EPSG','EPSG','2002-02-12','',0),
(2601,'Norway - offshore N of 62 deg N;  Svalbard','Norway - offshore north of 62 deg N. Also Svalbard.',62.0,80.75,-0.5,32.02,'','','',NULL,'','EPSG','EPSG','2003-06-27','2003.141',0),
(2602,'Palestine Territory, Occupied','Palestine Territory, Occupied.',31.2,32.55,34.2,35.57,'','PS','PSE',275,'','ISO 3166 Maintenance Agency.  ftp://ftp.fu-berlin.de/pub/doc/iso','EPSG','2002-06-22','',0),
(2603,'Asia - Middle East - Israel and Palestine Territory','Asia - Middle East - Israel and Palestine Territory.',29.49,33.27,34.22,35.68,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2604,'World - N hemisphere - 3-degree CM 048 deg E','Between 46 deg 30 min and 49 deg 30 min East, northern hemisphere.',0.0,84.0,46.5,49.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2605,'World - N hemisphere - 3-degree CM 051 deg E','Between 49 deg 30 min and 52 deg 30 min East, northern hemisphere.',0.0,84.0,49.5,52.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2606,'World - N hemisphere - 3-degree CM 054 deg E','Between 52 deg 30 min and 55 deg 30 min East, northern hemisphere.',0.0,84.0,52.5,55.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2607,'World - N hemisphere - 3-degree CM 057 deg E','Between 55 deg 30 min and 58 deg 30 min East, northern hemisphere.',0.0,84.0,55.5,58.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2608,'World - N hemisphere - 3-degree CM 060 deg E','Between 58 deg 30 min and 61 deg 30 min East, northern hemisphere.',0.0,84.0,58.5,61.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2609,'World - N hemisphere - 3-degree CM 063 deg E','Between 61 deg 30 min and 64 deg 30 min East, northern hemisphere.',0.0,84.0,61.5,64.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2610,'World - N hemisphere - 3-degree CM 066 deg E','Between 64 deg 30 min and 67 deg 30 min East, northern hemisphere.',0.0,84.0,64.5,67.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2611,'World - N hemisphere - 3-degree CM 069 deg E','Between 67 deg 30 min and 70 deg 30 min East, northern hemisphere.',0.0,84.0,67.5,70.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2612,'World - N hemisphere - 3-degree CM 072 deg E','Between 70 deg 30 min and 73 deg 30 min East, northern hemisphere.',0.0,84.0,70.5,73.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2613,'World - N hemisphere - 3-degree CM 075 deg E','Between 73 deg 30 min and 76 deg 30 min East, northern hemisphere.',0.0,84.0,73.5,76.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2614,'World - N hemisphere - 3-degree CM 078 deg E','Between 76 deg 30 min and 79 deg 30 min East, northern hemisphere.',0.0,84.0,76.5,79.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2615,'World - N hemisphere - 3-degree CM 081 deg E','Between 79 deg 30 min and 82 deg 30 min East, northern hemisphere.',0.0,84.0,79.5,82.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2616,'World - N hemisphere - 3-degree CM 084 deg E','Between 82 deg 30 min and 85 deg 30 min East, northern hemisphere.',0.0,84.0,82.5,85.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2617,'World - N hemisphere - 3-degree CM 087 deg E','Between 85 deg 30 min and 88 deg 30 min East, northern hemisphere.',0.0,84.0,85.5,88.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2618,'World - N hemisphere - 3-degree CM 090 deg E','Between 88 deg 30 min and 91 deg 30 min East, northern hemisphere.',0.0,84.0,88.5,91.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2619,'World - N hemisphere - 3-degree CM 093 deg E','Between 91 deg 30 min and 94 deg 30 min East, northern hemisphere.',0.0,84.0,91.5,94.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2620,'World - N hemisphere - 3-degree CM 096 deg E','Between 94 deg 30 min and 97 deg 30 min East, northern hemisphere.',0.0,84.0,94.5,97.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2621,'World - N hemisphere - 3-degree CM 099 deg E','Between 97 deg 30 min and 100 deg 30 min East, northern hemisphere.',0.0,84.0,97.5,100.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2622,'World - N hemisphere - 3-degree CM 102 deg E','Between 100 deg 30 min and 103 deg 30 min East, northern hemisphere.',0.0,84.0,100.5,103.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2623,'World - N hemisphere - 3-degree CM 105 deg E','Between 103 deg 30 min and 106 deg 30 min East, northern hemisphere.',0.0,84.0,103.5,106.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2624,'World - N hemisphere - 3-degree CM 108 deg E','Between 106 deg 30 min and 109 deg 30 min East, northern hemisphere.',0.0,84.0,106.5,109.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2625,'World - N hemisphere - 3-degree CM 111 deg E','Between 109 deg 30 min and 112 deg 30 min East, northern hemisphere.',0.0,84.0,109.5,112.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2626,'World - N hemisphere - 3-degree CM 114 deg E','Between 112 deg 30 min and 115 deg 30 min East, northern hemisphere.',0.0,84.0,112.5,115.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2627,'World - N hemisphere - 3-degree CM 117 deg E','Between 115 deg 30 min and 118 deg 30 min East, northern hemisphere.',0.0,84.0,115.5,118.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2628,'World - N hemisphere - 3-degree CM 120 deg E','Between 118 deg 30 min and 121 deg 30 min East, northern hemisphere.',0.0,84.0,118.5,121.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2629,'World - N hemisphere - 3-degree CM 123 deg E','Between 121 deg 30 min and 124 deg 30 min East, northern hemisphere.',0.0,84.0,121.5,124.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2630,'World - N hemisphere - 3-degree CM 126 deg E','Between 124 deg 30 min and 127 deg 30 min East, northern hemisphere.',0.0,84.0,124.5,127.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2631,'World - N hemisphere - 3-degree CM 129 deg E','Between 127 deg 30 min and 130 deg 30 min East, northern hemisphere.',0.0,84.0,127.5,130.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2632,'World - N hemisphere - 3-degree CM 132 deg E','Between 130 deg 30 min and 133 deg 30 min East, northern hemisphere.',0.0,84.0,130.5,133.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2633,'World - N hemisphere - 3-degree CM 135 deg E','Between 133 deg 30 min and 136 deg 30 min East, northern hemisphere.',0.0,84.0,133.5,136.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2634,'World - N hemisphere - 3-degree CM 138 deg E','Between 136 deg 30 min and 139 deg 30 min East, northern hemisphere.',0.0,84.0,136.5,139.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2635,'World - N hemisphere - 3-degree CM 141 deg E','Between 139 deg 30 min and 142 deg 30 min East, northern hemisphere.',0.0,84.0,139.5,142.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2636,'World - N hemisphere - 3-degree CM 144 deg E','Between 142 deg 30 min and 145 deg 30 min East, northern hemisphere.',0.0,84.0,142.5,145.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2637,'World - N hemisphere - 3-degree CM 147 deg E','Between 145 deg 30 min and 148 deg 30 min East, northern hemisphere.',0.0,84.0,145.5,148.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2638,'World - N hemisphere - 3-degree CM 150 deg E','Between 148 deg 30 min and 151 deg 30 min East, northern hemisphere.',0.0,84.0,148.5,151.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2639,'World - N hemisphere - 3-degree CM 153 deg E','Between 151 deg 30 min and 154 deg 30 min East, northern hemisphere.',0.0,84.0,151.5,154.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2640,'World - N hemisphere - 3-degree CM 156 deg E','Between 154 deg 30 min and 157 deg 30 min East, northern hemisphere.',0.0,84.0,154.5,157.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2641,'World - N hemisphere - 3-degree CM 159 deg E','Between 157 deg 30 min and 160 deg 30 min East, northern hemisphere.',0.0,84.0,157.5,160.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2642,'World - N hemisphere - 3-degree CM 162 deg E','Between 160 deg 30 min and 163 deg 30 min East, northern hemisphere.',0.0,84.0,160.5,163.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2643,'World - N hemisphere - 3-degree CM 165 deg E','Between 163 deg 30 min and 166 deg 30 min East, northern hemisphere.',0.0,84.0,163.5,166.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2644,'World - N hemisphere - 3-degree CM 168 deg E','Between 166 deg 30 min and 169 deg 30 min East, northern hemisphere.',0.0,84.0,166.5,169.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2645,'World - N hemisphere - 3-degree CM 171 deg E','Between 169 deg 30 min and 172 deg 30 min East, northern hemisphere.',0.0,84.0,169.5,172.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2646,'World - N hemisphere - 3-degree CM 174 deg E','Between 172 deg 30 min and 175 deg 30 min East, northern hemisphere.',0.0,84.0,172.5,175.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2647,'World - N hemisphere - 3-degree CM 177 deg E','Between 175 deg 30 min and 178 deg 30 min East, northern hemisphere.',0.0,84.0,175.5,178.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2648,'World - N hemisphere - 3-degree CM 180 deg','Between 178 deg 30 min East and 178 deg 30 min West, northern hemisphere.',0.0,84.0,178.5,-178.5,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2649,'World - N hemisphere - 3-degree CM 177 deg W','Between 178 deg 30 min and 175 deg 30 min West, northern hemisphere.',0.0,84.0,-178.5,-175.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2650,'World - N hemisphere - 3-degree CM 174 deg W','Between 175 deg 30 min and 172 deg 30 min West, northern hemisphere.',0.0,84.0,-175.5,-172.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2651,'World - N hemisphere - 3-degree CM 171 deg W','Between 172 deg 30 min and 169 deg 30 min West, northern hemisphere.',0.0,84.0,-172.5,-169.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2652,'World - N hemisphere - 3-degree CM 168 deg W','Between 169 deg 30 min and 166 deg 30 min West, northern hemisphere.',0.0,84.0,-169.5,-166.5,'','','',NULL,'','EPSG','EPSG','2005-06-05','2002.341 2005.144',0),
(2653,'Europe - FSU - 19.5 to 22.5 deg E','Estonia, Latvia, Lithuania, Russian Federation (Kaliningrad) and Ukraine - between 19 deg 30 min and 22 deg 30 min East.',48.24,55.29,19.5,22.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2654,'Europe - FSU - 22.5 to 25.5 deg E','Belarus, Estonia, Latvia, Lithuania, Russian Federation (Kaliningrad) and Ukraine - between 22 deg 30 min and 25 deg 30 min East.',47.71,55.06,22.5,25.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2655,'Europe - FSU - 25.5 to 28.5 deg E','Belarus, Estonia, Latvia, Lithuania, Moldova, Russian Federation and Ukraine - between 25 deg 30 min and 28 deg 30 min East.',45.26,70.0,25.5,28.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2656,'Europe - FSU - 28.5 to 31.5 deg E','Belarus, Moldova, Russian Federation and Ukraine - between 28 deg 30 min and 31 deg 30 min East.',45.21,70.0,28.5,31.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2657,'Europe - FSU - 31.5 to 34.5 deg E','Belarus, Russian Federation and Ukraine - between 31 deg 30 min and 34 deg 30 min East.',44.38,71.0,31.5,34.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2658,'Europe - FSU - 34.5 to 37.5 deg E','Russian Federation and Ukraine - between 34 deg 30 min and 37 deg 30 min East.',44.67,71.0,34.5,37.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2659,'Europe - FSU - 37.5 to 40.5 deg E','Georgia, Russian Federation and Ukraine - between 37 deg 30 min and 40 deg 30 min East.',43.13,70.0,37.5,40.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2660,'Europe - FSU - 40.5 to 43.5 deg E','Georgia, Russian Federation - between 40 deg 30 min and 43 deg 30 min East.',41.02,69.0,40.5,43.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2661,'Europe - FSU - 43.5 to 46.5 deg E','Armenia, Azerbaijan, Georgia and Russian Federation - between 43 deg 30 min and 46 deg 30 min East.',38.84,70.0,43.5,46.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2662,'Europe - FSU - 46.5 to 49.5 deg E','Azerbaijan, Georgia, Kazakhstan and Russian Federation - between 46 deg 30 min and 49 deg 30 min East.',38.31,70.0,46.5,49.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2663,'Europe - FSU - 49.5 to 52.5 deg E','Azerbaijan, Georgia, Kazakhstan and Russian Federation - between 49 deg 30 min and 52 deg 30 min East.',38.26,74.0,49.5,52.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2664,'Asia - FSU - 52.5 to 55.5 deg E','Kazakhstan, Russian Federation and Turkmenistan - between 52 deg 30 min and 55 deg 30 min East.',37.1,82.0,52.5,55.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2665,'Asia - FSU - 55.5 to 58.5 deg E','Kazakhstan, Russian Federation, Turkmenistan and Uzbekistan - between 55 deg 30 min and 58 deg 30 min East.',37.2,82.0,55.5,58.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2666,'Asia - FSU - 58.5 to 61.5 deg E','Kazakhstan, Russian Federation, Turkmenistan and Uzbekistan - between 58 deg 30 min and 61 deg 30 min East.',35.4,82.0,58.5,61.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2667,'Asia - FSU - 61.5 to 64.5 deg E','Kazakhstan, Russian Federation, Turkmenistan and Uzbekistan - between 61 deg 30 min and 64 deg 30 min East.',34.9,82.0,61.5,64.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2668,'Asia - FSU - 64.5 to 67.5 deg E','Kazakhstan, Russian Federation, Tajikistan, Turkmenistan and Uzbekistan - between 64 deg 30 min and 67 deg 30 min East.',36.5,82.0,64.5,67.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2669,'Asia - FSU - 67.5 to 70.5 deg E','Kazakhstan, Kyrgyzstan, Russian Federation, Tajikistan and Uzbekistan - between 67 deg 30 min and 70 deg 30 min East.',36.7,78.0,67.5,70.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2670,'Asia - FSU - 70.5 to 73.5 deg E','Kazakhstan, Kyrgyzstan, Russian Federation, Tajikistan and Uzbekistan - between 70 deg 30 min and 73 deg 30 min East.',36.5,74.0,70.5,73.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2671,'Asia - FSU - 73.5 to 76.5 deg E','Kazakhstan, Kyrgyzstan, Russian Federation and Tajikistan - between 73 deg 30 min and 76 deg 30 min East.',36.4,74.0,73.5,76.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2672,'Asia - FSU - 76.5 to 79.5 deg E','Kazakhstan, Kyrgyzstan and Russian Federation - between 76 deg 30 min and 79 deg 30 min East.',40.1,74.0,76.5,79.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2673,'Asia - FSU - 79.5 to 82.5 deg E','Kazakhstan, Kyrgyzstan and Russian Federation - between 79 deg 30 min and 82 deg 30 min East.',41.5,74.0,79.5,82.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2674,'Asia - FSU - 82.5 to 85.5 deg E','Kazakhstan and Russian Federation - between 82 deg 30 min and 85 deg 30 min East.',44.8,75.0,82.5,85.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2675,'Asia - FSU - 85.5 to 88.5 deg E','Kazakhstan and Russian Federation - between 85 deg 30 min and 88 deg 30 min East.',46.9,76.0,85.5,88.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2676,'Russia - 88.5 to 91.5 deg E','Russian Federation - between 88 deg 30 min and 91 deg 30 min East.',49.45,76.0,88.5,91.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2677,'Russia - 91.5 to 94.5 deg E','Russian Federation - between 91 deg 30 min and 94 deg 30 min East.',50.05,81.0,91.5,94.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2678,'Russia - 94.5 to 97.5 deg E','Russian Federation - between 94 deg 30 min and 97 deg 30 min East.',49.75,82.0,94.5,97.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2679,'Russia - 97.5 to 100.5 deg E','Russian Federation - between 97 deg 30 min and 100 deg 30 min East.',49.8,82.0,97.5,100.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2680,'Russia - 100.5 to 103.5 deg E','Russian Federation - between 100 deg 30 min and 103 deg 30 min East.',50.2,80.0,100.5,103.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2681,'Russia - 103.5 to 106.5 deg E','Russian Federation - between 103 deg 30 min and 106 deg 30 min East.',50.1,80.0,103.5,106.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2682,'Russia - 106.5 to 109.5 deg E','Russian Federation - between 106 deg 30 min and 109 deg 30 min East.',49.25,79.0,106.5,109.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2683,'Russia - 109.5 to 112.5 deg E','Russian Federation - between 109 deg 30 min and 112 deg 30 min East.',49.1,78.0,109.5,112.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2684,'Russia - 112.5 to 115.5 deg E','Russian Federation - between 112 deg 30 min and 115 deg 30 min East.',49.5,77.0,112.5,115.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2685,'Russia - 115.5 to 118.5 deg E','Russian Federation - between 115 deg 30 min and 118 deg 30 min East.',49.45,75.0,115.5,118.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2686,'Russia - 118.5 to 121.5 deg E','Russian Federation - between 118 deg 30 min and 121 deg 30 min East.',49.85,75.0,118.5,121.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2687,'Russia - 121.5 to 124.5 deg E','Russian Federation - between 121 deg 30 min and 124 deg 30 min East.',53.2,74.0,121.5,124.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2688,'Russia - 124.5 to 127.5 deg E','Russian Federation - between 124 deg 30 min and 127 deg 30 min East.',50.0,74.0,124.5,127.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2689,'Russia - 127.5 to 130.5 deg E','Russian Federation - between 127 deg 30 min and 130 deg 30 min East.',48.83,74.0,127.5,130.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2690,'Russia - 130.5 to 133.5 deg E','Russian Federation - between 130 deg 30 min and 133 deg 30 min East.',42.25,74.0,130.5,133.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2691,'Russia - 133.5 to 136.5 deg E','Russian Federation - between 133 deg 30 min and 136 deg 30 min East.',42.6,78.0,133.5,136.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2692,'Russia - 136.5 to 139.5 deg E','Russian Federation - between 136 deg 30 min and 139 deg 30 min East.',44.6,78.0,136.5,139.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2693,'Russia - 139.5 to 142.5 deg E','Russian Federation - between 139 deg 30 min and 142 deg 30 min East.',45.8,76.0,139.5,142.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2694,'Russia - 142.5 to 145.5 deg E','Russian Federation - between 142 deg 30 min and 145 deg 30 min East.',45.9,76.0,142.5,145.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2695,'Russia - 145.5 to 148.5 deg E','Russian Federation - between 145 deg 30 min and 148 deg 30 min East.',44.3,76.0,145.5,148.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2696,'Russia - 148.5 to 151.5 deg E','Russian Federation - between 148 deg 30 min and 151 deg 30 min East.',44.9,76.0,148.5,151.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2697,'Russia - 151.5 to 154.5 deg E','Russian Federation - between 151 deg 30 min and 154 deg 30 min East.',45.75,72.0,151.5,154.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2698,'Russia - 154.5 to 157.5 deg E','Russian Federation - between 154 deg 30 min and 157 deg 30 min East.',48.9,72.0,154.5,157.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2699,'Russia - 157.5 to 160.5 deg E','Russian Federation - between 157 deg 30 min and 160 deg 30 min East.',51.33,72.0,157.5,160.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2700,'Russia - 160.5 to 163.5 deg E','Russian Federation - between 160 deg 30 min and 163 deg 30 min East.',54.33,72.0,160.5,163.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2701,'Russia - 163.5 to 166.5 deg E','Russian Federation - between 163 deg 30 min and 166 deg 30 min East.',58.5,70.0,163.5,166.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2702,'Russia - 166.5 to 170.5 deg E','Russian Federation - between 166 deg 30 min and 169 deg 30 min East.',59.8,70.0,166.5,169.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2703,'Russia - 169.5 to 172.5 deg E','Russian Federation - between 169 deg 30 min and 172 deg 30 min East.',59.8,71.0,169.5,172.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2704,'Russia - 172.5 to 175.5 deg E','Russian Federation - between 172 deg 30 min and 175 deg 30 min East.',60.0,71.0,172.5,175.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2705,'Russia - 175.5 to 178.5 deg E','Russian Federation - between 175 deg 30 min and 178 deg 30 min East.',60.0,71.5,175.5,178.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2706,'Russia - 178.5 deg E to 178.5 deg W','Russian Federation - between 178 deg 30 min East and 178 deg 30 min West.',60.0,71.5,178.5,-178.5,'','','',NULL,'Area crosses 180-degree meridian.','EPSG','EPSG','2002-06-22','',0),
(2707,'Russia - 178.5 to 175.5 deg W','Russian Federation - between 178 deg 30 min and 175 deg 30 min West.',60.0,71.5,-178.5,-175.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2708,'Russia - 175.5 to 172.5 deg W','Russian Federation - between 175 deg 30 min and 172 deg 30 min West.',60.0,71.5,-175.5,-172.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2709,'Russia - 172.5 to 169.5 deg W','Russian Federation - between 172 deg 30 min and 169 deg 30 min West.',60.0,71.0,-172.5,-169.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2710,'Russia - E of 169.5 deg W','Russian Federation - between 169 deg 30 min and 166 deg 30 min West.',60.0,67.0,-169.5,-166.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2711,'China - 73.5 to 76.5 deg E','China - between 73 deg 30 min and 76 deg 30 min East.',35.81,40.64,73.62,76.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2712,'China - 76.5 to 79.5 deg E','China - between 76 deg 30 min and 79 deg 30 min East.',31.0,41.83,76.5,79.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2713,'China - 79.5 to 82.5 deg E','China - between 79 deg 30 min and 82 deg 30 min East.',29.96,45.88,79.5,82.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2714,'China - 82.5 to 85.5 deg E','China - between 82 deg 30 min and 85 deg 30 min East.',28.26,47.22,82.5,85.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2715,'China - 85.5 to 88.5 deg E','China - between 85 deg 30 min and 88 deg 30 min East.',27.81,49.17,85.5,88.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2716,'China - 88.5 to 91.5 deg E','China - between 88 deg 30 min and 91 deg 30 min East.',27.32,48.41,88.5,91.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2717,'China - 91.5 to 94.5 deg E','China - between 91 deg 30 min and 94 deg 30 min East.',27.73,45.13,91.5,94.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2718,'China - 94.5 to 97.5 deg E','China - between 94 deg 30 min and 97 deg 30 min East.',28.22,44.49,94.5,97.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2719,'China - 97.5 to 100.5 deg E','China - between 97 deg 30 min and 100 deg 30 min East.',21.44,42.75,97.5,100.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2720,'China - 100.5 to 103.5 deg E','China - between 100 deg 30 min and 103 deg 30 min East.',21.14,42.69,100.5,103.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2721,'China - 103.5 to 106.5 deg E','China - between 103 deg 30 min and 106 deg 30 min East.',22.5,42.2,103.5,106.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2722,'China - 106.5 to 109.5 deg E','China - between 106 deg 30 min and 109 deg 30 min East.',18.26,42.47,106.5,109.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2723,'China - 109.5 to 112.5 deg E','China - between 109 deg 30 min and 112 deg 30 min East.',18.17,45.1,109.5,112.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2724,'China - 112.5 to 115.5 deg E','China - between 112 deg 30 min and 115 deg 30 min East.',21.57,45.44,112.5,115.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2725,'China - 115.5 to 118.5 deg E','China - between 115 deg 30 min and 118 deg 30 min East.',22.66,49.88,115.5,118.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2726,'China - 118.5 to 121.5 deg E','China - between 118 deg 30 min and 121 deg 30 min East.',21.93,53.33,118.5,121.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2727,'China - 121.5 to 124.5 deg E','China - between 121 deg 30 min and 124 deg 30 min East.',23.5,53.55,121.5,124.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2728,'China - 124.5 to 127.5 deg E','China - between 124 deg 30 min and 127 deg 30 min East.',40.2,53.2,124.5,127.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2729,'China - 127.5 to 130.5 deg E','China - between 127 deg 30 min and 130 deg 30 min East.',41.37,50.25,127.5,130.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2730,'China - 130.5 to 133.5 deg E','China - between 130 deg 30 min and 133 deg 30 min East.',42.42,48.88,130.5,133.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2731,'China - 133.5 to 136.5 deg E','China - between 133 deg 30 min and 136 deg 30 min East.',45.86,48.39,133.5,134.77,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2732,'World - 6-degree CM 081 deg W','Between 84 and 78 deg West.',-80.0,84.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2733,'World - 6-degree CM 075 deg W','Between 78 and 72 deg West.',-80.0,84.0,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2734,'World - 6-degree CM 069 deg W','Between 72 and 66 deg West.',-80.0,84.0,-72.0,-66.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2735,'World - 6-degree CM 063 deg W','Between 66 and 60 deg West.',-80.0,84.0,-66.0,-60.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2736,'World - 6-degree CM 057 deg W','Between 60 and 54 deg West.',-80.0,84.0,-60.0,-54.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2737,'World - 6-degree CM 051 deg W','Between 54 and 48 deg West.',-80.0,84.0,-54.0,-48.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2738,'World - 6-degree CM 045 deg W','Between 48 and 42 deg West.',-80.0,84.0,-48.0,-42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2739,'World - 6-degree CM 039 deg W','Between 42 and 36 deg West.',-80.0,84.0,-42.0,-36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2740,'World - 6-degree CM 033 deg W','Between 36 and 30 deg West.',-80.0,84.0,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2741,'World - 6-degree CM 009 deg E','Between 6 and 12 deg East.',-80.0,84.0,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2742,'World - 6-degree CM 015 deg E','Between 12 and 18 deg East.',-80.0,84.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2743,'World - 6-degree CM 021 deg E','Between 18 and 24 deg East.',-80.0,84.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2744,'World - 6-degree CM 027 deg E','Between 24 and 30 deg East.',-80.0,84.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2745,'World - 6-degree CM 033 deg E','Between 30 and 36 deg East.',-80.0,84.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2746,'World - 6-degree CM 039 deg E','Between 36 and 42 deg East.',-80.0,84.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2005-06-05','2005.144',0),
(2747,'Russia - 19.5 to 22.5 deg E','Russian Federation - Kaliningrad - between 19 deg 30 min and 22 deg 30 min East.',54.32,55.3,19.5,22.5,'','','',NULL,'','EPSG','EPSG','2006-07-14','2006.59',0),
(2748,'Russia - 22.5 to 25.5 deg E','Russian Federation - between 22 deg 30 min and 25 deg 30 min East - Kaliningrad.',54.34,55.07,22.5,22.9,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2749,'Russia - 25.5 to 28.5 deg E','Russian Federation - between 25 deg 30 min and 28 deg 30 min East.',56.06,70.0,27.34,28.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2750,'Russia - 28.5 to 31.5 deg E','Russian Federation - between 28 deg 30 min and 31 deg 30 min East.',52.88,70.0,28.5,31.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2751,'Russia - 31.5 to 34.5 deg E','Russian Federation - between 31 deg 30 min and 34 deg 30 min East.',51.24,70.0,31.5,34.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2752,'Russia - 34.5 to 37.5 deg E','Russian Federation - between 34 deg 30 min and 37 deg 30 min East.',44.6,70.0,34.5,37.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2753,'Russia - 37.5 to 40.5 deg E','Russian Federation - between 37 deg 30 min and 40 deg 30 min East.',43.36,68.0,37.5,40.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2754,'Russia - 40.5 to 43.5 deg E','Russian Federation - between 40 deg 30 min and 43 deg 30 min East.',42.8,68.0,40.5,43.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2755,'Russia - 43.5 to 46.5 deg E','Russian Federation - between 43 deg 30 min and 46 deg 30 min East.',41.85,68.0,43.5,46.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2756,'Russia - 46.5 to 49.5 deg E','Russian Federation - between 46 deg 30 min and 49 deg 30 min East.',41.17,73.0,46.5,49.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2757,'Russia - 49.5 to 52.5 deg E','Russian Federation - between 49 deg 30 min and 52 deg 30 min East.',50.9,74.0,49.5,52.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2758,'Russia - 52.5 to 55.5 deg E','Russian Federation - between 52 deg 30 min and 55 deg 30 min East.',50.5,75.0,52.5,55.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2759,'Russia - 55.5 to 58.5 deg E','Russian Federation - between 55 deg 30 min and 58 deg 30 min East.',50.55,76.0,55.5,58.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2760,'Russia - 58.5 to 61.5 deg E','Russian Federation - between 58 deg 30 min and 61 deg 30 min East.',50.5,76.0,58.5,61.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2761,'Russia - 61.5 to 64.5 deg E','Russian Federation - between 61 deg 30 min and 64 deg 30 min East.',50.8,77.0,61.5,64.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2762,'Russia - 64.5 to 67.5 deg E','Russian Federation - between 64 deg 30 min and 67 deg 30 min East.',54.3,77.0,64.5,67.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2763,'Russia - 67.5 to 70.5 deg E','Russian Federation - between 67 deg 30 min and 70 deg 30 min East.',58.8,75.0,67.5,70.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2764,'Russia - 70.5 to 73.5 deg E','Russian Federation - between 70 deg 30 min and 73 deg 30 min East.',53.4,74.0,70.5,73.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2765,'Russia - 73.5 to 76.5 deg E','Russian Federation - between 73 deg 30 min and 76 deg 30 min East.',53.45,73.0,73.5,76.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2766,'Russia - 76.5 to 79.5 deg E','Russian Federation - between 76 deg 30 min and 79 deg 30 min East.',51.5,74.0,76.5,79.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2767,'Russia - 79.5 to 82.5 deg E','Russian Federation - between 79 deg 30 min and 82 deg 30 min East.',50.7,75.0,79.5,82.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2768,'Russia - 82.5 to 85.5 deg E','Russian Federation - between 82 deg 30 min and 85 deg 30 min East.',49.5,76.0,82.5,85.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2769,'Russia - 85.5 to 88.5 deg E','Russian Federation - between 85 deg 30 min and 88 deg 30 min East.',49.1,76.0,85.5,88.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2770,'Indonesia - Kalimantan NE','Indonesia - northeast Kalimantan.',-2.35,4.4,113.7,119.62,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2771,'Niger - SE','Niger - south east',12.6,16.5,8.0,15.5,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2772,'Asia - FSU - CS63 zone A1','Armenia and Georgia west of 43deg 02min E.',41.38,43.56,40.03,43.03,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2773,'Asia - FSU - CS63 zone A2','Armenia and Georgia between 43 deg 02min and 46 deg 02 min E; Azerbaijan west of 46 deg 02 min E.',38.86,43.1,43.03,46.03,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2774,'Asia - FSU - CS63 zone A3','Armenia and Georgia east of 46 deg 02 min E; Azerbaijan between 46 deg 02min and 49 deg 02 min E.',38.4,42.4,46.03,49.03,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2775,'Asia - FSU - CS63 zone A4','Azerbaijan east of 49 deg 02 min E.',38.4,42.75,49.03,52.03,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2776,'Asia - FSU - CS63 zone K2','Kazakhstan between 49 deg 16 min and 52 deg 16 min E.',40.59,55.44,49.27,52.27,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2777,'Asia - FSU - CS63 zone K3','Kazakhstan between 52 deg 16 min and 55 deg 16 min E.',40.59,51.2,52.27,55.27,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2778,'Asia - FSU - CS63 zone K4','Kazakhstan between 55 deg 16 min and 58 deg 16 min E.',40.59,51.2,55.27,58.27,'','','',NULL,'','EPSG','EPSG','2002-06-28','',0),
(2779,'Portugal - Selvagens','Portugal - Selvagens islands (Madeira province).',30.1,30.2,-15.9,-15.8,'','','',NULL,'','EPSG','EPSG','2003-08-14','2003.23',0),
(2780,'Malaysia - East Malaysia - offshore','Malaysia - East Malaysia (Sabah; Sarawak) - offshore.',1.5,12.0,109.5,119.0,'','','',NULL,'','EPSG','EPSG','2002-07-13','',0),
(2781,'Iran - Kharg Island','Iran - Kharg Island.',29.0,29.33,50.15,50.4,'','','',NULL,'','EPSG','EPSG','2002-07-13','',0),
(2782,'Iran - Lavan Island and Balal field','Iran - Lavan Island and Balal field.',26.2,26.8,52.4,53.3,'','','',NULL,'','EPSG','EPSG','2002-07-13','',0),
(2783,'Iran - South Pars blocks 2 and 3','Iran - South Pars field phases 2 and 3.',26.55,26.75,52.05,52.3,'','','',NULL,'','EPSG','EPSG','2002-07-13','',0),
(2784,'Canada - S of 60 deg N','Canada south of 60 degrees North - Alberta, British Columbia (BC), Manitoba, New Brunswick (NB), Newfoundland and Labrador, Nova Scotia (NS), Ontario, Prince Edward Island (PEI), Quebec and Saskatchewan.',41.68,60.0,-139.05,-52.62,'','','',NULL,'','EPSG','EPSG','2006-07-21','2006.461',0),
(2785,'Libya - Murzuq and En Naga','Libya - Murzuq and En Naga fields.',24.0,28.0,13.0,19.0,'','','',NULL,'','EPSG','EPSG','2005-04-14','2004.70',0),
(2786,'Libya - Mabruk','Libya - Mabruk field.',29.6,29.9,17.2,17.5,'','','',NULL,'','EPSG','EPSG','2002-07-16','',0),
(2787,'Morocco - S of 31.5 deg N','Morocco south of 35 grads (31 deg 30 min) North.',27.67,31.5,-13.1,-3.5,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2788,'Western Sahara - N of 24.3 deg N','Western Sahara - north of 27grads (24 deg 18 min) North.',24.3,27.68,-20.36,-8.67,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2789,'Western Sahara - S of 24.3 deg N','Western Sahara - south of 27grads (24 deg 18 min) North.',20.78,24.3,-20.36,-8.67,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2790,'Africa - 12th parallel','Senegal - central, Mali - southwest, Burkina Faso - central, Niger - southwest, Nigeria - north, Chad - central. All in proximity to the 12th parallel of latitude.',10.0,14.0,-16.81,22.97,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2791,'Africa - Burkina Faso and SW Niger','Burkina Faso - central, Niger - southwest, in proximity to the 12th parallel of latitude.',9.4,15.71,-5.52,4.63,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2792,'United Kingdom (UK) - Great Britain mainland','United Kingdom (UK) - Great Britain - England  and  Wales - mainland; Scotland - mainland and Inner Hebrides.',49.94,58.67,-6.24,1.78,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2793,'United Kingdom (UK) - Orkney Islands','United Kingdom (UK) - Great Britain - Scotland - Orkney Islands.',58.72,59.4,-3.44,-2.36,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2794,'United Kingdom (UK) - Fair Isle','United Kingdom (UK) - Great Britain - Scotland - Fair Isle.',59.51,59.55,-1.66,-1.59,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2795,'United Kingdom (UK) - Shetland Islands','United Kingdom (UK) - Great Britain - Scotland - Shetland Islands.',59.84,60.85,-2.12,-0.72,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2796,'United Kingdom (UK) - Foula','United Kingdom (UK) - Great Britain - Scotland - Foula.',60.1,60.16,-2.12,-2.03,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2797,'United Kingdom (UK) - Sule Skerry','United Kingdom (UK) - Great Britain - Scotland - Sule Skerry.',59.06,59.08,-6.04,-6.03,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2798,'United Kingdom (UK) - North Rona','United Kingdom (UK) - Great Britain - Scotland - North Rona.',59.08,59.13,-5.98,-5.95,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2799,'United Kingdom (UK) - Outer Hebrides','United Kingdom (UK) - Great Britain - Scotland - Outer Hebrides.',56.77,58.52,-7.67,-6.13,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2800,'United Kingdom (UK) - St. Kilda','United Kingdom (UK) - Great Britain - Scotland - St. Kilda.',-8.65,-8.56,57.79,57.84,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2801,'United Kingdom (UK) - Flannan Isles','United Kingdom (UK) - Great Britain - Scotland - Flannan Isles.',58.28,58.3,-7.6,-7.57,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2802,'United Kingdom (UK) - Scilly Isles','United Kingdom (UK) - Great Britain - England - Isles of Scilly.',49.86,49.98,-6.37,-6.24,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2803,'United Kingdom (UK) - Isle of Man','United Kingdom (UK) - Isle of Man.',54.04,54.42,-4.83,-4.31,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2804,'Europe - Austria and FR Yugoslavia.','Austria; Boznia and Herzegovina; Croatia; Czech Republic; FYR Macedonia; Serbia; Slovakia; Slovenia; Yugoslavia - Serbia and Montenegro.',40.86,51.05,9.53,23.03,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2805,'Chile - Tierra del Fuego','Chile - Tierra del Fuego.',-55.9,-48.64,-75.64,-66.52,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2806,'Iran - N Gulf coast','Iran - northern Gulf coast area.',29.0,31.67,47.75,50.83,'','','',NULL,'','EPSG','EPSG','2002-09-19','',0),
(2807,'Comoros - Njazidja (Grande Comore)','Comoros - Njazidja (Grande Comore).',-11.9,-11.4,43.2,43.5,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2808,'Comoros - Nzwani','Comoros - Nzwani.',-12.4,-12.06,44.2,44.5,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2809,'Comoros - Mwali','Comoros - Mwali.',-12.4,-12.23,43.61,43.87,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2810,'French Polynesia - Marquises Islands - Nuku Hiva','French Polynesia - Marquises Islands - Nuku Hiva.',-9.0,-8.75,-140.25,-139.95,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2811,'French Polynesia - Society Islands - Moorea and Tahiti','French Polynesia - Society Islands - Moorea and Tahiti.',-17.91,-17.45,-149.96,-149.07,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2812,'French Polynesia - Society Islands - Bora Bora, Huahine, Raiatea, Tahaa','French Polynesia - Society Islands - Bora Bora, Huahine, Raiatea and Tahaa.',-16.95,-16.62,-151.8,-150.9,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2813,'New Caledonia - Ouvea','New Caledonia - Loyalty Islands - Ouvea.',-20.75,-20.35,166.35,166.7,'','','',NULL,'','EPSG','EPSG','2006-07-25','2006.62',0),
(2814,'New Caledonia - Lifou','New Caledonia - Loyalty Islands - Lifou.',-21.2,-20.7,167.0,167.5,'','','',NULL,'','EPSG','EPSG','2006-07-25','2006.62',0),
(2815,'Wallis and Futuna - Wallis','Wallis and Futuna - Wallis.',-14.0,-13.0,-177.0,-176.0,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2816,'French Southern Territories - Kerguelen','French Southern Territories - Kerguelen.',-49.75,-48.5,68.5,70.6,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2817,'Antarctica - Adelie Land - Petrels island','Antarctica - Adelie Land - Petrels island.',-66.9,-66.5,139.5,140.5,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2818,'Antarctica - Adelie Land','Antarctica - Adelie Land.',-68.0,-66.0,135.0,142.0,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2819,'New Caledonia - Mare','New Caledonia - Loyalty Islands - Mare.',-21.7,-21.3,167.75,168.15,'','','',NULL,'','EPSG','EPSG','2006-07-25','2006.62',0),
(2820,'New Caledonia - Ile des Pins','New Caledonia - Ile des Pins.',-22.75,-22.5,167.3,167.55,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2821,'New Caledonia - Belep','New Caledonia - Belep.',-19.85,-19.54,163.55,163.7,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(2822,'New Caledonia - Grande Terre','New Caledonia - Grande Terre.',-22.5,-20.0,163.9,167.1,'','','',NULL,'','EPSG','EPSG','2003-08-14','2003.24',0),
(2823,'New Caledonia - Grande Terre - Noumea','New Caledonia - Grande Terre - Noumea district.',-22.35,-22.1,166.3,166.5,'','','',NULL,'','EPSG','EPSG','2003-08-14','2003.24',0),
(2824,'Caribbean - French Antilles','French Antilles - Guadeloupe and Martinique.',14.4,16.51,-61.8,-60.82,'','','',NULL,'','EPSG','EPSG','1999-04-22','',0),
(2825,'Africa - Ethiopia and Sudan - 30 to 36 deg E','Ethiopia - west of 36 degrees East.  Sudan - between 30 and 36 degrees East.',3.41,22.23,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2003-01-16','2002.81',0),
(2826,'Sudan - W of 24 deg E','Sudan - west of 24 degrees East.',8.68,15.77,21.84,24.0,'','','',NULL,'','EPSG','EPSG','2003-01-16','2002.81',0),
(2827,'Sudan - 24 to 30 deg E','Sudan - between 24 and 30 degrees East.',4.2,22.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2003-01-16','2002.81',0),
(2828,'Guadeloupe - St Martin and St Barthelemy','Guadeloupe - Saint Martin and Saint Barthelemy islands.',17.65,18.2,-63.18,-62.7,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2829,'Guadeloupe - Grande-Terre and surrounding islands','Guadeloupe - Basse-Terre, Grande-Terre, Desiride, Marie-Galante, Les Saintes.',14.35,16.51,-61.8,-60.75,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2830,'World (by country)','World: Afghanistan, Albania, Algeria, American Samoa, Andorra, Angola, Anguilla, Antarctica, Antigua and Barbuda, Argentina, Armenia, Aruba, Australia, Austria, Azerbaijan, Bahamas, Bahrain, Bangladesh, Barbados, Belgium, Belgium, Belize, Benin, Bermuda, Bhutan, Bolivia, Bosnia and Herzegowina, Botswana, Bouvet Island, Brazil, British Indian Ocean Territory, British Virgin Islands, Brunei Darussalam, Bulgaria, Burkina Faso, Burundi, Cambodia, Cameroon, Canada, Cape Verde, Cayman Islands, Central African Republic, Chad, Chile, China, Christmas Island, Cocos (Keeling) Islands, Comoros, Congo, Cook Islands, Costa Rica, C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast), Croatia, Cuba, Cyprus, Czech Republic, Denmark, Djibouti, Dominica, Dominican Republic, East Timor, Ecuador, Egypt, El Salvador, Equatorial Guinea, Eritrea, Estonia, Ethiopia, Falkland Islands (Malvinas), Faroe Islands, Fiji, Finland, France, French Guiana, French Polynesia, French Southern Territories, Gabon, Gambia, Georgia, Germany, Ghana, Gibraltar, Greece, Greenland, Grenada, Guadeloupe, Guam, Guatemala, Guinea, Guinea-Bissau, Guyana, Haiti, Heard Island and McDonald Islands, Holy See (Vatican City State), Honduras, China - Hong Kong, Hungary, Iceland, India, Indonesia, Islamic Republic of Iran, Iraq, Ireland, Israel, Italy, Jamaica, Japan, Jordan, Kazakhstan, Kenya, Kiribati, Democratic People''s Republic of Korea (North Korea), Republic of Korea (South Korea), Kuwait, Kyrgyzstan, Lao People''s Democratic Republic (Laos), Latvia, Lebanon, Lesotho, Liberia, Libyan Arab Jamahiriya, Liechtenstein, Lithuania, Luxembourg, China - Macau, The Former Yugoslav Republic of Macedonia, Madagascar, Malawi, Malaysia, Maldives, Mali, Malta, Marshall Islands, Martinique, Mauritania, Mauritius, Mayotte, Mexico, Federated States of Micronesia, Monaco, Mongolia, Montserrat, Morocco, Mozambique, Myanmar (Burma), Namibia, Nauru, Nepal, Netherlands, Netherlands Antilles, New Caledonia, New Zealand, Nicaragua, Niger, Nigeria, Niue, Norfolk Island, Northern Mariana Islands, Norway, Oman, Pakistan, Palau, Panama, Papua New Guinea (PNG), Paraguay, Peru, Philippines, Pitcairn, Poland, Portugal, Puerto Rico, Qatar, Reunion, Romania, Russian Federation, Rwanda, Saint Kitts and Nevis, Saint Lucia, Saint Vincent and the Grenadines, Samoa, San Marino, Sao Tome and Principe, Saudi Arabia, Senegal, Seychelles, Sierra Leone, Singapore, Slovakia (Slovak Republic), Slovenia, Solomon Islands, Somalia, South Africa, South Georgia and the South Sandwich Islands, Spain, Sri Lanka, Saint Helena, Saint Pierre and Miquelon, Sudan, Suriname, Svalbard and Jan Mayen, Swaziland, Sweden, Switzerland, Syrian Arab Republic, Taiwan, Tajikistan, United Republic of Tanzania, Thailand, The Democratic Republic of the Congo (Zaire), Togo, Tokelau, Tonga, Trinidad and Tobago, Tunisia, Turkey, Turkmenistan, Turks and Caicos Islands, Tuvalu, Uganda, Ukraine, United Arab Emirates (UAE), United Kingdom (UK), United States (USA), United States Minor Outlying Islands, Uruguay, Uzbekistan, Vanuatu, Venezuela, Vietnam, US Virgin Islands, Wallis and Futuna, Western Sahara, Yemen, Yugoslavia - Union of Serbia and Montenegro, Zambia, Zimbabwe.',-90.0,90.0,-180.0,180.0,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2831,'Canada - Atlantic offshore','Canada - offshore Newfoundland and Labrador, New Brunswick (NB) and Nova Scotia (NS).',40.0,62.0,-65.0,-44.0,'','','',NULL,'','EPSG','EPSG','2003-02-25','',0),
(2832,'Canada - British Columbia','Canada - British Columbia (BC).',48.3,60.0,-139.05,-114.03,'','','',NULL,'','EPSG','EPSG','2003-05-05','',0),
(2833,'Sweden - 12 00','Sweden - communes west of approximately 12 deg 45 min East and south of approximately 60 deg N. See information source for map.',55.85,60.25,10.57,13.08,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2834,'Sweden - 13 30','Sweden - communes between approximately 12 deg 45 min and 14 deg 15 min East and south of approximately 62 deg 10 min North. See information source for map.',55.2,62.26,12.1,14.65,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2835,'Sweden - 15 00','Sweden - communes between approximately 14 deg 15 min and 15 deg 45 min East and south of approximately 61 deg 30 min North. See information source for map.',55.95,61.62,13.5,16.1,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2836,'Sweden - 16 30','Sweden - communes between approximately 15 deg 45 min and 17 deg 15 min East and south of approximately 62 deg 20 min North. See information source for map.',56.18,62.35,15.65,17.71,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2837,'Sweden - 18 00','Sweden - communes east of approximately 17 deg 15 min East between approximately 60 deg 40 min and 58 deg 50 min North. See information source for map.',58.7,60.65,17.08,19.21,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2838,'Sweden - 14 15','Sweden - communes west of approximately 15 deg East and between approximately 61 deg 35 min and 64 deg 25 min N. See information source for map.',61.57,64.47,12.0,15.5,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2839,'Sweden - 15 45','Sweden - communes between approximately 15 deg and 16 deg 30 min East and between approximately 60 deg 30 min and 65 deg N. See information source for map.',60.5,65.1,13.64,17.0,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2840,'Sweden - 17 15','Sweden - communes between approximately 16 deg 30 min and 18 deg East and between approximately 67 deg 10 min and 64 deg North. See information source for map.',62.1,67.2,14.35,18.45,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2841,'Sweden - 18 45','Sweden - mainland communes between approximately 18 deg and 19 deg 30 min East and between approximately 62 deg 50 min and 66 deg N. Also Gotland. See information source for map.',56.85,65.58,17.25,20.25,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2842,'Sweden - 20 15','Sweden - communes in Vaasterbotten east of approximately 19 deg 30 min East and (i) north of 66 deg N and (ii) south of approximately 65 deg N. Also Norbotten west of approximately 22 deg 30 min E. See information source for map.',63.4,69.1,15.38,22.48,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2843,'Sweden - 21 45','Sweden - communes in Norbotten between approximately 20 deg and 22 deg 30 min East and between approximately 65 deg and 66 deg 25 min N. See information source for map.',65.0,65.38,20.0,21.65,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2844,'Sweden - 23 15','Sweden - communes east of approximately 22 deg 30 min East. See information source for map.',65.5,68.45,20.85,24.18,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2845,'Sweden - 7.5 gon W','Sweden - communes west of approximately 12 deg 26 min East. See information source for map.',56.85,63.8,10.57,12.44,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2846,'Sweden - 5 gon W','Sweden - communes between approximately 12 deg 26 min and 14 deg 40 min East. See information source for map.',55.3,66.15,12.44,14.09,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2847,'Sweden - 2.5 gon W','Sweden. For medium and small scale applications:- all country. For large scale applications:- communes between approximately 14 deg 40 min and 16 deg 55 min East. See information source for map.',56.0,68.0,14.09,16.94,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2848,'Sweden - 0 gon','Sweden - communes between approximately 16 deg 55 min and 19 deg 10 min East; Gotland. See information source for map.',56.9,68.58,16.94,19.19,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2849,'Sweden - 2.5 gon E','Sweden - communes between approximately 19 deg 10 min and 21 deg 25 min East. See information source for map.',63.3,69.1,19.19,21.44,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2850,'Sweden - 5 gon E','Sweden - east of approximately 21 deg 26 min East. See information source for map.',64.33,68.72,21.44,24.18,'','','',NULL,'','Lantmateriet (National Land Survey of Sweden).  http://www.lantmateriet.se','EPSG','2005-09-29','2005.46',0),
(2851,'Iceland - W of 24 W','Iceland - west of 24 deg West.',64.75,65.8,-24.7,-24.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2852,'Iceland - 24 to 18 deg W','Iceland - between 24 and 18 deg West.',63.25,66.5,-24.0,-18.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2853,'Iceland - E of 18 W','Iceland - east of 18 deg West.',63.5,66.55,-18.0,-13.4,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2854,'Europe - 36 to 30 deg W','Europe - between 36 and 30 deg West.',39.3,39.85,-36.0,-30.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2855,'Europe - 30 to 24 deg W','Europe - between 30 and 24 deg West.',25.1,65.8,-30.0,-24.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2856,'Europe - 24 to 18 deg W','Europe - between 24 and 18 deg West.',27.6,66.5,-24.0,-18.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2857,'Europe - 18 to 12 deg W','Europe - between 18 and 12 deg West.',27.6,66.55,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2858,'Europe - 12 to 6 deg W','Europe - between 12 and 6 deg West.',36.0,62.33,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2859,'Europe - 6 to 0 deg W','Europe - between 6 and 0 deg West.',34.75,62.33,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2860,'Europe - 0 to 6 deg E','Europe - between 0 and 6 deg East.',38.5,62.33,0.0,6.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2861,'Europe - 6 to 12 deg E','Europe - between 6 and 12 deg East.',36.7,70.0,6.0,12.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2862,'Europe - 12 to 18 deg E','Europe - between 12 and 18 deg East..',35.5,75.0,12.0,18.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2863,'Europe - 18 to 24 deg E','Europe - between 18 and 24 deg East.',34.8,75.0,18.0,24.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2864,'Europe - 24 to 30 deg E','Europe - between 24 and 30 deg East.',34.8,75.0,24.0,30.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2865,'Europe - 30 to 36 deg E','Europe - between 30 and 36 deg East.',34.5,75.0,30.0,36.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2866,'Europe - 36 to 42 deg E','Europe - between 36 and 42 deg East.',35.75,75.0,36.0,42.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2867,'Europe - 42 to 48 deg E','Europe - between 42 and 48 deg East.',36.95,75.0,42.0,48.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2868,'Europe - 48 to 54 deg E','Europe - between 48 and 54 deg East.',36.0,75.0,48.0,54.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','2005.14',0),
(2869,'Jan Mayen','Jan Mayen',70.8,71.2,-9.15,-7.9,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2870,'Portugal - main Madeira islands','Portugal - Madeira and Porto Santo islands.',32.62,33.15,-17.27,-16.25,'','','',NULL,'','EPSG','EPSG','2003-08-14','',0),
(2871,'Portugal - E Azores - S Miguel','Portugal - eastern Azores - Sao Miguel island.',37.65,37.95,-25.9,-25.1,'','','',NULL,'','EPSG','EPSG','2003-08-14','',0),
(2872,'Portugal - C Azores - Terceira','Portugal - central Azores - Terceira island.',38.6,38.85,-27.4,-27.05,'','','',NULL,'','EPSG','EPSG','2003-08-14','',0),
(2873,'Portugal - C Azores - Faial','Portugal - central Azores - Faial island.',38.5,38.65,-28.8,-28.58,'','','',NULL,'','EPSG','EPSG','2003-08-14','',0),
(2874,'Portugal - C Azores - Pico','Portugal - central Azores - Pico island.',38.37,38.57,-28.55,-28.0,'','','',NULL,'','EPSG','EPSG','2003-08-14','',0),
(2875,'Portugal - C Azores - S Jorge','Portugal - central Azores - Sao Jorge island.',38.5,38.75,-28.35,-27.75,'','','',NULL,'','EPSG','EPSG','2003-08-14','',0),
(2876,'Asia - Middle East - Iraq-Kuwait boundary','Iraq - Kuwait boundary.',29.05,30.1,46.5,48.0,'','','',NULL,'','EPSG','EPSG','2003-09-01','',0),
(2879,'Germany - offshore North Sea','Germany - offshore North Sea.',53.6,55.9,3.3,8.5,'','','',NULL,'','EPSG','EPSG','2003-09-22','',0),
(2880,'Antarctica - Australian sector N of 80 S','Antarctica - Australian sector - north of 80 deg South.',-80.0,-60.0,45.0,160.0,'','','',NULL,'','EPSG','EPSG','2003-09-22','',0),
(2881,'Europe - ETRS-LCC & LAEA','Europe - EU countries and candidates.',27.75,71.15,-31.53,45.0,'','','',NULL,'','EPSG','EPSG','2003-06-27','',0),
(2882,'Italy - Adriatic - N Ancona','Italy - offshore - Adriatic Sea - North Ancona.',43.0,47.25,12.0,19.5,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2883,'Italy - Adriatic - S Ancona / N Gargano','Italy - offshore - Adriatic Sea - South Ancona and North Gargano.',41.75,43.75,13.25,19.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2884,'Italy - Adriatic - S Gargano','Italy - offshore - Adriatic Sea - South Gargano.',39.75,42.0,16.0,20.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2885,'Italy - Otranto channel','Italy - offshore - Otranto channel.',39.5,41.0,18.0,20.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2886,'Italy - N Jonian Sea','Italy - offshore - north Jonian Sea.',37.0,40.5,16.0,21.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2887,'Italy - Sicily Strait E of 13 deg E','Italy - offshore - Strait of Sicily - east of 13 deg East (of Greenwich).',36.0,37.5,13.0,16.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2888,'Italy - Sicily Strait W of 13 deg E','Italy - offshore - Strait of Sicily - west of 13 deg East (of Greenwich).',36.5,38.5,10.0,13.0,'','','',NULL,'','EPSG','EPSG','2001-06-05','',0),
(2889,'New Zealand - Chatham Islands','New Zealand - Chatham Islands.',-45.0,-43.0,-177.5,-176.0,'','','',NULL,'','EPSG','EPSG','2004-02-17','',0),
(2890,'Guadeloupe - St Martin','Guadeloupe - Saint Martin island.',18.0,18.2,-63.18,-62.7,'','','',NULL,'','EPSG','EPSG','2004-03-15','',0),
(2891,'Guadeloupe - St Barthelemy','Guadeloupe - Saint Barthelemy island.',17.65,17.95,-62.95,-62.7,'','','',NULL,'','EPSG','EPSG','2004-03-15','',0),
(2892,'Guadeloupe - Grande-Terre and Basse-Terre','Guadeloupe - Basse-Terre and Grande-Terre.',15.9,16.51,-61.8,-61.21,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2893,'Guadeloupe - Desiride','Guadeloupe - Desiride.',16.34,16.35,-61.19,-61.0,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2894,'Guadeloupe - Marie-Galante','Guadeloupe - Marie-Galante.',15.79,16.0,-61.3,-61.2,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2895,'Guadeloupe - Les Saintes','Guadeloupe - Les Saintes.',15.79,15.8,-61.64,-61.6,'','','',NULL,'','EPSG','EPSG','2003-01-31','',0),
(2896,'Asia - Middle East - Israel, Palestine Territory, Turkey  - offshore','Asia - Middle East - Israel and Palestine Territory - offshore Mediterranean Sea; Turkey - offshore Black Sea.',31.33,42.5,28.15,41.5,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2897,'Asia - Middle East - Israel and Palestine Territory offshore','Asia - Middle East - Israel and Palestine Territory - offshore Mediterranean Sea.',31.33,33.1,33.5,35.1,'','','',NULL,'','EPSG','EPSG','2002-06-22','',0),
(2898,'Germany - Berlin','Germany - Berlin.',52.33,52.68,13.08,13.77,'','','',NULL,'','EPSG','EPSG','2004-04-22','',0),
(2899,'Australia - 126 to 132 deg E, 8 to 12 deg S (SC52)','Australia - between 8 and 12 deg South and 126 and 132 deg East',-12.0,-8.0,126.0,132.0,'','','',NULL,'Map sheet SC52','EPSG','EPSG','2004-04-27','',0),
(2900,'Australia - 132 to 138 deg E, 8 to 12 deg S (SC53)','Australia - between 8 and 12 deg South and 132 and 138 deg East',-12.0,-8.0,132.0,138.0,'','','',NULL,'Map sheet SC53','EPSG','EPSG','2004-04-27','',0),
(2901,'Australia - 138 to 144 deg E, 8 to 12 deg S (SC54)','Australia - between 8 and 12 deg South and 138 and 144 deg East',-12.0,-8.0,138.0,144.0,'','','',NULL,'Map sheet SC54','EPSG','EPSG','2004-04-27','',0),
(2902,'Australia - 120 to 126 deg E, 12 to 16 deg S (SD51)','Australia - between 12 and 16 deg South and 120 and 126 deg East',-12.0,-8.0,120.0,126.0,'','','',NULL,'Map sheet SD51','EPSG','EPSG','2004-04-27','',0),
(2903,'Australia - 126 to 132 deg E, 12 to 16 deg S (SD52)','Australia - between 12 and 16 deg South and 126 and 132 deg East',-12.0,-8.0,126.0,132.0,'','','',NULL,'Map sheet SD52','EPSG','EPSG','2004-04-27','',0),
(2904,'Australia - 132 to 138 deg E, 12 to 16 deg S (SD53)','Australia - between 12 and 16 deg South and 132 and 138 deg East',-12.0,-8.0,132.0,138.0,'','','',NULL,'Map sheet SD53','EPSG','EPSG','2004-04-27','',0),
(2905,'Australia - 138 to 144 deg E, 12 to 16 deg S (SD54)','Australia - between 12 and 16 deg South and 138 and 144 deg East',-12.0,-8.0,138.0,144.0,'','','',NULL,'Map sheet SD54','EPSG','EPSG','2004-04-27','',0),
(2906,'Australia - 144 to 150 deg E, 12 to 16 deg S (SD55)','Australia - between 12 and 16 deg South and 144 and 150 deg East',-12.0,-8.0,144.0,150.0,'','','',NULL,'Map sheet SD55','EPSG','EPSG','2004-04-27','',0),
(2907,'Australia - 114 to 120 deg E, 16 to 20 deg S (SE50)','Australia - between 16 and 20 deg South and 114 and 120 deg East',-20.0,-16.0,114.0,120.0,'','','',NULL,'Map sheet SE52','EPSG','EPSG','2004-04-27','',0),
(2908,'Australia - 120 to 126 deg E, 16 to 20 deg S (SE51)','Australia - between 16 and 20 deg South and 120 and 126 deg East',-20.0,-16.0,120.0,126.0,'','','',NULL,'Map sheet SE52','EPSG','EPSG','2004-04-27','',0),
(2909,'Australia - 126 to 132 deg E, 16 to 20 deg S (SE52)','Australia - between 16 and 20 deg South and 126 and 132 deg East',-20.0,-16.0,126.0,132.0,'','','',NULL,'Map sheet SE52','EPSG','EPSG','2004-04-27','',0),
(2910,'Australia - 132 to 138 deg E, 16 to 20 deg S (SE53)','Australia - between 16 and 20 deg South and 132 and 138 deg East',-20.0,-16.0,132.0,138.0,'','','',NULL,'Map sheet SE52','EPSG','EPSG','2004-04-27','',0),
(2911,'Australia - 138 to 144 deg E, 16 to 20 deg S (SE54)','Australia - between 16 and 20 deg South and 138 and 144 deg East',-20.0,-16.0,138.0,144.0,'','','',NULL,'Map sheet SE52','EPSG','EPSG','2004-04-27','',0),
(2912,'Australia - 144 to 150 deg E, 16 to 20 deg S (SE55)','Australia - between 16 and 20 deg South and 144 and 150 deg East',-20.0,-16.0,144.0,150.0,'','','',NULL,'Map sheet SE52','EPSG','EPSG','2004-04-27','',0),
(2913,'Australia - 108 to 114 deg E, 20 to 24 deg S (SF49)','Australia - between 20 and 24 deg South and 108 and 114 deg East',-24.0,-20.0,108.0,114.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2914,'Australia - 114 to 120 deg E, 20 to 24 deg S (SF50)','Australia - between 20 and 24 deg South and 114 and 120 deg East',-24.0,-20.0,114.0,120.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2915,'Australia - 120 to 126 deg E, 20 to 24 deg S (SF51)','Australia - between 20 and 24 deg South and 120 and 126 deg East',-24.0,-20.0,120.0,126.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2916,'Australia - 126 to 132 deg E, 20 to 24 deg S (SF52)','Australia - between 20 and 24 deg South and 126 and 132 deg East',-24.0,-20.0,126.0,132.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2917,'Australia - 132 to 138 deg E, 20 to 24 deg S (SF53)','Australia - between 20 and 24 deg South and 132 and 138 deg East',-24.0,-20.0,132.0,138.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2918,'Australia - 138 to 144 deg E, 20 to 24 deg S (SF54)','Australia - between 20 and 24 deg South and 138 and 144 deg East',-24.0,-20.0,138.0,144.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2919,'Australia - 144 to 150 deg E, 20 to 24 deg S (SF55)','Australia - between 20 and 24 deg South and 144 and 150 deg East',-24.0,-20.0,144.0,150.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2920,'Australia - 150 to 156 deg E, 20 to 24 deg S (SF56)','Australia - between 20 and 24 deg South and 150 and 156 deg East',-24.0,-20.0,150.0,156.0,'','','',NULL,'Map sheet SF52','EPSG','EPSG','2004-04-27','',0),
(2921,'Australia - 108 to 114 deg E, 24 to 28 deg S (SG49)','Australia - between 24 and 28 deg South and 108 and 114 deg East',-28.0,-24.0,108.0,114.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2922,'Australia - 114 to 120 deg E, 24 to 28 deg S (SG50)','Australia - between 24 and 28 deg South and 114 and 120 deg East',-28.0,-24.0,114.0,120.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2923,'Australia - 120 to 126 deg E, 24 to 28 deg S (SG51)','Australia - between 24 and 28 deg South and 120 and 126 deg East',-28.0,-24.0,120.0,126.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2924,'Australia - 126 to 132 deg E, 24 to 28 deg S (SG52)','Australia - between 24 and 28 deg South and 126 and 132 deg East',-28.0,-24.0,126.0,132.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2925,'Australia - 132 to 138 deg E, 24 to 28 deg S (SG53)','Australia - between 24 and 28 deg South and 132 and 138 deg East',-28.0,-24.0,132.0,138.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2926,'Australia - 138 to 144 deg E, 24 to 28 deg S (SG54)','Australia - between 24 and 28 deg South and 138 and 144 deg East',-28.0,-24.0,138.0,144.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2927,'Australia - 144 to 150 deg E, 24 to 28 deg S (SG55)','Australia - between 24 and 28 deg South and 144 and 150 deg East',-28.0,-24.0,144.0,150.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2928,'Australia - 150 to 156 deg E, 24 to 28 deg S (SG56)','Australia - between 24 and 28 deg South and 150 and 156 deg East',-28.0,-24.0,150.0,156.0,'','','',NULL,'Map sheet SG52','EPSG','EPSG','2004-04-27','',0),
(2929,'Australia - 108 to 114 deg E, 28 to 32 deg S (SH49)','Australia - between 28 and 32 deg South and 108 and 114 deg East',-32.0,-28.0,108.0,114.0,'','','',NULL,'Map sheet SH52','EPSG','EPSG','2004-04-27','',0),
(2930,'Australia - 114 to 120 deg E, 28 to 32 deg S (SH50)','Australia - between 28 and 32 deg South and 114 and 120 deg East',-32.0,-28.0,114.0,120.0,'','','',NULL,'Map sheet SH52','EPSG','EPSG','2004-04-27','',0),
(2931,'Australia - 120 to 126 deg E, 28 to 32 deg S (SH51)','Australia - between 28 and 32 deg South and 120 and 126 deg East',-32.0,-28.0,120.0,126.0,'','','',NULL,'Map sheet SH52','EPSG','EPSG','2004-04-27','',0),
(2932,'Australia - 126 to 132 deg E, 28 to 32 deg S (SH52)','Australia - between 28 and 32 deg South and 126 and 132 deg East',-32.0,-28.0,126.0,132.0,'','','',NULL,'Map sheet SH52','EPSG','EPSG','2004-04-27','',0),
(2933,'Australia - 132 to 138 deg E, 28 to 32 deg S (SH53)','Australia - between 28 and 32 deg South and 132 and 138 deg East',-32.0,-28.0,132.0,138.0,'','','',NULL,'Map sheet SH53','EPSG','EPSG','2004-04-27','',0),
(2934,'Australia - 138 to 144 deg E, 28 to 32 deg S (SH54)','Australia - between 28 and 32 deg South and 138 and 144 deg East',-32.0,-28.0,138.0,144.0,'','','',NULL,'Map sheet SH54','EPSG','EPSG','2004-04-27','',0),
(2935,'Australia - 144 to 150 deg E, 28 to 32 deg S (SH55)','Australia - between 28 and 32 deg South and 144 and 150 deg East',-32.0,-28.0,144.0,150.0,'','','',NULL,'Map sheet SH55','EPSG','EPSG','2004-04-27','',0),
(2936,'Australia - 150 to 156 deg E, 28 to 32 deg S (SH56)','Australia - between 28 and 32 deg South and 150 and 156 deg East',-32.0,-28.0,150.0,156.0,'','','',NULL,'Map sheet SH56','EPSG','EPSG','2004-04-27','',0),
(2937,'Australia - 114 to 120 deg E, 32 to 36 deg S (SI50)','Australia - between 32 and 36 deg South and 114 and 120 deg East',-36.0,-32.0,114.0,120.0,'','','',NULL,'Map sheet SI50','EPSG','EPSG','2004-04-27','',0),
(2938,'Australia - 120 to 126 deg E, 32 to 36 deg S (SI51)','Australia - between 32 and 36 deg South and 120 and 126 deg East',-36.0,-32.0,120.0,126.0,'','','',NULL,'Map sheet SI51','EPSG','EPSG','2004-04-27','',0),
(2939,'Australia - 132 to 138 deg E, 32 to 36 deg S (SI53)','Australia - between 32 and 36 deg South and 132 and 138 deg East',-36.0,-32.0,132.0,138.0,'','','',NULL,'Map sheet SI53','EPSG','EPSG','2004-04-27','',0),
(2940,'Australia - 138 to 144 deg E, 32 to 36 deg S (SI54)','Australia - between 32 and 36 deg South and 138 and 144 deg East',-36.0,-32.0,138.0,144.0,'','','',NULL,'Map sheet SI54','EPSG','EPSG','2004-04-27','',0),
(2941,'Australia - 144 to 150 deg E, 32 to 36 deg S (SI55)','Australia - between 32 and 36 deg South and 144 and 150 deg East',-36.0,-32.0,144.0,150.0,'','','',NULL,'Map sheet SI55','EPSG','EPSG','2004-04-27','',0),
(2942,'Australia - 150 to 156 deg E, 32 to 36 deg S (SI56)','Australia - between 32 and 36 deg South and 150 and 156 deg East',-36.0,-32.0,150.0,156.0,'','','',NULL,'Map sheet SI56','EPSG','EPSG','2004-04-27','',0),
(2943,'Australia - 132 to 138 deg E, 36 to 40 deg S (SJ53)','Australia - between 36 and 40 deg South and 132 and 138 deg East',-40.0,-36.0,132.0,138.0,'','','',NULL,'Map sheet SJ53','EPSG','EPSG','2004-04-27','',0),
(2944,'Australia - 138 to 144 deg E, 36 to 40 deg S (SJ54)','Australia - between 36 and 40 deg South and 138 and 144 deg East',-40.0,-36.0,138.0,144.0,'','','',NULL,'Map sheet SJ54','EPSG','EPSG','2004-04-27','',0),
(2945,'Australia - 144 to 150 deg E, 36 to 40 deg S (SJ55)','Australia - between 36 and 40 deg South and 144 and 150 deg East',-40.0,-36.0,144.0,150.0,'','','',NULL,'Map sheet SJ55','EPSG','EPSG','2004-04-27','',0),
(2946,'Australia - 150 to 156 deg E, 36 to 40 deg S (SJ56)','Australia - between 36 and 40 deg South and 150 and 156 deg East',-40.0,-36.0,150.0,156.0,'','','',NULL,'Map sheet SJ56','EPSG','EPSG','2004-04-27','',0),
(2947,'Australia - 144 to 150 deg E, 39.5 to 43.5 deg S (SK55)','Australia - between 39.5 and 43.5 deg South and 138 and 144 deg East (Tasmania)',-43.5,-39.5,144.0,150.0,'','','',NULL,'Map sheet SK55','EPSG','EPSG','2004-04-27','',0),
(2948,'United States (USA) - conus east of 89W','United States (USA) - CONUS east of 89 deg W  - Alabama; Connecticut; Delaware; Florida; Georgia; llinois; Indiana; Kentucky; Maine; Maryland; Massachusetts; Michigan; Mississippi; New Hampshire; New Jersey; New York; North Carolina; Ohio; Pennsylvania; Rhode Island; South Carolina; Tennessee; Vermont; Virginia; West Virginia; Wisconsin.',24.53,48.3,-89.0,-67.07,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2949,'United States (USA) - conus 89-107W','United States (USA) - CONUS between 89 and 107 deg W  - Arkansas; Colorado; Illinois; Iowa; Kansas; Louisiana; Michigan; Minnesota; Mississippi; Missouri; Montana; Nebraska; New Mexico; North Dakota; Oklahoma; South Dakota; Tennessee; Texas; Wisconsin; Wyoming.',25.83,49.39,-107.0,-89.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2950,'United States (USA) - conus west of 107W','United States (USA) - CONUS west of 107 deg W - Arizona; California; Colorado; Idaho; Montana; Nevada; New Mexico; Oregon; Utah; Washington; Wyoming.',31.32,49.39,-124.85,-107.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2951,'Japan - 120d to 126d E','Japan - west of 126 deg East.',23.9,24.95,122.49,126.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2952,'Japan - 126d to 132d E','Japan - between 126 deg and 132 deg East.',23.9,35.05,126.0,132.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2953,'Japan - 132d to 138d E','Japan - between 132 deg and 138 deg East.',23.5,37.7,132.0,138.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2954,'Japan - 138d to 144d E','Japan - between 138 deg and 144 deg East.',23.5,45.73,138.0,144.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2955,'Japan - 144d to 150d E','Japan - east of 144 deg East.',42.7,44.45,144.0,150.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2956,'Kuwait - N of 29.25 N','Kuwait - north of a line between Al Jahra'' and the Kuwait/Iraq/Saudi Arabia border tripoint.',29.1,30.1,46.57,49.24,'','','',NULL,'','EPSG','EPSG','2004-06-16','',0),
(2957,'Kuwait - S of 29.25 N','Kuwait - south of a line between Al Jahra'' and the Kuwait/Iraq/Saudi Arabia border tripoint.',28.56,29.33,46.57,48.45,'','','',NULL,'','EPSG','EPSG','2004-06-16','',0),
(2958,'United States (USA) - Maine - CS2000 - W','United States (USA) - Maine west of approximately 69d 40m West. The area is bounded by the following: Beginning at the point determined by the intersection of the Maine State line and the County Line between Aroostook and Somerset Counties, thence following the Somerset County line Easterly to the Northwest corner of the Somerset and Piscataquis county line, thence Southerly along this county line to the northeast corner of the Athens town line, thence westerly along the town line between Brighton Plantation and Athens to the westerly corner of Athens, and continuing southerly to the southwest corner of the town of Athens where it meets the Cornville town line, thence westerly along the Cornville - Solon town line to the intersection of the Cornville - Madison town line, thence southerly and westerly following the Madison town line to the intersection of the Norridgewock - Skowhegan town line, thence southerly along the Skowhegan town line to the Fairfield town line, thence easterly along the Fairfield town line to the Clinton town line (being determined by the Kennebec River), thence southerly along the Kennebec River to the Augusta city line, thence easterly along the city line to the Windsor town line, thence southerly along the Augusta - Windsor town line to the northwest corner of the Lincoln County line, thence southerly along the westerly Lincoln county line to the boundary of the State of Maine as determined by Maritime law, thence following the State boundary on the westerly side of the state to the point of beginning.',42.94,46.58,-71.08,-69.58,'','','',NULL,'','EPSG','EPSG','2004-06-16','',0),
(2959,'United States (USA) - Maine - CS2000 - C','United States (USA) - Maine between approximately 69d 40m and 68deg 25min West. The area is bounded by the following: Beginning at the point determined by the intersection of the Maine State line and the County Line between Aroostook and Somerset Counties, thence northeasterly along the state line to the intersection of the Fort Kent - Frenchville town line, thence southerly along this town line to the intersection with the New Canada Plantation - T17 R5 WELS town line, thence continuing southerly along town lines to the northeast corner of Penobscot County, thence continuing southerly along the Penobscot County line to the intersection of the Woodville - Mattawamkeag town line (being determined by the Penobscot River), thence along the Penobscot River to the Enfield - Lincoln town line, thence southeasterly along the Enfield - Lincoln town line and the Enfield - Lowell town line to the Passadumkeag - Edinburg town line, thence south-southeasterly along town lines to the intersection of the Hancock County line, thence southerly along the county line to the intersection of the Otis - Mariaville town line, thence southerly along the Otis - Mariaville town line to the Ellsworth city line, thence southerly along the Ellsworth city line to the intersection of the Surry - Trenton town line, thence southerly along the easterly town lines of Surry, Blue Hill, Brooklin, Deer Isle, and Stonington to the Knox County line, thence following the Knox County line to the boundary of the State of Maine as determined by Maritime law, thence following the State boundary westerly to the intersection of the Sagadahoc - Lincoln county line, thence northerly along the easterly boundary of the Maine 2000 West Zone, as defined, to the point of beginning.',43.65,47.46,-70.02,-68.34,'','','',NULL,'','EPSG','EPSG','2004-06-16','',0),
(2960,'United States (USA) - Maine - CS2000 - E','United States (USA) - Maine east of approximately 68d 25m West. The area is bounded by the following: Beginning at the point determined by the intersection of the Maine State line and the Fort Kent - Frenchville town line, thence continuing easterly and then southerly along the state line to the boundary of the State of Maine as determined by Maritime law, thence following the State boundary westerly to the intersection of the Knox and Hancock County line, thence northerly along the easterly boundary of the Maine 2000 Central Zone, as defined, to the point of beginning.',43.97,47.37,-68.38,-66.89,'','','',NULL,'','EPSG','EPSG','2004-06-16','',0),
(2961,'Ireland - Corrib and Errigal','Ireland - offshore - Corrib and Errigal fields.',53.75,55.75,-11.6,-9.5,'','','',NULL,'','EPSG','EPSG','2004-09-01','',0),
(2962,'Brazil - Santos','Brazil - offshore - Santos basin.',-27.83,-23.5,-48.45,-41.5,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2963,'Brazil - Campos','Brazil - offshore - Campos basin.',-24.42,-21.0,-41.5,-38.5,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2964,'Brazil - Espirito Santo','Brazil - offshore - Espirito Santo basin.',-21.29,-18.18,-39.37,-38.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2965,'Brazil - Pelotas','Brazil - offshore - Pelotas basin.',-34.0,-32.0,-51.3,-48.5,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2966,'Brazil - Aratu offshore','Brazil - offshore south of 18 deg South.',-34.0,-18.0,-53.0,-36.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2967,'Mauritania - N coast','Mauritania - coastal area north of Cape Timiris.',19.36,21.25,-17.5,-16.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2968,'Mauritania - central coast','Mauritania - coastal area south of Cape Timiris.',17.3,19.36,-18.0,-16.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2969,'Mauritania - E of 6d W','Mauritania - east of 6 deg West.',14.73,27.31,-6.0,0.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2970,'Mauritania - 12d to 6d W','Mauritania - between 12 and 6 deg West.',14.73,27.31,-12.0,-6.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2971,'Mauritania - W of 12d W','Mauritania - west of 12 deg West.',14.73,27.31,-18.0,-12.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2972,'Mauritania - Nouakchutt','Mauritania - Nouakchutt',17.8,18.3,-18.1,-15.75,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2973,'United States (USA) - conus S of 41d N, W of 112d W','United States (USA) - CONUS south of 41 deg N and west of 112 deg W  -',31.5,41.0,-124.07,-112.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2974,'United States (USA) - conus S of 41d N, 112 to 95d W','United States (USA) - CONUS south of 41 deg N and between 112 and 95 deg W  -',25.83,41.0,-112.0,-95.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2975,'United States (USA) - conus S of 41d N, 95 to 88d W','United States (USA) - CONUS south of 41 deg N and between 95 and 88 deg W  -',29.0,41.0,-95.0,-88.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2976,'United States (USA) - conus S of 41d N, E of 88d W','United States (USA) - CONUS south of 41 deg N and east of 88 deg W  -',24.53,41.0,-88.0,-70.5,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2977,'United States (USA) - conus N of 41d N, W of 112d W','United States (USA) - CONUS north of 41 deg N and west of 112 deg W  -',41.0,49.0,-124.85,-112.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2978,'United States (USA) - conus N of 41d N, 112 to 95d W','United States (USA) - CONUS north of 41 deg N and between 112 and 95 deg W  -',41.0,49.39,-112.0,-95.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2979,'United States (USA) - conus N of 41d N, 95 to 88d W','United States (USA) - CONUS north of 41 deg N and between 95 and 88 deg W  -',41.0,49.39,-95.0,-88.0,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2980,'United States (USA) - conus N of 41d N, E of 88dW','United States (USA) - CONUS north of 41 deg N and east of 88 deg W  -',41.0,48.15,-88.0,-67.07,'','','',NULL,'','EPSG','EPSG','2004-04-27','',0),
(2981,'Nigeria - offshore','Nigeria - offshore.',2.25,6.4,2.7,8.55,'','','',NULL,'','','EPSG','2004-03-23','',0),
(2982,'Pakistan - Karachi','Pakistan - Karachi.',24.8,25.1,66.8,67.2,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2983,'Pakistan - East Sind','Pakistan - East Sind.',26.0,27.0,68.0,71.1,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2984,'Pakistan - Badin and Mehran','Pakistan - Badin and Mehran blocks.',24.0,25.36,67.8,68.79,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2985,'Pakistan - offshore Indus','Pakistan - offshore Indus fan',22.0,25.5,65.0,69.0,'','','',NULL,'','EPSG','EPSG','2004-10-14','',0),
(2986,'Australia - South Australia','Australia - South Australia (SA).',-38.4,-26.0,129.0,141.0,'','','',NULL,'','EPSG','EPSG','2004-10-20','',0),
(2987,'Libya - Amal','Libya - Amal field.',29.2,29.6,21.0,21.3,'','','',NULL,'','EPSG','EPSG','2004-11-02','',0),
(2988,'United Kingdom (UK) - Channel Islands - Jersey','Channel Islands - Jersey, Les Ecrehos and Les Minquiers.',48.93,49.34,-2.3,-1.98,'','','',NULL,'','EPSG','EPSG','2004-11-02','',0),
(2989,'United Kingdom (UK) - Channel Islands - Guernsey, Alderney, Sark','Channel Islands - Guernsey, Alderney, Sark, Herm, Brecqhou, Jethou, Lihou.',49.4,49.75,-2.75,-2.13,'','','',NULL,'','EPSG','EPSG','2004-11-02','',0),
(2990,'Australia - Queensland - Brisbane','Australia - Queensland (Qld) - Brisbane area:- local authorities in south-east Queensland: Gold Coast, Logan, Beaudesert, Redcliffe, Redlands, Pine Rivers, Caboolture,\ufffd\ufffd\ufffdCaloundra, Maroochy, Noosa, Maryborough; local authorities in north-east NSW: Tweed, Byron, Lismore, Ballina and\ufffd\ufffd\ufffdRichmond Valley.',-29.0,-25.0,152.3,153.7,'','','',NULL,'','EPSG','EPSG','2001-08-15','',0),
(2991,'Antarctica - 60 to 64dS, 72 to 60dW (SP19-20)','Antarctica - 60 deg to 64 deg South and 72 to 60 deg West.',-64.0,-60.0,-72.0,-60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2992,'Antarctica - 60 to 64dS, 60 to 48dW (SP21-22)','Antarctica - 60 deg to 64 deg South and 60 to 48 deg West.',-64.0,-60.0,-60.0,-48.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2993,'Antarctica - 60 to 64dS, 48 to 36dW (SP23-24)','Antarctica - 60 deg to 64 deg South and 48 to 36 deg West.',-64.0,-60.0,-48.0,-36.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2994,'Antarctica - 64 to 68dS, 180 to 168dW (SQ01-02)','Antarctica - 64 deg to 68 deg South and 180 to 168 deg West.',-68.0,-64.0,-180.0,-168.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2995,'Antarctica - 64 to 68dS, 72 to 60dW (SQ19-20)','Antarctica - 64 deg to 68 deg South and 72 to 60 deg West.',-68.0,-64.0,-72.0,-60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2996,'Antarctica - 64 to 68dS, 60 to 48dW (SQ21-22)','Antarctica - 64 deg to 68 deg South and 60 to 48 deg West.',-68.0,-64.0,-60.0,-48.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2997,'Antarctica - 64 to 68dS, 36 to 48dE (SQ37-38)','Antarctica - 64 deg to 68 deg South and 36 to 48 deg East.',-68.0,-64.0,36.0,48.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2998,'Antarctica - 64 to 68dS, 48 to 60dE (SQ39-40)','Antarctica - 64 deg to 68 deg South and 48 to 60 deg East.',-68.0,-64.0,48.0,60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(2999,'Antarctica - 64 to 68dS, 60 to 72dE (SQ41-42)','Antarctica - 64 deg to 68 deg South and 60 to 72 deg East.',-68.0,-64.0,60.0,72.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3000,'Antarctica - 64 to 68dS, 72 to 84dE (SQ43-44)','Antarctica - 64 deg to 68 deg South and 72 to 84 deg East.',-68.0,-64.0,72.0,84.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3001,'Antarctica - 64 to 68dS, 84 to 96dE (SQ45-46)','Antarctica - 64 deg to 68 deg South and 84 to 96 deg East.',-68.0,-64.0,84.0,96.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3002,'Antarctica - 64 to 68dS, 96 to 108dE (SQ47-48)','Antarctica - 64 deg to 68 deg South and 96 to 108 deg East.',-68.0,-64.0,96.0,108.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3003,'Antarctica - 64 to 68dS, 108 to 120dE (SQ49-50)','Antarctica - 64 deg to 68 deg South and 108 to 120 deg East.',-68.0,-64.0,108.0,120.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3004,'Antarctica - 64 to 68dS, 120 to 132dE (SQ51-52)','Antarctica - 64 deg to 68 deg South and 120 to 132 deg East.',-68.0,-64.0,120.0,132.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3005,'Antarctica - 64 to 68dS, 132 to 144dE (SQ53-54)','Antarctica - 64 deg to 68 deg South and 132 to 144 deg East.',-68.0,-64.0,132.0,144.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3006,'Antarctica - 64 to 68dS, 144 to 156dE (SQ55-56)','Antarctica - 64 deg to 68 deg South and 144 to 156 deg East.',-68.0,-64.0,144.0,156.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3007,'Antarctica - 64 to 68dS, 156 to 168dE (SQ57-58)','Antarctica - 64 deg to 68 deg South and 156 to 168 deg East.',-68.0,-64.0,156.0,168.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3008,'Antarctica - 68 to 72dS, 108 to 96dW (SR13-14)','Antarctica - 68 deg to 72 deg South and 108 to 96 deg West.',-72.0,-68.0,-108.0,-96.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3009,'Antarctica - 68 to 72dS, 96 to 84dW (SR15-16)','Antarctica - 68 deg to 72 deg South and 96 to 84 deg West.',-72.0,-68.0,-96.0,-84.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3010,'Antarctica - 68 to 72dS, 84 to 72dW (SR17-18)','Antarctica - 68 deg to 72 deg South and 84 to 72 deg West.',-72.0,-68.0,-84.0,-72.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3011,'Antarctica - 68 to 72dS, 72 to 60dW (SR19-20)','Antarctica - 68 deg to 72 deg South and 72 to 60 deg West.',-72.0,-68.0,-72.0,-60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3012,'Antarctica - 68 to 72dS, 24 to 12dW (SR27-28)','Antarctica - 68 deg to 72 deg South and 24 to 12 deg West.',-72.0,-68.0,-24.0,-12.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3013,'Antarctica - 68 to 72dS, 12 to 0dW (SR29-30)','Antarctica - 68 deg to 72 deg South and 12 to 0 deg West.',-72.0,-68.0,-12.0,0.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3014,'Antarctica - 68 to 72dS, 0 to 12dE (SR31-32)','Antarctica - 68 deg to 72 deg South and 0 to 12 deg East.',-72.0,-68.0,0.0,12.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3015,'Antarctica - 68 to 72dS, 12 to 24dE (SR33-34)','Antarctica - 68 deg to 72 deg South and 12 to 24 deg East.',-72.0,-68.0,12.0,24.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3016,'Antarctica - 68 to 72dS, 24 to 36dE (SR35-36)','Antarctica - 68 deg to 72 deg South and 24 to 36 deg East.',-72.0,-68.0,24.0,36.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3017,'Antarctica - 68 to 72dS, 36 to 48dE (SR37-38)','Antarctica - 68 deg to 72 deg South and 36 to 48 deg East.',-72.0,-68.0,36.0,48.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3018,'Antarctica - 68 to 72dS, 48 to 60dE (SR39-40)','Antarctica - 68 deg to 72 deg South and 48 to 60 deg East.',-72.0,-68.0,48.0,60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3019,'Antarctica - 68 to 72dS, 60 to 72dE (SR41-42)','Antarctica - 68 deg to 72 deg South and 60 to 72 deg East.',-72.0,-68.0,60.0,72.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3020,'Antarctica - 68 to 72dS, 72 to 84dE (SR43-44)','Antarctica - 68 deg to 72 deg South and 72 to 84 deg East.',-72.0,-68.0,72.0,84.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3021,'Antarctica - 68 to 72dS, 84 to 96dE (SR45-46)','Antarctica - 68 deg to 72 deg South and 84 to 96 deg East.',-72.0,-68.0,84.0,96.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3022,'Antarctica - 68 to 72dS, 96 to 108dE (SR47-48)','Antarctica - 68 deg to 72 deg South and 96 to 108 deg East.',-72.0,-68.0,96.0,108.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3023,'Antarctica - 68 to 72dS, 108 to 120dE (SR49-50)','Antarctica - 68 deg to 72 deg South and 108 to 120 deg East.',-72.0,-68.0,108.0,120.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3024,'Antarctica - 68 to 72dS, 120 to 132dE (SR51-52)','Antarctica - 68 deg to 72 deg South and 120 to 132 deg East.',-72.0,-68.0,120.0,132.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3025,'Antarctica - 68 to 72dS, 132 to 144dE (SR53-54)','Antarctica - 68 deg to 72 deg South and 132 to 144 deg East.',-72.0,-68.0,132.0,144.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3026,'Antarctica - 68 to 72dS, 144 to 156dE (SR55-56)','Antarctica - 68 deg to 72 deg South and 144 to 156 deg East.',-72.0,-68.0,144.0,156.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3027,'Antarctica - 68 to 72dS, 156 to 168dE (SR57-58)','Antarctica - 68 deg to 72 deg South and 156 to 168 deg East.',-72.0,-68.0,156.0,168.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3028,'Antarctica - 68 to 72dS, 168 to 180dE (SR59-60)','Antarctica - 68 deg to 72 deg South and 168 to 180 deg East.',-72.0,-68.0,168.0,180.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3029,'Antarctica - 72 to 76dS, 162 to 144dW (SS04-06)','Antarctica - 72 deg to 76 deg South and 162 to 144 deg West.',-76.0,-72.0,-168.0,-144.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3030,'Antarctica - 72 to 76dS, 144 to 126dW (SS07-09)','Antarctica - 72 deg to 76 deg South and 144 to 126 deg West.',-76.0,-72.0,-144.0,-126.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3031,'Antarctica - 72 to 76dS, 126 to 108dW (SS10-12)','Antarctica - 72 deg to 76 deg South and 126 to 108 deg West.',-76.0,-72.0,-126.0,-108.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3032,'Antarctica - 72 to 76dS, 108 to 90dW (SS13-15)','Antarctica - 72 deg to 76 deg South and 108 to 90 deg West.',-76.0,-72.0,-108.0,-90.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3033,'Antarctica - 72 to 76dS, 90 to 72dW (SS16-18)','Antarctica - 72 deg to 76 deg South and 90 to 72 deg West.',-76.0,-72.0,-90.0,-72.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3034,'Antarctica - 72 to 76dS, 72 to 54dW (SS19-21)','Antarctica - 72 deg to 76 deg South and 72 to 54 deg West.',-76.0,-72.0,-72.0,-54.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3035,'Antarctica - 72 to 76dS, 36 to 18dW (SS25-27)','Antarctica - 72 deg to 76 deg South and 36 to 18 deg West.',-76.0,-72.0,-36.0,-18.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3036,'Antarctica - 72 to 76dS, 18 to 0dW (SS28-30)','Antarctica - 72 deg to 76 deg South and 18 to 0 deg West.',-76.0,-72.0,-18.0,0.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3037,'Antarctica - 72 to 76dS, 0 to 18dE (SS31-33)','Antarctica - 72 deg to 76 deg South and 0 to 18 deg East.',-76.0,-72.0,0.0,18.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3038,'Antarctica - 72 to 76dS, 18 to 36dE (SS34-36)','Antarctica - 72 deg to 76 deg South and 18 to 36 deg East.',-76.0,-72.0,18.0,36.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3039,'Antarctica - 72 to 76dS, 36 to 54dE (SS37-39)','Antarctica - 72 deg to 76 deg South and 36 to 54 deg East.',-76.0,-72.0,36.0,54.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3040,'Antarctica - 72 to 76dS, 54 to 72dE (SS40-42)','Antarctica - 72 deg to 76 deg South and 54 to 72 deg East.',-76.0,-72.0,54.0,72.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3041,'Antarctica - 72 to 76dS, 72 to 90dE (SS43-45)','Antarctica - 72 deg to 76 deg South and 72 to 90 deg East.',-76.0,-72.0,72.0,90.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3042,'Antarctica - 72 to 76dS, 90 to 108dE (SS46-48)','Antarctica - 72 deg to 76 deg South and 90 to 108 deg East.',-76.0,-72.0,90.0,108.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3043,'Antarctica - 72 to 76dS, 108 to 126dE (SS49-51)','Antarctica - 72 deg to 76 deg South and 108 to 126 deg East.',-76.0,-72.0,108.0,126.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3044,'Antarctica - 72 to 76dS, 126 to 144dE (SS52-54)','Antarctica - 72 deg to 76 deg South and 126 to 144 deg East.',-76.0,-72.0,126.0,144.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3045,'Antarctica - 72 to 76dS, 144 to 162dE (SS55-57)','Antarctica - 72 deg to 76 deg South and 144 to 162 deg East.',-76.0,-72.0,144.0,162.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3046,'Antarctica - 72 to 76dS, 162 to 180dE (SS58-60)','Antarctica - 72 deg to 76 deg South and 162 to 180 deg East.',-76.0,-72.0,162.0,180.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3047,'Antarctica - 76 to 80dS, 180 to 156dW (ST01-04)','Antarctica - 76 deg to 80 deg South and 180 to 156 deg West.',-80.0,-76.0,-180.0,-156.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3048,'Antarctica - 76 to 80dS, 156 to 132dW (ST05-08)','Antarctica - 76 deg to 80 deg South and 156 to 132 deg West.',-80.0,-76.0,-156.0,-132.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3049,'Antarctica - 76 to 80dS, 132 to 108dW (ST09-12)','Antarctica - 76 deg to 80 deg South and 132 to 108 deg West.',-80.0,-76.0,-132.0,-108.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3050,'Antarctica - 76 to 80dS, 108 to 84dW (ST13-16)','Antarctica - 76 deg to 80 deg South and 108 to 84 deg West.',-80.0,-76.0,-108.0,-84.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3051,'Antarctica - 76 to 80dS, 84 to 60dW (ST17-20)','Antarctica - 76 deg to 80 deg South and 84 to 60 deg West.',-80.0,-76.0,-84.0,-60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3052,'Antarctica - 76 to 80dS, 60 to 36dW (ST21-24)','Antarctica - 76 deg to 80 deg South and 60 to 36 deg West.',-80.0,-76.0,-60.0,-36.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3053,'Antarctica - 76 to 80dS, 36 to 12dW (ST25-28)','Antarctica - 76 deg to 80 deg South and 36 to 12 deg West.',-80.0,-76.0,-36.0,-12.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3054,'Antarctica - 76 to 80dS, 12dW to 12dE (ST29-32)','Antarctica - 76 deg to 80 deg South and 12 deg West to 12 deg East.',-80.0,-76.0,-12.0,12.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3055,'Antarctica - 76 to 80dS, 12 to 36dE (ST33-36)','Antarctica - 76 deg to 80 deg South and 12 to 36 deg East.',-80.0,-76.0,12.0,36.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3056,'Antarctica - 76 to 80dS, 36 to 60dE (ST37-40)','Antarctica - 76 deg to 80 deg South and 36 to 60 deg East.',-80.0,-76.0,36.0,60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3057,'Antarctica - 76 to 80dS, 60 to 84dE (ST41-44)','Antarctica - 76 deg to 80 deg South and 60 to 84 deg East.',-80.0,-76.0,60.0,84.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3058,'Antarctica - 76 to 80dS, 84 to 108dE (ST45-48)','Antarctica - 76 deg to 80 deg South and 84 to 108 deg East.',-80.0,-76.0,84.0,108.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3059,'Antarctica - 76 to 80dS, 108 to 132dE (ST49-52)','Antarctica - 76 deg to 80 deg South and 108 to 132 deg East.',-80.0,-76.0,108.0,132.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3060,'Antarctica - 76 to 80dS, 132 to 156dE (ST53-56)','Antarctica - 76 deg to 80 deg South and 132 to 156 deg East.',-80.0,-76.0,132.0,156.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3061,'Antarctica - 76 to 80dS, 156 to 180dE (ST57-60)','Antarctica - 76 deg to 80 deg South and 156 to 180 deg East.',-80.0,-76.0,156.0,180.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3062,'Antarctica - 80 to 84dS, 180 to 150dW (SU01-05)','Antarctica - 80 deg to 84 deg South and 180 to 150 deg West.',-84.0,-80.0,-180.0,-150.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3063,'Antarctica - 80 to 84dS, 150 to 120dW (SU06-10)','Antarctica - 80 deg to 84 deg South and 150 to 120 deg West.',-84.0,-80.0,-150.0,-120.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3064,'Antarctica - 80 to 84dS, 120 to 90dW (SU11-15)','Antarctica - 80 deg to 84 deg South and 120 to 90 deg West.',-84.0,-80.0,-120.0,-90.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3065,'Antarctica - 80 to 84dS, 90 to 60dW (SU16-20)','Antarctica - 80 deg to 84 deg South and 90 to 60 deg West.',-84.0,-80.0,-90.0,-60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3066,'Antarctica - 80 to 84dS, 60 to 30dW (SU21-25)','Antarctica - 80 deg to 84 deg South and 60 to 30 deg West.',-84.0,-80.0,-60.0,-30.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3067,'Antarctica - 80 to 84dS, 30 to 0dW (SU26-30)','Antarctica - 80 deg to 84 deg South and 30 to 0 deg West.',-84.0,-80.0,-30.0,0.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3068,'Antarctica - 80 to 84dS, 0 to 30dE (SU31-35)','Antarctica - 80 deg to 84 deg South and 0 to 30 deg East.',-84.0,-80.0,0.0,30.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3069,'Antarctica - 80 to 84dS, 30 to 60dE (SU36-40)','Antarctica - 80 deg to 84 deg South and 30 to 60 deg East.',-84.0,-80.0,30.0,60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3070,'Antarctica - 80 to 84dS, 60 to 90dE (SU41-45)','Antarctica - 80 deg to 84 deg South and 60 to 90 deg East.',-84.0,-80.0,60.0,90.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3071,'Antarctica - 80 to 84dS, 90 to 120dE (SU46-50)','Antarctica - 80 deg to 84 deg South and 90 to 120 deg East.',-84.0,-80.0,90.0,120.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3072,'Antarctica - 80 to 84dS, 120 to 150dE (SU51-55)','Antarctica - 80 deg to 84 deg South and 120 to 150 deg East.',-84.0,-80.0,120.0,150.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3073,'Antarctica - 80 to 84dS, 150 to 180dE (SU56-60)','Antarctica - 80 deg to 84 deg South and 150 to 180 deg East.',-84.0,-80.0,150.0,180.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3074,'Antarctica - 84 to 88dS, 180 to 120dW (SV01-10)','Antarctica - 84 deg to 88 deg South and 180 to 120 deg West.',-88.0,-84.0,-180.0,-120.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3075,'Antarctica - 84 to 88dS, 120 to 60dW (SV11-20)','Antarctica - 84 deg to 88 deg South and 120 to 60 deg West.',-88.0,-84.0,-120.0,-60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3076,'Antarctica - 84 to 88dS, 60 to 0dW (SV21-30)','Antarctica - 84 deg to 88 deg South and 60 to 0 deg West.',-88.0,-84.0,-60.0,0.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3077,'Antarctica - 84 to 88dS, 0 to 60dE (SV31-40)','Antarctica - 84 deg to 88 deg South and 0 to 60 deg East.',-88.0,-84.0,0.0,60.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3078,'Antarctica - 84 to 88dS, 60 to 120dE (SV41-50)','Antarctica - 84 deg to 88 deg South and 60 to 120 deg East.',-88.0,-84.0,60.0,120.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3079,'Antarctica - 84 to 88dS, 120 to 180dE (SV51-60)','Antarctica - 84 deg to 88 deg South and 120 to 180 deg East.',-88.0,-84.0,120.0,180.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3080,'Antarctica - 88 to 90dS, 180dW to 180dE (SW01-60)','Antarctica - 88 deg to 90 deg South and 180 deg West to 180 deg East.',-90.0,-88.0,-180.0,180.0,'','','',NULL,'','Scientific Committee for Antarctic Research','EPSG','2005-04-12','',0),
(3081,'Antarctica - Transantarctic mountains N of 80d S.','Antarctica - Transantarctic mountains north of 80 deg South.',-80.0,-70.0,150.0,175.0,'','','',NULL,'','Scientific Committee for Antarctic Research (SCAR).','EPSG','2005-04-12','',0),
(3082,'Colombia region 1','Colombia - region I - 10 to 13 deg North, 73 to 71 deg West',10.0,13.0,-73.0,-71.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3083,'Colombia region 2','Colombia - region II - 9.4 to 11.6 deg North, 76 to 73 deg West',9.4,11.6,-76.0,-73.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3084,'Colombia region 3','Colombia - region III - 8 to 9.4 deg North, 77.6 to 74.4 deg West',8.0,9.4,-77.6,-74.4,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3085,'Colombia region 4','Colombia - region IV - 5 to 9.4 deg North, 74.4 to 72 deg West',5.0,9.4,-74.4,-72.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3086,'Colombia region 5','Colombia - region V - 5 to 8 deg North, 78 to 74.4 deg West',5.0,8.0,-78.0,-74.4,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3087,'Colombia region 6','Colombia - region VI - 3 to 5 deg North, 78 to 74.4 deg West',3.0,5.0,-78.0,-74.4,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3088,'Colombia region 7','Colombia - region VII - 1 to 3 deg North, 79 to 74 deg West',1.0,3.0,-79.0,-74.0,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3089,'Colombia region 8','Colombia - region VIII - 3 to 7.3 deg North, 74.4 to 66.5 deg West',3.0,7.3,-74.4,-66.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3090,'Colombia - 78d 35m to 75d 35m W','Colombia - between 78d 35m W and 75d 35m W of Greenwich (4 deg 30 min W and 1 deg 30 min W of Bogota).',0.0,10.1,-78.58,-75.58,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3091,'Colombia - W of 78d 35m W','Colombia - west of 78d 35m W of Greenwich (4 deg 30 min W of Bogota).',1.2,12.6,-85.79,-78.58,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3092,'Finland - W of 19.5 deg E','Finland - west of 19 deg 30 min East.',60.0,60.42,19.09,19.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3093,'Finland - 19.5 to 20.5 deg E','Finland - between 19 deg 30 min and 20 deg 30 min East.',59.9,60.5,19.5,20.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3094,'Finland - 20.5 to 21.5 deg E','Finland - between 20 deg 30 min and 21 deg 30 min East.',59.8,69.31,20.5,21.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3095,'Finland - 21.5 to 22.5 deg E','Finland - between 21 deg 30 min and 22 deg 30 min East.',59.8,69.3,21.5,22.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3096,'Finland - 22.5 to 23.5 deg E','Finland - between 22 deg 30 min and 23 deg 30 min East.',59.75,68.75,22.5,23.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3097,'Finland - 23.5 to 24.5 deg E','Finland - between 23 deg 30 min and 24 deg 30 min East.',59.8,68.85,23.5,24.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3098,'Finland - 24.5 to 25.5 deg E','Finland - between 24 deg 30 min and 25 deg 30 min East.',60.0,68.9,24.5,25.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3099,'Finland - 25.5 to 26.5 deg E','Finland - between 25 deg 30 min and 26 deg 30 min East.',60.15,69.95,25.5,26.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3100,'Finland - 26.5 to 27.5 deg E','Finland - between 26 deg 30 min and 27 deg 30 min East.',60.25,70.05,26.5,27.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3101,'Finland - 27.5 to 28.5 deg E','Finland - between 27 deg 30 min and 28 deg 30 min East.',60.4,70.13,27.5,28.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3102,'Finland - 28.5 to 29.5 deg E','Finland - between 28 deg 30 min and 29 deg 30 min East.',60.95,69.83,28.5,29.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3103,'Finland - 29.5 to 30.5 deg E','Finland - between 29 deg 30 min and 30 deg 30 min East.',61.5,67.95,29.5,30.5,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3104,'Finland - E of 30.5 deg E','Finland - east of 30 deg 30 min East.',62.07,64.3,30.5,31.59,'','','',NULL,'','EPSG','EPSG','2005-04-12','',0),
(3105,'French Guiana - coastal area','French Guiana - coastal area.',2.11,5.95,-54.65,-51.05,'','','',NULL,'','EPSG','EPSG','2005-04-24','',0),
(3106,'Saudi Arabia - E of 54 deg E','Saudi Arabia - east of 54 deg East.',19.64,22.75,54.0,55.7,'','','',NULL,'','EPSG','EPSG','2005-05-12','',0),
(3107,'Saudi Arabia - W of 36 deg E','Saudi Arabia - west of 36 deg East.',25.1,29.5,34.27,36.0,'','','',NULL,'','EPSG','EPSG','2005-05-12','',0),
(3108,'Micronesia - Yap Islands','Federated States of Micronesia - Yap Islands',9.43,9.64,138.05,138.2,'','','',NULL,'','EPSG','EPSG','2005-05-21','',0),
(3109,'American Samoa - 2 main island groups','American Samoa - Tutuila, Aunu''u, Ofu, Olesega and Ta''u islands.',-14.38,-14.16,-170.85,-169.41,'','','',NULL,'','EPSG','EPSG','2005-05-21','',0),
(3110,'American Samoa - 2 main island groups and Rose Island','American Samoa - Tutuila, Aunu''u, Ofu, Olesega, Ta''u and Rose islands.',-14.57,-14.16,-170.85,-169.12,'','','',NULL,'','EPSG','EPSG','2005-05-21','',0),
(3111,'Europe - ED79 tfm.','Austria; Finland; Netherlands; Norway; Spain; Sweden, Switzerland.',36.0,71.05,-8.95,31.6,'','','',NULL,'','EPSG','EPSG','2005-05-27','',0),
(3112,'South America - 84 to 78 deg W, N hem and PSAD56 by country','South America (Ecuador) between 84 and 78 deg West, northern hemisphere.',0.0,1.44,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','',0),
(3113,'Nigeria - OML 58','Nigeria - block OML 58',5.05,5.31,6.54,6.83,'','','',NULL,'','EPSG','EPSG','2005-08-03','',0),
(3114,'North America - 96 to 90 deg W and NAD83 by country','North America - between 96 and 90 deg West. Canada - Manitoba; Nunavut; Ontario. United States (USA).',14.25,82.0,-96.0,-90.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2006.464',0),
(3115,'North America - 90 to 84 deg W and NAD83 by country','North America - between 90 and 84 deg West. Canada - Manitoba; Nunavut; Ontario. United States (USA).',17.7,82.5,-90.0,-84.0,'','','',NULL,'','EPSG','EPSG','2006-07-19','2006.464',0),
(3116,'North America - 84 to 78 deg W and NAD83 by country','North America - between 84 and 78 deg West. Canada - Nunavut; Ontario; Quebec. United States (USA).',24.0,83.0,-84.0,-78.0,'','','',NULL,'','EPSG','EPSG','2006-06-12','',0),
(3117,'North America - 78 to 72 deg W and NAD83 by country','North America - between 78 and 72 deg West. Canada - Nunavut; Ontario; Quebec. United States (USA).',33.83,83.2,-78.0,-72.0,'','','',NULL,'','EPSG','EPSG','2006-06-12','',0),
(3118,'Grenada - main island - onshore','Grenada - main island - onshore.',11.95,12.25,-61.8,-61.55,'','','',NULL,'','EPSG','EPSG','2006-02-01','2005.89',0),
(3119,'Greenland - onshore','Greenland - onshore.',59.75,85.05,-73.5,-11.0,'','','',NULL,'','EPSG','EPSG','2005-07-01','',0),
(3120,'French Polynesia - W of 150 deg W','French Polynesia - west of 150 deg West.',-24.0,-9.0,-155.0,-150.0,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3121,'French Polynesia - 150 to 144 deg W','French Polynesia - between 150 and 144 deg West.',-29.0,-13.0,-150.0,-144.0,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(3122,'French Polynesia - 144 to 138 deg W','French Polynesia - between 144 and 138 deg West',-29.0,-7.0,-144.0,-138.0,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(3123,'French Polynesia - E of 138 deg W','French Polynesia - east of 138 deg West.',-25.0,-18.0,-138.0,-132.0,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(3124,'French Polynesia - Society Islands - Tahiti','French Polynesia - Society Islands - Tahiti.',-17.91,-17.45,-149.69,-149.07,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3125,'French Polynesia - Society Islands - Moorea','French Polynesia - Society Islands - Moorea.',-17.61,-17.45,-149.96,-149.69,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(3126,'French Polynesia - Society Islands - Maupiti','French Polynesia - Society Islands - Maupiti.',-16.52,-16.33,-152.33,-152.16,'','','',NULL,'','EPSG','EPSG','2002-11-29','',0),
(3127,'French Polynesia - Marquises Islands - Ua Huka','French Polynesia - Marquises Islands - Ua Huka.',-9.0,-8.85,-139.6,-139.45,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3128,'French Polynesia - Marquises Islands - Ua Pou','French Polynesia - Marquises Islands - Ua Pou.',-9.5,-9.33,-140.17,-140.0,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3129,'French Polynesia - Marquises Islands - Nuku Hiva, Ua Huka and Ua Pou','French Polynesia - Marquises Islands - Nuku Hiva, Ua Huka and Ua Pou.',-9.5,-8.75,-140.25,-139.45,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3130,'French Polynesia - Marquises Islands - Hiva Oa and Tahuata','French Polynesia - Marquises Islands - Hiva Oa and Tahuata.',-10.05,-9.67,-139.18,-138.8,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3131,'French Polynesia - Marquises Islands - Hiva Oa','French Polynesia - Marquises Islands - Hiva Oa.',-9.88,-9.67,-139.18,-138.8,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3132,'French Polynesia - Marquises Islands - Tahuata','French Polynesia - Marquises Islands - Tahuata.',-10.05,-9.88,-139.15,-139.0,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3133,'French Polynesia - Marquises Islands - Fatu Iva','French Polynesia - Marquises Islands - Fatu Iva.',-10.55,-10.33,-138.7,-138.55,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3134,'French Polynesia - Society Islands - main islands','French Polynesia - Society Islands - Bora Bora, Huahine, Maupiti, Moorea, Raiatea, Tahaa and Tahiti.',-17.91,-16.42,-152.33,-149.07,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3135,'French Polynesia - Society Islands - Huahine','French Polynesia - Society Islands - Huahine.',-16.85,-16.67,-151.06,-150.93,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3136,'French Polynesia - Society Islands - Raiatea','French Polynesia - Society Islands - Raiatea.',-16.94,-16.69,-151.57,-151.41,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3137,'French Polynesia - Society Islands - Bora Bora','French Polynesia - Society Islands - Bora Bora.',-16.65,-16.42,-152.33,-151.65,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3138,'French Polynesia - Society Islands - Tahaa','French Polynesia - Society Islands - Tahaa.',-16.69,-16.55,-151.5,-151.34,'','','',NULL,'','EPSG','EPSG','2005-08-12','',0),
(3139,'Australia - New South Wales (NSW)','Australia - New South Wales (NSW).',-37.5,-28.15,141.0,153.62,'','','',NULL,'','EPSG','EPSG','2005-08-18','',0),
(3140,'Iran - South Pars block 11','Iran - South Pars field phase 11.',26.67,26.95,52.17,52.45,'','','',NULL,'','EPSG','EPSG','2005-08-18','',0),
(3141,'Iran - Tombak LNG plant','Iran - Tombak LNG plant.',27.7,27.8,52.1,52.25,'','','',NULL,'','EPSG','EPSG','2005-08-18','',0),
(3142,'Libya - Sirte NC192','Libya - Sirte Basin licence NC192.',27.83,28.67,21.17,21.83,'','','',NULL,'','EPSG','EPSG','2002-07-16','',0),
(3143,'Trinidad and Tobago - Trinidad - onshore','Trinidad and Tobago - Trinidad - onshore.',10.04,10.84,-61.93,-60.91,'','','',NULL,'','EPSG','EPSG','2005-09-23','',0),
(3144,'French Guiana - E of 54 deg W','French Guiana - east of 54 deg West.',2.16,9.06,-54.0,-49.62,'','','',NULL,'','EPSG','EPSG','2005-09-23','',0),
(3145,'French Guiana - W of 54 deg W','French Guiana - west of 54 deg West.',2.11,5.45,-54.65,-54.0,'','','',NULL,'','EPSG','EPSG','2005-09-23','',0),
(3146,'French Guiana - onshore','French Guiana - onshore.',2.11,5.78,-54.65,-51.6,'','','',NULL,'','EPSG','EPSG','2005-09-23','',0),
(3147,'Congo DR (Zaire) - Katanga','The Democratic Republic of the Congo (Zaire) - Katanga',-13.46,-6.0,24.0,30.78,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3148,'Congo DR (Zaire) - Kasai - SE','The Democratic Republic of the Congo (Zaire) - Kasai - south of 5 deg South and east of 21deg 30min East.',-7.25,-5.0,21.5,24.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3149,'Congo DR (Zaire) - 6th parallel south','The Democratic Republic of the Congo (Zaire) - adjacent to 6th parallel south',-7.25,-5.0,12.21,30.6,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3150,'Congo DR (Zaire) - 11 to 13 deg E','The Democratic Republic of the Congo (Zaire) - west of 13 deg East.',-6.1,-4.67,12.21,13.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3151,'Congo DR (Zaire) - 13 to 15 deg E','The Democratic Republic of the Congo (Zaire) - between 13 to 15 deg East.',-5.9,-4.25,13.0,15.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3152,'Congo DR (Zaire) - 15 to 17 deg E','The Democratic Republic of the Congo (Zaire) - between 15 to 17 deg East.',-7.2,-1.1,15.0,17.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3153,'Congo DR (Zaire) - 17 to 19 deg E','The Democratic Republic of the Congo (Zaire) - between 17 to 19 deg East.',-8.15,4.75,17.0,19.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3154,'Congo DR (Zaire) - 19 to 21 deg E','The Democratic Republic of the Congo (Zaire) - between 19 to 21 deg East.',-8.0,5.15,19.0,21.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3155,'Congo DR (Zaire) - 21 to 23 deg E','The Democratic Republic of the Congo (Zaire) - between 21 to 23 deg East.',-11.26,4.85,21.0,23.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3156,'Congo DR (Zaire) - 23 to 25 deg E','The Democratic Republic of the Congo (Zaire) - between 23 to 25 deg East.',-11.48,5.12,23.0,25.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3157,'Congo DR (Zaire) - 25 to 27 deg E','The Democratic Republic of the Congo (Zaire) - between 25 to 27 deg East.',-12.02,5.38,25.0,27.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3158,'Congo DR (Zaire) - 27 to 29 deg E','The Democratic Republic of the Congo (Zaire) - between 27 to 29 deg East.',-13.42,5.2,27.0,29.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3159,'Congo DR (Zaire) - 29 to 31 deg E','The Democratic Republic of the Congo (Zaire) - east of 29 deg East.',-13.46,4.67,29.0,30.6,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3160,'Congo DR (Zaire) - 15 to 17 deg E and 4 to 6 deg S','The Democratic Republic of the Congo (Zaire) - between 15 to 17 deg East and between 4 to 6 deg South.',-5.9,-4.2,15.0,17.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3161,'Congo DR (Zaire) - 17 to 19 deg E and 4 to 6 deg S','The Democratic Republic of the Congo (Zaire) - between 17 to 19 deg East and between 4 to 6 deg South.',-5.5,-4.2,17.0,19.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3162,'Congo DR (Zaire) - 19 to 21 deg E and 4 to 7 deg S','The Democratic Republic of the Congo (Zaire) - between 19 to 21 deg East and between 4 to 7 deg South.',-7.25,-4.5,19.0,21.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3163,'Congo DR (Zaire) - 21 to 23 deg E and 5 to 7 deg S','The Democratic Republic of the Congo (Zaire) - between 21 to 23 deg East and between 5 to 7 deg South.',-7.25,-5.0,21.0,23.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3164,'Congo DR (Zaire) - 23 to 25 deg E and 5 to 7 deg S','The Democratic Republic of the Congo (Zaire) - between 23 to 25 deg East and between 5 to 7 deg South.',-7.25,-5.0,23.0,25.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3165,'Congo DR (Zaire) - 25 to 27 deg E and 5 to 7 deg S','The Democratic Republic of the Congo (Zaire) - between 25 to 27 deg East and between 5 to 7 deg South.',-7.25,-5.0,25.0,27.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3166,'Congo DR (Zaire) - 27 to 29 deg E and 4 to 7 deg S','The Democratic Republic of the Congo (Zaire) - between 27 to 29 deg East and between 4 to 7 deg South.',-7.25,-4.0,27.0,29.0,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3167,'Congo DR (Zaire) - 29 to 31 deg E and 4 to 5 deg S','The Democratic Republic of the Congo (Zaire) - between east of 29 deg East and between 4 to 5 deg South.',-5.0,-4.0,29.0,30.6,'','','',NULL,'','EPSG','EPSG','2005-09-30','',0),
(3168,'Poland - W of 18 deg E','Poland - west of 18 deg East.',49.98,54.85,14.14,18.0,'','','',NULL,'','OGP','EPSG','2005-11-02','',0),
(3169,'Poland - 18 to 24 deg E','Poland - between 18 deg and 24 deg East.',49.03,55.95,18.0,24.0,'','','',NULL,'','OGP','EPSG','2005-11-02','',0),
(3170,'Poland - E of 24 deg E','Poland - east of 24 deg East.',50.4,50.9,24.0,24.16,'','','',NULL,'','OGP','EPSG','2005-11-02','',0),
(3171,'Congo DR (Zaire) - Bas Congo','The Democratic Republic of the Congo (Zaire) - Lower Congo (Bas Congo)',-6.1,-3.95,12.21,16.5,'','','',NULL,'','OGP','EPSG','2005-09-30','',0),
(3172,'Pacific Ocean','Pacific Ocean - American Samoa, Antarctica, Australia, Brunei Darussalam, Cambodia, Canada, Chile, China, China - Hong Kong, China - Macau, Cook Islands, Ecuador, Fiji, French Polynesia, Guam, Indonesia, Japan, Kiribati, Democratic People''s Republic of Korea (North Korea), Republic of Korea (South Korea), Malaysia, Marshall Islands, Federated States of Micronesia, Nauru, New Caledonia, New Zealand, Niue, Norfolk Island, Northern Mariana Islands, Palau, Panama, Papua New Guinea (PNG), Peru, Philippines, Pitcairn, Russian Federation, Samoa, Singapore, Solomon Islands, Taiwan, Thailand, Tokelau, Tonga, Tuvalu, United States (USA), United States Minor Outlying Islands, Vanuatu, Venezuela, Vietnam, Wallis and Futuna.',-78.8,65.6,99.3,-70.0,'','','',NULL,'Area crosses 180-degree meridian.','OGP','EPSG','2005-12-21','',0),
(3173,'Europe - FSU - CS63 zone C0','Estonia, Latvia and Lithuania - west of 23deg 27min E. Russia - Kaliningrad.',53.8,59.8,20.45,23.45,'','','',NULL,'','OGP','EPSG','2005-12-21','',0),
(3174,'Europe - FSU - CS63 zone C1','Estonia, Latvia and Lithuania - between 23deg 27min and 26deg 27min E.',53.8,59.8,23.45,26.45,'','','',NULL,'','OGP','EPSG','2005-12-21','',0),
(3175,'Europe - FSU - CS63 zone C2','Estonia, Latvia and Lithuania - east of 26deg 27min E.',53.8,59.8,26.45,28.25,'','','',NULL,'','OGP','EPSG','2005-12-21','',0),
(3176,'Brazil - 54 to 48 deg W and south of 15 deg S','Brazil - between 54 and 48 deg West and south of 15 deg South.',-33.8,-15.0,-54.0,-48.0,'','','',NULL,'','OGP','OGP','2005-12-30','',0),
(3177,'Brazil - 48 to 42 deg W and south of 15 deg S','Brazil - between 48 and 42 deg West and south of 15 deg South.',-26.3,-15.0,-48.0,-42.0,'','','',NULL,'','OGP','OGP','2005-12-30','',0),
(3178,'Brazil - E of 36 deg W','Brazil - east of 36 deg West .',-10.05,-5.15,-36.0,-34.5,'','','',NULL,'','OGP','OGP','2005-12-30','',0),
(3179,'Africa - Angola (Cabinda) and DR Congo (Zaire) - coastal','Africa - Angola (Cabinda) - onshore and offshore; The Democratic Republic of the Congo (Zaire) Congo (Zaire) - onshore coastal area and offshore.',-6.0,-4.37,10.85,13.11,'','','',NULL,'','OGP','OGP','2005-12-30','',0),
(3180,'Africa - Angola (Cabinda) and DR Congo (Zaire) - offshore','Africa - Angola (Cabinda) - offshore; The Democratic Republic of the Congo (Zaire) - offshore.',-6.0,-5.03,10.85,12.43,'','','',NULL,'','OGP','OGP','2005-12-30','',0),
(3181,'United States (USA) - Hawaii - Tern Island and Sorel Atoll','United States (USA) - Hawaii - Tern Island and Sorel Atoll.',23.61,23.88,-166.33,-166.03,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3182,'Saint Helena - Ascension Island','Saint Helena - Ascension Island.',-7.99,-7.88,-14.42,-14.29,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3183,'Saint Helena - St. Helena','Saint Helena - St. Helena Island.',-16.03,-15.88,-5.81,-5.63,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3184,'Saint Helena - Tristan da Cunha','Saint Helena - Tristan da Cunha island group including Tristan, Inaccessible, Nightingale, Middle and Stoltenhoff Islands.',-37.43,-37.05,-12.73,-12.21,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3185,'Cayman Islands - Grand Cayman','Cayman Islands - Grand Cayman.',19.26,19.41,-81.44,-81.08,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3186,'Cayman Islands - Little Cayman and Cayman Brac','Cayman Islands - Little Cayman and Cayman Brac.',19.65,19.76,-80.1,-79.71,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3187,'South Georgia','South Georgia and the South Sandwich Islands - South Georgia Island',-55.22,-53.8,-38.46,-34.63,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3188,'Chile - Easter Island','Chile - Easter Island.',-27.21,-27.06,-109.47,-109.23,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3189,'British Indian Ocean Territory - Diego Garcia','British Indian Ocean Territory - Chagos Archipelago - Diego Garcia',-7.49,-7.21,72.34,72.5,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3190,'Marshall Islands - Wake Island','Marshall Islands - Wake Island',19.26,19.34,166.58,166.66,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3191,'Marshall Islands - Eniwetok, Kwajalein and Wake islands','Marshall Islands - Eniwetok, Kwajalein and Wake islands',8.64,19.34,162.03,168.0,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3192,'Micronesia - Caroline Islands','Federated States of Micronesia - Caroline Islands',4.0,12.76,136.66,168.43,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3193,'Vanuatu - southern islands','Vanuatu - southern islands - Efate, Erromango and Tanna.',-19.7,-17.4,168.1,169.64,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3194,'Vanuatu - northern islands','Vanuatu - northern islands - Aese, Ambrym, Aoba, Epi, Espiritu Santo, Maewo, Malo, Malkula, Paama, Penecost, Shepherd and Tutuba.',-17.4,-14.61,166.5,168.31,'','','',NULL,'','OGP','OGP','2006-07-29','2006.51',0),
(3195,'Fiji - Viti Levu','Fiji - Viti Levu island.',-18.6,-17.26,177.02,178.87,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3196,'Kiribati - Phoenix Islands','Kiribati - Phoenix Islands: Kanton, Orona, McKean Atoll, Birnie Atoll, Phoenix Seamounts',-4.64,-2.72,-174.2,-171.3,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3197,'Solomon Islands - Guadalcanal Island','Solomon Islands - Guadalcanal Island.',-9.96,-9.24,159.56,160.91,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3198,'Solomon Islands - New Georgia - Ghizo (Gizo)','Solomon Islands - New Georgia - Ghizo (Gizo) Island.',-8.15,-8.0,156.7,156.9,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3199,'Spain - Canary Islands','Spain - Canary Islands.',27.72,29.4,-17.363,-13.3,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3200,'Japan - Iwo Jima','Japan - Iwo Jima island',24.74,24.823,141.28,141.36,'','','',NULL,'','OGP','OGP','2007-02-06','2007.016',0),
(3201,'Johnston Island','United States Minor Outlying Islands - Johnston Island.',16.0,16.81,-169.63,-169.3,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3202,'Midway Islands - Sand and Eastern Islands','United States Minor Outlying Islands - Midway Islands - Sand Island and Eastern Island',28.18,28.29,-177.42,-177.3,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3203,'Japan - Minamitori-shima (Marcus Island)','Japan - Minamitori-shima (Marcus Island).',24.26,24.32,153.95,154.01,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3204,'Antarctica - Antarctic Peninsula and Deception Island','Antarctica - Antarctic Peninsula and South Shetland Islands - Deception Island.',-64.1,-62.86,-61.0,-60.18,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3205,'Antarctica - Camp McMurdo area','Antarctica - McMurdo Sound, Camp McMurdo area.',-78.0,-77.0,165.5,167.0,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3206,'North America - Bahamas and USA - Florida','North America - Bahamas and USA - Florida (east).',20.8,30.69,-82.0,-72.72,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3207,'Cayman Islands - Cayman Brac','Cayman Islands - Cayman Brac.',19.68,19.76,-79.9,-79.71,'','','',NULL,'','OGP','OGP','2006-01-26','',0),
(3208,'Pitcairn - Pitcairn Island','Pitcairn - Pitcairn Island.',-25.16,-25.0,-130.18,-129.99,'','','',NULL,'','OGP','OGP','2006-02-02','',0),
(3209,'Mauritius - mainland','Mauritius - mainland onshore.',-20.5,-19.95,57.3,57.8,'','','',NULL,'','OGP','OGP','2006-02-02','',0),
(3210,'Serbia and Montenegro','Serbia and Montenegro - onshore and offshore.',41.82,46.23,18.44,23.05,'','CS','SCG',891,'','ISO 3166 Maintenance Agency.','OGP','2006-02-01','',0),
(3211,'Aland Islands','\ufffd\ufffd\ufffdland Islands - onshore and offshore.',59.95,60.47,19.32,20.7,'','AX','ALA',248,'','ISO 3166 Maintenance Agency.','OGP','2006-02-03','',0),
(3212,'Albania - onshore','Albania - onshore.',39.67,42.69,19.25,21.06,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3213,'Algeria - onshore','Algeria - onshore.',18.98,37.0,-8.67,11.99,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3214,'Anguilla - onshore','Anguilla - onshore.',18.16,18.31,-63.39,-62.93,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3215,'Argentina - onshore','Argentina - onshore.',-55.25,-21.8,-73.62,-56.21,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3216,'Aruba - onshore','Aruba - onshore.',12.39,12.66,-70.07,-69.85,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3217,'Bangladesh - onshore','Bangladesh - onshore.',20.63,26.65,88.1,92.72,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3218,'Barbados - onshore','Barbados - onshore.',13.0,12.35,-59.67,-59.4,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3219,'Belize - onshore','Belize - onshore.',15.87,18.49,-89.27,-87.79,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3220,'Benin - onshore','Benin - onshore.',6.25,12.4,0.78,3.86,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3221,'Bermuda - onshore','Bermuda - onshore.',32.22,32.41,-64.91,-64.63,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3222,'Bouvet Island - onshore','Bouvet Island - onshore.',-54.5,-54.35,3.27,3.57,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3223,'Brazil - onshore','Brazil - onshore.',-34.05,5.45,-74.05,-34.33,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3224,'Bulgaria - onshore','Bulgaria - onshore.',41.27,44.26,22.37,28.68,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3225,'Cambodia - onshore','Cambodia - onshore.',10.34,14.71,102.31,107.7,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3226,'Cameroon - onshore','Cameroon - onshore.',1.66,13.09,8.51,16.22,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3227,'Chile - onshore','Chile - onshore.',-56.0,-17.52,-75.95,-66.39,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3228,'China - onshore','China - onshore.',18.04,53.59,73.66,134.85,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3229,'Colombia - mainland','Colombia - mainland.',-4.22,12.65,-79.06,-66.91,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3230,'Congo - onshore','Congo - onshore.',-5.05,3.72,11.14,18.65,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3231,'Congo DR (Zaire) - onshore','The Democratic Republic of the Congo (Zaire) - onshore.',-12.11,5.38,12.21,31.3,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3232,'Costa Rica - onshore','Costa Rica - onshore.',8.02,11.22,-85.9,-82.5,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3233,'Cote d''Ivoire (Ivory Coast) - onshore','C\ufffd\ufffd\ufffdte d''Ivoire (Ivory Coast) - onshore.',4.32,10.74,-8.61,-2.49,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3234,'Croatia - onshore','Croatia - onshore.',42.3,46.57,13.47,19.5,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3235,'Cuba - onshore','Cuba - onshore.',19.74,23.3,-85.03,-74.05,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3236,'Cyprus - onshore','Cyprus - onshore.',34.54,35.75,32.24,34.64,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3237,'Denmark - onshore','Denmark - onshore.',54.5,57.9,7.8,12.9,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3238,'Djibouti - onshore','Djibouti - onshore.',10.94,12.75,41.78,43.45,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3239,'Dominica - onshore','Dominica - onshore.',15.19,15.65,-61.5,-61.2,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3240,'Dominican Republic - onshore','Dominican Republic - onshore.',17.48,20.0,-72.0,-68.25,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3241,'Ecuador - onshore','Ecuador - onshore.',-5.01,1.5,-81.45,-75.26,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3242,'Egypt - onshore','Egypt - onshore.',21.99,31.65,24.71,36.9,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3243,'El Salvador - onshore','El Salvador - onshore.',13.12,14.46,-90.13,-87.6,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3244,'Equatorial Guinea - onshore','Equatorial Guinea - onshore.',0.9,2.38,9.3,11.36,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3245,'Eritrea - onshore','Eritrea - onshore.',12.33,18.05,36.4,43.15,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3246,'Estonia - onshore','Estonia - onshore.',57.57,59.66,21.84,28.0,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3247,'Falkland Islands (Malvinas) - onshore','Falkland Islands (Malvinas) - onshore.',-52.45,-51.0,-61.43,-57.7,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3248,'Faroe Islands - onshore','Faroe Islands - onshore.',61.33,62.42,-7.75,-6.18,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3249,'Gabon - onshore','Gabon - onshore.',-4.03,2.33,8.65,14.55,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3250,'Gambia - onshore','Gambia - onshore.',13.02,13.83,-16.85,-13.81,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3251,'Georgia - onshore','Georgia - onshore.',41.12,43.56,40.0,46.8,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3252,'Ghana - onshore','Ghana - onshore.',4.65,11.17,-3.39,1.24,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3253,'Gibraltar - onshore','Gibraltar - onshore.',36.13,36.17,-5.39,-5.37,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3254,'Greece - onshore','Greece - onshore.',33.23,41.77,18.27,29.97,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3255,'Guam - onshore','Guam - onshore.',13.21,13.69,144.6,145.0,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3256,'Guatemala - onshore','Guatemala - onshore.',13.68,17.83,-92.29,-88.17,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3257,'Guinea - onshore','Guinea - onshore.',7.16,12.69,-15.12,-7.65,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3258,'Guinea-Bissau - onshore','Guinea-Bissau - onshore.',10.89,12.69,-16.73,-13.65,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3259,'Guyana - onshore','Guyana - onshore.',1.19,8.43,-61.43,-56.66,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3260,'Haiti - onshore','Haiti - onshore.',18.0,20.12,-74.5,-71.67,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3261,'Honduras - onshore','Honduras - onshore.',12.99,16.52,-89.4,-83.13,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3262,'Iceland - onshore','Iceland - onshore.',63.25,66.6,-24.6,-13.4,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3263,'Japan - Hokkaido, Honshu, Shikoku, Kyushu  - onshore','Japan - Hokkaido, Honshu, Shikoku, Kyushu  - onshore.',30.15,45.92,128.5,146.09,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3264,'Kenya - onshore','Kenya - onshore.',-4.76,5.03,33.93,41.93,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3265,'Korea, Democratic People''s Republic of (North Korea) - onshore','Democratic People''s Republic of Korea (North Korea) - onshore.',37.67,43.03,124.24,130.75,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3266,'Korea, Republic of (South Korea) - onshore','Republic of Korea (South Korea) - onshore.',33.18,38.67,125.8,129.72,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3267,'Kuwait - onshore','Kuwait - onshore.',28.56,30.1,46.57,48.45,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3268,'Latvia - onshore','Latvia - onshore.',55.64,58.09,20.98,28.23,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3269,'Lebanon - onshore','Lebanon - onshore.',33.05,34.7,35.1,36.65,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3270,'Liberia - onshore','Liberia - onshore.',4.27,8.57,-11.5,-7.37,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3271,'Libya - onshore','Libya - onshore.',19.51,32.9,9.31,25.15,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3272,'Lithuania - onshore','Lithuania - onshore.',53.92,56.48,21.07,26.82,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3273,'Madagascar - onshore','Madagascar - onshore.',-25.66,-11.9,43.2,50.6,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3274,'Maldives - onshore','Maldives - onshore.',3.9,4.5,73.33,73.7,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3275,'Malta - onshore','Malta - onshore.',35.8,36.09,14.18,14.6,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3276,'Martinique - onshore','Martinique - onshore.',14.38,14.9,-61.25,-60.79,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3277,'Mauritania - onshore','Mauritania - onshore.',14.73,27.31,-17.05,-4.81,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3278,'Mexico - onshore','Mexico - onshore.',14.33,32.74,-117.45,-86.42,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3279,'Montserrat - onshore','Montserrat - onshore.',16.66,16.83,-62.25,-61.1,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3280,'Morocco - onshore','Morocco - onshore.',27.68,36.23,-13.77,-1.01,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3281,'Mozambique - onshore','Mozambique - onshore.',-26.88,-10.4,30.23,40.9,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3282,'Myanmar (Burma) - onshore','Myanmar (Burma) - onshore.',10.0,28.57,92.2,101.23,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3283,'Namibia - onshore','Namibia - onshore.',-29.05,-16.99,11.65,25.28,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3284,'Netherlands - onshore','Netherlands - onshore.',50.78,53.6,3.33,7.3,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3285,'New Zealand - onshore','New Zealand - onshore - North Island, South Island, Stewart Island.',-47.4,-34.0,166.33,178.6,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3286,'Nicaragua - onshore','Nicaragua - onshore.',10.67,15.05,-87.75,-83.11,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3287,'Nigeria - onshore','Nigeria - onshore.',4.15,13.9,2.7,14.68,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3288,'Oman - onshore','Oman - onshore.',16.6,26.4,51.9,59.89,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3289,'Pakistan - onshore','Pakistan - onshore.',23.6,37.08,60.91,77.87,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3290,'Panama - onshore','Panama - onshore.',7.13,9.7,-83.06,-77.15,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3291,'Papua New Guinea (PNG) - onshore','Papua New Guinea (PNG) - onshore.',-11.69,-1.33,140.93,156.0,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3292,'Peru - onshore','Peru - onshore.',-18.53,-0.03,-81.4,-68.72,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3293,'Poland - onshore','Poland - onshore.',49.03,54.87,14.14,24.16,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3294,'Puerto Rico - onshore','Puerto Rico - onshore.',17.85,18.55,-67.3,-65.57,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3295,'Romania - onshore','Romania - onshore.',43.62,48.26,20.26,29.67,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3296,'Russian Federation - onshore','Russian Federation - onshore.',35.16,81.9,19.15,-168.25,'','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2006-02-01','',0),
(3297,'Saint Kitts and Nevis - onshore','Saint Kitts and Nevis - onshore.',17.09,17.43,-62.88,-62.53,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3298,'Saint Lucia - onshore','Saint Lucia - onshore.',13.7,14.12,-61.08,-60.86,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3299,'Saint Pierre and Miquelon - onshore','Saint Pierre and Miquelon - onshore.',46.75,47.15,-56.44,-56.13,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3300,'Saint Vincent and the Grenadines - onshore','Saint Vincent and the northern Grenadine Islands - onshore.',12.85,13.38,-61.3,-61.1,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3301,'Samoa - onshore','Samoa - onshore.',-14.08,-13.4,-172.8,-171.4,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3302,'Sao Tome and Principe - onshore','Sao Tome and Principe - onshore.',-0.02,1.71,6.44,7.49,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3303,'Saudi Arabia - onshore','Saudi Arabia - onshore.',16.27,32.26,34.6,55.7,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3304,'Senegal - onshore','Senegal - onshore.',12.32,16.7,-17.55,-11.37,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3305,'Serbia and Montenegro - onshore','Serbia and Montenegro - onshore.',41.82,46.23,18.44,23.05,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3306,'Sierra Leone - onshore','Sierra Leone - onshore.',6.89,10.0,-13.3,-10.27,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3307,'Slovenia - onshore','Slovenia - onshore.',45.44,46.91,13.37,16.68,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3308,'Somalia - onshore','Somalia - onshore.',-1.67,12.0,41.01,51.44,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3309,'South Africa - onshore','South Africa - onshore.',-35.0,-22.14,16.4,32.95,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3310,'Sri Lanka - onshore','Sri Lanka - onshore.',5.85,9.92,79.6,81.95,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3311,'Sudan - onshore','Sudan - onshore.',3.49,22.25,21.84,38.6,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3312,'Suriname - onshore','Suriname - onshore.',1.84,6.0,-58.11,-53.9,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3313,'Sweden - onshore','Sweden - onshore.',55.25,69.1,10.57,24.18,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3314,'Syria - onshore','Syria - onshore.',32.33,37.34,35.7,42.4,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3315,'Taiwan, Province of China - onshore','Taiwan, Province of China - onshore.',21.8,25.4,119.4,122.05,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3316,'Tanzania - onshore','Tanzania - onshore.',-11.75,-1.0,29.36,40.58,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3317,'Thailand - onshore','Thailand - onshore.',5.63,20.47,98.1,105.7,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3318,'Timor-Leste (East Timor) - onshore','Timor-Leste (East Timor) - onshore.',-9.5,-8.11,124.9,127.4,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3319,'Togo - onshore','Togo - onshore.',6.0,11.15,-0.15,1.82,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3320,'Tokelau - onshore','Tokelau - onshore.',-9.5,-8.5,-172.0,-171.5,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3321,'Tonga - onshore','Tonga - onshore.',-19.8,-18.4,-175.18,-173.7,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3322,'Turkey - onshore','Turkey - onshore.',35.75,42.2,25.7,44.85,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3323,'Turks and Caicos Islands - onshore','Turks and Caicos Islands - onshore.',21.15,22.0,-72.5,-71.05,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3324,'Ukraine - onshore','Ukraine - onshore.',44.41,52.38,22.17,40.29,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3325,'United Arab Emirates (UAE) - onshore','United Arab Emirates (UAE) - onshore. Abu Dhabi, Dubai, Sharjah, Umm al Qaywayn, Al Fujairah, Ras al Khaymah.',22.64,26.07,51.5,56.4,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3326,'Uruguay - onshore','Uruguay - onshore.',-35.0,-30.12,-58.51,-53.33,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3327,'Venezuela - onshore','Venezuela - onshore.',0.65,12.25,-73.36,-59.67,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3328,'Vietnam - onshore','Vietnam - onshore.',8.45,23.39,103.8,109.6,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3329,'Virgin Islands, British - onshore','British Virgin Islands - onshore.',18.3,18.8,-64.8,-64.25,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3330,'Virgin Islands, US - onshore','US Virgin Islands - onshore - St. Croix, St. John, and St. Thomas.',17.67,18.42,-65.1,-64.55,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3331,'Western Sahara - onshore','Western Sahara - onshore.',20.78,27.68,-17.1,-8.67,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3332,'Yemen - onshore','Yemen - onshore.',12.5,19.01,42.5,53.1,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3333,'Finland - onshore','Finland - onshore.',59.3,70.13,19.4,31.59,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3334,'China - Hong Kong - onshore','China - Hong Kong - onshore.',22.16,22.62,113.89,114.57,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3335,'China - Hong Kong - offshore','China - Hong Kong - offshore.',22.16,22.62,113.89,114.57,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3336,'Iran - onshore.','Iran - onshore.',24.95,39.8,44.06,63.37,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3337,'Reunion - Reunion Island','Reunion - Reunion Island.',-21.4,-20.8,55.2,55.8,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3338,'New Zealand - Stewart Island','New Zealand - Stewart Island.',-47.4,-46.67,167.3,168.45,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3339,'Germany - onshore','Germany - onshore - states of Baden-Wurtemberg, Bayern, Brandenburg, Hessen, Mecklenburg-Vorpommern, Niedersachsen, Nordrhein-Westfalen, Rheinland-Pfalz, Saarland, Sachsen, Sachsen-Anhalt, Schleswig-Holstein, Thuringen.',47.27,55.03,5.75,15.03,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3340,'Mayotte - onshore','Mayotte - onshore.',-13.0,-12.6,44.97,45.32,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3341,'India - onshore','India - onshore.',7.95,35.55,68.2,97.45,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3342,'Jamaica - onshore','Jamaica - onshore.',17.65,18.6,-78.4,-76.1,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3343,'Italy - including San Marino and Vatican','Italy - onshore and offshore; San Marino, Vatican City State.',34.49,47.12,5.95,18.97,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3344,'New Zealand - South and Stewart Islands','New Zealand - South Island, Stewart Island.',-47.4,-40.4,166.33,174.5,'','','',NULL,'','OGP','OGP','2006-02-01','',0),
(3355,'Brazil - S of 18 deg S and W of 54deg W.','Brazil - south of 18deg South and west of 54deg West.',-31.95,-18.0,-58.2,-54.0,'','','',NULL,'','OGP','OGP','2006-02-12','',0),
(3356,'South America - Brazil - S of 18 deg S and W of 54deg W; N Paraguay','Brazil - south of 18deg South and west of 54deg West. Paraguay - north.',-35.89,-2.8,-62.68,-34.5,'','','',NULL,'','OGP','OGP','2006-02-12','',0),
(3357,'United States (USA) - GoM','United States (USA) - offshore Gulf of Mexico (GoM) - protraction areas Brazos (including south addition), Matagorda Island, Mustang Island (including east addition); North Padre Island (including east addition), South Padre Island (including east addition), Corpus Christi, Port Isabel, Galverston (including south addition), East Breaks, Aliminos Canyon, High Island (including all additions and extensions), Sabine Pass, West Cameron (including west and south additions), East Cameron (including south addition), Vermillion (including south addition), South Marsh Island (including north and south additions), Eugene Island (including south addition), Ship Shoal (including south addition), South Timbalier (including south addition), Grand Isle (including south addition), West Delta (including south addition), South Pass (including south and east additions), Main Pass (including south and east addition), Breton Sound, Chandeleur (including east addition), Mobile, Viosca Knoll, Mississippi Canyon, Atwater Valley, Lund, Lund South, Ewing Bank, Green Canyon, Walker Ridge, Amery Terrace, Garden Banks, Keathley Canyon, Sigsbee Escarpment, Galverston (including south addition), East Breaks, Aliminos Canyon, Pensacola, Destin Dome, Desoto Canyon, Lloyd Ridge, Henderson, Florida Plain, Gainesville, Tarpon Springs, St. Petersburg, Charlotte Harbor, Pulley Ridge, Dry Tortugas, Tortugas Valley, Miami, Key West, Apalachicola, Florida Middle Ground, The Elbow, Vernon Basin, Howell Hook, Rankin and Campeche Escarpment.',23.82,30.35,-97.5,-81.18,'','','',NULL,'','OGP','OGP','2006-03-06','',0),
(3358,'United States (USA) - GoM - E of 87.25 deg W','United States (USA) - offshore Gulf of Mexico (GoM) east of approximately 87.25 deg West - protraction areas Gainesville, Tarpon Springs, St. Petersburg, Charlotte Harbor, Pulley Ridge, Dry Tortugas, Tortugas Valley, Miami, Key West, Apalachicola, Florida Middle Ground, The Elbow, Vernon Basin, Howell Hook, Rankin and Campeche Escarpment. Also for protraction areas Pensacola, Destin Dome, Desoto Canyon, Lloyd Ridge, Henderson and Florida Plain - east of 87.25 deg West.',23.82,30.35,-87.25,-81.18,'','','',NULL,'','OGP','OGP','2006-03-06','',0),
(3359,'United States (USA) - GoM - between 95 and 87.25 deg W','United States (USA) - offshore Gulf of Mexico (GoM) between approximately 95 deg and 87.25 deg West - protraction areas High Island (including all additions and extensions), Sabine Pass, West Cameron (including west and south additions), East Cameron (including south addition), Vermillion (including south addition), South Marsh Island (including north and south additions), Eugene Island (including south addition), Ship Shoal (including south addition), South Timbalier (including south addition), Grand Isle (including south addition), West Delta (including south addition), South Pass (including south and east additions), Main Pass (including south and east addition), Breton Sound, Chandeleur (including east addition), Mobile, Viosca Knoll, Mississippi Canyon, Atwater Valley, Lund, Lund South, Ewing Bank, Green Canyon, Walker Ridge, Amery Terrace, Garden Banks, Keathley Canyon and Sigsbee Escarpment. Also for protraction areas Galverston (including south addition), East Breaks and Aliminos Canyon - east of 95 deg West; for protraction areas Pensacola, Destin Dome, Desoto Canyon, Lloyd Ridge, Henderson and Florida Plain - west of 87.25 deg West.',25.5,30.33,-95.0,-87.25,'','','',NULL,'','OGP','OGP','2006-03-06','',0),
(3360,'United States (USA) - GoM - W of 95 deg W','United States (USA) - offshore Gulf of Mexico (GoM) west of approximately 95 deg West - protraction areas Brazos (including south addition), Matagorda Island, Mustang Island (including east addition); North Padre Island (including east addition), South Padre Island (including east addition), Corpus Christi and Port Isabel. Also protraction areas Galverston (including south addition), East Breaks and Aliminos Canyon - west of 95 deg West.',26.0,29.2,-97.5,-95.0,'','','',NULL,'','OGP','OGP','2006-03-06','',0),
(3361,'Mexico - offshore GoM - Tampico area','Mexico - offshore Gulf of Mexico (GoM) - Tampico area.',21.5,22.4,-97.8,-97.0,'','','',NULL,'','OGP','OGP','2006-03-06','',0),
(3362,'Greenland - west coast','Greenland - west coast.',59.75,79.0,-73.0,-42.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3363,'Greenland - west coast - between 63 and 66 deg N','Greenland - west coast - between 63 and 66 deg North.',63.0,66.0,-54.0,-48.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3364,'Greenland - west coast - between 66 and 69 deg N','Greenland - west coast - between 66 and 69 deg North.',66.0,69.0,-54.0,-49.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3365,'Greenland - west coast - between 69 and 72 deg N','Greenland - west coast - between 69 and 72 deg North.',69.0,72.0,-57.0,-50.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3366,'Greenland - west coast - between 72 and 75 deg N','Greenland - west coast - between 72 and 75 deg North.',72.0,75.0,-60.0,-55.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3367,'Greenland - west coast - between 75 and 78 deg N','Greenland - west coast - between 75 and 78 deg North.',75.0,78.0,-73.0,-57.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3368,'Greenland - west coast - between 78 and 79 deg N','Greenland - west coast - between 78 and 79 deg North.',78.0,79.0,-73.0,-63.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3369,'Greenland - east coast - between 68 and 69 deg N','Greenland - east coast - between 68 and 69 deg North.',68.0,69.0,-73.0,-42.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3370,'Greenland - east coast - between 69 and 72 deg N','Greenland - east coast - between 69 and 72 deg North.',69.0,72.0,-73.0,-42.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3371,'Greenland - east coast - between 72 and 75 deg N','Greenland - east coast - between 72 and 75 deg North.',72.0,75.0,-73.0,-42.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3372,'United States (USA) - west of 174 deg E','United States (USA) - west of 174 deg East. Alaska and offshore continental shelf (OCS).',49.0,56.3,168.0,174.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3373,'United States (USA) - 174 to 180 deg E','United States (USA) - between 174 and 180 deg East. Alaska and offshore continental shelf (OCS).',48.0,59.8,174.0,180.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3374,'United States (USA) - 180 to 174 deg W','United States (USA) - between 180 and 174 deg West. Alaska and offshore continental shelf (OCS).',48.0,63.3,-180.0,-174.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3375,'United States (USA) - 174 to 168 deg W','United States (USA) - between 174 and 168 deg West. Alaska and offshore continental shelf (OCS).',48.7,73.0,-174.0,-168.0,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3376,'Malaysia - West Malaysia - Johor','Malaysia - West Malaysia - Johor.',1.2,2.91,102.48,105.54,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3377,'Malaysia - West Malaysia - Sembilan and Melaka','Malaysia - West Malaysia - Negeri Sembilan and Melaka.',2.08,3.29,101.7,102.72,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3378,'Malaysia - West Malaysia - Pahang','Malaysia - West Malaysia - Pahang.',2.45,4.77,101.33,103.65,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3379,'Malaysia - West Malaysia - Selangor','Malaysia - West Malaysia - Selangor.',2.58,3.88,100.8,101.96,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3380,'Malaysia - West Malaysia - Terengganu','Malaysia - West Malaysia - Terengganu.',3.85,5.92,102.38,103.5,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3381,'Malaysia - West Malaysia - Pulau Pinang','Malaysia - West Malaysia - Pulau Pinang - Pinang (Penang) Island and Seberang Perai (Province Wellesley).',5.1,5.57,100.17,100.56,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3382,'Malaysia - West Malaysia - Kedah and Perlis','Malaysia - West Malaysia - Kedah and Perlis.',5.07,6.75,100.11,101.14,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3383,'Malaysia - West Malaysia - Perak','Malaysia - West Malaysia - Perak.',3.66,5.93,100.35,101.76,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3384,'Malaysia - West Malaysia - Kelantan','Malaysia - West Malaysia - Kelantan.',4.54,6.24,101.34,102.68,'','','',NULL,'','OGP','OGP','2006-03-16','',0),
(3385,'Finland - E of 31.5 deg E','Finland - east of 31 deg 30 min East.',62.8,63.0,31.5,31.59,'','','',NULL,'','OGP','OGP','2006-03-30','',0),
(3386,'Asia - Middle East - Iraq and Kuwait 42 to 48 deg E','Iraq - between 42 and 48 deg East. Kuwait - west of 48 deg East.',22.75,30.08,42.0,48.0,'','','',NULL,'','OGP','OGP','2006-06-02','',0),
(3387,'Iraq - W of 42 deg E','Iraq - west of 42 deg East.',31.14,36.75,38.82,42.0,'','','',NULL,'','OGP','OGP','2006-06-02','',0),
(3388,'Iraq - 42 to 48 deg E','Iraq - between 42 and 48 deg East.',29.06,37.41,42.0,48.0,'','','',NULL,'','OGP','OGP','2006-06-02','',0),
(3389,'Iraq - E of 48 deg E','Iraq - east of 48 deg East.',29.75,31.0,48.0,49.4,'','','',NULL,'','OGP','OGP','2006-06-02','',0),
(3390,'Asia - Middle East - Iraq - SE and Iran -W','Iraq - southeast. Iran - area bounding southeast Iraq.',29.75,33.5,44.3,49.4,'','','',NULL,'','OGP','OGP','2006-06-02','',0),
(3391,'World - between 80 deg S and 84 deg N','World between 80 deg South and 84 deg North.',-80.0,84.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2006-06-02','',0),
(3392,'Germany - Thuringen - W of 10.5 deg E','Germany - Thuringen - west of 10deg 30min East.',50.35,51.6,9.87,10.5,'','','',NULL,'','OGP','OGP','2006-06-12','',0),
(3393,'Germany - Thuringen - E of 10.5 deg E','Germany - Thuringen - east of 10deg 30min East.',50.19,51.65,10.5,12.65,'','','',NULL,'','OGP','OGP','2006-06-12','',0),
(3394,'Germany - Sachsen - E of 13.5 deg E','Germany - Sachsen - east of 13deg 30min East.',50.6,51.57,13.5,15.04,'','','',NULL,'','OGP','OGP','2006-06-12','',0),
(3395,'Germany - Sachsen - W of 13.5 deg E','Germany - Sachsen - west of 13deg 30min East.',50.15,51.69,11.87,13.5,'','','',NULL,'','OGP','OGP','2006-06-12','',0),
(3396,'Germany - Mecklenburg-Vorpommern and Sachsen-Anhalt','Germany - Mecklenburg-Vorpommern and Sachsen-Anhalt.',50.94,53.05,10.54,14.43,'','','',NULL,'','OGP','OGP','2006-06-12','',0),
(3397,'Iraq - SE','Iraq - southeast (Basra area).',29.06,31.0,46.0,49.4,'','','',NULL,'','OGP','OGP','2006-06-12','',0),
(3398,'Fiji - main islands','Fiji - Viti Levu, Vanua Levu, Taveuni and immediately adjacent smaller islands.',-18.5,-16.0,177.0,-179.5,'','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2006-07-20','',0),
(3399,'Fiji - main islands - W of 180 deg','Fiji - Viti Levu, Vanua Levu, Taveuni and immediately adjacent smaller islands - west of 180 deg.',-18.5,-16.0,177.0,180.0,'','','',NULL,'','OGP','OGP','2006-07-20','',0),
(3400,'Fiji - main islands - E of 180 deg','Fiji - Viti Levu, Vanua Levu, Taveuni and immediately adjacent smaller islands - east of 180 deg.',-18.5,-16.0,-180.0,-179.5,'','','',NULL,'','OGP','OGP','2006-07-20','',0),
(3401,'Fiji - Vanua Levu and Taveuni','Fiji - Vanua Levu and Taveuni.',-17.05,-16.0,178.25,-179.5,'','','',NULL,'Area crosses 180-degree meridian.','OGP','OGP','2006-07-20','',0),
(3402,'Algeria - Hassi Mouina licence area','Algeria - Hassi Mouina licence area.',29.25,31.0,0.0,1.52,'','','',NULL,'','OGP','OGP','2006-06-22','',0),
(3403,'Russia - W of 19.5 deg E','Russian Federation - Kaliningrad - west of 19 deg 30 min East.',54.32,55.3,19.2,19.5,'','','',NULL,'','OGP','OGP','2006-07-14','',0),
(3404,'North America - 120 to 114 deg W and NAD83 by country','North America - between 120 and 114 deg West. Canada - Alberta; British Columbia (BC); North West Territories; Nunavut. United States (USA).',27.0,78.33,-120.0,-114.0,'','','',NULL,'','OGP','OGP','2006-07-19','',0),
(3405,'North America - 114 to 108 deg W and NAD83 by country','North America - between 114 and 108 deg West. Canada - Alberta; North West Territories; Nunavut; Saskatchewan.   United States (USA).',24.83,79.25,-114.0,-108.0,'','','',NULL,'','OGP','OGP','2006-07-19','',0),
(3406,'North America - 108 to 102 deg W and NAD83 by country','North America - between 108 and 102 deg West. Canada - North West Territories; Nunavut; Saskatchewan.  United States (USA).',17.83,80.1,-108.0,-102.0,'','','',NULL,'','OGP','OGP','2006-07-19','',0),
(3407,'North America - 102 to 96 deg W and NAD83 by country','North America - between 102 and 96 deg West. Canada - Manitoba; Nunavut; Saskatchewan.  United States (USA).',15.5,81.0,-102.0,-96.0,'','','',NULL,'','OGP','OGP','2006-07-19','',0),
(3408,'Sweden - Stockholm','Sweden - Stockholm commune',59.23,59.45,17.77,18.2,'','','',NULL,'','Lantmateriet, http://www.lantmateriet.com, SWEPOS pages.','OGP','2006-07-20','',0),
(3409,'Canada - 144 to 138 deg W, S of 60 deg N','Canada south of 60 deg North and west of 138 deg West - British Columbia (BC).',58.0,60.0,-144.0,-138.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3410,'Canada - 138 to 132 deg W, S of 60 deg N','Canada south of 60 deg North and between 138 and 132 deg West - British Columbia (BC).',52.0,60.0,-138.0,-132.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3411,'Canada - 132 to 126 deg W, S of 60 deg N','Canada south of 60 deg North and between 132 and 126 deg West - British Columbia (BC).',49.0,60.0,-132.0,-126.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3412,'Canada - 126 to 120 deg W, S of 60 deg N','Canada south of 60 deg North and between 126 and 120 deg West - British Columbia (BC).',48.3,60.0,-120.0,-114.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3413,'Canada - 102 to 96 deg W, S of 60 deg N','Canada south of 60 deg North and between 102 and 96 deg West - Manitoba, Saskatchewan.',49.0,60.0,-102.0,-96.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3414,'Canada - 96 to 90 deg W, S of 60 deg N','Canada south of 60 deg North and between 96 and 90 deg West - Manitoba, Ontario.',48.0,60.0,-96.0,-90.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3415,'Canada - 90 to 84 deg W, S of 60 deg N','Canada south of 60 deg North and between 90 and 84 deg West - Manitoba, Ontario.',46.2,60.0,-90.0,-84.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3416,'Canada - 84 to 78 deg W, S of 60 deg N','Canada south of 60 deg North and between 84 and 78 deg West - Ontario and Quebec.',41.7,60.0,-84.0,-78.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3417,'Canada - 78 to 72 deg W, S of 60 deg N','Canada south of 60 deg North and between 78 and 72 deg West - Ontario and Quebec.',43.6,60.0,-78.0,-72.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3418,'Latin America - all countries','Latin America - Argentina, Brazil, Belize, Bolivia, Chile, Colombia, Costa Rica, Ecuador, El Salvador, French Guiana, Guatemala, Guyana, Honduras, Mexico, Nicaraguar, Panama, Paraguay, Peru, Suriname, Uruguay, Venezuela.',-56.15,32.74,-118.5,-34.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3419,'North America - 72 to 66 deg W and NAD83 by country','North America - between 72 and 66 deg West. Canada - Labrador; Nunavut; Quebec. United States (USA).',40.8,83.2,-72.0,-66.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3420,'North America - 66 to 60 deg W and NAD83 by country','North America - between 66 and 60 deg West. Canada - Labrador; Nunavut; Quebec. United States (USA) offshore Atlantic',43.33,83.0,-66.0,-60.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3421,'Latin America - 84 to 78 deg West; northern hemisphere.','Latin America - between 84 and 78 deg West; northern hemisphere.',0.0,16.0,-84.0,-78.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3422,'Latin America - 78 to 72 deg West; northern hemisphere.','Latin America - between 78 and 72 deg West; northern hemisphere.',0.0,11.5,-78.0,-72.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3423,'Mexico - W of 114 deg W','Mexico west of 114 deg West.',0.0,32.74,-120.0,-114.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3424,'Mexico - 114 to 108 deg W','Mexico between 114 and 108 deg West.',0.0,32.2,-114.0,-108.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3425,'Mexico - 108 to 102 deg W','Mexico between 108 and 102 deg West.',0.0,32.0,-108.0,-102.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3426,'Mexico - 102 to 96 deg W','Mexico between 102 and 96 deg West.',0.0,29.9,-102.0,-96.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3427,'Latin America - 96 to 90 deg W and SIRGAS by country','Latin America (including Mexico) between 96 and 90 deg West.',0.0,22.0,-96.0,-90.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3428,'Latin America - 90 to 84 deg W and SIRGAS by country','Latin America between 90 and 84 deg West. Mexico east of 90 deg West.',0.0,22.0,-90.0,-84.0,'','','',NULL,'','OGP','OGP','2006-07-21','',0),
(3429,'Spain - mainland and Balearic Islands','Spain - mainland and Balearic Islands.',35.98,43.8,-9.3,4.33,'','','',NULL,'','OGP','OGP','2006-07-24','',0),
(3430,'New Caledonia - Belep, Grande Terre, Ile des Pins, Loyalty Islands','New Caledonia - Belep, Grande Terre, Ile des Pins, Loyalty Islands (Lifou, Mare, Ouvea).',-22.75,-19.54,163.55,168.2,'','','',NULL,'','OGP','OGP','2006-07-25','',0),
(3431,'New Caledonia - W of 162 deg E','New Caledonia - west of 162 deg East.',-23.46,-17.26,157.09,162.0,'','','',NULL,'','OGP','OGP','2006-07-25','',0),
(3432,'New Caledonia - 162 to 168 deg E','New Caledonia - between 162 and 168 deg East.',-23.46,-17.26,162.0,168.0,'','','',NULL,'','OGP','OGP','2006-07-25','',0),
(3433,'New Caledonia - E of 168 deg E','New Caledonia - east of 168 deg East.',-23.46,-17.26,168.0,173.89,'','','',NULL,'','OGP','OGP','2006-07-25','',0),
(3434,'New Caledonia - Mare - W of 168 deg E','New Caledonia - Loyalty Islands - Mare - west of 168 deg East.',-21.7,-21.3,167.75,174.0,'','','',NULL,'','OGP','OGP','2006-07-25','',0),
(3435,'New Caledonia - Mare - E of 168 deg E','New Caledonia - Loyalty Islands - Mare - east of 168 deg East.',-21.7,-21.3,168.0,168.15,'','','',NULL,'','OGP','OGP','2006-07-25','',0),
(3436,'South America - 72 to 66 deg W, N hem and SIRGAS by country','South America (Brazil) between 72 and 66 deg West, northern hemisphere.',0.0,13.0,-72.0,-66.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3437,'South America - 66 to 60 deg W, N hem and SIRGAS by country','South America (Brazil) between 66 and 60 deg West, northern hemisphere.',0.0,11.2,-66.0,-60.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3438,'South America - 60 to 54 deg W, N hem and SIRGAS by country','South America (Brazil) between 60 and 54 deg West, northern hemisphere.',0.0,8.56,-60.0,-54.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3439,'South America - 54 to 48 deg W, N hem and SIRGAS by country','South America (Brazil) between 54 and 48 deg West, northern hemisphere.',0.0,5.75,-54.0,-48.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3440,'South America - 78 to 72 deg W, S hem and SIRGAS by country','South America (Brazil) between 78 and 72 deg West, southern hemisphere.',-54.8,0.0,-78.0,-72.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3441,'South America - 72 to 66 deg W, S hem and SIRGAS by country','South America (Brazil) between 72 and 66 deg West, southern hemisphere.',-56.15,0.0,-72.0,-66.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3442,'South America - 66 to 60 deg W, S hem and SIRGAS by country','South America (Brazil) between 66 and 60 deg West, southern hemisphere.',-55.33,0.0,-66.0,-60.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3443,'South America - 60 to 54 deg W, S hem and SIRGAS by country','South America (Brazil) between 60 and 54 deg West, southern hemisphere.',-38.9,0.0,-60.0,-54.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3444,'South America - 54 to 48 deg W, S hem and SIRGAS by country','South America (Brazil) between 54 and 48 deg West, southern hemisphere.',-34.6,0.0,-54.0,-48.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3445,'South America - 48 to 42 deg W and SIRGAS by country','South America (Brazil) between 48 and 42 deg West.',-26.3,0.0,-48.0,-42.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3446,'South America - 42 to 36 deg W and SIRGAS by country','South America (Brazil) between 42 and 36 deg West.',-23.0,0.0,-42.0,-36.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3447,'South America - 36 to 30 deg W and SIRGAS by country','South America (Brazil) between 36 and 30 deg West.',-9.9,0.0,-36.0,-30.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3448,'South America','South America.',-56.15,13.0,-82.0,-34.0,'','','',NULL,'','OGP','OGP','2006-07-29','',0),
(3449,'Greenland - W of 72d W','Greenland - west of 72 deg West.',77.0,79.0,-73.5,-72.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3450,'Greenland - 72 to 66 deg W','Greenland - between 72 and 66 deg West.',76.0,81.0,-72.0,-66.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3451,'Greenland - 66 to 60 deg W','Greenland - between 66 and 60 deg West.',75.0,82.0,-66.0,-60.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3452,'Greenland - 60 to 54 deg W','Greenland - between 60 and 54deg West.',73.0,82.0,-60.0,-54.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3453,'Greenland - 54 to 48 deg W','Greenland - between 54 and 48 deg West.',60.0,83.0,-54.0,-48.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3454,'Greenland - 48 to 42 deg W','Greenland - between 48 and 42 deg West.',59.0,84.0,-48.0,-42.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3455,'Greenland - 42 to 36 deg W','Greenland - between 42 and 36 deg West.',61.0,84.0,-42.0,-36.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3456,'Greenland - 36 to 30 deg W','Greenland - between 36 and 30 deg West.',65.0,84.0,-36.0,-30.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3457,'Greenland - 30 to 24 deg W','Greenland - between 30 and 24 deg West.',68.0,84.0,-30.0,-24.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3458,'Greenland - 24 to 18 deg W','Greenland - between 24 and 18 deg West.',69.0,84.0,-24.0,-18.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3459,'Greenland - 18 to 12 deg W','Greenland - between 18 and 12 deg West.',79.0,82.0,-18.0,-12.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3460,'Greenland - E of 12d W','Greenland - east of 12 deg West.',81.0,82.0,-12.0,-11.0,'','','',NULL,'','OGP','OGP','2006-07-30','',0),
(3461,'Mexico - offshore GoM - Campeche area N','Mexico - offshore Gulf of Mexico (GoM) - Bay of Campeche northeast.',20.64,23.0,-94.6,-89.0,'','','',NULL,'','OGP','OGP','2006-08-28','',0),
(3462,'Mexico - offshore GoM - Campeche area S','Mexico - offshore Gulf of Mexico (GoM) - Bay of Campeche southeast.',18.25,20.64,-94.67,-90.44,'','','',NULL,'','OGP','OGP','2006-08-28','',0),
(3463,'World - between 86 deg S and 86 deg N','World between 86 deg South and 86 deg North.',-86.0,86.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2006-12-15','',0),
(3464,'Chad - W of 18 deg E and WGS72BE','Between 12 and 18 deg East northern hemisphere. Chad - west of 18 deg East.',0.0,84.0,12.0,18.0,'','','',NULL,'','OGP','OGP','2006-09-22','',0),
(3465,'Chad - E of 18 deg E and WGS72BE','Between 18 and 24 deg East northern hemisphere. Chad - east of 18 deg East.',0.0,84.0,18.0,24.0,'','','',NULL,'','OGP','OGP','2006-09-22','',0),
(3466,'China - 108 to 108.5E and 37.75 to 38.25N','China - Orduz basin',37.75,38.25,108.0,108.5,'','','',NULL,'','OGP','OGP','2006-10-30','',0),
(3467,'North America - Great Lakes basin','Canada and United States (USA) - Great Lakes basin',40.4,50.74,-93.21,-74.5,'','','',NULL,'','Great Lakes Fisheries Commission','OGP','2006-11-11','',0),
(3468,'North America - Great Lakes basin and St Lawrence Seaway','Canada and United States (USA) - Great Lakes basin and St Lawrence Seaway',40.4,50.74,-93.21,-73.29,'','','',NULL,'','Great Lakes Fisheries Commission','OGP','2006-11-11','',0),
(3469,'China - offshore Yellow Sea','China - offshore Yellow Sea.',31.4,37.0,119.2,124.2,'','','',NULL,'','OGP','OGP','2006-11-17','',0),
(3470,'China - South China Sea - Pearl River basin.','China - offshore South China Sea - Pearl River basin.',19.5,22.0,111.0,117.0,'','','',NULL,'','OGP','OGP','2006-11-17','',0),
(3471,'Denmark - west of 12 deg E','Denmark - west of 12 deg E - Zealand west of 12 deg E; Jutland, Fuen and Lolland.',54.6,57.75,8.09,12.0,'','','',NULL,'','OGP','OGP','2006-12-01','',0),
(3472,'Denmark - east of 12 deg E','Denmark - east of 12 deg E - Zealand and Falster east of 12 deg E, Bornholm.',54.5,56.15,12.0,15.15,'','','',NULL,'','OGP','OGP','2006-12-01','',0),
(3473,'World - S of 40 deg S','Southern hemisphere - south of 40 deg South.',-90.0,-40.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2006-12-15','',0),
(3474,'World - S of 0 deg N','Southern hemisphere.',-90.0,0.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2006-12-15','',0),
(3475,'World - N of 0 deg N','Northern hemisphere.',0.0,90.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2006-12-15','',0),
(3476,'World - N of 30 deg N','Northern hemisphere - north of 30 deg North.',30.0,90.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2006-12-15','',0),
(3477,'Libya - Cyrenaica','Libya - Cyrenaica area 42, blocks 2 and 4.',32.0,32.67,22.5,23.0,'','','',NULL,'','OGP','OGP','2007-01-18','',0),
(3478,'Jamaica - W of 78 deg W','Jamaica - west of 78 deg West.',17.65,18.6,-78.4,-78.0,'','','',NULL,'','OGP','OGP','2007-01-19','',0),
(3479,'Jamaica - E of 78 deg W','Jamaica - east of 78 deg West.',17.65,18.6,-78.0,-76.1,'','','',NULL,'','OGP','OGP','2007-01-19','',0),
(3480,'World - N of 45 deg N','Northern hemisphere - north of 45 deg North.',45.0,90.0,-180.0,180.0,'','','',NULL,'','OGP','OGP','2007-01-24','',0)
INSERT INTO EPSG_CHANGE VALUES
(94.0100021362305,'1994-10-13','1994-10-17','Larry Flournoy;  Anadrill','Name and parameters for Gulf of Mexico UTM feet zones.','Proj','','Consulted MMS (Drew); Chevron; Shell; JECA; confirmed existing data (P0121-P0124) acceptable.','None.'),
(95.0100021362305,'1995-01-03','1995-01-30','John Bobbitt; POSC','Clarke 1880 (Arc) name.','','','Not found.  Revert to reporter.','None.'),
(95.0199966430664,'1995-01-03','1995-01-30','John Bobbitt; POSC','Modified American Foot conversion factor incosistency.','Ellips  Proj','E009  P0242-0244','Value = 12 * 1.0000382 / 39.37 = 0.30481225... as given in linear unit table.  ','E009; P0242-0244 updated.'),
(95.0299987792969,'1995-01-03','1995-01-30','John Bobbitt; POSC','Abbreviation for grad.','','','Suggestion implemented.','Updates throughout most files.'),
(95.0400009155273,'1995-01-03','1995-06-02','John Bobbitt; POSC','Gauss-Kruger projection method to be TM.','','','In consultancy brief.','TM adopted for version 2.'),
(95.0500030517578,'1995-01-04','1995-01-30','John Bobbitt; POSC','Spelling of Lisbon.','GDatum  GeogCS','G228-229  C0080','Reviewed at 27-Jan-95 wg meeting. Lisboa to be replaced by Lisbon.','G228-229; C0080 amended.'),
(95.0599975585938,'1995-01-11','1995-01-30','John Bobbitt; POSC','Error in Swiss projection longitude of origin.','Proj','P0531','Reviewed at 27-Jan-95 wg meeting.','P0531 longitude of origin value amended .'),
(95.0699996948242,'1995-01-11','1995-01-30','John Bobbitt; POSC','Difficulty in POSC model coping with apostrophies.','GeogCS','G162','Reviewed at 27-Jan-95 wg meeting. Apostrophe dropped from M''poroloko but not Cote d''Ivoire as this is ISO spelling.','G162 amended.'),
(95.0810012817383,'1995-01-27','1995-01-30','EPSG wg.','Adopt ISO country names.','GeogCS  ProjCS','C0018-19; C0081-82; C0091-0336; C0356-57; G117-8; G130; G176; G178; G187-189; G203; G215; G226-227; P0121-0377; P0466; P0523-4 and P0531-2 amended.','Agreed.','C0018-19; C0081-82; C0091-0336; C0356-57; G117-8; G130; G176; G178; G187-189; G203; G215; G226-227; P0121-0377; P0466; P0523-4 and P0531-2 amended.'),
(95.0820007324219,'1995-01-27','1995-01-30','EPSG wg.','Add revised France zones.','Proj','P0443-6','Agreed.','P0443-6 amended; P0536-9 added.'),
(95.0830001831055,'1995-01-27','1995-01-30','EPSG wg.','Add Morocco zones.','ProjCS','','','P0460-0461 added. P0462 not accepted.'),
(95.0899963378906,'1995-04-25','1995-04-28','Mike Ruth; SPOT','Modify Paris PM value to 2.596921296.','PMerid','','Additional precision not required.','None'),
(95.0999984741211,'1995-04-25','1995-04-28','Mike Ruth; SPOT','Add sphere; Add NATO Digest ellipsoids (Delambre; Fischer; Hough; Walbeck; WGS60 and WGS66).','Ellips','','Adding sphere agreed (authalic to be included).  Obsolete and scientific ellipsoids not agreed.  (WGS60 and WGS66 are geodetic datums not ellipsoids).','E035 added.'),
(95.120002746582,'1995-05-05','1995-05-10','John Bobbitt; POSC','Hidden spaces in text.','ProjCS','','No error found - data translator assumed the cause of problem.','Reporter advised.'),
(95.129997253418,'1995-05-05','1995-05-10','John Bobbitt; POSC','Ain el Abd datum name not consistently represented in CS names.','GeogCS  ProjCS','G105   C0026','Should be Ain el Abd 1970.','G105 and C0026 amended from "Ain el Abd 70" to "Ain el Abd 1970"'),
(95.1399993896484,'1995-05-05','1995-05-10','John Bobbitt; POSC','POSC model coping with apostrophies.','GeogCS','G162','Reverses change 95/7.','M''poroloko  reinstated.'),
(95.1500015258789,'1995-05-05','1995-05-10','John Bobbitt; POSC','South Carolina zones: NAD27 duplicated and NAD83 missing.','ProjCS','C0262','Error agreed.  Name is in error; component data OK.','C0262 name amended.'),
(95.1600036621094,'1995-05-09','1995-05-10','John Bobbitt; POSC','California zone names.','Proj','','Agreed.  Note that SP27 zones use roman numerals whilst SP83 use Arabic.','P**** name amended.'),
(95.1699981689453,'1995-05-18','1995-05-30','John Bobbitt; POSC','Make projCS units variable.','Proj','','Data model problem.','Reporter advised.'),
(95.1800003051758,'1995-07-20','1995-07-20','John Bobbitt; POSC','Missouri East & New York east SP projection longitude of origin error.','Proj','12401  13101','Agreed.','Longitude of natural origin hemisphere changed from E to W.'),
(95.1910018920898,'1995-07-21','1995-07-21','Melita Kennedy; ESRI','Hemisphere in area of use descriptions should all be W.','ProjCS','20822  20823  20824','Agreed.','Area of use longitude hemisphere changed from E to W.'),
(95.1920013427734,'1995-07-21','1995-07-21','Melita Kennedy; ESRI','Error in area of use description West Malaysia west of 102 deg E','ProjCS','24548','Agreed.','Area of use description changed from "...east of 102 deg E" to "... west of...".'),
(95.193000793457,'1995-07-21','1995-07-21','Melita Kennedy; ESRI','Hemisphere in area of use descriptions should all be E.','ProjCS','23846  23847  23848  23849  23850  23851  23852  23853  23886  23887  23888  23889  23890  23891  23892  23893  23894','Agreed.','Area of use longitude hemisphere changed from W to E.'),
(95.1999969482422,'1995-07-25','1995-07-25','Niles Ritter; JPL','Area of use mis-spelling eest.','ProjCS','23846  23886','Error introduced in amendment 95/19.3','Area of use description changed to "... and west of 96 deg E".'),
(95.2109985351563,'1995-07-25','1995-08-08','Joe Schwartz; Mapinfo','Add datum transformation parameters for each datum to WGS 84.','','','Not a trivial problem.  To be addressed in a later revision.','None at this time.'),
(95.2119979858398,'1995-07-25','1995-08-08','Joe Schwartz; Mapinfo','Add test data for each projected coordinate system.','ProjCS','','Examples are given in POSC transformation method documentation.','None'),
(95.2200012207031,'1995-08-08','1995-08-08','John Bobbitt; POSC','I have a publication that lists a "Louisiana Offshore" for use with NAD27.  Your tables don''t have this zone.  Does the area of use of Louisiana South include the offshore GOM or not?  Or does it include it on NAD27, but not NAD83?','Proj','','To the best of our knowledge Louisiana Offshore zones, both for NAD27 and NAD83 are not used.  The Louisiana South zone (NAD 27) is used offshore Louisiana. The NAD83/Louisiana South projected coordinate system is used only onshore.','None'),
(95.2300033569336,'1995-08-08','1995-08-08','John Bobbitt; POSC','For NAD27, the description for Texas South and Texas South Central includes the Gulf of Mexico. For NAD83 it does not. Is this correct?','Proj','14204  14205  14234  14235','Systems in use on the Texas shelf are NAD27/Texas South and NAD27/Texas South Central. MMS propose that NAD83/UTM zone 14/15 should replace these.  NAD83/Texas South and NAD83/Texas South Central are used onshore only.','None'),
(95.2399978637695,'1995-08-08','1995-08-08','John Bobbitt; POSC','Should Geographic CS 4270:Nahrwan 1967, have an area of use of "Persian Gulf" not "Arabian Gulf"?','GeogCS','4270','. Historically named the Persian Gulf,  with the rise of Arab nationalism, this became unacceptable on the west/south side of the Gulf and there the term Arabian Gulf has been used.','None'),
(95.25,'1995-08-08','1995-08-22','John Bobbitt; POSC','Arizona & Michigan coordinate system projection zone names inconsistent with names in projection table.','ProjCS','26748  26749  26750  26801  26802  26803','Agreed.','Amend projection zone names given in CS table to correspond to those in projection table.'),
(95.2600021362305,'1995-08-08','1995-08-22','John Bobbitt; POSC','Discrepancies in names between the projected coordinate system\ufffd\ufffd\ufffdfile and the projection parameters file in the name of the\ufffd\ufffd\ufffdprojection zone.','Proj  ProjCS','18081  18082  18083  18084  18091  18092  18093  18094  27581  27582  27583  27591  27592  27593','The names given in the projection parameter file are preferred.  However, investigation of this request has brought to light a transposition of and old code reference in the Remarks of all four (including Corsica) old and new Lambert France zones.','Remarks amended for projections 18081-18084 and 18091-18094.  For ProjCS 27591-27593 inclusive, amend projection zone to be consistent with proj file, and delete the map projection zone abbreviation. For ProjCS 27581-27583 and 27591-27593, add remarks.'),
(95.2699966430664,'1995-08-15','1995-08-22','John Bobbitt; POSC','BLM zone area of use','Proj  ProjCS','15916  26776','Agreed.','Amend area of use from "... 90d to 96d W" to "... 90d to 84d W".'),
(95.2799987792969,'1995-11-21','1995-12-02','Eric Pohl; Erdas','Angle unit code/value inconsistencies','Proj','16001-16060  16101-16160  16204-16232  16304-16332  18112-18117  19009  19910  19915  19917  19921','Agreed.','Amend angle unit code from 9101 to 9102.'),
(95.2900009155273,'1995-11-23','1995-12-08','Alan Haugh; Hydrosearch','STM FE value','Proj','','Value of zero for the South Africa CS zones (Lo15-Lo33) confirmed as correct by Russel Fox; OSGB librarian.','ProjCS v2.1.4'),
(95.3000030517578,'1995-12-02','1995-12-02','EPSG (Lott)','Angle unit code/value inconsistencies','Proj','10101-15917 except 15001 and 15031;  \ufffd\ufffd\ufffd17348-58  17448-58  17513-35  18031-7  18041-3  18051-4  18061-2  18072-4  18101-5  18110-1  18121-2  18141-2  18151-3  18161-3  18171-5  19900-2  19904-8  19913-4  19916  19918-20  19922-5','','Amend angle unit code from 9107 to 9108 and angle unit name from DMS to DMSH'),
(96.0100021362305,'1996-01-27','1996-01-27','Roger Lott; BP','Correct India zone 0 projection parameters','Proj','18110','','Correct values of parameters latitude of natural origin; scale factor at natural origin; false easting and false northing.'),
(96.0199966430664,'1996-01-27','1996-01-27','Roger Lott; BP','Amend area of use for India zones.','Proj','18110  18111  18112  18113  18114  18115  18116  18117','','Amend area of use description.'),
(96.0299987792969,'1996-04-12','1996-04-12','Roger Lott; BP','Duplication of codes.','ProjCS','26774  26775  26776  26777','','Amend ProjCS codes for NAD27 / BLM (feet) zones from 26774-26777 to 32074-32077.  Codes 26774-26777 remain applicable for Indiana West; Iowa North and South and Kansas North NAD27 SP zones.'),
(96.0400009155273,'1996-04-10','1996-10-18','Jim Cain; Western Geophysical','Use relational db for distribution.','All','','Relationships will be made available in version 3.','Make MS-Access db available from v3.'),
(96.0500030517578,'1996-04-10','2001-11-06','Jim Cain; Western Geophysical','Relate area of use to structured area table','All relevant tables','','','See change record 2000.51.'),
(96.0599975585938,'1996-04-10','1996-10-18','Jim Cain; Western Geophysical','Add revision history field.','All','','Change table to be part of db release from v3.','None'),
(96.0699996948242,'1996-04-10','1996-04-12','Jim Cain; Western Geophysical','Issue ProjCS in single unit only.','ProjCS','','Not agreed.  Policy is to tabulate original values as far as this is possible.','None'),
(96.0800018310547,'1996-04-10','1996-10-18','Jim Cain; Western Geophysical','Make unspecified geodetic datum and geogCS names unique ','G_datum\ufffd\ufffd\ufffdGeogCS','6001-6035  4001-4035','','Changed name for geodetic datums 6001-6035 and geogCS 4001-4035.'),
(96.0899963378906,'1996-04-10','1996-10-18','Jim Cain; Western Geophysical','Change name of International 1967 ellipsoid to GRS67','Ellips\ufffd\ufffd\ufffdG_datum','7023  7036  6023  6036  6237  6291','GPS 1967 is preferred terminology.','International 1967 ellipsoid (7023) made an alias of GRS67 (newly created 7036). Datum 6023 and GeogCS 4023 deleted and replaced by 6036 and 4036 respectively.'),
(96.0999984741211,'1996-04-14','1996-04-12','Jim Cain; Western Geophysical','Add Swedish data','GeogCS\ufffd\ufffd\ufffdProj  \ufffd\ufffd\ufffdProjCS','4308','','Augmented geogCS 4308 with 4814; added proj 19929 and projCS 30800'),
(96.1100006103516,'1996-04-10','1996-04-12','Jim Cain; Western Geophysical','Add Clarke 1866 ellipsoid in US Survey Feet','Ellips','','Not agreed.  The figure is used in metric form outside of US and will only be stored once.  Conversion to required units is an applications issue.','None'),
(96.120002746582,'1996-04-02','1996-04-12','Roger Lott; BP','Add Kuwait data','G_datum  GeogCS  \ufffd\ufffd\ufffdProj  \ufffd\ufffd\ufffdProjCS','27038  27039','','Add geodetic datum 6318 and 6319; geogCS 4318 and 4319; proj 19928; projCS 24600  31838  31839 and 31900.  Amend area of use for 27038 and 27039.'),
(96.129997253418,'1996-04-02','1996-04-12','John Harries; Amoco','Add Romania data','G_datum  \ufffd\ufffd\ufffdGeogCS  \ufffd\ufffd\ufffdProj  \ufffd\ufffd\ufffdProjCS','','','Add geodetic datum 6316 and 6317; geogCS 4316 and 4317; proj 19926 and 19927; projCS 31600 and 31700.'),
(96.1389999389648,'1996-06-02','1996-06-02','EPSG','Version 2.1 release','','','',''),
(96.1399993896484,'1996-04-02','1996-09-12','Christian Ameil; Elf','Add French and Swiss data','V_datum  \ufffd\ufffd\ufffdVertCS','','Agreed','V_datum 5107 and 5108 and VertCS 5707 and 5708 added.'),
(96.1500015258789,'1996-07-08','1996-07-17','Raphael Mankin; Coversoft','Proj codes use 9101/degrees where according to units table they ought to say 9102/degrees','Proj','19915; 16001-16160; 16204-16332; 18112-18117','Corrected under 95/28.','None'),
(96.1600036621094,'1996-07-18','1996-11-11','Paul Jensen; Agile Data Movers','Inconsistencies when redundant data (names and codes) in tables','Ellips  Proj  ProjCS','','Relationships will be made available in version 3.','None'),
(96.1699981689453,'1996-07-18','1996-11-11','Paul Jensen; Agile Data Movers','No tables for geodetic datum or transformation method','GeogCS','','Full tables and relationships will be made available in version 3.','None'),
(96.1800003051758,'1996-10-03','1996-10-18','Stephan Nebiker;  Swiss Federal Institute of Technology','Duplicate codes','ProjCS','26774  26775  26776 26777','Corrected under 96/03.  ','None'),
(96.1900024414063,'1996-10-03','1996-10-18','Stephan Nebiker;  Swiss Federal Institute of Technology','Angle units without names','AngUnit','9107  9108','','Entries in abbreviation field transferred to name field.'),
(96.1999969482422,'1996-10-18','1996-10-18','EPSG','Information source for Everest 1830 (1937 Adjustment)','Ellips','7015','','Information source commen added'),
(96.2099990844727,'1996-10-18','1996-10-18','EPSG','Add ellipsoid aliases','Ellipsoid_alias','','','7037  7038  7039  7040  and 7041added.'),
(96.2200012207031,'1996-07-18','1996-10-18','Paul Jensen; Agile Data Movers','Increase precision of angle units','Angle_unit','9102  9103  9104  9105  9106','Precision in units tables factors a through d is appropriate and adequate for most cartographic purposes.','Precision of pi increased'),
(96.2300033569336,'1996-09-12','1996-10-18','EPSG','Add new units to support  data in other tables','Angle_unit\ufffd\ufffd\ufffdScale_unit','','New entries microradian; sexagesimal degree; ppm','Added 9109  9110  9201  and 9202\ufffd\ufffd\ufffd'),
(96.2399978637695,'1996-09-12','1996-10-18','EPSG','Add nautical mile','Linear_unit Linear_unit_alias','9015','nautical mile preferred as primary name.','Add 7030 to linear unit table; move 7015 to linear unit alias table as alias of 7030. '),
(96.25,'1996-10-18','1996-10-18','EPSG','Correct ellipsoid for Cape datum','G_datum','6222','','Changed related ellipsoid from 7012 to 7013'),
(96.2600021362305,'1996-09-12','1996-10-18','Roger Lott; BP','Add Russian CS95','G_datum\ufffd\ufffd\ufffdGeogCS\ufffd\ufffd\ufffdProjCS','','','Add geodetic datum 6200; geogCS 4200; projCS 20004-20032 and 20064-20092.'),
(96.2699966430664,'1996-11-12','1997-11-13','Jean-Patrick Girbig; Petroconsultants','Add  Australian data','Trf_nonpoly  Trf_path  Geod_trf','','','Added non-polynomial transformations 8589-8594 and geodetic transformations 8189-8594.'),
(96.2799987792969,'1996-12-12','1996-12-12','Stephan Nebiker;  Swiss Federal Institute of Technology','Correct linear unit for Michigan SP CS27 zones','Proj   ProjCS','12111  12112  12113  26788  26789  26790','Correct values confirmed by Dave Doyle, USC&GS.  All NAD27 Michigan SP27 zones referred to Clarke 1866 Michigan ellipsoid in modified American feet.','Length unit changed to 9004 for proj 12111-12113;  26788-26790 deleted and replaced by 26811-26813 respectively. GeogCS 4268 renamed.'),
(96.2900009155273,'1996-12-12','1996-12-12','EPSG','Change angles in dms(h) text to sexagesimal degree to be more easily machine readable.','Proj  Pmerid','Multiple','','Entries with code 9107 changed to 9102 or 9110'),
(96.3000030517578,'1996-12-12','1996-12-12','EPSG','Version 3.0 release','','','',''),
(97.0100021362305,'1997-03-07','1997-04-11','Melita Kennedy; ESRI','Change Austrian longitude of origin values','Trf_nonpoly','18041  18042  18043','ProjCS 31291-3 unchanged.','Parameter 2 values changed to be relative to Ferro and prime meridian codes changed.'),
(97.0199966430664,'1997-03-07','1997-04-11','Melita Kennedy; ESRI','Correct spelling of Gibraltar','Trf_nonpoly','1133','','Gibralter corrected to Gibraltar'),
(97.0299987792969,'1997-03-07','1997-04-11','Melita Kennedy; ESRI','Area of use inconsistent for components of geodetic transformation 8047','Trf_nonpoly  Geod_trf','1147  1146  8047','1147  and 8047 unchanged.','Area of use for Norway amended and additional reference added in code 1146.'),
(97.0400009155273,'1997-03-07','1997-04-11','Melita Kennedy; ESRI','Correct angle unit codes','Trf_nonpoly','1146  1147','','Angle unit codes changed from 9101 to 9109.'),
(97.0500030517578,'1997-03-07','1997-04-11','Melita Kennedy; ESRI','Add several longitude rotations','Trf_nonpoly  Trf_path  Geod_trf','1194  8094','These are 2-step transformations requiring first a longitude rotation to equivalent Greenwich-based CS and then a geocentric transformation.','Change transformation 1194 from "NTF (Paris) to WGS 84" to "NTF (Paris) to NTF";  change trf_ path 8494/1 target from 4326 to 4275, add trf_path 8494/2.  Add new entries 1257-1269; 8560-8578; 8160-8178.'),
(97.0599975585938,'1997-03-07','1997-04-11','Melita Kennedy; ESRI','Add several geodetic transformations','Trf_nonpoly  Trf_path  Geod_trf','1110  1153  1176  1188  1230  1232  1245-1256  8548-8559  8148-8159','Updates found to be required for 1110  1153  1176  1188  1230  1232.','Parameters amended for 1110 and 1153, area of use amended for 1153 1176 1188 1230 and 1232.  New transformations 8148-8159, paths 8548-8559  and parameters 1245-1256 added.'),
(97.0699996948242,'1997-03-18','1997-04-11','Melita Kennedy; ESRI','Check Amersfoort to WGS 84 geodetic transformation values','Trf_nonpoly','1112','All signs reversed.','Parameter values for 1112 amended.'),
(97.0800018310547,'1997-04-01','1997-04-11','Claude Williamson, LGC','Check projection transformation parameter values FE and FN','Trf_nonpoly','15001  15031','15031 is OK.  15001 values in metres should be in US survey feet.','Amend 15001 FE and FN values.'),
(97.0899963378906,'1997-04-11','1997-04-11','EPSG','Duplication of Swedish GeogCS','Horiz_CS  Geod_datum','4490  4308  6290','HorizCS name change will adversely affect any application that uses both Code_HorizCS and  HorzCS_name_EPSG as a dual key.','4290 and 6290 deleted.  4308 name changed.'),
(97.0999984741211,'1997-04-11','1997-04-11','EPSG','NAD27 geodetic datum code should be GeogCS code','Trf_path','8547','','Erroneous source CS code changed from 6267 to 4267'),
(97.1100006103516,'1997-04-11','1997-04-11','EPSG','Colombia projection zones should be related to Greenwich','Trf_nonpoly  Horiz_CS','21891-4  18051-4','HorizCS name change will adversely affect any application that uses both Code_HorizCS and  HorzCS_name_EPSG as a dual key.','Changed HorizCS name in 21891-4, changed parameter 2 value and prime meridian code in 18051-4'),
(97.120002746582,'1997-04-11','1997-04-11','EPSG','Portuguese CS name muddles two datums','Horiz_CS','4803','Datum 73 is a different CS from the older Lisbon CS','Changed HorizCS name from Lisbon 73 (Lisbon) to Lisbon (Lisbon).'),
(97.129997253418,'1997-04-11','1997-04-11','EPSG','Belge 1950 / Belge Lambert 50 ProjCS longitude of origin incorrect','Horiz_CS','21500','Longitude of origin for tranformation 19901 is correct as zero based on Brussels meridian','Amended source GeogCS from 4215 to 4809; changed HorizCS name from Belge 1950 / Belge Lambert 50 to Belge 1950 (Brussels) / Belge Lambert 50'),
(97.1399993896484,'1997-04-11','1997-04-11','EPSG','Amend name of ProjCS','Horiz_CS','30800','Longitude of origin for transformation 19929 is based on Stockholm meridian','Changed HorizCS name from RT38 / Swedish National Grid to RT38 (Stockholm) / Swedish National Grid.'),
(97.1490020751953,'1997-04-11','1997-04-11','EPSG','Version 3.1 release','','','',''),
(97.1500015258789,'1997-04-16','1997-07-22','Leon Portokalakis; Public Petroleum Corporation of Greece','Add Greek coordinate systems','Geod_datum  PMeridian  Horiz_CS  Vert_datum  Vert_CS Trf_nonpoly  Trf_path  Geod_trf','1270  2100  4120  4815  5115  5716  6120  6121  8179  8579  8912  19930','Geodetic transformation to be added when sense of parameters clarified.','Added geodetic datums 6120 and 6121; prime meridian 8912; geogCS 4120  4121 and 4815; proj 19930; projCS 2020; vertical datum 5115; vertical CS 5716; trf_nonpoly 1270 1272; trf_path 8570 8581; geod_trf 8179 8181.'),
(97.1600036621094,'1997-04-16','1997-06-16','EPSG','Correct Namibian ProjCS; add transformation to WGS84','Ellipsoid  Trf_nonpoly  Horiz_CS  UOM_length  Trf_path  Geod_trf','1271  7006  8180  8580  9031 17611-17625 (odd numbers);  29371-29385 (odd numbers)','','Add new linear unit 9031 German legal metre (GLM).  Add remark to ellipsoid 7006 regarding  GLM.  Amend proj and projCS linear units from metre to German legal metre.  Add new trf_nonpoly 1271; trf_path 8580; geod_trf 8180.'),
(97.1699981689453,'1997-06-04','1997-06-16','John Bobbitt; POSC','Clarify transformation methods','','','POSC documentation needs updating.  No change to db.','Notified reporter.'),
(97.1800003051758,'1997-06-04','1997-06-16','John Bobbitt; POSC','Correct Universal Polar Stereographic parameters','Trf_nonpoly','16061  16161','Values for latitude and longitude of natural origin transposed','Amend values for parameter_1 and parameter_2'),
(97.1910018920898,'1997-06-04','1997-06-16','John Bobbitt; POSC','Correct Michigan SP CS27 zones linear units','Horiz_CS','26811-3','Incorrect implementation of change 96.28','Correct linear unit from 9003 to 9004.'),
(97.1920013427734,'1997-06-06','1997-06-16','EPSG','Correct Michigan SP CS27 zones axes names','Horiz_CS','26801-3','Incorrect implementation of change 96.28','Amend remarks.  Also change axes abbreviations from EN to XY.'),
(97.1999969482422,'1997-06-06','2000-03-07','Dominic Sexton','Compress Access database','','','','Do so for all future releases.'),
(97.2099990844727,'1997-06-10','1997-06-16','Melita Kennedy; ESRI','Add missing geodetic transformations','Geod_trf','8148-8151','','8148 through 8151 added.'),
(97.2200012207031,'1997-06-11','1997-06-16','Melita Kennedy; ESRI','Clarify Swedish geodetic datum name','Geod_datum','6308','No change needed to db.','Notified reporter.'),
(97.231,'1997-06-09','1999-10-20','Patrick Wheeler-Hoolahan;  Exploration Geodesy Inc.','Indian foot','UOM_length  UOM_length_alias  Ellipsoid  Geod_datum  HorizCS','9006  9013  7017  6243  4243','Length unit 9006 replaced by 9080 (effectively 9006 has been renamed).  Ellipsoid 7017 replaced by 7044 and 7045.  Geod datum 6243 and GeogCS 4243 renamed.  See also change request 99.91.','Delete length units 9006  9013; add 9080-7.  Add length alias 9088-90. Delete ellipsoid 7017; add 7044-5.  Rename geod_datum 6243; add 6144-6. Rename GeogCS 4243; add 4144-6;  (cont...)'),
(97.232,'1997-06-09','1999-10-20','Patrick Wheeler-Hoolahan;  Exploration Geodesy Inc.','97.231 Indian foot (continued)','Trf_nonpoly  HorizCS  Tfm_path  Geod_tfm','18110-18117 and  24370-74 & 24382','','(...cont). Change units of proj 18110-18117 and projCS 24370-74 & 24382.  Rename projCS 24370-74 & 24382. Add proj 18231-38.  Add projCS 24305-6  24311-13  24342-47  24375-81  24383.  Rename projCS 24370-4 & 24382.  Add remarks. (cont 97.235 ...)'),
(97.233,'1999-10-20','1999-10-20','EPSG','Rationalise British linear units','UOM_Length   Length Alias  Trf_nonpoly  HorizCS','9007-12  9032  18141-2 19912 19924-5 19935  24571 27291-2 29871-2 30200','Length units 9007-9012 and 9032 replaced by 9039 9063 9043 9062 9042 9040 and 9041 respectively (effectively these have been renamed).','Delete length units 9007-12  9032; add 9037-43 9050-3 9060-3 9070.  Add length alias 9044 9055-8 9064-5 9071.  Change unit code for proj 18141-2 19912 19924-5 19935 and projCS 24571 27291-2 29871-2 30200 to reflect the unit changes. (Cont...)'),
(97.234,'1999-10-20','1999-10-20','EPSG','97.233  Rationalise British linear units (cont).','UOM_Length','9005','Clarke presented his results as 1m = 39.370432 inces whence 1ft=0.30479726511...  However has usually been implemented as 0.304797265 exactly.','(...cont). Change factors b and c from 12 and 39.370432 to 0.304797265 and 1 respectively.'),
(97.235,'1997-06-09','1999-10-20','Patrick Wheeler-Hoolahan;  Exploration Geodesy Inc.','97.231 Indian foot (continued)','Trf_nonpoly Tfm_path  Geod_tfm','1155 1156 1247; 8455 8456 8550; 8055 8056 8150','','(...cont). Rename tfm_nonpoly 1155 1156 1247 and geod_tfm 8055 8056 8150 from Kalianpur to WGS 84 to Kalianpur yyyy to WGS 84, where yyyy is adoption year; change source cs in geod_trf 8055 8056 8150 and trf_path 8455 8456 8550 to be consistent.'),
(97.2399978637695,'1997-06-19','1997-06-19','John Bobbitt; POSC','Correct name of ETRS89 transformation to WGS84','Geod_trf  Trf_nonpoly','8049  1149','','Amend name of transformation to reflect geodetic datum and coordinate system terminology.'),
(97.2509994506836,'1997-06-30','1997-07-22','Chris Pryce; Shell','Hungarian EOV projection','Trf_nonpoly  Horiz_CS  Trf_method','','Algorithm under investigation','Add trf_method 9815; proj 19931; projCS 23700; trf_nonpoly 1273; trf_path 8582 8583; geod_trf 8182 8183.'),
(97.2519989013672,'1997-07-22','1997-07-22','EPSG','Greater precision to GRS67 1/f','Ellipsoid  Geod_datum','7036  6291  4291  29121-29185','IAG gives value to 9 dp.  Until change request 97.25 the only datum utilising the ellipsoid tok the figure to 2 dp.','Amended 1/f in 7036 from 298.25 to 298.24717.  Remarks added to 4291 6291 and 29121-29185.'),
(97.2600021362305,'1997-06-13','1997-06-19','John Bobbitt; POSC','Ellipsoidal heights','Vert_CS  Vert_datum','5001-5036  5601-5636','Ellipsoidal heights without datum are meaningless.','Ellipsoidal heights based on unspecified datum deleted.'),
(97.2699966430664,'1997-06-30','1997-06-30','EPSG','Swiss grid axes directions','Trf_nonpoly  Horiz_CS','19922  21790  30600','Reference "Die Projektionen der schweizerischen Plan- und Kartenwerke"; J. Bolliger 1967','Change east axis name from X to Y and north name axis from Y to X in 21790 and 30600.  In 19922 change parameter 6 from 200000 to 600000 and change parameter 7 from 600000 to 200000.'),
(97.2799987792969,'1997-06-30','1997-07-22','Simon-Pierre Cadieux; Formatek','Add New Brunswick CS','','','','Added geodetic datum 6122; geogCS 4122; proj 19932; projCS 2200 2219 2220.'),
(97.2900009155273,'1997-07-07','1997-07-14','Andrew Ruffhead; UK Military Survey','Correct formula for geocentric to geodetic transformation','Trf_method','9602','','Correct sign in numerator from - to + in formula for latitude from geocentric coordinates.'),
(97.3000030517578,'1997-07-08','1997-07-22','Mike Ruth; SPOT','Add Finnish CS','','','','Added geodetic datum 6123; geogCS 4123; proj 18191-18194; projCS 2391-2394; vertical datum 5116; vertical CS 5717.'),
(97.3099975585938,'1997-07-22','1997-07-22','EPSG','Add projected CS for ETRS89','Horiz_CS','','','Added ProjCS 25828-25838'),
(97.3199996948242,'1997-07-22','1997-07-22','EPSG','Amend RSO Borneo','Horiz_CS  UOM_length','29800','Extended entries to include grid units other than chains.  Sears foot-metre ratio used.','Deleted ProjCS 29800 and replace by new 29871 (minor change to name and abbreviation).  Added UOM_length 9032; additional ProjCS 29872 and 29873.'),
(97.3300018310547,'1997-08-28','1997-08-18','EPSG','Version 3.2 release','','','',''),
(97.3399963378906,'1997-08-29','1997-11-13','John Bobbitt; POSC','Projected CS for Arc1950','HorizCS','','','Added 20934-20936; also for Arc 1960 added 21035-21037 and 21095-21097.'),
(97.3499984741211,'1997-08-29','1997-11-13','John Bobbitt; POSC','Geodetic transformation naming','Geod_trf  Trf_nonpoly  Trf_poly','','Discussed at 13/11/97 meeting. If the geodetic transformation labelling were made more intuitive the sequential naming of non-polynomial transformations could not be maintained.','None.'),
(97.3600006103516,'1997-10-02','1998-11-11','Simon-Pierre Cadieux; Formatek','Canadian NT transformation method','Trf_method  Geod_trf  Trf_path  Trf_nonpoly','','Operates between CS with positive west longitude. To be discussed at April 98 meeting.','Added transformation methods 9614-9615; non-polynomial transformations 1312-1313; tfm_path 8642-8445; geodetic transformations 8242-8245.'),
(97.371,'1997-10-02','1997-11-13','Simon-Pierre Cadieux; Formatek','Geodetic transformations for France','Geod_trf  Trf_path  Trf_nonpoly','','Requested changes to ED79 not added.  ED79 is a temporary scientific adjustment superceded by ED87.','Added non-polynomial transformations 8584-8588 and geodetic transformations 8184-8188.'),
(97.372,'1997-11-13','1997-11-13','EPSG','Correct NGF','VertCS  Vert_datum','5707  5107','The CNIG states that NGF is a general term applying to all vertical network readjustments of France and recommends more specific terminology.','Delete VertCS 5707 and Vert_datum 5107; replace by 5719-5721 and 5118-5120.'),
(97.379997253418,'1997-10-02','1997-11-13','Simon-Pierre Cadieux; Formatek','MTM for Canada','HorizCS  Trf_nonpoly','','','Added 17700-17717; 17794-17795; 19933; 2290; 2294-2295; 32080-32097 and 32180-32197.'),
(97.3899993896484,'1997-10-03','1997-11-13','Lars Nilsson; Satellitbild','Swedish CS and transformations','HorizCS  Trf_nonpoly','4308  4814  19929  30800','','Changed longitude of natural origin value and prime meridian in 19929 from Stockholm to Greenwich; changed projCS 30800 to be based on GeogCS 4308 instead of 4814 and amended name to reflect local practice.'),
(97.4000015258789,'1997-10-03','1997-11-13','Lars Nilsson; Satellitbild','Add Swedish CS and transformations','Geod_datum  HorizCS  Vert_datum  VertCS   Geod_trf  Trf_path  Trf_nonpoly','','Because the EPSG tables do not include listings of geographic 3D coordinate systems it has not been possible to add RR92 or the geodetic transformation between RR92 and ETRS89.','Added geodetic datum 6124; horizCS 4124 and 2400; trf_nonpolynomial 1281 and geodetic transformation 8195.'),
(97.4100036621094,'1996-11-13','1997-11-13','Bruno Ravanas; Total','Add Indonesia Kalimantan Samboja datum','Geod_datum  HorizCS   Geod_trf  Trf_path  Trf_nonpoly','','','Added geodetic datum 6125; horizCS 4125 and 2550; trf_nonpolynomial 1282 and geodetic transformation 8196.'),
(97.42,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Change code rounding in csv files','Change','','EPSG uses real numbers for change records.  These are not stored precisely in Access.  Display using 3 decimal places.','None.'),
(97.43,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Standardise areas of use','Area  HorizCS  VertCS  CompoundCS  Trf_nonpoly  Trf_poly','','The long-term intention is to link areas of use to ISO country codes and subdivisions thereof.','No action for country subdivision descriptions.  Abbreviations for grads eliminated.'),
(97.44,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Correct area of use description','HorizCS','24891','','Change area of use description from "Peru east of 73 deg West" to "Peru west of 79 deg West"'),
(97.45,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Correct spelling','HorizCS','28404  28464','','Change part of area of use description from "Estona" to "Estonia"'),
(97.46,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Correct spelling','HorizCS','24821','','Change part of area of use description from "Surinam" to "Suriname"'),
(97.47,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Correct EPSG name','Trf_nonpoly  Geod_trf','1273  8182','','Change EPSG name from "HD72 to ERTS89 (1)" to "HD72 to ETRS89 (1)"'),
(97.48,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Check Schwarzeck to WGS84 transformations','Trf_nonpoly','1226  1271','No change made to non-polynomial transformation 1226.','In non-polynomial transformation 1271 parameter 3 (dZ) changed from 255.81 to -255.81 metres.  Note added to remarks re units.'),
(97.49,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Amplify area of use description','Trf_nonpoly  HorizCS','12601  12602  13901  13902  26705  26706  26731  26733','','Extend area of use description to sub-state level.'),
(97.5,'1997-10-11','1997-11-13','Melita Kennedy; ESRI','Correct abbreviation in area of use description','Trf_nonpoly  HorizCS','14801  14802  14831  14832  26752  32152  32153','','Correct abbreviation for minute of arc from "mm" to "m".'),
(97.52,'1997-10-23','1997-11-13','EPSG','Add vertical offset to transformation table','Trf_method','','','Added transformation method 9616; added transformation method field to V_offsets query.'),
(97.53,'1997-10-23','1998-04-16','EPSG','Correct font problems in formulae','Trf_method','','The formulae are available as a Word v7 document which includes symbol font.  Access v2 does not allow multiple fonts in one field.  The fomulae have been modified with symbols changed to letters.','Link web readme file to downloadable Word document.'),
(97.54,'1997-10-23','1997-11-13','EPSG','Add compound CS table','CompndCS','','','New table CMPD_CS added; COMPOUND query in v3 renamed CMPD_TRF in v4; new query CMPD_CS added.'),
(97.55,'1997-10-23','1997-11-13','Andrew Ruffhead; UK Military Survey','Correct the ellipsoid for ETRS89 datum','Geod_datum','6258','Because the two ellipsoids are nearly identical this change whilst being correct has no practical consequence.','Change ellipsoid reference from 7030 to 7019.'),
(97.56,'1997-11-13','1998-04-16','Roger Lott; BP','Add ISO format for degrees minutes seconds','Angle_unit','','Not adopted because (a) requires values to be held as text string rather than number and (b) not clear whether latitude and longitude can be given in separate fields.','None.'),
(97.57,'1997-11-13','1997-11-13','EPSG','Delete unnecessary abbreviations','Horiz_CS','21891-4','Abbreviations were identical to EPSG name','In 21891 to 21894 retain abbreviations; replace names which were identical text to abbreviation with new name.'),
(97.58,'1997-11-13','1997-11-13','EPSG','Delete unnecessary abbreviations','Horiz_CS','22032  22033','EPSG name is less than 25 characters','Delete unnecessary abbreviations in 22032 and 22033.'),
(97.59,'1997-11-13','1997-11-13','EPSG','Add necessary abbreviations','Horiz_CS','20437-9','EPSG name is greater than 24 characters','Add abbreviation.'),
(97.6,'1997-11-13','1997-11-13','EPSG','Correct hemisphere for longitude of origin','Trf_nonpoly','19932','','Change longitude of origin from 66.3 to -66.3 sexagesimal degrees.'),
(97.611,'1997-11-13','1997-11-13','EPSG','Amend formula reference for Hotine Oblique Mercator','Trf_method','9812','POSC documentation and formula expand USGS formula fo global application.','Formulas and example added.  Information source changed from reference of USGS publication publication 1395 to formulas as modified by EPSG/POSC.'),
(97.612,'1997-11-13','1997-11-13','EPSG','Check Swiss coordinate systems','Trf_nonpoly  HorizCS','19922  19923  21790 21791 31800','Value of origin for trf_non-poly 19922 of 46d 57m 07.89s N 7d 26m 22.335s E given in Bollinger 1967 has not been used by the Swiss mapping agencies who have retained the earlier value of 46d 57m 08.866s N 7d 26m 22.5s E.','HorizCS 31800 (Bern 1938 / Swiss New) deleted; HorizCS 21791  referred to trf 19922 rather from 19923; trf 19922 and 19923 changed from method 9814 to 9815 with parameters 3-5 and remarks added; parameters 1 and 2 for trf 19922 corrected (see comment).'),
(97.613,'1997-11-13','1997-11-13','EPSG','Check Madagascar coordinate systems','Tfm_nonpolynomial','19911','','Changed transformation method from 9813 to 9815; added parameter 4 and remarks.'),
(97.62,'1997-11-12','1999-10-20','Stephan Nebiker; ETH Zurich','Add new Swiss coordinate systems','','6217  4217  21790-91  5108','','Replace g_datum 6217  geogCS 4217  projCS 21790-91 v_datum 5108  vertCS 5708 by 6149  4149  21780-1  5127  5728 respectively.  Add g_datum 6150-1  geogCS 4150-51  proj 19950  projCS 256  v_datum 5128  vertCS 5729  non-poly_tfm 1508-11  geod_tfm 8455-9.'),
(97.63,'1997-12-04','1997-12-08','Nick Hoffman; BHP','Adopt Accessv7','','','There is no backward compatibility between Access versions 2, 7 and 8.  However as both v7 and v8 can import v2 of the EPSG db without problem we intend to retain v2 for the time being.','Replied to requestor'),
(97.64,'1997-12-10','1998-03-12','Hans Kremer; Chevron','Add miscellaneous geodetic datums','','','Insufficient justification provided.','Requestor asked to provide full coordinate system information.'),
(97.65,'1997-12-17','1998-11-11','Simon-Pierre Cadieux; Formatek','Add ISO country code to CS tables','','','Use the Area table to map ISO codes to country.  Reports accept country name input.','None.'),
(98.01,'1998-01-06','1998-03-12','Dalius Radis; HNIT-Baltic geoinfoServisas','Add Lithunian coordinate systems','Geod_datum  HorizCS  Trf_nonpoly  Trf_path  Geod_trf','','','Added geodetic datum 6126; geogCS 4126; projection 19934; projCS 2600; non-polynomial transformations1274 & 1283; geodetic transformations 8197 & 8198.'),
(98.02,'1998-01-08','1998-11-11','Tim Magee; Maersk','Add reporting by country facility','','','','Reports by area for GeogCS  ProjCS  and Geocentric Transformations added.'),
(98.03,'1998-02-14','1998-03-12','Blair Parker; Crazy Mountain Joint Venture','Add Gunter''s chain','UOM_length','','Gunter''s chain is a measuring tool not a unit.','Add length units 9033-9035 US survey chain US survey link and US survey mile'),
(98.04,'1998-02-19','1998-04-16','Alan Haugh; Hydrosearch','Check geodetic transformation for Indian 1975 datum','Tfm_nonpoly','1154','The values for the transformation from DMA TR8350.2 version of 1987 have not been included as it is not clear to which coordinate system these apply.  See also change record 98.05.','Amended source information for non-polynomial transformation 1154.'),
(98.05,'1998-02-27','1998-04-16','Melita Kennedy; ESRI','Add NIMA TR8350.2 revision 3 geodetic datum transformations','Geod_trf  Trf_nonpoly','','','Added  non-polynomial transformations1284-1294 and 1304-1306; geodetic transformations 8199-8211 and 8226-8228.'),
(98.06,'1998-02-27','1998-06-30','Melita Kennedy; ESRI','Add counties to US SPCS area of use','Tfm_nonpoly  HorizCS','','To be considered during mid-98.','Added Area_use 277-406'),
(98.07,'1998-03-11','1998-11-11','Alexandra Garnier; Istar','Add old Spanish systems','Ellipsoid Geod_datum  HorizCS  Trf_nonpoly  Trf_path  Geod_trf','7028','','Added Geod_datum 6903; GeogCS 4903 and ProjCS 300; transformation method 9617; polynomial transformations 1001-1003 and geodetic transfprmations 8238-8241.  Changed ellipsoid semi-major axis from 6378297 given by Strasser to 6378298.3 as used in Spain.'),
(98.08,'1998-03-24','1998-04-01','EPSG','Version 4.0 release','','','',''),
(98.09,'1998-03-30','1998-04-16','Peter Ladstaetter; Siemens-Nixdorf','Use EPSG data in OGC well known text representation','','','','Readme file reworded.'),
(98.101,'1998-04-06','1998-04-16','Chris Pryce; Shell','Add Trinidad datum transformations','Trf_nonpoly  Geod_trf','','','Added  non-polynomial transformations1295-1296; geodetic transformations 8212-8213.'),
(98.102,'1998-04-16','1998-04-16','EPSG','Add Trinidad datum transformations from older edition of DMA TR8350.2','Trf_nonpoly  Geod_trf','1192  8092','EPSG believes that the values for the Naparima to WGS 84 transformation from DMA TR8350.2 versions of 1991-97 contain a blunder.  However we believe that the values from the 1987 edition exclude this blunder.','Added  non-polynomial transformation 1307; geodetic transformation 8229.  Added cautionary note to non-polynomial transformation 1192 and geodetic transformation 8092.'),
(98.11,'1998-04-10','1998-04-16','Melita Kennedy; ESRI','Check Pulkovo 1942 geodetic transformations','Trf_nonpoly','1245  1275  1287-1293','The offset in names of single step geod_trf and their trf_nonpoly names has caused confusion.  To resolve this all non_polt transformation names will adopt their single step geod_trf name. There may be gaps in the sequencing of trf_nonpoly names.','For trf_nonpoly 1245 and 1275 ED50 to WGS 84 (x); x increased by 2.  For 1287-1293 Pulkovo 1942 to WGS 84 (y); y increased by 1.'),
(98.111,'1998-04-14','1998-04-16','Jim Cain; Western Geophysical','Add Kazakstan Caspian geodetic transformation','Trf_nonpoly  Geod_trf','','','Added  non-polynomial transformation 1303; geodetic transformation 8225.'),
(98.12,'1998-04-14','1998-04-16','Simon-Pierre Cadieux; Formatek','Check ellipsoid parameters','Ellipsoid','7011','In version 4.0 ellipsoid table issued with 1/f values having inappropriate precision.  In version 4.1 a precision of 5 decimal places, as v3.2, re-instated.','Change 7011 second parameter from inverse flattening value of 293.46602... to semi-minor axis value of 6356515.0 m.'),
(98.13,'1998-04-15','1998-04-16','Simon-Pierre Cadieux; Formatek','Correct name','Geod_trf','8198','','EPSG_name corrected from "LKS94 to WGS84 (1)" to "LKS94 to WGS 84 (1)".\ufffd\ufffd\ufffd          LKS94 to WGS84 (1)'),
(98.14,'1998-04-14','1998-04-16','Roger Lott; BP','Add Mozambique CS and transformations','Geod_datum  HorizCS  Trf_nonpoly  Geod_trf','','','Added geodetic datums 6127-6130; geogCS 41227-4130; projCS 2736 2737 3036 & 3037;  non-polynomial transformations 1297-1302; geodetic transformations 8214-8224; vertical datum 5121; vertCS 5722.'),
(98.15,'1998-05-08','1998-06-30','Richard Wylde; SIMA Consultancy','Check NIMA Algeria datum transformations','Trf_non-poly','1255  8158','NIMA advise that the published transformation parameter values are consistent with the data used in their derivation.  However EPSG believes that the data for non-polynomial transformation 1253 contains a blunder.','Cautionary note added to DMA Voirol Unifie 1960 to WGS 84 non-polynomial transformation 1255 and geodetic transformation 8158.'),
(98.16,'1998-05-18','1998-05-18','Roel Nicolai; Shell','Minor change to text describing formula','Trf_method','9606','Change applies to text; the formula is unchanged.','Added phrase in 3rd paragraph to clarify convention common in E&P practice.'),
(98.17,'1998-06-03','1998-06-30','Andreas Kasparz; FEZ Potsdam.','Add DHDN to WGS 84 geodetic transformation.','Trf_nonpoly  Geod_trf','','Also added Pulkovo 1942 to WGS 84 for former East Germany.','Added non-polynomial transformations 1309 1310; transformation paths 8633-8636 and geodetic transformations 8233-8236.'),
(98.18,'1998-06-03','1998-06-30','Andreas Kasparz; FEZ Potsdam.','Amend codes to long integer.','All','','EPSG codes can all be accomodated with a short integer.  EPSG will therefore not change its database declarations.   User-defined extensions to the EPSG list can be accomodated by users declaring all code fields as long integer.',''),
(98.19,'1998-06-03','1998-06-30','Andreas Kasparz; FEZ Potsdam.','Extend ProjCS zones based on Pulkovo 1942 GeogCS.','HorizCS','','','Added non-polynomial transformations 16202 16203 16302 16303 and projCS 28402 28403 28462 28463.'),
(98.2,'1998-06-30','1998-06-30','EPSG','Correct NADCON entries','Trf_non-poly','1241  1243','','Moved file names from remarks tp parameter fields.'),
(98.201,'1998-06-30','1998-06-30','EPSG','Delete erroneous NADCON WGS84 entries.','Trf_nonpoly  Trf_path  Geod_trf','1242  1244  8145  8147  8545  8547','','Records deleted.'),
(98.203,'1998-06-30','1998-06-30','EPSG','Add NAD83 to ITRF','Trf_nonpoly  Trf_path  Geod_trf','','WGS 84 considered coincident with ITRF for E&P purposes.','Added non-polynomial transformation 1308, transformation path 8630-8632 and geodetic transformation 8230-8232.'),
(98.21,'1998-06-30','1998-06-30','EPSG','Add Common Offshore transformation','Trf_nonpoly  Trf_path  Geod_trf','','','Added non-polynomial transformation 1311, transformation path 8637 and geodetic transformation 8237.'),
(98.22,'1998-07-21','1998-11-11','Melita Kennedy; ESRI','Check Michigan State Plane units','Ellipsoid  HorizCS  Trf_nonpoly  UOM_length','7009  9004  12101-3  12111-3  26801-3  26811-3','','Changed units for Clarke 1866 Michigan ellipsoid and all six NAD27 Michigan State Plane zones from Modified American foot to US Survey Foot.  Deleted Modified American foot.'),
(98.23,'1998-09-29','1998-09-29','EPSG','Version 4.1 release','','','','Version 4.1 release.'),
(98.24,'1998-09-29','1998-11-11','Jean-Patrick Girbig; Petroconsultants','Add Tunisia Mining Grid','Trf_method  HorizCS  Trf_nonpoly  UOM_length','','','Added length unit 9036; transformation method 9816; non-polynomial transformation 19927; geogCS 4816; projCS 22300.'),
(98.25,'1998-10-09','1998-11-11','EPSG','Add Angola ProjCSs and transformations','Trf_nonpoly  Geod_trf   Trf_nonpoly  HorizCS','','','Added non-polynomial transformations 16611-12 and 1317-1330; HorizCS 22091-92; Geodetic transformations 8249-8662.'),
(98.26,'1998-10-10','1998-11-11','EPSG','Correct source GeogCS code in ProjCS report','','','','New reports included in v4.2.'),
(98.27,'1998-10-13','1999-04-22','Henri Dupuy; Woodside Petroleum.','Add Mauritania information','','','Insufficient information provided.','Referred to reporter.'),
(98.28,'1998-10-16','1998-11-11','EPSG','Change Common Offshore transformation name','Geod_trf','8237  8238','Geod_trf name changed from that of non-poly_trf abbreviation to non-poly_trf name.','Delete geod_trf 8237 and replace by 8238 retaining same path to non-poly_trf 1311.'),
(98.29,'1998-11-02','1998-11-11','Nadine Delisle; HMR','Check South Africa and Namibia ProjCS','','','No problem dentified.','Informed reporter.'),
(98.3,'1998-01-02','1998-11-11','Nadine Delisle; HMR','Correct datum for ProjCS NAD83 / North Carolina','HorizCS','26719','','Correct source GeogCS from 4267 to 4269.'),
(98.31,'1998-11-06','1998-11-11','EPSG','Add Iran Final Datum 1958','Geod_datum  HorizCS','','','Added Geod_datum 6132; GeogCS 4132 and ProjCS 3200.'),
(98.32,'1998-11-06','1998-11-11','Peter Laskowski; Intergraph','Increase ellipsoid parameter precision','Ellipsoid','7019  7030-7033  7036','5 decimal places in 1/f allows computation of semi-minor axis to better than 0.5mm.','Precision of 1/f increased from 5 decimal places to original publication precision.'),
(98.321,'1998-11-06','1999-04-22','Peter Laskowski; Intergraph','Increase ellipsoid parameter precision','Ellipsoid','7001-2  7004-6','5 decimal places in 1/f allows computation of semi-minor axis to better than 0.5mm.','Precision of 1/f increased from 5 decimal places to original publication precision.'),
(98.33,'1998-11-06','1998-11-11','Peter Laskowski; Intergraph','Expand ellipsoid second defining parameter types','Ellipsoid','','EPSG/POSC will retain the three geometric parameters a b and 1/f; the computation of other geometric parameters required for transformations is best left for the application; the introduction of physical parameters introduces unnecessary complexity.','Informed reporter.'),
(98.34,'1998-11-06','1999-04-22','Peter Laskowski; Intergraph','Store original ellipsoid unit definitions','Ellipsoid','7001  7004  7008','','Added original definition as remarks to 7001 7004 and 7008; added 7042.'),
(98.35,'1998-11-06','1999-04-22','Richard Wylde; SIMA Consultancy','Add TM offset from UTM and associated CS','HorizCS  Trf_nonpoly','','','Added non-polynomial transformations 16400 16405 16506 16611 16612 16636;  horizCS 3176 22091 22092 23090 23095 32766.'),
(98.361,'1998-11-06','1998-11-19','Richard Wylde; SIMA Consultancy','Check Petroconsultants country codes','Area','10  40  62  93  97  105  224  242  271','','Changed Petroconsultants codes for Area_IDs 10(8190>6190) 40(6610>6510) 62(8220>6220) 93(5520>6520) 97(8080>8680) 105(6230>6430) 242(8230>6230) and 271(3360>3370). Added Petroconsultants code 6600 for Area_ID 274.'),
(98.362,'1998-11-06','1998-11-19','Richard Wylde; SIMA Consultancy','Check ISO area codes','Area','26 141 263','','Changed ISO A3 codes for Area_IDs 26(BR>BHR) and 141(KBR>LBR). Changed ISO A2 code for Area_ID 263(BG>VG).'),
(98.37,'1998-11-10','1998-11-11','Rossano Carlotti; AGIP','Check Rome prime meridian transformation','Trf_non-poly','1262','','Erroneous value of -7.26225 replaced with correct value of 12.27084.'),
(98.38,'1998-11-03','1998-11-11','John Bobbitt; POSC','Check Trinidad geodetic transformations','Trf_non-poly','1295  1296','Parameters for these two transformation parameters were transposed.','Corrected parameters for dX dY and dZ for 1295 and 1296 by moving values from 1295 to 1296 and vice versa.'),
(98.381,'1998-11-10','1998-11-11','Rossano Carlotti; AGIP','Check Trinidad geodetic transformations','Trf_non-poly','','See 98.380','See 98.380.'),
(98.39,'1998-11-10','2002-09-19','APSG','Ensure at least 1 transformation to WGS84 for every GeogCS','','','See 2002.391','Case closed.'),
(98.4,'1998-11-11','1998-11-11','EPSG','Add Indian 1960 GeogCS','Geod_datum  HorizCS','','','Added geodetic datum 6131; geogCS 4131; projCS 3148  3149  3176.'),
(98.41,'1998-11-11','1999-10-20','EPSG','Add parameter units for all transformation parameters','','','To be implemented in v5.',''),
(98.42,'1998-11-11','1998-11-11','John Bobbitt; POSC','Correct spelling of Portuguese','HorizCS  Trf_nonpoly','19918  20700','Only change is in the spelling of the projection and projected CS names.  As these are keys the original enties deleted and replaced.','Non-poly tfm 19918 and HorizCS 20700 deleted and replaced by 19936 and 20790 respectively.'),
(98.43,'1998-11-11','1998-11-11','EPSG','Add UKOOA UKCS transformations','Trf_non-poly  Geod_trf','','','Added non-polynomial transformations 1314-1315; geodetic transformations 8246-8247.'),
(98.44,'1998-10-26','1998-11-11','Rossano Carlotti; AGIP','Add Cameroon transformations','Trf_non-poly  Geod_trf','','','Added non-poly trf 1316 and geod_trf 8248.'),
(98.45,'1998-11-11','1998-11-11','EPSG','Add country names to WGS 84 systems','horizCS','32601-60; 32701-60','GeogCS report adds WGS 84 to all areas.','Added country names to all WGS84 / UTM projCS area of use.'),
(98.4600015258789,'1998-11-18','1998-11-19','Lars Nilsson; Satellitbild','Correct trf_variant values in Geod_trf table','Geod_trf','8180  8227','','Changed trf_variants for 8180 and 8227 from 1 to 2 and from 1 to 5 respectively.  Changed name of 8227 from "\ufffd\ufffd\ufffdto WGS84 (5)" to "\ufffd\ufffd\ufffdto WGS 84 (5)".'),
(98.47,'1998-11-25','1998-11-25','EPSG','Version 4.2 release','','','',''),
(98.48,'1998-12-02','1999-10-20','Gerhard Trichtl; Datamed Info GmbH','Add Austrian projections; check prime meridian.','Tfm_nonpoly  HorizCS','18041-43','Other requested systems not provided by Austrian authorities.','Amended remarks for proj 18041-43 and projCS 31291-93.  Added proj 18044-46  19947 and projCS 31294-97; non-poly tfm 1471  tfm_path 8815  geod tfm 8415.'),
(98.49,'1998-12-09','1999-04-22','Kazushi Iuchi; Hitachi','Add Japanese coordinate systems and transformations.','HorizCS  Tfm_nonpoly  Trf_path  Geod_trf  Vert_datum  Vert_CS','','','Added non-polynomial transformations 1335-1436 and 17801-17819; projCS 30161-30179; geodetic transformations 8268-8369; trf_path 8668-8769; vertical datum 5122; vertical CS 5723.'),
(98.5,'1998-12-14','1998-12-14','EPSG','Correct second part of Australian compound geodetic transformations','Trf_path','8590 step 2, 8592 step 2, 8594 step 2.','Change ID and date also recorded in Geod_Trf records 8190 8192 and 8194 although no change was actually made in this table.','Amended non-polynomial transformation code in step 2 from 1151 (GD49) to 1150 (GDA94).'),
(98.51,'1998-12-14','1998-12-14','EPSG','Correct path for Sweden RT38 longitude rotation','Trf_path','8578','','Corrected target CS code from 4378 (unused) to 4308 (RT38).'),
(98.52,'1998-12-14','1998-12-14','EPSG','Correct name for Greek longitude rotation','Geod_trf','8179','','Changed geod_trf name from "Greek (Athens) to Greek" to "Greek (Athens) to Greek (1)".'),
(98.53,'1998-12-14','1998-12-14','EPSG','Add unit codes for NADCON transformations','Tfm_nonpoly','1241  1243','','Added angle unit code.'),
(98.54,'1998-12-14','1999-04-22','EPSG','Add Estonia coordinate systems and transformations','Gdatum  HorizCS  Tfm_nonpoly  Trf_path  Geod_trf','','Data not confirmed by national mapping agency.','Add geodetic datum 6133; geogCS 4133; projections 19938-39; projCS 3300 and 25884; non-poly_tfm 1331-4; geod_trf 8264-7; trf_path 8664-7.'),
(98.55,'1998-12-14','1998-12-14','EPSG','Add concatenated transformation area of use field','Geod_trf','','This field is for concatenated (multi-step) transformations only. For single step transformations the area of use for the related polynomial or non-polynomial transformation apply to the geodetic transformation.','New field added.  Remarks and information source field captions changed to include "concatenated".'),
(98.56,'1998-12-14','1998-12-14','EPSG','Correct angle units for Angola geodetic transformations','Trf_nonpoly','1267  1326','','Changed angle unit code from incorrect value of 9102 (=degree) to 9104 (=arc-second).'),
(98.57,'1998-12-14','1998-12-14','EPSG','Correct variation number for Canada NT transformations','Geod_trf','8242  8244','','Changed coord_trf_variant from 1 to 3 and 2 to 4 respectively.'),
(98.58,'1998-12-14','2000-10-19','EPSG','Check coordinate system and area consistency for DMA Batavia to WGS84 transformation.','Trf_nonpoly','1123','Area given as Sumatra but Batavia is a datum for Java.','Remark added.'),
(99.01,'1999-01-07','1999-04-22','Gerhard Bilhag, Univ. of Munich','Correct Abridged Molodenski formulae','Tfm_method','9605','EPSG guidance note 7 also corrected and re-issued February 1999.','Correct formula: In equation for Dlat changed 206265 to 1/sin1". In equation for Dlon, (a) changed 206265/nu to 1/nu*cos(lat)*sin1"; (b) the term dY*cos(lat) changed to dY*cos(lon). In equation for Dh, the sin2(lat) term changed to sin(lat)^2.'),
(99.02,'1999-02-11','1999-04-22','Melita Kennedy; ESRI','Add Madrid 1870 (Greenwich)','','','We have no evidence of the Madrid datum being used with the Greenwich meridian.  Transformations carried in the EPSG data to not require the presence of Madrid (Greenwich) datum.','None to data set.  Informed reporter.'),
(99.03,'1999-02-11','1999-04-22','Melita Kennedy; ESRI','Change ellipsoid name for WGS72 datum','Ellipsoid  Ellips_alias Geod_datum','7026  6322  6324','The WGS72 figure of the earth adopted the NWL10D ellipsoid parameters.  However, universal usage (including within NIMA TR8350.2) is to refer to this ellipsoid as WGS72.','WGS 72 (code 7043) added to ellipsoid table.  NWL 10D (code 7026) deleted from ellipsoid table and added to ellips_alias table.  WGS72 and WGS72BE datums changed from ellipsoid 7026 to 7043.'),
(99.04,'1999-02-12','1999-05-24','Simon-Pierre Cadieux; Concept Logic','Update NAD27-NAD83 transformations for Quebec and Ontario','','','','Add geod_datum 6608-6609; geogCS 4608-4609; non-poly tfm 1451 1462 1463; trf_path 8795-6  8803-8806; geod trf 8395-6  8403-8406.'),
(99.041,'1999-04-22','1999-05-24','EPSG','Update NAD27 / MTM and UTM projCSs for Quebec and Ontario','HorizCS','26715-26721  26780  26787-26797','','Delete ProjCS 32080 & 32087-32097 (NAD27 / MTM * except for Newfoundland); add ProjCS 208-235.  Amend remarks for 26715-26721.'),
(99.042,'1999-04-22','1999-05-24','EPSG','Correct MTM zones for Nova Scotia','Trf_non-poly','17794  17795','','Changed longitude of natural origin (parameter 2) values from 61.3 to -61.3 and from 64.3 to -64.3 respectively.'),
(99.05,'1999-02-18','1999-04-22','Simon-Pierre Cadieux; Concept Logic','Add angle units and abbreviations','UOM_angle  UOM_an_alias','','','In UOM_angle added abbreviation to codes 9105 (grad) and 9109 (microradian); added new angle units 9112-9114 (centesimal minutes and seconds; mil_6400).  In UOM_an_alias added new angle unit alias 9115 (mil).'),
(99.051,'1999-03-22','1999-04-22','Simon-Pierre Cadieux; Concept Logic','Add new angle unit degree and decimal minutes','UOM_angle','','','Added angle unit code 9111.'),
(99.06,'1999-02-17','1999-04-22','Frank Warmerdam','Increase precision of pi from 2 decimal places','UOM_angle','','The database holds pi to a precision of 9 decimal places.  We believe the reporters problems are an artifact of Access exporting.  No change made to database tables.','Reporter informed.'),
(99.07,'1999-03-03','1999-04-22','EPSG','Add Oman horizontal and vertical data','','','','Added geod_datum 6134; geogCS 4134; projCS 3439 and 3440; non_poly transformations 1438 and 1439; geod_trf 8370 and 8371; vert_datum 5123 5124; vertCS 5724 5725.'),
(99.08,'1999-03-10','1999-10-20','Tim Magee; Maersk','Foot-metre conversion for Bangladesh','','','','See change request 97.23.'),
(99.09,'1999-03-23','1999-04-22','EPSG','Add Israel data','','','','Added non_poly transformations 18201 and 18202; projCS 28191 and 28192.'),
(99.091,'1999-04-22','1999-10-20','EPSG','Add new Israel data','','','','Added projections 18203 and 18204; geodetic datum 6141; GeogCS 4141; ProjCS 239 and 28193.'),
(99.1,'1999-03-23','1999-04-22','Marc Beaudoin; Egypt Environmental Information Project','Add Egypt Blue Belt','Tfm_nonpoly  ProjCS','','Some doubt about projection name as identical parameter values often encountered as "Green Belt".','Added non_poly transformation 18071 and projCS 22991.'),
(99.101,'1999-04-22','2000-03-07','EPSG','Check Egypt datums','','','Some authorities document datum as Egypt 1930.  This is the date that projected coordinate systems based on the Egypt 1907 datum were instigated.','None - see remarks.'),
(99.11,'1999-04-08','1999-04-22','Lars Nilsson; Satellitbild','Correct Swedish transformation','Trf_nonpoly  Trf_path','1281  8595','Previous parameter values of dX=-419.375; dY=-99.352; dZ=-591.349; rX=+0.850458; rY=+1.817245; rZ=-7.862245 and dS=+0.99496 were for ETRF89 to RR92/RT90.','Delete non_poly tfm 1281 (RT90 to WGS 84) and replace with 1437 (RT90 to ETRF89). Add geod_tfm 8380 (RT90 to ETRF89).  Amend tfm_path 8595/1 target from 4326 (WGS 84) to 4258 (ETRF89).  Add tfm_path 8595/2 (4258 to 4326).'),
(99.111,'1999-04-22','1999-04-22','EPSG','Change ETRS89 to ETRF89','GeogCS  Geod_Datum  ProjCS  Trf_nonpoly  Geod_trf','4258  6248  25828-38  25884  1149  1273  1309  1310  1331  8049  8182  8233  8235  8264.','Geodetic transformations act on reference frames, the practical realisation of reference systems.','Change name from ETRS89 to ETRF89.'),
(99.112,'1999-04-22','1999-04-22','EPSG','Change ETRF89 to ETRS89','Gdatum_alias','6400','Change associated with 99.111.','Change name from ETRF89 to ETRS89.'),
(99.12,'1999-04-22','1999-04-22','EPSG','Amend NAD tfm for US','Trf_nonpoly','1308','','Reverse signs in parameter values of non-poly transformation 1308.'),
(99.13,'1999-04-22','1999-10-20','EPSG','Investigate transformations for Canada other than Quebec','','','Canada CSRS98 added for New Brunswick; other provincial systems will be added when they are made public.','See 99.61.'),
(99.14,'1999-04-22','1999-10-20','EPSG','Add US HARNS and transformations','','','','Add non_poly tfm 1474-1503; tfm_path 8819-8847 and 8860-89; geod_tfm 8419-8417 and 8460-89.'),
(99.151,'1999-04-22','2000-06-23','EPSG','Add Venezuela grids','','','','Added proj 18260-63; projCS 2101-04.  For v5 only added local datums 9301-11; local CS 5801-03 and 5808-16.'),
(99.152,'1999-04-22','1999-10-20','EPSG','Rationalise La Canoa datum.','','4247  4248  24720-21  24818-20','La Canoa is fundamental point for Venezuela system also adopted as origin for PSAD56.','Added ProjCS 24718-9.  Deleted ProjCS 24721.  Added remarks to GeogCS 4247-8 and ProjCS 24720 and 24818-20.'),
(99.153,'1999-04-22','1999-11-05','EPSG','Add Venezuela PDVSA transformations','','','This data for eastern Venezuela. Investigations continuing for western and central areas.','Added tfm_nonpoly 1516  tfm_path 8895  geod_tfm 8495.'),
(99.154,'1999-11-05','2000-10-19','EPSG','Add Venezuela PDVSA transformations for western and central areas','','','No data forthcoming - case closed.','None.'),
(99.16,'1999-04-22','1999-10-20','Jean-Patrick Girbig; IHS Energy Services','Add Argentina SAD69 projCS','','','We can find no evidence of SAD69 being used by geomatics authorities in Argentina.','None.'),
(99.17,'1999-04-22','1999-04-22','Jean-Patrick Girbig; IHS Energy Services','Add Barbados projCS','geod_datum  horizCS','6212  4212','','Changed name of geodetic datum 6212 and geogCS 4212 from Barbados to Barbados 1938. Added non_poly transformation (projection) 19943; projCS 21291-92.'),
(99.18,'1999-04-22','1999-04-22','Jean-Patrick Girbig; IHS Energy Services','Add West Indies projCS and transformations','','','','Added geodetic datums 6139 & 6600-7; geogCS 4139 & 4600-7; transformation method 9619 (geog. offsets); non_poly transformations 1441-7 and 19942; projCS 3920 & 200-207; geodetic transformations 8373-8379.'),
(99.19,'1999-04-22','1999-10-20','EPSG','Add FD58 transformation','','','Data for Ahwaz area still needed.','Added  tfm non-poly 1513; tfm_path 8891; geod_tfm 8491.'),
(99.201,'1999-04-22','1999-04-22','Martin Redford, Enterprise','Add Morocco transformation','','','Data already in database.','Advised reporter.'),
(99.202,'1999-04-22','1999-10-20','Melita Kennedy; ESRI','Check Morocco angle units','','4261  18131-2  26191-2','These are OK.  Although originally working in grads (hence projection parameter definition) usage since 1953 has been in degrees.','None.'),
(99.203,'1999-04-22','1999-10-20','Cliff Munier; University of New Orleans','Review Morocco projection method','','','The small difference in coordinates caused by the change in projection method and the very old date (1953) of change does not warrent adding the historic systems to the database.','Remarks added to proj 18131 and 18132.'),
(99.21,'1999-04-22','1999-04-22','EPSG','Add Syria projCS','','','EPSG guidance note 7 updated for new projection method.','Added transformation method 9817 (truncated Lambert Conic); non_poly pojection 19940; projCS 22700.'),
(99.211,'1999-04-22','1999-04-22','EPSG','Improve Lambert 1SP formulae','Tfm_method','9801','EPSG guidance note 7 updated for improved formula.','Amended transformation method 9801 (Lambert Conic 1SP) formula to improve efficiency of reverse computation.'),
(99.221,'1999-04-22','1999-04-22','EPSG','Add Greece ED50 projCS','','23034 23035','Used in oil industry.','Added Greece to area of use.'),
(99.222,'1999-04-22','1999-04-22','Martin Redford; Enterprise','Add Greece ED50 transformation','','','','Added non_poly transformation 1440 and geodetic tfm 8372 (ED50 to WGS 84 (19)).'),
(99.23,'1999-04-22','2000-03-07','Martin Redford; Enterprise','Add Vietnam data','','','','Added geod_datum 6147; geogCS 4147; proj 16586; projCS 2044-45 2093-94; vert_datum 5125-6; vertCS 5726-7; tfm 1541-44; trf path 8365-68; single geod tfm 8531 8533-35; concat geod tfm 8532.'),
(99.24,'1999-04-22','1999-04-22','EPSG','Add Brazil data','','','EPSG guidance note 7 updated for new projection method.','Added transformation method 9818 (American Polyconic); non_poly projection 19941; projCS 24882 and 29100.'),
(99.25,'1999-04-22','1999-10-20','Jim Cruickshank; Western Geophysical','Add Ivory Coast data','','','','Added geodetic datums 6142 6143; geogCS 4142 4143; projCS 240-243; non-poly transformations 1469 1470; tfm path 8813 8814; geod. tfm 8413 8414.'),
(99.26,'1999-04-22','1999-04-22','Tim Smith; Conoco','Add Poland data','','','','Amended area of use for projCS 28403 28404 28463 and 28464.'),
(99.27,'1999-04-22','1999-05-24','Erik Havarstein; Statoil','Add offshore Norway 62-65 deg transformations','','','This covers area west of 5 deg E.  Area to east dependent upon onshore transformation - investigations ongoing. EPSG guidance note 7 updated for new projection method.','Added trf_method 9620; non_poly tfm 1450, geof_tfm 8384.'),
(99.271,'1999-04-22','2001-06-05','Erik Havarstein; Statoil','Add offshore Norway 62-65 deg transformations','','','Area east of 5 deg E dependent upon onshore transformation - investigations ongoing.','Problem closed without action as for oil industry purposes overtaken by the addition of tfm 1613 (see change request 2001.06).'),
(99.281,'1999-04-22','1999-04-22','EPSG','Change Lambert Conic (2SP) transformation parameter order','Trf_method  Trf_nonpoly','9802-3 and trf_nonpoly as given in action.','To enhance projCS report aesthetics by making consistent with other projection methods.  (Continued in change records 99.282 and 99.283 ...)','For trf_methods 9802 and 9803 (Lambert Conic with 2SP) reverse trf parameters 1 & 3; reverse param 2 & 4. Thus lat/long of origin from param 3 & 4 to param 1 & 2 respectively and lat of 1st/2nd SP from param 1 & 2 to param 3 & 4. (Cont 99.282 & 99.283..)'),
(99.282,'1999-04-22','1999-04-22','EPSG','Change Lambert Conic (2SP) transformation parameter order','Trf_method  Trf_nonpoly','9802-3 and trf_nonpoly as given in action.','(... continued from change record 99.281 and to 99.283 ...)','(Cont from 99.281). In trf_non-poly reverse param 1/2 with 3/4 for all US SP using LCC2; Belgium and Estonia.  Codes affected: 10301-10630; 10903; 10933; 11401-11732; 11900-12032; 12111-12233; 12501-12630; 13104; 13134; 13200-13732; (Cont 99.283 \ufffd\ufffd\ufffd)'),
(99.283,'1999-04-22','1999-04-22','EPSG','Change Lambert Conic (2SP) transformation parameter order','Trf_method  Trf_nonpoly','9802-3 and trf_nonpoly as given in action.','(... continued from change record 99.282).','(Cont from 99.282). Codes affected (cont): 13901-14333; 14501-14833; 15010; 15040; 15201-15230; 19901; 19902; 19938.'),
(99.284,'1999-04-22','1999-04-22','EPSG','Change Spain polynomial transformation parameter order','Trf_method  Trf_poly','9617  1001-3','To enhance polynomial report aesthetics.','For trf_method 9617 (Spain polynomial) move trf parameters 1-9 to trf param 5-13 respectively. Thus coeff B moved from param 2 to param 6.  Make same change in trf_poly 1001-1003.'),
(99.29,'1999-04-22','2000-03-07','EPSG','Amend reports to show DDDMMSSsss conventionally','','','','Implemented in v5 forms and reports.'),
(99.3,'1999-04-22','1999-05-24','EPSG','Correct Lithuania transformation method','Tfm_non-poly','1274','Data in v4.2 was consistent within itself but inconsistent with the format provided to EPSG.','Changed transformation method code from 9606 to 9607; multiplied values of each of parameters 4 through 6 by -1.'),
(99.31,'1999-04-22','1999-05-24','EPSG','Consolidate TRF_METHOD for gridded bi-linear interpolations into a single method','Trf_method','9613 9614 9615','Not consolidated.  The various methods currently carried (NADcon, NTv1 and NTv2) all use different gridded data file structures and require different algorithms.','In recognition of international usage changed names of methods 9614 and 9615 by deleting the prefix ''Canada''.  Amended description of methods 9613-9615.'),
(99.32,'1999-05-10','1999-05-24','EPSG','Update NADCON tranformations for individual source datums other than NAD27 covered within NADCON','','','','Added Geod_datum 6135-6138; HorizCS 4135-4138;  geod_trf 8385-8392 & 8401-2; trf_path 8785-8792 & 8801-2; trf_nonpoly 1454-1457 & 1461.'),
(99.321,'1999-05-10','1999-10-20','EPSG','Update NADCON tranformations to incorporate HARN readjustments from NAD83(1986) to later realizations','','','See 99.14.',''),
(99.322,'1999-05-10','1999-05-24','EPSG','Correct NAD27 Hawaii and Puerto Rico State Plane CS datums','HorizCS','26761-26765','NAD27 does not formally exist in Hawaii.  References to it really refer to Old Hawaiian datum.','Deleted ProjCS 26761-26765 based on NAD27 and replaced these with 3561-3565 based on Old Hawaiian.'),
(99.323,'1999-05-10','1999-05-24','EPSG','Correct NAD27 St Croix and Puerto Rico State Plane CS datums','HorizCS','26759  26760','NAD27 is not formally used for State Plane CSs in Puerto Rico and the US Virgin Island.  References to NAD27 in this context realy refer to Puerto Rico datum.','Deleted ProjCS 32059 and 32060 based on NAD27 and replaced these with 3991 and 3992 based on Puerto Rico datum.'),
(99.324,'1999-05-24','1999-10-20','EPSG','Check NAD83 in Hawaii and Puerto Rico','HorizCS','','NGS confirms that NAD83 does exist in these areas.','None.'),
(99.33,'1999-03-23','1999-05-24','Simon-Pierre Cadieux; Concept Logic','Update NTv2 transformations for Australia from Australian government website','','','Further coverage to come.','Added trf_nonpoly 1464-1465; trf_path 8807-8810; geod_trf 8407-8410.'),
(99.34,'1999-05-24','1999-05-24','EPSG','Add regional similarity transformations for Australia from government website','','','','Added trf_nonpoly 1458-1460; trf_path 8795-8800; geod_trf 8395-8400.'),
(99.35,'1999-07-26','1999-07-26','EPSG','Version 4.3 release','','','Further reporting added.  Changes through 99.34 but with actions still remaining on some earlier change requests.','Version 4.3 released'),
(99.36,'1999-08-11','1999-10-20','Tore Hoff;  Geodata AS','Add onshore Norway systems','','','See 99.271 for geodetic transformations involving NGO48.','Add prime_meridian 8913; HorizCS 4817; projections 18221-8; projCS 27391-8; non_poly tfm 1466.'),
(99.37,'1999-08-11','1999-10-20','Radek Kuttelwascher; Arcdata','Add Czech and Slovakian Gauss Kruger systems','HorizCS','28402-3  28462-3','','Amended area of use to include Czech Republic and Slovakia.'),
(99.38,'1999-08-11','1999-10-20','Melita Kennedy; ESRI','Update information source URL for US transformation','Trf_nonpoly  Trf_path  Geod_tfm','1308  8630-31  8230-31','NAD27 to WGS 84 variants 23 and 24 replaced by variants 28 and 29 respectively.','Add non_poly tfm 1515; delete concatenated geod tfm using 1308 (8230-31 and tfm path 8630-31) and replace with concatenated geod tfm using 1515 (8496-97 and tfm path 8896-97).'),
(99.39,'1999-08-11','1999-11-05','Melita Kennedy; ESRI','Update Codes table','Codes','','','Done'),
(99.4,'1999-08-11','1999-08-11','Tamotsu Amemiya; PASCO','Add Japanese systems','','','Already in v4.3.  See 98.49','None'),
(99.41,'1999-07-21','2000-03-07','Simon-Pierre Cadieux; Methodex','Check parameters for Alaska SP zone 1','Trf_nonpoly','15001  15031','EPSG parameters are consistent with transformation formulae.','None'),
(99.42,'1999-07-27','2000-10-19','EPSG','Additional Syria systems','','','','Added proj 19948-9 and projCS 22770 22780.  Added aliases to geod datum 6227; geogCs 4227 and projCS 22700.  Added geodetic transformations 1584-87 and concatenated transformation 8568.'),
(99.43,'1999-08-06','1999-10-20','Jean-Patrick Girbig; IHS Energy','Add Guatemala system','','','','Added proj 18211-2 and projCS 32061-2.'),
(99.44,'1999-08-10','1999-08-10','Simon-Pierre Cadieux; Methodex','Correct ATS77 MTM parameters','Trf_nonpoly','17794  17795','See 99.042','None'),
(99.45,'1999-08-27','1999-07-20','Malcolm Jones; Fugro','Add Rassadiran datum and projection','','','See also 99.19','Added geod_datum 6153-4; geogCS 4153-4; proj 19951; projCS 257-261; tfm non-poly 1512 1514; tfm_path 8890 8892; geod_tfm 8490 8492.'),
(99.46,'1999-09-07','1999-09-07','Simon-Pierre Cadieux; Methodex','Correct transformation path 8578','Trf_path','8578','See 98.51','None'),
(99.47,'1999-09-10','2000-03-07','Simon-Pierre Cadieux; Methodex','Clarify polynomial transformation method','Trf_polynomial  Trf_method','1025-28 (formerly 1000-1004);  9608-12 9617','See also 99.64','Added sections 3 and 4 to EPSG guidance note #7.'),
(99.48,'1999-09-12','1999-10-20','Simon-Pierre Cadieux; Methodex','Correct Angle unit','UOM_Angle','9112','','Change value of target unit from 9106 to 9101.'),
(99.49,'1999-09-12','1999-10-20','Simon-Pierre Cadieux; Methodex','Correct unspecified datum','G_datum  HorizCS','6026  4026','','Delete geod_datum 6026 and geogCS 4026; add geod_datum 6041-6045 and geogCS 4041-4045.'),
(99.5,'1999-09-12','1999-10-20','Simon-Pierre Cadieux; Methodex','Update codes table','Codes','','','See 99.39'),
(99.51,'1999-09-12','1999-10-20','Simon-Pierre Cadieux; Methodex','Ensure consistent value for pi','UOM_Angle','9112-4','','Change value of factor b from 3.14159265359 to 3.14159265358979.'),
(99.52,'1999-09-12','1999-10-20','Simon-Pierre Cadieux; Methodex','Correct remarks','HorizCS','32183-32190','','Change Remarks text from NAD27 to NAD83.'),
(99.53,'1999-09-12','1999-10-20','Simon-Pierre Cadieux; Methodex','Correct Quebec remarks and Change record','HorizCS  Change','227-235  99.041','','Change HorizCS Remarks code values from 320** to 267**.  Amend Change record 99.041 codes affected from 320** to 267**.'),
(99.54,'1999-09-12','1999-11-05','Simon-Pierre Cadieux; Methodex','Update  NTv2 information source URL','Trf_method  Trf_nonpoly','9615  1313','This is not the source requested by Reporter, but is more appropriate to provide information about the transformation.  It does link directly to requested sourc','Change source information for NTv2 method 9615 and transformation 1313.'),
(99.55,'1999-09-18','1999-10-20','Simon-Pierre Cadieux; Methodex','Polyconic projection parameters','Trf_method  Tfm_non-poly','9818  19941','','Delete requirement for parameter 5 in method 9818.  Delete parameter 5 in projection 19941.'),
(99.56,'1999-09-20','1999-10-20','EPSG','Correct coordinates of Tokyo datum fundamental point','Geod_datum','6301','','Change value of latitude minutes from 19 to 39.'),
(99.57,'1999-09-20','1999-10-20','Simon-Pierre Cadieux; Methodex','Add Quebec Lambert system','Trf_nonpolynomial  HorizCS','','','Add projection 19944 and ProjCS 32198.'),
(99.58,'1999-09-28','1999-09-28','Adam Gawne-Cain; Cadcorp','Add Japanese systems','','','Already in v4.3.  See 98.49','None'),
(99.59,'1999-10-04','1999-10-20','EPSG','Update Angola CS area of use','HorizCS  Trf_nonpolynomial','22092  1327','','Add to Remarks: Used by BP Amoco, Elf and Esso for offshore blocks 31-33.'),
(99.6,'1999-10-08','1999-10-20','Melita Kennedy; ESRI','Check Brazil systems north of equator','','','We have found no evidence of official Brazilean CS using northern hemisphere UTM zones.','None.'),
(99.61,'1999-10-08','1999-10-20','Melita Kennedy; ESRI','Add new Canada New Brunswick systems','','','','Delete proj 19932 and replace by 19945; amended projCS 2200 from 19932 to 19945. Added proj 19946  geod_datum 6140   geogCS 4140  projCS 236-8;  non_poly tfm 1472-3  tfm_path 8816-8  geod_tfm 8416-8.'),
(99.62,'1999-05-10','1999-10-20','Bruno Ravanas; Total-Fina','Correct Algeria ellipsoid','Geod_datum','6305  6307','','Change reference ellipsoid from Clarke 1880 (IGN) [code 7011] to Clarke 1880 (RGS) [code 7012].'),
(99.63,'1999-10-20','1999-10-20','Simon-Pierre Cadieux; Methodex','Check Paris meridian value','P_Meridian','8903','No change made to Paris prime meridian (EPSG prefers IGN value to RGS value).  But added RGS value as longitude rotation transformation amending transformation using existing IGN value to accommodate.','Delete non_poly transformation 1194 and replace by 1467; amend tfm_path 8560 tfm from 1194 to 1467.  Add non_poly transformation 1468; tfm_path 8812 geod_tfm 8412.'),
(99.64,'1999-10-20','2000-03-07','EPSG','Check polynomial reversiblity','Trf_method','9608-12 9617','See also 99.47  and June 2000 edition of EPSG guidance note 7.','Deleted methods 9608-12; added methods 9621-30.  For tfm method 9617 and for tfm 1026-1028 (formerly 1001-1003) amended order of parameters 2 3 7 and 8 to accord with revised guidance note #7.  For v5.0 only added tfm 1035.'),
(99.65,'1999-10-20','2000-03-07','EPSG','Add Dutch polynomial transformations','','','Includes Belgian polynomials.','Added tfm methods 9631-32; polynomial_tfm 1029-34; tfm_path 8350-55; geod_tfm 8545-50.'),
(99.66,'1999-10-19','1999-10-20','Simon-Pierre Cadieux; Methodex','Change GeogCS to west longitudes','HorizCS','4135-8  4267-9  4608-9','EPSG recommends ISO practice of longitudes being positive east.  All EPSG GeogCS follow this practice.','None.'),
(99.67,'1999-10-19','1999-10-20','Simon-Pierre Cadieux; Methodex','Rename Australia transformation files','Trf_non-poly  Tfm_path Geod_trf','1465  8809-10  8409-10','','Delete non_poly tfm 1465; tfm_path 8809-10; geod_tfm 8409-10.  In non_poly tfm 1464 change parameter 35 from gridfile.gsb to vic_0799.gsb.  Add non_poly tfm 1506-7; tfm_path 8851-4; geod_tfm 8451-4.'),
(99.68,'1999-10-20','2000-10-19','EPSG','Add Glonass coordinate system and transformations','','','CS not in regular stand-alone use and no accepted transformation to WGS 84.','None.'),
(99.69,'1999-10-19','1999-10-20','Mike Postle-Hacon; Hydrosearch','Add new South African datum','Geod_datum  HorizCS','6222  4222','','Amended fundamental point for Cape datum (6222).  Add geod_datum 6148; geogCS 4148; projCS 246-255; non_poly tfm 1504-5; tfm path 8849-50; geod_tfm 8449-50.  Add remarks to geogCS 4222.'),
(99.7,'1999-11-05','1999-11-05','Roger Lott; BP Amoco','Check 1/f for Clarke 1858.','Ellipsoid','7007','DOS confirms that Trindad adjustment and densification used a and b to derive 1/f to 8 significant figures whilst obsolete Australian systems used a and 1/f to 4 significant figures.','Amend remarks.'),
(99.71,'1999-11-05','2000-03-07','Jean-Patrick Girbig; IHS Energy','Add Czech and Slovakian Krovak systems','','','','Added transformation method 9819; projection 19952; geodetic datums 6818 (v5 only) and 6156; horizCS 4156 and 4818; projCS 2065.'),
(99.72,'1999-11-05','1999-11-15','EPSG','Check names and orientation of Argentina CS axes','HorizCS','22191-97','','Changed axis 1 (X) direction from east to north and axis 2 (Y) direction from north to east.'),
(99.73,'1999-11-05','2000-06-23','Jean-Patrick Girbig; IHS Energy','Add Argentina Astra grid.','','','','For v5 only added local datum 9300; local CS 5800; tfm 1035.'),
(99.74,'1999-11-05','2000-03-07','EPSG','Review and modify coding rationale','HorizCS  Trf_poly','200-261  300  1000-1003','GeoTIFF reserved codes 0-1023 are to be avoided by EPSG..','ProjCS codes 200-261 and 300 deleted and replaced by codes 2000-2061and 2062 respectively.  Tfm-poly codes 1000-1003 deleted and replaced by codes 1025-1028 respectively.  Codes table changed in association with v4 to v5 changes.'),
(99.75,'1999-11-05','1999-11-05','EPSG','Correct transformation name.','Geod_tfm','8232','Geod tfm NAD83 to WGS 84 (14) replaced with NAD83 to WGS 84 (4); no change to related non_poly tfm NAD83 to WGS 84 (4).','Deleted geod_tfm 8232 and tfm_path 8632.  Replaced these with 8493 and 8793 repectively.'),
(99.76,'1999-11-05','1999-11-05','EPSG','Add geod tfm abbreviations','Geod_tfm','All single-step transformations','Indicates source and area.','Added to the Description field.'),
(99.77,'1999-11-11','1999-11-12','Simon-Pierre Cadieux; Methodex','Increase precision of Australian transformation parameter values','Trf_nonpoly','1278  1279','','Added remarks to these entries.'),
(99.78,'1999-11-11','1999-11-12','Simon-Pierre Cadieux; Methodex','Correct sign of Japanese longitude shift','Trf_nonpoly','1349','See change record 99.79.','Changed parameter 2 from 13.31 to -13.31.'),
(99.79,'1999-11-11','1999-11-12','Simon-Pierre Cadieux; Methodex','Correct transformation definition','Trf_method  Trf_nonpoly  Vert_offset','9601  9616  9618-9  1257-70  1466-68  5400','','Changed description of methods 9601 9616 9618 9619; changed sign before offset in formula for method 9616; added formulae for 9601 9618-9; reversed sign of parameter 1 for non-poly_tfm 1257-70 1466-68 vert_offset 5404.'),
(99.8,'1999-11-15','1999-11-15','Simon-Pierre Cadieux; Methodex','Amend information source','Trf_nonpoly','1463','','Change information source to http://www.geod.emr.ca/html-public/GSDapps/English/NTv2_Fact_Sheet.html'),
(99.81,'1999-09-13','1999-11-15','Simon-Pierre Cadieux; Methodex','Correct Tunisia Mining Grid','Tfm_nonpoly','19937','See also change record 99.811','Amended parameter 1 from 38.81924 to 38.81973; parameter 2 from 7.84257 to 7.83445; parameter 6 from 270.66603 to 270; parameter 7 from 581.95123 to 582.'),
(99.811,'1999-11-15','1999-11-15','EPSG','Update projection formulae','Tfm_method','9809  9812  9615  9816  9817','Also improved formula symbol font problems in 9801-8  and 9810. However reference to EPSG guidance note #7 where symbol fonts are not corrupted is recommended.','Corrected oblique stereographic (9809) formulae for R and n; oblique mercator (9812 and 9815) formulae for u and U''; Tunisia Mining Grid (9816) coefficients for lon(paris) and E; Lambert Conic Near Conformal (9817) formula for M''.'),
(99.82,'1999-11-11','1999-11-15','Simon-Pierre Cadieux; Methodex','Correct Spanish transformations','Trf_poly  Trf_method','1001-3  9617','','Change trf_poly 1001-1003 parameter 9 (coefficient E) from -13336.58 to -13276.58.  Amend example in trf_method 9617.'),
(99.83,'1999-11-15','1999-11-15','Simon-Pierre Cadieux; Methodex','Update area of interest to mention Nunavut','Tfm_nonpoly  HorizCS','1182  32610-19','','Added Nunavut to 1182 and 32610-13; replaced Northwest Territories by Nunavut in 32614-19.'),
(99.84,'1999-11-19','1999-11-19','EPSG','Version 4.4 release','','','Data update.  Changes through 99.79 but with actions still remaining on some earlier change requests.','Version 4.4 released'),
(99.85,'1999-12-01','1999-12-01','Simon-Pierre Cadieux; Methodex','Add NAD83(NSRS)','','','This was discussed in October 1999.  It was decided that the NSRS system for the US would be added once the adjustment was publicly released; estimated to be in 2002.','None - see comment'),
(99.86,'1999-12-02','1999-12-09','Rossano Carlotti; AGIP','Add Guinea data','','','','Added Dabola geodetic datum 6155 geogCS 4155; comment to geogCS 4315 (Conakry); projCS 2063 2064 (Dabola/UTM) 31528 31529 (Conakry/UTM); non_poly tfm 1517-8; trf_path 8898-9; geod_tfm 8498-9.'),
(99.861,'1999-12-02','2000-03-07','EPSG','Add Guinea Bissau data','','','','Added geodetic datum 6165; geogCS 4165; projCS 2095; non-poly tfm 1547; trf_path 8361; geod_trf 8539.'),
(99.87,'1999-12-06','2000-03-07','Simon-Pierre Cadieux; Methodex','Add Gunter''s link and Ramsden''s link','','','These are measuring tools, not units.  See change request 98.03','Advised reporter.'),
(99.88,'1999-12-07','1999-12-09','Simon-Pierre Cadieux; Methodex','Correct information source spellings','UOM_length','9005  9037-9','','Corrected url in information source from www.auslig.gov/au/geodesy/histry.htm to www.auslig.gov.au/geodesy/history.htm'),
(99.89,'1999-12-07','1999-12-09','Simon-Pierre Cadieux; Methodex','Correct Swiss transformation','Trf_non-poly  Trf_path  Geod_trf','1257  8561  8161','See change request 97.62 which changed geogCS name from Bern 1898 to CH1903.  The actions herein compliment that amendment.','Deleted trf_nonpoly 1257 and geod_trf 8161 replacing with 1519 and 8500 respectively.  Trf_path 8561 re-used but target CS amended from 4217 to 4149.'),
(99.9,'1999-12-07','2000-10-19','Simon-Pierre Cadieux; Methodex','Amend Canada CSRS area of use','HorizCS','4140 2036-38','','Changed area of use for 4140 from Canada - New Brunswick to Canada - NB, PEI   QC  AB & SK; amended remarks. Added/Corrected CS aliases 4140 2036-38.  Added projCS 2139-53.'),
(99.91,'1999-12-07','1999-12-09','Simon-Pierre Cadieux; Methodex','Delete obsolete unknown geodetic datum','Geod_datum  HorizCS','6017  4017','See change request 97.231 in which ellipsoid 7017 was deleted and replaced.','Delete unknown geod_datum 6017 and CS 4017.'),
(99.92,'1999-12-20','2000-03-07','Simon-Pierre Cadieux; Methodex','Add statute mile','','','','Added uom_length 9093.'),
(99.93,'1999-12-29','2000-01-06','Melita Kennedy; ESRI','Add new US HARNS','','','','Add non-poly tfm 1520-1526 and 1553-54; trf_path 8386-8399 and 8346-49; single geod_trf 8501-8507 and 8551-8552; concatenated geod_trf 8508-8514 and 8553-8554.'),
(99.931,'2000-01-06','2000-01-06','EPSG','Amend remarks for US HARNS','Trf_nonpolynomial','1474-1503','','Corrected remarks reference from code 4140 to code 4152 in non-poly tfm 1474-1503.  For non-poly tfm 1492 also changed information source.'),
(99.94,'1999-12-29','2000-01-06','Melita Kennedy; ESRI','Correct Austria projection parameters','Trf_nonpolynomial','19947','Reversed parameter 1 and 2 values.','Changed parameter 1 from 13deg 20 min to 47 deg 30 min and parameter 2 from 47 deg 30 min to 13deg 20 min.'),
(99.95,'1999-12-29','2000-03-07','Melita Kennedy; ESRI','Check name for Guatemala proj and projCS','Trf_nonpolynomial  HorizCS','18212  30262','','Changed name from Guatemale Sud to Guatemala Sur.'),
(99.96,'1999-12-29','2000-03-07','Melita Kennedy; ESRI','Check name for South Africa datum and CS','G_datum HorizCS Trf_nonpolynomial  Geod_trf','4148  6148  246-255  1504  1505  8449  8450','','Changed all spellings of Hartbeesthoek to Hartebeesthoek.'),
(99.97,'1999-12-29','2000-01-06','Melita Kennedy; ESRI','Check area of use for Japan projCS','Trf_nonpolynomial  HorizCS','17801-13  30161-73','','Amended area of use for zones I through XIII in both projection and projected CS records.'),
(99.98,'2000-01-06','2000-03-07','EPSG','Check axis abbreviations for South Africa and Namibia projCSs.','HorizCS','2046-2055  29371-29385  22275-22292','Codes 2046-2055 previously 246-255 - see change record 99.74.','Changed axis 1 abbreviation from W to Y; changed axis 2 abbreviation from S to X.'),
(99.99,'2000-01-06','2000-05-07','Alan Reid; Reid Geophysical','Harmonise POSC and EPSG unit abbreviations','UoM_Angle  UoM_Length  UoM_Scale','2046-2055  29371-29385  22275-22292','Codes 2046-2055 previously 246-255 - see change record 99.74.','Changed axis 1 abbreviation from W to Y; changed axis 2 abbreviation from S to X.'),
(2000.01,'2000-01-25','2000-06-10','Melita Kennedy; ESRI','Add Korean 95 CS and transformation','','','Is this KD85 or 95?','Added geodetic datums 6162 6166; geogCS 4162 4166; proj 18251-53; projCS 2096-98; tfm 1558; tfm path 8343; single_geod_tfm 8558.'),
(2000.02,'2000-01-25','2000-10-19','Melita Kennedy; ESRI','Add SIRGAS CS and transformation','','','','Added geodetic datum 6170; geogCS 4170; projCS 31917-22 and 31977-85; geodetic transformation 1581.'),
(2000.03,'2000-01-25','2000-03-07','Melita Kennedy; ESRI','Add NIMA Old Hawaiian geogCS and transformations','','','Deformations caused by tectonic motion cause problems with the integrity of this data.','Advised reporter.'),
(2000.04,'2000-01-26','2000-03-07','Roger Lott; BP Amoco','Add offshore Brazil transformation data','','','','Added tfm 1548-52; tfm path 8356-60; single_geod_tfm 8540-44.'),
(2000.05,'2000-01-28','2000-02-02','Roger Lott; BP Amoco','Correct Kazakststan transformation','Trf_non-poly','1303','','Corrected parameter 1 through 7 values from 43.661; -103.342; -124.117; 1.659; -0.824; 0.653 and 0.590 to 43.822; -108.842; -119.585; 1.455; -0.761; 0.737 and 0.549 respectively.'),
(2000.06,'2000-02-14','2000-03-07','EPSG','Amended NIMA transformation for Iran','Trf_non-poly','1141  8041','Changed source CS from ED50 to ED50(ED77).','Amended EPSG names for non-poly tfm 1141 and geodetic tfm 8041 from ''ED50 to WGS 84 (9)'' to ''ED50(ED77) to WGS 84 (2)''.'),
(2000.07,'2000-03-07','2000-03-07','EPSG','Change structure of prime meridian relationship in version 5.','Coordinate System','4801-4818  4901-4903','Prime meridian related to geodetic datum instead of geogCS.  Now consistent with ISO 19011 model.','In version 5 for each non-Greenwich geogCS 4801-17 & 4901-03 create a new geodetic datum 6801-17 & 6901-03; relate the relevant prime meridian to the datum; change the geogCS to relate to the new datum.'),
(2000.08,'2000-03-07','2000-03-07','EPSG','Modify parameter names for Tunisia Mining Grid method','Tfm_method','9816','This eliminates the ambiguous parameters ''Latitude of Origin'' and ''Longitude of Origin''.','Change parameters 1 2 6 and 7 from ''Latitude of Origin''  ''Longitude of Origin'' ''False Easting'' and ''False Northing''  to ''Latitude of False Origin''  ''Longitude of False Origin'' ''Easting at False Origin'' and ''Northing at False Origin'' respectively.'),
(2000.091,'2000-03-07','2000-03-07','EPSG','Remove unnecessary spaces from US State Plane CS zone names','HorizCS','26748 26750 26756-59 26766-74 26783-85 26796 26801 26803 26948 26956-57  26961-66 26968-74 26983-85 26996 26998 32007 32009-12 32014-15 32017 32019 32030 32036 32045 32055-58 32100 32104 32107 32110-11 32115 32117 32119 32130 32136 32145 32155-58','','Deleted double or trailing spaces from EPSG name.'),
(2000.092,'2000-03-07','2000-03-07','EPSG','Remove unnecessary spaces from US SP projection names and abbreviations','Trf_non-poly','10201 10203 10700 10901-02 11001-02 11101-03 11201-02 11301-02 11801-02 12101 12103 12401 12403 12701 12703 12800 13001 13003 13101 13103 14901-04 14931-34','','Deleted double or trailing space from EPSG name and abbreviation fields.'),
(2000.093,'2000-03-07','2000-03-07','EPSG','Remove unnecessary spaces from projection names','Trf_non-poly','10231 10233 12702  18171-75','','Deleted double or trailing space from EPSG name field.'),
(2000.094,'2000-03-07','2000-03-07','EPSG','Remove unnecessary spaces from projection abbreviations','Trf_non-poly','10600 10630 10730 11900 11930 12530 12630 12830 12900 12930 13200 13230 13800 13830 13930 14100 14130 14400 14430 15201-02 16061 16161 18113-14 18116','','Deleted trailing space from EPSG abbreviation field.'),
(2000.095,'2000-03-07','2000-03-07','EPSG','Correct transformation name','Trf_non-poly  Geod_trf','1333  8393','','Changed "... to WGS84" to "... to WGS 84" in EPSG name field for 1333.  Deleted double space in geod_trf EPSG name for 8393.'),
(2000.1,'2000-03-07','2000-03-07','Jean-Patrick Girbig; IHS Energy','Add Europe Gauss-Kruger zones and coordinate systems for Yugoslavia.','','','','Added proj 16261-68 and 16361-68; added ProjCS 31265-68.'),
(2000.101,'2000-03-07','2000-03-07','Jean-Patrick Girbig; IHS Energy','Amend Germany CS','HorizCS','31491-95','Changes name from DHDN / Germany zone x to DHDN / Gauss zone x.','Replaced Germany projCS 31491-95 with 31461-65 respectively.  Deleted proj 18101-05.'),
(2000.11,'2000-03-07','2000-03-07','EPSG','Correct spelling of Netherlands Vertical CS','VertCS','5709','','Changed EPSG name spelling from "Noormal Amsterdam Piel" to  "Normaal Amsterdam Peil".'),
(2000.12,'2000-03-07','2000-03-07','Rossano Carlotti; AGIP','Add Equatorial Guinea data','','','No information supplied.','None.'),
(2000.13,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Cuba data','','','','Added projCS 2084-85; tfm 1530; tfm path 8381; single_geod_tfm 8519.'),
(2000.14,'2000-03-07','2000-05-10','EPSG','Delete units for interpolation methods','Trf_non-poly','1241 1243 1312-13 1450 1451 1454-57 1461-64 1472 1474-1503 1506-07','Data file and coordinate system names do not have units.  Units are addressed within the application using the data file.','Delete units code.'),
(2000.15,'2000-03-03','2000-05-08','Bruno Ravanas; Total-Fina','Add Cabinda transformation data','','','','Added tfm 1557; tfm path 8344; single_geod_tfm 8557.'),
(2000.16,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Angola transformation data','Trf_non-poly','1321','','Changed parameter values 1 through 3 from -42.5  -342.5 and -228.1 to -41.8  -342.2 and -228.2 respectively.'),
(2000.17,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Argentina data','','','','Added geodetic datums 6160-61; geogCS 4160-61; projCS 2081-82; tfm 1527-28; tfm path 8383-85; single_geod_tfm 8515-16; concat_geod_tfm 8517.'),
(2000.18,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Argentina Tierra del Fuego data','','','','Added projCS 2083-4; tfm 1529; tfm path 8382; single_geod_tfm 8518.'),
(2000.19,'2000-03-03','2000-10-19','Bruno Ravanas; Total-Fina','Add Bolivia transformation data','','','','Added geodetic transformations 1582 and 1583.'),
(2000.2,'2000-03-03','2000-10-19','Bruno Ravanas; Total-Fina','Correct/add Colombia data','Geodetic Datum  Coordinate System  Coordinate Transformation','6218 6802 4218  4802 21817-18 21891-94 1125 1258 8174','','Changed name from "Bogota" to "Bogota 1975" throughout.  Added geod tfm 1597'),
(2000.21,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add UAE transformation data','','','','Added tfm 1531; tfm path 8380; single_geod_tfm 8520.'),
(2000.22,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Gabon data','','','','Added tfm 1532; tfm path 8379; single_geod_tfm 8521.'),
(2000.23,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Correct Indonesia transformation data','Trf_non-poly','1282','','Reversed signs of parameter values 2 and 3.'),
(2000.24,'2000-03-03','2000-10-19','Bruno Ravanas; Total-Fina','Add Iran data','','','Data offered either already in db or not in public use.','None'),
(2000.25,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Libya data','','','','Add geodetic datum 6159; geogCS 4159; Proj 16412; projCS 2068-80 2087.'),
(2000.26,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Myanmar data','','','','Added tfm 1533; tfm path 8378; single_geod_tfm 8522.'),
(2000.27,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Nigeria data','','','','Added tfm 1534; tfm path 8377; single_geod_tfm 8523.'),
(2000.28,'2000-03-03','2001-06-05','Bruno Ravanas; Total-Fina','Add Oman data','Coordinate Transformation','1439','','Amended version and added remarks to geod tfm 1439. Added geod tfm 1616-17 and concatenated tfm 8581. Added compound CRS 7410.'),
(2000.29,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Qatar data','HorizCS','4285  28600','','Amended geogCS name from Qatar to Qatar 1974; amended geogCS for projCS 28600 from Qatar 1948 (code 4286) to Qatar 1974 (code 4285).  Amended area of use of geogCS 4270 and projCS 27039.  Added tfm 1535-36; tfm path 8375-76; single_geod_tfm 8524-25.'),
(2000.3,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Thailand data','','','','Added tfm 1537; tfm path 8374; single_geod_tfm 8526.'),
(2000.31,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Tunisia data','','','','Added proj 16411; projCS 2088; tfm 1538; tfm path 8373; single_geod_tfm 8527.'),
(2000.32,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Venezuela data','','','Data offered either already in db or not in public use.','None.'),
(2000.33,'2000-03-03','2000-03-07','Bruno Ravanas; Total-Fina','Add Yemen data','','','','Added geodetic datums 6163-64; geogCS 4163-64; projCS 2089-92;  tfm 1539-40; tfm path 8370-72; single_geod_tfm 8528-29; concat_geod_tfm 8530.'),
(2000.34,'2000-03-07','2000-03-07','EPSG','Add International metre alias','','','','Added unit of measure alias 9091 (version 5 only).'),
(2000.35,'2000-03-07','2000-03-07','EPSG','Add Trinidad and Tobago data','','','','Added geod_datums 6157-58; geogCS 4157-58; projCS 2066-67.'),
(2000.351,'2000-03-07','2000-03-07','EPSG','Amend Trinidad and Tobago data','HorizCS  Tfm_non-poly','27120  1295 1307','','Amended abbreviation for projCS 27120 from ''Naparima / UTM 20N'' to ''Naparima 1972 / UTM 20N''.  Replaced single geod tfm 1295 with 1555 and geod tfm 8212 with 8555. Added tfm_nonpoly 1556; tfm_path 8345; geod_tfm 8556.'),
(2000.36,'2000-03-07','2000-03-07','EPSG','Add Egypt transformation data.','','','','Added tfm 1545-46; tfm path 8362-64; single_geod_tfm 8536 8538; concat geod tfm 8537.'),
(2000.37,'2000-03-07','2000-03-07','EPSG','Change Dutch projectedCS name.','HorizCS','28991-92','','Changed projCS names from RD / Netherlands New [Old] to Amersfoort / RD New [Old].'),
(2000.38,'2000-04-07','2000-04-08','Martin Daly;  Cadcorp','Remove double spaces from EPSG names','Trf_non-poly  HorizCS  Geod_trf','10201 10203 10231 10233 18171-5 26948 26958-59 26961-74 26983-84 26996 26998 32107 32115 32117 8393','These corrections already made - see change requests 2000.091-2000.094','Advised reporter.'),
(2000.39,'2000-04-20','2000-04-23','Melita Kennedy; ESRI','Correct Indian grid FE and FN','Tfm_nonpoly','18231-5  18238','Conversion from yards to metres transposed.','For 18231-5 amended parameter 6 from 2743185.69 to 2743195.5 and parameter 7 from 914395.23 to 914398.5;  for 18238 amended parameter 6 from 2743195.5  to 2743185.69 and parameter 7 from 914398.5 to 914395.23.'),
(2000.4,'2000-05-01','2000-10-19','Melita Kennedy; ESRI','Alternative definition for Belgium grid','Coordinate System; Coordinate Transformation; Transformation Method','31300  19902  9803','','Added proj 19961; projCS 31370. Added remarks to proj 19902; projCS 31300 and tfm method 9803.  Added geod tfm 1609-10.'),
(2000.41,'2000-05-02','2000-10-19','Jim Cain; Baker Hughes','Check War Office ellipsoid parameters.','Ellipsoid','7029','There has been confusion with foot-metre conversions.  See also change record 2000.71.','Added Length Unit 9094.  Changed War Office ellipsoid sma from 6378300.583 to 6378300; added alias and remarks.'),
(2000.42,'2000-05-03','2000-05-03','Gary Masters; POSC','Remove codes from unknown datums and geogCS','Geodetic Datum;  Coordinate System','6000-6045;  4000-4045','v5.0 only.','Amended names of unspecified datums and unknown geogCSs to include ellipsoid names rather than code.'),
(2000.43,'2000-05-01','2000-05-08','Melita Kennedy; ESRI','Add S-JTSK system for Czech Republic.','','','Already added. See 99.71.','Advised reporter.'),
(2000.44,'2000-05-10','2000-06-10','Simon-Pierre Cadieux; Methodex','Add transformation for Western Australia','','','','Added tfm 1559; tfm path 8341-42; single_geod_tfm 8559; concat geod tfm 8560.'),
(2000.451,'2000-06-10','2001-11-06','EPSG','Make forms and reports aesthetically consistent.','','','Not implemented in v5.','Implemented in v6.'),
(2000.452,'2000-06-10','2000-10-19','EPSG','Improve depiction of aliases on forms.','','','Implemented in v5.1of database','Changed access to Aliases from Command Button to embedded subform for all affected object types.'),
(2000.453,'2000-06-23','2001-11-06','EPSG','Move v5 Area table ISO fields to Alias table','','','','Retained in v6.1 Area table.'),
(2000.46,'2000-06-08','2000-06-10','Bruno Ravanas; Total-Fina','Add Suriname projCSs','HorizCS','24821','Suriname Stereographic not added as geodetic datum uncertain.','Added proj 17054 19954 19955; projCS 31154 31170 31171.  Deleted Suriname from area of use for 24821(PSAD56 / UTM 21N).'),
(2000.47,'2000-06-10','2000-06-23','Tony Maultsby; Conoco','Clarify Algeria Voirol Unifie','HorizCS  Geod_datum  Geod_trf Trf_path Trf_non-poly','4305 4812 30591-92 8158 8171 8177 8558 8574-75 1255 1267','','Replaced projCS 30591-92 with projCS 30791-92.  Deleted geogCS 4305 4812 geod datum 6305 6812. Added geogCS 4819 and to v5 only geod datum 6819.  Renamed tfm 1255 (and in v4.5 geod tfm 8158) from Voirol Unifie... to Nord Sahara....'),
(2000.471,'2000-06-10','2000-06-23','Tony Maultsby; Conoco','Clarify Algeria transformations','','','','Added non_poly tfm 1560; trf_path 8339-8340; geod_trf 8561-62.'),
(2000.472,'2000-08-15','2000-10-19','EPSG','Amend Algeria Lambert projection remarks','Coordinate Transformation','18021-22','Overlooked in change request 2000.47','Changed remarks from "Voirol Unifie 1960" to "Nord Sahara 1959".'),
(2000.481,'2000-06-26','2000-06-26','EPSG','Version 4.5 release','','','Data update.  Changes through 2000.47 but with actions still remaining on some earlier change requests.','Version 4.5 database to web site.'),
(2000.482,'2000-06-26','2000-06-26','EPSG','Version 5.0 release','','','Database structure update.  Changes through 2000.47 but with actions still remaining on some earlier change requests.','Version 5.0 database to web site.'),
(2000.49,'2000-06-21','2000-10-19','Richard Wylde; SIMA','Add new north Norway transformation','','','See 99.271 for area east of 5 deg E.','Added geod tfm 1588-90 and concatenated tfm 8569-70.'),
(2000.5,'2000-06-22','2001-11-06','Paul Hopgood; Hydrosearch','Link change table to records.','','','','Not considered to be necessary.'),
(2000.51,'2000-06-22','2001-11-06','Paul Hopgood; Hydrosearch','Link area table to records.','','','','Implemented in v6.1.'),
(2000.52,'2000-07-05','2000-10-19','Melita Kennedy; ESRI','Add American Samoa data','','','','Added geodetic datum 6169; geogCS 4169; proj 15300; projCS 2155-56; geodetic tfm 1577-79 8474-75'),
(2000.53,'2000-07-14','2000-10-19','Roger Lott, BP Amoco','Correct names for Qatar transformations','Coordinate Transformation','1210  1535-36','Effectively changes name from "Qatar to WGS 84" to "Qatar 1974 to WGS 84".','Deleted tfm 1210 and 1535.  Added tfm 1561 and 1562.  Changed area of use, info source and remarks for 1236.'),
(2000.531,'2000-07-14','2000-10-19','Roger Lott, BP Amoco','Add Qatar transformation','','','','Added tfm 1563.'),
(2000.54,'2000-07-19','2000-10-19','EPSG','Correct single geodetic transformation show fields','Coordinate Transformation','1100-1106  1470','','Change Show field from No to Yes.'),
(2000.55,'2000-08-04','2000-10-19','EPSG','Correct North Sea transformation remarks','Coordinate Transformation','1025','','Changed remarks comments A1-A15 and B1-B15 to A0-A14 and B0-B14.'),
(2000.56,'2000-09-05','2000-10-19','Richard Wylde; SIMA','Update Netherlands CS and transformation information','','','','Add compound CS 7408; geod tfm 1571; concat tfm 8572.  Amended remarks for geod datum 6289.'),
(2000.57,'2000-10-03','2000-10-19','Simon-Pierre Cadieux; Methodex','Add new Quebec transformation data and old projected CS','','','','Added geod tfm 1572-76 and concat tfm 8564-66.  Changed: area of use for 1463; remarks for 1451 1462 8243 8394 8404; version for 1313 1451 1462.  Added projCS 32098 and 2138.'),
(2000.58,'2000-07-29','2000-10-19','Alan Reid; Reid Geophysical','Resolve problem with running db under Access 2000 and NT','','','Converted MSAccess2000 problems with this database have not appeared when running under Win2000','Add comments to Readme file to indicate the operating system issue  when running Access2000.'),
(2000.581,'2000-08-03','2000-10-19','Mario Hilgemeier; Megatel','Provide Access 2000 version of db','','','See 2000.58','Comments made to readme file.'),
(2000.59,'2000-07-21','2000-10-19','Melita Kennedy; ESRI','Check bin grid scale units','Unit of measure','9204-11','','Changed UoM type from scale to length.'),
(2000.6,'2000-07-21','2000-10-19','Roel Nicolai; Shell','Correct Borneo RSO definition','Transformation Method; Coordinate System; Coordinate Transformation','9812  9815; 19912;  29871-73','The change of projection parameters to be consistent with source information requires a change of method.  19912 used method 9812, 19956-58 using method 9815 are equivalent.','Deleted projection 19912 and replaced it with 19956-58; amended projCSs 29871-73 to link to proj 19956-58 respectively instead of 19912.  Corrected formulae and examples for tfm methods 9812 and 9815.'),
(2000.601,'2000-10-19','2000-10-19','Roel Nicolai; Shell','Add Borneo transformation','','','','Added geod tfm 1592.'),
(2000.611,'2000-10-05','2000-10-19','Roger Lott; bp','Add British transformations','','','','Added transformation parameter 8664; transformation method 9633; geodetic transformation 1036; concatenated transformation 8567.'),
(2000.612,'2000-10-05','2000-10-19','Roger Lott; bp','Add Irish systems and transformation','Coordinate System','4230','','Added geodetic datum 6173; geogCS4173; proj 19962; projCS 2157-58; geod tfm 1611; concat tfm 8580.  Added Ireland to area of use for geogCS ED50 (code 4230).'),
(2000.62,'2000-10-06','2001-06-05','K R Santhosh; Coordinates India','Add Indian polyconic projection','','','Definition required.','Case closed as no info received from reporter.'),
(2000.63,'2000-10-03','2000-10-19','Andre Verville; Softmap','Add military grid reference system','','','Outside scope of EPSG db because it is an area indexing system, not a coordinate system.','Informed reporter'),
(2000.64,'2000-10-19','2002-01-18','EPSG','Allow forms and reports to include alias within filtering by name','','','','Completed on reports v6.1 but not possible on subforms.'),
(2000.65,'2000-10-19','2001-06-05','EPSG','Add facility for user logo on forms and reports','','','','Fully implemented in v5.2 and v6.0.'),
(2000.66,'2000-10-19','2000-10-19','EPSG','Correct New Brunswick transformation detail','Coordinate Transformation','1472','','Change tfm name from "ATS 77..." to "ATS77 ... " and file name from NT7783v2.gsb to NB7783v2.gsb'),
(2000.661,'2000-10-19','2000-10-19','EPSG','Add Canada maritime province interpolation tfms','','','','Added tfm method 9634; trfm parameter 8665; geodetic tfms 1603-08.'),
(2000.67,'2000-10-19','2001-08-15','EPSG','Replace concatenation of ITRF-based CRS to WGS84','','','','See change records 2001.221-2001.228'),
(2000.68,'2000-10-19','2000-10-19','EPSG','Correct binary transformation data for Western Australia','Coordinate Transformation','1559 8560','Changed most current file name from wa_0400.gsb to wa_0700.gsb','Added geod tfm 1593; concat tfm 8579.  Remarks added to tfms 1559 8560'),
(2000.681,'2000-10-19','2000-10-19','EPSG','Update binary transformation data for Australia','','1459 1464 8408','','Added geod tfms 1594-1596; concat tfms 8576-78  Remarks added to tfms 1459 1464 8408'),
(2000.69,'2000-10-19','2000-10-19','EPSG','Add country names to continental CS and transformations','Coordinate System; Coordinate Transformation','Many','','Amended Area of Use field as appropriate.'),
(2000.701,'2000-10-19','2000-10-19','EPSG','Add New Zealand GD2000 and transformations','','','','Added geodetic datum 6167 and geogCS 4167.  Added transformations 1564-1568 and 8563.'),
(2000.702,'2000-10-19','2000-10-19','EPSG','Amend New Zealand GD49 name','Coordinate System; Geodetic Datum; Coordinate Transformation','4272  27200  27291-92  6272  1151','','In geogCS 4272, projCS 27200 27291-92 and geodetic transformation 1151, changed name from GD49 to NZGD49; added alias GD49. Added second alias to geodetic datum 6272.'),
(2000.703,'2000-10-19','2000-10-19','EPSG','Add New Zealand meridional circuits','','','','Added proj 17901-28 and 17931-58; projCS 2105-2132 and 27205-27232.'),
(2000.704,'2000-10-19','2000-10-19','EPSG','Add New Zealand offshore UTM CS','','','','Added projCS 2133-2135 and 27258-27260.'),
(2000.71,'2000-10-19','2000-10-19','EPSG','Add pre-metric Ghana data','','','See also change record 2000.41.','Added UoM 9094; geodetic datum 6168; geogCS 4168; proj 17001 and 19959; projCS 2136-37; geodetic transformation 1569-70 and concat tfm 8571.  Added remarks to geod datum 6250 and proj 19904.'),
(2000.72,'2000-10-19','2000-10-19','EPSG','Change ETRF89 to ETRS89','Geodetic Datum; Coordinate System; Coordinate Transformation','6258;  4258  25828-38 25884; 1149 1273 1331 1437 8570','See change records 99.111 and 99.112','Changed ETRF to ETRS on names and added alias ETRF for geodetic datum 6258;  geogCS 4258, projCS 25828-38, 25884; geod tfm 1149 1309 1273 1310 1331 1437; concat tfm 8570.'),
(2000.73,'2000-10-19','2000-10-19','EPSG','Add French RGF93 CS','','','','Added geodetic datum 6171; geogCS 4171; geod tfm 1591; concat tfm 8573; proj 18085; projCS 2154'),
(2000.74,'2000-10-19','2000-10-19','EPSG','Correct Algeria geogCS axis abbreviations','Coordinate System','4819','','Changed axis 1 abbreviation from N to Lat and axis 2 abbreviation from E to Long.'),
(2000.75,'2000-10-19','2000-10-19','EPSG','Add Argentina POSGAR data','','','','Added geodetic datum 6172; geogCS 4172; geod tfm 1598'),
(2000.76,'2000-10-19','2000-10-19','EPSG','Add Genuk Alias for Batavia','Geodetic datum; Coordinate System; Coordinate Transformation','6211 4211 4813 21100 21148 21150','See also change record 99.58','Added aliases for Genuk to geodetic datum 6211; geogCS 4211 4813; projCS 21100 21148 21150'),
(2000.77,'2000-10-19','2000-10-19','EPSG','Expand area of use in Canada to always list applicable provinces','Coordinate System; Coordinate Transformation','Many','','Added all appropriate provinces to appropriate coordinate system and geodetic trf records except 1188 which is restricted by text data type limits.'),
(2000.78,'2000-10-19','2000-10-19','EPSG','Correct area of use for WGS 84 / UTM zones 20N; 33N; 34N; 35N','Coordinate System','32620 32633-35','','Amended truncated area of use fields for projCS 32620 32633-35.  Truncation happened when dataset moved from v4.4 to v5.0'),
(2000.79,'2000-10-19','2000-10-19','EPSG','Repair form for edit/add coordinate system (compound) to remove duplicate axes when ProjCS or VertCS is used in more than one compound coorinate system','','','','Changed sql statement from "select..." to "select distinct..."'),
(2000.8,'2000-10-19','2000-10-19','EPSG','Deleting records via forms does not delete associated aliases from alias table','All','','','Added warning to edit/add forms.'),
(2000.81,'2000-10-19','2000-10-19','EPSG','Add European vertical datums','','','','Added vertical datum 5129; vertical CS 5730; compound CS 7409.'),
(2000.82,'2000-10-19','2000-10-19','EPSG','Correct CS axis orientation','Coordinate System','32755','','Corrected second axis orientation from west to north.'),
(2000.83,'2000-10-19','2000-10-19','EPSG','Review Similarity Transformation reversibility','Transformation Method','9621','','changed  reverse transformation switch from "Yes" to "No" and changed reversibility of the four transformation parameters to be blank ; modified last sentence in formulae and added add''t sentence regarding non-reversibility of method.'),
(2000.84,'2000-12-31','2000-12-31','EPSG','Version 5.1 release','','','Database structure update.  Changes through 2000.47 but with actions still remaining on some earlier change requests.','Version 5.1 database to web site in final form'),
(2000.85,'2001-01-09','2001-06-05','Philippe Chessel; IHS Energy','Add Greenland Lambert projection data.','','','Danish mapping/geodetic agency KMS has no knowledge of these projections and no evidence of widespread public use has been furnished.','No action. Informed reporter.'),
(2000.861,'2001-01-12','2001-06-05','EPSG','Add aliases for Gold Coast foot (ftGC, foot).','Unit of Measure','9094','','Added aliases.'),
(2000.862,'2001-01-12','2001-06-05','EPSG','Order alias by naming system.','','','',''),
(2001.01,'2001-01-14','2001-11-06','Norm Berls; Geoquest','Check under Access 2000','','','Importing v97 db into  v2000 db under Windows2000 seems to prevent the instability caused by importation under Windows97.','None.'),
(2001.02,'2001-01-19','2001-11-06','EPSG','Add WGS84 geocentric CRS','','','Geocentric not actioned for v5.3.','Added CRS 4327 to v5.3 and v6.0; 4328 to v6.0 only.'),
(2001.03,'2001-02-05','2001-11-06','Paul Beaty, Georgia Tech','Add US feet for NAD83 SPCS','','','(Continued on record 2001.031\ufffd\ufffd\ufffd)','Added proj 15304-15371 and projCRS 2222-2289.  Remarks added to equivalent metric records. Added aliases to projCRS 2205; 26929-78; 26980-98; 32100-61.'),
(2001.031,'2001-02-05','2001-11-06','Paul Beaty, Georgia Tech','(\ufffd\ufffd\ufffd continued from 2001.300)','Coordinate Operation','15040, 15303 and 1ss3z (where 01=<ss=<52 and 0=<z<10) except 11631.','Applies to all NAD83 State Plane zones in metres.','For proj codes 15040, 15303 and 1ss3z (where 01=<ss=<52 and 0=<z<10) except 11631, replaced name and added previous name as an alias.'),
(2001.04,'2001-03-23','2001-06-05','Philippe Chessel; IHS Energy','Add Sierra Leone data','','','','Added geodetic datums 6174-75; geog CRS 4174-75; projCRS 2159-62; geod tfm 1614.'),
(2001.051,'2001-03-23','2001-06-05','EPSG','Correct spelling of POSGAR alias','Alias','4172','','Changed alias "National Geodetic System [Argenina]" to "National Geodetic System [Argentina]"'),
(2001.052,'2001-03-23','2001-06-05','EPSG','Add alias for Clarke 1880 (Arc) ellipsoid','Alias','7013','','Added aliases.'),
(2001.06,'2001-03-23','2001-06-05','EPSG','Add new offshore Norway transformations','Coordinate transformation','1450 1588-90 8046-47 8569-70','','Added geod tfm 1612 and 1613.  Added second alias for EUREF89 to geod tfm 1588-89.  Added remarks to geod tfm 1450,1588-90 and concatenated tfm 8046-47, 8569-70.'),
(2001.07,'2001-05-17','2001-06-05','Deborah Cruse; USGS','Add US National Atlas projection','Ellipsoid;  Geodetic Datum;  Coordinate Reference System','7035 6035 4035','','Deprecated 7035 4035 6035. Added ellipsoid 7047; datum 6047; geogCRS 4047; proj method 9820; proj 19965; projCRS 2163.'),
(2001.08,'2001-05-17','2001-06-05','Miguel Filgueiras; Univ. of Porto','Correct Lambert Conic Conformal and Mercator projection formulae.','Transformation Method','9801 9802 9804','Same changes made to Guidance Note #7.','Amended formula for t'' in methods 9801 and 9802;  for N and t in method 9804.'),
(2001.09,'2001-05-18','2001-11-06','EPSG','Add transformation methods','','','','Added proj methods 9821-23 and 9825; tfm method 9635; proj 19968; projCRS 32662.'),
(2001.091,'2001-06-05','2001-06-05','EPSG','Add UTM zoned systems','','','','Added coord operation parameters 8830-31; proj method 9824; proj 16000 and 16100; CRS 32600 and 32700.'),
(2001.1,'2001-04-08','2001-06-05','Dai Jones, IHS Energy','Add Clarke 1880 IGN General datum','','','Clarke 1880 (IGN) is an ellipsoid, not a datum.','Informed reporter.'),
(2001.11,'2001-04-08','2001-06-05','Dai Jones, IHS Energy','Clarify Cote d''Ivoire data','Coordinate reference system','4142 4143 4226','','Deprecated geogCRS 4226. Added proj 17005; projCRS 2164-65; aliases to geogCRS 4142-43.'),
(2001.12,'2001-05-18','2001-11-06','EPSG','Add EuroGeographics data','Operation Method','9809','See also 2001.55.','Added: alias to proj method 9809; proj 16269-75, 18086, 18281-5, 18300, 18305-8, 19966-67, 19969-70; datum 6178-85, 6191; geogCRS 4178-85, 4191; projCRS 2166-69, 2171-92, 2199, 3301, 20791, 27491; coord operation 1619-1664.'),
(2001.121,'2001-08-15','2001-11-06','EPSG','Reduce precision of Swiss transformation parameter values','Coordinate Operation','1510','3 decimal place precision of original info from BfL reduced to 1 dp to be consistent with information issued through EuroGeographics. Changed 1510 v4.4 parameter values from dX=674.374 to 674.4, dY=15.056 to 15.1 and dZ=405.346 to 405.3.','Deprecated in v6 and deleted from v5 code 1510. Added code 1766.'),
(2001.122,'2001-08-15','2001-11-06','EPSG','Rename transformation for east Germany','Coordinate Operation','1310','Effect is to replace Pulkovo 1942 to ETRS89 (1) with Pulkovo 1942(83) to ETRS89 (1).','Deprecated code 1310 v5.1.  Added code 1674.'),
(2001.13,'2001-05-18','2001-06-05','Roel Nicolai; Shell','Add new Netherlands transformation','','','Geodesia 2001-2 pp64-69 www.geodesia.nl','Not added to db - scientific use only.'),
(2001.141,'2000-06-22','2001-06-05','ISO 19127 project team','Add Antarctic CRS','','','','Added datum 6176; geog CRS 4176.'),
(2001.142,'2000-06-22','2001-06-05','ISO 19127 project team','Add New South Wales Integrated CRS','','','Insufficient data provided',''),
(2001.15,'2000-06-22','2001-11-06','ISO 19127 project team','Add South African and Namibian data','Ellipsoid;  Geodetic Datum','7006  6006 6293','Requested datum, projection and CRS data already in database.','Added ellipsoid 7046 Bessel Namibia (GLM); deprecated in v6.1 and deleted from v5.3 ellipsoid 7006. Amended geodetic datums 6006 and 6293 to reference ellipsoid 7046 rather than 7006.'),
(2001.16,'2001-05-17','2001-06-05','EPSG','Add Brunei transformation','Coordinate transformation','1592','','Added geod tfm 1615.  Added remarks and amended area of use for geod tfm 1592.'),
(2001.17,'2001-06-05','2002-01-26','EPSG','Add Greenland data','Datum; Coordinate Reference System; Coordinate Operation','6287; 4287; 1211','Changed  name from Qornoq to Qornoq 1927.  Future Greenland96 system not included as details not yet available.','Deprecated datum 6287 geogCRS 4287 and tfm 1211. Added areas 2556-73; proj conv method 9826; proj 18421-28 and 18432-37; CS 4501; datums 6194-96; geogCRS 4194-96; projCRS 2216-18 2221 and 2296-2307; tfm 1798-1800.'),
(2001.18,'2001-06-05','2001-06-05','EPSG','Correct Balkans CRS','Coordinate Reference System','31265-68','Replaced 31265-68 with 31275-78 to correct scale factor, and order of and abbreviation for axes.','Added proj 18275-78; projCRS 31275-78.  Deprecated in v6.0 and deleted from v5.2 codes 31265-68.  But see also change 2001.31.'),
(2001.181,'2001-06-05','2001-06-05','EPSG','Correct German CRS','Datum; Coordinate Reference System; Area','6314  31461-5  1628','ProjCRS 31462-65 replaced by 31466-69 respectively. ProjCRS 31461 not replaced.','Deprecated in v6.0 and deleted in v5.2 projCRS 31461-65; added projCRS 31466-69.  Corrected name and origin details for datum 6314.  In v6.1 only deprecated area 1628.'),
(2001.182,'2001-06-05','2001-06-05','EPSG','Correct Austria CRS','Coordinate Reference System','31291-31297','Replaced 31291-97 with 31281-87 to correct order of axes.','Deprecated in v6.0 and deleted from v5.2 codes 31291-97; added 31281-87.'),
(2001.183,'2001-06-05','2001-06-05','EPSG','Correct Austria transformation','Coordinate transformation','1471','Replaced 1471 with 1618 to correct sign of parameters.','Deprecated in v6.0 and deleted from v5.2 code 1471; added 1618.'),
(2001.19,'2001-06-23','2001-06-25','Melita Kennedy; ESRI','Correct GRS80 authalic sphere','Ellipsoid;  Geodetic Datum; Coordinate Reference System','7047 6047 4047 2163','Replaced 7047 with 7048 to correct value of parameters.','Deleted from v5.21 code 7047; added 7048.  Amended datum 6047 to reference 7048.'),
(2001.201,'2001-06-11','2001-06-11','EPSG','Version 5.2 release','','','',''),
(2001.202,'2001-06-25','2001-06-25','EPSG','Version 5.2.1 release','','','',''),
(2001.21,'2001-07-17','2001-07-17','EPSG','Correct Netherlands transformation','Coordinate Operation','1571','','See 2001.34'),
(2001.221,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via GDA94 with single tfms.','Coordinate Operation','See action','Effect is to replace 1m accuracy concat tfm 8396 by single tfm 1665, 8400 by 1666, 8576-77 by 1667-78 and 8194 by 1669 whilst deleting concat tfms of lower and higher accuracy.','Deprecated in v6.0 and deleted in v5.3 codes 8190 8192 8194 8396 8398 8400 8408 8453-54 8560 and 8576-79; added 1665-69.'),
(2001.222,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via ETRS89 with single tfms.','Coordinate Operation','See action','See also change records 2001.121 and 2001.122.','Deprecated in v6.0 and deleted in v5.3 codes 8183 8195 8199 8234 8236 8457 8567 8572-73 8580; added 1671-73 1675-81.'),
(2001.223,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via NZGD2000 with single tfms.','Coordinate Operation','8563','','Deprecated in v6.0 and deleted in v5.3 code 8563; added 1670.'),
(2001.225,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via NGN96 with single tfms.','Coordinate Operation','See action','','Deprecated in v6.0 and deleted in v5.3 code 8530; added 1682.'),
(2001.226,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via Moznet with single tfms.','Coordinate Operation','See action','','Deprecated in v6.0 and deleted in v5.3 codes 8215 8217 8219 8221 8223; added 1683-87.'),
(2001.227,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via NAD83 NAD83(HARNS) and NAD83(CSRS98) with single tfms.','Coordinate Operation','See action','','Deprecated in v6.0 and deleted in v5.3 codes 8243 8245 8388 8390 8392 8394 8404 8406 8418-22 8564-66; added 1688-1700 and 1702.'),
(2001.228,'2001-08-15','2001-11-06','EPSG','Replace concatenated transformations to WGS84 via NAD83 with transformations via NAD83(HARN).','Coordinate Operation','See action','Effect is to replace concat tfm 8386 for Hawaii and 8402 for Puerto Rico by tfms 8582 and 8583 respectively using Nadcon HARN file for second step instead of zero geocentric tfm.','Deprecated in v6.1 and deleted in v5.3 codes 8386 8402. Added single tfms 1741 and 1731 and concatenated tfms 8582-83.'),
(2001.229,'2001-08-15','2001-11-06','EPSG','Add transformations to WGS84 via NAD83(HARN)','','','Nadcon NAD83>NAD83(HARN) used for NAD83>WGS 84.','Added NAD83>WGS84 tfms 1708-30, 1732-40, 1742-50 and NAD27>NAD83>WGS84 concatenated tfms 8590-8630 [v6.0 only (not v5.3)].'),
(2001.23,'2001-08-17','2001-11-06','Melita Kennedy; ESRI','Correct error in New Zealand transformation parameter value','Coordinate Operation','1567','Sign of z-axis rotation corrected from 1.024 to -1.024','Deprecated in v6.0 and deleted from v5.3 code 1567. Added 1701.'),
(2001.24,'2001-08-15','2001-11-06','EPSG','Add additional US Nadcon data','','','See change record 2001.229 for versions to WGS 84.','Added tfms 1704-07; concatenated tfms 8586-89.'),
(2001.25,'2001-08-28','2001-11-06','Mark Tuttle; Shell Todd Oil Services','Add New Zealand TM projection','','','','Added conversion 19971 and projCRS 2193.'),
(2001.26,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct spelling of Czech/Slovak datum','Datum','6156 6818','(i) In v6.0 of the db, datum 6156 was deprecated and replaced by 6186, to which geogCRS 4156 repointed. This reversed for v6.1.  (ii) See change record 2001.51.','For datum 6156, name "Jednote Trigonometricke Siti Kataastrali" replaced by "Jednotn\ufffd\ufffd\ufffd Trigonometrick\ufffd\ufffd\ufffd S\ufffd\ufffd\ufffdte Katastr\ufffd\ufffd\ufffdln\ufffd\ufffd\ufffd". Alias for datum 6818 corrected to "Jednotn\ufffd\ufffd\ufffd Trigonometrick\ufffd\ufffd\ufffd S\ufffd\ufffd\ufffdte Katastr\ufffd\ufffd\ufffdln\ufffd\ufffd\ufffd".'),
(2001.27,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct name of Qatar datum','Datum','6285','(i) In v6.0 of the db, datum 6285 was deprecated and replaced by 6187, to which geogCRS 4285 repointed. This reversed for v6.1.  (ii) See change record 2000.29','For datum 6285, datum name "Qatar" replaced by "Qatar 1974".'),
(2001.28,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct information source for Korea data','Datum; Coordinate Reference System','6162 4162 2096-98','','Corrected information source.'),
(2001.29,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct remarks for Swiss data','Coordinate Reference System','21781','','In remarks, code 256 corrected to 2056.'),
(2001.3,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct Source CRS for Canada PEI','Coordinate Reference System','2291','','Deprecated in v6.0 and deleted in v5.3 code 2291 and replaced with 2292.'),
(2001.31,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct CRS for Balkans','Coordinate Reference System','31278','Error in map projection attached.  See 2001.18','Deprecated in v6.0 and deleted in v5.3 code 31278 and replaced with 31279.'),
(2001.32,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct data for American Samoa','Coordinate Operation; Coordinate Reference System','15300 2155-56','','Deprecated in v6.0 and deleted in v5.3 projection 15300 and CRS 2155; replaced with projection 15301 and CRS 2194. Deprecated in v6.0 and deleted in v5.3 projCRS 2156; added projCRS 2195.'),
(2001.33,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct area of use for Sirgas','Coordinate Operation; Coordinate Reference System','1581 4170','','Added Peru to area; corrected spelling of Uruguay.'),
(2001.34,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct transformation for Netherlands','Coordinate Operation','1571','Remarks for 8572 also amended to make clearer.','1571 deprecated in v6.0 and deleted in v5.3; replaced with 1751. Amended remarks in 1112 in v6.0 only (not v5.3).'),
(2001.35,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct transformation for Alberta','Coordinate Operation','1602','','1602 deprecated in v6.0 and deleted in v5.3; replaced with 1752.'),
(2001.36,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct information source for Belgium','Coordinate Operation','1609-10  19961','','Updated information source url.'),
(2001.37,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct transformation for Switzerland','Coordinate Operation','1508','Wrong unit for scale difference.','1508 deprecated in v6.0 and deleted from v5.3; replaced with 1753.'),
(2001.38,'2001-06-27','2001-11-06','Melita Kennedy; ESRI','Correct transformation for Nigeria','Coordinate Operation','1534','Wrong unit for scale difference.','1534 deprecated in v6.0 and deleted from v5.3; replaced with 1754.'),
(2001.39,'2001-08-28','2001-11-06','EPSG','Correct names of longitude rotations','Coordinate Operation','1258-59 1261 1263 1268-70 1466-68 1519','Transformation name did not correspond with target CRS name. " (Greenwich)" deleted from transformation names.','Deprecated in v6.1 and deleted from v5.3 tfm codes 1258-59 1261 1263 1268-70 1466-68 1519; added 1755-65.'),
(2001.4,'2001-08-28','2001-11-06','EPSG','Deprecate erroneous transformation for Alaska','Coordinate Operation','8497','Step 2 applies to lower 48, not Alaska.','8497 deprecated in v6.0 and deleted in v5.3.'),
(2001.41,'2001-08-29','2001-08-29','EPSG','Version 6.0 release to ISO 19127 project team.','','','Not a public release.','Version 6.0 release to ISO 19127 project team leader.'),
(2001.42,'2001-09-02','2001-09-02','EPSG','Version 6.02 release to ISO 19127 project team.','','','Not a public release.','Version 6.02 release to ISO 19127 project team.'),
(2001.43,'2001-09-09','2001-11-06','EPSG','Separate areas for Finland zone 3','Coordinate Reference System','2393','','Area for 2393 amended. Also added aliases to 2391-94.'),
(2001.44,'2001-09-09','2001-11-06','EPSG','Correct area for Deir','Datum','6277','V6.1 only.  Field does not apply to v5.  Error was introduced in v6.0.','Corrected area of use from Syria to Lebanon and Syria.'),
(2001.45,'2001-09-25','2001-11-06','Marc-Andre Morin; Altaphoto','Correct US Tennessee and Kentucky SP projections','Coordinate Operation; Coordinate Reference System','11631  14100  26979  32036','','Deprecated in v6.1 and deleted from v5.3 proj 11631 and 14100 and projCRS 32036 and 26979; added proj 15302-03 and projCRS 2204-05.'),
(2001.46,'2001-10-12','2001-11-06','EPSG','Add aliases for France NGF','Datum','5118-20','See change record 97.372.','Added further aliases to datums 5118-5120.'),
(2001.47,'2001-10-12','2001-11-06','EPSG','Deprecate Cote d''Ivoire datum','Datum','6226','Exists only as an alias for Abidjan and Locodjo (codes 6143 and 6142).  See change record 2001.11.','Deprecated in v6.1 and deleted from v5.3 datum 6226.'),
(2001.48,'2001-10-12','2001-11-06','EPSG','Correct Irish data','Coordinate Operation; Coordinate Reference System','19908  29900','','Deprecated in v6.1 and deleted from v5.3 proj 19908 and projCRS 29900; added datum 5130 5131 6188, proj 19972-73, geogCRS 4188, projCRS 29901-03, vertCRS 5731-32. Additional remarks added to geogCRS 4299 and 4300. Alias added to 4300.'),
(2001.49,'2001-10-25','2001-11-06','Mike Nottage; TotalFinaElf','Add Venezuela REGVEN data','','','','Added geod datum 6189 and geogCRS 4189; proCRS 2201-03; tfm param 8667; tfm method 9636; tfm 1767-72.'),
(2001.5,'2001-10-26','2001-11-06','EPSG','Add Danish data','','','Full definitions for older GI datum and Systems 34 and 45, plus polynomial transformations between these and ED50/UTM, not available.','Added proj 18401-03, projCRS 2196-98; vert datum 5132, vertCRS 5733.'),
(2001.51,'2001-10-31','2001-11-06','EPSG','Ensure names use only ASCII character set','Datum','6171 6172 6186','','In datum name, changed accented letters to non-accented ascii equivalent and added accented name as alias.'),
(2001.511,'2001-11-06','2001-11-06','EPSG','Correct German datum','Datum','6314','','Datum name Deutsche Hauptdreiecksnetz replaced by Deutsches Hauptdreiecksnetz; origin changed from Potsdam to Rauenberg.'),
(2001.52,'2001-11-06','2001-11-06','EPSG','Correct Swiss datum fundamental point','Datum','6150','','Change name of datum origin from Old Bern observatory to Zimmerwald observatory.'),
(2001.53,'2001-11-06','2001-11-06','EPSG','Clarify Argentina POSGAR realisation','Datum; Coordinate Reference System; Coordinate Operation','6172  4172  1598','Effect is to replace POSGAR with POSGAR98. POSGAR could be considered to be POSGAR94; the positional difference between POSGAR94 and POSGAR98 is not significant for most applications.','Deprecated in v6.1 and deleted in v5.3 datum 6172, geogCRS 4172 and tfm 1598. Added datum 6190, geogCRS 4190 and tfms 1773-74.'),
(2001.54,'2001-11-06','2001-11-06','EPSG','Correct names for French projections','Coordinate Operation; Coordinate Reference System','18081-84  19091-94; 27581-84  27591-94  7401-03','','Corrected names of proj 18081-84 and 18091-94; added aliases with former names.  Deprecated in v6.1 and deleted in v5.3 CRS 27581-84, 27591-94 and 7401-03; added 27561-64, 27571-74 and 7411-13.'),
(2001.551,'2001-11-06','2001-11-06','EPSG','Update EuroGeographics data','Coordinate Operation; Coordinate Reference System','1636-7; 18290-95, 18299; 2181-87','See 2001.13.  Some changes made to data on EuroGeographics web site added to EPSG v6.0. As v6.0 a non-public release the May 2001 data that has been updated has been deleted rather than deprecated in the EPSG database.','Deleted proj 18290-95, 18299 and replaced with 16269-75, projCRS 2181-87 and replaced with 2206-12, tfm 1636-7 and replaced with 1783-4.  Added date and remarks to datum 6207 and alias to CRS 4207.'),
(2001.552,'2001-11-06','2001-11-06','EPSG','Update EuroGeographics data (continued from 2001.551)','','','See 2001.13.  Some changes made to data on EuroGeographics web site added to EPSG v6.0. As v6.0 a non-public release the May 2001 data that has been updated has been deleted rather than deprecated in the EPSG database.','Added datum 6191, geogCRS 4191, projCRS 2199, tfm 1775-82 and 1785-88. Amended names of datums 6182-84 geogCRS 4182-84 and projCRS 2188-90.'),
(2001.56,'2001-11-06','2001-11-06','EPSG','Correct Portuguese data','Coordinate Operation; Coordinate Reference System; Datum','19970  27491  6207 6803','Projection longitude prime meridian changed from Lison to Greenwich','Deleted proj 19970 and projCRS 27491 and replaced with 19974 and 27492 respectively. Changed name of datums 6207 and 6803 to include Epoch date. Added aliases for datums 6207 6803, CRS 4207 4803 20790 20791.'),
(2001.57,'2001-11-06','2001-11-06','Bruno Ravanas; TotalFinaElf','Add Romanian data','','','','Added Area 2546, proj 16430, projCRS 2213, tfm1789.'),
(2001.58,'2001-10-26','2002-07-18','Bruno Ravanas; TotalFinaElf','Add Iran transformations','','','See 2000.24','Added area 2851-53; tfm 1854-58.'),
(2001.6,'2001-11-07','2002-06-22','Marc-Andr\ufffd\ufffd\ufffd Morin; Altaphoto','Add US Harns state plane projCRS','Area','1337','No HARNS for AK, NC or SC. That for PA to be completed during 2002.','Deleted AK, PA, NC and SC from area 1337. Added projCRS 2759-2930.  Added remarks to projCRS 2205 2222-63 2265-70 2274-89 26941-78 26980-98 32100-18 32120-27 32130-32 32134-58 32161.'),
(2001.61,'2001-12-11','2002-01-18','Alan Haugh; Hydrosearch','Add Montenegro transformation','','','','Added area 2547, tfms 1794-95.'),
(2002.01,'2002-01-02','2002-02-12','Jim Cain; Exxon-Mobil','Clarify Cameroon info.','Datum; Coordinate Reference System','6228 6234 6260  4228 4234 4260  22832 23433','','Deprecated datums 6228 6234 and 6260, geogCRSs 4228 4234 and 4260, projCRS 22832 and 23433. Added areas 2548-55 and 290-91, datums 6192-93 and 6197-98, proj 18411-17, geogCRS 4192-93 and 4197-98, projCRS 2214-15 and 2312-13, tfm1796 1805-06 and 8631-32.'),
(2002.02,'2002-01-18','2002-01-18','EPSG','Correct concatenated transformation 8583','Coordinate Operation','8583','Concatenated transformations should not include a method - this is shown in each step.','Deleted entry in method field.'),
(2002.03,'2002-01-18','2002-01-18','EPSG','Update EuroGeographics transformations for Portugal','Coordinate Operation','1656 1658','','Deprecated approximate tfm to WGS84 codes 1656 and 1658. Added tfm 1791-93. Amended remarks to tfm 1655 and 1657.'),
(2002.04,'2002-01-18','2002-01-18','EPSG','Add aliases to Ivory Coast data','Coordinate Operation; Coordinate Reference System','1469-70; 2040-43','','Added aliases.'),
(2002.05,'2002-01-18','2002-02-12','EPSG','Correct name for Congo datum','Datum','6282','Alias added to CRSs 4282 and 28232 and tfm 1200.','Changed datum name from "Pointe Noire" to "Congo 1960 Pointe Noire". Added tfm 1801-02.'),
(2002.06,'2002-01-18','2002-02-12','EPSG','Add Australian national transformations','Coordinate Operation','1506-07, 1593, 1596.','','Added tfm 1803-04. Added remarks to tfm 1506-07, 1593, 1596. Deprecated in v6.1 and deleted from v5.3 tfm 1559.'),
(2002.07,'2002-02-10','2002-07-13','Roel Nicolai for OGC','Review dmsh units for latitude and longitude','Unit of Measure','9107 9108 9110 9111','','Amended remarks to 9107 9108 9110 9111. Changed name of 9110 and 9111. Added alias to 9110. Added 9115.'),
(2002.08,'2002-02-06','2002-06-22','Yoshio Iwata; DPC','Add Japan JGD2000 data','','','','Added datum 6612; geogCRS 4612; projCRS 2443-61; tfm 1826.  Added remarks to datum 6301; geogCRS 4301; projCRS 30161-79. Amended url in info source for proj 17801-19, datum 5122 and 6301, geogCRS 4301, projCRS 30161-79, vertCRS 5723, tfm 1336-1436.'),
(2002.081,'2002-06-01','2002-06-22','EPSG','Correct area for Japan CRSs','Coordinate Reference System','30165-69 30175 30177-79','','For projCRS 30165-69 30175 and 30177-79, changed area codes from 1859-62 1858 1869 1871 1872 and 1868 to 1858-61 1862 1868 and 1870-72 respectively.'),
(2002.09,'2002-02-07','2002-02-12','Jim Cain; ExxonMobil','Add Nigerian data','','','','Added area 1717; proj 16406; projCRS 2311; tfm 1818-21.'),
(2002.1,'2002-02-10','2002-02-12','Jim Cain; ExxonMobil','Add Azerbaijan data','','','Additional remarks added to vertCRS 5706.','Added area 2592; vert datum 5133-34; vertCRS 5734-35; tfm 5402-04 and 1807-09.'),
(2002.11,'2002-02-10','2002-06-28','Tim Magee; Maersk','Add Former Soviet Union CS63 data','','','','Added areas 2772-2778, 2788; proj 18441-48; projCRS 2935-41, 2964.'),
(2002.12,'2002-02-10','2002-02-12','Roger Lott; BP','Add Trinidad data','','','','Added proj 19975 and projCRS 2314.'),
(2002.13,'2002-02-10','2002-02-12','Roger Lott; BP','Add Egypt data','','','','Added geod datum 6199; geogCRS 4199; area 2595; tfm 1810. Added aliases to datum 6229 and geogCRS 4229.'),
(2002.14,'2002-02-10','2002-02-12','Roger Lott; BP','Add South American data','','','','Amended area of use for area code 1815 (v6.1) and projCS 29122 (v5.3). Added area 2596-97; proj 19976; projCRS 2315-17; tfm 1811. Added alias to tfm 1516.'),
(2002.15,'2002-02-10','2002-02-12','Roger Lott; BP','Add Indonesian data','','','','Added proj 16409 16716 16732; projCRS 2308-10; tfm 1813-14.'),
(2002.151,'2002-03-06','2002-06-22','EPSG','Add Indonesian data','Datum; Coordinate Reference System; Coordinate Operation','6126 6294 6326; 4125 4294 4326-28 2309-10 32646-52 32747-54; 1126 1248 1282.','','Deprecated datum 6125 6294, geog CRS 4125 4294 and tfm 1282 1286 and replaced them with 6613, 4613 and 1834 respectively. Added datum 6820, geogCRS 4820, tfm 1832-33 and 1835-37, naming system 7311. Added aliases to datum 6326, geogCRS 4326-28, projCRS 2309-10 2933-34 32646-52 32747-54, tfm 1248. Extended origin description for datum 6326. For tfm 1126 Changed version from DMA-Col to DMA-Idn BBI.'),
(2002.16,'2002-02-10','2002-06-22','Roger Lott; BP','Add China data','Area; Datum; Coordinate Reference System','1118 1147; 5104; 5704 21413-23 21473-83.','','Added area 2711-31; ellipsoid 7049; geod datum 6610; geogCRS 4610; projCRS 2327-2390, 2401-2442. Amended names of areas 1118 (Hong Kong) and 1147 (Macau) to include non-ISO prefix "China - " and suffix "special administrative region". Changed name of datum 5104 from "Yellow Sea" to "Yellow Sea 1956" and added origin and epoch. Deprecated CRS 5704 and added CRS 5736. Added areas 2711-31; datums 5135-37 and 6611; proj 19978; CRS 2326-90 2401-42 4611 5737-39; tfm 1825 and 5405. Amended scope and added remarks to 21413-23. Deprecated projCRS 21473-83 and added 21453-63.'),
(2002.17,'2002-02-10','2002-02-12','Roger Lott; BP','Add Thailand data','','','','Added tfm 1812.'),
(2002.18,'2002-02-10','2002-02-12','Roger Lott; BP','Add Algeria data','','','','Added area 2598-2600 and tfm 1815-17.'),
(2002.19,'2002-02-10','2002-02-12','Roger Lott; BP','Add Kuwait data','','','','Added remarks to projCRSs 20438 and 24600.'),
(2002.2,'2002-02-10','2002-02-12','Barry Barrs; ExxonMobil','Add Saudi Arabia data','','','','Added proj 19977 and projCRS 2318.'),
(2002.21,'2002-02-12','2002-02-12','Jim Cain; ExxonMobil','Clarify units for US ''UTM'' foot zones','Coordinate Operation; Coordinate Reference System','15914-17; 32074-77','','For proj 15914-17, change name of proj "BLM zone xxN (feet)" to "BLM zone xxN (US survey feet)" and add old name as alias. Deprecated CRS 32074-77 and added CRS 32064-67.'),
(2002.22,'2002-02-12','2002-02-12','Melita Kennedy; ESRI','Delete duplicate Escambia county name','Area','2187','Also applied to v5.3 projCRS codes 2238, 26760 and 26960','Deleted second occurance of Escambia in Area of Use.'),
(2002.23,'2002-02-12','2002-02-12','Melita Kennedy; ESRI','Add Japan data','','','','See 2002.08'),
(2002.24,'2002-02-12','2002-02-12','Melita Kennedy; ESRI','Add Australian national transformations','','','','See 2002.06'),
(2002.25,'2002-02-12','2002-07-13','Melita Kennedy; ESRI','Check Portuguese data','Datum','6182 6184','','Amended EPSG aliases for datum 6182 6184. Amended origin description for 6184. Added area 2779, amended area 1314. Added datums 6615-16 geogCRS 4615-16 projCRS 2942-43. Deprecated datum 6185 geogCRS 4185 projCRS 2191. Added datum 6904, geogCRS 4904, proj methods 9827-28, proj 19979, CS 6509, projCRS 2963.'),
(2002.26,'2002-02-12','2002-02-12','EPSG','Correct spelling of Oslo PM','PrimeMeridian; Coordinate Reference System','8913; 27391-98','','In PM 8913 alias and remarks, Kristiana changed to Kristiania. In projCRS 27391-98, changed area of use Greenwich seconds from 20.5 to 22.5.'),
(2002.27,'2002-02-12','2002-06-22','EPSG','Fix v97 table relationships','','','Only affects building of forms and reports - no data or reporting problems.','No action taken.'),
(2002.28,'2002-02-22','2002-02-22','EPSG','Version 5.3 and v6.1 release.','','','',''),
(2002.29,'2002-02-28','2002-07-16','EPSG','Delete duplicate Nigeria transformation and add new data.','Coordinate Operation','1754  1819-22','','Deprecated tfm code 1819. For tfm code 1754 amended remarks and corrected ISO country code in Version from ''SHL-Nig S'' to ''SHL-Nga S''. Amended precision of tfm 1820 from dm to mm and 1821 from dm to cm. Added tfms 1822-24.'),
(2002.3,'2002-02-28','2002-06-22','EPSG','Correct remarks for spherical CS','Coordinate System','6404','','In remarks, changed "geographic" to "geocentric".'),
(2002.31,'2002-02-28','2004-03-17','Roel Nicolai for OGC','Add image datum subtype','Datum','','Unlikely that EPSG dataset will need to utilise this subtype.','Will be added after harmonisation of OGC spec and ISO model if needed to support data in db.'),
(2002.32,'2002-05-07','2002-06-22','EPSG','Deprecate duplicate Cameroon transformation','Coordinate Operation','1316','See change record 2002.01 - this action omitted.','Deprecated tfm 1316.'),
(2002.33,'2002-04-19','2002-07-18','EPSG','Add Libya data','','','','Added tfm 1859-63.'),
(2002.34,'2002-05-20','2002-06-22','EPSG','Add ISO country code for Palestine Territory.','Area; Datum; Coordinate Reference System','1356; 6141; 2039 4141 28193','Area code 1356 was being used by datum code 6281; proj 18201-02; and CRSs 4281 28191-92.','Added areas 2602-03. Changed area code 1356 from ''Israel and Jordan'' to ''Israel, Jordan and Palestine Territory''. Changed datum 6141, proj 18203-04 and CRSs 2039 4141 28193 from area code 1126 [Israel] to code 2603 [Israel and Palestine Territory].'),
(2002.341,'2002-05-20','2002-06-22','EPSG','Check ISO country codes','Area','1024-1261','','Changed Information Source for area codes 1024-1261 (from EPSG to ISO 3166 Maintenance Agency). Changed semicolon (;) to comma (,) in names of codes 1123 1134-35 1148 1161-62 1228. Added prefix ''The'' to name in codes 1148 and 1259. Deleted parentheses from codes 1161 1253-54. Moved abbreviations from before to after names for 1243-45. Changed spelling of code 1131 from Kazakhstan to Kazakstan. Changed ISO 3-character code from ROM to ROU for area code 1197. Changed ''St.'' to ''Saint'' in codes 1219-20.  Deleted ''Islands'' from 1223 and 1255. Added ''United Republic of'' to 1230.'),
(2002.342,'2002-05-20','2002-06-22','EPSG','Alter Change table action field','Change','','To accommodate longer descriptions of actions. Effective from db v6.2.','Amended Change table Action field from Text 255 to Memo.'),
(2002.35,'2002-05-20','2002-06-22','Roger Lott; BP','Add Turkey data','','','','Added CRSs 2319-2325. Added remarks to CRS 2206-2212.'),
(2002.36,'2002-05-20','2002-06-22','EPSG','Rationalise Gauss-Kruger zone names','Coordinate Operation; Coordinate Reference System','16202-32 16302-32 16261-75 16361-68 18031-37; 2091-92 2166-68 2199 20064-92 28462-92','','Added alias to transformation parameter code 8802 (longitude of natural origin). Added prefix ''6-degree '' to name of proj codes 16202-32 and 16302-32. Amended suffix from ''[zone]N'' to ''CM [cm][h]'' in proj codes 16302-32. Amended scope and remarks to proj 16202-32, 16302-32 and 16361-68. Added additional alias to Vietnam projCRSs 2044-45. Deprecated projCRSs 2091-92 (Yemen), 2166-68 (Germany) and 2199 (Albania) and added replacements 2395-96, 2397-99 and 2462 respectively. Added additional alias to Argentina proj 18031-37, projCRSs 22191-97 and 2081-83. Amended scope, added alias and remarks to Russia projCRS 20004-32 and 28402-32. Deprecated Russia projCRSs 20064-92 and 28462-92 and added replacements 2463-2522.'),
(2002.361,'2002-05-20','2002-06-22','EPSG','Add Russia 3-degree Gauss-Kruger zones','Area','1792-1805 1873-1992 2299-2306 2534-40','','Changed names of Area codes 1792-1805, 1873-1992, 2299-2306 and 2534-40. Added Area codes 2604-52 and 2747-69; Added proj codes 16070-94, 16170-94, 16201, 16233-60, 16276-99, 16301, 16333-60 and 16369-99. Added projCRS codes 2523-49, 2551-99, 2601-2735 and 2738-58.'),
(2002.37,'2002-05-23','2002-06-22','Gabor Timar; Eotvos University','Add and correct Hungary transformations','Coordinate Operation','1273 1677','1273 parameter values all have wrong sign. 1677 had an error in sign of dX relative to 1273 from which it was derived.','Deprecated transformations 1273 and 1677 and replaced them with 1829 and 1830 respectively.  Added tfm 1831.'),
(2002.38,'2002-05-28','2002-06-22','Anna Andersen; Andersen Petroleum Services','Clarify transformations for Senegal','Coordinate Operation','1101 1102 1104 1105','','Added remarks to transformation codes 1101 1102 1104 and 1105. Added transformations 1828 and 8633.'),
(2002.39,'2002-06-02','2002-09-19','EPSG','Add DMA WGS72 transformations','','','To supplement transformations to WGS 84 when not otherwise available. Several missing could be completed by other means - see Change record 2002.391. No further geogCRSs in db without tfm to WGS84 could be added through WGS72.','None.'),
(2002.391,'2002-09-19','2002-09-19','EPSG','Add missing transformations to WGS84','','','','Added tfm 1881-94; concatenated tfm 8636-45.'),
(2002.4,'2002-06-16','2002-06-22','Paul Dowd; FGPS','Check coordinate operation parameter value','Coordinate Operation','1025 1335','','Deprecated tfm 1335 and added replacement 1827. For tfm 1025 changed unit for latitude and longitude from degree/minute to degree.'),
(2002.41,'2002-06-22','2002-07-13','EPSG','Amend Canada CSRS data','Area; Coordinate Reference System; Coordinate Operation','1336; 4140 2036-38 2139-53 2291-92; 1472-73 1572 1574 1576 1599-1601 1752 8584','','Deprecated area 1336, geogCRS 4140, projCRS 4140 2036-38 2139-53 2291-92, tfm 1472-73 1572 1574 1576 1599-1601 1752 8584. Replaced them with area 2784, geogCRS 4617, projCRS 2944-62, tfm 1841-49 and 8635. Amended remarks for tfm 1688-89 1691-92 1696-97 1702-03 8585. Amended area of use for area 1449. Added tfm 1850-51.'),
(2002.42,'2002-06-22','2002-06-22','EPSG','Amend operation parameter value subforms.','','','','Amended browse tfm param value subforms to show dms units.'),
(2002.43,'2002-06-21','2002-06-28','EPSG','Add Niger data','Coordinate Reference System','4213','','Added Area 2771. Amended area of use for geogCRS 4213 from Niger to Niger SE. Added proj 16413, projCRS 2931; tfm 1839 and 8634.'),
(2002.431,'2002-06-21','2002-09-19','EPSG','Add Niger Point 58 data','','','','Added area 2790, datum 6620, geogCRS 4620, tfm 1880. Added remarks to datum 6201 and geogCRS 4201.'),
(2002.44,'2002-06-28','2002-07-13','Roel Nicolai for NAM','Add Dutch North Sea transformation','','','','Added tfm 1037 and 1038.'),
(2002.45,'2002-06-28','2002-06-28','EPSG','Add Qatar data.','','','','Added datum 6614, geogCRS 4614, projCRS 2932, tfm 1840.'),
(2002.46,'2002-07-07','2002-07-16','Paul Dowd; FGPS','Clarify codes table','','','','Codes table updated to ISO terminology.'),
(2002.47,'2002-06-07','2002-07-13','Roar Nilsen; PGS','Add east Malaysia transformation','Coordinate Operation','1592','','Added area 2780, tfm 1852. Added remarks re Lela field to tfm 1592. Added remarks re metric supersession to proj 1956-57 and projCRS 29871-72.'),
(2002.48,'2002-07-13','2003-01-21','EPSG','Correct and add Swedish data','Coordinate Operation; Datum','1437 1680 1787 1788; 5117','Awaiting decision on projected CRS(s) to be associated with the SWEREF99 geogCRS - see 2002.482.','Added datum 6619, geogCRS 4619, transformations 1878-79. Deprecated tfm 1787-88 and added replacements 1895-96. Changed remarks in tfm 1437 and 1680 to reference 1895 and 1896. Corrected spelling of name of vertical datum 5117.'),
(2002.481,'2002-07-13','2003-09-01','EPSG','Add Swedish RT projCRS data','Coordinate Operation; Coordinate Reference System','19929; 2400 30800','','For proj 19929 reversed name and alias and changed remarks. Deprecated projCRS 30800 and 2400. Added area 2845-50; proj 17334-38; projCRS 3019-3030.'),
(2002.482,'2002-07-13','2004-01-07','EPSG','Add Swedish SWEREF projCRS data','','','','Added area 2833-44; proj 17321-33; projCRS 3006-3018.'),
(2002.49,'2002-07-16','2002-07-16','EPSG','Add alias to Egypt Blue Belt','Coordinate Operation; Coordinate Reference System','18071; 22991','','Added alias to proj 18071 and projCRS 22991'),
(2002.5,'2002-07-16','2002-09-19','Bruno Ravenas; TotalFinaElf','Review ellipsoid for SAD69','Ellipsoid; Datum; Coordinate Reference System; Coordinate Operation','7003 7036; 6291; 4291; 29100 29118-22 29177-85; 1212-24 1548.','SAD69 uses GRS 1967 ellipsoid but with 1/f to 2 decimal places.','Added ellipsoid 7050; additional remarks to 7003 and 7036. Deprecated datum 6291; geogCRS 4291, projCRS 29100 29118-22 29177-85; transformations 1212-24 and 1548. Added as replacements datum 6618; geogCRS 4618, projCRS 29101 29168-72 29187-95; transformations 1864-77.'),
(2002.51,'2002-07-16','2002-07-31','EPSG','Review coordinate operation formulae','Coordinate Operation Parameter; Coordinate Operation Method','8806 8807; 9636 9808','Also reviewed and if necessary amended remarks for all operations to bring into consistency with ISO19111 terminology (these changes having no practical consequences). Formulas in db brought into consistency with August 2002 revision of GN7.','Added alias and made minor amendment to description of coord op param 8806-07. Corrected formulas for 9808. Added formulas for 9636.'),
(2002.52,'2002-07-25','2002-07-31','Melita Kennedy; ESRI','Correct Kazakstan spelling and review addition of CS63 K1 zone','Area','1284; 1291; 1357; 1798; 1799-1804; 2074-2088; 2314; 2405','Check compliance with ISO country spelling and review possible addition of K1 zone','CS63 K1 zone not added as there is no evidence of its actual usage; changed spelling from Kazakhstan to Kazakstan in affected records 1284; 1291; 1357; 1798; 1799-1804; 2074-2088; 2314; 2405'),
(2002.53,'2002-07-31','2002-07-31','EPSG','Version 6.2 release','','','',''),
(2002.54,'2002-08-12','2002-08-13','EPSG','Delete spurious deprecation record','Deprecation','38','Refers to datum code 6314 which remains valid.','Deleted this spurious record.'),
(2002.55,'2002-08-12','2002-08-13','EPSG','Complete change record 2002.33 action.','','','','Added action to record in this table.'),
(2002.56,'2002-08-16','2002-08-29','EPSG','Correct nomenclature in Algeria CRS remarks.','Coordinate Reference System','4307 30791-92','','Changed remarks for geogCRS 4307 and alias remarks for projCRS 30791-92 to conform to ISO terminology.'),
(2002.57,'2002-08-07','2002-09-19','Gerhard Somer; Magistrat Wien','Clarify Austria projected CRS updates','Coordinate Operation; Coordinate Reference System','1757; 18041-46; 31281-86','Change request 2001.182 refers','Amended scope and remarks for proj 18041-43. Amended scope and remarks and added 2nd alias to projCRS 31281-83. Amended remarks for proj 18044-46 and projCRS 31284-86. Added proj 18047-49 and projCRS 31288-90. Corrected area of use for tfm 1757 and projCRS 31282-83.'),
(2002.58,'2002-08-13','2002-09-19','Chas Dense; AK Div of Government Coordination','Add Alaska Albers projection','','','ProjCRS based on NAD27 to be included in v6.3; further investigation required for NAD83-based projCRS.','Added proj 15020 and projCRS 2964.'),
(2002.59,'2002-06-16','2002-09-13','EPSG','Add AMS projections','','','Unable to ascertain geodetic datum with which the projections are associated - CRS therefore incomplete - request rejected.','None.'),
(2002.6,'2002-08-20','2002-09-05','EPSG','Fix VBA compilation errors.','','','','Amended VBA code behind all form controls.'),
(2002.61,'2002-08-24','2002-08-24','EPSG','Correct China record deprecation trail','Coordinate Reference System','5704','See change record 2002.16.','Reference to change id in deprecation trail of deprecated record 5704 changed from 2002.33 to 2002.16.'),
(2002.62,'2002-08-29','2003-01-21','Roger Lott; BP','Add new UK and Ireland data','Coordinate Operation','1314','','Deprecated tfm 1681. Added area 2792-2803, vert datum 5138-5148, vertCRS 5740-50; coord op param 8668-8693, coord op method 9637, tfm 1039-42. Amended remarks to tfm 1036. Added remarks to geod datum 6277. Amended name of datum 5131 and added previous name as abbreviation; added abbreviation to vertCRS 5732. Changed remarks for tfm 1314 to refer to 1039 rather than 1036.'),
(2002.621,'2002-09-13','2003-09-01','EPSG','Correct Ireland CRS/Tfm inconsistencies','Datum; Coordinate Reference System; Coordinate Operation; UoM','6299 6300; 4299 4300; 1229 1640-41 5401; 9095.','','For datum 6300 changed name from TM75 to Geodetic Datum of 1965 and added aliases and remarks. Added remarks to datum 6299 and CRSs 4299 and 4300. Deprecated tfm 1229 and 1640. Changed remarks for tfm 1641. Added tfm 1953-56. Deprecated tfm 5401 and replaced it with 5406. Added UoM 9095, Coord Sys 6496, datum 5152, CRS 5754, tfms 5407-08. Added additional info source for Ireland to UoM 9095.'),
(2002.622,'2002-09-13','2003-09-01','EPSG','Correct Ireland ellipsoid inconsistencies','Ellipsoid','7002','','Amended remarks and added information source.'),
(2002.63,'2002-09-05','2002-09-05','EPSG','Version 6.2.1 release','','','See change record 2002.60.',''),
(2002.64,'2002-09-13','2002-09-19','EPSG','Correct Morocco projection and add Western Sahara data','Area; Coordinate Operation; Coordinate Reference System','1704-05; 18131-33; 26191-93','','Added aliases to proj 18131-32 and projCRS 26191-92. Amended area of use for proj 18132 and projCRS 26192. Deprecated areas 1704-05, proj 18133 and projCRS 26193. Added areas 2787-89, proj 18134-35 and projCRS 26194-95.'),
(2002.65,'2002-09-13','2002-09-19','EPSG','Add Iran vertical CRS data','','','','Added datum 5149-50; vertCRS 5751-52.'),
(2002.66,'2002-09-13','2002-09-13','EPSG','Add Angola Cabinda transformation','','','','Provenance of data not proven. No action taken.'),
(2002.67,'2002-09-13','2005-04-11','EPSG','Add Brazil offshore transformations','','','Further investigation required',''),
(2002.68,'2002-09-13','2003-01-21','EPSG','Correct problem in Browse Transformation form in Access2000 SR1.','','','','Revised forms included in v6.3.'),
(2002.69,'2002-09-16','2002-09-16','EPSG','Version 6.2.2 release','','','See change record 2002.60.',''),
(2002.7,'2002-09-19','2002-09-19','EPSG','Correct revision date','Coordinate Operation','1592','','Revision date changed from 15-Oct-02 to 15-Oct-00.'),
(2002.71,'2002-09-19','2002-09-19','EPSG','Order edit/add alias form deprecation trail','','','','Added sort ascending to Replaced By field on subform Deprecation Trail Area.'),
(2002.72,'2002-09-19','2003-01-21','EPSG','Correct Portuguese transformations','Coordinate Operation','1656 1791 1793','','Deprecated tfm 1656, 1791, 1793. Replaced with tfm 1944-45. Amended remarks for tfm 1790 and 1792.'),
(2002.73,'2002-09-19','2002-11-18','EPSG','Correct Indonesian transformations','Coordinate Operation','1834 1835 1836','Changed source CRS code from 4294 to 4613.','Deprecated tfm 1834-36 and replaced these with 1897-99.'),
(2002.74,'2002-09-19','2002-09-19','EPSG','Correct reference in France transformation','Coordinate Operation','1764','Tfm 1467 was deprecated and replaced by 1763 (see change 2001.39), but reference to 1467 in tfm 1764 was missed.','Changed remarks reference from preferred code 1467 to code 1763.'),
(2002.75,'2002-09-19','2002-09-19','EPSG','Amend general polynomial formulae','Coordinate Operation Method','9625-27','Formulae in Guidance Note 7 use superscripted suffixes and these did not transcribe.','Added power (^) signs where missing in formulae.'),
(2002.76,'2002-09-19','2002-09-19','EPSG','Amend scope for transformations.','Coordinate Operation','1444 1518','Taken from NIMA TR8350.2.','Amended scope and remarks for tfm 1444 and 1518.'),
(2002.77,'2002-10-11','2002-11-18','Alain Robert; Kodak','Correct US Indiana NAD83 ft SP projections','Coordinate Operation; Coordinate Reference System','11331-32 15326-27; 2244-45 2792-93 2889-90','','Deprecated proj 15326-27 and projCRS 2244-55 2889-90. Added replacement proj 15372-73 and projCRS 2965-68. Amended CRS code reference in remarks for proj 11331-32, projCRS 2792-93 and projCRS 26973-74.'),
(2002.771,'2002-10-13','2002-11-18','EPSG','Correct US HARN CRS remarks','Coordinate Reference System','2761-63 2766-81 2787-89 2792-93 2798-99 2804-09 2813-14 2818 2825-33 2836-39 2843-51 2853-56 2859-61 2867-88 2891-2930','','Amended CRS code reference in remarks.'),
(2002.78,'2002-10-21','2003-01-21','Akira Uematsu; NEC','Add WGS84 CRS with alternative CS','Unit of Measure','9107 9108 9110 9111 9115','See also 2002.85 for amendments to remarks of CS 6401-02.','For UoM 9107, 9108, 9110, 9111 and 9115 amended target UoM from 9101 to 9102 and also amended remarks. Added UoM 9116-21; added Coord Operation Methods 9637-44; added Coord Conversions 101-108; added Coord Systems 6405-21; added WGS 84 codes CRS 63266405-20. Added geog2D (deg) CRS codes 6***6405 where *** = 120-124, 126-171, 173-176, 178-184, 188-216, 218-225, 227, 229-233, 236-259, 261-286, 288-289, 292-293, 295, 297-304, 306-319, 322, 324, 600-616, 618-640, 650-655, 801-806, 808-809, 813-815, 818, 820 and 903-903. Added geog3D (deg) CRS codes 6###6413 where ### = 126, 130, 140, 148, 151, 152, 163, 167, 170, 171, 173, 176, 180, 189, 190, 258, 283, 612, 619, 624, 627, 640 and 645.'),
(2002.79,'2002-10-25','2002-10-25','Milan Trninic; Galdos','Correct deprecation record inconsistency','','','See change record 2002.54','Advised correspondent'),
(2002.8,'2002-10-25','2002-11-18','Milan Trninic; Galdos','Make alias table object type field entries consistent in case','','','','Where necessary, changed "datum" to "Datum".'),
(2002.81,'2002-09-13','2003-01-21','EPSG','Check Sudan datum','Coordinate Reference System; Datum','4296, 29635-36; 6296','','Amended area 1552-53; added area 2825-27. Deprecated CRSs 4296 and 29635-36, datum 6296. Added projCRS 20134-36.'),
(2002.82,'2002-11-01','2002-11-18','EPSG','Correct area text','Area','2286','','Added closing parenthesis around NSW in area name.'),
(2002.83,'2002-11-01','2003-01-21','EPSG','Review NAD83 ITRF transformations','Coordinate Operation','1308 1515 1850','','Deprecated tfm 1308 and 1515. Added tfm 1900-01, 1946. Corrected variant for tfm 1850 from 2 to 3.'),
(2002.84,'2002-11-01','2003-01-21','EPSG','Check Cameroon data','Coordinate Reference System','2215 4193 4197','','Deleted remarks from geogCRS 4197. In remarks for geogCRS 4193 corrected spelling of Bukavu and changed datum to CRS. Added remarks to projCRS 2215. Added tfm 1902 and concat tfm 8646.'),
(2002.85,'2002-11-07','2002-11-18','EPSG','Correct ellipsoidal CS unit description.','Coordinate system','6401-03','See also 2002.78','Corrected order of north and east in CS name for CS 6401-03.  Added additional remarks to CS 6401-02.'),
(2002.86,'2002-11-07','2002-11-18','Alan Haugh; Hydrosearch','Correct angle unit remarks','Unit of Measure','9102-06 9112-13.','','Added "radians" to formula within remarks for UoM 9102-06 and 9112-13.'),
(2002.87,'2002-11-11','2003-01-21','Georg Haefele; IABG','Add Comoros data','','','No transformation information available from IGN.','Added Area 2807-09, datum 6646, geog CRS 4646 and projCRS 2999.'),
(2002.871,'2002-11-11','2003-02-25','EPSG','Add French Overseas Territories data','Coordinate Reference System; Datum; Area','4235; 6235; 1099','','Added Area 2810-2824, CS 4492, datum 6621-6645, geog CRS 4621-45, proj 19981-83, projCRS 2969-73, 2975--90 and 2995-98, tfm 1903-1934. Deprecated datum 6235 and CRS 4235. Added remarks to area 1099.'),
(2002.88,'2002-11-11','2003-09-30','Georg Haefele; IABG','Add Iceland data','','','','Added Area 2851-53; ellipsoid 7051, datum 6657-59; proj 19987-89; geogCRS 4386 4657-59 66576405 66586405 66596405 66596413; geocenCRS 4387; projCRS 3052-57; tfm 1951-52 and 1994.'),
(2002.89,'2002-11-27','2003-01-21','EPSG','Add ITRF','Datum','6326','','Added datums 6647-56; geocentric CRSs 4330-38 and 4385, tfm 1935-43. Added remarks to datum 6326 (WGS84).'),
(2002.9,'2002-12-02','2002-12-09','EPSG','Correct remarks for Netherlands transformations','Coordinate Operation','1112, 1672','Corrected incorrect reference to Amersfoort to ETRS89 (2) to ETRS89 (1).','Amended remarks for transformations 1112 and 1751.'),
(2002.91,'2002-12-17','2003-01-21','OGC','Add US Oregon projection','','','','Added proj 13633 and 15374; projCRS 2991-94.'),
(2002.92,'2002-12-18','2003-01-21','Melita Kennedy; ESRI','Correct formula for spherical radius','Coordinate Operation Method','9823','Changed formula for R from R = b to R = sqrt(Mo * No). Also amended GN7.','Changed formula for R.'),
(2002.93,'2002-12-18','2003-01-21','EPSG','Correct CS axes for UPS','Coordinate Reference System','32661, 32761','','Added CS 4493-94. Amended CRS 32661 and 32761 to use these CS.'),
(2002.94,'2002-12-18','2003-09-30','EPSG','Include coordinate operation formula rather than citations','Coordinate Operation Method','9820 9822 9827 9828','','Added formula to methods 9820 9822 9827 9828; example to method 9820.'),
(2002.95,'2002-12-18','2003-01-31','Norm Berls; Geoquest','Correct Krovak formula','Coordinate Operation Method','9819','Also corrected GN7. Note: date closed wrongly documented in v6.3 and corrected in v6.4.','Corrected formula and amended example for coord op method 9819.'),
(2002.96,'2002-12-18','2006-03-16','EPSG','Check Oblique Stereographic formula','Coordinate Operation Method','9809','Descrepancy in implementations of about 0.06m has been reported.','Investigation to be actioned when resources permit.'),
(2002.97,'2002-12-18','2003-01-21','EPSG','Amend show CRS switch setting','Coordinate Reference System','4188','','Changed Show? from No to Yes.'),
(2003.01,'2003-01-03','2003-01-08','Martin Daly; Cadcorp','Review precision of British National Grid parameters','Coordinate Operation','19916','This change will affect conversions by a maximum of 0.4mm. This is not considered to be a critical change: parameter value has been amended rather than deprecated and replaced. Note: date closed wrongly documented in v6.3 and corrected in v6.4.','Changed SF value from 0.999601272 to 0.9996012717. Included change record reference in dependent projCRS 27700.'),
(2003.02,'2003-01-15','2003-01-21','Frank Warmerdam','Correct projCRS prime meridian and projection inconsistency','Coordinate Reference System','2934 21100 25700 26591-92','This deprecation and replacement effectively renames the CRSs.','Deprecated CRSs 2934, 21100, 25700, 26591-92 and replaced them with 3000-3004. Added remarks regarding longitude reference to proj 18041-43, 18047-49, 18081-84, 18091-94, 18221-28, 19901, 19903, 19911, 19921, 19923, 19936-37, 19952, 19969, 19979.'),
(2003.021,'2003-02-04','2003-02-05','Bernard Snyers; Ionic Software','Correct Italy prime meridian and projection inconsistency','Coordinate Reference System','26591-92','See change record 2002.020','Advised correspondent.'),
(2003.03,'2003-01-21','2003-09-30','EPSG','Add Netherlands transformation','','','','Added tfm 1960-61.'),
(2003.04,'2003-01-31','2003-09-30','EPSG','Add French Overseas Territories vertical datums','','','','Added datums 5153-56 and vertCRSs 5755-58.'),
(2003.041,'2003-06-20','2004-04-27','EPSG','Add French datum transformations','','','','Added coord op param 8727, coord op method 9655, tfms 1053-54.'),
(2003.05,'2003-02-05','2003-02-05','Frank Warmerdam','Correct scale factor unit','Coordinate Operation','18441 18442','','Amended unit of measure for scale factor from "US survey foot" to "Unity".'),
(2003.051,'2003-02-05','2003-02-06','EPSG','Correct rotation unit','Coordinate Operation','1026 1027','','Amended unit of measure for parameter B00 from "coefficient" to "arc-second".'),
(2003.052,'2003-02-16','2003-02-17','EPSG','Correct Scale Factor and False Easting unit of measure names','Coordinate Operation','16376','','Amended unit of measure for parameter scale factor from "meter" to "unity" and amended unit of measure for parameter False Northing from "unity" to "meter".'),
(2003.06,'2003-02-06','2003-02-06','EPSG','Amend country name for Yugoslavia','Area','1258','Follows change of country name to Union of Serbia and Montenegro. ISO3166 yet to be updated.','Added "Union of Serbia and Montenegro" to Yugoslavia.'),
(2003.07,'2003-02-17','2003-02-17','EPSG','Correct alias','Coordinate Operation','1274','','Deleted aliases and replaced with corrected alias.'),
(2003.08,'2003-02-25','2003-02-25','EPSG','Correct Canada Maritme Provinces transformation','Coordinate Operation','1604-08','','Corrected area of use and version for tfm 1604-05 which were transposed. Deprecated tfm 1606-08 and replaced with 1947-49. Added tfm 1950 and concatenated tfm 8657.'),
(2003.09,'2003-02-26','2003-02-26','EPSG','v6.3 release.','','','',''),
(2003.1,'2003-04-29','2003-09-30','EPSG','Add BC Albers projection','','','','Added area 2832, projection 19984 and projected CRS 3005.'),
(2003.11,'2003-05-01','2003-06-27','Simon Cox','Add geogCRSs with axes long-lat and in decimal degrees','','','EPSG recommends that ISO 670-9 order (latitude, longitude) be adhered to for data exchange.','Notified reporter.'),
(2003.12,'2003-05-15','2003-06-06','Roar N Nilsen; PGS','Verify ellipsoid for M''Poraloko datum','','','M''Poraloko datum and CRS implemented by Elf; confirmed that the Clarke 1880 (IGN) ellipsoid was used. Records which indicate Clarke 1880 (RGS) ellipsoid used are not correct.','Notified reporter 6/6/03.'),
(2003.13,'2003-06-09','2003-09-30','EPSG','Add Pan-European data','','','','Added area 2854-68 and 2881; proj 19985-86; projCRS 3034-35 and 3038-51.'),
(2003.14,'2003-06-17','2003-09-30','EPSG','Add Jan Mayen data','','','','Added Area code 2869, proj 19991, datum 6660, geogCRS 4660 and 66606405, projCRS 3057, tfm 1957.'),
(2003.141,'2003-06-17','2003-09-30','EPSG','Clarify usage in Norwegian dependencies.','Area','1296 1635-38 2056 2062 2064 2066 2332 2601','','Deleted Jan Mayen from area codes 2062 2064 2332 and 2601; added Jan Mayen to Area code 2056. Added Svalbard to area codes 1296 and 1635-38.'),
(2003.15,'2003-06-20','2003-09-30','Aivars Terauds; Envirotech','Add Latvia data','','','','Added datum 6661; geogCRS 4661 4388 4389 66616405 66616413; proj 19990; projCRS 3059; tfm 1958. Added aliases and remarks to CRSs 2600 3300-01 4126 4133 4180.'),
(2003.16,'2003-06-20','2003-09-30','EPSG','Add St. Vincent transformation','','','See change request 2002.391.','Added tfm 1959.'),
(2003.17,'2003-06-24','2003-06-27','Flavio Pletti; Polettix','Clarify Helmert transformation formulae','Coordinate Operation Method','','Rotations are in radians as the mathematics uses the approximation of sine 1".','Notified correspondent.'),
(2003.18,'2003-06-27','2004-03-17','Richard Wylde; ExxonMobil','Add Jamaica transformation','','','','Added tfms 1083-86. 10086-88.'),
(2003.19,'2003-06-27','2004-01-07','EPSG','Add Italy data','','','','Added datum 6670; CRSs 4670 and 4982-83 and 3064-65; tfm 1098-99.'),
(2003.2,'2003-06-27','2003-09-30','EPSG','Add offshore Germany transformation','','','','Added coordinate operation method 9654, parameters 8697-8726, area 2879, tfm 1052.'),
(2003.201,'2003-10-31','2004-03-17','EPSG','Add Germany offshore transformation','','','','Added tfm 1998. Added cross-reference to tfm 1052.'),
(2003.21,'2003-08-06','2004-03-17','Stephen H. Savage; Arizona State University','Add Jordan data','','','ED50 to WGS 84 geocentric transformation with parameters dX=-112.0m, dY=-110.3m, dZ=-140.2m not added to dataset as it is inconsistent with tfm from neighbouring countries (Turkey and Egypt).','Added projection 19995, projCRS 3066.'),
(2003.22,'2003-08-06','2003-09-30','Melita Kennedy; ESRI','Review Antarctica Terre Adelie projection','Coordinate Operation Method; Coordinate Operation','9810; 19983','GN7 updated. Method 9810 also used by proj 16061 and 16161.','Enhanced formula for method 9810; added methods 9829-30; changed proj 19983 from using method 9810 to method 9830 including deletion of scale factor parameter.'),
(2003.221,'2003-08-06','2003-09-30','EPSG','Add Antarctic data','','','','Added area 2880; proj 19992-94; CS 4489-90; CRS 3031-33.'),
(2003.23,'2003-08-06','2003-09-30','Melita Kennedy; ESRI','Correct spelling of Portugal Selvagens transformation','Coordinate Operation','1889','','Deprecated tfm 1889 and added replacement 1965. Amended area 2779 description from Portugal - Selvagens island (Madeira group) to Portugal - Selvagens islands (Madeira province).'),
(2003.231,'2003-08-14','2003-09-30','EPSG','Add Portugal data','Datum; Coordinate Reference System; Coordinate Operation','6183-84 6615; 4183 4615 2189 2942; 1944-45.','','Amended datum 6615 name from Porto Santo to Porto Santo 1936; added alias Porto Santo. Added datum 6663-66, geogCRS 4663-6 66636405 66646405 66656405 66666405, projCRS 3061-63. Added area 2870-75, tfm 1966-91 and 8648-49. Added aliase Base SE to datum 6615, CRSs 4615, 2942 and tfm 1888. Added alias Base SW to datum 6183, CRSs 4183, 2189 and tfm 1886. Added remarks to alias to datum 6184, CRSs 4184 and 2190. Added supersession remarks to datum 6183-84 and 6615; CRS 4183-84 and 4615. Deprecated tfm 1944-45.'),
(2003.232,'2003-08-14','2003-09-30','EPSG','Update Portugal information source URL','Datum; Coordinate Reference System','6615-16 6904; 4615-16 2942-43 2963','','Changed URL from www.ipcc.pt to www.igeo.pt.'),
(2003.233,'2003-08-14','2003-12-23','EPSG','Check parameter value for Portugal transformation','Coordinate Operation','1790 1792','Verified that tfm 1992 added in v6.4 is OK.','Deprecated tfm 1792. Deprecated tfm 1790 and added replacement tfm 1997. Changed cross-referencing remarks in tfms 1655 and 1657.'),
(2003.234,'2003-08-14','2003-09-30','EPSG','Add aliases for Portugal transformations','Coordinate Operation','1655 1756 1790','','Added aliases to tfm 1655 1756 1790'),
(2003.24,'2003-08-06','2003-09-30','Melita Kennedy; ESRI','Correct spelling of New Caledonia Grande Terre','Area; Coordinate Reference System; Coordinate Operation','2822-23; 2984 3060 4381-82 4634 66346405 4645; 1918 1929.','','In area 2822 and 2823 and remarks for CRSs 4381-82 4645 and 2984, changed Grand Terre to Grande Terre. Deprecated CRSs 4634, 2982 and tfms 1918, 1929; added replacement CRSs 4662, 3060 and tfms 1962-63. Amended CRS 66346405 name and source CRS.'),
(2003.241,'2003-08-14','2003-08-14','EPSG','Delete spurious remark','Coordinate Operation','1919','','Deleted remarks for tfm 1919.'),
(2003.25,'2003-08-06','2003-09-30','Melita Kennedy; ESRI','Correct spelling of Reunion transformation','Coordinate Operation','1933','','Deprecated tfm 1933 and added replacement 1964. Amended remarks for reciprocal tfm 1926.'),
(2003.26,'2003-08-14','2003-09-30','EPSG','Add ETRS89 origin details','Datum','6258','','Added origin description and amended remarks.'),
(2003.27,'2003-08-27','2003-09-30','Carol McCaig; NIMA','Correct WGS 84 remarks','Datum','6326','','Amended origin description and added remarks and info source.'),
(2003.28,'2003-08-30','2003-09-30','EPSG','Correct Niger CRS axis unit','Coordinate Reference System','2931','','Corrected CS axis unit from ftUS to m.'),
(2003.29,'2003-08-30','2003-09-30','EPSG','Amend Australia AGD84 area','Area; Datum; Coordinate Reference System','2576; 6203; 4203','','For area 2576, added Qld and SA to list of states. (Impacts datum 6203 and CRS 4203). For CRS 62036405 changed area of use from "Australia" to area 2576. For datum 6203, added origin information, remarks and info source. For CRS 4203, added info source.'),
(2003.3,'2003-08-30','2003-09-30','EPSG','Add IKBD','','','','Added datum 6667; CRS 4667 and 66676405; tfm 1993.'),
(2003.31,'2003-09-16','2003-09-30','EPSG','Correct Russia projCRS source geogCRS','Coordinate Reference System','2641-2735 and 2738-2759.','','Corrected source geogCRS from code 4284 to code 4200.'),
(2003.32,'2003-10-15','2003-10-15','EPSG','v6.4 release.','','','',''),
(2003.33,'2003-10-24','2004-04-27','Markus Neteler; ITC','Check US National Atlas projCRS','Coordinate Reference System; Datum','2163 4047; 6047','','Added ellipsoid 7052, datum 6052, geogCRS 4052. Changed projCRS 2163 to reference geogCRS 4052 rather than 4047. Additional deprecation record applied to previously deprecated ellipsoid 7047. Datum 6047 amended to reference ellipsoid 7048 rather than 7047.'),
(2003.34,'2003-11-27','2003-11-28','Maxim Dubinin; Biodiversity Conservation Center, Moscow','Add Romania transformation','','','','Added tfm 1097 and 1996.'),
(2003.341,'2003-11-27','2003-11-28','EPSG','Correct Romania transformation name','Coordinate Operation','1789','','Deprecated tfm 1789 and replaced it with 1995.'),
(2003.35,'2003-12-10','2003-12-14','Andreas Schimke; OLANIS Expertensysteme GmbH','Correct example','Coordinate Operation Method','9820','Guidance Note 7 also corrected. No error in actual example, only in defining parameters.','Corrected values for FE and FN in Lambert Azimuthal Equal Area method example.'),
(2003.36,'2003-12-18','2003-12-18','Alan Haugh; Hydrosearch','Correct Italy datum origin details','Datum','6265','','Prime meridian referenced in Datum Origin fundamental point longitude details changed from Rome to Greenwich. Origin date and alias added (also to 6806).'),
(2003.361,'2003-12-18','2004-01-07','EPSG','Correct datum origin details','Datum','6190-91 6201-03 6211 6215 6221 6224 6230 6239 6257 6261 6263 6289 6297 6304 6666 6801-02 6807 6809-11 6813','','Datum Origin longitude details changed: for 6215 from Brussels to Greenwich, for 6297 the Paris value wrongly labeled as Greenwich is corrected to the actual Greenwhich value, for 6304 and 6310 from Paris to Greenwich and from grads to degrees, for 6666 from Lisbon to Greenwich, for 6813 from Greenwich to Jakarta; for 6801 "from Bern" added, for 6802 "from Bogota" added, for 6807 "from Lisbon" added; coordinates added for 6257 6804; precision increased for 6202 6203 6211 6221 6263 6813; leading zero added to datum origin minutes/seconds for 6201 6224 6227 6282; double space removed from text for Datum Origin for 6157 6191 6289; details amended for 6239; for 6261 changed DMS symbols to abbreviations. Info source added for 6230 6257 6804. Origin remarks amended for 6191. Added datums 6304, 6811; geogCRSs 4671 and 4821; projCRSs 30493-94. Added remarks to datums 6304 and 6811, geogCRSs 4304 and 4811, projCRSs 30491-92. Amended remarks to projCRSs 30791-92.'),
(2003.362,'2003-12-18','2004-01-07','EPSG','Add datum origin details','Datum; Coordinate Reference System','6131 6137-39 6159 6169 6181 6194 6216 6220 6223 6231 6236 6251 6255 6273 6293 6295 6302 6307 6309-10 6322 6618 6665 6816-17 6819; 4131, 61316405, 3176, 3148-4.','','Datum origin information added. For datum 6131 also moved alias info from remarks to alias; alias added to CRS 4131, 61316405, 3176, 3148-49. For datum 6139 also added epoch.'),
(2003.364,'2003-12-18','2004-01-07','EPSG','Add ED79 datum and CRS details','','','','Added datum 6668, CRS 4668.'),
(2003.365,'2004-01-06','2004-01-07','EPSG','Deprecate Algeria data','Datum; Coordinate Reference System','6819; 4819','','Deprecated datum 6819, CRS 4819.'),
(2003.37,'2003-12-31','2004-01-07','EPSG','Amend geogCRS axis description','Coordinate Reference System','4001-16 4018-22 4024-34 4036 4041-45 4047 4120-24 4127-39 4141-71 4173-76 4178-84 4188-4216 4218-25 4227 4229-33 4236-59 4261-86 4288-89 4292-93 4295 4297-4304 4306-4318 4322 4324 4326 4600-4633 4635-46 4657-69 4801-06 4808-09 4813-15 4817-18 4820 4903-0','The derived geogCRS mechanism is no longer supported.','Added UoM 9122 and Coordinate System 6422-23. For geog2D CRSs changed CS from 6402 (DMSH) to 6422 (any representation) and amended scope and remarks. For geog3D CRSs changed CS from 6401 (DMSH) to 6423 (any representation) and amended scope and remarks. CS 6404 horizontal Axis UoM changed from 9102 (degree) to 9122 (degree (supplier-defined representation)).'),
(2003.38,'2003-12-31','2004-01-07','EPSG','Eliminate CRS kind from CRS name','Coordinate Reference System','4328-4389','For geog 3d systems, CS changed from 6401 to 6423 - see change record 2003.37','Deprecated geocentric and geographic 3D CRSs 4328-4389; added replacement CRSs 4910-19, 4930-81 and 4984-87.'),
(2003.381,'2003-12-31','2004-01-07','EPSG','Eliminate alias CRS name','Coordinate Reference System','4126','Old name LKS94 (ETRS89) included as alias to replacement record.','Changed CRS name from "LKS94 (ETRS89)" to "LKS94".'),
(2003.39,'2003-12-31','2004-01-07','EPSG','Withdraw support for code-concatenated geogCRSs','Coordinate Reference System; Coordinate Operation; Coordinate Operation Method; Coordinate System','Any CRS code > 32767; conversions 101-108; methods 9637-44; CS 6401-02 and 6405-20.','Degree representations no longer supported. GN7 updated.','Deprecated geographic CRSs with code in range 6xxx6405, 6xxx6413, 63266405-20; conversions 101-108, methods 9637-44; CS 6401-02 and 6405-20.'),
(2004.01,'2004-01-06','2004-01-07','Melita Kennedy; ESRI','Resolve discrepancy in method codes','','','Error in Guidance Note 7 references to database method codes corrected in January 2004 version of GN.','No action required to database records.'),
(2004.02,'2004-01-06','2004-01-07','Melita Kennedy; ESRI','Correct Netherlands transformation','Coordinate Operation','1961','','Deprecated tfm 1961 and added replacement 1999.'),
(2004.03,'2004-01-08','2004-01-08','Melita Kennedy; ESRI','Correct tranformation variant','Coordinate Operation','1770 1772','','Deprecated tfms 1770 and 1772 and added replacements 1095-96.'),
(2004.04,'2004-01-13','2004-01-13','EPSG','v6.5 release.','','','',''),
(2004.05,'2004-01-15','2004-04-27','EPSG','Add Trinidad transformations','','','','Added tfm 10085.'),
(2004.06,'2004-01-15','2004-03-01','EPSG','Add datum information','Datum','5118 5120 5151 6223 6302 6816','','Added origin description to datums 5118, 5120 and 5151.  Added datum epoch to 5120 and 5151. Amended alias for 5151. Added datum epoch and remarks to datums 6223 6816. Amended origin details and source info for datum 6302.'),
(2004.07,'2004-01-15','2004-01-15','Alan Haugh; Hydrosearch','Clarify usage of Italy geogCRS','Coordinate Reference System','4265 4806 3003-04','See change request 2003.36','Amended scope of CRSs 4265 and 4806 to include minerals licencing. Also added aliases to these and CRSs 3003-04.'),
(2004.08,'2004-01-15','2004-01-20','EPSG','Add Italy transformations','Coordinate Operation','1169 1659-64','','Added area 2882-88; tfm 1088-1094. Added aliases to tfm 1169 and 1659-64.'),
(2004.09,'2004-01-29','2004-01-30','Stefan Steiniger','Correct signs of Germany transformation','Coordinate Operation','1309','Parameter values for 1309 are consistent with its method (Coordinate Frame).','Amended remarks.'),
(2004.1,'2004-02-08','2004-09-14','EPSG','Add European vertical information','Datum; Coordinate Reference System','5101 5105 5109 5117 5127-29 5132 5138 5730','','Added coord op parameters 8730-31, coord op method 8731, vert datums 5172-5185, vertCRS 5774-5787, tfm 5415-5431. Added origin description and remarks to datums 5101 5105 5109 5117 5127-29 5132 5138. Scope revised for datums 5127-28. Name for vertCRS 5730 amended from "European Vertical Reference System 2000" to "EVRF2000".'),
(2004.11,'2004-02-11','2004-03-09','EPSG','Add New Zealand data','','','','Added Chatham Islands data: area 2889, datum 6672-73, geogCRS 4672-73, tfm 1080-82. Added additional remarks to datum 4167 and CRSs 6167 and 6272. Added vertical data: datum 5157-5170, vertCRS 5759-5772.'),
(2004.12,'2004-03-01','2004-04-27','Reino Ruotsalainen; National Land Survey of Finland','Add Finnish data','Coordinate Operation','1638-39','','Added proj 16065 and projCRS 3067; tfm 10098-99. In tfm 1638 and 1639 changed remarks.'),
(2004.13,'2004-03-09','2004-03-09','EPSG','Add Luxembourg transformation.','','','','Added tfm 1078 and 1079.'),
(2004.14,'2004-03-17','2004-10-14','EPSG','Add Netherlands transformations.','Coordinate Operation','1751','','Added tfm 1066. Changed remarks for 1751 to refer to 1066.'),
(2004.141,'2004-03-17','2004-04-07','EPSG','Amend Molodenski-Badekas method name','Coordinate Operation Method','9606-07 9636','Similar change to GN7. Change made to clarify that the coordinates of the evaluation point are critical parameters.','Inserted "10-parameter" into method name, added alias, example and remarks to method 9636. Added alias and alias remarks and made minor changes to example to methods 9606 and 9607.'),
(2004.15,'2004-03-17','2004-04-27','EPSG','Add Israel data.','Area; Datum','1296; 6141 6281','','Aliases added to datums 6141 628. Amended area of use for ED50 and ED50 / UTM zone 33 (area codes 1296 and 1639) to include Israel offshore. Added area 2896-97, coord op param 8728-29, coord op method 9656, tfm 1071-1075 and 8650.'),
(2004.16,'2004-03-17','2004-04-27','EPSG','Add/amend Nigeria transformations.','Coordinate Operation','1818','','Added tfm 1067. Deleted remarks concerning Statoil from tfm 1818.'),
(2004.161,'2004-03-26','2004-04-27','EPSG','Amend Nigeria CRS usage','Coordinate Reference System','2311','','Updated area of use, scope and remarks information.'),
(2004.17,'2004-03-24','2004-04-09','EPSG','Correct remarks','Coordinate Operation','1026-28','','Corrected codes referenced in remarks.'),
(2004.181,'2004-03-26','2004-03-26','EPSG','Correct spelling','Area','2058 2060','','Corrected spelling of Burkina Faso.'),
(2004.182,'2004-03-26','2004-03-26','EPSG','Correct remarks','Coordinate Operation','1454 1804','','In remarks for tfm 1454, deleted "to". In remarks for tfm 1804, amended "1159" to "1559".'),
(2004.183,'2004-03-26','2004-03-26','EPSG','Correct remarks','Datum; Coordinate Reference System','6120; 4134 4910-19','','In remarks for datum 6120, added supersession info. In remarks for CRS 4134, amended "coordinate system" to "coordinate reference system". In remarks for CRS 4910-19, corrected CRS code references.'),
(2004.184,'2004-03-26','2004-04-27','EPSG','Correct Venezuela transformation name','Coordinate Operation','1095-96','','In name, "\ufffd\ufffd\ufffd WGS84 ..." changed to  "\ufffd\ufffd\ufffd WGS 84 ...".'),
(2004.19,'2004-03-17','2004-05-22','EPSG','Correct tfm parameter sign reversibility','Coordinate Operation Method','9613-15 9633 9635','','For tfm methods 9613, 9614, 9615, 9633 and 9635 changed coordinate operation parameter sign reversal from "No" to "Yes".'),
(2004.191,'2004-05-22','2005-05-21','EPSG','Check Norway tfm reversibility','Coordinate Operation Method','9620','','Added remarks on reversibility.'),
(2004.2,'2004-03-26','2004-04-27','EPSG','Correct Area of Use','Datum; Coordinate Operation','6640; 1955','','Corrected area of use.'),
(2004.201,'2004-03-26','2004-04-27','EPSG','Correct Area of Use','Coordinate Reference System','4982-83','','Corrected area of use from Yemen to Italy..'),
(2004.21,'2004-04-07','2004-04-07','EPSG','Correct remarks','Coordinate Reference System','4129 4160-61 4232 4259 4316-17 3439-40 23239-40 31600','','In remarks, changed CS to CRS.'),
(2004.211,'2004-04-07','2004-04-07','EPSG','Correct remarks','Coordinate Reference System','5752','','In remarks, changed  Bandar Abbas (code 5752) to Fao (code 5751).'),
(2004.212,'2004-04-07','2004-04-07','EPSG','Correct remarks','Datum','5124','','Move information on datum origin from remarks field to datum origin field.'),
(2004.22,'2004-03-25','2004-05-31','Emelie Nilsson, Lund University','Add data for Laos.','','','','Added datums 6676-78, geogCRS 4676-78 4991 4993, geocentric CRS 4990 4992, conv 15560-63, tfm 1063-65 and 8651-52.'),
(2004.23,'2004-04-07','2004-04-27','EPSG','Add Guam data','','','','Amended area 1337 to include Guam. Added proj method 9831, proj 15400, datum 6675, geogCRS 4675, projCRS 3993, tfm 1068-70.'),
(2004.24,'2004-04-21','2004-04-27','Marcus Schaber; Logitrak AG','Add Germany Berlin CRS','','','','Added area 2898, proj 19996, projCRS 3068.'),
(2004.25,'2004-04-22','2004-04-27','EPSG','Add SIRGAS 2000 data','Datum; Coordinate Reference System; Coordinate Operation','6170; 4170 4974-75 31986-32000; 1581 1767 1774','','Corrected area of use and amended name, alias and remarks for datum 6170. Added alias and remarks and amended info source to CRSs 4974-75. Added alias and remarks to geogCRS 4170 and projCRSs 31986-32000. Added datum 6674, CRSs 4674 4988-89 31971-85, tfm xxx'),
(2004.26,'2004-04-23','2004-04-27','Ted Koch; State of Wisconsin','Add Wisconsin NAD83 TM','','','','Added proj  14811 and 14841; projCRS 3069-71.'),
(2004.271,'2004-04-27','2004-10-14','Melita Kennedy; ESRI','Add Maine 2000 systems','Coordinate Operation; Coordinate Reference System','11801-02 11831-82; 26783-4 26983-4 2802-3','','For Maine 2000 added proj 11851-53 and projCRS 3072-77; amended remarks for proj 11801-02 11831-82 and projCRS 26783-4 26983-4 2802-3; added aliases for projCRS 26783-4 26983-4 2802-3.'),
(2004.272,'2004-04-27','2004-10-14','Melita Kennedy; ESRI','Add Michigan Oblique Mercator','','','','Added proj 12150 and projCRS 3078-79.'),
(2004.273,'2004-04-27','2004-10-14','Melita Kennedy; ESRI','Add Texas state-wide systems','','','','Added proj 14251-54 and projCRS 3080-85.'),
(2004.274,'2004-08-27','2004-10-14','EPSG','Add Florida state-wide system','','','','Added proj 10934 and projCRS 3086-87.'),
(2004.275,'2004-09-22','2004-10-14','EPSG','Add Kentucky state-wide system','','','','Added proj 15375-6 and projCRS 3088-91.'),
(2004.276,'2004-09-22','2004-10-14','EPSG','Add US HPGN','Datum; Coordinate Reference System; Coordinate Operation','6152; 4152 4956-57 2195 2