/*
 * Decompiled with CFR 0.152.
 */
package simple.http.connect;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import simple.http.connect.Configurator;
import simple.http.connect.ConfiguratorFactory;
import simple.http.connect.SocketHandler;

final class Processor
extends Thread {
    private Configurator configurator = ConfiguratorFactory.getInstance();
    private SocketHandler handler;
    private ServerSocket server;

    public Processor(SocketHandler handler, ServerSocket server) {
        this.handler = handler;
        this.server = server;
        this.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.execute();
                }
            }
            catch (Throwable e) {
                if (!this.server.isClosed()) continue;
                return;
            }
            break;
        }
    }

    private void execute() throws IOException {
        while (true) {
            Socket sock = this.server.accept();
            try {
                this.handshake(sock);
                this.configure(sock);
                this.process(sock);
                continue;
            }
            catch (Exception e) {
                sock.close();
                continue;
            }
            break;
        }
    }

    private void handshake(Socket sock) throws IOException {
        SSLSocket secure = null;
        if (sock instanceof SSLSocket) {
            secure = (SSLSocket)sock;
        }
        if (secure != null) {
            secure.startHandshake();
        }
    }

    private void configure(Socket sock) throws IOException {
        this.configurator.configure(sock);
    }

    private void process(Socket sock) throws Exception {
        this.handler.process(sock);
    }
}

