/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import simple.util.PlainLoader;
import simple.util.PropertyLoader;
import simple.util.XMLLoader;
import simple.util.parse.ParseBuffer;

class PropertyParser
implements PropertyLoader {
    private ParseBuffer text;
    private PlainLoader plain;
    private XMLLoader xml;

    public PropertyParser(Properties table) {
        this.plain = new PlainLoader(table);
        this.xml = new XMLLoader(table);
        this.text = new ParseBuffer();
    }

    public void load(InputStream source) throws Exception {
        this.load(source, "utf-8");
    }

    public void load(InputStream source, String charset) throws Exception {
        this.load(new InputStreamReader(source, charset));
    }

    private void load(Reader source) throws Exception {
        int num;
        char[] buf = new char[64];
        while ((num = source.read(buf)) >= 0) {
            this.text.append(buf, 0, num);
        }
        this.parse(this.text);
    }

    private void parse(ParseBuffer text) throws Exception {
        if (text.length() > 0) {
            this.parse(text.toString());
        }
        text.clear();
    }

    private void parse(String source) throws Exception {
        if (source.startsWith("<?xml ")) {
            this.xml(source);
        } else {
            this.plain(source);
        }
    }

    private void plain(String source) throws Exception {
        this.plain.parse(source);
    }

    private void xml(String source) throws Exception {
        this.xml.parse(source);
    }
}

