/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.commandline.CommandLineImpl;

public class PropertiesCommandLine
extends CommandLineImpl {
    private static final char NUL = '\u0000';
    private final Properties properties;
    private final Option root;
    private final char separator;

    public PropertiesCommandLine(Option root, Properties properties) {
        this(root, properties, '\u0000');
    }

    public PropertiesCommandLine(Option root, Properties properties, char separator) {
        this.root = root;
        this.properties = properties;
        this.separator = separator;
    }

    public boolean hasOption(Option option) {
        if (option == null) {
            return false;
        }
        return ((Hashtable)this.properties).containsKey(option.getPreferredName());
    }

    public Option getOption(String trigger) {
        return this.root.findOption(trigger);
    }

    public List getValues(Option option, List defaultValues) {
        String value = this.properties.getProperty(option.getPreferredName());
        if (value == null) {
            return defaultValues;
        }
        if (this.separator > '\u0000') {
            ArrayList<String> values = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(value, String.valueOf(this.separator));
            while (tokens.hasMoreTokens()) {
                values.add(tokens.nextToken());
            }
            return values;
        }
        return Collections.singletonList(value);
    }

    public Boolean getSwitch(Option option, Boolean defaultValue) {
        String value = this.properties.getProperty(option.getPreferredName());
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        return defaultValue;
    }

    public String getProperty(String property, String defaultValue) {
        return this.properties.getProperty(property, defaultValue);
    }

    public Set getProperties() {
        return ((Hashtable)this.properties).keySet();
    }

    public List getOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        Iterator keys = ((Hashtable)this.properties).keySet().iterator();
        while (keys.hasNext()) {
            String trigger = (String)keys.next();
            Option option = this.root.findOption(trigger);
            if (option == null) continue;
            options.add(option);
        }
        return Collections.unmodifiableList(options);
    }

    public Set getOptionTriggers() {
        HashSet triggers = new HashSet();
        Iterator options = this.getOptions().iterator();
        while (options.hasNext()) {
            Option option = (Option)options.next();
            triggers.addAll(option.getTriggers());
        }
        return Collections.unmodifiableSet(triggers);
    }
}

