/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridRange2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class GridGeometry2D
extends GeneralGridGeometry {
    private static final long serialVersionUID = -3989363771504614419L;
    private static ReferencingFactoryContainer FACTORIES;
    private final CoordinateReferenceSystem crs2D;
    public final int gridDimensionX;
    public final int gridDimensionY;
    public final int axisDimensionX;
    public final int axisDimensionY;
    private final MathTransform2D gridToCRS2D;
    private final MathTransform2D gridFromCRS2D;
    private MathTransform2D cornerToCRS2D;

    private boolean isValid() {
        if (this.gridToCRS != null) {
            int sourceDim = this.gridToCRS.getSourceDimensions();
            int targetDim = this.gridToCRS.getTargetDimensions();
            assert (this.gridToCRS.equals(this.gridToCRS2D) == (sourceDim == 2 && targetDim == 2));
            assert (!this.gridToCRS2D.equals(this.cornerToCRS2D));
            assert (this.gridRange == null || sourceDim == this.gridRange.getDimension()) : this.gridRange;
            assert (this.envelope == null || targetDim == this.envelope.getDimension()) : this.envelope;
            assert (this.gridDimensionY < sourceDim) : this.gridDimensionY;
            assert (this.axisDimensionY < targetDim) : this.axisDimensionY;
        }
        assert (this.gridDimensionX < this.gridDimensionY) : this.gridDimensionX;
        assert (this.axisDimensionX < this.axisDimensionY) : this.axisDimensionX;
        return this.crs2D == null || this.crs2D.getCoordinateSystem().getDimension() == 2;
    }

    GridGeometry2D(GridGeometry2D gm, CoordinateReferenceSystem crs) {
        super(gm, crs);
        this.gridDimensionX = gm.gridDimensionX;
        this.gridDimensionY = gm.gridDimensionY;
        this.axisDimensionX = gm.axisDimensionX;
        this.axisDimensionY = gm.axisDimensionY;
        this.gridFromCRS2D = gm.gridFromCRS2D;
        this.gridToCRS2D = gm.gridToCRS2D;
        this.cornerToCRS2D = gm.cornerToCRS2D;
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridGeometry other) {
        super(other);
        if (other instanceof GridGeometry2D) {
            GridGeometry2D gg = (GridGeometry2D)other;
            this.gridToCRS2D = gg.gridToCRS2D;
            this.gridFromCRS2D = gg.gridFromCRS2D;
            this.gridDimensionX = gg.gridDimensionX;
            this.gridDimensionY = gg.gridDimensionY;
            this.axisDimensionX = gg.axisDimensionX;
            this.axisDimensionY = gg.axisDimensionY;
            this.crs2D = gg.crs2D;
            this.cornerToCRS2D = gg.cornerToCRS2D;
        } else {
            int[] dimensions = new int[4];
            this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, this.gridRange, dimensions, null);
            this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
            this.gridDimensionX = dimensions[0];
            this.gridDimensionY = dimensions[1];
            this.axisDimensionX = dimensions[2];
            this.axisDimensionY = dimensions[3];
            this.crs2D = this.createCRS2D();
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridRange, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, PixelInCell.CELL_CENTER, gridToCRS, crs, null);
    }

    public GridGeometry2D(GridEnvelope gridRange, PixelInCell anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs, Hints hints) throws MismatchedDimensionException, IllegalArgumentException {
        super(gridRange, anchor, gridToCRS, crs);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridRange, dimensions, hints);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            this.cornerToCRS2D = GridGeometry2D.getMathTransform2D(gridToCRS, gridRange, dimensions, hints);
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridRange, PixelOrientation anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs, Hints hints) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, anchor, gridToCRS, new int[4], crs, hints);
    }

    private GridGeometry2D(GridEnvelope gridRange, PixelOrientation anchor, MathTransform gridToCRS, int[] dimensions, CoordinateReferenceSystem crs, Hints hints) {
        this(gridRange, anchor, gridToCRS != null && gridToCRS.getSourceDimensions() == 2 && gridToCRS.getTargetDimensions() == 2 && PixelOrientation.UPPER_LEFT.equals((Object)anchor) ? PixelInCell.CELL_CORNER : PixelInCell.CELL_CENTER, gridToCRS, GridGeometry2D.getMathTransform2D(gridToCRS, gridRange, dimensions, hints), dimensions, crs);
    }

    private GridGeometry2D(GridEnvelope gridRange, PixelOrientation anchor, PixelInCell anchorND, MathTransform gridToCRS, MathTransform2D gridToCRS2D, int[] dimensions, CoordinateReferenceSystem crs) {
        super(gridRange, anchorND, PixelTranslation.translate(gridToCRS, anchor, PixelTranslation.getPixelOrientation(anchorND), dimensions[0], dimensions[1]), crs);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        if (gridToCRS == gridToCRS2D) {
            this.gridToCRS2D = (MathTransform2D)this.gridToCRS;
        } else {
            int xdim = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
            this.gridToCRS2D = (MathTransform2D)PixelTranslation.translate((MathTransform)gridToCRS2D, anchor, PixelOrientation.CENTER, xdim, xdim ^ 1);
        }
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(PixelInCell anchor, MathTransform gridToCRS, Envelope envelope, Hints hints) throws MismatchedDimensionException, IllegalArgumentException {
        super(anchor, gridToCRS, envelope);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, this.gridRange, dimensions, hints);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            this.cornerToCRS2D = GridGeometry2D.getMathTransform2D(gridToCRS, this.gridRange, dimensions, hints);
        }
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(GridEnvelope gridRange, Envelope userRange) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, userRange, null, false, true);
    }

    @Deprecated
    public GridGeometry2D(GridEnvelope gridRange, Envelope userRange, boolean[] reverse, boolean swapXY) throws IllegalArgumentException, MismatchedDimensionException {
        this(gridRange, userRange, reverse, swapXY, false);
    }

    private GridGeometry2D(GridEnvelope gridRange, Envelope userRange, boolean[] reverse, boolean swapXY, boolean automatic) throws IllegalArgumentException, MismatchedDimensionException {
        super(gridRange, userRange, reverse, swapXY, automatic);
        int[] dimensions = new int[4];
        this.gridToCRS2D = GridGeometry2D.getMathTransform2D(this.gridToCRS, gridRange, dimensions, null);
        this.gridFromCRS2D = GridGeometry2D.inverse(this.gridToCRS2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
        this.crs2D = this.createCRS2D();
        assert (this.isValid()) : this;
    }

    public GridGeometry2D(Rectangle gridRange, Rectangle2D userRange) {
        this(new GeneralGridRange(gridRange), GridGeometry2D.getMathTransform(gridRange, userRange), (CoordinateReferenceSystem)null);
    }

    public static GridGeometry2D wrap(GridGeometry other) {
        if (other == null || other instanceof GridGeometry2D) {
            return (GridGeometry2D)other;
        }
        return new GridGeometry2D(other);
    }

    private static MathTransform getMathTransform(Rectangle gridRange, Rectangle2D userRange) {
        double scaleX = userRange.getWidth() / gridRange.getWidth();
        double scaleY = userRange.getHeight() / gridRange.getHeight();
        double transX = userRange.getMinX() - (double)gridRange.x * scaleX;
        double transY = userRange.getMaxY() + (double)gridRange.y * scaleY;
        AffineTransform tr = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, transX, transY);
        tr.translate(0.5, 0.5);
        return ProjectiveTransform.create(tr);
    }

    private static MathTransform2D getMathTransform2D(MathTransform transform, GridEnvelope gridRange, int[] axis, Hints hints) throws IllegalArgumentException {
        if (transform == null || transform instanceof MathTransform2D) {
            axis[3] = 1;
            axis[1] = 1;
            return (MathTransform2D)transform;
        }
        DimensionFilter filter = DimensionFilter.getInstance(hints);
        if (gridRange != null) {
            int dimension = gridRange.getDimension();
            for (int i = 0; i < dimension; ++i) {
                if (gridRange.getSpan(i) <= 1) continue;
                filter.addSourceDimension(i);
            }
        } else {
            filter.addSourceDimensionRange(0, 2);
        }
        Throwable cause = null;
        int[] dimensions = filter.getSourceDimensions();
        if (dimensions.length == 2) {
            axis[0] = dimensions[0];
            axis[1] = dimensions[1];
            try {
                MathTransform candidate = filter.separate(transform);
                if (candidate.getTargetDimensions() != 2) {
                    filter.clear();
                    filter.addSourceDimensions(dimensions);
                    filter.addTargetDimensions(dimensions);
                    candidate = filter.separate(transform);
                }
                dimensions = filter.getTargetDimensions();
                axis[2] = dimensions[0];
                axis[3] = dimensions[1];
                try {
                    return (MathTransform2D)candidate;
                }
                catch (ClassCastException exception) {
                    cause = exception;
                }
            }
            catch (FactoryException exception) {
                cause = exception;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)101), cause);
    }

    private static MathTransform2D inverse(MathTransform2D gridToCRS2D) throws IllegalArgumentException {
        if (gridToCRS2D == null) {
            return null;
        }
        try {
            return gridToCRS2D.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new IllegalArgumentException(Errors.format((int)15, (Object)Classes.getClass((Object)gridToCRS2D)), exception);
        }
    }

    private CoordinateReferenceSystem createCRS2D() throws InvalidGridGeometryException {
        if (!super.isDefined(1)) {
            return null;
        }
        CoordinateReferenceSystem crs = super.getCoordinateReferenceSystem();
        try {
            crs = this.reduce(crs);
        }
        catch (FactoryException exception) {
            throw new InvalidGridGeometryException(Errors.format((int)42, (Object)"crs", (Object)crs.getName()), exception);
        }
        return crs;
    }

    public Envelope2D reduce(Envelope envelope) {
        if (envelope == null) {
            return null;
        }
        return new Envelope2D(this.crs2D, envelope.getMinimum(this.axisDimensionX), envelope.getMinimum(this.axisDimensionY), envelope.getSpan(this.axisDimensionX), envelope.getSpan(this.axisDimensionY));
    }

    public CoordinateReferenceSystem reduce(CoordinateReferenceSystem crs) throws FactoryException {
        if (crs == null || crs.getCoordinateSystem().getDimension() <= 2) {
            return crs;
        }
        if (FACTORIES == null) {
            FACTORIES = ReferencingFactoryContainer.instance(null);
        }
        CoordinateReferenceSystem crs2D = FACTORIES.separate(crs, new int[]{this.axisDimensionX, this.axisDimensionY});
        assert (crs2D.getCoordinateSystem().getDimension() == 2) : crs2D;
        return crs2D;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() throws InvalidGridGeometryException {
        if (this.crs2D != null) {
            assert (this.isDefined(1));
            return this.crs2D;
        }
        assert (!this.isDefined(1));
        throw new InvalidGridGeometryException(140);
    }

    public Envelope2D getEnvelope2D() throws InvalidGridGeometryException {
        if (this.envelope != null && !this.envelope.isNull()) {
            assert (this.isDefined(2));
            return new Envelope2D(this.crs2D, this.envelope.getMinimum(this.axisDimensionX), this.envelope.getMinimum(this.axisDimensionY), this.envelope.getSpan(this.axisDimensionX), this.envelope.getSpan(this.axisDimensionY));
        }
        assert (!this.isDefined(2));
        throw new InvalidGridGeometryException(this.gridToCRS == null ? 178 : 141);
    }

    public GridRange2D getGridRange2D() throws InvalidGridGeometryException {
        if (this.gridRange != null) {
            assert (this.isDefined(4));
            return new GridRange2D(this.gridRange.getLow(this.gridDimensionX), this.gridRange.getLow(this.gridDimensionY), this.gridRange.getSpan(this.gridDimensionX), this.gridRange.getSpan(this.gridDimensionY));
        }
        assert (!this.isDefined(4));
        throw new InvalidGridGeometryException(141);
    }

    public MathTransform2D getGridToCRS2D() throws InvalidGridGeometryException {
        if (this.gridToCRS2D != null) {
            return this.gridToCRS2D;
        }
        throw new InvalidGridGeometryException(101);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform2D getGridToCRS2D(PixelOrientation orientation) {
        if (this.gridToCRS2D == null) {
            throw new InvalidGridGeometryException(101);
        }
        if (!PixelOrientation.UPPER_LEFT.equals((Object)orientation)) {
            return this.computeGridToCRS2D(orientation);
        }
        GridGeometry2D gridGeometry2D = this;
        synchronized (gridGeometry2D) {
            if (this.cornerToCRS2D == null) {
                this.cornerToCRS2D = this.gridToCRS.getSourceDimensions() == 2 && this.gridToCRS.getTargetDimensions() == 2 ? (MathTransform2D)super.getGridToCRS(PixelInCell.CELL_CORNER) : this.computeGridToCRS2D(orientation);
            }
        }
        return this.cornerToCRS2D;
    }

    private MathTransform2D computeGridToCRS2D(PixelOrientation orientation) {
        int xdim = this.gridDimensionX < this.gridDimensionY ? 0 : 1;
        return (MathTransform2D)PixelTranslation.translate((MathTransform)this.gridToCRS2D, PixelOrientation.CENTER, orientation, xdim, xdim ^ 1);
    }

    public MathTransform getGridToCRS(PixelOrientation orientation) {
        if (this.gridToCRS == null) {
            throw new InvalidGridGeometryException(178);
        }
        return PixelTranslation.translate(this.gridToCRS, PixelOrientation.CENTER, orientation, this.gridDimensionX, this.gridDimensionY);
    }

    @Deprecated
    public static Point2D getPixelTranslation(PixelOrientation orientation) throws IllegalArgumentException {
        PixelTranslation offset = PixelTranslation.getPixelTranslation(orientation);
        return new Point2D.Double(offset.dx, offset.dy);
    }

    final Point2D inverseTransform(Point2D point) throws InvalidGridGeometryException {
        if (this.gridFromCRS2D != null) {
            try {
                return this.gridFromCRS2D.transform(point, null);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException(Errors.format((int)23, (Object)AbstractGridCoverage.toString(point, Locale.getDefault()), (Object)((Object)exception)));
            }
        }
        throw new InvalidGridGeometryException(101);
    }

    final Rectangle inverseTransform(Rectangle2D bounds) {
        if (bounds != null && this.gridFromCRS2D != null) {
            try {
                bounds = org.geotools.referencing.CRS.transform(this.gridFromCRS2D, bounds, null);
                int xmin = (int)Math.floor(bounds.getMinX() - 0.5);
                int ymin = (int)Math.floor(bounds.getMinY() - 0.5);
                int xmax = (int)Math.ceil(bounds.getMaxX() - 0.5);
                int ymax = (int)Math.ceil(bounds.getMaxY() - 0.5);
                return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            GridGeometry2D that = (GridGeometry2D)object;
            return this.gridDimensionX == that.gridDimensionX && this.gridDimensionY == that.gridDimensionY && this.axisDimensionX == that.axisDimensionX && this.axisDimensionY == that.axisDimensionY;
        }
        return false;
    }
}

