/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class XMLMime
extends MimeType {
    private static Log log = LogFactory.getLog(XMLMime.class);
    public static final XMLMime ogcxml = new XMLMime("application/vnd.ogc.se_xml", "ogc-xml", "ogc-xml", "application/vnd.ogc.se_xml", true);
    public static final XMLMime kml = new XMLMime("application/vnd.google-earth.kml+xml", "kml", "kml", "application/vnd.google-earth.kml+xml", true);
    public static final XMLMime kmz = new XMLMime("application/vnd.google-earth.kmz", "kmz", "kmz", "application/vnd.google-earth.kmz", true);
    public static final XMLMime gml = new XMLMime("application/vnd.ogc.gml", "gml", "gml", "application/vnd.ogc.gml", true);

    private XMLMime(String mimeType, String fileExtension, String internalName, String format, boolean noop) {
        super(mimeType, fileExtension, internalName, format, false);
    }

    public XMLMime(String mimeType, String fileExtension, String internalName, String format) throws MimeException {
        super(mimeType, fileExtension, internalName, format, false);
    }

    protected static XMLMime checkForFormat(String formatStr) throws MimeException {
        if (formatStr.equalsIgnoreCase("application/vnd.google-earth.kml+xml")) {
            return kml;
        }
        if (formatStr.equalsIgnoreCase("application/vnd.google-earth.kmz")) {
            return kmz;
        }
        if (formatStr.equalsIgnoreCase("application/vnd.ogc.se_xml")) {
            return ogcxml;
        }
        if (formatStr.equalsIgnoreCase("application/vnd.ogc.gml")) {
            return gml;
        }
        return null;
    }

    protected static XMLMime checkForExtension(String fileExtension) throws MimeException {
        if (fileExtension.equalsIgnoreCase("kml")) {
            return kml;
        }
        if (fileExtension.equalsIgnoreCase("kmz")) {
            return kmz;
        }
        if (fileExtension.equalsIgnoreCase("gml")) {
            return gml;
        }
        return null;
    }
}

