/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest;

import org.geowebcache.GeoWebCacheException;

public abstract class GWCTask {
    public static final int TYPE_SEED = 0;
    public static final int TYPE_RESEED = 1;
    public static final int TYPE_TRUNCATE = 2;
    protected int threadCount = 1;
    protected int threadOffset = 0;
    long taskId = -1L;
    protected int type = -1;
    protected String layerName = null;
    protected long timeSpent = -1L;
    protected long timeRemaining = -1L;
    protected long tilesDone = -1L;
    protected long tilesTotal = -1L;
    protected boolean terminate = false;

    public abstract void doAction() throws GeoWebCacheException;

    public void setThreadInfo(int threadCount, int threadOffset) {
        this.threadCount = threadCount;
        this.threadOffset = threadOffset;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getThreadOffset() {
        return this.threadOffset;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public long getTilesTotal() {
        return this.tilesTotal;
    }

    public String getTilesTotalStr() {
        if (this.tilesTotal > 0L) {
            return Long.toString(this.tilesTotal);
        }
        return "Too many to count";
    }

    public long getTilesDone() {
        return this.tilesDone;
    }

    public long getTimeRemaining() {
        if (this.tilesTotal > 0L) {
            return this.timeRemaining;
        }
        return -2L;
    }

    public void terminateNicely() {
        this.terminate = true;
    }

    public boolean isType(int otherType) {
        return this.type == otherType;
    }

    public String getType() {
        switch (this.type) {
            case 0: {
                return "Seed";
            }
            case 1: {
                return "Reseed";
            }
            case 2: {
                return "Truncate";
            }
        }
        return "Not set";
    }
}

