/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.kml;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorKMLTile;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.OutOfBoundsException;
import org.geowebcache.layer.SRS;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.service.kml.KMLDebugGridLayer;
import org.geowebcache.service.kml.KMLSiteMap;
import org.geowebcache.service.kml.KMZHelper;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.wms.BBOX;

public class KMLService
extends Service {
    private static Log log = LogFactory.getLog(KMLService.class);
    public static final String SERVICE_KML = "kml";
    public static final String HINT_DEBUGGRID = "debuggrid";
    public static final String HINT_SITEMAP_LAYER = "sitemap";
    public static final String HINT_SITEMAP_GLOBAL = "sitemap_global";
    private StorageBroker sb;
    private TileLayerDispatcher tld;

    public KMLService(StorageBroker sb, TileLayerDispatcher tld) {
        super(SERVICE_KML);
        this.sb = sb;
        this.tld = tld;
    }

    protected static String[] parseRequest(String pathInfo) {
        String[] retStrs = new String[4];
        String[] splitStr = pathInfo.split("/");
        String filename = splitStr[splitStr.length - 1];
        int extOfst = filename.lastIndexOf(".");
        String lastExtension = filename.substring(extOfst + 1, filename.length());
        int typeExtOfst = filename.lastIndexOf(".", extOfst - 1);
        if (typeExtOfst > 0) {
            retStrs[2] = filename.substring(typeExtOfst + 1, extOfst);
            retStrs[3] = lastExtension;
        } else {
            retStrs[2] = lastExtension;
            retStrs[3] = null;
            typeExtOfst = extOfst;
        }
        String ext = splitStr[splitStr.length - 2];
        if (ext.equalsIgnoreCase(SERVICE_KML) || ext.equalsIgnoreCase("kmz")) {
            retStrs[0] = filename.substring(0, typeExtOfst);
            retStrs[1] = "";
        } else {
            retStrs[0] = splitStr[splitStr.length - 2];
            retStrs[1] = filename.substring(0, typeExtOfst);
        }
        return retStrs;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        String[] parsed = null;
        try {
            parsed = KMLService.parseRequest(URLDecoder.decode(request.getPathInfo(), "UTF-8"));
        }
        catch (Exception e) {
            throw new ServiceException("Unable to parse KML request : " + e.getMessage());
        }
        int[] gridLoc = null;
        if (parsed[1].length() > 0) {
            gridLoc = KMLService.parseGridLocString(parsed[1]);
        }
        ConveyorKMLTile tile = new ConveyorKMLTile(this.sb, parsed[0], SRS.getEPSG4326(), gridLoc, MimeType.createFromExtension(parsed[2]), "", "", request, response);
        tile.setSRS(SRS.getEPSG4326());
        if (parsed[0].equalsIgnoreCase(HINT_SITEMAP_LAYER) && parsed[2].equalsIgnoreCase("xml")) {
            tile.setHint(HINT_SITEMAP_GLOBAL);
            String tmpUrl = KMLService.urlPrefix(request.getRequestURL().toString(), parsed);
            tile.setUrlPrefix(tmpUrl.substring(0, tmpUrl.length() - HINT_SITEMAP_LAYER.length()));
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (parsed[1].equalsIgnoreCase(HINT_SITEMAP_LAYER)) {
            tile.setHint(HINT_SITEMAP_LAYER);
            tile.setUrlPrefix(KMLService.urlPrefix(request.getRequestURL().toString(), parsed));
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (parsed[3] != null) {
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            tile.setUrlPrefix(KMLService.urlPrefix(request.getRequestURL().toString(), parsed));
            tile.setWrapperMimeType(MimeType.createFromExtension(parsed[3]));
        }
        if (tile.getLayerId().equalsIgnoreCase("debugGrid")) {
            tile.setHint(HINT_DEBUGGRID);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
        }
        return tile;
    }

    public void handleRequest(Conveyor conv) throws GeoWebCacheException {
        TileLayer layer;
        ConveyorKMLTile tile = (ConveyorKMLTile)conv;
        if (tile.getHint() == HINT_DEBUGGRID) {
            layer = KMLDebugGridLayer.getInstance();
        } else if (tile.getHint() == HINT_SITEMAP_GLOBAL) {
            layer = null;
        } else {
            layer = this.tld.getTileLayer(tile.getLayerId());
            if (layer == null) {
                throw new ServiceException("No layer provided, request parsed to: " + tile.getLayerId());
            }
        }
        tile.setTileLayer(layer);
        if (tile.getHint() == HINT_SITEMAP_LAYER || tile.getHint() == HINT_SITEMAP_GLOBAL) {
            KMLSiteMap sm = new KMLSiteMap(tile, this.tld);
            try {
                sm.write();
            }
            catch (IOException ioe) {
                throw new GeoWebCacheException("Unable to write sitemap: " + ioe.getMessage());
            }
            return;
        }
        if (tile.getTileIndex() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request for super overlay for " + tile.getLayerId() + " received"));
            }
            KMLService.handleSuperOverlay(tile);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request for overlay for " + tile.getLayerId()));
            }
            KMLService.handleOverlay(tile);
        }
    }

    private static String urlPrefix(String requestUrl, String[] parsed) {
        int endOffset = requestUrl.length() - parsed[1].length() - parsed[2].length();
        if (parsed.length > 3 && parsed[3] != null) {
            endOffset -= parsed[3].length() + 1;
        }
        return new String(requestUrl.substring(0, endOffset - 1));
    }

    private static void handleSuperOverlay(ConveyorKMLTile tile) throws GeoWebCacheException {
        SRS srs = SRS.getEPSG4326();
        TileLayer layer = tile.getLayer();
        BBOX bbox = layer.getGrid(srs).getBounds();
        String formatExtension = "." + tile.getMimeType().getFileExtension();
        if (tile.getWrapperMimeType() != null) {
            formatExtension = formatExtension + "." + tile.getWrapperMimeType().getFileExtension();
        }
        int[] gridLoc = layer.getZoomedOutGridLoc(srs);
        String networkLinks = null;
        if (gridLoc[2] < 0) {
            int[] gridLocWest = new int[]{0, 0, 0};
            int[] gridLocEast = new int[]{1, 0, 0};
            BBOX bboxWest = new BBOX(bbox.coords[0], bbox.coords[1], 0.0, bbox.coords[3]);
            BBOX bboxEast = new BBOX(0.0, bbox.coords[1], bbox.coords[2], bbox.coords[3]);
            networkLinks = KMLService.superOverlayNetworLink(layer.getName() + " West", bboxWest, tile.getUrlPrefix() + "/" + KMLService.gridLocString(gridLocWest) + formatExtension) + KMLService.superOverlayNetworLink(layer.getName() + " East", bboxEast, tile.getUrlPrefix() + "/" + KMLService.gridLocString(gridLocEast) + formatExtension);
        } else {
            networkLinks = KMLService.superOverlayNetworLink(layer.getName(), bbox, tile.getUrlPrefix() + "/" + KMLService.gridLocString(gridLoc) + formatExtension);
        }
        String xml = KMLService.KMLHeader() + "\n<Folder>" + KMLService.getLookAt(bbox) + networkLinks + "\n</Folder>" + "\n</kml>\n";
        tile.setContent(xml.getBytes());
        tile.setMimeType(XMLMime.kml);
        tile.setStatus(200);
        KMLService.writeTileResponse(tile, true);
    }

    private static String superOverlayNetworLink(String superString, BBOX bbox, String url) {
        String xml = "\n<NetworkLink><name>Super-overlay: " + superString + "</name>" + "\n<Region>\n" + bbox.toKML() + "\n<Lod><minLodPixels>128</minLodPixels>" + "\n<maxLodPixels>-1</maxLodPixels></Lod>" + "\n</Region>" + "\n<Link><href>" + url + "</href>" + "\n<viewRefreshMode>onRegion</viewRefreshMode>" + "\n</Link>" + "\n</NetworkLink>";
        return xml;
    }

    protected static String gridLocString(int[] gridLoc) {
        return "x" + gridLoc[0] + "y" + gridLoc[1] + "z" + gridLoc[2];
    }

    protected static int[] parseGridLocString(String key) throws ServiceException {
        int[] ret = new int[3];
        int yloc = key.indexOf("y");
        int zloc = key.indexOf("z");
        try {
            ret[0] = Integer.parseInt(key.substring(1, yloc));
            ret[1] = Integer.parseInt(key.substring(yloc + 1, zloc));
            ret[2] = Integer.parseInt(key.substring(zloc + 1, key.length()));
        }
        catch (NumberFormatException nfe) {
            throw new ServiceException("Unable to parse " + key);
        }
        catch (StringIndexOutOfBoundsException sobe) {
            throw new ServiceException("Unable to parse " + key);
        }
        return ret;
    }

    private static void handleOverlay(ConveyorKMLTile tile) throws GeoWebCacheException {
        TileLayer tileLayer = tile.getLayer();
        boolean packageData = false;
        if (tile.getWrapperMimeType() == XMLMime.kmz) {
            packageData = true;
        }
        if (packageData) {
            String overlayXml = KMLService.createOverlay(tile, true);
            try {
                tile.setWrapperMimeType(null);
                try {
                    tileLayer.getTile(tile);
                }
                catch (OutOfBoundsException oobe) {
                    log.error((Object)("Out of bounds: " + Arrays.toString(tile.getTileIndex()) + " should never habe been linked to."));
                    throw oobe;
                }
                tile.setWrapperMimeType(XMLMime.kmz);
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage());
                ioe.printStackTrace();
                throw new ServiceException(ioe.getMessage());
            }
            byte[] zip = KMZHelper.createZippedKML(KMLService.gridLocString(tile.getTileIndex()), tile.getMimeType().getFileExtension(), overlayXml.getBytes(), tile.getContent());
            tile.setContent(zip);
            tile.setStatus(200);
        } else {
            String overlayXml = KMLService.createOverlay(tile, false);
            tile.setContent(overlayXml.getBytes());
            tile.setStatus(200);
            tileLayer.putTile(tile);
        }
        KMLService.writeTileResponse(tile, true);
    }

    private static String createOverlay(ConveyorKMLTile tile, boolean isPackaged) throws ServiceException, GeoWebCacheException {
        TileLayer tileLayer = tile.getLayer();
        int[] gridLoc = tile.getTileIndex();
        SRS srs = SRS.getEPSG4326();
        BBOX bbox = tileLayer.getBboxForGridLoc(srs, gridLoc);
        StringBuffer buf = new StringBuffer();
        buf.append(KMLService.createOverlayHeader(bbox, tile.getMimeType() instanceof ImageMime));
        buf.append("\n<!-- Network links to subtiles -->\n");
        int[][] linkGridLocs = tileLayer.getZoomInGridLoc(srs, gridLoc);
        if (tile.getMimeType() == XMLMime.kml) {
            linkGridLocs = KMZHelper.filterGridLocs(tile.getStorageBroker(), tileLayer, tile.getMimeType(), linkGridLocs);
        }
        for (int i = 0; i < 4; ++i) {
            if (linkGridLocs[i][2] <= 0) continue;
            BBOX linkBbox = tileLayer.getBboxForGridLoc(srs, linkGridLocs[i]);
            String gridLocStr = KMLService.gridLocString(linkGridLocs[i]);
            String gridLocUrl = tile.getUrlPrefix() + gridLocStr + "." + tile.getMimeType().getFileExtension() + "." + tile.getWrapperMimeType().getFileExtension();
            buf.append(KMLService.createNetworkLinkElement(tileLayer, linkBbox, gridLocUrl, gridLocStr, -1));
        }
        buf.append("\n<!-- Network link to actual content -->\n");
        if (tile.getMimeType() instanceof ImageMime) {
            buf.append(KMLService.createGroundOverLayElement(gridLoc, tile.getUrlPrefix(), bbox, tile.getMimeType().getFileExtension()));
        } else {
            String gridLocStr = KMLService.gridLocString(gridLoc);
            String gridLocUrl = gridLocStr + "." + tile.getMimeType().getFileExtension();
            if (isPackaged) {
                gridLocUrl = "data_" + gridLocUrl;
            }
            int maxLodPixels = -1;
            if (tile.getLayer() instanceof KMLDebugGridLayer) {
                maxLodPixels = 385;
            }
            buf.append(KMLService.createNetworkLinkElement(tileLayer, bbox, gridLocUrl, gridLocStr, maxLodPixels));
        }
        buf.append("</Document>\n</kml>");
        return buf.toString();
    }

    private static String createOverlayHeader(BBOX bbox, boolean isRaster) {
        int maxLodPixels = -1;
        if (isRaster) {
            maxLodPixels = 385;
        }
        return KMLService.KMLHeader() + "<Document>\n" + "<Region>\n" + bbox.toKML() + "<Lod><minLodPixels>128</minLodPixels>" + "<maxLodPixels>" + Integer.toString(maxLodPixels) + "</maxLodPixels></Lod>\n" + "</Region>\n";
    }

    private static String createNetworkLinkElement(TileLayer layer, BBOX bbox, String gridLocUrl, String tileIdx, int maxLodPixels) {
        String xml = "\n<NetworkLink>\n<name>" + layer.getName() + "</name>" + "\n<Region>" + bbox.toKML() + "\n<Lod><minLodPixels>128</minLodPixels>" + "<maxLodPixels>" + Integer.toString(maxLodPixels) + "</maxLodPixels></Lod>\n" + "</Region>" + "\n<Link>" + "\n<href>" + gridLocUrl + "</href>" + "\n<viewRefreshMode>onRegion</viewRefreshMode>" + "</Link>" + "\n</NetworkLink>\n";
        return xml;
    }

    private static String createGroundOverLayElement(int[] gridLoc, String urlStr, BBOX bbox, String formatExtension) {
        String xml = "\n<GroundOverlay>\n<drawOrder>" + gridLoc[2] + "</drawOrder>" + "\n<altitudeMode>clampToGround</altitudeMode>" + "\n<Icon>" + "\n<href>" + KMLService.gridLocString(gridLoc) + "." + formatExtension + "</href>" + "</Icon>\n" + bbox.toKML() + "\n</GroundOverlay>\n";
        return xml;
    }

    private static String getLookAt(BBOX bbox) {
        double lon1 = bbox.coords[0];
        double lat1 = bbox.coords[1];
        double lon2 = bbox.coords[2];
        double lat2 = bbox.coords[3];
        double R_EARTH = 6371000.0;
        double[] p1 = KMLService.getRect(lon1, lat1, R_EARTH);
        double[] p2 = KMLService.getRect(lon2, lat2, R_EARTH);
        double[] midpoint = new double[]{(p1[0] + p2[0]) / 2.0, (p1[1] + p2[1]) / 2.0, (p1[2] + p2[2]) / 2.0};
        midpoint = KMLService.getGeographic(midpoint[0], midpoint[1], midpoint[2]);
        midpoint[0] = (lon1 + lon2) / 2.0;
        double distance = KMLService.distance(p1, p2);
        return "<LookAt id=\"superoverlay\">\n<longitude>" + (lon1 + lon2) / 2.0 + "</longitude>" + "\n<latitude>" + midpoint[1] + "</latitude>" + "\n<altitude>0</altitude>" + "\n<heading>0</heading>" + "\n<tilt>0</tilt>" + "\n<range>" + distance + "</range>" + "\n<altitudeMode>clampToGround</altitudeMode>" + "\n</LookAt>\n";
    }

    private static String KMLHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/kml/2.2 http://schemas.opengis.net/kml/2.2.0/ogckml22.xsd\">\n";
    }

    private static double[] getRect(double lat, double lon, double radius) {
        double theta = (90.0 - lat) * Math.PI / 180.0;
        double phi = (90.0 - lon) * Math.PI / 180.0;
        double x = radius * Math.sin(phi) * Math.cos(theta);
        double y = radius * Math.sin(phi) * Math.sin(theta);
        double z = radius * Math.cos(phi);
        return new double[]{x, y, z};
    }

    private static double[] getGeographic(double x, double y, double z) {
        double radius = KMLService.distance(new double[]{x, y, z}, new double[]{0.0, 0.0, 0.0});
        double theta = Math.atan2(Math.sqrt(x * x + y * y), z);
        double phi = Math.atan2(y, x);
        double lat = 90.0 - theta * 180.0 / Math.PI;
        double lon = 90.0 - phi * 180.0 / Math.PI;
        return new double[]{lon > 180.0 ? lon - 360.0 : lon, lat, radius};
    }

    private static double distance(double[] p1, double[] p2) {
        double dx = p1[0] - p2[0];
        double dy = p1[1] - p2[1];
        double dz = p1[2] - p2[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

