/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.layer.Grid;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSRequests {
    private static Log log = LogFactory.getLog(WMSRequests.class);
    protected static List<Configuration> getCapConfigs;
    static String getCapsStr;

    static void handleGetCapabilities(TileLayerDispatcher tLD, HttpServletResponse response) throws GeoWebCacheException {
        HashMap<String, TileLayer> layerMap = tLD.getLayers();
        Iterator iter = layerMap.values().iterator();
        StringBuffer buf = new StringBuffer();
        buf.append(WMSRequests.getCapabilitiesHeader());
        while (iter.hasNext()) {
            TileLayer tl = (TileLayer)iter.next();
            tl.isInitialized();
            buf.append(WMSRequests.getTileSets(tl));
        }
        buf.append(WMSRequests.getCapabilitiesFooter());
        try {
            WMSRequests.writeData(response, buf.toString().getBytes());
        }
        catch (IOException ioe) {
            throw new GeoWebCacheException("Error doing getCapabilities: " + ioe.getMessage());
        }
    }

    private static String getCapabilitiesHeader() throws GeoWebCacheException {
        String wms = WMSRequests.fetchOriginalWMSCapabilitiesDocument();
        if (wms == null) {
            throw new GeoWebCacheException("Unable to retrieve original WMS Capabilities document");
        }
        int split = wms.indexOf("<VendorSpecificCapabilities/>");
        if (split != -1) {
            String header = wms.substring(0, split);
            return header + "\n<VendorSpecificCapabilities>";
        }
        split = wms.indexOf("</VendorSpecificCapabilities>");
        split = wms.indexOf("<UserDefinedSymbolization");
        if (split == -1) {
            split = wms.indexOf("<Layer");
        }
        String header = wms.substring(0, split);
        return header + "\n<VendorSpecificCapabilities>";
    }

    private static String getCapabilitiesFooter() throws GeoWebCacheException {
        String wms = WMSRequests.fetchOriginalWMSCapabilitiesDocument();
        int split = wms.indexOf("<VendorSpecificCapabilities/>");
        if (split != -1) {
            String footer = wms.substring(split + 29);
            return "\n</VendorSpecificCapabilities>" + footer;
        }
        split = wms.indexOf("<VendorSpecificCapabilities/>");
        if (split != -1) {
            String footer = wms.substring(split + 28);
            return "\n</VendorSpecificCapabilities>" + footer;
        }
        split = wms.indexOf("<UserDefinedSymbolization");
        if (split == -1) {
            split = wms.indexOf("<Layer");
        }
        String footer = wms.substring(split);
        return "\n</VendorSpecificCapabilities>" + footer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized String fetchOriginalWMSCapabilitiesDocument() throws GeoWebCacheException {
        if (getCapsStr != null) {
            return getCapsStr;
        }
        StringBuffer buf = new StringBuffer();
        if (getCapConfigs == null) {
            throw new GeoWebCacheException("No configuration object available to use for WMS Capabilities");
        }
        Iterator<Configuration> configIter = getCapConfigs.iterator();
        block23: while (configIter.hasNext()) {
            List<TileLayer> configLayers = null;
            Configuration config = configIter.next();
            try {
                configLayers = config.getTileLayers(false);
            }
            catch (GeoWebCacheException gwce) {
                log.error((Object)gwce.getMessage());
                log.error((Object)("Failed to add layers from " + config.getIdentifier()));
            }
            Iterator<TileLayer> iter = null;
            if (configLayers != null) {
                iter = configLayers.iterator();
            }
            while (iter != null && iter.hasNext()) {
                TileLayer layer = iter.next();
                if (!(layer instanceof WMSLayer)) continue;
                WMSLayer wmsLayer = (WMSLayer)layer;
                String url = wmsLayer.getWMSurl()[0];
                InputStream input = null;
                BufferedReader process = null;
                try {
                    String line;
                    URL capabilitiesURL = new URL(url + "?REQUEST=GetCapabilities&SERVICE=WMS&VESION=1.1.0");
                    URLConnection connection = capabilitiesURL.openConnection();
                    input = connection.getInputStream();
                    InputStreamReader reader = new InputStreamReader(input);
                    process = new BufferedReader(reader);
                    buf = new StringBuffer();
                    while ((line = process.readLine()) != null) {
                        buf.append(line);
                        buf.append("\n");
                    }
                    if (buf.length() == 0) continue;
                    break block23;
                }
                catch (Throwable notConnected) {}
                continue;
                finally {
                    if (process != null) {
                        try {
                            process.close();
                        }
                        catch (IOException e) {}
                    }
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        getCapsStr = buf.toString();
        return getCapsStr;
    }

    public static void setConfig(List<Configuration> configs) {
        getCapConfigs = configs;
    }

    private static String getTileSets(TileLayer tl) throws GeoWebCacheException {
        String ret = "";
        List<MimeType> mimeList = tl.getMimeTypes();
        String strStyles = tl.getStyles();
        if (strStyles == null) {
            strStyles = "";
        }
        for (Grid grid : tl.getGrids().values()) {
            String[] strBounds = WMSRequests.doublesToStrings(grid.getBounds().coords);
            String strResolutions = WMSRequests.getResolutionString(grid.getResolutions());
            String strName = tl.getName();
            for (MimeType mime : mimeList) {
                String strFormat = mime.getFormat();
                ret = ret + WMSRequests.getTileSet(strName, grid.getSRS().toString(), strBounds, strStyles, strResolutions, strFormat);
            }
        }
        return ret;
    }

    private static String getTileSet(String strName, String strSRS, String[] strBounds, String strStyles, String strResolutions, String strFormat) {
        return "\n<TileSet><SRS>" + strSRS + "</SRS>" + "<BoundingBox srs=\"" + strSRS + "\"" + " minx=\"" + strBounds[0] + "\"" + " miny=\"" + strBounds[1] + "\"" + " maxx=\"" + strBounds[2] + "\"" + " maxy=\"" + strBounds[3] + "\" />" + "<Resolutions>" + strResolutions + "</Resolutions>" + "<Width>256</Width>" + "<Height>256</Height>" + "<Format>" + strFormat + "</Format>" + "<Layers>" + strName + "</Layers>" + "<Styles>" + strStyles + "</Styles>" + "</TileSet>";
    }

    private static String[] doublesToStrings(double[] doubles) {
        String[] ret = new String[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ret[i] = Double.toString(doubles[i]);
        }
        return ret;
    }

    private static String getResolutionString(double[] resolutions) {
        String ret = "";
        for (int i = 0; i < resolutions.length; ++i) {
            ret = ret + Double.toString(resolutions[i]) + " ";
        }
        return ret;
    }

    private static void writeData(HttpServletResponse response, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            log.trace((Object)"sendData() had nothing to return");
            response.setStatus(204);
            return;
        }
        log.trace((Object)"sendData() Sending data.");
        response.setStatus(200);
        response.setContentType("application/vnd.ogc.wms_xml");
        response.setContentLength(data.length);
        try {
            ServletOutputStream os = response.getOutputStream();
            os.write(data);
            os.flush();
        }
        catch (IOException ioe) {
            log.debug((Object)("Caught IOException" + ioe.getMessage()));
        }
    }

    public static void handleProxy(TileLayerDispatcher tld, ConveyorTile tile) throws GeoWebCacheException {
        WMSLayer layer = null;
        TileLayer tl = tld.getTileLayer(tile.getLayerId());
        if (tl == null) {
            throw new GeoWebCacheException(tile.getLayerId() + " is unknown.");
        }
        if (!(tl instanceof WMSLayer)) {
            throw new GeoWebCacheException(tile.getLayerId() + " is not served by a WMS backend.");
        }
        layer = (WMSLayer)tl;
        String queryStr = tile.servletReq.getQueryString();
        String serverStr = layer.getWMSurl()[0];
        try {
            URL url = serverStr.endsWith("?") ? new URL(serverStr + queryStr) : new URL(serverStr + "?" + queryStr);
            HttpURLConnection wmsBackendCon = (HttpURLConnection)url.openConnection();
            HttpServletResponse response = tile.servletResp;
            if (wmsBackendCon.getContentEncoding() != null) {
                response.setCharacterEncoding(wmsBackendCon.getContentEncoding());
            }
            response.setContentType(wmsBackendCon.getContentType());
            int read = 0;
            byte[] data = new byte[1024];
            while (read > -1) {
                read = wmsBackendCon.getInputStream().read(data);
                if (read <= -1) continue;
                response.getOutputStream().write(data, 0, read);
            }
        }
        catch (IOException ioe) {
            tile.servletResp.setStatus(500);
            log.error((Object)ioe.getMessage());
        }
    }
}

