/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheItem;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Literal;

public final class LabelCacheDefault
implements LabelCache {
    public double MIN_GOODNESS_FIT = 0.7;
    public double DEFAULT_PRIORITY = 1000.0;
    protected Map labelCache = new HashMap();
    protected ArrayList labelCacheNonGrouped = new ArrayList();
    public boolean DEFAULT_GROUP = false;
    public int DEFAULT_SPACEAROUND = 0;
    protected boolean outlineRenderingEnabled = false;
    protected SLDStyleFactory styleFactory = new SLDStyleFactory();
    boolean stop = false;
    Set enabledLayers = new HashSet();
    Set activeLayers = new HashSet();
    LineLengthComparator lineLengthComparator = new LineLengthComparator();
    private boolean needsOrdering = false;

    public void stop() {
        this.stop = true;
        this.activeLayers.clear();
    }

    public void start() {
        this.stop = false;
    }

    public void clear() {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed," + " stop() or endLayer() must be called before clear is called");
        }
        this.needsOrdering = true;
        this.labelCache.clear();
        this.labelCacheNonGrouped.clear();
        this.enabledLayers.clear();
    }

    public void clear(String layerId) {
        LabelCacheItem item;
        if (this.activeLayers.contains(layerId)) {
            throw new IllegalStateException(layerId + " is still rendering, end the layer before calling clear.");
        }
        this.needsOrdering = true;
        Iterator<Object> iter = this.labelCache.values().iterator();
        while (iter.hasNext()) {
            item = (LabelCacheItem)iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
        }
        iter = this.labelCacheNonGrouped.iterator();
        while (iter.hasNext()) {
            item = (LabelCacheItem)iter.next();
            if (!item.getLayerIds().contains(layerId)) continue;
            iter.remove();
        }
        this.enabledLayers.remove(layerId);
    }

    public void disableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.remove(layerId);
    }

    public void startLayer(String layerId) {
        this.enabledLayers.add(layerId);
        this.activeLayers.add(layerId);
    }

    public double getPriority(TextSymbolizer symbolizer, SimpleFeature feature) {
        if (symbolizer.getPriority() == null) {
            return this.DEFAULT_PRIORITY;
        }
        try {
            Double number = (Double)symbolizer.getPriority().evaluate((Object)feature, Double.class);
            return number;
        }
        catch (Exception e) {
            return this.DEFAULT_PRIORITY;
        }
    }

    public void put(String layerId, TextSymbolizer symbolizer, SimpleFeature feature, LiteShape2 shape, NumberRange scaleRange) {
        this.needsOrdering = true;
        try {
            String label = (String)symbolizer.getLabel().evaluate((Object)feature, String.class);
            if (label == null) {
                return;
            }
            if ((label = label.trim()).length() == 0) {
                return;
            }
            double priorityValue = this.getPriority(symbolizer, feature);
            boolean group = this.isGrouping(symbolizer);
            if (!group) {
                TextStyle2D textStyle = (TextStyle2D)this.styleFactory.createStyle(feature, symbolizer, (Range)scaleRange);
                LabelCacheItem item = new LabelCacheItem(layerId, textStyle, shape, label);
                item.setPriority(priorityValue);
                item.setSpaceAround(this.getSpaceAround(symbolizer));
                this.labelCacheNonGrouped.add(item);
            } else {
                LabelCacheItem lci = (LabelCacheItem)this.labelCache.get(label);
                if (lci == null) {
                    TextStyle2D textStyle = (TextStyle2D)this.styleFactory.createStyle(feature, symbolizer, (Range)scaleRange);
                    LabelCacheItem item = new LabelCacheItem(layerId, textStyle, shape, label);
                    item.setPriority(priorityValue);
                    item.setSpaceAround(this.getSpaceAround(symbolizer));
                    this.labelCache.put(label, item);
                } else {
                    if (symbolizer.getPriority() != null && !(symbolizer.getPriority() instanceof Literal)) {
                        lci.setPriority(lci.getPriority() + priorityValue);
                    }
                    lci.getGeoms().add(shape.getGeometry());
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private int getSpaceAround(TextSymbolizer symbolizer) {
        String value = symbolizer.getOption("spaceAround");
        if (value == null) {
            return this.DEFAULT_SPACEAROUND;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return this.DEFAULT_SPACEAROUND;
        }
    }

    private boolean isGrouping(TextSymbolizer symbolizer) {
        String value = symbolizer.getOption("group");
        if (value == null) {
            return this.DEFAULT_GROUP;
        }
        return value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
    }

    public void endLayer(String layerId, Graphics2D graphics, Rectangle displayArea) {
        this.activeLayers.remove(layerId);
    }

    public List orderedLabels() {
        ArrayList al = this.getActiveLabels();
        Collections.sort(al);
        Collections.reverse(al);
        return al;
    }

    private ArrayList getActiveLabels() {
        Collection c = this.labelCache.values();
        ArrayList<LabelCacheItem> al = new ArrayList<LabelCacheItem>();
        for (LabelCacheItem item : c) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        for (LabelCacheItem item : this.labelCacheNonGrouped) {
            if (!this.isActive(item.getLayerIds())) continue;
            al.add(item);
        }
        return al;
    }

    private boolean isActive(Set layerIds) {
        for (String string : layerIds) {
            if (!this.enabledLayers.contains(string)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Graphics2D graphics, Rectangle displayArea) {
        Object antialiasing = graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object textAntialiasing = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            if (this.outlineRenderingEnabled && antialiasing == RenderingHints.VALUE_ANTIALIAS_OFF && textAntialiasing == RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.paintLabels(graphics, displayArea);
        }
        finally {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintLabels(Graphics2D graphics, Rectangle displayArea) {
        if (!this.activeLayers.isEmpty()) {
            throw new IllegalStateException(this.activeLayers + " are layers that started rendering but have not completed," + " stop() or endLayer() must be called before end() is called");
        }
        ArrayList<Rectangle> glyphs = new ArrayList<Rectangle>();
        displayArea = new Rectangle(displayArea);
        --displayArea.width;
        --displayArea.height;
        GeometryFactory factory = new GeometryFactory();
        Geometry displayGeom = factory.toGeometry(new Envelope(displayArea.getMinX(), displayArea.getMaxX(), displayArea.getMinY(), displayArea.getMaxY()));
        List items = this.needsOrdering ? this.orderedLabels() : this.getActiveLabels();
        Iterator labelIter = items.iterator();
        while (labelIter.hasNext()) {
            if (this.stop) {
                return;
            }
            try {
                LabelCacheItem labelItem = (LabelCacheItem)labelIter.next();
                labelItem.getTextStyle().setLabel(labelItem.getLabel());
                GlyphVector glyphVector = labelItem.getTextStyle().getTextGlyphVector(graphics);
                Geometry geom = labelItem.getGeometry();
                AffineTransform oldTransform = graphics.getTransform();
                AffineTransform tempTransform = new AffineTransform();
                Geometry representativeGeom = null;
                if (geom instanceof Point || geom instanceof MultiPoint) {
                    representativeGeom = this.paintPointLabel(glyphVector, labelItem, tempTransform, displayGeom);
                } else if (geom instanceof LineString && !(geom instanceof LinearRing) || geom instanceof MultiLineString) {
                    representativeGeom = this.paintLineLabel(glyphVector, labelItem, tempTransform, displayGeom);
                } else if (geom instanceof Polygon || geom instanceof MultiPolygon || geom instanceof LinearRing) {
                    representativeGeom = this.paintPolygonLabel(glyphVector, labelItem, tempTransform, displayGeom);
                }
                Rectangle glyphBounds = glyphVector.getPixelBounds(null, 0.0f, 0.0f);
                glyphBounds = tempTransform.createTransformedShape(glyphBounds).getBounds();
                if (!displayArea.contains(glyphBounds)) continue;
                RectangularShape shieldBounds = null;
                if (labelItem.getTextStyle().getGraphic() != null) {
                    Rectangle area = labelItem.getTextStyle().getGraphicDimensions();
                    Rectangle untransformedBounds = glyphVector.getPixelBounds(new FontRenderContext(new AffineTransform(), true, false), 0.0f, 0.0f);
                    double[] shieldVerts = new double[]{-area.width / 2 + untransformedBounds.x - untransformedBounds.width / 2, -area.height / 2 + untransformedBounds.y - untransformedBounds.height / 2, area.width / 2, area.height / 2};
                    tempTransform.transform(shieldVerts, 0, shieldVerts, 0, 2);
                    shieldBounds = new Rectangle2D.Double(shieldVerts[0] + (double)(glyphBounds.width / 2), shieldVerts[1] + (double)(glyphBounds.height / 2), shieldVerts[2] - shieldVerts[0], shieldVerts[3] - shieldVerts[1]);
                    if (!displayArea.contains((Rectangle2D)shieldBounds)) continue;
                }
                int space = labelItem.getSpaceAround();
                int haloRadius = Math.round(labelItem.getTextStyle().getHaloFill() != null ? labelItem.getTextStyle().getHaloRadius() : 0.0f);
                if (space >= 0 && (this.overlappingItems(glyphBounds, glyphs, space + haloRadius) || shieldBounds != null && this.overlappingItems(shieldBounds.getBounds(), glyphs, space)) || this.goodnessOfFit(glyphVector, tempTransform, representativeGeom) < this.MIN_GOODNESS_FIT) continue;
                try {
                    AffineTransform newTransform = new AffineTransform(oldTransform);
                    newTransform.concatenate(tempTransform);
                    graphics.setTransform(newTransform);
                    if (labelItem.getTextStyle().getGraphic() != null) {
                        LiteShape2 tempShape = new LiteShape2((Geometry)new GeometryFactory().createPoint(new Coordinate((double)glyphBounds.width / 2.0, -1.0 * (double)glyphBounds.height / 2.0)), null, null, false, false);
                        labelItem.getTextStyle().getGraphic().setMinMaxScale(0.0, 10.0);
                        new StyledShapePainter(this).paint(graphics, tempShape, labelItem.getTextStyle().getGraphic(), 5.0);
                        graphics.setTransform(tempTransform);
                    }
                    Shape outline = glyphVector.getOutline();
                    if (labelItem.getTextStyle().getHaloFill() != null) {
                        graphics.setPaint(labelItem.getTextStyle().getHaloFill());
                        graphics.setComposite(labelItem.getTextStyle().getHaloComposite());
                        graphics.setStroke(new BasicStroke(2.0f * (float)haloRadius, 1, 1));
                        graphics.draw(outline);
                    }
                    Paint fill = labelItem.getTextStyle().getFill();
                    Composite comp = labelItem.getTextStyle().getComposite();
                    if (fill == null) {
                        fill = Color.BLACK;
                        comp = AlphaComposite.getInstance(3, 1.0f);
                    }
                    if (fill == null) continue;
                    graphics.setPaint(fill);
                    graphics.setComposite(comp);
                    if (this.outlineRenderingEnabled) {
                        graphics.fill(outline);
                    } else {
                        graphics.drawGlyphVector(glyphVector, 0.0f, 0.0f);
                    }
                    Rectangle bounds = glyphVector.getPixelBounds(new FontRenderContext(tempTransform, true, false), 0.0f, 0.0f);
                    int extraSpace = labelItem.getSpaceAround();
                    if (extraSpace < 0) continue;
                    bounds = new Rectangle(bounds.x - extraSpace, bounds.y - extraSpace, bounds.width + extraSpace, bounds.height + extraSpace);
                    if (shieldBounds != null) {
                        bounds.add((Rectangle2D)shieldBounds);
                    }
                    bounds.grow(haloRadius, haloRadius);
                    glyphs.add(bounds);
                }
                finally {
                    graphics.setTransform(oldTransform);
                }
            }
            catch (Exception e) {}
        }
    }

    private double goodnessOfFit(GlyphVector glyphVector, AffineTransform tempTransform, Geometry representativeGeom) {
        if (representativeGeom instanceof Point) {
            return 1.0;
        }
        if (representativeGeom instanceof LineString) {
            return 1.0;
        }
        if (representativeGeom instanceof Polygon) {
            Rectangle glyphBounds = glyphVector.getPixelBounds(new FontRenderContext(tempTransform, true, false), 0.0f, 0.0f);
            try {
                Polygon p = this.simplifyPoly((Polygon)representativeGeom);
                int count = 0;
                int n = 10;
                double mindistance = glyphBounds.height;
                for (int t = 1; t < n + 1; ++t) {
                    Coordinate c = new Coordinate((double)glyphBounds.x + (double)glyphBounds.width * ((double)t / (double)(n + 1)), glyphBounds.getCenterY());
                    Point pp = new Point(c, representativeGeom.getPrecisionModel(), representativeGeom.getSRID());
                    if (!(p.distance(pp) < mindistance)) continue;
                    ++count;
                }
                return (double)count / (double)n;
            }
            catch (Exception e) {
                representativeGeom.geometryChanged();
                Envelope ePoly = representativeGeom.getEnvelopeInternal();
                Envelope eglyph = new Envelope(glyphBounds.x, glyphBounds.x + glyphBounds.width, glyphBounds.y, glyphBounds.y + glyphBounds.height);
                Envelope inter = this.intersection(ePoly, eglyph);
                if (inter != null) {
                    return inter.getWidth() * inter.getHeight() / (eglyph.getWidth() * eglyph.getHeight());
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    private Polygon simplifyPoly(Polygon polygon) {
        if (polygon.getNumInteriorRing() == 0) {
            return polygon;
        }
        LineString outer = polygon.getExteriorRing();
        if (outer.getStartPoint().distance(outer.getEndPoint()) != 0.0) {
            ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(outer.getCoordinates()));
            clist.add(outer.getStartPoint().getCoordinate());
            outer = outer.getFactory().createLinearRing(clist.toArray(new Coordinate[clist.size()]));
        }
        LinearRing r = (LinearRing)outer;
        return outer.getFactory().createPolygon(r, null);
    }

    private boolean overlappingItems(Rectangle bounds, List glyphs, int extraSpace) {
        bounds = new Rectangle(bounds.x - extraSpace, bounds.y - extraSpace, bounds.width + extraSpace, bounds.height + extraSpace);
        for (Rectangle oldBounds : glyphs) {
            if (!oldBounds.intersects(bounds)) continue;
            return true;
        }
        return false;
    }

    private Geometry paintLineLabel(GlyphVector glyphVector, LabelCacheItem labelItem, AffineTransform tempTransform, Geometry displayGeom) {
        LineString line = this.getLineSetRepresentativeLocation(labelItem.getGeoms(), displayGeom);
        if (line == null) {
            return null;
        }
        TextStyle2D textStyle = labelItem.getTextStyle();
        this.paintLineStringLabel(glyphVector, line, textStyle, tempTransform);
        return line;
    }

    private void paintLineStringLabel(GlyphVector glyphVector, LineString line, TextStyle2D textStyle, AffineTransform tempTransform) {
        double rotation;
        Rectangle2D textBounds = glyphVector.getVisualBounds();
        Point centroid = this.middleLine(line, 0.5);
        tempTransform.translate(centroid.getX(), centroid.getY());
        double displacementX = 0.0;
        double displacementY = 0.0;
        double anchorX = textStyle.getAnchorX();
        double anchorY = textStyle.getAnchorY();
        if (textStyle.isPointPlacement()) {
            rotation = textStyle.getRotation();
        } else {
            rotation = this.middleTheta(line, 0.5);
            displacementY -= (double)textStyle.getPerpendicularOffset();
            anchorX = 0.5;
            anchorY = 0.5;
        }
        displacementX = anchorX * -textBounds.getWidth() + textStyle.getDisplacementX();
        displacementY += anchorY * textBounds.getHeight() - textStyle.getDisplacementY();
        if (rotation != rotation) {
            rotation = 0.0;
        }
        if (Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
    }

    private Geometry paintPointLabel(GlyphVector glyphVector, LabelCacheItem labelItem, AffineTransform tempTransform, Geometry displayGeom) {
        double rotation;
        Point point = this.getPointSetRepresentativeLocation(labelItem.getGeoms(), displayGeom);
        if (point == null) {
            return null;
        }
        TextStyle2D textStyle = labelItem.getTextStyle();
        Rectangle2D textBounds = glyphVector.getVisualBounds();
        tempTransform.translate(point.getX(), point.getY());
        double displacementX = 0.0;
        double displacementY = 0.0;
        displacementX = textStyle.getAnchorX() * -textBounds.getWidth() + textStyle.getDisplacementX();
        displacementY = textStyle.getAnchorY() * textBounds.getHeight() - textStyle.getDisplacementY();
        if (!textStyle.isPointPlacement()) {
            displacementY -= (double)textStyle.getPerpendicularOffset();
        }
        if ((rotation = textStyle.getRotation()) != rotation) {
            rotation = 0.0;
        }
        if (Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
        return point;
    }

    private Geometry paintPolygonLabel(GlyphVector glyphVector, LabelCacheItem labelItem, AffineTransform tempTransform, Geometry displayGeom) {
        double rotation;
        Point centroid;
        Polygon geom = this.getPolySetRepresentativeLocation(labelItem.getGeoms(), displayGeom);
        if (geom == null) {
            return null;
        }
        try {
            centroid = geom.getCentroid();
        }
        catch (Exception e) {
            try {
                centroid = geom.getExteriorRing().getCentroid();
            }
            catch (Exception ee) {
                try {
                    centroid = geom.getFactory().createPoint(geom.getCoordinate());
                }
                catch (Exception eee) {
                    return null;
                }
            }
        }
        TextStyle2D textStyle = labelItem.getTextStyle();
        Rectangle2D textBounds = glyphVector.getVisualBounds();
        tempTransform.translate(centroid.getX(), centroid.getY());
        double displacementX = 0.0;
        double displacementY = 0.0;
        displacementX = textStyle.getAnchorX() * -textBounds.getWidth() + textStyle.getDisplacementX();
        displacementY = textStyle.getAnchorY() * textBounds.getHeight() - textStyle.getDisplacementY();
        if (!textStyle.isPointPlacement()) {
            displacementY -= (double)textStyle.getPerpendicularOffset();
        }
        if ((rotation = textStyle.getRotation()) != rotation) {
            rotation = 0.0;
        }
        if (Double.isInfinite(rotation)) {
            rotation = 0.0;
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
        return geom;
    }

    Point getPointSetRepresentativeLocation(List geoms, Geometry displayGeometry) {
        ArrayList<Geometry> pts = new ArrayList<Geometry>();
        for (Geometry g : geoms) {
            if (!(g instanceof Point) && !(g instanceof MultiPoint)) {
                g = g.getCentroid();
            }
            if (g instanceof Point) {
                if (!displayGeometry.intersects(g)) continue;
                pts.add(g);
                continue;
            }
            if (!(g instanceof MultiPoint)) continue;
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Point gg = (Point)g.getGeometryN(t);
                if (!displayGeometry.intersects(gg)) continue;
                pts.add(gg);
            }
        }
        if (pts.size() == 0) {
            return null;
        }
        return (Point)pts.get(0);
    }

    LineString getLineSetRepresentativeLocation(List geoms, Geometry displayGeometry) {
        ArrayList<Geometry> lines = new ArrayList<Geometry>();
        for (Geometry g : geoms) {
            if (!(g instanceof LineString) && !(g instanceof MultiLineString) && !(g instanceof Polygon) && !(g instanceof MultiPolygon)) continue;
            if (g instanceof Polygon || g instanceof MultiPolygon) {
                if ((g = g.getBoundary()) instanceof LineString || g instanceof MultiLineString) continue;
                continue;
            }
            if (g instanceof LineString) {
                if (g.getLength() == 0.0) continue;
                lines.add(g);
                continue;
            }
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                LineString gg = (LineString)g.getGeometryN(t);
                lines.add(gg);
            }
        }
        if (lines.size() == 0) {
            return null;
        }
        Collection merged = this.mergeLines(lines);
        ArrayList<Geometry> clippedLines = new ArrayList<Geometry>();
        Iterator it = merged.iterator();
        Envelope displayGeomEnv = displayGeometry.getEnvelopeInternal();
        while (it.hasNext()) {
            LineString l = (LineString)it.next();
            MultiLineString ll = this.clipLineString(l, (Polygon)displayGeometry, displayGeomEnv);
            if (ll == null || ll.isEmpty()) continue;
            for (int t = 0; t < ll.getNumGeometries(); ++t) {
                clippedLines.add(ll.getGeometryN(t));
            }
        }
        if (clippedLines.size() == 0) {
            return null;
        }
        double maxLen = -1.0;
        LineString maxLine = null;
        for (int t = 0; t < clippedLines.size(); ++t) {
            LineString cline = (LineString)clippedLines.get(t);
            if (!(cline.getLength() > maxLen)) continue;
            maxLine = cline;
            maxLen = cline.getLength();
        }
        return maxLine;
    }

    public MultiLineString clipLineString(LineString line, Polygon bbox, Envelope displayGeomEnv) {
        Geometry clip = line;
        line.geometryChanged();
        if (displayGeomEnv.contains(line.getEnvelopeInternal())) {
            LineString[] lns = new LineString[]{clip};
            return line.getFactory().createMultiLineString(lns);
        }
        try {
            Decimator d = new Decimator(10.0, 10.0);
            d.decimate(line);
            line.geometryChanged();
            clip = EnhancedPrecisionOp.intersection(line, bbox);
        }
        catch (Exception e) {
            clip = line;
        }
        if (clip instanceof MultiLineString) {
            return (MultiLineString)clip;
        }
        if (clip instanceof LineString) {
            LineString[] lns = new LineString[]{clip};
            return line.getFactory().createMultiLineString(lns);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Geometry> lns = new ArrayList<Geometry>();
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry g = gc.getGeometryN(t);
            if (!(g instanceof LineString)) continue;
            lns.add(g);
        }
        if (lns.size() == 0) {
            return null;
        }
        return line.getFactory().createMultiLineString(lns.toArray(new LineString[1]));
    }

    Polygon getPolySetRepresentativeLocation(List geoms, Geometry displayGeometry) {
        ArrayList<Geometry> polys = new ArrayList<Geometry>();
        for (Geometry g : geoms) {
            if (!(g instanceof Polygon) && !(g instanceof MultiPolygon)) continue;
            if (g instanceof Polygon) {
                polys.add(g);
                continue;
            }
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Polygon gg = (Polygon)g.getGeometryN(t);
                polys.add(gg);
            }
        }
        if (polys.size() == 0) {
            return null;
        }
        ArrayList<Geometry> clippedPolys = new ArrayList<Geometry>();
        Iterator it = polys.iterator();
        Envelope displayGeomEnv = displayGeometry.getEnvelopeInternal();
        while (it.hasNext()) {
            Polygon p = (Polygon)it.next();
            MultiPolygon pp = this.clipPolygon(p, (Polygon)displayGeometry, displayGeomEnv);
            if (pp == null || pp.isEmpty()) continue;
            for (int t = 0; t < pp.getNumGeometries(); ++t) {
                clippedPolys.add(pp.getGeometryN(t));
            }
        }
        if (clippedPolys.size() == 0) {
            return null;
        }
        if (clippedPolys.size() == 1) {
            return (Polygon)clippedPolys.get(0);
        }
        double maxSize = -1.0;
        Polygon maxPoly = null;
        for (int t = 0; t < clippedPolys.size(); ++t) {
            Polygon cpoly = (Polygon)clippedPolys.get(t);
            if (!(cpoly.getArea() > maxSize)) continue;
            maxPoly = cpoly;
            maxSize = cpoly.getArea();
        }
        return maxPoly;
    }

    public MultiPolygon clipPolygon(Polygon poly, Polygon bbox, Envelope displayGeomEnv) {
        Geometry clip = poly;
        poly.geometryChanged();
        if (displayGeomEnv.contains(poly.getEnvelopeInternal())) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        try {
            Decimator d = new Decimator(10.0, 10.0);
            d.decimate(poly);
            poly.geometryChanged();
            clip = EnhancedPrecisionOp.intersection(poly, bbox);
        }
        catch (Exception e) {
            clip = poly;
        }
        if (clip instanceof MultiPolygon) {
            return (MultiPolygon)clip;
        }
        if (clip instanceof Polygon) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        if (clip instanceof LineString) {
            return null;
        }
        if (clip instanceof MultiLineString) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Geometry> plys = new ArrayList<Geometry>();
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry g = gc.getGeometryN(t);
            if (!(g instanceof Polygon)) continue;
            plys.add(g);
        }
        if (plys.size() == 0) {
            return null;
        }
        return poly.getFactory().createMultiPolygon(plys.toArray(new Polygon[1]));
    }

    double middleTheta(LineString l, double percent) {
        if (percent >= 1.0) {
            percent = 0.99;
        }
        if (percent <= 0.0) {
            percent = 0.01;
        }
        double len = l.getLength();
        double dist = percent * len;
        double running_sum_dist = 0.0;
        CoordinateSequence pts = l.getCoordinateSequence();
        int length = pts.size();
        Coordinate curr = new Coordinate();
        Coordinate next = new Coordinate();
        for (int i = 0; i < length - 1; ++i) {
            pts.getCoordinate(i, curr);
            pts.getCoordinate(i + 1, next);
            double segmentLen = curr.distance(next);
            if (running_sum_dist + segmentLen >= dist) {
                double dx = next.x - curr.x;
                double dy = next.y - curr.y;
                double slope = dy / dx;
                return Math.atan(slope);
            }
            running_sum_dist += segmentLen;
        }
        return 0.0;
    }

    Point middleLine(LineString l, double percent) {
        if (percent >= 1.0) {
            percent = 0.99;
        }
        if (percent <= 0.0) {
            percent = 0.01;
        }
        double len = l.getLength();
        double dist = percent * len;
        double running_sum_dist = 0.0;
        Coordinate[] pts = l.getCoordinates();
        int length = pts.length;
        for (int i = 0; i < length - 1; ++i) {
            double segmentLen = pts[i].distance(pts[i + 1]);
            if (running_sum_dist + segmentLen >= dist) {
                double r = (dist - running_sum_dist) / segmentLen;
                Coordinate c = new Coordinate(pts[i].x + (pts[i + 1].x - pts[i].x) * r, pts[i].y + (pts[i + 1].y - pts[i].y) * r);
                return l.getFactory().createPoint(c);
            }
            running_sum_dist += segmentLen;
        }
        return l.getEndPoint();
    }

    Collection mergeLines(Collection lines) {
        LineMerger lm = new LineMerger();
        lm.add(lines);
        Collection merged = lm.getMergedLineStrings();
        if (merged.size() == 0) {
            return null;
        }
        if (merged.size() == 1) {
            return merged;
        }
        Hashtable nodes = new Hashtable(merged.size() * 2);
        for (LineString ls : merged) {
            this.putInNodeHash(ls, nodes);
        }
        ArrayList result = new ArrayList();
        ArrayList merged_list = new ArrayList(merged);
        Collections.sort(merged_list, this.lineLengthComparator);
        this.processNodes(merged_list, nodes, result);
        return result;
    }

    public void processNodes(List edges, Hashtable nodes, ArrayList result) {
        int index = 0;
        while (index < edges.size()) {
            LineString ls2;
            LineString ls = (LineString)edges.get(index);
            Coordinate key = ls.getCoordinateN(0);
            ArrayList nodeList = (ArrayList)nodes.get(key);
            if (nodeList == null) {
                ++index;
                continue;
            }
            if (!nodeList.contains(ls)) {
                ++index;
                continue;
            }
            this.removeFromHash(nodes, ls);
            Coordinate key2 = ls.getCoordinateN(ls.getNumPoints() - 1);
            ArrayList nodeList2 = (ArrayList)nodes.get(key2);
            if (nodeList.size() == 0 && nodeList2.size() == 0) {
                result.add(ls);
                ++index;
                continue;
            }
            if (nodeList.size() > 0) {
                ls2 = this.getLongest(nodeList);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            if (nodeList2.size() > 0) {
                ls2 = this.getLongest(nodeList2);
                ls = this.merge(ls, ls2);
                this.removeFromHash(nodes, ls2);
            }
            edges.set(index, ls);
            this.putInNodeHash(ls, nodes);
        }
    }

    public void removeFromHash(Hashtable nodes, LineString ls) {
        Coordinate key = ls.getCoordinateN(0);
        ArrayList nodeList = (ArrayList)nodes.get(key);
        if (nodeList != null) {
            nodeList.remove(ls);
        }
        if ((nodeList = (ArrayList)nodes.get(key = ls.getCoordinateN(ls.getNumPoints() - 1))) != null) {
            nodeList.remove(ls);
        }
    }

    public LineString getLongest(ArrayList al) {
        if (al.size() == 1) {
            return (LineString)al.get(0);
        }
        double maxLength = -1.0;
        LineString result = null;
        int size = al.size();
        for (int t = 0; t < size; ++t) {
            LineString l = (LineString)al.get(t);
            if (!(l.getLength() > maxLength)) continue;
            result = l;
            maxLength = l.getLength();
        }
        return result;
    }

    public void putInNodeHash(LineString ls, Hashtable nodes) {
        Coordinate key = ls.getCoordinateN(0);
        ArrayList<LineString> nodeList = (ArrayList<LineString>)nodes.get(key);
        if (nodeList == null) {
            nodeList = new ArrayList<LineString>();
            nodeList.add(ls);
            nodes.put(key, nodeList);
        } else {
            nodeList.add(ls);
        }
        key = ls.getCoordinateN(ls.getNumPoints() - 1);
        nodeList = (ArrayList<LineString>)nodes.get(key);
        if (nodeList == null) {
            nodeList = new ArrayList<LineString>();
            nodeList.add(ls);
            nodes.put(key, nodeList);
        } else {
            nodeList.add(ls);
        }
    }

    Collection mergeLines2(Collection lines) {
        LineMerger lm = new LineMerger();
        lm.add(lines);
        Collection merged = lm.getMergedLineStrings();
        if (merged.size() == 0) {
            return null;
        }
        if (merged.size() == 1) {
            return merged;
        }
        ArrayList mylines = new ArrayList(merged);
        boolean keep_going = true;
        while (keep_going) {
            keep_going = false;
            Collections.sort(mylines, this.lineLengthComparator);
            int size = mylines.size();
            for (int t = 0; t < size; ++t) {
                LineString major = (LineString)mylines.get(t);
                if (major == null) continue;
                for (int i = t + 1; i < mylines.size(); ++i) {
                    LineString merge;
                    LineString minor = (LineString)mylines.get(i);
                    if (minor == null || (merge = this.merge(major, minor)) == null) continue;
                    keep_going = true;
                    mylines.set(i, null);
                    mylines.set(t, merge);
                    major = merge;
                }
            }
            mylines = this.removeNulls(mylines);
        }
        return this.removeNulls(mylines);
    }

    ArrayList removeNulls(List l) {
        ArrayList al = new ArrayList();
        for (Object o : l) {
            if (o == null) continue;
            al.add(o);
        }
        return al;
    }

    LineString reverse(LineString l) {
        List<Coordinate> clist = Arrays.asList(l.getCoordinates());
        Collections.reverse(clist);
        return l.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    LineString merge(LineString major, LineString minor) {
        Coordinate major_s = major.getCoordinateN(0);
        Coordinate major_e = major.getCoordinateN(major.getNumPoints() - 1);
        Coordinate minor_s = minor.getCoordinateN(0);
        Coordinate minor_e = minor.getCoordinateN(minor.getNumPoints() - 1);
        if (major_s.equals2D(minor_s)) {
            return this.mergeSimple(this.reverse(minor), major);
        }
        if (major_s.equals2D(minor_e)) {
            return this.mergeSimple(minor, major);
        }
        if (major_e.equals2D(minor_s)) {
            return this.mergeSimple(major, minor);
        }
        if (major_e.equals2D(minor_e)) {
            return this.mergeSimple(major, this.reverse(minor));
        }
        return null;
    }

    private LineString mergeSimple(LineString l1, LineString l2) {
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(l1.getCoordinates()));
        clist.addAll(Arrays.asList(l2.getCoordinates()));
        return l1.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private Envelope intersection(Envelope e1, Envelope e2) {
        Envelope r = e1.intersection(e2);
        if (r.getWidth() < 0.0) {
            return null;
        }
        if (r.getHeight() < 0.0) {
            return null;
        }
        return r;
    }

    public void enableLayer(String layerId) {
        this.needsOrdering = true;
        this.enabledLayers.add(layerId);
    }

    public boolean isOutlineRenderingEnabled() {
        return this.outlineRenderingEnabled;
    }

    public void setOutlineRenderingEnabled(boolean outlineRenderingEnabled) {
        this.outlineRenderingEnabled = outlineRenderingEnabled;
    }

    private final class LineLengthComparator
    implements Comparator {
        private LineLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Double.compare(((LineString)o2).getLength(), ((LineString)o1).getLength());
        }
    }
}

