/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.math.BigInteger;
import java.util.AbstractList;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1D;
import org.geotools.referencing.piecewise.DefaultPiecewiseTransform1DElement;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapTransform;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapTransformElement;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapUtilities;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMapElement;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinearColorMap
extends AbstractList<LinearColorMapElement>
implements ColorMapTransform<LinearColorMapElement> {
    private IndexColorModel colorModel;
    private final LinearColorMapElement[] standardElements;
    private final LinearColorMapElement[] preFilteringElements;
    private final Color defaultColor;
    private DefaultPiecewiseTransform1D<LinearColorMapElement> piecewise;
    private DefaultPiecewiseTransform1D<LinearColorMapElement> preFilteringPiecewise;
    private Color preFilteringColor;
    private InternationalString name;
    private int hashCode = -1;

    public LinearColorMap(CharSequence name, LinearColorMapElement[] standardElements) {
        this(name, standardElements, null);
    }

    public LinearColorMap(CharSequence name, LinearColorMapElement[] standardElements, Color defColor) {
        this(name, standardElements, null, defColor);
    }

    public LinearColorMap(CharSequence name, LinearColorMapElement[] standardElements, LinearColorMapElement[] preFilteringElements, Color defaultColor) {
        ColorMapUtilities.ensureNonNull("name", name);
        ColorMapUtilities.ensureNonNull("standardElements", standardElements);
        this.name = SimpleInternationalString.wrap((CharSequence)name);
        LinearColorMap.preliminarChecks(standardElements, preFilteringElements);
        if (preFilteringElements != null) {
            Color color;
            this.preFilteringElements = (LinearColorMapElement[])preFilteringElements.clone();
            this.preFilteringColor = color = this.preFilteringElements[0].getColors()[0];
        } else {
            this.preFilteringElements = null;
        }
        this.standardElements = (LinearColorMapElement[])standardElements.clone();
        this.defaultColor = defaultColor;
    }

    public LinearColorMap(String string, LinearColorMapElement[] linearColorMapElements, LinearColorMapElement[] linearColorMapElements2) {
        this(string, linearColorMapElements, linearColorMapElements2, null);
    }

    private static void preliminarChecks(LinearColorMapElement[] domainElements, LinearColorMapElement[] domainElementsToPreserve) {
        ColorMapUtilities.checkPreservingElements(domainElementsToPreserve);
        int num = domainElementsToPreserve != null ? domainElements.length + domainElementsToPreserve.length : domainElements.length;
        for (int i = 0; i < num; ++i) {
            LinearColorMapElement c0 = i >= domainElements.length ? domainElementsToPreserve[i - domainElements.length] : domainElements[i];
            ColorMapTransformElement v0 = c0;
            NumberRange<? extends Number> outRange0 = c0.getOutputRange();
            Color[] colors0 = v0.getColors();
            int minimum0 = (int)outRange0.getMinimum();
            int maximum0 = (int)outRange0.getMaximum();
            for (int j = 0; j < num; ++j) {
                if (j == i) continue;
                LinearColorMapElement c1 = j >= domainElements.length ? domainElementsToPreserve[j - domainElements.length] : domainElements[j];
                ColorMapTransformElement v1 = c1;
                NumberRange<? extends Number> outRange1 = c1.getOutputRange();
                if (!outRange1.intersects(outRange0) || !outRange0.intersects(outRange1)) continue;
                int minimum1 = (int)outRange1.getMinimum();
                int maximum1 = (int)outRange1.getMaximum();
                Color[] colors1 = v1.getColors();
                if (minimum1 == maximum0 && colors0[colors0.length - 1].equals(colors1[0]) || minimum0 == maximum1 && colors1[colors1.length - 1].equals(colors0[0])) continue;
                throw new IllegalArgumentException(Errors.format(10, c0, c1));
            }
        }
    }

    @Override
    public IndexColorModel getColorModel() {
        this.initColorModel();
        return this.colorModel;
    }

    private synchronized void initColorModel() {
        if (this.colorModel == null) {
            boolean defaultColorFound;
            BigInteger bits = new BigInteger("0");
            boolean preFilteringValuesPresent = this.preFilteringColor != null;
            int elementsCount = this.standardElements.length + (preFilteringValuesPresent ? 1 : 0);
            int max = -1;
            for (int i = 0; i < elementsCount; ++i) {
                LinearColorMapElement element = i < this.standardElements.length ? this.standardElements[i] : this.preFilteringElements[0];
                int elementMin = (int)element.getOutputMinimum();
                int elementMax = (int)element.getOutputMaximum();
                for (int k = elementMin; k <= elementMax; ++k) {
                    bits = bits.setBit(k);
                }
                max = Math.max(max, elementMax);
            }
            int[] ARGB = new int[++max];
            int outMax = 0;
            int outMin = 0;
            for (int i = 0; i < elementsCount; ++i) {
                LinearColorMapElement element = i < this.standardElements.length ? this.standardElements[i] : this.preFilteringElements[0];
                outMin = (int)element.getOutputMinimum();
                outMax = (int)element.getOutputMaximum();
                ColorUtilities.expand((Color[])element.getColors(), (int[])ARGB, (int)outMin, (int)(outMax + 1));
            }
            this.preFilteringPiecewise = this.preFilteringElements == null ? null : new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.preFilteringElements);
            boolean lookForDefaultColor = this.defaultColor != null;
            boolean bl = defaultColorFound = !lookForDefaultColor;
            if (lookForDefaultColor) {
                int i;
                int defaultColorIndex = -1;
                for (i = 0; i < ARGB.length; ++i) {
                    if (!lookForDefaultColor || defaultColorIndex != -1 || !bits.testBit(i) || ARGB[i] != this.defaultColor.getRGB()) continue;
                    defaultColorIndex = i;
                    defaultColorFound = true;
                    break;
                }
                if (defaultColorFound) {
                    this.piecewise = new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.standardElements, (double)defaultColorIndex);
                } else {
                    for (i = 0; i < max && bits.testBit(i); ++i) {
                    }
                    if (i == max) {
                        max = i == max ? max++ : max;
                        bits = bits.setBit(i);
                        int[] tempARGB = new int[max];
                        System.arraycopy(ARGB, 0, tempARGB, 0, ARGB.length);
                        tempARGB[tempARGB.length - 1] = this.defaultColor.getRGB();
                        ARGB = tempARGB;
                    }
                    this.piecewise = new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.standardElements, (double)max);
                }
            } else {
                this.piecewise = new DefaultPiecewiseTransform1D((DefaultPiecewiseTransform1DElement[])this.standardElements);
            }
            this.colorModel = new IndexColorModel(ColorUtilities.getBitCount((int)max), max, ARGB, 0, ColorUtilities.getTransferType((int)max), bits);
        }
    }

    @Override
    public SampleModel getSampleModel(int width, int height) {
        this.initColorModel();
        return new PixelInterleavedSampleModel(this.colorModel.getTransferType(), width, height, 1, width, new int[1]);
    }

    @Override
    public LinearColorMapElement get(int index) {
        return this.standardElements[index];
    }

    @Override
    public int size() {
        return this.preFilteringElements.length + this.standardElements.length;
    }

    @Override
    public double getDefaultValue() {
        this.initColorModel();
        return this.piecewise.getDefaultValue();
    }

    @Override
    public boolean hasDefaultValue() {
        this.initColorModel();
        return this.piecewise.hasDefaultValue();
    }

    @Override
    public NumberRange<?> getApproximateDomainRange() {
        this.initColorModel();
        return this.piecewise.getApproximateDomainRange();
    }

    @Override
    public LinearColorMapElement findDomainElement(double sample) {
        this.initColorModel();
        boolean prefiltering = this.preFilteringElements != null;
        LinearColorMapElement retValue = null;
        if (prefiltering) {
            retValue = (LinearColorMapElement)this.preFilteringPiecewise.findDomainElement(sample);
        }
        if (retValue == null) {
            retValue = (LinearColorMapElement)this.piecewise.findDomainElement(sample);
        }
        return retValue;
    }

    public LinearColorMapElement[] getDomainElements() {
        return (LinearColorMapElement[])this.standardElements.clone();
    }

    @Override
    public InternationalString getName() {
        this.initColorModel();
        return this.name;
    }

    @Override
    public boolean hasGaps() {
        this.initColorModel();
        return this.piecewise.hasGaps();
    }

    public double derivative(double value) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "derivate"));
    }

    public double transform(double value) throws TransformException {
        this.initColorModel();
        LinearColorMapElement transform = this.findDomainElement(value);
        if (transform != null) {
            return transform.transform(value);
        }
        return this.preFilteringPiecewise.transform(value);
    }

    public Matrix derivative(DirectPosition point) throws MismatchedDimensionException, TransformException {
        ColorMapUtilities.checkDimension(point);
        return new Matrix1(this.derivative(point.getOrdinate(0)));
    }

    public int getSourceDimensions() {
        return 1;
    }

    public int getTargetDimensions() {
        return 1;
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public boolean isIdentity() {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws MismatchedDimensionException, TransformException {
        ColorMapUtilities.ensureNonNull("ptSrc", ptSrc);
        ColorMapUtilities.checkDimension(ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            ColorMapUtilities.checkDimension(ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        throw new UnsupportedOperationException(Errors.format(15, "transform"));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LinearColorMap)) {
            return false;
        }
        LinearColorMap that = (LinearColorMap)o;
        if (!Utilities.equals((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Utilities.equals((Object)this.defaultColor, (Object)that.defaultColor)) {
            return false;
        }
        if (this.preFilteringColor != that.preFilteringColor) {
            return false;
        }
        if (!Utilities.equals((Object)this.preFilteringElements, (Object)that.preFilteringElements)) {
            return false;
        }
        if (!Utilities.equals((Object)this.standardElements, (Object)that.standardElements)) {
            return false;
        }
        return this.piecewise.equals(that.piecewise);
    }

    @Override
    public int hashCode() {
        if (this.hashCode >= 0) {
            return this.hashCode;
        }
        this.hashCode = 37;
        this.hashCode = Utilities.hash((Object)this.name, (int)this.hashCode);
        this.hashCode = Utilities.hash((Object)this.defaultColor, (int)this.hashCode);
        this.hashCode = Utilities.hash((Object)this.preFilteringColor, (int)this.hashCode);
        this.hashCode = Utilities.hash((Object)this.preFilteringElements, (int)this.hashCode);
        this.hashCode = Utilities.hash((Object)this.standardElements, (int)this.hashCode);
        this.hashCode = Utilities.hash(this.piecewise, (int)this.hashCode);
        return this.hashCode;
    }

    public static final class LinearColorMapType {
        public static final int TYPE_RAMP = 1;
        public static final int TYPE_VALUES = 3;
        public static final int TYPE_INTERVALS = 2;

        public static boolean validateColorMapTye(int linearColorMapType) {
            switch (linearColorMapType) {
                case 1: 
                case 2: 
                case 3: {
                    return true;
                }
            }
            return false;
        }
    }
}

