/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal;

import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverageio.BaseGridCoverage2DReader;
import org.geotools.data.DataSourceException;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class BaseGDALGridCoverage2DReader
extends BaseGridCoverage2DReader
implements GridCoverageReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio.gdal");

    protected BaseGDALGridCoverage2DReader(Object input, Hints hints, String worldFileExtension, ImageReaderSpi formatSpecificSpi) throws DataSourceException {
        super(input, hints, worldFileExtension, formatSpecificSpi);
    }

    protected void setCoverageProperties(ImageReader reader) throws IOException {
        IIOMetadata metadata = reader.getImageMetadata(0);
        if (!(metadata instanceof GDALCommonIIOImageMetadata)) {
            throw new DataSourceException("Unexpected error! Metadata should be an instance of the expected class: GDALCommonIIOImageMetadata.");
        }
        this.getPropertiesFromCommonMetadata((GDALCommonIIOImageMetadata)metadata);
        if (this.getCoverageCRS() == null) {
            this.parsePRJFile();
        }
        if (this.getCoverageCRS() == null) {
            LOGGER.info("crs not found, proceeding with EPSG:4326");
            this.setCoverageCRS(AbstractGridFormat.getDefaultCRS());
        }
        if (this.getCoverageEnvelope() == null) {
            this.parseWorldFile();
            if (this.getCoverageEnvelope() == null) {
                throw new DataSourceException("Unavailable envelope for this coverage");
            }
        }
        this.getCoverageEnvelope().setCoordinateReferenceSystem(this.getCoverageCRS());
        this.originalEnvelope = this.getCoverageEnvelope();
        this.originalGridRange = this.getCoverageGridRange();
        this.crs = this.getCoverageCRS();
    }

    private void getPropertiesFromCommonMetadata(GDALCommonIIOImageMetadata metadata) {
        double[] geoTransform;
        String wkt;
        if (this.getCoverageCRS() == null && (wkt = metadata.getProjection()) != null && !wkt.equalsIgnoreCase("")) {
            try {
                this.setCoverageCRS(CRS.parseWKT((String)wkt));
                Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)this.getCoverageCRS(), (boolean)true);
                if (epsgCode != null) {
                    this.setCoverageCRS(CRS.decode((String)("EPSG:" + epsgCode)));
                }
            }
            catch (FactoryException fe) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to get CRS from WKT contained in metadata. Looking for a PRJ.");
                }
                this.setCoverageCRS(null);
            }
        }
        if (this.getCoverageGridRange() == null) {
            this.setCoverageGridRange(new GeneralGridRange(new Rectangle(0, 0, metadata.getWidth(), metadata.getHeight())));
        }
        if ((geoTransform = metadata.getGeoTransformation()) != null && geoTransform.length == 6) {
            AffineTransform tempTransform;
            block12: {
                tempTransform = new AffineTransform(geoTransform[1], geoTransform[4], geoTransform[2], geoTransform[5], geoTransform[0], geoTransform[3]);
                if (this.getCoverageEnvelope() == null) {
                    try {
                        this.setCoverageEnvelope(CRS.transform((MathTransform)ProjectiveTransform.create((AffineTransform)tempTransform), (Envelope)new GeneralEnvelope((Rectangle2D)this.getCoverageGridRange().toRectangle())));
                    }
                    catch (IllegalStateException e) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                    catch (TransformException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block12;
                        LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
            }
            double tr = -PixelTranslation.getPixelTranslation((PixelInCell)PixelInCell.CELL_CORNER);
            tempTransform.translate(tr, tr);
            this.raster2Model = ProjectiveTransform.create((AffineTransform)tempTransform);
        }
    }
}

