/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceInfoImpl
implements ResourceInfo {
    String id;
    String name;
    String nativeName;
    List<String> alias = new ArrayList<String>();
    NamespaceInfo namespace;
    String title;
    String description;
    String _abstract;
    List<String> keywords = new ArrayList<String>();
    List<MetadataLinkInfo> metadataLinks = new ArrayList<MetadataLinkInfo>();
    CoordinateReferenceSystem nativeCRS;
    String srs;
    ReferencedEnvelope nativeBoundingBox;
    ReferencedEnvelope latLonBoundingBox;
    ProjectionPolicy projectionPolicy;
    boolean enabled;
    Map metadata = new HashMap();
    StoreInfo store;
    Catalog catalog;

    protected ResourceInfoImpl(Catalog catalog) {
        this.catalog = catalog;
    }

    protected ResourceInfoImpl(Catalog catalog, String id) {
        this(catalog);
        this.setId(id);
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNativeName() {
        return this.nativeName;
    }

    @Override
    public void setNativeName(String nativeName) {
        this.nativeName = nativeName;
    }

    @Override
    public NamespaceInfo getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(NamespaceInfo namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getPrefixedName() {
        return this.getNamespace().getPrefix() + ":" + this.getName();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getAbstract() {
        return this._abstract;
    }

    @Override
    public void setAbstract(String _abstract) {
        this._abstract = _abstract;
    }

    @Override
    public List<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public List<MetadataLinkInfo> getMetadataLinks() {
        return this.metadataLinks;
    }

    public void setMetadataLinks(List<MetadataLinkInfo> metadataLinks) {
        this.metadataLinks = metadataLinks;
    }

    @Override
    public String getSRS() {
        return this.srs;
    }

    @Override
    public void setSRS(String srs) {
        this.srs = srs;
    }

    @Override
    public ReferencedEnvelope getBoundingBox() throws Exception {
        CoordinateReferenceSystem declaredCRS = this.getCRS();
        CoordinateReferenceSystem nativeCRS = this.getNativeCRS();
        ProjectionPolicy php = this.getProjectionPolicy();
        if (this.nativeBoundingBox == null) {
            return null;
        }
        if (!CRS.equalsIgnoreMetadata((Object)declaredCRS, (Object)nativeCRS) && php == ProjectionPolicy.REPROJECT_TO_DECLARED) {
            return this.nativeBoundingBox.transform(declaredCRS, true);
        }
        if (php == ProjectionPolicy.FORCE_DECLARED) {
            return new ReferencedEnvelope((Envelope)this.nativeBoundingBox, declaredCRS);
        }
        return this.nativeBoundingBox;
    }

    @Override
    public ReferencedEnvelope getLatLonBoundingBox() {
        return this.latLonBoundingBox;
    }

    @Override
    public void setLatLonBoundingBox(ReferencedEnvelope box) {
        this.latLonBoundingBox = box;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metaData) {
        this.metadata = metaData;
    }

    @Override
    public StoreInfo getStore() {
        return this.store;
    }

    @Override
    public void setStore(StoreInfo store) {
        this.store = store;
    }

    public Object getAdapter(Class adapterClass, Map hints) {
        return null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public List<String> getAlias() {
        return this.alias;
    }

    @Override
    public CoordinateReferenceSystem getCRS() throws Exception {
        if (this.getSRS() == null) {
            return null;
        }
        return CRS.decode((String)this.getSRS());
    }

    @Override
    public ReferencedEnvelope getNativeBoundingBox() {
        return this.nativeBoundingBox;
    }

    @Override
    public void setNativeBoundingBox(ReferencedEnvelope box) {
        this.nativeBoundingBox = box;
    }

    @Override
    public CoordinateReferenceSystem getNativeCRS() {
        return this.nativeCRS;
    }

    @Override
    public void setNativeCRS(CoordinateReferenceSystem nativeCRS) {
        this.nativeCRS = nativeCRS;
    }

    @Override
    public ProjectionPolicy getProjectionPolicy() {
        return this.projectionPolicy;
    }

    @Override
    public void setProjectionPolicy(ProjectionPolicy projectionPolicy) {
        this.projectionPolicy = projectionPolicy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._abstract == null ? 0 : this._abstract.hashCode());
        result = 31 * result + (this.alias == null ? 0 : ((Object)this.alias).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.keywords == null ? 0 : ((Object)this.keywords).hashCode());
        result = 31 * result + (this.latLonBoundingBox == null ? 0 : this.latLonBoundingBox.hashCode());
        result = 31 * result + (this.metadataLinks == null ? 0 : ((Object)this.metadataLinks).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.nativeBoundingBox == null ? 0 : this.nativeBoundingBox.hashCode());
        result = 31 * result + (this.nativeCRS == null ? 0 : this.nativeCRS.hashCode());
        result = 31 * result + (this.nativeName == null ? 0 : this.nativeName.hashCode());
        result = 31 * result + (this.projectionPolicy == null ? 0 : this.projectionPolicy.hashCode());
        result = 31 * result + (this.srs == null ? 0 : this.srs.hashCode());
        result = 31 * result + (this.store == null ? 0 : this.store.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceInfo)) {
            return false;
        }
        ResourceInfo other = (ResourceInfo)obj;
        if (this._abstract == null ? other.getAbstract() != null : !this._abstract.equals(other.getAbstract())) {
            return false;
        }
        if (this.alias == null ? other.getAlias() != null : !((Object)this.alias).equals(other.getAlias())) {
            return false;
        }
        if (this.description == null ? other.getDescription() != null : !this.description.equals(other.getDescription())) {
            return false;
        }
        if (this.enabled != other.isEnabled()) {
            return false;
        }
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        if (this.keywords == null ? other.getKeywords() != null : !((Object)this.keywords).equals(other.getKeywords())) {
            return false;
        }
        if (this.latLonBoundingBox == null ? other.getLatLonBoundingBox() != null : !this.latLonBoundingBox.equals((Object)other.getLatLonBoundingBox())) {
            return false;
        }
        if (this.metadataLinks == null ? other.getMetadataLinks() != null : !((Object)this.metadataLinks).equals(other.getMetadataLinks())) {
            return false;
        }
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        if (this.namespace == null ? other.getNamespace() != null : !((Object)this.namespace).equals(other.getNamespace())) {
            return false;
        }
        if (this.nativeBoundingBox == null ? other.getNativeBoundingBox() != null : !this.nativeBoundingBox.equals((Object)other.getNativeBoundingBox())) {
            return false;
        }
        if (this.nativeCRS == null ? other.getNativeCRS() != null : CRS.equalsIgnoreMetadata((Object)this.nativeCRS, (Object)other.getNativeCRS())) {
            return false;
        }
        if (this.nativeName == null ? other.getNativeName() != null : !this.nativeName.equals(other.getNativeName())) {
            return false;
        }
        if (this.projectionPolicy == null ? other.getProjectionPolicy() != null : !this.projectionPolicy.equals((Object)other.getProjectionPolicy())) {
            return false;
        }
        if (this.srs == null ? other.getSRS() != null : !this.srs.equals(other.getSRS())) {
            return false;
        }
        if (this.store == null ? other.getStore() != null : !this.store.equals(other.getStore())) {
            return false;
        }
        return !(this.title == null ? other.getTitle() != null : !this.title.equals(other.getTitle()));
    }
}

