/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;

public class DisabledServiceCheck
implements DispatcherCallback {
    public Request init(Request request) {
        return request;
    }

    public Service serviceDispatched(Request request, Service service) {
        Object s = service.getService();
        Method m = null;
        if (s instanceof Proxy) {
            Class<?>[] interfaces = s.getClass().getInterfaces();
            for (int i = 0; m == null && i < interfaces.length; ++i) {
                m = OwsUtils.getter(interfaces[i], (String)"serviceInfo", ServiceInfo.class);
            }
        } else {
            m = OwsUtils.getter(s.getClass(), (String)"serviceInfo", ServiceInfo.class);
        }
        if (m != null) {
            try {
                ServiceInfo info = (ServiceInfo)m.invoke(s, null);
                if (!info.isEnabled()) {
                    throw new ServiceException("Service " + info.getName() + " is disabled");
                }
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return service;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return response;
    }

    public void finished(Request request) {
    }
}

