/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.Serializable;
import org.opengis.feature.type.AttributeDescriptor;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;

public class AttributeTypeInfo {
    org.geoserver.catalog.AttributeTypeInfo attributeType;

    public AttributeTypeInfo(org.geoserver.catalog.AttributeTypeInfo attributeType) {
        this.attributeType = attributeType;
    }

    public void load(AttributeTypeInfoDTO dto) {
        this.attributeType.setName(dto.getName());
        this.attributeType.setMinOccurs(dto.getMinOccurs());
        this.attributeType.setMaxOccurs(dto.getMaxOccurs());
        this.attributeType.setNillable(dto.isNillable());
    }

    public String getName() {
        return this.attributeType.getName();
    }

    public AttributeDescriptor getAttributeType() {
        return this.attributeType.getAttribute();
    }

    public void sync(AttributeDescriptor type) {
        this.attributeType.setAttribute(type);
    }

    public String getType() {
        if (this.attributeType != null && this.attributeType.getAttribute() != null && this.attributeType.getAttribute().getType() != null && this.attributeType.getAttribute().getType().getBinding() != null) {
            return this.attributeType.getAttribute().getType().getBinding().getSimpleName();
        }
        return "unknown";
    }

    public boolean containsMetaData(String key) {
        return this.attributeType.getMetadata().get(key) != null;
    }

    public void putMetaData(String key, Object value) {
        this.attributeType.getMetadata().put(key, (Serializable)value);
    }

    public Object getMetaData(String key) {
        return this.attributeType.getMetadata().get(key);
    }

    Object toDTO() {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setName(this.attributeType.getName());
        dto.setMinOccurs(this.attributeType.getMinOccurs());
        dto.setMaxOccurs(this.attributeType.getMaxOccurs());
        dto.setNillable(this.attributeType.isNillable());
        dto.setType(this.getType());
        return dto;
    }

    public int getMaxOccurs() {
        return this.attributeType.getMaxOccurs();
    }

    public int getMinOccurs() {
        return this.attributeType.getMinOccurs();
    }

    public boolean isNillable() {
        return this.attributeType.isNillable();
    }

    public String toString() {
        return "[AttributeTypeInfo backed by " + this.toDTO() + " with type " + this.attributeType.getAttribute() + " and meta " + this.attributeType.getMetadata();
    }
}

