/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geotools.data.FeatureSource;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;
import org.vfny.geoserver.global.AttributeTypeInfo;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.LegendURL;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureTypeInfo
extends GlobalLayerSupertype {
    public static int FORCE = ProjectionPolicy.FORCE_DECLARED.getCode();
    public static int REPROJECT = ProjectionPolicy.REPROJECT_TO_DECLARED.getCode();
    public static int LEAVE = ProjectionPolicy.NONE.getCode();
    LayerInfo layer;
    Catalog catalog;
    org.geoserver.catalog.FeatureTypeInfo featureType;

    public FeatureTypeInfo(LayerInfo layer, Catalog catalog) {
        this.layer = layer;
        this.catalog = catalog;
        this.featureType = layer != null ? (org.geoserver.catalog.FeatureTypeInfo)layer.getResource() : new DummyFeatureTypeInfo();
    }

    public void load(FeatureTypeInfoDTO dto) throws Exception {
        this.featureType.setAbstract(dto.getAbstract());
        org.geoserver.catalog.DataStoreInfo ds = this.catalog.getDataStoreByName(dto.getDataStoreId());
        this.featureType.setStore(ds);
        this.layer.setDefaultStyle(this.catalog.getStyleByName(dto.getDefaultStyle()));
        this.layer.getStyles().clear();
        for (String styleName : dto.getStyles()) {
            this.layer.getStyles().add(this.catalog.getStyleByName(styleName));
        }
        if (dto.getLegendURL() != null) {
            LegendInfo l = this.catalog.getFactory().createLegend();
            new LegendURL(l).load(dto.getLegendURL());
            this.layer.setLegend(l);
        }
        this.featureType.setFilter(dto.getDefinitionQuery());
        this.featureType.getMetadata().put("dirName", (Serializable)((Object)dto.getDirName()));
        this.featureType.getKeywords().clear();
        this.featureType.getKeywords().addAll(dto.getKeywords());
        this.featureType.getMetadataLinks().clear();
        for (MetaDataLink link : dto.getMetadataLinks()) {
            MetadataLinkInfo ml = this.catalog.getFactory().createMetadataLink();
            new MetaDataLink(ml).load(link);
            this.featureType.getMetadataLinks().add(ml);
        }
        this.setSRS(dto.getSRS());
        this.featureType.setLatLonBoundingBox(new ReferencedEnvelope(dto.getLatLongBBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.featureType.setNativeName(dto.getName());
        if (dto.getAlias() != null) {
            this.featureType.setName(dto.getAlias());
        } else {
            this.featureType.setName(dto.getName());
        }
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(ds.getWorkspace().getName());
        this.featureType.setNamespace(ns);
        this.layer.setName(this.featureType.getName());
        this.layer.setPath(dto.getWmsPath());
        this.layer.setType(LayerInfo.Type.VECTOR);
        this.featureType.setNumDecimals(dto.getNumDecimals());
        this.featureType.getAttributes().clear();
        SimpleFeatureType ft = ds.getDataStore(null).getSchema(this.featureType.getNativeName());
        if (dto.getSchemaAttributes() != null) {
            for (AttributeTypeInfoDTO adto : dto.getSchemaAttributes()) {
                org.geoserver.catalog.AttributeTypeInfo ati = this.catalog.getFactory().createAttribute();
                new AttributeTypeInfo(ati).load(adto);
                this.featureType.getAttributes().add(ati);
            }
        } else {
            for (int x = 0; x < ft.getAttributeCount(); ++x) {
                AttributeDescriptor ad = ft.getDescriptor(x);
                org.geoserver.catalog.AttributeTypeInfo att = this.catalog.getFactory().createAttribute();
                att.setName(ad.getLocalName());
                att.setMinOccurs(ad.getMinOccurs());
                att.setMaxOccurs(ad.getMaxOccurs());
                att.setAttribute(ad);
                this.featureType.getAttributes().add(att);
            }
        }
        this.setSchemaBase(dto.getSchemaBase());
        this.setSchemaName(dto.getSchemaName());
        this.setSchemaFile(dto.getSchemaFile());
        this.featureType.setProjectionPolicy(ProjectionPolicy.get(dto.getSRSHandling()));
        this.featureType.setNativeCRS(ft.getCoordinateReferenceSystem());
        if (dto.getNativeBBox() != null) {
            this.featureType.setNativeBoundingBox(new ReferencedEnvelope(dto.getNativeBBox(), ft.getCoordinateReferenceSystem()));
        }
        this.setCacheMaxAge(dto.getCacheMaxAge());
        this.setCachingEnabled(dto.isCachingEnabled());
        this.setIndexingEnabled(dto.isIndexingEnabled());
        this.setRegionateAttribute(dto.getRegionateAttribute());
        this.setRegionateStrategy(dto.getRegionateStrategy());
        this.setRegionateFeatureLimit(dto.getRegionateFeatureLimit());
        this.setNameTemplate(dto.getNameTemplate());
        this.featureType.setMaxFeatures(dto.getMaxFeatures());
        this.featureType.setTitle(dto.getTitle());
        this.featureType.setEnabled(ds.isEnabled());
    }

    @Override
    public Object toDTO() {
        Envelope e;
        FeatureTypeInfoDTO dto = new FeatureTypeInfoDTO();
        dto.setAbstract(this.getAbstract());
        dto.setDataStoreId(this.getDataStoreInfo().getId());
        if (this.getDefaultStyle() != null) {
            dto.setDefaultStyle(this.getDefaultStyle().getName());
        }
        ArrayList<String> styles = new ArrayList<String>();
        for (Style style : this.getStyles()) {
            styles.add(style.getName());
        }
        dto.setStyles(styles);
        if (this.getLegendURL() != null) {
            dto.setLegendURL(this.getLegendURL().toDTO());
        }
        dto.setDefinitionQuery(this.getDefinitionQuery());
        dto.setDirName(this.getDirName());
        dto.setKeywords(this.getKeywords());
        dto.setMetadataLinks(this.getMetadataLinks());
        try {
            dto.setLatLongBBox((Envelope)this.getLatLongBoundingBox());
            dto.setNativeBBox((Envelope)this.featureType.getNativeBoundingBox());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (dto.getLatLongBBox() == null) {
            e = new Envelope();
            e.setToNull();
            dto.setLatLongBBox(e);
        }
        if (dto.getNativeBBox() == null) {
            e = new Envelope();
            e.setToNull();
            dto.setNativeBBox(e);
        }
        dto.setName(this.getNativeTypeName());
        if (!this.featureType.getName().equals(this.featureType.getNativeName())) {
            dto.setAlias(this.featureType.getName());
        }
        dto.setWmsPath(this.getWmsPath());
        dto.setNumDecimals(this.getNumDecimals());
        LinkedList<Object> tmp = new LinkedList<Object>();
        for (AttributeTypeInfo att : this.getAttributes()) {
            tmp.add(att.toDTO());
        }
        dto.setSchemaAttributes(tmp);
        dto.setSchemaBase(this.getSchemaBase());
        if (this.getSchemaName() != null) {
            dto.setSchemaName(this.getSchemaName());
        } else {
            dto.setSchemaName(this.getTypeName() + "_Type");
        }
        dto.setSRS(Integer.parseInt(this.getSRS()));
        dto.setSRSHandling(this.getSrsHandling());
        dto.setTitle(this.getTitle());
        dto.setMaxFeatures(this.getMaxFeatures());
        dto.setCacheMaxAge(this.getCacheMaxAge());
        dto.setCachingEnabled(this.isCachingEnabled());
        dto.setIndexingEnabled(this.isIndexingEnabled());
        dto.setRegionateAttribute(this.getRegionateAttribute());
        dto.setRegionateStrategy(this.getRegionateStrategy());
        dto.setRegionateFeatureLimit(this.getRegionateFeatureLimit());
        dto.setNameTemplate(this.getNameTemplate());
        return dto;
    }

    public int getNumDecimals() {
        return this.featureType.getNumDecimals();
    }

    public DataStoreInfo getDataStoreInfo() {
        return new DataStoreInfo(this.featureType.getStore(), this.catalog);
    }

    public Style getDefaultStyle() {
        StyleInfo style = this.layer.getDefaultStyle();
        try {
            return style != null ? style.getStyle() : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayList getStyles() {
        ArrayList<Style> realStyles = new ArrayList<Style>();
        for (StyleInfo si : this.layer.getStyles()) {
            try {
                realStyles.add(si.getStyle());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return realStyles;
    }

    public List<String> getStyleNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StyleInfo si : this.layer.getStyles()) {
            result.add(si.getName());
        }
        return result;
    }

    public boolean isEnabled() {
        return this.featureType.isEnabled() && this.featureType.getStore().isEnabled();
    }

    public String getPrefix() {
        return this.featureType.getNamespace().getPrefix();
    }

    public NameSpaceInfo getNameSpace() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("This featureType is not enabled");
        }
        return new NameSpaceInfo(this.featureType.getNamespace(), this.catalog);
    }

    public String getName() {
        return this.featureType.getPrefixedName();
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource() throws IOException {
        return this.getFeatureSource(false);
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(boolean skipReproject) throws IOException {
        if (!this.isEnabled() || this.getDataStoreInfo().getDataStore() == null) {
            throw new IOException("featureType: " + this.getName() + " does not have a properly configured " + "datastore");
        }
        Hints hints = new Hints((RenderingHints.Key)ResourcePool.REPROJECT, (Object)(!skipReproject ? 1 : 0));
        try {
            return this.featureType.getFeatureSource(null, hints);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public ReferencedEnvelope getBoundingBox() throws IOException {
        try {
            return this.featureType.getBoundingBox();
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public Filter getDefinitionQuery() {
        return this.featureType.getFilter();
    }

    public ReferencedEnvelope getLatLongBoundingBox() throws IOException {
        return this.featureType.getLatLonBoundingBox();
    }

    public String getSRS() {
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)this.featureType.getSRS());
            return CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true).toString();
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSRS(int srs) {
        this.featureType.setSRS("EPSG:" + srs);
    }

    public CoordinateReferenceSystem getDeclaredCRS() {
        try {
            return this.featureType.getCRS();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CoordinateReferenceSystem getNativeCRS() throws IOException {
        return this.featureType.getNativeCRS();
    }

    public boolean isGeometryless() throws IOException {
        try {
            return this.featureType.getFeatureType().getGeometryDescriptor() == null;
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String getAbstract() {
        return this.featureType.getAbstract();
    }

    public List getKeywords() {
        return this.featureType.getKeywords();
    }

    public List getMetadataLinks() {
        ArrayList<MetaDataLink> links = new ArrayList<MetaDataLink>(this.featureType.getMetadataLinks().size());
        for (MetadataLinkInfo link : this.featureType.getMetadataLinks()) {
            links.add(new MetaDataLink(link));
        }
        return links;
    }

    public String getTitle() {
        return this.featureType.getTitle();
    }

    public String getSchemaName() {
        String schemaName = (String)((Object)this.featureType.getMetadata().get("gml.schemaName"));
        if (schemaName == null) {
            return this.getTypeName() + "_Type";
        }
        return schemaName;
    }

    public void setSchemaName(String string) {
        this.featureType.getMetadata().put("gml.schemaSchema", (Serializable)((Object)string));
    }

    public String getSchemaBase() {
        return (String)((Object)this.featureType.getMetadata().get("gml.schemaBase"));
    }

    public void setSchemaBase(String string) {
        this.featureType.getMetadata().put("gml.schemaBase", (Serializable)((Object)string));
    }

    public String getTypeName() {
        return this.featureType.getName();
    }

    public String getNativeTypeName() {
        return this.featureType.getNativeName();
    }

    public SimpleFeatureType getFeatureType() throws IOException {
        try {
            return this.featureType.getFeatureType();
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public DataStoreInfo getDataStoreMetaData() {
        return new DataStoreInfo(this.featureType.getStore(), this.catalog);
    }

    public List getAttributeNames() {
        List attribs = this.getAttributes();
        if (attribs.size() != 0) {
            ArrayList<String> list = new ArrayList<String>(attribs.size());
            for (AttributeTypeInfo at : attribs) {
                list.add(at.getName());
            }
            return list;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            SimpleFeatureType ftype = this.getFeatureType();
            List types = ftype.getAttributeDescriptors();
            list = new ArrayList(types.size());
            for (int i = 0; i < types.size(); ++i) {
                list.add(((AttributeDescriptor)types.get(i)).getLocalName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public List getAttributes() {
        ArrayList<AttributeTypeInfo> schema = new ArrayList<AttributeTypeInfo>();
        for (org.geoserver.catalog.AttributeTypeInfo att : this.featureType.getAttributes()) {
            schema.add(new AttributeTypeInfo(att));
        }
        return schema;
    }

    public boolean containsMetaData(String key) {
        return this.featureType.getMetadata().get(key) != null;
    }

    public void putMetaData(String key, Object value) {
        this.featureType.getMetadata().put(key, (Serializable)value);
    }

    public Object getMetaData(String key) {
        return this.featureType.getMetadata().get(key);
    }

    public LegendURL getLegendURL() {
        return this.layer.getLegend() != null ? new LegendURL(this.layer.getLegend()) : null;
    }

    public File getSchemaFile() {
        return (File)this.featureType.getMetadata().get("gml.schemaFile");
    }

    public void setSchemaFile(File file) {
        this.featureType.getMetadata().put("gml.schemaFile", file);
    }

    public String getDirName() {
        return (String)((Object)this.featureType.getMetadata().get("dirName"));
    }

    public String getWmsPath() {
        return this.layer.getPath();
    }

    public void setWmsPath(String wmsPath) {
        this.layer.setPath(wmsPath);
    }

    public String getCacheMaxAge() {
        return (String)((Object)this.featureType.getMetadata().get("cacheAgeMax"));
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.featureType.getMetadata().put("cacheAgeMax", (Serializable)((Object)cacheMaxAge));
    }

    public boolean isCachingEnabled() {
        Boolean cachingEnabled = (Boolean)this.featureType.getMetadata().get("cachingEnabled");
        return cachingEnabled != null ? cachingEnabled : false;
    }

    public boolean isIndexingEnabled() {
        Boolean indexingEnabled = (Boolean)this.featureType.getMetadata().get("indexingEnabled");
        return indexingEnabled != null ? indexingEnabled : false;
    }

    public String getRegionateAttribute() {
        return (String)((Object)this.featureType.getMetadata().get("kml.regionateAttribute"));
    }

    public String getRegionateStrategy() {
        return (String)((Object)this.featureType.getMetadata().get("kml.regionateStrategy"));
    }

    public int getRegionateFeatureLimit() {
        Integer regionateFeatureLimit = (Integer)this.featureType.getMetadata().get("kml.regionateFeatureLimit");
        return regionateFeatureLimit != null ? regionateFeatureLimit : -1;
    }

    public String getNameTemplate() {
        return (String)((Object)this.featureType.getMetadata().get("template.name"));
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.featureType.getMetadata().put("cachingEnabled", Boolean.valueOf(cachingEnabled));
    }

    public void setIndexingEnabled(boolean indexingEnabled) {
        this.featureType.getMetadata().put("indexingEnabled", Boolean.valueOf(indexingEnabled));
    }

    public void setRegionateAttribute(String attr) {
        this.featureType.getMetadata().put("kml.regionateAttribute", (Serializable)((Object)attr));
    }

    public void setRegionateStrategy(String strategy) {
        this.featureType.getMetadata().put("kml.regionateStrategy", (Serializable)((Object)strategy));
    }

    public void setRegionateFeatureLimit(int limit) {
        this.featureType.getMetadata().put("kml.regionateFeatureLimit", Integer.valueOf(limit));
    }

    public void setNameTemplate(String name) {
        this.featureType.getMetadata().put("template.name", (Serializable)((Object)name));
    }

    public int getMaxFeatures() {
        return this.featureType.getMaxFeatures();
    }

    public void setMaxFeatures(int maxFeatures) {
        this.featureType.setMaxFeatures(maxFeatures);
    }

    public int getSrsHandling() {
        ProjectionPolicy policy = this.featureType.getProjectionPolicy();
        if (policy != null) {
            return policy.getCode();
        }
        return ProjectionPolicy.FORCE_DECLARED.getCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyFeatureTypeInfo
    implements org.geoserver.catalog.FeatureTypeInfo {
        private DummyFeatureTypeInfo() {
        }

        @Override
        public List<org.geoserver.catalog.AttributeTypeInfo> getAttributes() {
            return null;
        }

        @Override
        public FeatureSource getFeatureSource(ProgressListener listener, Hints hints) throws IOException {
            return null;
        }

        @Override
        public SimpleFeatureType getFeatureType() throws IOException {
            return null;
        }

        @Override
        public Filter getFilter() {
            return null;
        }

        @Override
        public int getMaxFeatures() {
            return 0;
        }

        @Override
        public int getNumDecimals() {
            return 0;
        }

        @Override
        public org.geoserver.catalog.DataStoreInfo getStore() {
            return null;
        }

        @Override
        public void setFilter(Filter filter) {
        }

        @Override
        public void setMaxFeatures(int maxFeatures) {
        }

        @Override
        public void setNumDecimals(int numDecimals) {
        }

        @Override
        public String getAbstract() {
            return null;
        }

        @Override
        public <T> T getAdapter(Class<T> adapterClass, Map<?, ?> hints) {
            return null;
        }

        @Override
        public List<String> getAlias() {
            return null;
        }

        @Override
        public ReferencedEnvelope getBoundingBox() throws Exception {
            return null;
        }

        @Override
        public CoordinateReferenceSystem getCRS() throws Exception {
            return null;
        }

        @Override
        public Catalog getCatalog() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public List<String> getKeywords() {
            return null;
        }

        @Override
        public ReferencedEnvelope getLatLonBoundingBox() {
            return null;
        }

        @Override
        public Map<String, Serializable> getMetadata() {
            return Collections.EMPTY_MAP;
        }

        @Override
        public List<MetadataLinkInfo> getMetadataLinks() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public NamespaceInfo getNamespace() {
            return null;
        }

        @Override
        public ReferencedEnvelope getNativeBoundingBox() {
            return null;
        }

        @Override
        public CoordinateReferenceSystem getNativeCRS() {
            return null;
        }

        @Override
        public String getNativeName() {
            return null;
        }

        @Override
        public String getPrefixedName() {
            return null;
        }

        @Override
        public ProjectionPolicy getProjectionPolicy() {
            return null;
        }

        @Override
        public String getSRS() {
            return null;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void setAbstract(String _abstract) {
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public void setLatLonBoundingBox(ReferencedEnvelope box) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setNamespace(NamespaceInfo namespace) {
        }

        @Override
        public void setNativeBoundingBox(ReferencedEnvelope box) {
        }

        @Override
        public void setNativeCRS(CoordinateReferenceSystem nativeCRS) {
        }

        @Override
        public void setNativeName(String nativeName) {
        }

        @Override
        public void setProjectionPolicy(ProjectionPolicy policy) {
        }

        @Override
        public void setSRS(String srs) {
        }

        @Override
        public void setStore(StoreInfo store) {
        }

        @Override
        public void setTitle(String title) {
        }
    }
}

