/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;

public class NameSpaceInfo
extends GlobalLayerSupertype {
    NamespaceInfo namespace;
    Catalog catalog;

    public NameSpaceInfo(NamespaceInfo namespace, Catalog catalog) {
        this.namespace = namespace;
        this.catalog = catalog;
    }

    public void load(NameSpaceInfoDTO dto) {
        this.setPrefix(dto.getPrefix());
        this.setUri(dto.getUri());
    }

    Object toDTO() {
        NameSpaceInfoDTO dto = new NameSpaceInfoDTO();
        dto.setDefault(this.isDefault());
        dto.setPrefix(this.getPrefix());
        dto.setUri(this.getUri());
        return dto;
    }

    public Object clone() {
        return new NameSpaceInfo(this.namespace, this.catalog);
    }

    public boolean equals(Object obj) {
        NameSpaceInfo ns = (NameSpaceInfo)obj;
        return this.getPrefix() == ns.getPrefix() && this.getUri() == ns.getUri() && this.isDefault() == ns.isDefault();
    }

    public boolean isDefault() {
        return ((Object)this.namespace).equals(this.catalog.getDefaultNamespace());
    }

    public String getPrefix() {
        return this.namespace.getPrefix();
    }

    public String getUri() {
        return this.namespace.getURI();
    }

    public String getURI() {
        return this.namespace.getURI();
    }

    public void setDefault(boolean b) {
        if (b) {
            this.catalog.setDefaultNamespace(this.namespace);
        } else if (((Object)this.namespace).equals(this.catalog.getDefaultNamespace())) {
            this.catalog.setDefaultNamespace(null);
        }
    }

    public void setPrefix(String string) {
        this.namespace.setPrefix(string);
    }

    public void setUri(String string) {
        this.namespace.setURI(string);
    }

    public boolean containsMetaData(String key) {
        return this.namespace.getMetadata().get(key) != null;
    }

    public void putMetaData(String key, Object value) {
        this.namespace.getMetadata().put(key, (Serializable)value);
    }

    public Object getMetaData(String key) {
        return this.namespace.getMetadata().get(key);
    }

    public Set getTypeNames() {
        HashSet<String> set = new HashSet<String>();
        List<org.geoserver.catalog.FeatureTypeInfo> resources = this.catalog.getResourcesByNamespace(this.namespace, org.geoserver.catalog.FeatureTypeInfo.class);
        for (org.geoserver.catalog.FeatureTypeInfo ft : resources) {
            set.add(ft.getPrefixedName());
        }
        return set;
    }

    public FeatureTypeInfo getFeatureTypeInfo(String typeName) {
        org.geoserver.catalog.FeatureTypeInfo ft = this.catalog.getResourceByName(this.namespace.getURI(), typeName, org.geoserver.catalog.FeatureTypeInfo.class);
        if (ft == null) {
            return null;
        }
        for (LayerInfo layer : this.catalog.getLayers()) {
            if (!ft.equals(layer.getResource())) continue;
            return new FeatureTypeInfo(layer, this.catalog);
        }
        return null;
    }

    public String toString() {
        return this.getPrefix() + ":" + this.getUri();
    }
}

