/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Wrapper;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.OWS;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.dto.ServiceDTO;

public class Service
implements OWS {
    protected ServiceInfo service;
    protected org.geoserver.config.GeoServer gs;

    public Service(ServiceInfo service, org.geoserver.config.GeoServer gs) {
        this.service = service;
        this.gs = gs;
    }

    public void load(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException();
        }
        this.service.setEnabled(dto.isEnabled());
        this.service.setName(dto.getName());
        this.service.setTitle(dto.getTitle());
        this.service.setAbstract(dto.getAbstract());
        this.service.getKeywords().clear();
        this.service.getKeywords().addAll(dto.getKeywords());
        this.service.setFees(dto.getFees());
        this.service.setAccessConstraints(dto.getAccessConstraints());
        this.service.setOnlineResource(dto.getOnlineResource() != null ? dto.getOnlineResource().toString() : null);
        if (dto.getMetadataLink() != null) {
            this.service.setMetadataLink(dto.getMetadataLink().getMetadataLink());
        } else {
            this.service.setMetadataLink(null);
        }
        this.setStrategy(dto.getStrategy());
        this.setPartialBufferSize(dto.getPartialBufferSize());
    }

    public void setStrategy(String strategy) {
        this.service.setOutputStrategy(strategy);
    }

    public String getStrategy() {
        return this.service.getOutputStrategy();
    }

    public int getPartialBufferSize() {
        Integer i = (Integer)this.service.getMetadata().get("partialBufferSize");
        return i != null ? i : -1;
    }

    public void setPartialBufferSize(int partialBufferSize) {
        this.service.getMetadata().put("partialBufferSize", Integer.valueOf(partialBufferSize));
    }

    public Object toDTO() {
        ServiceDTO dto = new ServiceDTO();
        dto.setAccessConstraints(this.service.getAccessConstraints());
        dto.setEnabled(this.service.isEnabled());
        dto.setFees(this.service.getFees());
        dto.setKeywords(this.service.getKeywords());
        dto.setMaintainer(this.service.getMaintainer());
        dto.setName(this.service.getName());
        if (this.service.getOnlineResource() != null) {
            try {
                dto.setOnlineResource(new URL(this.service.getOnlineResource()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        dto.setAbstract(this.service.getAbstract());
        dto.setTitle(this.service.getTitle());
        dto.setMetadataLink(this.getMetadataLink());
        dto.setStrategy(this.getStrategy());
        dto.setPartialBufferSize(this.getPartialBufferSize());
        return dto;
    }

    public Data getData() {
        return new Data(this.gs);
    }

    public Data getRawData() {
        Catalog catalog = this.gs.getCatalog();
        if (catalog instanceof Wrapper && ((Wrapper)((Object)catalog)).isWrapperFor(Catalog.class)) {
            catalog = ((Wrapper)((Object)catalog)).unwrap(Catalog.class);
        }
        return new Data(this.gs, catalog);
    }

    public void setData(Data dt) {
    }

    public GeoServer getGeoServer() {
        return new GeoServer(this.gs);
    }

    public void setGeoServer(GeoServer gs) {
    }

    public MetaDataLink getMetadataLink() {
        if (this.service.getMetadataLink() != null) {
            return new MetaDataLink(this.service.getMetadataLink());
        }
        return null;
    }

    public Charset getCharSet() {
        return this.getGeoServer().getCharSet();
    }

    public String getAbstract() {
        return this.service.getAbstract();
    }

    public void setAbstract(String serverAbstract) {
    }

    public String getAccessConstraints() {
        return this.service.getAccessConstraints();
    }

    public void setAccessConstraints(String accessConstraints) {
        this.service.setAccessConstraints(accessConstraints);
    }

    public String getFees() {
        return this.service.getFees();
    }

    public void setFees(String fees) {
        this.service.setFees(fees);
    }

    public String getId() {
        return this.service.getId();
    }

    public List getKeywords() {
        return this.service.getKeywords();
    }

    public String getMaintainer() {
        return this.service.getMaintainer();
    }

    public void setMaintainer(String maintainer) {
        this.service.setMaintainer(maintainer);
    }

    public String getName() {
        return this.service.getName();
    }

    public void setName(String name) {
        this.service.setName(name);
    }

    public URL getOnlineResource() {
        try {
            return new URL(this.service.getOnlineResource());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setOnlineResource(URL onlineResource) {
        this.service.setOnlineResource(onlineResource != null ? onlineResource.toString() : null);
    }

    public String getTitle() {
        return this.service.getTitle();
    }

    public boolean isEnabled() {
        return this.service.isEnabled();
    }

    public void setTitle(String title) {
        this.service.setTitle(title);
    }

    public void setEnabled(boolean enabled) {
        this.service.setEnabled(enabled);
    }

    public String getSchemaBaseURL() {
        return this.service.getSchemaBaseURL();
    }

    public void setSchemaBaseURL(String schemaBaseURL) {
        this.service.setSchemaBaseURL(schemaBaseURL);
    }

    public boolean isVerbose() {
        return this.service.isVerbose();
    }

    public void setVerbose(boolean verbose) {
        this.service.setVerbose(verbose);
    }

    public Map getClientProperties() {
        return this.service.getClientProperties();
    }
}

