/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.ServiceDTO;

public final class WFSDTO
implements DataTransferObject {
    public static final int SERVICE_BASIC = 1;
    public static final int SERVICE_INSERT = 2;
    public static final int SERVICE_UPDATE = 4;
    public static final int SERVICE_DELETE = 8;
    public static final int SERVICE_LOCKING = 16;
    public static final int BASIC = 1;
    public static final int TRANSACTIONAL = 15;
    public static final int COMPLETE = 31;
    private ServiceDTO service;
    private boolean srsXmlStyle = true;
    private int serviceLevel = 31;
    private boolean featureBounding = true;
    private boolean citeConformanceHacks = false;

    public WFSDTO() {
    }

    public WFSDTO(WFSDTO other) {
        if (other == null) {
            throw new NullPointerException("Data Transfer Object required");
        }
        this.service = new ServiceDTO(other.getService());
        this.featureBounding = other.isFeatureBounding();
        this.serviceLevel = other.getServiceLevel();
        this.citeConformanceHacks = other.getCiteConformanceHacks();
    }

    public Object clone() {
        return new WFSDTO(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof WFSDTO)) {
            return false;
        }
        WFSDTO dto = (WFSDTO)other;
        if (this.citeConformanceHacks != dto.getCiteConformanceHacks()) {
            return false;
        }
        if (this.featureBounding != dto.isFeatureBounding()) {
            return false;
        }
        return this.serviceLevel == dto.getServiceLevel() && this.service == null ? dto.getService() == null : this.service.equals(dto.getService());
    }

    public int hashCode() {
        return this.service == null ? 0 : this.service.hashCode();
    }

    public ServiceDTO getService() {
        return this.service;
    }

    public void setService(ServiceDTO dto) {
        if (dto == null) {
            throw new NullPointerException("ServiceDTO requrired");
        }
        this.service = dto;
    }

    public boolean isSrsXmlStyle() {
        return this.srsXmlStyle;
    }

    public void setSrsXmlStyle(boolean doXmlStyle) {
        this.srsXmlStyle = doXmlStyle;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public void setCiteConformanceHacks(boolean on) {
        this.citeConformanceHacks = on;
    }

    public boolean getCiteConformanceHacks() {
        return this.citeConformanceHacks;
    }

    public boolean isFeatureBounding() {
        return this.featureBounding;
    }

    public void setFeatureBounding(boolean featureBounding) {
        this.featureBounding = featureBounding;
    }
}

