/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.net.URI;
import org.geotools.ows.ServiceException;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.XSISAXHandler;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.handlers.xsi.RootHandler;
import org.geotools.xml.schema.Schema;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class WFSSchemaFactory
extends SchemaFactory {
    protected WFSSchemaFactory() {
        is = this;
    }

    protected XSISAXHandler getSAXHandler(URI uri) {
        return new WFSXSISAXHandler(uri);
    }

    private static class ServiceExceptionReportHandler
    extends XSIElementHandler {
        private static final long serialVersionUID = "org.geotools.data.wfs.WFSSchemaFactory.ServiceExceptionReportHandler".hashCode();
        private ServiceException exception;
        private boolean inside = false;

        private ServiceExceptionReportHandler() {
        }

        public int getHandlerType() {
            return 0;
        }

        protected ServiceException getException() {
            return this.exception;
        }

        public void endElement(String namespaceURI, String localName) {
            this.inside = false;
        }

        public void startElement(String namespaceURI, String localName, Attributes attr) {
            if ("ServiceException".equalsIgnoreCase(localName)) {
                this.inside = true;
                if (attr != null) {
                    String code;
                    String locator = attr.getValue("", "locator");
                    if (locator == null) {
                        locator = attr.getValue(namespaceURI, "locator");
                    }
                    if ((code = attr.getValue("", "code")) == null) {
                        code = attr.getValue(namespaceURI, "code");
                    }
                    this.exception = new ServiceException("", code, locator);
                }
            }
        }

        public void characters(String text) {
            if (this.inside) {
                this.exception = new ServiceException(text, this.exception.getCode(), this.exception.getLocator());
            }
        }

        public XSIElementHandler getHandler(String namespaceURI, String localName) {
            if ("ServiceException".equalsIgnoreCase(localName) && FilterSchema.NAMESPACE.toString().equalsIgnoreCase(namespaceURI)) {
                return this;
            }
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int hashCode() {
            return 0;
        }
    }

    protected static class WFSRootHandler
    extends RootHandler {
        private static final long serialVersionUID = "org.geotools.data.wfs.WFSSchemaFactory.WFSRootHandler".hashCode();
        private ServiceExceptionReportHandler se = null;

        public WFSRootHandler(URI uri) {
            super(uri);
        }

        public XSIElementHandler getHandler(String namespaceURI, String localName) {
            XSIElementHandler r = null;
            r = super.getHandler(namespaceURI, localName);
            if (r != null) {
                return r;
            }
            if ("ServiceExceptionReport".equalsIgnoreCase(localName) && FilterSchema.NAMESPACE.toString().equalsIgnoreCase(namespaceURI)) {
                if (this.se == null) {
                    this.se = new ServiceExceptionReportHandler();
                }
                return this.se;
            }
            return null;
        }

        public Schema getSchema() throws SAXException {
            if (this.se != null && this.se.getException() != null) {
                throw this.se.getException();
            }
            return super.getSchema();
        }
    }

    protected static class WFSXSISAXHandler
    extends XSISAXHandler {
        public WFSXSISAXHandler(URI uri) {
            super(uri);
            this.rootHandler = new WFSRootHandler(uri);
        }
    }
}

