/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Repository;
import org.geotools.data.Transaction;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureSourceRepository
implements Repository {
    protected SortedMap<String, FeatureSource<?, ?>> featuresources = new TreeMap();

    @Override
    public SortedMap<String, FeatureSource<?, ?>> getFeatureSources() {
        return Collections.unmodifiableSortedMap(this.featuresources);
    }

    @Override
    public Set<String> getPrefixes() throws IOException {
        HashSet<String> prefix = new HashSet<String>();
        for (FeatureSource<?, ?> fs : this.featuresources.values()) {
            Object schema = fs.getSchema();
            prefix.add(schema.getName().getNamespaceURI());
        }
        return prefix;
    }

    private SortedSet<String> typeNames() throws IOException {
        TreeSet<String> typeNames = new TreeSet<String>();
        for (FeatureSource<?, ?> fs : this.featuresources.values()) {
            Object schema = fs.getSchema();
            typeNames.add(schema.getName().getLocalPart());
        }
        return typeNames;
    }

    private Map<String, DataStore> dataStores() {
        TreeMap<String, DataStore> dataStores = new TreeMap<String, DataStore>();
        for (Map.Entry<String, FeatureSource<?, ?>> entry : this.featuresources.entrySet()) {
            String key = entry.getKey();
            String dataStoreId = key.split(":")[0];
            FeatureSource<?, ?> fs = entry.getValue();
            dataStores.put(dataStoreId, (DataStore)fs.getDataStore());
        }
        return dataStores;
    }

    private SortedMap<String, SimpleFeatureType> types(DataStore ds) throws IOException {
        TreeMap<String, SimpleFeatureType> map = new TreeMap<String, SimpleFeatureType>();
        String[] typeNames = ds.getTypeNames();
        for (int i = 0; i < typeNames.length; ++i) {
            try {
                map.put(typeNames[i], ds.getSchema(typeNames[i]));
                continue;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return map;
    }

    public SortedMap<String, FeatureSource<?, ?>> types() {
        return new TreeMap(this.featuresources);
    }

    @Override
    public boolean lockExists(String lockID) {
        if (lockID == null) {
            return false;
        }
        for (DataStore store : this.dataStores().values()) {
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lockRefresh(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean refresh = false;
        for (DataStore store : this.dataStores().values()) {
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            refresh = true;
        }
        return refresh;
    }

    @Override
    public boolean lockRelease(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean release = false;
        for (DataStore store : this.dataStores().values()) {
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            release = true;
        }
        return release;
    }

    public void register(String id, FeatureSource<SimpleFeatureType, SimpleFeature> featureSource) throws IOException {
        this.featuresources.put(id + ":" + featureSource.getSchema().getTypeName(), featureSource);
    }

    public DataStore datastore(String id) {
        for (Map.Entry<String, FeatureSource<?, ?>> entry : this.featuresources.entrySet()) {
            String key = entry.getKey();
            String dataStoreId = key.split(":")[0];
            if (!id.equals(dataStoreId)) continue;
            FeatureSource<?, ?> fs = entry.getValue();
            return (DataStore)fs.getDataStore();
        }
        return null;
    }

    @Override
    public Map<String, DataStore> getDataStores() {
        return Collections.unmodifiableMap(this.dataStores());
    }

    @Override
    public FeatureSource<?, ?> source(String dataStoreId, String typeName) throws IOException {
        String typeRef = dataStoreId + ":" + typeName;
        return (FeatureSource)this.featuresources.get(typeRef);
    }
}

